var sea = sea || {};

sea.constants = (function() {
	return {
		DSTypes : {
			JDBC : "jdbc",
			WEB : "web",
			CSV : "csv",
			ELOQUA : "eloqua",
			SALESFORCE : "salesforce",
			NAS : "nas",
			FS : "file",
			LDAP : "ldap",
			FEDERATED : "federated",
			BLANK : "blank",
			HTTP : "http",
			FACEBOOK : "facebook",
			REVIEWSET : "reviewset",
			TWITTER : "twitter",
			EDGE : "edge",
			VM : "vm"
		},
		Actions : {
			NEW : "new",
			EDIT : "edit",
			VIEW : "view",
			VIEW_ALL : "view_all",
			HOME : "home",
			VIEW_SCHEMA : "schema",
			SEARCH : "search",
			SEARCH_VIEWS : "sv",
			EACH_SEARCH_VIEW : "esv",
			REPORT_VIEW : "rv",
			REST_API : "api",
			START_CRAWL : "start",
			STOP_CRAWL : "stop",
			ANALYTICS : "analytics",
			ANALYTICS_VIEW_RESULTS : "avr",
			HANDLER : "hv",
			CREATE_HANDLER : "ch",
			EDIT_HANDLER : "eh",
			EACH_HANDLER : "ehv",
			ENTITY : "ee",
			ENTITY_DETAILS : "eed",
			REDIRECT_URL : "href",
			WEBHOOK : "webhook",
			ENTITY_EXTRACTION : "e_e",
			DATA_BLENDING : "dbl"
		},
		HistoryParams : {
			CORE_NAME : "cn",
			ACTION : "action",
			DS_TYPE : "type",
			DS_ID : "id",
			DS_NAME : "dn",
			VIEW_ID : "vid",
			FULL_VIEW : "fv",
			JOB_IB : "jid",
			JOB_NAME : "jname",
			NO_REDIR : "noredir",
			HANDLER_NAME : "hn",
			HANDLER_ID : "hid",
			ENTITY_TYPE : "eetype",
			QUERY : "q",
			SUBTYPE : "subtype"
		},
		ReportInputParams : {
			DS_ID : "input.dsId",
			DS_TYPE : "input.dsType",
			HANDLER_ID : "input.handlerId",
			HANDLER_NAME : "input.handlerName",
			END_POINT : "endpoint",
			NAME : "rname"

		},
		Operations : {
			CREATE : "CREATE",
			DELETE : "DELETE",
			MODIFY : "MODIFY"
		},
		Permissions : {
			VIEW : "View",
			EDIT : "Edit",
			DELETE : "Delete",
			EXECUTE : "Execute",
			SHARE : "Share"
		},
		schemaAllowedDataTypes : {
			boolean : {
				fieldName : "boolean",
				dispName : "Boolean"
			},
			tdate : {
				fieldName : "tdate",
				dispName : "Date"
			},
			tdouble : {
				fieldName : "tdouble",
				dispName : "Double"
			},
			tfloat : {
				fieldName : "tfloat",
				dispName : "Float"
			},
			int : {
				fieldName : "int",
				dispName : "Integer"
			},
			tlong : {
				fieldName : "tlong",
				dispName : "Long"
			},
			longstring : {
				fieldName : "longstring",
				dispName : "Long String"
			},
			lowercase : {
				fieldName : "lowercase",
				dispName : "Lowercase String"
			},
			string : {
				fieldName : "string",
				dispName : "String"
			},
			text_general_rev : {
				fieldName : "text_general_rev",
				dispName : "Text"
			},
			epoch : {
				fieldName : "epoch",
				dispName : "Win32 FILETIME/Unix Timestamp"
			}
		},
		newSchemaAllowedDataTypes : {
			pdouble : {
				fieldName : "double",
				dispName : "Double"
			},
			pfloat : {
				fieldName : "float",
				dispName : "Float"
			},
			pint : {
				fieldName : "int",
				dispName : "Integer"
			},
			plong : {
				fieldName : "long",
				dispName : "Long"
			},
			string : {
				fieldName : "string",
				dispName : "String"
			},
			utcdatetime : {
				fieldName : "utcdate",
				dispName : "UTC Date/Time"
			}
		},
		LandingPage : {
			DASHBOARD : "dashboard",
			DASHBOARD_INFO_TILES : "dashboardInfoTiles"
		},
		SupportedEntitiesToExtract : {
			phone : localMsg.Phone,
			ssn : localMsg.SSN,
			ccn : localMsg.CCN,
			usdl : localMsg.USDL,
			itin : localMsg.Itin,
			ip : localMsg.IP,
			rtn : localMsg.Rtn,
			email : localMsg.Email
		},
		DATA_SOURCES : "datasources",
		COMMCELL : "Commcell",
		HANDLER : "handler",
		TMPL_PREFIX : "tmpl_",
		DS_DRIVERS_KEY_PREFIX : "jdbcdrivers",
		DS_ENGINES_KEY_PREFIX : "engines",
		DS_ALL_ENGINES_KEY_PREFIX : "all_engines"
	};
})();
/*
 * DSTypeConstants - list of all data source types
 */
sea.DSTypeConstants = (function() {

	var basePath = "dcube.do";
	var imgBasePath = "sea/img/types/";
	var enableAnalyticsEngineSelection = false;

	//changing listOfDS from Array to Object so that lookups will be faster.

	var listOfDS = {
		"federated" : {
			"statsEnabled" : false
		},
		"jdbc" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : true,
			"isEEEnabled" : true,
		},
		"web" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : true,
			"isEEEnabled" : true,
		},
		"csv" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : true,
			"isEEEnabled" : true,
		},
		"file" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : true,
			"isEEEnabled" : true
			//hiding seismic file system for now as no one is currently using it
			/*"subTypes" : {
				"archiverClient" : localMsg.archiverClient,
				"seismic" : localMsg.seismic
			},*/
		},
		"eloqua" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : true
		},
		"salesforce" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : true,
			"isEEEnabled" : true,
		},
		"ldap" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : true,
			"isEEEnabled" : true,
		},
		"blank" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : false,
			"isEEEnabled" : true,
			"isCrawlable" : false,
		},
		"http" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : true,
			"isEEEnabled" : true,
		},
		"facebook" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : true,
			"isEEEnabled" : true,
		},
		"twitter" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isLookupEnabled" : true,
			"isEEEnabled" : true,
		},
		"nas" : {
			"searchOnly" : true,
			"statsEnabled" : true
		},
		"reviewset" : {
			"searchOnly" : true,
			"statsEnabled" : true
		},
		"complianceaudit" : {
			"searchOnly" : true,
			"statsEnabled" : true
		},
		"vm" : {
			"searchOnly" : false,
			"statsEnabled" : true,
			"isCrawlable" : false
		}
	};

	var reportsType = {
		"FileAnalytics" : {
			"iconPath" : imgBasePath + "fileanalytics-icon.svg",
			"iconClass" : "ico-file-analytics-icon ico-sb-file",
			"dsDispName" : localMsg.FlaReport,
			"statsEnabled" : false,
			"viewLinkTooltip" : localMsg.ViewFla,
			"appUrl" : "cireports/index.jsp?component=appClients",
		},
		"EmailAnalytics" : {
			"iconPath" : imgBasePath + "emailanalytics-icon.svg",
			"iconClass" : "ico-email-analytics-icon ico-sb-email",
			"dsDispName" : localMsg.EmailAnalyticsReport,
			"statsEnabled" : false,
			"viewLinkTooltip" : localMsg.ViewEmailAnalytics,
			"appUrl" : "cireports/index.jsp?component=exchClients",
		},
		"WebAnalytics" : {
			"iconPath" : imgBasePath + "webanalytics-icon.svg",
			"iconClass" : "ico-earth ico-sb-web",
			"appUrl" : "webanalytics",
			"dsDispName" : localMsg.WebAnalytics,
			"viewLinkTooltip" : localMsg.ViewWebAnalytics,
			"statsEnabled" : false
		}
	};

	var socialDSTypes = [ sea.constants.DSTypes.FACEBOOK ];
	var getDSObject = function(type) {
		return sea.DSTypeConstants.listOfDS[type];
	};
	return {
		listOfDS : listOfDS,
		reportsType : reportsType,
		enableAnalyticsEngineSelection : enableAnalyticsEngineSelection,
		getDSObject : getDSObject,
		socialDSTypes : socialDSTypes,
	};
})();

/*
 * CrawlStatesConstants
 */
sea.CrawlStatesConstants = (function() {
	var getJobStateObj = function(dispName, isIconRequired, className) {
		return {
			"displayName" : dispName,
			"isIconRequired" : isIconRequired,
			"className" : className
		};
	};
	var crawlStatesList = {
		"IDLE" : getJobStateObj("Idle", false),
		"FINISHED" : getJobStateObj("Completed", false, "crawlStatusGreen"),
		"STOPPED" : getJobStateObj("Stopped", false, "crawlStatusRed"),
		"ABORTED" : getJobStateObj("Aborted", false, "crawlStatusRed"),
		"EXCEPTION" : getJobStateObj("Exception", false, "crawlStatusRed"),
		"UNKNOWN" : getJobStateObj("Unknown", false),
		"STARTING" : getJobStateObj("Starting", true, "crawlStatusGreen"),
		"SYNCING" : getJobStateObj("Syncing", true, "crawlStatusGreen"),
		"RUNNING" : getJobStateObj("Running", true, "crawlStatusGreen"),
		"FINISHING" : getJobStateObj("Completing", true, "crawlStatusGreen"),
		"STOPPING" : getJobStateObj("Stopping", true, "crawlStatusRed"),
		"ABORTING" : getJobStateObj("Aborting", true, "crawlStatusRed"),
		"PENDING" : getJobStateObj("Pending", true, "crawlStatusRed"),
		"COMPLETED_WITH_ERRORS" : getJobStateObj("Completed with errors", false, "crawlStatusGreen"),
	};
	var getDispTextForCrawlState = function(state) {
		var jobStatusObj = crawlStatesList[state];
		var dispValue = localMsg.NotApplicable;
		if (jobStatusObj) {
			dispValue = jobStatusObj.displayName;
		}
		return dispValue;
	};
	var getDispHtmlOfCrawlState = function(state) {
		var jobStatusObj = crawlStatesList[state];
		var dispValue = localMsg.NotApplicable;
		if (jobStatusObj) {
			dispValue = "<span class='crawlStatus";
			if (jobStatusObj.isIconRequired) {
				dispValue += " crawlProgressIcon";
			}
			dispValue += "'>" + jobStatusObj.displayName + "</span>";
		}
		return dispValue;
	};
	var getClassNameByCrawlState = function(state) {
		var jobStatusObj = crawlStatesList[state];
		var className = "crawlStatusGray"; // default
		if (jobStatusObj && jobStatusObj.className) {
			className = jobStatusObj.className;
		}

		return className;
	};
	return {
		crawlStatesList : crawlStatesList,
		statesToStopPoll : [ "IDLE", "FINISHED", "STOPPED", "ABORTED", "EXCEPTION", "UNKNOWN", "COMPLETED_WITH_ERRORS" ],
		statesToStopCrawl : [ "RUNNING", "STARTING", "SYNCING", "STOPPING", "PENDING" ],
		getDispHtmlOfCrawlState : getDispHtmlOfCrawlState,
		getDispTextForCrawlState : getDispTextForCrawlState,
		getClassNameByCrawlState : getClassNameByCrawlState
	};
})();
/*
 * ScheduleConstants
 */
sea.ScheduleConstants = (function() {

	var repeatUnits = {
		hourly : "HOURLY",
		daily : "DAILY",
		weekly : "WEEKLY",
		minute : "MINUTE"
	};
	var repeatUnitObjects = [ {
		value : repeatUnits.minute,
		dispVal : localMsg.Minutes
	}, {
		value : repeatUnits.hourly,
		dispVal : localMsg.Hourly
	}, {
		value : repeatUnits.daily,
		dispVal : localMsg.Daily
	}, {
		value : repeatUnits.weekly,
		dispVal : localMsg.Weekly
	} ];
	var getDisplayValueOfRepeatUnit = function(val) {
		var returnText = null;
		$(repeatUnitObjects).each(function(i, e) {
			if (e.value == val) {
				returnText = e.dispVal;
				return false;
			}
		});
		return returnText;
	};
	var repeatDayObjects = [ {
		value : "SUNDAY",
		dispVal : localMsg.Sunday
	}, {
		value : "MONDAY",
		dispVal : localMsg.Monday
	}, {
		value : "TUESDAY",
		dispVal : localMsg.Tuesday
	}, {
		value : "WEDNESDAY",
		dispVal : localMsg.Wednesday
	}, {
		value : "THURSDAY",
		dispVal : localMsg.Thursday
	}, {
		value : "FRIDAY",
		dispVal : localMsg.Friday
	}, {
		value : "SATURDAY",
		dispVal : localMsg.Saturday
	} ];

	var getDisplayValueOfRepeatDay = function(val) {
		var returnText = null;
		$(repeatDayObjects).each(function(i, e) {
			if (e.value == val) {
				returnText = e.dispVal;
				return false;
			}
		});
		return returnText;
	};
	return {
		repeatUnits : repeatUnits,
		repeatDayObjects : repeatDayObjects,
		getDisplayValueOfRepeatUnit : getDisplayValueOfRepeatUnit,
		getDisplayValueOfRepeatDay : getDisplayValueOfRepeatDay,

	};
})();

/* Column Configuration */
sea.ColumnConfiguration = (function() {
	var getMultieditButton = function(data, type, row, meta) {
		if (row.skipdelete) {
			return "";
		}
		var renderer = {
			type : "toggle_boolean"
		};
		return cvFormatters.getDisplayValue(data, renderer, meta, row);
	};

	var schemaConfig = [
			{
				fieldName : "fieldName",
				dispName : localMsg.FieldName,
				isSortable : true,
				className : "schema-fieldName",
				renderer : function(data, type, row, meta) {

					if (row.dynamicField) {
						return "<span class='glyphicon glyphicon-info-sign' data-toggle='tooltip' data-placement='right' data-original-title = '" +
								localMsg.DynamicFieldMessage +
								"'></span> " +
								"<span class='schema-fieldName-value dynamicFieldName' data-value='" +
								data +
								"'>" +
								data + "</span>";
					} else {
						return "<span class='schema-fieldName-value schemaFieldName' data-value='" + data + "'>" +
								data + "</span>";
					}
				}
			},
			{
				fieldName : "type",
				dispName : localMsg.FieldType,
				isSortable : true,
				className : "schema-type",
				renderer : function(data, type, row, meta) {
					var displayName = null;

					if (!$.isEmptyObject(sea.constants.schemaAllowedDataTypes[data])) {
						displayName = sea.constants.schemaAllowedDataTypes[data].dispName;
					} else {
						displayName = data;
					}

					if (row.skipdelete) {
						return displayName;
					} else {
						return "<a class='schema-type' data-value='" + data + "'>" + displayName + "</a>";
					}
				}
			},
			{
				fieldName : "indexed",
				dispName : localMsg.Indexed,
				className : "text-center schema-indexed",
				renderer : getMultieditButton,
				isSortable : true,
				width : "100px"
			},
			{
				fieldName : "multiValued",
				dispName : localMsg.MultiValued,
				className : "text-center schema-multiValued",
				renderer : getMultieditButton,
				isSortable : true,
				width : "100px"
			},
			{
				fieldName : "stored",
				dispName : localMsg.ShowInSearchResults,
				className : "text-center schema-stored",
				renderer : getMultieditButton,
				isSortable : true,
				width : "100px"
			},
			{
				fieldName : "searchDefault",
				dispName : localMsg.DefaultSearchField,
				className : "text-center schema-searchDefault",
				renderer : getMultieditButton,
				isSortable : true,
				width : "100px"
			},
			{
				fieldName : "autocomplete",
				dispName : localMsg.AutoCompleteField,
				className : "text-center schema-autocomplete",
				renderer : getMultieditButton,
				isSortable : true,
				width : "100px"
			},
			{
				fieldName : "action",
				dispName : localMsg.Action,
				defaultContent : "<button type='button' class='btn btn-link btnEdit' action='show'>" + localMsg.Edit +
						"</button>" + " <button type='button' class='btn btn-link btnDelete'>" + localMsg.Delete +
						"</button>",
				renderer : function(data, type, row, meta) {
					if (row.skipdelete) {
						return "<label class='noActionsLabel'> " + localMsg.SystemDefinedField + "</label>";
					}
					if (row.dynamicField) {
						return "<button type='button' class='btn btn-link btnEdit' action='show'>" + localMsg.Edit +
								"</button>"
					}
				},
				isSortable : true,
				width : "150px"
			} ];
	var dateTimeRenderer = {
		type : "date"
	};
	if (!sea.isUseSeaServer) {
		dateTimeRenderer.srcFmt = "ts";
	}
	var searchViewConfig = [ {
		fieldName : sea.isUseSeaServer ? "viewName" : "searchViewName",
		dispName : localMsg.ViewName,
		renderer : function(data, type, row, meta) {
			return "<a data-viewid='" + row.searchViewId + "' class='viewNameLink'>" + data + "</a>";
		}
	}, {
		fieldName : sea.isUseSeaServer ? "addedTime" : "createUTCTime",
		dispName : localMsg.CreatedAt,
		renderer : dateTimeRenderer
	}, {
		fieldName : sea.isUseSeaServer ? "modifiedTime" : "modifiedUTCTime",
		dispName : localMsg.ModifiedAt,
		renderer : dateTimeRenderer
	}, {
		fieldName : "action",
		dispName : localMsg.Action,
		defaultContent : "<button type='button' class='btn btn-link btnDelete'>" + localMsg.Delete + "</button>",
		renderer : function(data, type, row, meta) {
			if (row.attribute == 0) {
				return "<label class='noActionsLabel'> " + localMsg.SystemDefinedView + "</label>";
			}
		},
		isSortable : false
	} ];
	var reportViewConfig = [
			{
				fieldName : "searchViewName",
				dispName : localMsg.ReportName,
				renderer : function(data, type, row, meta) {
					return "<a data-row='" + JSON.stringify(row) + "' class='reportNameLink'>" + data + "</a>";
				}
			},
			{
				fieldName : "createUTCTime",
				dispName : localMsg.CreatedAt,
				renderer : {
					type : "date",
					srcFmt : "ts"
				}
			},
			{
				fieldName : "action",
				dispName : localMsg.Action,
				renderer : function(data, type, row, meta) {
					if (row.attribute === 2) {
						// return "<label class='noActionsLabel'> " + localMsg.SystemDefinedView + "</label>";
						return "<a class='clone-default-report'>" + localMsg.Clone + "</a>";
					}
					return "<a href='" + cvUtil.getContextPath() + "/reportsplus/index.jsp?reportId=" + row.viewInfo +
							"'>" + localMsg.Edit + "</a>";
				},
				isSortable : false
			} ];
	var handlerViewConfig = [
			{
				fieldName : "handlerName",
				dispName : localMsg.HandlerName,
				isSortable : true,
				visible : true,
				renderer : function(data, type, row, meta) {
					return "<button type='button' data-handlerId='" + row.handlerId +
							"' class='btn btn-link btnExecute'>" + data + "</button>";
				}
			},
			{
				fieldName : "action",
				dispName : localMsg.Action,

				defaultContent : "<button type='button' class='btn btn-link handlerEditLink'>" +
						localMsg.Edit +
						"</button>" +
						"<button type='button' class='btn btn-link btnRest'>" +
						localMsg.RESTAPI +
						"</button><button type='button' class='btn btn-link btnShare'>" +
						localMsg.Share +
						"</button>" +
						(sea.isCustomReportsEnabled ? "<button type='button' class='btn btn-link btnVisualize'>" +
								localMsg.Visualize + "</button>" : "") +
						"<button type='button' class='btn btn-link btnDelete'>" + localMsg.Delete + "</button>",

				isSortable : false,
				visible : true
			} ];

	var entityTypeConfig = [ {
		fieldName : "entityType",
		dispName : localMsg.EntityType,
		isSortable : true,
		visible : true,
		renderer : function(data, type, row, meta) {
			if (row.entityNum > 0) {
				return "<button type='button' class='btn btn-link entity-type'>" + data + "</button>";
			} else {
				return data;
			}
		}
	}, {
		fieldName : "entityNum",
		dispName : localMsg.EntityDetected,
		isSortable : true,
		visible : true,
		renderer : function(data, type, row, meta) {
			return data;
		}
	}, {
		fieldName : "documentsNum",
		dispName : localMsg.EntityDocs,
		isSortable : true,
		visible : true,
		renderer : function(data, type, row, meta) {
			return data;
		}
	} ];

	var entityDetailsConfig = [ {
		fieldName : "entityName",
		dispName : localMsg.Entities,
		isSortable : true,
		visible : true,
		renderer : function(data, type, row, meta) {
			return "<button type='button' class='btn btn-link entity-name-search'>" + data + "</button>";

		}
	}, {
		fieldName : "entityType",
		dispName : localMsg.EntityType,
		isSortable : false,
		visible : true,
		renderer : function(data, type, row, meta) {
			return data;
		}
	}, {
		fieldName : "entityNum",
		dispName : localMsg.EntityDetected,
		isSortable : true,
		visible : true,
		renderer : function(data, type, row, meta) {
			return data;
		}
	} ];

	var sharingInfoConfig = [
			{
				fieldName : "userName",
				dispName : localMsg.UsersOrGroups,
				className : "user-sharing",
				isSortable : true,
				visible : true,
				renderer : function(data, type, row, meta) {
					var resp = "<div class='" + data._type_ + "'><span class='user-sharing-info' datatype=" +
							data._type_ + " userId=" + data.userId;
					if (data.groupId) {
						resp += " groupId=" + data.groupId;
					}
					resp += ">" + data.userName + "</span></div>";
					return resp;
				}
			},
			{
				fieldName : "capability",
				dispName : localMsg.Capabilities,
				className : "mode",
				isSortable : true,
				visible : true,
				renderer : function(data) {
					return data;
				}
			},
			{
				fieldName : "action",
				dispName : localMsg.Action,
				isSortable : false,
				visible : true,
				renderer : function(data) {
					return data;
				}
			} ];

	var federatedViewConfig = [ {
		fieldName : "dataSourceName",
		dispName : localMsg.DataSourceName,
		width : "30%"
	}, {
		fieldName : "handlerName",
		dispName : localMsg.HandlerName,
		width : "50%"
	} ];

	var crawlHistoryConfig = [ {
		fieldName : "jobId",
		dispName : localMsg.JobID,
		width : "5%",
		renderer : function(data, type, row, meta) {
			return data ? data : localMsg.NotApplicable;
		}
	}, {
		fieldName : sea.isUseSeaServer ? "crawlStartUTC" : "startUTCTime",
		dispName : localMsg.StartTime,
		width : "15%",
		renderer : dateTimeRenderer
	}, {
		fieldName : sea.isUseSeaServer ? "crawlStopUTC" : "endUTCTime",
		dispName : localMsg.EndTime,
		width : "15%",
		renderer : dateTimeRenderer
	}, {
		fieldName : sea.isUseSeaServer ? "crawlStopUTC" : "endUTCTime",
		dispName : localMsg.TimeTaken,
		isSortable : true,
		width : "10%",
		renderer : function(data, type, row) {
			var time = 0;
			if (sea.isUseSeaServer) {
				time = data - row["crawlStartUTC"];
			} else {
				time = data - row["startUTCTime"];
			}
			if (time > 0) {
				return cvFormatters.formatTimeDuration(time);
			} else {
				return localMsg.NotApplicable;
			}
		}
	}, {
		fieldName : sea.isUseSeaServer ? "crawlState" : "state",
		dispName : localMsg.Status,
		width : "15%",
		renderer : function(data, type, row, meta) {
			return sea.CrawlStatesConstants.getDispHtmlOfCrawlState(data);
		}
	}, {
		fieldName : "numAdded",
		dispName : localMsg.Successful,
		width : "10%",
		renderer : {
			type : "number"
		}
	}, {
		fieldName : "numAccessDenied",
		dispName : localMsg.DocumentsAccessDenied,
		width : "10%",
		visible : true,
		renderer : {
			type : "number"
		}
	}, {
		fieldName : "numFailed",
		dispName : localMsg.DocumentsFailed,
		width : "10%",
		renderer : {
			type : "number"
		}
	}, {
		fieldName : sea.isUseSeaServer ? "crawlStopUTC" : "endUTCTime",
		dispName : "hiddenTimeTaken",
		visible : false,
		renderer : function(data, type, row) {
			var time = 0;
			if (sea.isUseSeaServer) {
				time = data - row["crawlStartUTC"];
			} else {
				time = data - row["startUTCTime"];
			}
			if (time > 0) {
				return time;
			} else {
				return 0;
			}
		}
	}, {
		fieldName : "error",
		dispName : localMsg.ErrorMsg,
		width : "25%",
		renderer : function(data, type, row) {
			return data && data.errLogMessage ? data.errLogMessage : "N/A";
		}
	} ];

	var createBaseReqObj = function(model) {
		var reqObj = {};
		reqObj[sea.constants.HistoryParams.CORE_NAME] = model.collectionName;
		reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.VIEW;
		reqObj[sea.constants.HistoryParams.DS_ID] = model.dsId;
		reqObj[sea.constants.HistoryParams.DS_TYPE] = model.dsType;
		reqObj[sea.constants.HistoryParams.DS_NAME] = model.dsName;
		return reqObj;
	};
	var getDataViewerConfig = function(dsType) {
		var dataViewerColumnConfig;
		if (dsType == sea.constants.DSTypes.FEDERATED) {
			dataViewerColumnConfig = [ {
				data : "dsName",
				title : localMsg.Name,
				width : "20%",
				orderable : true,
				render : function(rowData, type, row, meta) {
					var dsObj = sea.DSTypeConstants.getDSObject(sea.constants.DSTypes.FEDERATED);
					var reqObj = createBaseReqObj(row);
					var returnHtml = $("<div><a class='dsLink'>" + row.dataSourceName + "</a></div>");
					$("a.dsLink", returnHtml).cvHyperlink(reqObj);
					return returnHtml.html();
				},
			}, {
				data : "handlerCount",
				width : "10%",
				title : localMsg.NumberOfHandlers,
				orderable : true,
				render : function(rowData, type, row, meta) {

					var renderer = {
						type : "number",
					};
					return cvFormatters.getDisplayValue(rowData, renderer);
				}
			}, ];
		} else {
			dataViewerColumnConfig = [
					{
						data : "dsName",
						title : localMsg.Name,
						width : "20%",
						orderable : true,
						render : function(rowData, type, row, meta) {
							var dsObj = sea.DSTypeConstants.getDSObject(row.dsType);
							var isSearchOnly = typeof (dsObj) !== "undefined" &&
									typeof (dsObj.searchOnly) !== "undefined" && dsObj.searchOnly;
							var reqObj = createBaseReqObj(row);
							var returnHtml = $("<div><a class='dsLink'>" + row.dsName + "</a></div>");

							if (isSearchOnly) {
								$("a.dsLink", returnHtml).addClass("noHrefLink");
							} else {
								$("a.dsLink", returnHtml).cvHyperlink(reqObj);
							}

							return returnHtml.html();
						},
					},
					{
						data : "docsCount",
						width : "10%",
						title : localMsg.NumberOfDocs,
						orderable : true,
						render : function(rowData, type, row, meta) {

							var renderer = {
								type : "number",
							};
							return cvFormatters.getDisplayValue(rowData, renderer);
						}
					},
					{
						data : "createUTCTime",
						title : localMsg.CreatedAt,
						width : "10%",
						render : function(rowData, type, row, meta) {
							return cvFormatters.getDisplayValue(rowData, {
								type : "date",
								srcFmt : "ts"
							});
						}
					},
					{
						data : "lastCrawledAt",
						title : localMsg.RecentlyCrawledAt,
						width : "10%",
						render : function(rowData, type, row, meta) {
							return cvFormatters.formatFromNow(rowData);
						}
					},
					{
						data : "crawlStatus",
						title : localMsg.CrawlStatus,
						width : "10%",
						groupable : true,
						render : function(rowData, type, row, meta) {
							return sea.CrawlStatesConstants.getDispHtmlOfCrawlState(rowData);
						}
					},
					{
						data : "dsDispName",
						title : localMsg.Type,
						width : "10%",
						visible : dsType ? false : true,
						orderable : dsType ? false : true,
						groupable : dsType ? false : true,
						render : function(rowData, type, row, meta) {
							var dsObj = sea.DSTypeConstants.getDSObject(rowData)
							return dsObj ? dsObj.dsDispName : rowData;
						}
					},
					{
						data : "cloudId",
						title : localMsg.AnalyticsEngine,
						width : "10%",
						render : function(id, type, row, meta) {
							if (row.dsType == sea.constants.DSTypes.FEDERATED) {
								return localMsg.NotApplicable;
							}
							return DataSourceHandler.prototype.getHostName(id);
						}
					},
					{
						title : localMsg.Action,
						width : "10%",
						render : function(rowData, type, row, meta) {
							var dsObj = sea.DSTypeConstants.getDSObject(row.dsType);
							var isSearchOnly = typeof (dsObj) !== "undefined" &&
									typeof (dsObj.searchOnly) !== "undefined" && dsObj.searchOnly;
							var reqObj = createBaseReqObj(row);
							var returnHtml = $("<div></div>");

							if (dsType == sea.constants.DSTypes.FEDERATED) {
								return localMsg.NotApplicable;
							}

							returnHtml.append("<a class='searchLink' style='margin-left: 5px; margin-right: 5px;'>" +
									localMsg.Search + "</a>");
							if (row.dsType !== sea.constants.DSTypes.WEB && !isSearchOnly) {
								returnHtml
										.append("<a class='schemaLink' style='margin-left: 5px; margin-right: 5px;'>" +
												localMsg.ViewSchema + " </a>")
							}

							if (isSearchOnly) {
								$("a.dsLink", returnHtml).addClass("noHrefLink");
							} else {
								reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.VIEW_SCHEMA;
								$("a.schemaLink", returnHtml).cvHyperlink(reqObj);
							}
							reqObj[sea.constants.HistoryParams.ACTION] = sea.constants.Actions.SEARCH_VIEWS;
							$("a.searchLink", returnHtml).cvHyperlink(reqObj);
							return returnHtml.html();
						}
					},
			];
		}

		return dataViewerColumnConfig;
	};

	var getNormalizedValue = function(obj) {
		return obj ? ($.isArray(obj) ? obj[0] : obj) : obj;
	};
	// Search result template for web
	var searchResultTmpl = function(model) {
		var contentid = getNormalizedValue(model.contentid);
		contentid = contentid ? decodeURIComponent(contentid) : cvSearchMessages.NotAvailable;
		var title = getNormalizedValue(model.title);
		title = title ? title : contentid;
		var body_stored = getNormalizedValue(model.body_stored);
		body_stored = body_stored ? body_stored.substring(0, 800) + "..." : cvSearchMessages.NotAvailable;
		var htm = "<div class='itemDiv webDsItemDiv col-md-12 col-sm-12 col-xs-12'><div class='titleDiv'><a href='" +
				contentid + "' target='_blank'>" + title + "</a></div><div class='urlDiv'>" + contentid +
				"</div><div class='descDiv'>" + body_stored + "</div></div>";

		return htm;
	};
	var getConfigInDTFormat = function(config) {
		var configArray = new Array();
		$.each(config, function(index, eachConfig) {
			var obj = {};
			if (eachConfig.fieldName) {
				obj.data = eachConfig.fieldName;
			}
			obj.orderable = eachConfig.isSortable;
			if (eachConfig.renderer) {
				if (typeof eachConfig.renderer === "function") {
					obj.render = eachConfig.renderer;
				} else {
					obj.render = function(data, type, row, meta) {
						return cvFormatters.getDisplayValue(data, eachConfig.renderer, meta, row);
					};
				}
			}
			if (eachConfig.defaultContent) {
				obj.defaultContent = eachConfig.defaultContent;
			}
			if (eachConfig.className) {
				obj.className = eachConfig.className;
			}
			if (eachConfig.width) {
				obj.width = eachConfig.width;
			}
			if (typeof eachConfig.visible !== undefined) {
				obj.visible = eachConfig.visible;
			}
			configArray.push(obj);
		});
		return configArray;
	};

	return {
		schemaConfig : schemaConfig,
		crawlHistoryConfig : crawlHistoryConfig,
		searchViewConfig : searchViewConfig,
		searchResultTmpl : searchResultTmpl,
		getConfigInDTFormat : getConfigInDTFormat,
		createBaseReqObj : createBaseReqObj,
		getDataViewerConfig : getDataViewerConfig,
		handlerViewConfig : handlerViewConfig,
		entityTypeConfig : entityTypeConfig,
		entityDetailsConfig : entityDetailsConfig,
		sharingInfoConfig : sharingInfoConfig,
		federatedViewConfig : federatedViewConfig,
		reportViewConfig : reportViewConfig,
	};
})();

sea.handlerConstants = (function() {
	return {
		Containers : {
			DEFAULT : "default",
			APPEND : "append",
			INVARIANT : "invariant"
		},
		InputTypes : {
			COMBO : "combo",
			TEXT : "text",
			TEXTAREA : "textarea",
			NUMBER : "number",
			BOOLEAN : "boolean",
			CHECKBOX : "checkbox",
			RADIO : "radio"
		}
	};
})();
/*
 * MiscConstants
 */
sea.MiscConstants = (function() {
	var colSepList = [ {
		value : ",",
		dispVal : localMsg.Comma
	}, {
		value : "SPACE",
		dispVal : localMsg.Space
	}, {
		value : "TAB",
		dispVal : localMsg.Tab
	} ];
	var getDispForColSep = function(val) {
		var returnText = null;
		$(colSepList).each(function(i, e) {
			if (e.value == val) {
				returnText = e.dispVal;
				return;
			}
		});
		return returnText;
	};

	var animationDuration = 100;
	return {
		getDispForColSep : getDispForColSep,
		animationDuration : animationDuration,
		deleteCrawledDataChangeType : {
			FIELD : "schemaField",
			PRIMARY_KEY : "primaryKey"
		}
	};
})();
