var sea = sea || {};

sea.analyticsConstants = (function() {
	return {
		"jobStatus" : {
			"Created" : 1,
			"Running" : 2,
			"Completed" : 3,
			"Pending" : 4,
			"Failed" : 5
		},
		"jobPhase" : {
			"Crawl" : 0,
			"Analyze" : 1
		}
	};
})();

sea.analyticsColumnConfig = (function() {

	var jobViewConfig = [
			{
				targets : 0,
				data : "jobName",
				render : function(data, type, full, meta) {
					return "<a data-jobId='" + full.jobId + "' data-jobName='" + full.jobName +
							"' class='viewResult'>" + full.jobName + "</a>";
				},
				orderable : true,
				width : "30%",
				title : localMsg.JobName
			},
			{
				targets : 1,
				data : "addedTime",
				render : form = function(data, type, full, meta) {
					return cvFormatters.formatDate(data);
				},
				orderable : true,
				width : "25%",
				title : localMsg.AddedTime
			},
			{
				targets : 3,
				data : "addedTime",
				render : form = function(data, type, full, meta) {
					return "<a data-jobId='" + full.jobId + "' data-dsId='" + full.dataSourceId +
							"' class='editJob'>EDIT</a> | " + "<a data-jobId='" + full.jobId + "' data-dsId='" +
							full.dataSourceId + "' class='deleteJob'>DELETE </a>| " + "<a data-jobId='" + full.jobId +
							"' data-dsId='" + full.dataSourceId + "' class='runJob'>RUN</a>";
				},
				orderable : false,
				width : "25%",
				title : localMsg.Action
			},
			{
				targets : 4,
				data : "jobStatus",
				render : form = function(data, type, full, meta) {
					var outData = sea.analyticsController.getJobStatusDataView(data);
					if (outData != "Job Completed" || outData != "Not Started") {
						sea.analyticsPolling.addJob(full.jobId, full.dataSourceId);
					}
					return "<span class='pollStatus" + full.jobId + "'>" + outData + "</span>";

				},
				orderable : false,
				width : "20%",
				title : localMsg.JobStatus
			} ];

	return {
		jobViewConfig : jobViewConfig
	};

})();