<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.SeaMessages">
	<fmt:message key="SEA_Header" var="SEA_Header" scope="request" />
	<jsp:include page="/common/header.jsp">
		<jsp:param value="${SEA_Header}" name="titleLocalized" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/headerstyles.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/bootstrap/css/bootstrap-tagsinput.css" name="css" />
		<jsp:param value="${SEA_Header}" name="headerTitleLocalized" />
		<jsp:param value="true" name="bootstrapped" />
	</jsp:include>
	<jsp:include page="/reportsplus/reportHeader.jsp">
		<jsp:param value="webconsole" name="applicationName" />
		<jsp:param value="false" name="includeImport" />
		<jsp:param value="true" name="isFromDataCube" />
		<jsp:param value="false" name="includeBootstrapCss" />
	</jsp:include>
	<jsp:include page="/searchcomponents/includecss.jsp"/>
	
	<jsp:include page="/softwarestore/loginframe/appStoreFrame.jsp">
		<jsp:param value="analytics" name="category"/>
		<jsp:param value="reports" name="subcategory"/>
	</jsp:include>
	<jsp:include page="/reports/reportImportExport.jsp" />
	<link rel="stylesheet"
		href="${pageContext.request.contextPath}/common/jquery-tree-multiselect/jquery.tree-multiselect.min.css?${applicationScope.BUILD_TS}" />
	<link rel="stylesheet"
		href="${pageContext.request.contextPath}/common/jquery-tree-multiselect/jquery.tree-multiselect.overrides.css?${applicationScope.BUILD_TS}" />

	
	<link rel="stylesheet"
		href="${pageContext.request.contextPath}/sea/css/seastyles.css?${applicationScope.BUILD_TS}" />
	<c:choose>
		<c:when test="${not requestScope.useSeaServer}">
			<jsp:include page="/upload/index.jsp" />
			<link rel="stylesheet"
				href="upload/css/upload.css?${applicationScope.BUILD_TS}" />
			<script nonce="${sessionScope.cspNonce}" type="text/javascript"
				src="sea/js/uploadFile.js?${applicationScope.BUILD_TS}"></script>
		</c:when>
		<c:otherwise>
			<script nonce="${sessionScope.cspNonce}" type="text/javascript"
				src="standalone/js/uploadFile.js?${applicationScope.BUILD_TS}"></script>
			<script nonce="${sessionScope.cspNonce}" type="text/javascript"
				src="thirdparty/js/jquery.form.js?${applicationScope.BUILD_TS}"></script>
		</c:otherwise>
	</c:choose>
	<script nonce="${sessionScope.cspNonce}" >
		var sea = {};
		// do not use this variable in JS as "false" in conditions treated as 1. Use isUseSeaServer.
		sea.useSeaServer = "${requestScope.useSeaServer}";
		var rocEnable = "${requestScope.isROCEnabled}";
		if (rocEnable.toString() == "true")
			sea.isROCEnabled = true;
		else
			sea.isROCEnabled = false;
		sea.BUILD_TS = "${applicationScope.BUILD_TS}";
		if (sea.useSeaServer && (sea.useSeaServer === "true" || sea.useSeaServer === true))
			sea.isUseSeaServer = true;
		else
			sea.isUseSeaServer = false;
		var showDataConnectors = "${requestScope.showDataConnectors}";
		if (showDataConnectors != null && (showDataConnectors === "true" || showDataConnectors === true))
			sea.showDataConnectors = true;
		else
			sea.showDataConnectors = false;
		var handlerEnable = "${requestScope.isDcubeHandlerEnabled}";
		if (handlerEnable.toString() == "true")
			sea.isDcubeHandlerEnabled = true;
		else
			sea.isDcubeHandlerEnabled = false;
		var entityExtractionEnable = "${requestScope.isEntityExtractionEnabled}";
		if (entityExtractionEnable.toString() == "true")
			sea.isEntityExtractionEnabled = true;
		else
			sea.isEntityExtractionEnabled = false;
		var customReportsEnabled = "${requestScope.isDcubeEnabledInCustomReports}";
		if (customReportsEnabled.toString() == "true")
			sea.isCustomReportsEnabled = true;
		else
			sea.isCustomReportsEnabled = false;
		var isDcubeExportEnabled = "${requestScope.isDcubeExportEnabled}";
		if(isDcubeExportEnabled.toString() == "true")
			sea.isDcubeExportEnabled = true;
		else
			sea.isDcubeExportEnabled = false;
		var isAllSchemaFieldDataTypes = "${requestScope.isAllSchemaFieldDataTypes}";
		if (isAllSchemaFieldDataTypes.toString() == "true")
			sea.isAllSchemaFieldDataTypes = true;
		else
			sea.isAllSchemaFieldDataTypes = false;
		var lookupEnable = "${requestScope.isLookupEnabled}";
		if (lookupEnable.toString() == "true")
			sea.isLookupEnabled = true;
		else
			sea.isLookupEnabled = false;
		var detectDataTypeEnable = "${requestScope.isDetectDataTypeEnabled}";
		if (detectDataTypeEnable.toString() == "true")
			sea.isDetectDataTypeEnabled = true;
		else
			sea.isDetectDataTypeEnabled = false;
		var webhookEnable = "${requestScope.isWebhookEnabled}";
		if (webhookEnable.toString() == "true")
			sea.isWebhookEnabled = true;
		else
			sea.isWebhookEnabled = false;
		
		sea.dataConnectorsList = "${requestScope.dataConnectorsList}";
		sea.enabledReportsList = "${requestScope.enabledReportsList}";
		//needed for rest api sample response
		sea.authToken = "${sessionScope.LOGIN_TOKEN_INFO.token}";
		var originalValFun = this.originalValFun = $.fn.val;
		$.fn.val = function(value) {
		    if (typeof value == 'undefined') {
		        //Getting the value
		        return $.trim(originalValFun.call(this));
		       }		    
		    else {
		        //Setting the value
		        return originalValFun.call(this, value);
		    }
		};

	</script>

	<div id="cvPageWithSideBar-Main" class="cvPageWithSideBar active">
		<div class="cvSidebarWrapper hidden-print" data-spy="affix"
			data-offset-top="10">
			<ul class="cvSidebarNav margin-bottom-0">
				<li class="cvSidebarBrand row nomargin"><a class="col-lg-10 col-md-10 col-sm-10" id="seaHomeLink" href="dcube.do"><fmt:message
							key="SEA_Header" /></a> <span
					class="list-icon ico-view-headline cvSidebarMenuToggle col-lg-2 col-md-2 col-sm-2"
					data-cv-sidebar-parent="cvPageWithSideBar-Main"></span></li>
				
			</ul>
			<ul id="dsList" class="cvSidebarNav cvSidebarNavMenu cvSidebarScroll">
			</ul>
		</div>

		<!-- Page content -->
		<div class="cvPageContentWrapper">
			<!-- Keep all page content within the page-content div! -->
			<div class="page-content inset container-fluid">
				<div class="row">
					<div id="seaContainer" class="col-lg-12 col-md-12"></div>
				</div>
			</div>
		</div>

	</div>
	<h3 data-templateId="tmpl_Header" class="cvHeader"></h3>
	<p data-templateId="tmpl_sub_Header" class="descriptionHeader"></p>
	<div data-templateId="tmpl_Toolbar" class="cvToolbar"
		style="display: none">
		<div class="cvToolbarTitle pull-left"></div>
		<div class="cvToolbarButtonbar pull-right"></div>
		<div style="clear: both"></div>
	</div>
	<div data-templateId="tmpl_SubMenuToolbar" class="cvToolbar header-toolbarInPage"
		style="display: none">
<!-- 		<div class="cvToolbarText pull-left">
			<div class="cvToolbarTitle"></div>
			<p class="dsViewDescription"></p>
		</div> -->
		<div class="cvToolbarNavSubMenuGrp"></div>
	</div>
	<jsp:include page="/sea/templatehtml/common.jsp" />
	<jsp:include page="/sea/templatehtml/dashboard.jsp" />
	<jsp:include page="/sea/templatehtml/dashboardInfoTiles.jsp" />
	<!-- include templates for db and web data-sources -->
	<jsp:include page="/sea/templatehtml/dbdstemplate.jsp" />
	<jsp:include page="/sea/templatehtml/webdstemplate.jsp" />
	<jsp:include page="/sea/templatehtml/csvdstemplate.jsp" />
	<jsp:include page="/sea/templatehtml/eloquadstemplate.jsp" />
	<jsp:include page="/sea/templatehtml/fsdstemplate.jsp" />
	<jsp:include page="/sea/templatehtml/salesforcedstemplate.jsp" />
	<jsp:include page="/sea/templatehtml/ldapdstemplate.jsp" />
	<!-- include templates for fields, search, schedule  -->
	<jsp:include page="/sea/templatehtml/fieldstemplate.jsp" />
	<jsp:include page="/sea/templatehtml/scheduletemplate.jsp" />
	<!-- include templates for search view creation  -->
	<jsp:include page="/sea/templatehtml/viewtemplate.jsp" />
	<jsp:include page="/sea/templatehtml/solrHandlerTemplate.jsp" />
	<jsp:include page="/sea/templatehtml/federatedTemplate.jsp" />
	<jsp:include page="/sea/templatehtml/blankdstemplate.jsp" />
	<jsp:include page="/sea/templatehtml/httpdstemplate.jsp" />
	<jsp:include page="/sea/templatehtml/fbdstemplate.jsp" />
	<jsp:include page="/sea/templatehtml/twitterdstemplate.jsp" />
	<!-- handlebar templates -->
	<jsp:include page="/sea/templatehtml/restApi.html"></jsp:include>
	<jsp:include page="/sea/templatehtml/webhooktemplate.jsp"></jsp:include>
	<jsp:include page="/sea/templatehtml/contentAnalyzer.jsp"></jsp:include>
	<jsp:include page="/sea/templatehtml/lookuptool.jsp"></jsp:include>
</fmt:bundle>
<jsp:include page="/sea/templatehtml/localization.jsp" />

<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/handlebars.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/encoder.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/bootstrap/js/bootstrap-multiselect.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/bootstrap/js/bootstrap-tagsinput.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/jquery-tree-multiselect/jquery.tree-multiselect.min.js?${applicationScope.BUILD_TS}"></script>

<jsp:include page="/common/footer.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="../sea/js/sea.js" name="js" />
	<jsp:param value="../sea/js/services.js" name="js" />
	<jsp:param value="../sea/js/util.js" name="js" />
	<jsp:param value="../sea/js/analyticsapp.js" name="js" />
	<jsp:param value="../sea/js/dsController.js" name="js" />
	<jsp:param value="../sea/js/schemaController.js" name="js" />
	<jsp:param value="../sea/js/crawlController.js" name="js" />
	<jsp:param value="../sea/js/viewController.js" name="js" />
	<jsp:param value="../sea/js/restApiController.js" name="js" />
	<jsp:param value="../sea/js/restApiConstants.js" name="js" />
	<jsp:param value="../sea/js/constants.js" name="js" />
	<jsp:param value="../sea/js/uiControls.js" name="js" />
	<jsp:param value="../sea/js/datasourcehandler.js" name="js" />
	<jsp:param value="../sea/js/jdbcHandler.js" name="js" />
	<jsp:param value="../sea/js/blankHandler.js" name="js" />
	<jsp:param value="../sea/js/webHandler.js" name="js" />
	<jsp:param value="../sea/js/csvHandler.js" name="js" />
	<jsp:param value="../sea/js/fsHandler.js" name="js" />
	<jsp:param value="../sea/js/eloquaHandler.js" name="js" />
	<jsp:param value="../sea/js/salesforceHandler.js" name="js" />
	<jsp:param value="../sea/js/ldapHandler.js" name="js" />
	<jsp:param value="../sea/js/federatedHandler.js" name="js" />
	<jsp:param value="../sea/js/httpHandler.js" name="js" />
	<jsp:param value="../sea/js/socialHandler.js" name="js" />
	<jsp:param value="../sea/js/facebookHandler.js" name="js" />
	<jsp:param value="../sea/js/seaexception.js" name="js" />
	<jsp:param value="../sea/js/cvWizard.js" name="js" />
	<jsp:param value="../sea/js/shareFiles.js" name="js" />
	<jsp:param value="../sea/js/searchApiController.js" name="js" />
	<jsp:param value="../sea/js/dataTables.cvVisualizer.js" name="js" />
	<jsp:param value="../sea/js/lookupTool.js" name="js" />
	<jsp:param value="../sea/js/twitterHandler.js" name="js" />
	<jsp:param value="../sea/js/contentAnalyzer.js" name="js" />
	<jsp:param value="../sea/js/webhookController.js" name="js" />
	<jsp:param value="../sea/js/authTool.js" name="js" />
	<jsp:param value="../reports/js/reportsBase.js" name="js" />
</jsp:include>

<!-- Moved the below files from /searchcomponents/includejs.jsp	for their bootstrap dependecy -->
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/searchcomponents/js/cvFacetsView.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/searchcomponents/js/cvSearchView.js?${applicationScope.BUILD_TS}"></script>

<c:choose>
	<c:when test="${requestScope.isEntityExtractionEnabled}">
		<script nonce="${sessionScope.cspNonce}" src="sea/js/entityExtractor.js"></script>
		<script nonce="${sessionScope.cspNonce}" src="common/js/highcharts/highcharts.js"></script>
		<script nonce="${sessionScope.cspNonce}" src="common/js/highcharts/highcharts-3d.js"></script>
		<script nonce="${sessionScope.cspNonce}" src="common/js/highcharts/exporting.js"></script>
	</c:when>
</c:choose>
<c:choose>
	<c:when test="${requestScope.isROCEnabled}">
		<jsp:include page="templatehtml/analyticsJobCreationTemplate.jsp"></jsp:include>
		<jsp:include page="/roc/page.jsp"></jsp:include>
		<script nonce="${sessionScope.cspNonce}"
			src="sea/js/analytics/services.js?${applicationScope.BUILD_TS}"></script>
		<script nonce="${sessionScope.cspNonce}"
			src="sea/js/analytics/constants.js?${applicationScope.BUILD_TS}"></script>
		<script nonce="${sessionScope.cspNonce}"
			src="sea/js/analytics/controller.js?${applicationScope.BUILD_TS}"></script>
	</c:when>
</c:choose>
