<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:bundle basename="localization.ReportsPlusMessages">

    <div class="loading-top hideOnExportFriendly" data-ng-if="component.type !== 'TABS'" data-ng-hide="isReadme || component.hideLoadingAnimation"></div>
    <div class="component full-height {{appName}}-component"
         data-ng-class="{'componentSelected': component.isSelected && !isDcubeEnabledInCustomReports,'scroll-mode-enabled' : component.enableHorizontalScroll,'scroll-mode-disabled':!component.enableHorizontalScroll}"
         data-ng-hide="component.blankComponent" data-ng-controller="ComponentCtrl"
         data-ng-click="setActiveComponent(component,undefined,$event)">
        <div class="buttonPanel hideOnExportFriendly"
             data-ng-if="(component.type=='TABLE' || component.type =='NEW_TABLE') && component.enableButtonPanel && !component.collapsed && !component.showButtonsAtBottom">
            <ul cv-rpt-sortable="component.buttons">
                <li data-ng-repeat="button in component.buttons" cv-rpt-sortable-item="$index"
                    data-ng-click="setActiveComponent({type:'button',comp:button},'undefined',$event)">
                    <button id="{{button.id}}" class="btn {{button.class}}"
                            data-ng-class="{'default-button': !button.class}" title="{{button.toolTip}}"
                            data-ng-click="evalButtonExpression($event,button.clickExpression)"
                            ng-dblclick="evalButtonExpression($event,button.clickExpression)"
                            cv-tag-attributes="{{button.buttonAttributes}}" cv-report-customization
                            data-ng-disabled="!buttonStates[$index]"
                            data-ng-init="buttonStates[$index] = evalButtonState(button)">
                        <img ng-attr-src="{{button.imageType == 'url' ? button.imageValue : ''}}"
                             data-ng-if="button.imageType == 'url'">
                        <span class="customIcon" data-ng-if="button.imageType == 'custom'"
                              ng-bind-html="button.imageValue"></span>
                        <span cv-report-customization cv-expression="{{button.title.text}}" cv-localize="true"></span>
                    </button>
                </li>
                <li data-ng-show="reportMode == 'builder'" data-ng-init="upgradeButtons()">
                    <button class="btn ng-binding" data-ng-click="addButton()" title="Add New Button">
                        <span class="sprite reports-actions-addpage"></span>
                    </button>
                </li>
            </ul>
        </div>
        <div id="{{component.id}}-component-title" class="reportstabletitle"
             data-ng-hide="((component.hideHeader && reportMode === 'viewer') || component.isQuickAnalysis )"
             data-ng-class="{'panel-table-title' : isLayoutAvailable}">
            <span data-ng-if="component.type=='FACET' && reportMode == 'builder' && !component.hideCollapse"
                  class="collapseIconStyle glyphicon cursor-pointer"
                  data-ng-click="component.collapseAllFacets=!component.collapseAllFacets"
                  data-ng-class="{'icon-expand' : component.collapseAllFacets,'icon-collapse' : !component.collapseAllFacets}"></span>

            <div data-ng-if="reportLayout[component.id][deviceType].size.x === reportLayout.gridsterOpts.columns &&
            (component.type !== 'FACET' || (component.type === 'FACET' && reportMode === 'viewer'))"
                 class="arrowPlaceholder hideOnExportFriendly" data-ng-click="toggleComponentVisiblity($event)"
                 data-ng-class="{'expand':!component.collapsed , 'collapse':component.collapsed}"></div>


            <inplace data-ng-if="!isTileBuilder" model="componentTitle"
                     ng-attr-placeholder="{{getTitlePlaceholder()}}"
                     data-ng-class="{'actionDisabled': component.type === 'HITS','modal-title': component.shared}"
                     class="input-title">
            </inplace>
            <span data-ng-if="isTileBuilder" class="tileHelpLabels">{{componentTitle}}</span>


            <a class="glyphicon glyphicon-warning-sign chart-error compButtons"
               uib-popover="Too many values. Not showing all data." popover-placement="bottom-left"
               data-ng-if="tempComponent.tooManyRecordsReturned" popover-append-to-body="true"
               popover-trigger="mouseenter"></a>
            <span class="showSelectedRows"
                  data-ng-if="component.enableButtonPanel && component.enableRowSelection && !component.collapsed"
                  data-ng-show="child.showSelectedRowsLabel"><input type="checkbox" class="checkbox-label"
                                                                    id="{{component.id}}_selectedrows"
                                                                    class="compButtons btn"
                                                                    data-ng-model="toggleSelectedRows"
                                                                    data-ng-change="child.showSelectedRows(toggleSelectedRows)"
                                                                    title="Show Selected Rows"><label
                    for="{{component.id}}_selectedrows"><fmt:message
                    key="CustomReport.Component.ShowSelectedRows"/></label></span>
            <div class="component-actions" data-ng-if="component.showAsSearchResults"
                 data-ng-hide="component.collapsed || (appName === 'adminconsole' && (component.type === 'TABLE' || component.type === 'PIVOT_TABLE' || component.type === 'NEW_TABLE'))">
                 <span data-ng-if="child.totalServerItems > 0 && !dataSetPreview && component.type!='TAG_CLOUD' && component.type!='NEW_TABLE' && !toggleSelectedRows">
					 	<span class="tableInfoText" data-ng-show="!component.shared && !child.isExportTwoStep() && !child.quickAnalysisMode" ><fmt:message key="CustomReport.Showing"/> {{child.pageOffSet+1}} <fmt:message key="CustomReport.To"/> {{child.pageOffSet + child.totalFilteredItems}} <fmt:message key="CustomReport.Of"/> {{child.totalServerItems}} <fmt:message key="CustomReport.Entries"/></span>
					 	<span class="tableInfoText" data-ng-show="!component.shared && child.isExportTwoStep() && !child.quickAnalysisMode" ><fmt:message key="CustomReport.Showing"/> {{child.pageOffSet+1}} <fmt:message key="CustomReport.To"/> {{child.totalServerItems}} <fmt:message key="CustomReport.Of"/> {{child.totalServerItems}} <fmt:message key="CustomReport.Entries"/></span>
					</span>
                <span class="hideOnExportFriendly hideOnReadme pageSizeElm"><fmt:message key="CustomReport.Show"/>&nbsp;&nbsp;<label
                        for="{{component.id}}_pageSize" class="select-label"><select id="{{component.id}}_pageSize"
                                                                                     class="page-size"
                                                                                     data-ng-model="component.pageSize"
                                                                                     data-ng-change="child.pageSizeChanged(component.pageSize)"
                                                                                     data-ng-options="size as size for size in pageSizes"
                                                                                     style="color: black"></select></label></span>
                <a class="compButtons sprite  reports-actions-xbutton"
                   data-ng-click="deleteComponent($index,panelComponentIndex,tabData,$event)"
                   title='<fmt:message key="CustomReport.DeleteComponent"/>' data-ng-if="reportMode === 'builder' && !isFullScreen"></a>
            </div>
            <div class="component-actions" data-ng-if="!component.showAsSearchResults"
                 data-ng-hide="component.collapsed">
					<span data-ng-hide="(component.type === 'TABLE' || component.type === 'PIVOT_TABLE' || component.type === 'NEW_TABLE')" data-ng-if="cv.additionalSettings.Console.replaceNewTable && child.totalServerItems > 0 && !dataSetPreview && component.type!='TAG_CLOUD' && component.type!='NEW_TABLE' && !toggleSelectedRows">
					 	<span class="tableInfoText" data-ng-show="!component.shared && !child.isExportTwoStep() && !child.quickAnalysisMode"><fmt:message
                                key="CustomReport.Showing"/> {{child.pageOffSet+1}} <fmt:message key="CustomReport.To"/> {{child.pageOffSet + child.totalFilteredItems}} <fmt:message
                                key="CustomReport.Of"/> {{child.totalServerItems}} <fmt:message
                                key="CustomReport.Entries"/></span>
					 	<span class="tableInfoText" data-ng-show="!component.shared && child.isExportTwoStep() && !child.quickAnalysisMode"><fmt:message
                                key="CustomReport.Showing"/> {{child.pageOffSet+1}} <fmt:message key="CustomReport.To"/> {{child.totalServerItems}} <fmt:message
                                key="CustomReport.Of"/> {{child.totalServerItems}} <fmt:message
                                key="CustomReport.Entries"/></span>
					</span>

				<span class="tableActionBtns table-action-btns ng-table-actions" data-ng-if="appName !== 'adminconsole' && cv.additionalSettings.Console.replaceNewTable && (component.type ==='TABLE' || component.type ==='PIVOT_TABLE')  && !child.quickAnalysisMode">
	                <span class="hideOnExportFriendly hideOnReadme pageSizeElm"
	                      data-ng-if="(component.type ==='TABLE' || component.type ==='PIVOT_TABLE') && !child.quickAnalysisMode"><fmt:message
	                        key="CustomReport.Show"/>&nbsp;&nbsp;<label for="{{component.id}}_pageSize"
	                                                                    class="select-label"><select
	                        id="{{component.id}}_pageSize" class="page-size" data-ng-model="component.pageSize"
	                        data-ng-change="child.pageSizeChanged(component.pageSize)"
	                        data-ng-options="size as size for size in pageSizes"
	                        style="color: black"></select></label></span>
                    <button data-ng-class="{'compButtons  icon-add-col hideOnExportFriendly' : !component.showColumnSetting,'colSettingBtn':component.showColumnSetting }"
                            data-ng-if="(component.type ==='TABLE' || component.type ==='PIVOT_TABLE' || component.type === 'NEW_TABLE') && (!component.hideFilterOption || component.hideFilterOption != true) && !child.quickAnalysisMode"
                            data-ng-click="component.showColumnSetting ? child.openColumnSettingModal() : child.showColMenu($event, component.id)"
                            title="<fmt:message key='CustomReport.AddRemoveColumns'/>">{{component.showColumnSetting ? "<fmt:message key='CustomReport.ColumnSetting.Title'/>" : ""}}</button>
	                <button class="compButtons  icon-filter hideOnExportFriendly"
	                        data-ng-if="(component.type ==='TABLE' || component.type ==='PIVOT_TABLE' || component.type === 'NEW_TABLE') && (!component.hideFilterOption || component.hideFilterOption != true) && !child.quickAnalysisMode"
	                        data-ng-click="component.showFilterByDefault=!component.showFilterByDefault"
	                        title="<fmt:message key='CustomReport.Filtercolumns'/>"></button>

					<button class="compButtons icon-burger hideOnExportFriendly"
                        data-ng-if="(component.type ==='TABLE' || component.type ==='PIVOT_TABLE' || component.type === 'NEW_TABLE') && !child.quickAnalysisMode && !isFullScreen"
                        data-ng-click="showTableMenu($event, component.id)" title="Show Table Menu"></button>

	            </span>

				<div class="table-action-btns ng-table-actions" data-ng-if="!cv.additionalSettings.Console.replaceNewTable && (component.type ==='TABLE' || component.type ==='PIVOT_TABLE')  && !child.quickAnalysisMode">
                    <a data-ng-if="component.enableRowSelection && component.enableMultiRowSelection
                    && component.filterReportForRowSelection && child.showSelectedRowsLabel" class="cursor-pointer padding-left-5 margin-right-15" data-ng-click="child.clearRowSelection()" title="<fmt:message key='CustomReport.Clear'/>"><fmt:message key='CustomReport.Clear'/></a>
                    <div class="show-search search-text-wrapper inline-divs" data-ng-class="{'hideOnExportFriendly':!child.globalSearch}"  title="<fmt:message key='CustomReport.Table.SearchHelpText'/>">
						  <input id="{{component.id}}-search-input" type="search" class="search-input" placeholder="Search" data-ng-model="child.globalSearch" data-ng-enter="child.handleSearch()" data-ng-blur="!child.globalSearch ? child.searchEnabled = false :  child.searchEnabled = true">
						  <span class="k-icon k-i-close k-i-x clear-global-search" title="<fmt:message key='CustomReport.ClearSearch'/>" data-ng-click="child.handleSearch(true)" data-ng-show="child.searchApplied"></span>
					</div>
					<div class="hideOnExportFriendly inline-divs action-icon" data-ng-if="reportMode !== 'preview'">
						<ul kendo-menu k-options="child.settingsDropDownOptions" class="settings-menu">
					      <li class="glyphicon glyphicon-cog hideOnExportFriendly  inline-divs action-icon" data-ng-click="child.opendropDown($event)">
                            <ul  style="display:none">
                            <li class="action-item table-column-selector">
		                        <div class="action-item-div">
									<span class="k-icon k-i-columns"></span><span class="action-item-label" title="<fmt:message key='CustomReport.TableMenu.AddRemoveColumns'/>"><fmt:message key='CustomReport.TableMenu.AddRemoveColumns'/></span>
								</div>
								<ul>
				                  <column-list data-columns="component.columns" data-callbackfn="child.toggleColVisibility"></column-list>
				                </ul>
	                    	</li>
					         <li class="action-item table-show-filter" data-ng-click="component.showFilterByDefault=!component.showFilterByDefault;child.toggleFilterVisibility()" data-ng-if="(!component.hideFilterOption || component.hideFilterOption != true)">
		                        <div class="action-item-div"><svg class="menu-icons" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 18 18">
									<path d="M16.7,0H1.4C0,0-0.4,0.9,0.5,2.1l6.2,7.6V18l4.9-2.3V9.9l3.1-4.2l2.8-3.6C18.5,0.9,18,0,16.7,0"/>
								</svg>
										<span class="action-item-label" title="<fmt:message key='CustomReport.Filtercolumns'/>"><fmt:message key='CustomReport.Filtercolumns'/></span>
								</div>
	                    	</li>
	                    	<li class="action-item table-export-csv" data-ng-click="exportToCSV();" data-ng-if="!component.shared && component.hideCsvOption != true && reportMode === 'viewer'">
		                        <div class="action-item-div"><svg class="menu-icons" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 18 18">
										<path d="M11.3,0H8.1L5.9,3.3L3.6,0H0.4l3.9,5.7L0,12h6.1V9.9H4.8l1-1.8L8.5,12h3.3L7.5,5.7L11.3,0z M18,13.5V18h-4.5v-4.5H18z
											 M13.5,6.6v4.5H18V6.6L13.5,6.6z M13.5,0v4.5H18V0H13.5z M6.6,18h4.5v-4.5H6.6L6.6,18z M0,18h4.5v-4.5H0V18z"/>
										</svg>
										<span class="action-item-label" title="<fmt:message key='CustomReport.TableMenu.ExportToCsv'/>"><fmt:message key='CustomReport.TableMenu.ExportToCsv'/></span>
								</div>
	                    	</li>
	                    	<li class="action-item table-rest-api" data-ng-click="showRESTAPI();" data-ng-if="!component.shared && reportMode === 'viewer' && dataSet.endpoint != 'DATACUBE'">
		                        <div class="action-item-div"><svg class="menu-icons" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="12px" height="12px" viewBox="0 0 522.468 522.469" style="enable-background:new 0 0 522.468 522.469;" xml:space="preserve"><g><g><path d="M325.762,70.513l-17.706-4.854c-2.279-0.76-4.524-0.521-6.707,0.715c-2.19,1.237-3.669,3.094-4.429,5.568L190.426,440.53 c-0.76,2.475-0.522,4.809,0.715,6.995c1.237,2.19,3.09,3.665,5.568,4.425l17.701,4.856c2.284,0.766,4.521,0.526,6.71-0.712 c2.19-1.243,3.666-3.094,4.425-5.564L332.042,81.936c0.759-2.474,0.523-4.808-0.716-6.999 C330.088,72.747,328.237,71.272,325.762,70.513z"/><path d="M166.167,142.465c0-2.474-0.953-4.665-2.856-6.567l-14.277-14.276c-1.903-1.903-4.093-2.857-6.567-2.857 s-4.665,0.955-6.567,2.857L2.856,254.666C0.95,256.569,0,258.759,0,261.233c0,2.474,0.953,4.664,2.856,6.566l133.043,133.044 c1.902,1.906,4.089,2.854,6.567,2.854s4.665-0.951,6.567-2.854l14.277-14.268c1.903-1.902,2.856-4.093,2.856-6.57 c0-2.471-0.953-4.661-2.856-6.563L51.107,261.233l112.204-112.201C165.217,147.13,166.167,144.939,166.167,142.465z"/><path d="M519.614,254.663L386.567,121.619c-1.902-1.902-4.093-2.857-6.563-2.857c-2.478,0-4.661,0.955-6.57,2.857l-14.271,14.275 c-1.902,1.903-2.851,4.09-2.851,6.567s0.948,4.665,2.851,6.567l112.206,112.204L359.163,373.442 c-1.902,1.902-2.851,4.093-2.851,6.563c0,2.478,0.948,4.668,2.851,6.57l14.271,14.268c1.909,1.906,4.093,2.854,6.57,2.854 c2.471,0,4.661-0.951,6.563-2.854L519.614,267.8c1.903-1.902,2.854-4.096,2.854-6.57 C522.468,258.755,521.517,256.565,519.614,254.663z"/></g></g></svg>
										<span class="action-item-label" title="<fmt:message key='CustomReport.TableMenu.showRestApi'/>"><fmt:message key='CustomReport.TableMenu.showRestApi'/></span>
								</div>
	                    	</li>
	                    	<li class="action-item table-add-to-dashboard" data-ng-click="addToDashboard();" data-ng-if="!component.shared && appName !== 'adminconsole' && reportMode === 'viewer' &&  component.hideCsvOption != true">
		                        <div class="action-item-div"><svg class="menu-icons" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 17.3 18">
											<path d="M6.9,15.1H1.4V9.7h5.5C7.3,9.1,7.7,8.5,8.3,8V2.8h5.5v4.6c0.5,0.2,1,0.5,1.4,0.8V0H0v16.6h8.2C7.6,16.2,7.2,15.7,6.9,15.1z
												 M1.4,2.8h5.5v5.5H1.4V2.8z M11.8,6.9c-3.1,0-5.5,2.5-5.5,5.5S8.7,18,11.8,18s5.5-2.5,5.5-5.5S14.8,6.9,11.8,6.9z M15.5,13.4h-2.8
												v2.8h-1.9v-2.8H8v-1.9h2.8V8.7h1.9v2.8h2.8V13.4z"/>
											</svg>
										<span class="action-item-label" title="<fmt:message key='CustomReport.TableMenu.AddToDashboard'/>"><fmt:message key='CustomReport.TableMenu.AddToDashboard'/></span>
								</div>
	                    	</li>
	                    	<li class="action-item table-quick-chart" data-ng-click="child.showQuickAnalysis($event);" data-ng-if="!component.shared && (!component.hideQuickAnalysisOption || component.hideQuickAnalysisOption != true)">
		                        <div class="action-item-div"><svg class="menu-icons" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 18 18">
								<path d="M9.5,0v8c0,0,7.6-2.8,7.5-3C15.6,2,12.7,0.1,9.5,0z M10.1,9.6l4.5,6.5C16.7,14.4,18,11.8,18,9c0-0.7,0-1.3-0.2-2  C17.7,6.8,10.1,9.6,10.1,9.6z M8.1,9.5L8.1,9.5c0,0-0.1-9.5-0.5-9.3C3.2,0.8,0,4.5,0,9c0,5,4,9,9,9c1.5,0,2.9-0.4,4.2-1  c0.3-0.2-5-7.4-5-7.4L8.1,9.5z"/>
							</svg>
										<span class="action-item-label" title="<fmt:message key='CustomReport.TableMenu.ShowQuickAnalysis'/>"><fmt:message key='CustomReport.TableMenu.ShowQuickAnalysis'/></span>
								</div>
	                    	</li>
	                    	<li class="action-item table-alarm" data-ng-click="openAlarmsDialog();" data-ng-if="reportMode === 'viewer' && !component.shared && component.hideAlarmOption != true">
		                        <div class="action-item-div"><svg class="menu-icons" xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 14 14"><path d="M7,1a1.1,1.1,0,0,0-1,.8C4,2.2,3.2,4,3.2,6.1V7.9A1.8,1.8,0,0,1,1.9,9.6v.7H12.1V9.6a1.8,1.8,0,0,1-1.3-1.7V6.1C10.8,4,10,2.2,8,1.8A1.1,1.1,0,0,0,7,1ZM5.1,11.1a1.9,1.9,0,1,0,3.8,0Z"/></svg></button>
										<span class="action-item-label" title="<fmt:message key='CustomReport.TableMenu.ConfigureAnAlert'/>"><fmt:message key='CustomReport.TableMenu.ConfigureAnAlert'/></span>
								</div>
	                    	</li>
	                    	<li class="action-item table-scroll-mode" data-ng-click="child.toggleScrollMode()">
		                        <div class="action-item-div"><svg class="menu-icons" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16.36 18"><path d="M16.36,18V0H0V18ZM13.09,1.64h1.64V16.36H13.09Zm-1.64.2V16.36H1.64V9.91H7.39v2.42L10.51,9.1,7.39,5.87V8.29H1.64V1.84Z"/></svg></button>
										<span class="action-item-label" title="{{component.enableHorizontalScroll ? '<fmt:message key="CustomReport.TableMenu.DisableHorizontalScroll"/>':'<fmt:message key="CustomReport.TableMenu.EnableHorizontalScroll"/>'}}">{{component.enableHorizontalScroll ? '<fmt:message key="CustomReport.TableMenu.DisableHorizontalScroll"/>':'<fmt:message key="CustomReport.TableMenu.EnableHorizontalScroll"/>'}}</span>
								</div>
	                    	</li>
	                    	<li class="action-item table-full-screen-mode" data-ng-click="makeComponentFullScreen($event);" data-ng-if="reportMode === 'viewer' && !component.shared">
		                        <div class="action-item-div"><svg class="menu-icons" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 18 18">
							<path d="M18,0l-1,6.2l-1.5-1.6l-4.4,4.2L9.2,6.8l4.4-4.2l-1.7-1.7L18,0z M6.2,17l-1.7-1.6l4.4-4.4L6.9,9l-4.4,4.4l-1.7-1.5L0,18
								L6.2,17z"/>
							</svg>
										<span class="action-item-label" title="<fmt:message key='CustomReport.TableMenu.Fullscreen'/>"><fmt:message key='CustomReport.TableMenu.Fullscreen'/></span>
								</div>
	                    	</li>

					        </ul>
					      </li>
					      </ul>
				    </div>

	            </div>
                <button class="colSettingBtn" data-ng-if="component.showColumnSetting && (component.type ==='TABLE' || component.type ==='PIVOT_TABLE')"
                data-ng-click="child.openColumnSettingModal()" title="<fmt:message key='CustomReport.AddRemoveColumns'/>"><fmt:message key='CustomReport.ColumnSetting.Title'/></button>

                <div data-ng-if="component.type ==='TABLE' || component.type ==='PIVOT_TABLE' && !child.quickAnalysisMode"
                    id="{{'col_menu_' + component.id}}"
                    class="reportColums_container fadeOutSection"
                    data-ng-class="{'adminConsole':appName == 'adminconsole'}">
                    <div class="searchDiv row noLftRghtMargin">
                        <i class="col-sm-2 glyphicon glyphicon-search text-md"></i><input class="col-sm-10 noLftRghtPadding searchInput" ng-model="searchInput"  ng-model-options="{debounce: 300}" placeholder="<fmt:message key='CustomReport.Search'/>" type="text">
                    </div>
                    <ul class="colList">
                        <li class="noResultInfo" data-ng-if="child.showNoResultMsg()"><span><fmt:message key='CustomReport.NoResults'/></span></li>
                        <li class="cb_$index colBox"
                            data-ng-click="child.toggleColVisibility(col,$event)"
                            data-ng-repeat="col in component.columns | filter : searchInput | orderBy : 'displayName'"
                            data-ng-hide="col.hidden == true"><input
                            type="checkbox" id="previewTable_cb_{{$index}}"
                            class="addOrRemoveCheckBox colBox" data-ng-model="col.visible"
                            data-ng-hide="appName == 'adminconsole'" /> <i class="icon"
                            data-ng-class="{'ui-grid-icon-cancel':!col.visible , 'ui-grid-icon-ok':col.visible}"
                            data-ng-if="appName == 'adminconsole'"></i> <label class="custom-cb-label colBox" title="{{col.displayName}}" cv-report-customization
                            cv-expression="{{col.displayName}}"
                            cv-localize="true"></label></li>
                    </ul>
                </div>

				<ul data-ng-if="component.type ==='TABLE' || component.type ==='PIVOT_TABLE' || component.type === 'NEW_TABLE'"
                    id="{{'table_menu_' + component.id}}" class="reportColums_container fadeOutSection tableActions"
                    data-ng-class="{'adminConsole':appName == 'adminconsole'}">
                    <li class="col1 colBox exportToCSV" data-ng-click="exportToCSV();showTableMenu($event, component.id)"
                        data-ng-if="component.hideCsvOption != true && (component.type ==='TABLE' || component.type ==='PIVOT_TABLE' || component.type === 'NEW_TABLE') && reportMode !== 'builder'">
                        <div class="icon-export-xls menu-icons"></div>
                        <span class="custom-cb-label colBox"
                              title="<fmt:message key='CustomReport.TableMenu.ExportToCsv'/>"><fmt:message
                                key='CustomReport.TableMenu.ExportToCsv'/></span>
                    </li>
                    <li class="col1 colBox" data-ng-click="showRESTAPI();showTableMenu($event, component.id)"
                        data-ng-if="(component.type ==='TABLE' || component.type ==='PIVOT_TABLE') && reportMode == 'builder' && dataSet.endpoint != 'DATACUBE'">
                        <div class="menu-icons">
                            <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                                 xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="12px" height="12px"
                                 viewBox="0 0 522.468 522.469" style="enable-background:new 0 0 522.468 522.469;"
                                 xml:space="preserve"><g>
                                <g>
                                    <path d="M325.762,70.513l-17.706-4.854c-2.279-0.76-4.524-0.521-6.707,0.715c-2.19,1.237-3.669,3.094-4.429,5.568L190.426,440.53 c-0.76,2.475-0.522,4.809,0.715,6.995c1.237,2.19,3.09,3.665,5.568,4.425l17.701,4.856c2.284,0.766,4.521,0.526,6.71-0.712 c2.19-1.243,3.666-3.094,4.425-5.564L332.042,81.936c0.759-2.474,0.523-4.808-0.716-6.999 C330.088,72.747,328.237,71.272,325.762,70.513z"/>
                                    <path d="M166.167,142.465c0-2.474-0.953-4.665-2.856-6.567l-14.277-14.276c-1.903-1.903-4.093-2.857-6.567-2.857 s-4.665,0.955-6.567,2.857L2.856,254.666C0.95,256.569,0,258.759,0,261.233c0,2.474,0.953,4.664,2.856,6.566l133.043,133.044 c1.902,1.906,4.089,2.854,6.567,2.854s4.665-0.951,6.567-2.854l14.277-14.268c1.903-1.902,2.856-4.093,2.856-6.57 c0-2.471-0.953-4.661-2.856-6.563L51.107,261.233l112.204-112.201C165.217,147.13,166.167,144.939,166.167,142.465z"/>
                                    <path d="M519.614,254.663L386.567,121.619c-1.902-1.902-4.093-2.857-6.563-2.857c-2.478,0-4.661,0.955-6.57,2.857l-14.271,14.275 c-1.902,1.903-2.851,4.09-2.851,6.567s0.948,4.665,2.851,6.567l112.206,112.204L359.163,373.442 c-1.902,1.902-2.851,4.093-2.851,6.563c0,2.478,0.948,4.668,2.851,6.57l14.271,14.268c1.909,1.906,4.093,2.854,6.57,2.854 c2.471,0,4.661-0.951,6.563-2.854L519.614,267.8c1.903-1.902,2.854-4.096,2.854-6.57 C522.468,258.755,521.517,256.565,519.614,254.663z"/>
                                </g>
                            </g></svg>
                        </div>
                        <span class="custom-cb-label colBox"
                              title="<fmt:message key='CustomReport.TableMenu.showRestApi'/>"><fmt:message
                                key='CustomReport.TableMenu.showRestApi'/></span>
                    </li>
                    <li class="col1 colBox"
                        data-ng-click="showQuickAnalysis($event);showTableMenu($event, component.id)"
                        data-ng-if="(component.type ==='TABLE' || component.type ==='NEW_TABLE') && (!component.hideQuickAnalysisOption || component.hideQuickAnalysisOption != true) && reportMode === 'viewer'">
                        <div class="icon-quick-chart menu-icons"></div>
                        <span class="custom-cb-label colBox"
                              title="<fmt:message key='CustomReport.TableMenu.ShowQuickAnalysis'/>"><fmt:message
                                key='CustomReport.TableMenu.ShowQuickAnalysis'/></span>
                    </li>
                    <li class="col1 colBox" data-ng-click="openAlarmsDialog();showTableMenu($event, component.id)"
                        data-ng-if="component.hideAlarmOption != true && (component.type ==='TABLE' || component.type ==='PIVOT_TABLE' || component.type === 'NEW_TABLE')">
                        <div class="icon-alarm-bell sprite menu-icons"></div>
                        <span class="custom-cb-label colBox"
                              title="<fmt:message key='CustomReport.TableMenu.ConfigureAnAlert'/>"><fmt:message
                                key='CustomReport.TableMenu.ConfigureAnAlert'/></span>
                    </li>
                    <li class="col1 colBox" data-ng-click="addToDashboard();showTableMenu($event, component.id)"
                        data-ng-if="!isFullScreen && appName !== 'adminconsole' && reportMode === 'viewer' && subAppName === 'reports'">
                        <div class="icon-add-dashboard menu-icons"></div>
                        <span class="custom-cb-label colBox"
                              tooltip="<fmt:message key='CustomReport.TableMenu.AddToDashboard'/>"><fmt:message
                                key='CustomReport.TableMenu.AddToDashboard'/></span>
                    </li>
                    <li class="col1 colBox"
                        data-ng-click="makeComponentFullScreen($event);showTableMenu($event, component.id)">
                        <div class="icon-fullscreen menu-icons"></div>
                        <span class="custom-cb-label colBox"
                              title="<fmt:message key='CustomReport.TableMenu.Fullscreen'/>"
                              data-ng-disabled="reportMode == 'builder' && !component.id"><fmt:message
                                key='CustomReport.TableMenu.Fullscreen'/></span>
                    </li>
                </ul>

                <a class="compButtons"
                   data-ng-show="(component.dateRange.absolute.from!='' && component.dateRange.absolute.to!='') ||  component.dateRange.relative!=''"
                   data-ng-click="clearComponentFilters('viewer', undefined, component, undefined, 'component',component.dateRangeField)"
                   data-ng-if="component.type === 'DATE_RANGE'"><fmt:message key='CustomReport.Clear'/></a>

                <a class="compButtons"
                   data-ng-show="showFilterClearOption('viewer', component.countrycode, component, undefined, 'component')"
                   data-ng-click="clearComponentFilters('viewer', component.countrycode, component, undefined, 'component',component.countrycode)"
                   data-ng-if="component.type === 'MAP_v2' && component.inputType === 'cc'"><fmt:message
                        key='CustomReport.Clear'/></a>
                <span data-ng-if="(component.type === 'CHART' || component.type === 'HEAT_MAP' || component.type === 'SCATTER' || component.type === 'TAG_CLOUD') && !isTileBuilder">
    				<a class="compButtons"
                       data-ng-show="(showFilterClearOption('viewer', component.dimensionDataField[0], component, undefined, 'component') || (component.dimensionDataField.length===2 && showFilterClearOption('viewer', component.dimensionDataField[1], component, undefined, 'component')) || child.clearOptionEnabled)"
                       data-ng-click="clearComponentFilters('viewer', undefined, component, undefined, 'component',component.dimensionDataField[0].column)"><fmt:message
                            key='CustomReport.Clear'/></a>
				    <a class="glyphicon glyphicon-save dropdown-toggle compButtons hideOnExportFriendly show-on-hover"
                       id="dropdownMenu1" data-toggle="dropdown"
                       data-ng-show="component.type === 'CHART' || component.type === 'HEAT_MAP' || component.type === 'SCATTER'"></a>
						<ul class="dropdown-menu chart-options hideOnExportFriendly">
							<li><a data-ng-click="child.chartOptions('download')"><fmt:message
                                    key='CustomReport.DownloadChart'/></a></li>
						</ul>
					</span>
                <span data-ng-if="component.type === 'SEARCH_BAR'">
	    				<a class="compButtons"
                           data-ng-show="showFilterClearOption('viewer', tempComponent.searchField, component, undefined, 'component')"
                           data-ng-click="clearComponentFilters('viewer', undefined, component, undefined, 'component',tempComponent.searchField)"><fmt:message
                                key='CustomReport.Clear'/></a>
    				</span>


                <a data-ng-if="component.type === 'IFRAME'"
                   class="compButtons show-on-hover sprite  icon-refresh-disabled"
                   data-ng-click="reloadComponent(true)" title='<fmt:message key="CustomReport.Refresh"/>'
                   data-ng-if="!isFullScreen"></a>
                <a data-ng-if="component.type === 'IFRAME'" class="compButtons show-on-hover sprite icon-comment-edit"
                   data-ng-click="child.openFrameModal()" title='<fmt:message key="CustomReport.Edit"/>'
                   data-ng-if="!isFullScreen"></a>
                <a data-ng-if="component.type === 'IFRAME'" class="compButtons show-on-hover sprite datatype-time"
                   data-ng-click="child.setAutoRefresh()" title='Autorefresh' data-ng-if="!isFullScreen"></a>
                <a data-ng-if="component.type === 'IFRAME'"
                   class="compButtons show-on-hover sprite reports-health-detail"
                   target="{{component.id}}" href="{{child.detailUrl}}" title='Detail' data-ng-if="!isFullScreen"></a>
                <a id="kendoExportCSVIcon" data-ng-if="component.type === 'KENDO_GRID'" class ="glyphicon glyphicon-export padding-5 font-14" 
                data-ng-click="component.exportDataTableToCSV()" title="<fmt:message
                key='CustomReport.ExportToCsv'/>"></a>
                <a class="compButtons show-on-hover sprite icon-plus-disabled"
                   data-ng-click="addToDashboard()" title='Add To Dashboard'
                   data-ng-if="component.type !== 'IFRAME' && appName !== 'adminconsole' && reportMode == 'viewer' && subAppName === 'reports' && !isFullScreen && !(component.type ==='TABLE' || component.type ==='PIVOT_TABLE' )"></a>

                <span id="expandButton" data-ng-show="!isTileBuilder"
                      data-ng-if="isLayoutAvailable && !(component.type ==='TABLE' || component.type ==='PIVOT_TABLE' )"
                      class="hideOnExportFriendly">
		    				<a class="compButtons"
                               data-ng-class='{"glyphicon glyphicon-resize-full" : !isFullScreen, "btn btn-info": isFullScreen}'
                               data-ng-click="makeComponentFullScreen($event)" title="Fullscreen"
                               data-ng-if="reportMode == 'viewer'"
                               data-ng-hide="component.type === 'SEARCH_BAR' || component.type === 'DATE_RANGE'">
									<span data-ng-show="isFullScreen"><fmt:message
                                            key='CustomReport.ExitFullscreen'/></span>
								</a>
		    				<a class="compButtons"
                               data-ng-class='{"glyphicon glyphicon-resize-full" : !isFullScreen, "btn btn-info": isFullScreen}'
                               data-ng-click="makeComponentFullScreen($event)" title="Fullscreen"
                               data-ng-if="reportMode == 'builder'" data-ng-disabled="!component.id"
                               data-ng-hide="component.type === 'SEARCH_BAR' || component.type === 'DATE_RANGE'">
									<span data-ng-show="isFullScreen" style="color: white;"><fmt:message
                                            key='CustomReport.Close'/></span>
								</a>
					</span>
                <span id="expandButton" data-ng-show="!isTileBuilder"
                      data-ng-if="isFullScreen && isLayoutAvailable && (component.type ==='TABLE' || component.type ==='PIVOT_TABLE' )"
                      class="hideOnExportFriendly">
						<a class="compButtons btn btn-info" data-ng-click="makeComponentFullScreen($event)"
                           title="Fullscreen" data-ng-if="reportMode == 'viewer'">
							<span><fmt:message key='CustomReport.ExitFullscreen'/></span>
						</a>
						<a class="compButtons btn btn-info" data-ng-click="makeComponentFullScreen($event)"
                           title="Fullscreen" data-ng-if="reportMode == 'builder'" data-ng-disabled="!component.id">
							<span style="color: white;"><fmt:message key='CustomReport.Close'/></span>
						</a>
					</span>
                <button data-ng-if="component.type=='FACET' && component.isEnableFieldVisibilityOption()"
                        data-ng-class="{'icon-add-col': !component.showFilterSetting,'addFilterBtn':component.showFilterSetting}" class="compButtons" data-ng-click="component.showFilterSetting ? component.openFilterSettingModal() : component.showOrHideFieldsMenu($event)"
                        title="<fmt:message key='CustomReport.AddRemoveColumns'/>">{{component.showFilterSetting ? "<fmt:message key='CustomReport.FilterSetting.AddFilter'/>" : ""}}</button>

                <div data-ng-if="component.type ==='FACET'" id="{{'fieldMenu' + component.id}}"
                    class="reportColums_container facetFieldMenu">
                    <div class="searchDiv row noLftRghtMargin">
                        <i class="col-sm-2 glyphicon glyphicon-search text-md"></i><input class="col-sm-10 noLftRghtPadding searchInput" ng-model="searchInput"  placeholder="<fmt:message key='CustomReport.Search'/>" type="text">
                    </div>
                    <ul>
                        <li data-ng-if="component.showNoResultMsg()" class="noResultInfo"><span><fmt:message key='CustomReport.NoResults'/></span></li>
                            <div class="fieldList" data-ng-repeat="(dataSetName,filterFields) in component.filterDataField[component.filterMode]">
                                <li data-ng-repeat="field in filterFields.fields | filter : searchInput | orderBy : 'column'">
                                    <input class="cursor-pointer" type="checkbox"

                                                                                         data-ng-checked="field.isVisible"
                                                                                         data-ng-model="field.isVisible"
                                                                                         data-ng-click="$event.stopPropagation()"
                                                                                         data-ng-change="component.showOrHideFilterField(dataSetName,field)"
                                                                                         id="chkbx{{component.id + field.column + $index}}"/>
                                    <label class="menuFieldlabel cursor-pointer" data-ng-click="$event.stopPropagation()"
                                           for="chkbx{{component.id + field.column + $index}}">{{field.displayName}}</label>
                                </li>
                            </div>
                    </ul>
                </div>
                <span data-ng-if="reportMode == 'builder'">
						<a class="compButtons sprite reports-actions-downarrow"
                           data-ng-class="{'actionDisabled':$index==reportComponents.length -1 || !component.isSelected}"
                           data-ng-click="moveComponent($index, 'DOWN')"
                           title="<fmt:message key='CustomReport.MoveDown'/>"
                           data-ng-if="!isDcubeEnabledInCustomReports"></a>
    				<a class="compButtons sprite reports-actions-uparrow"
                       data-ng-class="{'actionDisabled': $index ==0 || !component.isSelected}"
                       data-ng-click="moveComponent($index,'UP')" title="<fmt:message key='CustomReport.MoveUp'/>"
                       data-ng-if="!isDcubeEnabledInCustomReports"></a>
    				<a data-ng-if="!isTileBuilder || (isTileBuilder && component.type === 'PANEL')"
                       class="compButtons sprite  reports-actions-xbutton"
                       data-ng-click="deleteComponent($index,panelComponentIndex,tabData,$event)"
                       title='<fmt:message key="CustomReport.DeleteComponent"/>' data-ng-if="!isFullScreen"></a>
					</span>
                <a data-ng-if="component.type === 'IFRAME' && reportMode !== 'builder'"
                   class="compButtons show-on-hover sprite  reports-actions-xbutton"
                   data-ng-click="deleteComponent($index,panelComponentIndex,$event)"
                   title='<fmt:message key="CustomReport.DeleteComponent"/>' data-ng-if="!isFullScreen"></a>
            </div>
            <div class="component-actions" data-ng-if="!component.showAsSearchResults"
                 data-ng-hide="component.collapsed">
                <a class="compButtons hideOnExportFriendly"
                   data-ng-if="(component.type ==='TABLE' || component.type ==='PIVOT_TABLE' || component.type === 'NEW_TABLE') && child.quickAnalysisMode"
                   data-ng-click="child.showQuickAnalysis($event)"
                   title="<fmt:message key='CustomReport.GoBackFromQuickAnalysis'/>"><fmt:message
                        key='CustomReport.GoBackFromQuickAnalysis'/></a>
            </div>
        </div>

        <div class="component-body component-body-gridster" data-ng-hide="component.collapsed" data-ng-class="{'full-height': component.type != 'SEARCH_BAR' && component.type != 'DATE_RANGE' && component.type!='TABLE' && component.type !='NEW_TABLE', 'full-height-excluding-title': component.type=='DATE_RANGE' || component.type=='TABLE' || component.type =='NEW_TABLE', 'compScrollStyle' : component.type === 'FACET' &&  component.showOnlyBasicFilter}">
           <div data-ng-if="component.type=='TABLE'" class="full-height">
                <div data-ng-if="cv.additionalSettings.Console.replaceNewTable" data-cv-table class="full-height"></div>
                <cvnewtable data-ng-if="!cv.additionalSettings.Console.replaceNewTable" class="full-height"></cvnewtable>
            </div>

            <div data-ng-if="component.type=='PIVOT_TABLE' && cv.additionalSettings.Console.replaceNewTable" class="full-height">
                <div data-cv-table class="full-height"></div>
            </div>

            <div data-ng-if="component.type=='PIVOT_TABLE' && !cv.additionalSettings.Console.replaceNewTable" class="full-height">
                <cvnewtable class="full-height"></cvnewtable>
            </div>

            <div data-ng-if="component.type=='KENDO_GRID'" class="full-height">
                <cvkendogrid></cvkendogrid>
            </div>
            <div data-ng-if="component.type=='NEW_TABLE'" class="full-height">
                <cvnewtable></cvnewtable>
            </div>
            <div data-ng-if="component.type=='KENDO_TREEGRID'" class="full-height">
                <cvkendotree></cvkendotree>
            </div>

            <div data-ng-if="(component.type=='CHART' || component.type=='HEAT_MAP') && component.chartType !== 'TileStatusChart'"
                 class="full-height">
                <cvchart data-type="{{component.chartType}}" class="full-height"></cvchart>

            </div>

            <div data-ng-if="component.type=='CHART' && component.chartType === 'TileStatusChart'" class="full-height">
                <tile-status-chart class="full-height"></tile-status-chart>
            </div>

            <div data-ng-if="component.type=='TAG_CLOUD'" class="full-height">
                <cvtagcloud></cvtagcloud>
            </div>

            <div data-ng-if="component.type=='CUSTOM'">
                <div data-cv-custom-component class="full-height"></div>
            </div>

            <div data-ng-if="component.type=='LEGEND'">
                <div data-cv-legend-component></div>
            </div>

            <div data-ng-if="component.type=='MAP_v2' || component.type=='MAP'" class="full-height">
                <cv-map></cv-map>
            </div>

            <div data-ng-if="component.type=='SCATTER'" class="full-height">
                <scatter-chart data-type="scatter" class="full-height"></scatter-chart>
            </div>

            <div data-ng-if="component.type=='SEARCH_BAR'" class="full-height">
                <cvsearchbar></cvsearchbar>
            </div>
            <div data-ng-if="component.type=='DATE_RANGE'" class="full-height">
                <cvdaterange></cvdaterange>
            </div>
            <div data-ng-if="component.type=='HITS'" class="full-height">
                <cvhits></cvhits>
            </div>
            <div data-ng-if="component.type=='FACET'" class="full-height">
                <cvfacet config="component" type="'component'" page="page" filters="page.body.filters"
                         filter-mode="'viewer'" report-mode="reportMode" get-data="getData()"
                         set-all-components-intialized="setAllComponentsIntialized(component)"></cvfacet>
            </div>

            <div data-ng-if="component.type=='PANEL_HEADER'" class="full-height">
                <cvpanel></cvpanel>
            </div>
            <div data-ng-if="component.type=='PANEL'" class="full-height">
                <div cv-panel-component class="full-height"></div>
            </div>

            <div data-ng-if="component.type=='R-GGPlot'" class="full-height">
                <rggplot></rggplot>
            </div>

            <div data-ng-if="component.type=='IFRAME'" class="full-height">
                <cv-frame></cv-frame>
            </div>

            <div data-ng-if="component.type== 'TABS'" class="full-height">
                <cv-tabs></cv-tabs>
            </div>
            <div data-ng-if="component.type== 'TOPOLOGY'" class="full-height">
                <topology-chart></topology-chart>
            </div>

        </div>
        <div class="buttonPanel"
             data-ng-if="component.type=='TABLE' && component.enableButtonPanel && !component.collapsed && component.showButtonsAtBottom"
             data-ng-class="{'bottom-button-panel': component.shared}">
            <ul>
                <li data-ng-repeat="button in component.buttons"
                    data-ng-click="setActiveComponent({type:'button',comp:button},'undefined',$event)">
                    <button id="{{button.id}}" class="btn {{button.class}}"
                            data-ng-class="{'default-button': !button.class}" title="{{button.toolTip}}"
                            data-ng-click="evalButtonExpression($event,button.clickExpression)"
                            ng-dblclick="evalButtonExpression($event,button.clickExpression)"
                            cv-tag-attributes="{{button.buttonAttributes}}" cv-report-customization
                            data-ng-disabled="!buttonStates[$index]"
                            data-ng-init="buttonStates[$index] = evalButtonState(button)">
                        <img ng-attr-src="{{button.imageType == 'url' ? button.imageValue : ''}}"
                             data-ng-if="button.imageType == 'url'">
                        <span class="customIcon" data-ng-if="button.imageType == 'custom'"
                              ng-bind-html="button.imageValue"></span>
                        <span cv-report-customization cv-expression="{{button.title.text}}" cv-localize="true"></span>
                    </button>
                </li>
                <li data-ng-show="reportMode == 'builder'" data-ng-init="upgradeButtons()">
                    <button class="btn ng-binding" data-ng-click="addButton()" title="Add New Button">
                        <span class="sprite reports-actions-addpage"></span>
                    </button>
                </li>
            </ul>
        </div>
    </div>
</fmt:bundle>