<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.ReportsPlusMessages">
<div ng-controller="tileStatusChartCtrl" class="maskLayer full-height" data-ng-class="{'isMasked':masked}">
<div class="chartArea full-height tileStatusChartArea" id="chart_{{$index}}">
	<label class='maskLayerLabel hideOnExportFriendly' data-ng-show="masked" ><fmt:message key="CustomReport.Loading"/></label>
	<div class="clearFloat"></div>
	<div class="yAxisColGroup" data-ng-show="reportMode == 'builder'">
		<fieldset class="axisColumnDrop ng-isolate-scope" data-tile-component-type="{{component.tileCompType}}" data-ng-class="{'disableColumnDrop':  !component.isSelected}" x-lvl-drop-target="true" data-droptype="nameColumn" x-on-drop="dropped(dragEl, dropEl)">
				<legend class="fieldsetLegend ng-binding"><fmt:message key="CustomReport.DropStatusNameColumn"/></legend>	
				<div class="chartColumns">
	 				<label> {{component.tileData.nameColumn}}</label>
	        	<span data-ng-if="component.tileData.nameColumn!= undefined" class="deleteColumn" data-ng-click="deleteColumn('nameColumn')">&times;</span>
				</div>
		</fieldset>

		<fieldset class="axisColumnDrop ng-isolate-scope" data-tile-component-type="{{component.tileCompType}}" data-ng-class="{'disableColumnDrop':  !component.isSelected}" x-lvl-drop-target="true" data-droptype="idColumn" x-on-drop="dropped(dragEl, dropEl)">
				<legend class="fieldsetLegend ng-binding"><fmt:message key="CustomReport.DropStatusIdColumn"/></legend>	
				<div class="chartColumns">
	 				<label> {{component.tileData.idColumn}}</label>
	        	<span  data-ng-if="component.tileData.idColumn!= undefined"  class="deleteColumn" data-ng-click="deleteColumn('idColumn')">&times;</span>
				</div>
		</fieldset>
				
		<fieldset class="axisColumnDrop ng-isolate-scope" data-tile-component-type="{{component.tileCompType}}" data-ng-class="{'disableColumnDrop':  !component.isSelected}" x-lvl-drop-target="true" data-droptype="valueColumn" x-on-drop="dropped(dragEl, dropEl)">
				<legend class="fieldsetLegend ng-binding"><fmt:message key="CustomReport.DropValueColumn"/></legend>	
				<div class="chartColumns">
	 				<label> {{component.tileData.valueColumn}}</label>
	        	<span  data-ng-if="component.tileData.valueColumn!= undefined"  class="deleteColumn" data-ng-click="deleteColumn('valueColumn')">&times;</span>
				</div>
		</fieldset>
		
	</div>	
	<div class="clearFloat"></div>
	
	<div class="tileLabels" >
		<p data-ng-repeat="label in otherData"> {{label.name}}:  {{label.value}} </p>
	</div>
			
	<div class="noChartDiv"  data-ng-show="isShowNoChartDiv()" data-ng-click="setActiveComponent()">
		<label data-ng-show="componentLoaded && !component.isChartExist "><fmt:message key="CustomReport.NoDataAvailable"/></label>
	</div>
	
	<div class="tileStatusChartWrapper">
		<div  class="tileStatusDonut" data-ng-repeat="cData in chartData" > 	
			<div  data-ng-controller="tileSolidDonutController">
				<highchart    config="chartConfig">	</highchart>
				<div class="donutLabel">{{cData.name}}</div>
			</div>	
		</div>
	</div>	
		
	<div class="clearFloat"></div>
  </div>
  </div>
</fmt:bundle>

<fmt:bundle basename="localization.SurveyMessages">
	<fmt:message key="CriticalStatus" var="criticalStatus" />
	<fmt:message key="WarningStatus" var="warningStatus" />
	<fmt:message key="GoodStatus" var="goodStatus" />
	<fmt:message key="UnknownStatus" var="unknownStatus" />
</fmt:bundle>

<script nonce="${sessionScope.cspNonce}"  type="text/javascript">
	var localMsg = localMsg || {};
	localMsg.criticalStatus="${criticalStatus}";
	localMsg.warningStatus="${warningStatus}";
	localMsg.goodStatus="${goodStatus}";
	localMsg.unknownStatus="${unknownStatus}";
</script>
