<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<script type="text/javascript" nonce="${sessionScope.cspNonce}" >
      var localMsg = localMsg || {};
      localMsg.customReport = localMsg.customReport || {};
      localMsg.customReport.updateSecuritySuccess = '<fmt:message key="successfully.updated.security.associations" />';
	  localMsg.customReport.handlerSecurityUpdateFailed = '<fmt:message key="handler.security.update.failed" />';
      localMsg.customReport.canView = '<fmt:message key="CustomReport.Security.CanView"/>';
      localMsg.customReport.canEdit = '<fmt:message key="CustomReport.Security.CanEdit"/>';
      localMsg.customReport.canQuery = '<fmt:message key="CustomReport.Security.CanQuery"/>';
	</script>
	<div id="entity-security-modal" cv-draggable drag-handler=".modal-header" drag-parent=".modal-dialog" class="security-modal" data-ng-class="{'show-scrollbar': updateSecurityRequest.securityAssociations.associations.length >= 10}">
		<div class="setup-title" data-ng-class="{'modal-header': appName !== 'adminconsole'}">
				<%--<button type="button" class="close" data-ng-click="$close()" data-dismiss="modal">&times;</button>--%>
			<h4><fmt:message key="CustomReport.Security"/> - {{entity.entityName}}</h4>
		</div>
		<div class="setup-content" data-ng-class="{'modal-body': appName !== 'adminconsole'}">
			<div id="searchContainer" class="inputAreaDivs inline-display">
				<div class="search-results-container">
					<div class="selected-users-container">
						<div class="user-add" data-ng-repeat="user in selectedUsers track by $index" data-user-type="{{user.userInfo.userType}}"  data-loginname="{{user.name}}">
							<span class="text-user-select">{{user.displayName}} ({{user.loginName}})</span>
							<span class="deleteItem xButton user-column" data-ng-click="deleteUser($index,user)">&times;</span>
						</div>
					</div>
					<div class="search-text-input">
						<input type="text" id="field" name="field" placeholder="Enter Username, Email Address or Group Name(s)." data-ng-model="usearSearechText" data-ng-keyup="searchUsersList()" data-ng-class="{'loading':searchInProgress}">
					</div>
				</div>

				<div class="btn-group inline-display user-actions" uib-dropdown >
					<button id="single-button" type="button" class="btn" uib-dropdown-toggle>
						<!-- <span class="permissions-label">{{getPermissionsString(currentPermissionsList)}}</span><span class="caret"></span> -->
						<span class="permissions-label"><fmt:message key="CustomReport.Security.Permissions"/></span><span class="caret"></span>
					</button>
					<ul class="dropdown-menu user-actions-menu" uib-dropdown-menu role="menu" aria-labelledby="single-button">
						<li class="user-action-item"  role="menuitem" data-ng-repeat="permission in currentPermissionsList" >
							<input id="user-permission-{{$index}}" class="user-action-item-check"  type="checkbox" name="user-radio-{{$index}}" checklist-model="selPermissions.selectedPermissions"  checklist-value="permission"/>
							<label for="user-permission-{{$index}}" class="checkbox-label">
								<span tooltip-placement="top" uib-tooltip="{{permission.permissionDesc}}">
									{{permission.permissionName}}
								</span>
							</label>
						</li>
					</ul>
				</div>
				<div id="addUserButton" class="inline-display" data-ng-click="addUsersToSecurity()">
					<span data-ng-if="appName !== 'adminconsole'" class="sprite icon-add_20" title="Add Users" ></span>
					<i data-ng-if="appName === 'adminconsole'" class="glyphicon glyphicon-plus"></i>
				</div>
				<div class="search-results" data-ng-if="showSearchresults">
						<ul class="search-results-list">
							<li class="search-result" data-ng-repeat="userItem in userSearchResults track by $index" data-ng-click="addUserToList(userItem)">
								<span class="user-icon " data-ng-class="{'sprite icon-user': appName !== 'adminconsole' && (userItem.entityType === 3 || userItem.entityType === 4) ,'sprite icon-group': appName !== 'adminconsole' && (userItem.entityType === 1 || userItem.entityType === 2) ,'user-type': appName === 'adminconsole' && (userItem.entityType === 3 || userItem.entityType === 4) ,'group-type': appName === 'adminconsole' && (userItem.entityType === 1 || userItem.entityType === 2)}"></span><span class="suggestedText vw-text">{{userItem.displayName}} ({{userItem.loginName}})</span>
							</li>
						</ul>
			    </div>
			</div>
			<div class="associated-user-list-info">
			<div class="user-info" data-ng-repeat="association in updateSecurityRequest.securityAssociations.associations" data-ng-if="showAssociation(association)" data-ng-init="assocIndex = $index">
				<div class="user-row">
					<span class="user-icon " data-ng-class="{'sprite icon-user': appName !== 'adminconsole' && association.userOrGroup[0]['_type_'] == 13,'sprite icon-group': appName !== 'adminconsole' && association.userOrGroup[0]['_type_'] !== 13,'user-type': appName === 'adminconsole' && association.userOrGroup[0]['_type_'] == 13,'group-type': appName === 'adminconsole' && association.userOrGroup[0]['_type_'] !== 13}"></span>
					<ul class="user-container">
						<li>{{getAssociationName(association)}}</li>
						<li data-ng-if="association.properties.isCreatorAssociation === false" class="user-permissions">
							{{getPermissionsString(association)}}
						</li>
					</ul>
					<div class="user-assocations" data-ng-if="association.properties.isCreatorAssociation === true">
						<div class="user-assocations-dropdown user-column owner-column">
							<label><fmt:message key="CustomReport.Security.Owner"/></label>
						</div>
					</div>
					<div class="user-assocations" data-ng-if="!association.properties.isCreatorAssociation">
						<div class="btn-group inline-display user-row-actions" uib-dropdown>
							<button id="user-action-button-{{association.userOrGroup[0].userId}}" type="button" class="btn btn-link" uib-dropdown-toggle ng-disabled="disabled">
								<span class="permissions-label"><fmt:message key="CustomReport.Security.Permissions"/></span> <span class="caret"></span>
							</button>
							<ul class="dropdown-menu user-actions-menu" uib-dropdown-menu role="menu" aria-labelledby="user-action-button-{{association.userOrGroup[0].userId}}">
								<li role="menuitem" data-ng-repeat="permission in currentPermissionsList" >
									<input id="user-check-{{assocIndex}}-{{$index}}" type="checkbox" name="user-radio-{{$index}}" checklist-model="association.properties.categoryPermission.categoriesPermissionList" ng-checked="isChecked(permission, association)" checklist-value="permission" ng-click="check(permission,association,checked)" />
									<label for="user-check-{{assocIndex}}-{{$index}}" class="checkbox-label">
										<span tooltip-placement="top" uib-tooltip="{{permission.permissionDesc}}">
											{{permission.permissionName}}
										</span>
									</label>
								</li>
							</ul>
						</div>
						<span tooltip-placement="left" uib-tooltip="Delete {{getAssociationName(association)}} Association and Permissions">
						<div class="deleteItem xButton user-column" data-ng-click="removeUser($index)">&times;</div>
						</span>
					</div>
				</div>
			</div>
			<span data-ng-show="isLoading" class="grid-data-spinner">
					<img data-ng-if="appName === 'adminconsole'" src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
					<img data-ng-if="appName !== 'adminconsole'" src="${pageContext.request.contextPath}/common/css/images/loading.gif">
					<label><fmt:message key="CustomReport.Security.LoadingAssociations"/></label>
			</span>

			</div>
			<div class="button-container" data-ng-class="{'modal-footer': appName !== 'adminconsole'}">
				<button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="$close()"><fmt:message key="CustomReport.Cancel"/></button>
				<button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-class="{'btn-disabled': !hasChanges}" data-ng-click="updateSecurityAssociations()"><fmt:message key="CustomReport.Update"/></button>
			</div>
		</div>
	</div>
</fmt:bundle>
