(function() {
	"use strict";

	var app = angular.module("reports");

	// Controller for "Add Data Set" modal
	app.controller("insertVariableCtrl", [
			"$scope",
			"$uibModalInstance",
			"customReportSvc",
			"page",
			"component",
			"modalParams",
			function($scope, $modalInstance, customReportSvc, page, component, modalParams) {

				$scope.page = page;

				//$scope.variables = {input:$scope.page.inputs,system:customReportSvc.sharedData.systemVariables}; // will add the system variables on the insert screen  if needed.
				//$scope.variables = {input:$scope.page.inputs,system:customReportSvc.sharedData.systemVariables}; // will add the system variables on the insert screen  if needed.
				if (modalParams.entityToAdd === "parameter" || component.type === 'IFRAME') {
					$scope.variables = {
						input : $scope.page.inputs
					};
				} else if (modalParams.entityToAdd === "input") {
					if (component.type === 'CHART') {
						var cols = [];
						for (var i = 0; i < component.dimensionDataField.length; i++) {
							cols.push({
								id : component.dimensionDataField[i].column
							});
						}

						if (component.measureDataField.length === 1) {
							var aggrType = component.measureDataField[0].aggrType;
							var key = component.measureDataField[0].column;
							if (aggrType.toLowerCase() !== "none") {
								key = aggrType + "(" + key + ")"
							}
							cols.push({
								id : key
							});
						} else if (component.measureDataField.length > 1) {
							cols.push({
								id : "aggregateName"
							});
							cols.push({
								id : "aggregateValue"
							});
						}

						$scope.variables = {
							row : cols
						}
					} else {

						$scope.variables = {
							//row : modalParams.row
							row : component.columns
						// this is a placeholder, fix later
						};
					}
				} else if (_.indexOf([ 'nodes', 'edges' ], modalParams.entityToAdd) > -1) {
					$scope.variables = {
						row : component.topologyProps[modalParams.entityToAdd].dataSet.fields
					}
					angular.forEach($scope.variables.row, function(row) {
						row.id = row.dataField;
					})
				} else if (modalParams.entityToAdd === "selectedRow") {
					$scope.variables = {
						selectedRow : component.columns
					}
				}

				var root = [];
				angular.forEach($scope.variables, function(val, key) {
					var child = {};
					child.label = key;
					child.state = 'expanded';
					root.splice(0, 0, child);
					if (val != undefined && val.length > 0) {
						child.children = [];
						angular.forEach(val, function(val2) {
							var cc = {};
							cc.label = val2.id;
							cc.isLeaf = true;
							child.children.push(cc);
						});
					}
				});

				$scope.selectedItems = [];
				$scope.treeParent = root;
				$scope.insertVariable = function() {
					$modalInstance.close($scope.selectedItems);
				};

			} ]);

})();