// Closure to isolate scope, as per best practices
(function() {
	"use strict";

	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");

	// Controller for "Add Data Set" modal
	app
			.controller("reportInputModalCtrl",
					[
							"$scope",
							"$uibModalInstance",
							"customReportSvc",
							"treeNode",
							"reportService",
							"page",
							"builderVersion",
							"mergedParams",
							"cacheId",
							function($scope, $modalInstance, customReportSvc, treeNode, reportService, page,
									builderVersion, mergedParams, cacheId) {
								$scope.mergedParams = mergedParams;
								$scope.builderVersion = builderVersion;
								$scope.cacheId = cacheId;
								$scope.page = page;
								$scope.inputs = [];
								$scope.dependentInputs = [];
								$scope.addDisabled = true;
								$scope.dependsOnSettings = {
									showCheckAll : false,
									showUncheckAll : false,
									smartButtonMaxItems: 3,
									externalIdProp : 'id',
									displayProp : 'displayName'
								};
								$scope.eventSettings={
									  onItemSelect: function (item) {
										  $scope.currentInput.dependsOn.push(item.id);
									  },
									  onItemDeselect : function(item){
										  let index = $scope.currentInput.dependsOn.indexOf(item.id);
										  $scope.currentInput.dependsOn.splice(index, 1);
										  console.log($scope.currentInput.dependsOn);
									  }
								}
								$scope.possibleOptions = [];
								if ($scope.page.inputs) {
									angular.copy($scope.page.inputs, $scope.inputs);
									for(var i=0 ;i < $scope.page.inputs.length ; i++){
										let  input = $scope.page.inputs[i];
										$scope.dependentInputs.push({
											id : input.id,
											displayName : input.displayName
										});
									}
									angular.forEach($scope.page.inputs, function(input, i) {

									});
								}

								$scope.inputTypes = [
										"Date",
										"DateRange",
										"Decimal",
										"Integer",
										"String",
										"Time",
										"Commcell",
										"CommcellEntity" ];
								$scope.commcellEntityTypes = [ {
									"entityTypeName" : "Client",
									"entityTypeId" : 3
								}, {
									"entityTypeName" : "Client Group",
									"entityTypeId" : 28
								}, {
									"entityTypeName" : "Data Source",
									"entityTypeId" : 132
								}, {
									"entityTypeName" : "Governance Project",
									"entityTypeId" : 188
								} ];

								$scope.allControlTypes = [
										"CheckBox",
										"DropDown",
										"DatePicker",
										"DateTimePicker",
										"DateRange",
										"Hidden",
										"ListBox",
										"RadioButton",
										"TextBox",
										"TextArea",
										"ToggleBox",
										"TimePicker",
										"Slider" ];

								$scope.controlTypes = [
										"TextBox",
										"TextArea",
										"Hidden",
										"DropDown",
										"ListBox",
										"RadioButton",
										"CheckBox",
										"TimePicker",
										"ToggleBox",
										"DatePicker",
										"DateTimePicker",
										"DateRange",
										"Slider" ];

								$scope.initControlType = function() {
									if ($scope.currentInput.controlType === 'ToggleBox' &&
											!$scope.currentInput.possibleValues) {
										$scope.currentInput.possibleValues = [];
									}
								}

								$scope.setDefaultRelativeOptions = function() {
									if ($scope.currentInput.relativeOptions) {
										_.map($scope.currentInput.relativeOptions, function(val) {
											$scope.updateDefaultRelativeOpts(val, true, true);
										});
									}

									if ($scope.currentInput.relativeUnits) {
										_.map($scope.currentInput.relativeUnits, function(val) {
											$scope.updateDefaultRelativeUnitOpts(val, true, true);
										});
									}

									if ($scope.currentInput.possibleValues && $scope.currentInput.possibleValueLabels) {
										var values = _.map($scope.currentInput.possibleValues, function(val) {
											return {
												value : val,
												labelLocalized: customReportSvc.getRelativeLabel(val)
											};
										});
										var labels = _.map($scope.currentInput.possibleValueLabels, function(val) {
											return {
												label : val
											};
										});

										$scope.possibleOptions = _.merge(values, labels);
									}

									$scope.changeRelativeUnits($scope.relativeOpts[0]);
									$scope.updateRelativeOptions();
								}

								$scope.updateDeaultRelativeValue = function(option, unit, value) {
									$scope.currentInput.defaultValue = $scope.getRelativeValue(option, unit, value);
								}

								$scope.getRelativeValue = function(option, unit, value) {
									// construct value like -P7D P0d
									var addString = option === '-R' ? "R0"+unit : "P0D";
									var addFirst = option === 'P' ? true : false;
									option = (unit === 'm' || unit === 'H') ? option + 'T' : option;
									option = option + value + unit;
									if (!addFirst) {
										option = option + ' ' + addString;
									} else {
										option = addString + ' ' + option;
									}

									return option;
								}

								$scope.defaultRelativeOpts = [ {
									label : 'Last',
									localizedLabel : localMsg.customReport.Last,
									value : '-P'
								}, {
									label : 'Next',
									localizedLabel : localMsg.customReport.Next,
									value : 'P'
								}, {
									label : 'Previous',
									localizedLabel : localMsg.customReport.Previous,
									value : '-R'
								} ];

								$scope.relativeOpts = [];
								$scope.relativeUnits = [];

								//Used to map the selection from defaultRelativeUnits to its values.Label should be same as elements in defaultRelativeUnits.
								$scope.defaultRelativeUnitOpts = [ {
									label : 'Minutes' ,
									singularLabel : localMsg.customReport.Minute,
									pluralLabel : localMsg.customReport.Minutes,
									value : 'm'
								}, {
									label : 'Hours',
									singularLabel : localMsg.customReport.Hour,
									pluralLabel : localMsg.customReport.Hours,
									value : 'H'
								}, {
									label : 'Days',
									singularLabel : localMsg.customReport.Day,
									pluralLabel : localMsg.customReport.Days,
									value : 'D'
								}, {
									label : 'Weeks',
									singularLabel : localMsg.customReport.Week,
									pluralLabel : localMsg.customReport.Weeks,
									value : 'W'
								}, {
									label : 'Months',
									singularLabel : localMsg.customReport.Month,
									pluralLabel : localMsg.customReport.Months,
									value : 'M'
								}, {
									label : 'Quarters',
									singularLabel : localMsg.customReport.Quarter,
									pluralLabel : localMsg.customReport.Quarters,
									value : 'Q'
								},{
									label : 'Years',
									singularLabel : localMsg.customReport.Year,
									pluralLabel : localMsg.customReport.Years,
									value : 'Y'
								} ];

								//Populating 'Allowed units' under customization of DateRange Input modal
								$scope.defaultRelativeUnits = [ {
									label : 'Minutes' ,
									value : localMsg.customReport.Minutes
								}, {
									label : 'Hours',
									value : localMsg.customReport.Hours
								}, {
									label : 'Days',
									value : localMsg.customReport.Days
								}, {
									label : 'Weeks',
									value : localMsg.customReport.Weeks
								}, {
									label : 'Months',
									value : localMsg.customReport.Months
								}, {
									label : 'Years',
									value : localMsg.customReport.Years
								} ];

								$scope.defaultRelativeOptions = [ {
									label : localMsg.customReport.LastN,
									value : 'Last'
								}, {
									label : localMsg.customReport.NextN,
									value : 'Next'
								}, {
									label : localMsg.customReport.PreviousN,
									value : 'Previous'
								}, {
									label : localMsg.customReport.CustomRange,
									value : 'Custom'
								} ];

								//Creates the default 'Possible Value' under customization of DateRange Input modal
								$scope.updateRelativeOptions = function() {
									$scope.model = {};
									$scope.model.relFrequency = $scope.relativeOpts[0];
									$scope.model.relUnit = $scope.relativeUnits[0];
									$scope.relValue = 1;
								}

								$scope.hiddenLabelsForPrevious = ["Hours","Minutes"]; //The order of items should be kept the same. Will affect the order of insertion into $scope.defaultRelativeUnits
								$scope.removeRelativeUnits = function (relativeUnit){
									if( $scope.hiddenLabelsForPrevious.includes(relativeUnit.label) )
											return true;
								}
								$scope.updateDefaultRelativeOpts = function(value, checked, init) {
									if (value == 'Custom') {
										return;
									}

									var opt = _.find($scope.defaultRelativeOpts, {
										'label' : value
									});

									if (checked) {
										$scope.relativeOpts.push(opt);
										if(value=="Previous"){
											var optionQuarter = _.find($scope.defaultRelativeUnitOpts, {
												label : "Quarters"
											});
											var optionQuarterIndex = -1;
											$scope.defaultRelativeUnits.splice(optionQuarterIndex,0,{label: optionQuarter.label, value: optionQuarter.pluralLabel});
										}else{
											var hourExist = _.find($scope.defaultRelativeUnits, {
												label: "Hours"
											});
											if(!hourExist){
												for (var hiddenLabel of $scope.hiddenLabelsForPrevious){
													var option = _.find($scope.defaultRelativeUnitOpts, {
														label : hiddenLabel
													});
													$scope.defaultRelativeUnits.unshift({label: option.label, value: option.pluralLabel});
												}
											}	
										}
									} else {
										_.remove($scope.relativeOpts, {
											label : value
										});
										if(value=="Previous"){
											_.remove($scope.defaultRelativeUnits,{
												label : "Quarters"
											});
										}
										else{
											var relUnitExist;
											for(var relUnit of $scope.relativeOpts){
												if(relUnit.label=="Next" || relUnit.label=="Last"){
													relUnitExist=true;	
													break
												}
											}
											if( !relUnitExist ){
												_.remove($scope.defaultRelativeUnits,$scope.removeRelativeUnits);
											}
										}
									}

									if (!init) {
										$scope.updateRelativeOptions();
										$scope.changeRelativeUnits($scope.model.relFrequency,$scope.model.relUnit);
									}
								}

								$scope.updateDefaultRelativeUnitOpts = function(value, checked, init) {
									var opt = _.find($scope.defaultRelativeUnitOpts, {
										'label' : value
									});

									if (checked) {
										$scope.relativeUnits.push(opt);
									} else {
										_.remove($scope.relativeUnits, {
											label : value
										});
									}
									if (!init) {
										$scope.model.relUnit = $scope.relativeUnits[0];
										setTimeout(function(){ //Enclosed in timeout to account for the latency of updation of 'currentInput.relativeUnits'
											$scope.changeRelativeUnits($scope.model.relFrequency,$scope.model.relUnit)
										},10);
									}
								}

								$scope.relativeOptFilter = function() {
									return function(item) {
										return $scope.currentInput.relativeOptions.indexOf(item.label) !== -1;
									}
								}

								$scope.relativeUnitFilter = function() {
									return function(item) {
										return $scope.currentInput.relativeUnits.indexOf(item.label) !== -1;
									}
								}

								//Function for creating a sync between dropdown values. Should be called after updating allowed Time units & Options.
								//Time unit 'Hours' and 'Minutes' can't be associated with 'Previous'
								//Time unit 'Quarters' can be only associated with 'Previous'
								$scope.changeRelativeUnits = function(relOption,relUnit){
									var reloadRequired = false;
									if(!relOption){
										return;
									}
									if(relOption.label == "Previous"){
										_.remove($scope.relativeUnits,$scope.removeRelativeUnits);
										if(relUnit && relUnit.label && $scope.hiddenLabelsForPrevious.includes(relUnit.label)){
											reloadRequired = true;
										}
										var quarterLabelExist = _.find($scope.relativeUnits, {
											label: "Quarters"
										});
										if(!quarterLabelExist ){
											var optionQuarter = _.find($scope.defaultRelativeUnitOpts, {
												label : "Quarters"
											});
											var optionQuarterIndex = -1;
											if( $scope.currentInput.relativeUnits.includes(optionQuarter.label) ){
												$scope.relativeUnits.splice(optionQuarterIndex,0,optionQuarter);
											}
										}
									}else{
										_.remove($scope.relativeUnits,{
											label : "Quarters"
										});
										if(relUnit && relUnit.label == "Quarters"){
											reloadRequired = true;
										}
										for (var hiddenLabel of $scope.hiddenLabelsForPrevious){
											if($scope.currentInput.relativeUnits.includes(hiddenLabel)){
												var hiddenLabelExist = _.find($scope.relativeUnits, {
													label: hiddenLabel
												});
												if(!hiddenLabelExist ){
													var option = _.find($scope.defaultRelativeUnitOpts, {
														label : hiddenLabel
													});
													$scope.relativeUnits.unshift(option);
												}
											}
										}
									}
									if(reloadRequired){
										$scope.model.relUnit = $scope.relativeUnits[0];
									}
								}
								$scope.addRelativeOption = function(relOpt, relUnit, relValue) {
									var relaValue = $scope.getRelativeValue(relOpt.value, relUnit.value, relValue);
									var relalabel = relOpt.label + " " + relValue + " " + relUnit.label;
									var relaLocalizedLabel = relOpt.localizedLabel + " " + relValue + " ";
									relaLocalizedLabel += relValue == 1 ? relUnit.singularLabel : relUnit.pluralLabel;
									if (!$scope.currentInput.possibleValues) {
										$scope.currentInput.possibleValues = [];
									}

									if (!$scope.currentInput.possibleValueLabels) {
										$scope.currentInput.possibleValueLabels = [];
									}

									if ($scope.currentInput.possibleValues.indexOf(relaValue) !== -1) {
										customReportSvc.errorToast('Value already exists');
										return;
									}

									$scope.currentInput.possibleValues.push(relaValue);
									$scope.currentInput.possibleValueLabels.push(relalabel);
									$scope.possibleOptions.push({
										label : relalabel,
										labelLocalized : relaLocalizedLabel,
										value : relaValue
									});
								}

								$scope.deleteTimeRange = function(value) {
									var selectedVal = _.remove($scope.possibleOptions, {
										value : value
									});
									var index = $scope.currentInput.possibleValueLabels.indexOf(selectedVal[0].label);
									$scope.currentInput.possibleValues.splice(index, 1);
									$scope.currentInput.possibleValueLabels.splice(index, 1);
								}

								$scope.sortOptions = [ 'label', 'value', 'None' ];
								$scope.sortDirs = [ 'Asc', 'Desc' ];

								$scope.getDataSets = function() {
									$scope.dsList = [];
									reportService
											.getAllDataSets(true)
											.then(function(data) {
												$scope.dsList = $scope.page.dataSets.dataSet;
												if (data.data.dataSet) {
													$scope.dsList = $scope.dsList.concat(data.data.dataSet);
												}

												if ($scope.currentInput.dataSetEntity) {
													for (var i = 0; i < $scope.dsList.length; i++) {
														if ($scope.dsList[i].dataSet.dataSetName == $scope.currentInput.dataSetEntity.dataSetName) {
															$scope.currentInput.dataSetEntity = $scope.dsList[i].dataSet;
															break;
														}
													}
													$scope.getFieldsFromDataSet($scope.currentInput.dataSetEntity);
												}
											},
													function(error) {
														alert(error.data)
													});
								}

								$scope.setCommcellProperties = function() {
									$scope.currentInput.fromDataSet = true;
									$scope.currentInput.dataSetEntity = {
										dataSetName : "CommcellList",
										dataSetGuid : "36711099-c17b-4857-b2d6-2d26e52c6aec"
									};
									// do not override already selected properties.
									if(!$scope.currentInput.valueField){
										$scope.currentInput.labelField = "CCHostName";
										$scope.currentInput.valueField = "id";
									}
									$scope.fields = [ "id", "aliasName" ];
								}

								$scope.setCommcellEntityProperties = function() {
									$scope.currentInput.fromDataSet = true;
								}

								$scope.updateControltypes = function(type) {
									$scope.showMultiSelect = true;
									angular.copy($scope.allControlTypes, $scope.controlTypes);
									if (type == 'Boolean') {
										$scope.controlTypes.splice(2, 5);//remove the list box
										$scope.controlTypes.splice(3, 2);//remove the date options
										$scope.controlTypes.splice(4, 1);//remove slider
									} else if (type == 'Date') {
										$scope.showMultiSelect = false;
										$scope.controlTypes = [];
										$scope.controlTypes.push("DatePicker");
										$scope.controlTypes.push("DateTimePicker");
										$scope.controlTypes.push("TimePicker");
										$scope.currentInput.controlType = "DatePicker";
									} else if (type == 'Time') {
										$scope.showMultiSelect = false;
										$scope.controlTypes = [];
										$scope.controlTypes.push("TimePicker"); // shows only Time picker
										$scope.currentInput.controlType = "TimePicker";
									} else if (type == 'DateRange') {
										$scope.showMultiSelect = false;
										$scope.controlTypes = [];
										$scope.controlTypes.push("DateRange"); // shows only the date range
										$scope.currentInput.controlType = "DateRange";
									} else {
										$scope.controlTypes.splice(2, 3);// removes the date option
										$scope.controlTypes.splice(8, 1);// removes the time picker
										if (type == 'String') {
											$scope.controlTypes.splice(8, 1);// removes the slider
										} else if (type == 'Commcell') {
											$scope.setCommcellProperties();
											$scope.controlTypes.splice(5, 3); // remove textbox, text area and slider
											if (!$scope.currentInput.controlType ||
													$scope.currentInput.controlType == 'TextBox') {
												$scope.currentInput.controlType = "ListBox";
											}
										} else if (type == 'CommcellEntity') {
											$scope.setCommcellEntityProperties();
											$scope.controlTypes.splice(6, 3); // remove text area, toggle box and slider
											if (!$scope.currentInput.controlType ||
													$scope.currentInput.controlType == 'TextBox') {
												$scope.currentInput.controlType = "DropDown";
											}
										}

										if ($scope.currentInput.allowMultipleSelection) {
											$scope.controlTypes = [];
											$scope.controlTypes.push("CheckBox");
											$scope.controlTypes.push("ListBox");
											$scope.controlTypes.push("Hidden");
											if (!$scope.currentInput.controlType ||
													$scope.controlTypes.indexOf($scope.currentInput.controlType) === -1) {
												$scope.currentInput.controlType = "ListBox";
											}
										}

										if (!$scope.currentInput.controlType) {
											$scope.currentInput.controlType = 'TextBox';
										}

									}
								}

								$scope.getFieldsFromDataSet = function(dataSetEnity) {
									customReportSvc.mask("addNewInputForm", true, "Loading fields ...");
									$scope.fields = [];
									//var dataUrl = "reportsplusengine/datasets/" +encodeURIComponent(dataSetEnity.dataSetName) +"/select/?cacheId=&offset=0&q=&componentName=$scope.input.displayname";

									var ds = customReportSvc.getDataSet(dataSetEnity.dataSetName,
											$scope.page.dataSets.dataSet);
									var datasets = dataSetUtility.getDataSets(ds, $scope.page);
									var dsId = encodeURIComponent(dataSetEnity.dataSetName);
									var dataSetParams = {
										reportMode : $scope.reportMode,
										componentName : $scope.currentInput.displayname,
										dsId : dsId,
										operation : "fields",
										builderVersion : $scope.builderVersion,
										isPreview : $scope.isPreview,
										limit : 1,
										offset : 0,
										exportType : null,
										exportedFileName : null,
										rawData : ds && ds.endpoint == "HTTP" ? true : false,
										cacheId : $scope.cacheId
									};
									//$scope.mergedParams = $.extend({}, $scope.requestParms, $scope.viewParams);
									var dataUrl = dataSetUtility.getUrlForDataComponent(undefined,
											ds,
											$scope.page,
											dataSetParams,
											$scope.mergedParams,
											{});

									function successCallback(columns) {
										for (var i = 0; i < columns.length; i++) {
											$scope.fields.push(columns[i].name);
										}
										customReportSvc.unMask("addNewInputForm", true);
									}
									function errorCallback(error) {
										customReportSvc.unMask("addNewInputForm", true);
										if (error && error.data) {
											customReportSvc.errorToast(error.data);
										}
									}
									if (ds.endpoint === "DATACUBE") {
										reportService.getFieldsForDCubeDataSet(ds.dCubeDataSet).then(function(data) {
											successCallback(customReportSvc
													.getFieldsForCustomReport((data.data.schemaFields || [])));
										},
												errorCallback);
									} else {
										// ds object is empty for shared datasets
										if ($.isEmptyObject(ds)) {
											reportService.getDataForDataSetViaProxy(dataUrl).then(function(data) {
												successCallback(data.data.columns);
											}, errorCallback);
										} else {
											reportService.putFieldsForDataSet(dataUrl, datasets).then(function(data) {
												successCallback(data.data.columns);
											}, errorCallback);
										}
									}
								}

								$scope.validateInput = function() {
									var error = false;

									for (var j = 0; j < $scope.inputs.length; j++) {

										if (j !== $scope.currentInputIndex) {
											if ($scope.inputs[j].id === $scope.currentInput.id) {
												customReportSvc
														.errorToast($scope.currentInput.id +
																" is already used by another input. Please enter another value for Input Variable field. ");
												return true;
											}

											if ($scope.inputs[j].displayName === $scope.currentInput.displayName) {
												customReportSvc
														.errorToast($scope.currentInput.displayName +
																" is already used by another input. Please enter another value for Display Name field.");
												return true;
											}
										}
									}

									if ($scope.currentInput.controlType === 'DateRange'){
										if($scope.currentInput.relativeOptions.indexOf('Last') !== -1 || $scope.currentInput.relativeOptions
														.indexOf('Next') !== -1) {
											if (!$scope.currentInput.relativeUnits ||
													$scope.currentInput.relativeUnits.length === 0) {
												customReportSvc.errorToast(localMsg.customReport.SelectUnit);
												return true;
											}
										}
										if($scope.currentInput.relativeOptions.length < 1){
											customReportSvc.errorToast(localMsg.customReport.SelectOption);
											return true;
										}
									}

									if ($scope.currentInput.controlType === 'Slider') {
										var slider_min = parseInt($scope.currentInput.rangeParam.floor, 10);
										var slider_max = parseInt($scope.currentInput.rangeParam.ceil, 10);
										var slider_step = parseInt($scope.currentInput.rangeParam.step, 10);
										var defaultValue = parseInt($scope.currentInput.defaultValue, 10);
										var error = slider_min > slider_max ||
												slider_step > (slider_max - slider_min) || defaultValue < slider_min ||
												defaultValue > slider_max;
										if (error) {
											customReportSvc.errorToast("Invalid Input for slider fields");
										} else {
											$scope.currentInput.rangeParam.floor = slider_min;
											$scope.currentInput.rangeParam.ceil = slider_max;
											$scope.currentInput.rangeParam.step = slider_step;
										}
										return error
									}
								}

								$scope.updatedependentInput = function(id) {
									if (!$scope.currentInput.dependsOn) {
										$scope.currentInput.dependsOn = [];
									}
									if (id !== null) {
										$scope.currentInput.dependsOn[0] = id;
									} else {
										$scope.currentInput.dependsOn = [];
									}
								}

								/**
								 * Add a input to the list of inputs to modify
								 */
								$scope.commitChanges = function() {

									if ($scope.page.inputs == undefined) {
										$scope.page.inputs = [];
									}

									var error = $scope.validateInput() || false;
									if (error) {
										return;
									}

									$scope.page.inputs.splice(0, $scope.page.inputs.length);

									if ($scope.currentInput.newInput == true) {
										$scope.currentInput.newInput = false;
										if ($scope.currentInput.type === "Commcell" && $scope.inputs.length > 1) {
											$scope.inputs.splice(0, 0, $scope.currentInput);
										} else {
											$scope.inputs.push($scope.currentInput);
										}
									}

									for (var i = 0; i < $scope.inputs.length; i++) {
										$scope.inputs[i].isSelected = false;
										$scope.page.inputs.push($scope.inputs[i]);
									}

									customReportSvc.triggerCallback("inputUpdated", {
										inputs : $scope.inputs
									});

									$modalInstance.close($scope.page.inputs);
								}; // end method addInput

								$scope.newInput = function() {
									$scope.currentInput = {
										type : "String",
										controlType : "TextBox",
										required : false,
										newInput : true,
										isSelected : true,
										fromDataSet : false,
										relativeOptions : [],
										dependsOn : [],
										dependendent : []
									};
									$scope.updateControltypes($scope.currentInput.type);
								}
								/**
								 * Select a certain Input
								 * 
								 * @param selected
								 *            Newly selected input index
								 */
								$scope.setCurrentInput = function(input, isClick) {
									if ($scope.currentInput) {
										if (isClick) {
											if (!$scope.currentInput.id || $scope.currentInput.id == '') {
												customReportSvc.errorToast("Please enter input variable name.");
												return;
											}
											if (!$scope.currentInput.displayName ||
													$scope.currentInput.displayName == '') {
												customReportSvc.errorToast("Please enter input variable display name.");
												return;
											}
										}
										$scope.currentInput.isSelected = false;
									}

									$scope.currentInput = input;
									if ($scope.currentInput.type === 'DateRange') {
										$scope.setDefaultRelativeOptions();
									}

									// backward compatibility for old reports when editing
									if (!$scope.currentInput.dependsOn) {
										$scope.currentInput.dependsOn = [];
										$scope.currentInput.dependendent = [];
									}
									if($scope.currentInput.dependsOn && $scope.currentInput.dependsOn.length > 0){
										$scope.currentInput.dependendent =  $scope.dependentInputs.filter(x => $scope.currentInput.dependsOn.indexOf(x.id) !== -1);
									}else{
										$scope.currentInput.dependendent = [];
									}

									$scope.updateControltypes(input.type);
									$scope.currentInput.isSelected = true;
									//			$scope.actionCheckList();
								}; // end method setTab

								/**
								 * Whether or not the given input is selected
								 * 
								 * @param input
								 *            Index of input to check
								 * @return Whether or not <code>input</code> is selected
								 */
								$scope.isCurrentInput = function(input) {
									return $scope.currentInput === input;
								}; // end method isSelected

								/**
								 * Delete the currently selected input
								 */
								$scope.deleteCurrentInput = function() {
									var index = $scope.inputs.indexOf($scope.currentInput);
									$scope.inputs.splice($scope.inputs.indexOf($scope.currentInput), 1);
									if (index > 0) {
										$scope.setCurrentInput($scope.inputs[index - 1]);
									} else if ($scope.inputs.length > 0) {
										$scope.setCurrentInput($scope.inputs[0]);
									} else {
										$scope.newInput();
									}
								}; // end method deleteCurrentInput

								/**
								 * Moves the currently selected input up
								 * 
								 * @param direction
								 *            Either "up" or "down"
								 */
								$scope.moveInput = function(direction) {
									var index = $scope.inputs.indexOf($scope.currentInput);
									if (direction.toLowerCase() === "up") {
										if (index !== 0) {
											$scope.inputs[index] = $scope.inputs[index - 1];
											$scope.inputs[index - 1] = $scope.currentInput;
										}
									} else {
										if (index !== $scope.inputs.length - 1) {
											$scope.inputs[index] = $scope.inputs[index + 1];
											$scope.inputs[index + 1] = $scope.currentInput;
										}
									}

									//			$scope.actionCheckList ();
								}; // end method moveInput

								//		$scope.actionCheckList = function() {
								//			if($scope.inputs && $scope.inputs.length <=1) {
								//				$scope.upDisabled = true;
								//				$scope.downDisabled = true;
								//			} else {
								//				var index = $scope.inputs.indexOf($scope.currentInput);
								//				if (index == 0)
								//					$scope.upDisabled = true;
								//				else
								//					$scope.upDisabled = false;
								//
								//				if (index ==  $scope.inputs.length-1)
								//					$scope.downDisabled = true;
								//				else
								//					$scope.downDisabled = false;
								//			}
								//		}
								//
								$scope.init = function(treeNode) {
									if (treeNode) {
										$scope.mode = "Edit";
										for (var i = 0; i < $scope.inputs.length; i++) {
											if (treeNode.id == $scope.inputs[i].id) {
												$scope.setCurrentInput($scope.inputs[i]);
												$scope.currentInputIndex = i;
												break;
											}
										}
									} else {
										$scope.mode = "Add";
										$scope.newInput();
									}
									//			$scope.actionCheckList ();
								};
								$scope.init(treeNode);

							} ]); // end controller addDataSetModalCtrl

})();
