<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
        <span class="ico ico-form-field"></span>
    </li>
    <li class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
        <span class="ico ico-code"></span>
    </li>
    <li class="sub-header" title="Mobile" data-ng-show="propData.mobile.visible === 'On' && cv.additionalSettings.Console.enableMobileOptions" data-ng-class="{'sub-header-active': selectedPropertyCategory==='mobile'}" data-ng-click="selectedPropertyCategory='mobile'">
        <span class="ico ico-mobile"></span>
    </li>
    <li class="sub-header" title="Filters" data-ng-show="ds && ds.endpoint === 'DATACUBE'" data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}" data-ng-click="selectedPropertyCategory='filters'">
        <span class="ico ico-funnel"></span>
    </li>
</ul>

<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>
<!-- Begin "General" group -->
<div data-ng-show="selectedPropertyCategory==='general'">
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm" type="text"
                     placeholder="<fmt:message key='CustomReport.Properties.TableName'/>"
                     data-ng-model="propData.title.text">
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   type="text"
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
                   data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">
                  <span class="inline-validation-error" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>  <!-- localize -->
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message key="CustomReport.Properties.DataSet"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                   <input class="form-control input-sm"
                   type="text"
                   placeholder="<fmt:message key="CustomReport.Properties.DataSetName"/>"
                   readonly="true"
                   data-ng-model="propData.dataSet.dataSetName">
                </div>
            </div>
        </div>
    </div>

<!--     Show in Phase 2 -->
<!--     <div class="row noLftRghtMargin"> -->
<!--         <div class="col-xs-12"> -->
<!--             <label> -->
<!--                 Group By -->
<!--                 <select  class="form-control input-sm"  -->
<!--                 	data-ng-model="selectedColumn"  -->
<!--                 	data-ng-change="groupBy(selectedColumn)"> -->
<!--                 	<option data-ng-selected="{{columns== selectedColumn}}" data-ng-if="column.visible"   data-ng-repeat="column in propData.tableColumns" value="{{column.displayName}}">{{column.displayName}}</option> -->
<!--                 </select> -->
<!--             </label> -->
<!--         </div> -->
<!--     </div> -->




   <%--  <div class="row noLftRghtMargin">
        <div class="col-xs-6">
<!-- FIXME: Localize -->
            <label>
                <fmt:message key="CustomReport.Properties.Height"/><br>
                <span class="input-group input-group-sm">
                    <input class="form-control"
                    	   placeholder="auto"
						   data-ng-model="propData.styles.height"
                           type="text">
                    <span class="input-group-addon">px</span>
                </span>
            </label>
        </div>


        <div class="col-xs-6">
<!-- FIXME: Localize -->
            <label>
                <fmt:message key="CustomReport.Properties.Width"/><br>
                <span class="input-group input-group-sm">
                    <input class="form-control"
                           placeholder="auto"
                    	   data-ng-model="propData.styles.width"
                           type="text">
                    <span class="input-group-addon">px</span>
                </span>
            </label>
        </div>


     <!--     <div class="col-xs-6">
FIXME: Localize
            <label>
                Background
                <br>
                <input class="form-control input-sm"
                	   data-ng-model="propData.background"
                       type="color"
                       value="#FFFFFF">
            </label>
        </div> -->
    </div>
 --%>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.IncludeAllColumns"/>'><fmt:message key="CustomReport.Properties.IncludeAllColumns"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                      <input type="checkbox" cv-toggle-switch data-ng-model="propData.allColumns" data-ng-disabled="!propData.dataSet.dataSetName" id="allcolumns" data-ng-change="reInitializeTable()">
                </div>
            </div>
        </div>
    </div>
    <div class="row noLftRghtMargin">
       <div class="col-xs-12" >
            <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideAlert"/>'><fmt:message key="CustomReport.Properties.HideAlert"/></label>
                    <div class="col-sm-3 noLftRghtPadding">
                          <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideAlarmOption" id="hidealalarmoption">
                    </div>
              </div>
        </div>
    </div>
    <div class="row noLftRghtMargin" data-ng-show="propData.type !== 'PIVOT_TABLE'">
       <div class="col-xs-12">
<!-- FIXME: Localize -->
           <div class="form-group">
               <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EnableButtonPanel"/>'><fmt:message key="CustomReport.Properties.EnableButtonPanel"/></label>
               <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.enableButtonPanel" id="enableButtonPanel" data-ng-change="checkAndEnableRowSelection()">
               </div>
           </div>
       </div>
    </div>
 	<div class="row noLftRghtMargin" data-ng-show="propData.type !== 'PIVOT_TABLE'">
       <div class="col-xs-12">
<!-- FIXME: Localize -->
           <div class="form-group">
               <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EnableColumnSelection"/>'><fmt:message key="CustomReport.Properties.EnableColumnSelection"/></label>
               <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.enableRowSelection" id="enableRowSelection" data-ng-change="enableRowSelection()">
               </div>
           </div>
       </div>
    </div>

    <div class="row noLftRghtMargin" data-ng-show="propData.type !== 'PIVOT_TABLE' && propData.enableButtonPanel && propData.enableRowSelection">
       <div class="col-xs-12">
<!-- FIXME: Localize -->
           <div class="form-group">
               <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EnableMultipleRowSelection"/>'><fmt:message key="CustomReport.Properties.EnableMultipleRowSelection"/></label>
               <div class="col-sm-3 noLftRghtPadding">
                     <input type="checkbox" cv-toggle-switch data-ng-model="propData.enableMultiRowSelection" id="enableMultiRowSelection" data-ng-change="enableMultiRowSelection(propData.id)">
               </div>
           </div>
       </div>
    </div>

    <div class="row noLftRghtMargin" data-ng-show="ds && ds.endpoint === 'DATACUBE' && propData.type !== 'PIVOT_TABLE' && propData.enableButtonPanel && propData.enableRowSelection && propData.enableMultiRowSelection">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EnableRowFilter"/>'>
                    <fmt:message key="CustomReport.Properties.EnableRowFilter"/>
                </label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.filterReportForRowSelection" id="filterReportForRowSelection">
                </div>
            </div>
        </div>
    </div>

    
    <div class="row noLftRghtMargin" data-ng-show="propData.filterReportForRowSelection">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.FilterColumn"/>'>
                    <fmt:message key="CustomReport.Properties.FilterColumn"/>
                </label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm" type="text"
                        placeholder="<fmt:message key='CustomReport.Properties.FilterColumn'/>"
                        data-ng-model="propData.filterColumn">
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin" data-ng-show="propData.type !== 'PIVOT_TABLE' && propData.enableButtonPanel && propData.enableRowSelection">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
			<label  class="col-xs-12 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DisableRowSelectionHelp"/>'>
				<fmt:message key="CustomReport.Properties.DisableRowSelection"/><br>
			</label>
		      <span class="input-group-sm col-xs-12 noLftRghtPadding">
		        <textarea  data-ng-model="propData.disableRowSelectionWhen" rows="5" data-ng-blur="refreshTableData()"></textarea>
		      </span>
        </div>
    </div>

    <div class="row noLftRghtMargin" data-ng-show="propData.type !== 'PIVOT_TABLE' && propData.enableButtonPanel && propData.enableRowSelection">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
			<label  class="col-xs-12 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideRowSelectionHelp"/>'>
				<fmt:message key="CustomReport.Properties.HideRowSelection"/><br>
			</label>
		      <span class="input-group-sm col-xs-12 noLftRghtPadding">
		        <textarea  data-ng-model="propData.hideRowSelectionWhen" rows="5" data-ng-blur="refreshTableData()"></textarea>
		      </span>
        </div>
    </div>

    
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EmptyGridMsg"/>'>
                    <fmt:message key="CustomReport.Properties.EmptyGridMsg"/>
                </label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm" type="text"
                        placeholder="<fmt:message key='CustomReport.Properties.EmptyGridMsg'/>"
                        data-ng-model="propData.emptyGridMessage">
                </div>
            </div>
        </div>
    </div>

    <!-- <div class="row noLftRghtMargin">
       <div class="col-xs-12">
FIXME: Localize
           <div class="form-group">
               <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='Enable Dynamic Column Selection'>Column Selection</label>
               <div class="col-sm-3 noLftRghtPadding">
                     <input type="checkbox" cv-toggle-switch data-ng-model="propData.dynamicColumnSelection" id="dynamicColumnSelection">
               </div>
           </div>
       </div>
    </div> -->

    <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideHeader"/>'><fmt:message key="CustomReport.Properties.HideHeader"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideHeader" id="hideheader">
                </div>
            </div>
    </div>

    <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideFooter"/>'><fmt:message key="CustomReport.Properties.HideFooter"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideFooter" id="hideFooter" data-ng-change="refreshComponent(propData.id)">
                </div>
            </div>
    </div>

     <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.AutoHeight"/>'><fmt:message key="CustomReport.Properties.AutoHeight"/></label>
                <div class="col-sm-4 noLftRghtPadding">
                        <select class="form-control input-sm"
                          data-ng-model="propData.autoHeight">
                          <option value="On"><fmt:message key="CustomReport.Properties.On"/></option>
                          <option value="Off"><fmt:message key="CustomReport.Properties.Off"/></option>
                        </select>
                </div>
            </div>
    </div>

    <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.CustomRowTemplateHelp"/>'><fmt:message key="CustomReport.Properties.CustomRowTemplate"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.showAsSearchResults" id="showAsSearchResults">
                </div>
            </div>
    </div>

    <div class="row noLftRghtMargin" data-ng-if="propData.showAsSearchResults">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
			<label  class="col-xs-12 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.RowTemplate"/>'>
				<fmt:message key="CustomReport.Properties.RowTemplate"/><br>
			</label>
		      <span class="input-group-sm col-xs-12 noLftRghtPadding">
		        <textarea  data-ng-model="propData.rowTemplate" rows="5" data-ng-blur="refreshTableData()"></textarea>
		      </span>
        </div>
    </div>

<!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">
                    <select class="form-control input-sm"
                      data-ng-model="propData.mobile.visible">
                      <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                      <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>
            </div>
        </div>
    </div>
	<entity-security data-item="propData"></entity-security>
</div>

<!-- End "General" group -->

<!-- Begin "Font" group -->
<!-- <div class="group container-fluid" -->
<!--      data-ng-class="{collapsed:collapsed['font']}"> -->
<!--     <div class="row noSelect groupHeader" data-ng-click="collapsed['font']=!collapsed['font']"> -->
<!--         <div class="col-xs-1"> -->
<!--             <span class="dropdown-icon">{{ -->
<!--                 collapsed["font"] -->
<!--                 ? "&blacktriangleright;" -->
<!--                 : "&blacktriangledown;" -->
<!--             }}</span> -->
<!--         </div> -->
<!--         <div class="col-xs-8 text-center"> -->
<!-- FIXME: Localize -->
<!--             <span class="groupName">Font</span> -->
<!--         </div> -->
<!--     </div> -->

<!--     <div class="row noLftRghtMargin"> -->
<!--         <div class="col-xs-12"> -->
<!-- FIXME: Localize -->
<!--             <label> -->
<!--                 Family -->
<!--                 <select class="form-control input-sm" data-ng-model="propData.fontFamily"> -->
<!--                     <option>Inherit</option> -->
<!--                     <option>Initial</option> -->
<!--                     <option>Georgia, serif</option> -->
<!--                     <option>"Palatino Linotype", "Book Antiqua", Palatino, serif</option> -->
<!--                     <option>"Times New Roman", Times, serif</option> -->
<!--                     <option>Arial, Helvetica, sans-serif</option> -->
<!--                     <option>"Arial Black", Gadget, sans-serif</option> -->
<!--                     <option>"Comic Sans MS", cursive, sans-serif</option> -->
<!--                     <option>Impact, Charcoal, sans-serif</option> -->
<!--                     <option>"Lucida Sans Unicode", "Lucida Grande", sans-serif</option> -->
<!--                     <option>Tahoma, Geneva, sans-serif</option> -->
<!--                     <option>"Trebuchet MS", Helvetica, sans-serif</option> -->
<!--                     <option>Verdana, Geneva, sans-serif</option> -->
<!--                     <option>"Courier New", Courier, monospace</option> -->
<!--                     <option>"Lucida Console", Monaco, monospace</option> -->
<!--                 </select> -->
<!--             </label> -->
<!--         </div> -->
<!--     </div> -->

<!--     <div class="row noLftRghtMargin"> -->
<!--         <div class="col-xs-6"> -->
<!-- FIXME: Localize -->
<!--             <label> -->
<!--                 Size<br> -->
<!--                 <span class="input-group input-group-sm" data-style="width:85px;"> -->
<!--                     <input class="form-control" -->
<!--                     	   data-ng-model="propData.fontSize" -->
<!--                            type="number" -->
<!--                            min="0" -->
<!--                            value="14"> -->
<!--                     <span class="input-group-addon">px</span> -->
<!--                 </span> -->
<!--             </label> -->
<!--         </div> -->

<!--         <div class="col-xs-6"> -->
<!-- FIXME: Localize -->
<!--             <label> -->
<!--                 Color -->
<!--                 <br> -->
<!--                 <input class="form-control input-sm" -->
<!--                 	   data-ng-model="propData.fontColor" -->
<!--                        type="color" -->
<!--                        value="#000000"> -->
<!--             </label> -->
<!--         </div> -->
<!--     </div> -->
<!-- </div> -->
<!-- End "Font" group -->

<!-- Begin "Rows" group -->
<!-- <div class="group container-fluid"
     data-ng-class="{collapsed:collapsed['labels']}">
    <div class="row noSelect groupHeader" data-ng-click="collapsed['labels']=!collapsed['labels']">
        <div class="col-xs-1">
            <span class="dropdown-icon">{{
                collapsed["font"]
                ? "&blacktriangleright;"
                : "&blacktriangledown;"
            }}</span>
        </div>
        <div class="col-xs-8 text-center">
FIXME: Localize
            <span class="groupName">Rows</span>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
FIXME: Localize
            <label>
                Even Rows
               <input class="form-control input-sm"
               			data-ng-model="propData.styles.evenRowColor"
						type="color">
            </label>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
FIXME: Localize
            <label>
                Odd Rows
               <input class="form-control input-sm"
               		   data-ng-model="propData.styles.oddRowColor"
               		   type="color">
            </label>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
FIXME: Localize
            <label>
                Selected Row
                <input class="form-control input-sm"
                		data-ng-model="propData.styles.selectedRowColor"
                       	type="color">
            </label>
        </div>
    </div>
</div> -->
<!-- End "Rows" group -->

<!-- Begin "Series" group -->
<div data-ng-show="selectedPropertyCategory==='fields'">
    <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['sorting']=!collapsed['sorting']">
       <div class="col-xs-12 noLftRghtPadding">
           <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['sorting'], 'ico-chevron-right':collapsed['sorting']}" style="margin-right:5px"></span>
           <span><fmt:message key="CustomReport.Properties.Sorting"/></span>
           <span class="pull-right ico ico-plus-circle" title="Add Sorting" data-ng-click="collapsed['sorting']=true;addSort()"></span>
       </div>
    </div>
    <div data-ng-class="{'collapsed': collapsed['sorting']}">
       <div class="row ng-scope noLftRghtMargin" data-ng-repeat="sort in propData.sorting">
       <div class="col-xs-12">
  			<select data-ng-model="sort.columnId"
  			               data-ng-options="col.id as col.displayName for col in propData.columns | excludeFrom:sort.columnId:propData.sorting"
  			               data-ng-change="refreshTableData()" class="col-lg-7 noLftRghtPadding" style="margin-right: 5px;"></select>
  			<select data-ng-model="sort.direction"
  	               data-ng-options="o as o for o in sortDirs"
  	               data-ng-change="refreshTableData()" class="col-lg-3 noLftRghtPadding" style="margin-right: 5px;"></select>
      		<span class="ico ico-trash2 pro-dlt-btn" data-ng-click="deleteSort($index)"> </span>
		</div>
  	</div>
  	<div class="row noLftRghtMargin" data-ng-show="propData.type === 'PIVOT_TABLE'">
  	     <div class="col-xs-12" >
              <div class="form-group">
                  <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.PivotOrderColumns"/>'><fmt:message key="CustomReport.Properties.PivotOrderColumns"/></label>
                  <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.orderColumns" id="ordercolumns" data-ng-change="reInitializeTable()">
                  </div>
              </div>
          </div>
      </div>
      <div class="row noLftRghtMargin" data-ng-show="propData.orderColumns">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label" title='Order'>Order</label>
            <div class="col-sm-8">
                <select class="form-control input-sm" data-ng-model="propData.pivotDirection"
                   data-ng-options="o as o for o in sortDirs"
                   data-ng-change="reInitializeTable()"></select>
            </div>
        </div>
      </div>
    </div>

<!--     <div class="row noLftRghtMargin secondary-header property-header">
       <div class="col-xs-12 noLftRghtPadding" data-ng-click="collapsed['filters']=!collapsed['filters']" data-ng-init="collapsed['filters']=true">
           <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['filters'], 'ico-chevron-right':collapsed['filters']}" style="margin-right:5px"></span>
           <span>Filter</span>
       </div>
    </div>
    <div data-ng-class="{'collapsed': collapsed['filters']}">
			<div class="row noLftRghtMargin">
              <div class="col-xs-12">
      FIXME: Localize
                <label>
                  Condition<br>
                </label>
                <span>
                    <textarea  data-ng-model="component.filterClause" rows="5"></textarea>
                    <div class="text-muted"><em>e.g. columnName1 &gt; @parameter1 AND columnName2 &lt; @parameter2</em></div>
                </span>
              </div>
          </div>
    </div> -->
        <!--  Begin Column properties -->
   <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['columns']=!collapsed['columns']" data-ng-init="collapsed['columns']=true">
     <div class="col-xs-12 noLftRghtPadding">
         <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['columns'], 'ico-chevron-right':collapsed['columns']}" style="margin-right:5px"></span>
         <span>Columns</span> <!-- TODO: localize -->
     </div>
   </div>
   <div data-ng-class="{'collapsed': collapsed['columns']}">
    <div data-ng-repeat="column in propData.columns" data-ng-init="collapsed['column'+$index] = true">
        <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel" >
            <div class="fieldHeader"  data-ng-click="collapsed['column'+$index]=!collapsed['column'+$index]">
                  <label class="col-lg-9 noLftRghtPadding">
                      <span cv-report-customization cv-expression="{{column.displayName}}" cv-localize="true" ></span>
                  </label>
                   <span class="pull-right">
                        <span class="ico inner-panel-expand-icon" data-ng-class="{'ico-chevron-down':!collapsed['column'+$index], 'ico-chevron-right':collapsed['column'+$index]}" style="margin-right:5px"></span>
                        <!-- <span class="ico ico-trash" title="<fmt:message key='CustomReport.Properties.DeleteColumn'/>" data-ng-click="removeColumn(column)"></span> -->
                    </span>
             </div>
      <div data-ng-class="{'collapsed': collapsed['column'+$index]}">
     	 <div cv-columns data-column="column"></div>
      </div>
      </div>
    </div>
    </div>


    <!-- End Column properties -->
</div>
<!-- End "Table Options" group -->


<!-- Begin "Custom" group -->
<div data-ng-show="selectedPropertyCategory==='customcode'">
     <div class="row noLftRghtMargin">
          <div class="col-xs-12">
<!-- FIXME: Localize -->
            <label title='<fmt:message key="CustomReport.Properties.RowStyles"/>'>
              <fmt:message key="CustomReport.Properties.RowStyles"/><br>
            </label>
            <div class="pull-right">
                <button class="btn btn-primary btn-xs" data-ng-click="openAceEditor(propData.rowStyleExpression,'css','redrawComponent(propData.id)','propData.rowStyleExpression')">
                    <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddStyle"/>
                </button>
            </div>
        </div>
        <div class="col-xs-12">
<!-- FIXME: Localize -->
    			<label title='<fmt:message key="CustomReport.Properties.AllCellExpression"/>'>
    				<fmt:message key="CustomReport.Properties.AllCellExpression"/><br>
    			</label>
          <div>
              <button class="btn btn-primary btn-xs" data-ng-click="openAceEditor(propData.allCellExpression,'javascript',undefined,'propData.allCellExpression')">
                  <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddExpression"/>
              </button>
          </div>
        </div>

    </div>
    <div data-ng-if="propData.enableRowSelection" data-ng-init="collapseProp=true">
      <div class="row noLftRghtMargin noLftRghtPadding secondary-header property-header" data-ng-click="collapseProp=!collapseProp">
         <div class="col-xs-12">
             <span class="ico col-xs-2 margin-right-5 noLftRghtPadding" data-ng-class="{'ico-chevron-down':!collapseProp, 'ico-chevron-right':collapseProp}"></span>
             <label class="col-xs-10 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.RowFormatter"/>'>
              <fmt:message key="CustomReport.Properties.RowFormatter"/><br>
            </label>

         </div>
      </div>
      <div data-ng-if="!collapseProp">
        <event-properties event-type="onClick" event-model="propData.rowFormatter" comp-type="'row'" columns="propData.columns"></event-properties>
      </div>
  </div>

</div>

<!-- Begin "Mobile" group -->
<div data-ng-show="selectedPropertyCategory==='mobile'">
    <div class="row noLftRghtMargin">
        <event-properties event-type="onClick" event-model="propData.mobile.listItemClick" is-mobile="true"></event-properties>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
        <label  class="col-xs-12 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.CustomLayout"/>'>
            <fmt:message key="CustomReport.Properties.Mobile.CustomLayout"/><br>
        </label>
        <span class="input-group-sm col-xs-12 noLftRghtPadding">
            <textarea data-ng-model="propData.mobile.customListLayout" rows="5" ></textarea>
        </span>
    </div>
   </div>
  </div>

<!-- End "Table Options" group -->

<!-- Begin "Filters" group -->
<div data-ng-show="ds && ds.endpoint === 'DATACUBE' && selectedPropertyCategory==='filters'">
    <cvfacet config="propData" type="'properties'" page="page" filters="propData.filters" filter-mode="'builder'" report-mode="reportMode"></cvfacet>
    <div class="row noLftRghtMargin" data-ng-show="ds && ds.endpoint === 'DATACUBE'">
        <div class="col-xs-12">
            <label class="col-xs-12 noLftRghtPadding">
                Custom Filter Query<br>
            </label>
            <span class="col-xs-12 noLftRghtPadding">
                <textarea  data-ng-model="propData.filters.customFilterQuery" data-ng-blur="refreshTableData()"></textarea>
            </span>
        </div>
    </div>
</div>



</fmt:bundle>
