// Closure to isolate scope, as per best practices
(function() {
	"use strict";

	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");

	app.directive("cvColumns", function() {
		return {
			restrict : 'AEC',
			templateUrl : customReports.contextPath + '/reportsplus/properties/column.jsp',
		};
	});

	app.directive("entitySecurity", function() {
		return {
			restrict : 'AEC',
			replace : true,
			scope : {
				item : '=item'
			},
			templateUrl : customReports.contextPath + '/reportsplus/properties/entitySecurityProperties.jsp',
			controller:['$scope',function($scope){
				if(!$scope.item.visible){
					$scope.item.visible = {};
				}

			}]
		};
	});

	app.filter('filterDuplicateAggregates', function() {
		return function(aggrTypes, selectedAggrs, aggrType) {
			var temp = [];
			angular.forEach(aggrTypes, function(val, indx) {
				if (selectedAggrs.indexOf(val) === -1 || val === aggrType) {
					temp.push(val);

				}
			});
			return temp;
		}
	});
	var defaultMultiChartColors = [
			"#ef9359",
			"#ff6d31",
			"#31ddff",
			"#a931ff",
			"#ffd231",
			"#73b66b",
			"#b66b73",
			"#b68d6b",
			"#6b7bb6",
			"#ffcb18",
			"#9718ff",
			"#ff1880",
			"#80ff18",
			"#c22326",
			"#26c223",
			"#2328c2",
			"#c27023",
			"#29a2c6",
			"#c65829",
			"#c6a729",
			"#8a29c6",
			"#027878",
			"#781f02",
			"#785a02",
			"#3d0278" ];

	// Controller for properties area
	app
			.controller("propertiesCtrl",
					[
							'$scope',
							'customReportSvc',
							'$timeout',
							'$compile',
							'$uibModal',
							'reportService',
							function($scope, customReportSvc, $timeout, $compile, $uibModal, reportService) {
								$scope.sortDir = 'None';
								$scope.aggrTypesForNumber = [ "Count", "CountDistinct", "Avg", "Sum", "Min", "Max" ];
								$scope.aggrTypesForString = [ "Count", "CountDistinct" ];
								$scope.timezones = ["None"].concat(moment.tz.names());
								$scope.IntegerDateFormats = [{val:"ts", name: 'Timestamp'},{val:"tsms", name: 'Timestamp in milliseconds'}];
								$scope.dateTypes = ['TimeStamp', 'Date'];
								$scope.integerTypes = ['Integer','Long'];
								$scope.mapStyles = [{
							            name : "basic",
										value : "mapbox://styles/mapbox/basic-v9?optimize=true"
									},{
							            name : "streets",
							            value:"mapbox://styles/mapbox/streets-v11?optimize=true"
							        },{
							            name : "light",
							            value:"mapbox://styles/mapbox/light-v10?optimize=true"
							        },{
							            name : "dark",
							            value:"mapbox://styles/mapbox/dark-v10?optimize=true"
							        },{
							            name : "satellite",
							            value:"mapbox://styles/mapbox/satellite-v9?optimize=true"
							        },{
							            name : "satellite-streets",
							            value:"mapbox://styles/mapbox/satellite-streets-v11?optimize=true"
							        },{
							            name : "gray-white",
							            value:"mapbox://styles/commvault-maps/cjub8dh8r1kw91fpav6ap3dfy?optimize=true"
							       }];

								/** Map to track collapsed/expanded groups; values here are defaults */
								$scope.collapsed = {
									"general" : false,
									"sorting" : true,
									"options3d" : true,
									"labels" : true,
									"series" : true,
									"dimension" : true,
									"measure" : true,
									"storeProperties" : true,
									"looknfeel" : true,
									"binProperties" : false,
									"otherProperties" : true
								};

								$scope.timeOptions = [ {
									"label" : "Minutes",
									"value" : "Mi",
									"groupName" : "Duration"
								}, {
									"label" : "Hours",
									"value" : "H",
									"groupName" : "Duration"
								}, {
									"label" : "Days",
									"value" : "D",
									"groupName" : "Duration"
								}, {
									"label" : "Weeks",
									"value" : "W",
									"groupName" : "Duration"
								}, {
									"label" : "Months",
									"value" : "M",
									"groupName" : "Duration"
								}, {
									"label" : "Years",
									"value" : "Y",
									"groupName" : "Duration"
								} ];

								$scope.sizeOptions = [ {
									"label" : "",
									"value" : ""
								}, {
									"label" : "Bytes",
									"value" : "Bytes",
									"groupName" : "Size"
								}, {
									"label" : "KB",
									"value" : "KB",
									"groupName" : "Size"
								}, {
									"label" : "MB",
									"value" : "MB",
									"groupName" : "Size"
								}, {
									"label" : "GB",
									"value" : "GB",
									"groupName" : "Size"
								}, {
									"label" : "TB",
									"value" : "TB",
									"groupName" : "Size"
								}, {
									"label" : "PB",
									"value" : "PB",
									"groupName" : "Size"
								} ];


								$scope.fixedRangeOptions = function() {
									return $scope.sizeOptions.concat($scope.timeOptions);
								}
								$scope.getVariableOptions = function(type) {
									if (type === 'TIME') {
										return $scope.timeOptions;
									} else if (type === 'SIZE') {
										return $scope.sizeOptions;
									}
								}

								$scope.resetBinValues = function() {
									$scope.propData.binValues = [ {
										value : "",
										unit : ""
									} ];
								}

								$scope.updateVariables = function() {

									if ($scope.propData.binType === "CUSTOMBINWIDTH") {
										$scope.propData.binValues = undefined;
									} else {
										$scope.resetBinValues();
									}
								}

								$scope.setVarOptions = function(type) {
									$scope.varOptions = $scope.getVariableOptions(type);
								}

								$scope.addNewVariable = function(event) {
									if ($scope.propData.binType === "VARIABLEBINWIDTH") {
										$scope.propData.binValues.push({
											value : "",
											unit : ""
										});
									}
									event.stopPropagation();
								}

								$scope.deleteVariable = function(index) {
									$scope.propData.binValues.splice(index, 1);
								}

								// when some property changes like the aggregation type , we need to update the data in the component.
								$scope.updateComponent = function(componentId) {
									customReportSvc.triggerCallback("refreshComponent", componentId);
								}

								//Updates the data and layout
								$scope.refreshComponent = function(componentId) {
									customReportSvc.triggerCallback('refreshComponent', componentId);
								}
								//Updates only the layout; no server side call to get data
								$scope.redrawComponent = function(componentId) {
									customReportSvc.triggerCallback('redrawComponent', componentId);
								}

								$scope.enableMultiRowSelection = function(componentId){
									customReportSvc.triggerCallback('enableMultiRowSelection', componentId);
								}

								$scope.resetSelectedRows = function(componentId) {
									customReportSvc.triggerCallback('resetSelectedRows', componentId);
								}

								$scope.evalButtonsState = function(button){
									customReportSvc.triggerCallback('evalButtonsState', button);
								}

								$scope.propData;
								$scope.$watch('activeComponent', function(component) {
									if (component) {
										$scope.propData = component;
										$scope.oldId = $scope.propData.id;
										$scope.initProperties();
									}
								});
								// using angular events as callbacks are getting reset in page watch
								$scope.$on("comppnentDataSetUpdated", function(e, ds) {
									$scope.ds = ds;
								});

								$scope.properties = function() {
									console.log("Properties :::: " + $scope.propData);
								}

								$scope.getFieldLabel = function(chartType, axis) {
									return ((chartType == "Pie" || chartType == "Donut") ? (axis == "x" ? "Dimension"
											: "Measure") : (axis == "x" ? "X-Axis" : "Y-Axis"));
								}

								$scope.isNumberColumn1 = function(type) {
									var arr = [ 'Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal' ];
									return arr.indexOf(type) != -1 ? true : false;
								}

								$scope.isRDataSetAlreadyAvailable = function(dataSet) {
									if ($.isEmptyObject($scope.propData.rDataSetList) == true ||
											$.isEmptyObject($scope.propData.rDataSetList.rDataSets) == true) {
										return -1;
									}

									for (var i = 0, curDataSet; i < $scope.propData.rDataSetList.rDataSets.length; i++) {
										curDataSet = $scope.propData.rDataSetList.rDataSets[i];
										if (curDataSet.dataSet.dataSetGuid == dataSet.dataSetGuid) {
											return i;
										}
									}
									return -1;
								}

								$scope.excludeDataSet = function(inputDataSet) {
									var index = $scope.isRDataSetAlreadyAvailable(inputDataSet);

									if (index > -1) {
										$scope.propData.rDataSetList.rDataSets.splice(index, 1);
									}
								}

								$scope.updateIncludeAllColumns = function(dataSetGuid, includeAllColumns) {
									angular.forEach($scope.propData.rDataSetList.rDataSets, function(cur) {
										if (cur.dataSet.dataSetGuid == dataSetGuid) {
											cur.includeAllColumns = includeAllColumns;
											return;
										}
									});
								}

								$scope.updateIncludeField = function(dataSetGuid, field, includeField) {
									for (var i = 0, curDataSet; i < $scope.propData.rDataSetList.rDataSets.length; i++) {
										curDataSet = $scope.propData.rDataSetList.rDataSets[i];

										if (curDataSet.dataSet.dataSetGuid == dataSetGuid) {
											if (includeField == true) {
												curDataSet.fields.push(field);
											} else {
												for (var j = 0; j < curDataSet.fields.length; j++) {
													var curField = curDataSet.fields[j];
													if (curField.name == field.name) {
														curDataSet.fields.splice(j, 1);
														break;
													}
												}
											}
											break;
										}
									}

								}

								$scope.updateIncludeThisDataSet = function(inputDataSet, inputRDataSet) {

									if ($.isEmptyObject(inputDataSet) == true ||
											inputRDataSet.includeThisDataSet == undefined) {
										return;
									}

									if (inputRDataSet.includeThisDataSet == true) {
										var rDataSet = {
											dataSet : inputDataSet,
											includeThisDataSet : true,
											includeAllColumns : true,
											fields : [],
											dataFrameName : ""
										};
										$scope.propData.rDataSetList.rDataSets.push(rDataSet);

										if (inputRDataSet.includeAllColumns == undefined) {
											inputRDataSet.includeAllColumns = true;
										}
									} else {
										//exclude;
										$scope.excludeDataSet(inputDataSet);
									}//exclude

								}//func

								$scope.initializeRDataSet = function() {
									var dataSetGuid = "", isDataSetAdded, rDataSet, includeThisDataSet, includeAllColumn, dataFrameName;

									angular.forEach($scope.dataSets, function(dataSet) {
										dataSetGuid = dataSet.dataSet.dataSetGuid;
										isDataSetAdded = false;
										includeThisDataSet = false;
										includeAllColumn = true;
										dataFrameName = "";

										for (var i = 0; i < $scope.propData.rDataSetList.rDataSets.length; i++) {
											rDataSet = $scope.propData.rDataSetList.rDataSets[i];
											if (rDataSet.dataSet.dataSetGuid == dataSetGuid) {
												isDataSetAdded = true;

												includeThisDataSet = rDataSet.includeThisDataSet;
												includeAllColumn = rDataSet.includeAllColumns;
												dataFrameName = rDataSet.dataFrameName;
												break;
											}
										}//inner

										var curRDataSet = {
											dataSet : {},
											includeThisDataSet : includeThisDataSet,
											includeAllColumns : includeAllColumn,
											fields : [],
											dataFrameName : dataFrameName
										};

										dataSet.rDataSet = curRDataSet;

										for (var j = 0; j < dataSet.fields.length; j++) {
											var curField = dataSet.fields[j];
											var isAdded = false;

											if (isDataSetAdded && rDataSet.includeAllColumns == false) {

												for (var k = 0; k < rDataSet.fields.length; k++) {
													var curRField = rDataSet.fields[k];

													if (curField.name == curRField.name) {
														isAdded = true;
														break;
													}
												}//k

											}

											curField.isIncludedinR = isAdded;
										}//for;

									});//outer

								}
								$scope.reportInputs = [];
								$scope.initProperties = function() {
									$scope.selectedPropertyCategory = 'general';
									$scope.componentColumns = $scope.propData.columns ? $scope.propData.columns : [];
									var component = null;
									if($scope.propData.componentId){ // consider this column level
										var component = customReportSvc.getComponent($scope.propData.componentId,$scope.page.body.reportComponents);
										if(component != null){
											$scope.componentColumns = component.columns;
										}
									}
									$scope.componentId = $scope.propData.id;
									if (!$scope.componentId) {
										$scope.componentId = $scope.propData.comp && $scope.propData.comp.parentId;
									}
									$scope.formatterOptions = false;
									if ($scope.propData.dataSet) {
										$scope.ds = $scope.getDataSet($scope.propData.dataSet.dataSetName, 'name');
									}
									$scope.selectedProperties = '';
									$scope.datagridProperties = false;

									var isComponent;
									for (var i = 0; i < $scope.components.length; i++) {
										var comp = $scope.components[i];
										if (comp.componentType === $scope.propData.type) {
											isComponent = true;
											break;
										}
									}

									if ($scope.activeComponent.pageName !== undefined) {
										$scope.selectedProperties = "page";
									} else if ($scope.propData.type == undefined) {
										$scope.propData = $scope.propData;
										$scope.selectedProperties = "report";
									} else if ($scope.propData.type == "IFRAME") {
										$scope.selectedProperties = $scope.propData.type;
										var params = customReportSvc.getUrlParams($scope.propData.url);
										let reportId = params['reportId'];
										let pageName = params['pageName'];
										var promise2 = reportService.getCustomReport({
											reportId : reportId,
											includeDrafts : false,
											reportName : ""
										});
										promise2.then(function(response) {
											for (var i = 0; i < response.data.pages.length; i++) {
												if(response.data.pages[i].pageName === pageName){
													$scope.reportInputs = response.data.pages[i].inputs;
												}
											}
										});
										console.log(reportId);
									} else if ($scope.propData.type == "CHART" || $scope.propData.type == "HEAT_MAP") {
										$scope.propData = $scope.propData;
										$scope.selectedProperties = "chart";
										if ($scope.ds) {
											$scope.fields = $scope.ds.fields;
										}
									} else if ($scope.propData.type == "TABLE" || $scope.propData.type == "PIVOT_TABLE" || $scope.propData.type == "NEW_TABLE") {
										$scope.selectedProperties = "table";
										$scope.sortDirs = [ "Asc", "Desc" ];
										angular.forEach($scope.propData.columns, function(column, idx) {
											if (!column.mobileOptions) {
												column.mobileOptions = {
													visible : $scope.visibleOnMobile,
													viewOnList : true,
													viewOnDetail : true
												}
											}
											column.mobileOptions.visible = $scope.visibleOnMobile;
										});
									} else if ($scope.activeComponent.type === 'button') {
										$scope.propData = $scope.activeComponent.comp;
										$scope.selectedProperties = "button";
										delete $scope.propData.columns;
									} else {
										if (isComponent) {
											$scope.selectedProperties = $scope.propData.type;
										} else {
											//column selection
											$scope.selectedProperties = "column";
											if (!$scope.propData.mobileOptions) {
												$scope.propData.mobileOptions = {
													visible : $scope.visibleOnMobile,
													viewOnList : true,
													viewOnDetail : true
												}
											}
											$scope.column = $scope.propData;
											$scope.componentId = $scope.column.componentId;//needed to refresh the component.
											$scope.isNumberColumn = $scope.isNumberColumn1($scope.column.type);
											delete $scope.propData.columns;
											/*
											 * $scope.currColumnIndex = 0; for (var i = 0; i <
											 * $scope.propData.columns.length; i++) {
											 * if($scope.propData.columns[i].id ==
											 * $scope.propData.selectedCol.id){ $scope.column =
											 * $scope.propData.columns[i]; $scope.currColumnIndex = i;
											 * $scope.isNumberColumn =
											 * $scope.isNumberColumn1($scope.propData.columns[i].type); } };
											 * if ($scope.ds) $scope.fields = $scope.ds.fields;
											 */

											//this will remove the properties form getting saved into the JSON structure saved in the report definition.
											$scope.propData.colSelected = undefined;
											$scope.propData.selectedCol = undefined;
										}
									}

									if ($scope.propData.type == 'TOPOLOGY') {
										$scope.nodesDS = $scope
												.getDataSet($scope.propData.topologyProps.nodes.dataSet.dataSetName,
														'name');
										$scope.edgesDS = $scope
												.getDataSet($scope.propData.topologyProps.edges.dataSet.dataSetName,
														'name');
									}

									if ($scope.propData.type == "R-GGPlot") {
										$scope.initializeRDataSet();
									}
									if (isComponent) {
										if (!$scope.propData.mobile) {
											$scope.propData.mobile = {
												visible : 'On',
												listItemClick : {},
												customListLayout : null
											}
										}
									}

									$timeout(function() {
										$scope.$apply();
									});

								}

								$scope.writeJsToDom = function(modifiedConetnt) {
									customReportSvc.writeCustomScriptToDOM(modifiedConetnt);
									customReportSvc.triggerCallback("refreshTableData", $scope.propData.id);
								}

								$scope.writeCSSToDom = function(modifiedConetnt) {
									$scope.page.body.customStyle = modifiedConetnt;
									customReportSvc.writeCustomStyleToDOM($scope.page.body.customStyle);
								}

								$scope.addSystemFilter = function() {
									if (!$scope.page.systemFilters) {
										$scope.page.systemFilters = [];
									}
									$scope.viewMode = "Create";
									$scope.tableMode = false;
									$uibModal.open({
										templateUrl : customReports.contextPath + "/reportsplus/views/viewModal.jsp",
										controller : 'viewModalCtrl',
										scope : $scope
									});
								}

								$scope.editSystemFilter = function(view, index) {
									if (!$scope.page.systemFilters) {
										$scope.page.systemFilters = [];
									}
									$scope.viewMode = "Edit";
									$scope.tableMode = false;
									$scope.currentIndex = index;
									$scope.selectedView = view;
									$uibModal.open({
										templateUrl : customReports.contextPath + "/reportsplus/views/viewModal.jsp",
										controller : 'viewModalCtrl',
										scope : $scope
									});
								}

								$scope.deleteView = function(index) {
									$scope.page.systemFilters.splice(index, 1);
								}

								$scope.addSort = function() {
									if (!$scope.propData.columns || $scope.propData.columns.length === 0) {
										return;
									}

									if (!$scope.propData.sorting) {
										$scope.propData.sorting = [];
									}
									if ($scope.propData.sorting.length == 0 ||
											$scope.propData.sorting[$scope.propData.sorting.length - 1].columnId != "") {
										$scope.propData.sorting.push({
											columnId : "",
											direction : "Asc"
										});
										$scope.addButtonDisabled = true;
									}
								}

								$scope.deleteSort = function(index) {
									$scope.propData.sorting.splice(index, 1);
									$scope.refreshTableData();
								}

								$scope.modifyColumnProperties = function(dataField) {

									angular.forEach($scope.fields, function(value, key) {
										if (value.dataField == dataField) {
											$scope.column.type = value.type;
										}
									});

									$scope.refreshTableData();
								}

								//used for table
								$scope.removeColumn = function(col) {
									customReportSvc.triggerCallback("columnRemoved", col);
								}

								$scope.hideFilterColumn = function(index) {
									if ($scope.propData.type === 'NEW_TABLE') {
										customReportSvc.triggerCallback("gridHiddenColumn", {
											column: $scope.propData.columns[index].id,
											id: $scope.propData.id
										});
										return;
									}
									customReportSvc.triggerCallback("hiddenColumn", index);
									$scope.columnPropertyUpdated($scope.propData,"hidden");
								}

								$scope.deleteColumn = function(index) {
									$scope.propData.columns.splice(index, 1);
									$scope.updateComponent($scope.propData.id);
								}

								// button panel changed for a component only for table now.

								$scope.deleteButton = function(button) {
									customReportSvc.triggerCallback("buttonRemoved", button);
									$scope.propData = null;
									// $scope.closeProperties();
								}

								var enableRowSelectionAndRedraw = function(compId,column){
									customReportSvc.triggerCallback("enableRowSelection", {compId:$scope.propData.id,column:column});
								}

								$scope.checkAndEnableRowSelection= function(){
									enableRowSelectionAndRedraw($scope.propData.id);
								}

								$scope.enableRowSelection = function(onlyEnable) {
									if ($scope.propData.allcolumns) {
										enableRowSelectionAndRedraw($scope.propData.id);
										return;
									}
									var sys_rowidindex;
									var col = null;
									if ($scope.propData.columns && $scope.propData.columns.length > 0) {
										for (var i = 0; i < $scope.propData.columns.length; i++) {
											if ($scope.propData.columns[i].dataField === "sys_rowid") {
												sys_rowidindex = i;
												break;
											}
										}
									}
									if ($scope.propData.enableRowSelection && sys_rowidindex === undefined) {
										var ds = customReportSvc.getDataSet($scope.propData.dataSet.dataSetName,
												$scope.page.dataSets.dataSet);
										if(ds.endpoint === 'DATACUBE') {
											col = {
												aggrType : "None",
												dataField : "sys_rowid",
												displayName : "sys_rowid",
												hidden : true,
												id : "sys_rowid",
												origType : "string",
												type : "String",
												visible : false,
												mobileOptions : {
													visible : true,
													viewOnList : true,
													viewOnDetail : true
												}
											}
											$scope.propData.columns.push(col);
										} else {
											for (var i = 0; i < ds.fields.length; i++) {
												if (ds.fields[i].name === 'sys_rowid') {
													col = {
														aggrType : "None",
														dataField : ds.fields[i].name,
														displayName : "sys_rowid",
														hidden : true,
														id : "sys_rowid",
														origType : ds.fields[i].type,
														type : ds.fields[i].type,
														visible : false,
														mobileOptions : {
															visible : true,
															viewOnList : true,
															viewOnDetail : true
														}
													}
													$scope.propData.columns.push(col);

													break;
												}
											}
										}
									} else if (!$scope.propData.enableRowSelection && sys_rowidindex) {
										$scope.deleteColumn(sys_rowidindex);
									}
									enableRowSelectionAndRedraw($scope.propData.id,col);

								}

								$scope.changeSort = function(col, sortDir) {
									var colFound = false;
									if ($scope.propData.sorting == undefined) {
										$scope.propData.sorting = [];
									}

									angular.forEach($scope.propData.sorting, function(value, key) {
										if (value.dataField == col.dataField) {
											colFound = true;
											if (sortDir == "None") {
												$scope.propData.sorting.splice(key, 1);
											} else {
												value.direction = sortDir;
											}
										}
									});

									if (colFound == false && sortDir != "None") {
										$scope.propData.sorting.push({
											columnId : col.id,
											direction : sortDir
										});
									}

									customReportSvc.triggerCallback("refreshTableData", $scope.propData.id);
								}

								$scope.refreshTableData = function() {
									customReportSvc.triggerCallback("refreshTableData", $scope.propData.id);
								}

								$scope.reInitializeTable = function() {
									customReportSvc.triggerCallback("reInitializeTable", $scope.propData.id);
								}

								$scope.resetDefault = function() {
									customReportSvc.resetToDefault($scope.propData, true);
								};

								$scope.deleteSeries = function(index) {
									$scope.propData.seriesFormatting[index].selected = false;
									$scope.propData.seriesFormatting.splice(index, 1);
								}
								$scope.addCustomSeriesColor = function(event) {
									if (!$scope.propData.seriesFormatting) {
										$scope.propData.seriesFormatting = [];
									}
									var defaultColor = defaultMultiChartColors[$scope.propData.seriesFormatting.length];
									$scope.propData.seriesFormatting.push({
										value : "",
										color : defaultColor
									});
									event.stopPropagation();
								};

								$scope.isPieChartApplicable = function() {
									return ($scope.propData.dimensionDataField && $scope.propData.dimensionDataField.length <= 1) &&
											($scope.propData.measureDataField && $scope.propData.measureDataField.length <= 1) &&
											!$scope.propData.isDateTime;
								}

								$scope.isHeatMapApplicable = function() {
									return (!$scope.propData.dimensionDataField || $scope.propData.dimensionDataField.length >= 2) &&
											(!$scope.propData.measureDataField || $scope.propData.measureDataField.length <= 1);
								}

								$scope.isTileStatusChartApplicable = function() {
									return $scope.isTileBuilder;
								}

								$scope.isTreeMapApplicable = function() {
									return (!$scope.propData.dimensionDataField || $scope.propData.dimensionDataField.length >= 1) &&
											(!$scope.propData.measureDataField || $scope.propData.measureDataField.length <= 1);
								}

								$scope.isYSortApplicable = function() {
									return !(($scope.propData.dimensionDataField && $scope.propData.dimensionDataField.length > 1)) &&
											$scope.propData.chartType != 'TimeSeries' &&
											!($scope.propData.measureDataField && $scope.propData.measureDataField.length > 1); //reports like Backup summary requires sorting on y axis
								}

								$scope.isAlreadySelected = function(value) {

									angular.forEach($scope.propData.sorting, function(value, key) {
										if (value == value.dataField) {
											return true;
										}
									});

									return false;
								}
								$scope.deleteMeasure = function(index) {
									$scope.propData.measureDataField.splice(index, 1);
								}
								//this method is only for hits component
								$scope.deleteAllColumns = function() {
									$scope.propData.allColumns = undefined;
								}
								$scope.deleteDimension = function(index) {
									$scope.propData.dimensionDataField.splice(index, 1);
								}

								$scope.updateChart = function(redrawChart) {
									customReportSvc.triggerCallback("updateChart", redrawChart, $scope.propData.id);
								}

								$scope.changeAggregation = function() {
									$scope.propData.yAxisTitle.text = null;
									if ($scope.propData.chartType === 'heatmap') {
										$scope.propData.heatMapCell.aggrType = $scope.propData.measureDataField[0].aggrType;

									}
									$scope.updateChart();
								}

								$scope.validateRelativeTime = function() {
									customReportSvc.triggerCallback("validateRelativeTime");
								}

								$scope.validateComponentId = function() {
									if (!$scope.propData.id) {
										customReportSvc.errorToast("Please enter a valid ID."); // TODO: localize
									} else {
										$scope.reportLayout[$scope.propData.id] = $scope.reportLayout[$scope.oldId];
										delete $scope.reportLayout[$scope.oldId];
										$scope.oldId = $scope.propData.id;
									}
								};

								$scope.showAdditionalProperties = function(dimension, dataSetName) {
									$scope.dataSetName = dataSetName;
									$(".additional-properties").css("right", $('#rightCol').width());
									$scope.hideFormatterOptions();
									$scope.propData.additionalProperties = true;
									$scope.selectedDimension = $.extend(true, {}, dimension); // deep copy
									if ($.isEmptyObject($scope.selectedDimension.groups)) {
										$scope.selectedDimension.groups = [];
									}
								}

								$scope.showMapFilterInputOptions = () => {
									$(".additional-properties").css("right", $('#rightCol').width());
									$scope.hideFormatterOptions();
									$scope.propData.showMapFilterInputOptions = true;
									if($scope.propData.columns && $scope.propData.columns.length) {
										$scope.filterColumn = $.extend(true, {},$scope.propData.categoryColumn);// deep copy
										if(!$scope.filterColumn.mapFilters)
											$scope.filterColumn.mapFilters = [];
									}
								}

								$scope.hideMapFilterInputOptions = () => {
									$scope.propData.showMapFilterInputOptions = false;
								}

								$scope.addFiltersToComponentColumn = () => {
									$scope.propData.categoryColumn.mapFilters = $scope.filterColumn.mapFilters.filter(mapFilter => mapFilter.value);
									if($scope.filterColumn.includeUngrouped) {
										$scope.propData.categoryColumn.includeUngrouped = true;
										$scope.propData.categoryColumn.ungroupedLabel = $scope.filterColumn.ungroupedLabel;
										$scope.propData.categoryColumn.ungroupedColor =  $scope.filterColumn.ungroupedColor;
									}
									$scope.hideMapFilterInputOptions();
									$scope.refreshComponent($scope.propData.id);
								}

								

								$scope.hideAdditionalProperties = function() {
									$scope.propData.additionalProperties = false;
								}

								$scope.updateCustomGroupsAvailable = function(dimension) {
									//dimension.customGroupsAvailable = !dimension.customGroupsAvailable;
									/*
									 * if (!dimension.customGroupsAvailable &&
									 * !$.isEmptyObject(dimension.groups)) { //dimension.groups = []; } else {
									 * //dimension.groups = []; }
									 */
									$scope.triggerRefreshOnCustomGroupEdit();
									$scope.hideAdditionalProperties();
								}

								$scope.addCustomGroupsToDimension = function() {
									var dimension = {};
									//TODO: check this logic
									var arr = ($scope.propData.categoryColumn && [ $scope.propData.categoryColumn ]) ||
												($scope.propData.pieColumn && [ $scope.propData.pieColumn ]) ||
												$scope.propData.dimensionDataField ||
												$scope.propData.columns ||
												$scope.propData.filterDataField['viewer'][$scope.dataSetName]['fields'];

									angular.forEach(arr, function(field) {
										if (field.column === $scope.selectedDimension.column) {
											dimension = field;
											return;
										}
									});
									dimension.groups = [];
									angular.forEach($scope.selectedDimension.groups, function(group) {
										if ($.trim(group.groupName) != "" && $.trim(group.groupValues != "")) {
											dimension.groups.push(group);
										}
									});
									dimension.includeMissingGroups = $scope.selectedDimension.includeMissingGroups;
									dimension.includeUngrouped = $scope.selectedDimension.includeUngrouped;
									dimension.ungroupedLabel = $scope.selectedDimension.ungroupedLabel;
									$scope.hideAdditionalProperties();
									$scope.triggerRefreshOnCustomGroupEdit();
								}

								$scope.triggerRefreshOnCustomGroupEdit = function() {
									if ($scope.propData.type === 'KENDO_TREEGRID') {
										customReportSvc.triggerCallback("reInitializeTable", $scope.propData.id);
									} else if ($scope.propData.type === 'FACET' || $scope.propData.type === 'MAP'
										|| $scope.propData.type === 'MAP_v2') {
										$scope.refreshComponent($scope.propData.id);
									} else {
										customReportSvc.triggerCallback("updateChart", true, $scope.propData.id);
									}
								}

								$scope.updateAutoRefreshOption = function() {
									$timeout(() => {
										$scope.page.body.isAutoRefreshShow = $scope.page.body.autoRefresh;									
									});
									$scope.startAutoRefreshTimer(false)
								}

								$scope.getFormatterType = function(formatter) {
									if (typeof formatter === 'string') {
										return 'Custom';
									} else if (typeof formatter === 'undefined') {
										return 'None';
									} else {
										var formatType = formatter.type;
										return formatType[0].toUpperCase() + formatType.substr(1);
									}
								}
								$scope.updateFormatterOptions = function() {
									var formatters = $scope.formatters;
									if (formatters.render.type === 'custom') {
										formatters.formatField[formatters.formatKey] = formatters.render.customformat;
									} else {
										formatters.formatField[formatters.formatKey] = formatters.render;
									}
									if ($scope.propData.type === 'CHART') {
										$scope.updateChart(true);
									} else if ($scope.propData.type === 'TABLE' ||
											$scope.propData.type === 'KENDO_GRID' ||
											$scope.propData.type === 'NEW_TABLE' ||
											$scope.propData.type === 'KENDO_TREEGRID' ||
											$scope.propData.type === 'LEGEND') {
										$scope.updateComponent($scope.propData.id);
									} else if ($scope.propData.type === 'MAP_v2') {
										$scope.redrawComponent($scope.propData.id);
									} else {
										$scope.refreshComponent($scope.componentId || $scope.propData.id);
									}
									$scope.hideFormatterOptions();
								}
								$scope.showFormatterOptions = function(field, formatKey) {
									$(".additional-properties").css("right", $('#rightCol').width());
									$scope.hideAdditionalProperties();
									$scope.formatterOptions = true;
									$scope.selFieldType = field.type;
									$scope.formatters = {
										'formatField' : field,
										'formatKey' : formatKey,
										'render' : {
											'type' : 'none',
											'source' : 'bytes',
											'target' : 'relative',
											'fmt' : 'comma',
											'customformat' : '',
											'tofixed' : 2,
											'customDateFormat' : '',
											'targetWindow' : '_blank',
											'srcTimezone' : 'GMT'

										}
									};
									if (typeof field[formatKey] === 'string') {
										$scope.formatters.render.type = 'custom';
										$scope.formatters.render.customformat = field[formatKey];
									} else if (!$.isEmptyObject(field[formatKey])) {
										if (field[formatKey]['type'] === 'link' && field[formatKey]['linkString']) {
											field[formatKey].link = $scope.getLinkObj();
											field[formatKey].link.events.onClick = {
												"action" : "Link",
												"URL" : field[formatKey]['linkString']
											}

											if (field[formatKey]['targetWindow'] === "_blank") {
												field[formatKey].link.events.onClick.openInNewTab = true;
											}
											field[formatKey]['linkString'] = undefined;
										}
										$scope.formatters.render = field[formatKey];
									}
									$timeout(function() {
										$(".formatters-properties","#reportArea").resizable({"handles" : "n, e, s, w,ne, se, sw, nw"});
									});

								}

								$scope.getLinkObj = function() {
									return {
										title : {
											text : "=cellData"
										},
										enable : "always", // can be an expression
										enableExpression : "",
										visible : "always",
										visibleExpression : "",
										type : "link",
										events : {
											onClick : {}
										}
									};
								}
								$scope.updateRenderer = function(type) {
									if ($scope.formatters.render.type === 'link') {
										$scope.formatters.render.link = $scope.getLinkObj();
									} else if ($scope.formatters.render.link) {
										$scope.formatters.render.link = undefined;
									}
								}

								$scope.$watch('propData.mobile.visible', function(newValue) {
									if (newValue !== undefined) {
										if ($scope.visibleOnMobile === newValue == 'On') {
											// console.log('son iguales');
										} else {
											$scope.visibleOnMobile = newValue == 'On';
											angular.forEach($scope.propData.columns, function(column, idx) {
												if (column.mobileOptions) {
													column.mobileOptions.visible = $scope.visibleOnMobile;
												}
											});
										}
									}
								})

								$scope.$watch('formatters.render.type', function(newValue, oldValue) {
									//Below is not the correct solution for the issue. We need to fix it properly.
									var sourceValsForDuration = [ "milliseconds", "seconds", "minutes" ];
									var sourceValsForSize = [ "bytes", "kb", "mb", "gb", "tb", "pb" ];
									var fmtValsForDate = [
											"Auto",
											"AutoDateTime",
											"DD-MM-YYYY",
											"DD-MMM-YYYY",
											"MM-DD-YYYY",
											"Do-MMM-YYYY",
											"DD-MM-YYYY HH:mm:ss",
											"Custom" ];
									var fmtValsForNumber = [ "comma", "string" ];
									if (newValue === 'date' &&
											$.inArray($scope.formatters.render.fmt, fmtValsForDate) === -1) {

										if($scope.integerTypes.indexOf($scope.selFieldType) !== -1) {
											$scope.formatters.render.fmt = "Auto";
											$scope.formatters.render.srcFmt = "ts";
										} else
											$scope.formatters.render.fmt = "AutoDateTime";

									} else if (newValue === 'number' &&
											$.inArray($scope.formatters.render.fmt, fmtValsForNumber) === -1) {
										$scope.formatters.render.fmt = "comma";
									} else if (newValue === 'duration' &&
											$.inArray($scope.formatters.render.source, sourceValsForDuration) === -1) {
										$scope.formatters.render.source = "milliseconds";
									} else if (newValue === 'size' &&
											$.inArray($scope.formatters.render.source, sourceValsForSize) === -1) {
										$scope.formatters.render.source = "bytes";
									}
								});

								$scope.$watch('selectedDimension.includeUngrouped', function(newValue, oldValue) {
									if(oldValue !== undefined && newValue !== undefined && newValue !== oldValue && newValue && !$scope.selectedDimension.ungroupedLabel)
									{
										$scope.selectedDimension.ungroupedLabel = "Others"; //default value
									}
								});


								$scope.hideFormatterOptions = function() {
									$scope.formatterOptions = false;
								}

								$scope.toggleAggrType = function(field, aggrType) {
									var aggrIdx = -1;
									if ((aggrIdx = field.aggrTypes.indexOf(aggrType)) === -1) {
										field.aggrTypes.push(aggrType);
									} else {
										field.aggrTypes.splice(aggrIdx, 1);
									}
									$scope.refreshComponent($scope.propData.id);
								}
								// filter panel related functions
								$scope.addAggregate = function(measure, index, aggrType) {
									if (index === -1) {
										if (measure.aggrTypes.length !==0 && ((measure.showNumberOps && $scope.aggrTypesForNumber.length <= measure.aggrTypes.length) ||
												(!measure.showNumberOps && $scope.aggrTypesForString.length <= measure.aggrTypes.length))) {
											return;
										}

										measure.aggrTypes.push(aggrType);
										measure.aggrDisplayNames.push(aggrType);

									} else {
										measure.aggrTypes[index] = aggrType;
										measure.aggrDisplayNames[index] = measure.column + '_' + aggrType;
										$scope.refreshComponent($scope.propData.id);
									}

								}
								$scope.deleteAggregate = function(measure, index) {
									measure.aggrTypes.splice(index, 1);
									measure.aggrDisplayNames.splice(index, 1);
								}
								$scope.showFieldsFromDataSet = function(dataSetName) {
									$scope.ds = $scope.getDataSet(dataSetName, 'name');
									$scope.showMeasureDropDown = true;
								}
								$scope.addMeasureToFilterPanel = function(selectedMeasureField, field, type) {
									var data = {
										'selectedMeasureField' : selectedMeasureField,
										'field' : field,
										'type' : type
									};
									$scope.showMeasureDropDown = false;
									customReportSvc
											.triggerCallback('addMeasureToFilterPanel', data, $scope.propData.id);
								};
								$scope.deleteFilterDimension = function(dataSetName, filterMode, dimensionIndex) {
									$scope.propData.filterDataField[filterMode][dataSetName].fields
											.splice(dimensionIndex, 1);
								};
								$scope.deleteFilterMeasure = function(field, measureIndex) {
									if(field.measureDataFields.length === 1) {
										field.measureDataFields[0].aggrDisplayNames = [];
										field.measureDataFields[0].aggrTypes = [];
									}
									else
										field.measureDataFields.splice(measureIndex, 1);
								};

								$scope.addPanelHeaderComponent = function() {
									var i = $scope.propData.panelHeaderComponents.length + 1;
									$scope.propData.panelHeaderComponents.push({
										title : {
											text : "Panel Header Component" + i
										},
										id : "panelheadercomponnent" + i,
										enable : "always",
										enableExpression : "",
										type : "",
										visible : "always",
										visibleExpression : "",
										onLinkType : "Link" // special for Links only
									});
								}

								/* Deleting Header Component */
								$scope.deletePanelHeaderCompoent = function(panelHeaderComponentIndex) {
									$scope.propData.panelHeaderComponents.splice(panelHeaderComponentIndex, 1);
								}

								/* Adding Header Component Menu Items */

								$scope.addPanelHeaderComponentMenuItems = function(currentPanelHeaderComponentIndex) {
									if (!$scope.propData.panelHeaderComponents[currentPanelHeaderComponentIndex].items) {
										$scope.propData.panelHeaderComponents[currentPanelHeaderComponentIndex].items = [];
									}
									var len = $scope.propData.panelHeaderComponents[currentPanelHeaderComponentIndex].items.length + 1;

									$scope.propData.panelHeaderComponents[currentPanelHeaderComponentIndex].items
											.push({
												title : {
													text : "Item" + len
												},
												id : "item" + len,
												enable : "always", // can be an expression
												enableExpression : "",
												visible : "always",
												visibleExpression : "",
												onClickType : "link",
												itemAttributes : {
													style : "background-color:#333;"
												},
												events : [ {
													onClick : ""
												} ]
											});
								}

								/* Deleting Header Component Menu Items */
								$scope.deletePanelHeaderComponentMenuItem = function(panelHeaderComponentIndex,
										itemIndex) {
									$scope.propData.panelHeaderComponents[panelHeaderComponentIndex].items
											.splice(itemIndex, 1);
								}

								$scope.addComponent = function() {
									if (!$scope.column.components) {
										$scope.column.components = [];
									}
									var i = $scope.column.components.length + 1;
									$scope.column.components.push($scope.getComponent("Component", i));

								}

								$scope.deleteComponent = function(i) {
									$scope.column.components.splice(i, 1);
								}

								$scope.addMenuItems = function(currentComponentIndex) {
									if (!$scope.column.components[currentComponentIndex].items) {
										$scope.column.components[currentComponentIndex].items = [];
									}
									var len = $scope.column.components[currentComponentIndex].items.length + 1;

									$scope.column.components[currentComponentIndex].items.push($scope
											.getComponent("Item", len));
								}

								$scope.getComponent = function(preText, i) {
									return {
										title : {
											text : preText + i
										},
										id : preText + i,
										enable : "always",
										enableExpression : "",
										type : "",
										visible : "always",
										visibleExpression : "",
										onLinkType : "Link", // special for Links only,
										events : {
											onClick : {

											}
										},
										mobile : {
											viewOnDetail : true,
											viewOnList : true,
										}
									}
								}

								$scope.deleteMenuItem = function(componentIndex, itemIndex) {
									$scope.column.components[componentIndex].items.splice(itemIndex, 1);
								}

								$scope.clickExpressionTypes = [ "Workflow", "Report", "Link", "Custom" ];
								$scope.clickExpressionTypes = [ {
									"label" : "None",
									"value" : ""
								}, {
									"label" : "Run a workflow",
									"value" : "Workflow"
								}, {
									"label" : "Open Report",
									"value" : "Report"
								}, {
									"label" : "Url",
									"value" : "Link"
								}, {
									"label" : "Custom",
									"value" : "Custom"
								} ];
								$scope.entities = {
									Workflow : [],
									Report : []
								};

								// Loads options to handle onClick events based on selection
								$scope.getEntitiesOfType = function(type, componentIndex) {
									$scope.entityMap = {};
									if (!$scope.workflows) {
										$scope.workflows = [];
										$scope.workflowEntities = {};
									}
									if (!$scope.reports) {
										$scope.reports = [];
										$scope.reportEntities = {};
									}
									$scope.column.components[componentIndex].clickExpression = "";
									if (type === 'Custom') {
										$scope.column.components[componentIndex].clickExpression = $scope.column.components[componentIndex].customExpression;
									} else if (type === 'Workflow') {
										if ($scope.workflows.length === 0) {
											var promise = reportService.getForms();
											promise
													.then(function(response) {
														for (var i = 0; i < response.data.container.length; i++) {
															$scope.workflows.push({
																name : response.data.container[i].entity.workflowName
															});
															$scope.workflowEntities[response.data.container[i].entity.workflowName] = response.data.container[i];
														}
													});
										}
										$scope.entities.Workflow = $scope.workflows;
									} else if (type === 'Report') { // put page init stuff here. please
										if ($scope.reports.length === 0) {
											var promise = reportService.getReportsList();
											promise.then(function(response) {
												for (var i = 0; i < response.data.reports.length; i++) {
													$scope.reports.push({
														name : response.data.reports[i].reportName
													});
												}
											});
										}
										$scope.entities.Report = $scope.reports;
										if ($scope.column.components[componentIndex].clickParams.name) {
											$scope.pages = [];
											$scope.pageMap = {};
											var promise2 = reportService.getCustomReport({
												reportId : 0,
												includeDrafts : false,
												reportName : $scope.column.components[componentIndex].clickParams.name
											});
											promise2
													.then(function(response) {
														for (var i = 0; i < response.data.pages.length; i++) {
															$scope.pages.push({
																name : response.data.pages[i].pageName
															});
															$scope.pageMap[response.data.pages[i].pageName] = response.data.pages[i];
														}
													});
										}
									}
								}

								// when selected workflow or report is changed
								$scope.onSelectedEntityChanged = function(name, componentIndex, type) {
									var obj = {};
									$scope.inputs = [];
									$scope.column.components[componentIndex].clickParams.inputs = [];
									if (type == 'Workflow') {
										obj = $scope.workflowEntities[name];
										if (obj.inputForm.entries) {
											for (var i = 0; i < obj.inputForm.entries.length; i++) {
												$scope.inputs.push({
													id : obj.inputForm.entries[i].inputName,
													value : ""
												});
											}
											$scope.column.components[componentIndex].clickParams.inputs = $scope.inputs;
										}

									} else if (type === 'Report') {
										$scope.pages = [];
										$scope.pageMap = {};
										if (!$scope.reportEntities[name]) {
											var promise = reportService.getCustomReport({
												reportId : 0,
												includeDrafts : false,
												reportName : name
											});
											promise
													.then(function(response) {
														for (var i = 0; i < response.data.pages.length; i++) {
															$scope.pages.push({
																name : response.data.pages[i].pageName
															});
															$scope.pageMap[response.data.pages[i].pageName] = response.data.pages[i];
														}
														if ($scope.pageMap[$scope.pages[0].name].inputs) {
															for (var i = 0; i < $scope.pageMap[$scope.pages[0].name].inputs.length; i++) {
																$scope.column.components[componentIndex].clickParams.inputs
																		.push({
																			id : $scope.pageMap[$scope.pages[0].name].inputs[i].id,
																			value : ''
																		});
															}
														}
														$scope.reportEntities[name] = response.data;
														$scope.column.components[componentIndex].clickParams.reportId = response.data.report.customReportId;
													});
										} else {
											var currentReport = $scope.reportEntities[name];
											$scope.column.components[componentIndex].clickParams.reportId = currentReport.report.customReportId;
											for (var i = 0; i < currentReport.pages.length; i++) {
												$scope.pages.push({
													name : currentReport.pages[i].pageName
												});
												$scope.pageMap[currentReport.pages[i].pageName] = currentReport.pages[i];
											}
											$scope.column.components[componentIndex].clickParams.pageName = currentReport.pages[0].pageName;
											$scope.column.components[componentIndex].clickParams.inputs = $scope.pageMap[$scope.column.components[componentIndex].clickParams.pageName].inputs;
										}
									}
								}

								$scope.onSelectedPageChanged = function(pageName, componentIndex) {
									$scope.inputs = $scope.pageMap[pageName].inputs;
									$scope.column.components[componentIndex].clickParams.inputs = $scope.inputs;
								}

								//				$scope.addParams = function(currentComponentIndex, currentItemIndex) {
								//					if (!$scope.column.components[currentComponentIndex].items[currentItemIndex].params) {
								//						$scope.column.components[currentComponentIndex].items[currentItemIndex].params = [];
								//					}
								//					$scope.column.components[currentComponentIndex].items[currentItemIndex].params.push({
								//						paramKey : "",
								//						paramValue : ""
								//					});
								//				}

								$scope.insertTopologyVariable = function(parameter, property) {
									var modalInstance = $uibModal.open({
										templateUrl : "reportVariables/insertVariable.jsp",
										controller : "insertVariableCtrl",
										backdrop : 'static',
										keyboard : false,
										resolve : {
											page : function() {
												return $scope.page;
											},
											component : function() {
												for (var i = 0; i < $scope.page.body.reportComponents.length; i++) {
													if ($scope.page.body.reportComponents[i].id = $scope.componentId) {
														return $scope.page.body.reportComponents[i];
													}
												}
											},
											modalParams : function() {
												return {
													entityToAdd : parameter
												};
											}
										}
									});

									modalInstance.result.then(function(response) {
										if (response !== undefined) {
											$scope.propData.topologyProps[parameter][property]
											if ($scope.propData.topologyProps[parameter][property] === undefined) {
												$scope.propData.topologyProps[parameter][property] = '';
											}
											$scope.propData.topologyProps[parameter][property] += 'row[\'' +
													response[0].entity.label + '\']';
										}
									});
								}

								//should below two functions be moved? They're copied from modal.js
								$scope.showInsertVariable = function(input) {
									$scope.setCurrentInput(input);
									var modalInstance = $uibModal.open({
										templateUrl : "reportVariables/insertVariable.jsp",
										controller : "insertVariableCtrl",
										backdrop : 'static',
										keyboard : false,
										resolve : {
											page : function() {
												return $scope.page;
											},
											component : function() {
												for (var i = 0; i < $scope.page.body.reportComponents.length; i++) {
													if ($scope.page.body.reportComponents[i].id === $scope.componentId) {
														return $scope.page.body.reportComponents[i];
													}
												}
											},
											modalParams : function() {
												return {
													entityToAdd : "input"
												};
											}
										}
									});

									modalInstance.result.then(function(response) {
										if (response !== undefined) {
											let label = response[0].parent.entity.label + "['" + response[0].label +"']";
											input.value = $scope.propData.type === "IFRAME" ? "="+label : label;
										}
									});
								};

								$scope.setCurrentInput = function(input) {
									$scope.currentInput = input;
								};

								// add input variable receiving response from a GET API
								$scope.addPageVariable = function($event) {
									if (!$scope.propData.body.pageVariales) {
										$scope.propData.body.pageVariables = [];
									}
									$scope.propData.body.pageVariables.push({
										"variableName" : "",
										"variableRestApi" : ""
									});
									$event.stopPropagation();
								};
								$scope.deletePageVariable = function($index) {
									$scope.propData.body.pageVariables.splice($index, 1);
								};

								$scope.openAceEditor = function(editorContent,editorMode,callback,dataVariable,scope,inputType) {
									//for page script we are directly appending the script to dom then we don't need to preceed expression with :=
									if(dataVariable !== "page.body.customJsCode" && !editorContent && editorMode === "javascript")
                    					editorContent = ":="
                    				if(!scope)
										scope = $scope;
									let inputVarObj = {};
									if($scope.propData.type == 'MAP_v2') {
										switch(inputType) {
											case 'props' : 
												inputVarObj['props'] =  $scope.propData.categoryColumn.mapFilters;
												break;

											case 'exp' : 
												const type =  $scope.propData.categoryColumn.type;
												const operators = customReportSvc.getFilterOpsForHtmlCluster(type);
												inputVarObj['operations'] = operators.map(op => {
													return op.includes('contains') ? {name:op,endExp:':'} : {name:op}
												});
												break;

											default : 
												let inputs;
												if($scope.propData.inputType === 'cc') {
													inputs = [$scope.propData.countrycode,...$scope.propData.columns];
													if($scope.propData.categoryColumn)
														inputs = [...inputs, $scope.propData.categoryColumn];
												} else {
													inputs = [$scope.propData.latitude, $scope.propData.longitude,...$scope.propData.columns]
												}
												inputVarObj["row"] = inputs;
										}
									}
									
									$scope.openAceEditorWindow(editorContent,editorMode,dataVariable,scope,inputVarObj,function(modifiedContent) {
										if(callback) {
											if (typeof callback === "function")
												callback(modifiedContent);
											else
												$scope.$eval(callback);
										}


								   });
								}

								$scope.columnPropertyUpdated = function(column,property,oldValue){
									customReportSvc.triggerCallback("columnPropertyUpdated", {column:column,property:property,oldValue:oldValue});
								}

								$scope.maxReleaseIDs = [ {
									value : 100,
									label : ""
								}, {
									value : 16,
									label : "11"
								}, {
									value : 17,
									label : "12"
								} ];

								$scope.minSPValues=[];
								for(var valueSP=0;valueSP<100;valueSP++){
									if(valueSP==0){
										$scope.minSPValues.push({ value: valueSP, label: "" });
									}
									else{
										$scope.minSPValues.push({ value: valueSP, label: valueSP.toString() });
									}
								}    

								$scope.maxSPValues = [ {
									value : 99,
									label : ""
								}, {
									value : 1,
									label : "1"
								}, {
									value : 2,
									label : "2"
								}, {
									value : 3,
									label : "3"
								}, {
									value : 4,
									label : "4"
								}, {
									value : 5,
									label : "5"
								}, {
									value : 6,
									label : "6"
								}, {
									value : 7,
									label : "7"
								}, {
									value : 8,
									label : "8"
								}, {
									value : 9,
									label : "9"
								}, {
									value : 10,
									label : "10"
								}, {
									value : 11,
									label : "11"
								}, {
									value : 12,
									label : "12"
								}, {
									value : 13,
									label : "13"
								}, {
									value : 14,
									label : "14"
								}, {
									value : 15,
									label : "15"
								}, {
									value : 16,
									label : "16"
								}, {
									value : 17,
									label : "17"
								}, {
									value : 18,
									label : "18"
								}, {
									value : 19,
									label : "19"
								}, {
									value : 20,
									label : "20"
								} ];

								$scope.addInputsToFrameComponent = function(input){
									if(!$scope.propData.inputs){
										$scope.propData.inputs = [];
									}
									$scope.propData.inputs.push({id:input.id,displayName:input.displayName,value:""});
								}

								$scope.deleteInputFromFrameComponent = function(index){
									$scope.propData.inputs.slice(index,1);
								}

								$scope.resetLegendHTML = function() {
									customReportSvc.triggerCallback("resetLegendHTMLTemplate");
								}

							} ]); // end controller propertiesCtrl
})();
