// Closure to isolate scope, as per best practices
(function() {
	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");

	app.directive("componentProperties", function() {
		return {
			restrict : 'AEC',
			templateUrl : customReports.contextPath + '/reportsplus/properties/panelComponentProperties.jsp',
			scope : {
				component : '='
			},
			controller : [ "$scope", "reportService", "$uibModal", function($scope, reportService, $uibModal) {
				// Backward compatibility
				if (!$scope.component.mobile) {
					$scope.component.mobile = {
						viewOnList : true,
						viewOnDetail : true,
					}
				}

				$scope.addMenuItems = function(currentComponentIndex) {
					if (!$scope.component.items) {
						$scope.component.items = [];
					}
					var len = $scope.component.items.length + 1;
					var itemComp = $scope.$parent.getComponent("Item", len);
					itemComp.type = "MenuItem";
					$scope.component.items.push(itemComp);
				}
			} ]

		};
	});

})();