<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
<div class="additional-properties panel panel-info" data-ng-show="propData.additionalProperties" cv-draggable data-handler=".panel-heading">
    <div class="panel-heading text-align-center">
        <h3 class="panel-title">{{selectedDimension.column}}            
        </h3>
    </div>
    <div class="panel-body">                
        <div class="row noLftRghtMargin" data-ng-repeat="group in selectedDimension.groups" style="margin-top:6px;"> 
            <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4 group-info">
                <input type="text" name="" data-ng-model="group.groupName" id="input" class="form-control-input" value="" pattern="" title="" placeholder="Group Name">
            </div>                    
            <div class="col-xs-8 col-sm-8 col-md-8 col-lg-8 group-info input-group">
                    <input type="text" name="" data-ng-model="group.groupValues" class="form-control-input" value="" pattern="" title="" placeholder="Group Values">
                    <!-- <span class="input-group-addon group-buttons glyphicon glyphicon-plus" title="Add Group" data-ng-click="selectedDimension.groups.splice($index+1,0,{'groupName' : '', 'groupValues': ''})"></span> -->            
                    <span class="input-group-addon group-buttons glyphicon glyphicon-trash" title="Delete Group"  data-ng-click="selectedDimension.groups.splice($index,1)"></span>
            </div>                
        </div> 
        <div class="add-new-group text-align-center">
            <button type="button" class="btn btn-default" data-ng-click="selectedDimension.groups.push({'groupName' : '', 'groupValues': ''})">
                <span class="sprite reports-actions-newreport" style="vertical-align: middle;"></span>
                Add Group
            </button>
        </div>        
      <div class="row" >  
            <label class="col-sm-10">
               <fmt:message key="CustomReport.Properties.IncludeGroupsWithNoData"/>
            </label>
                <div class="col-sm-2">
                     <div class="on-off-switch">
                        <input type="checkbox" name="on-off-switch" data-ng-model="selectedDimension.includeMissingGroups" class="on-off-switch-checkbox" id="missingGroups">
                        <label class="on-off-switch-label" for="missingGroups">
                            <span class="on-off-switch-inner"></span>
                            <span class="on-off-switch-switch"></span>
                        </label>
                    </div> 
                </div>
     </div>   
     <div class="row" >            
            <label class="col-sm-10">
               <fmt:message key="CustomReport.Properties.IncludeValuesNotPartOfGroups"/>
            </label>
                <div class="col-sm-2">
                    <div class="on-off-switch">
                        <input type="checkbox" name="on-off-switch" data-ng-model="selectedDimension.includeUngrouped" class="on-off-switch-checkbox" id="includeUngrouped">
                        <label class="on-off-switch-label" for="includeUngrouped">
                            <span class="on-off-switch-inner"></span>
                            <span class="on-off-switch-switch"></span>
                        </label>
                    </div>  
                </div>                
     </div>
         <div class="row" ng-if="selectedDimension.includeUngrouped" >
            <label class="col-sm-6">
               <fmt:message key="CustomReport.Properties.LabelForValuesNotPartOfGroups"/>
            </label>
            <div class="col-sm-6">               
                <input type="text" data-ng-model="selectedDimension.ungroupedLabel"/>                                
            </div>
         </div>
    </div>
    <div class="panel-footer">
        <div class="pull-right">
            <button type="button" class="btn btn-sm btn-info" data-ng-click="addCustomGroupsToDimension()">
               <fmt:message key="Apply"/>
            </button>
            <button type="button" class="btn btn-sm btn-warning" data-ng-click="hideAdditionalProperties()">
               <fmt:message key="CustomReport.Cancel"/>
            </button>
        </div>
    </div>
</div>
<div class="formatters-properties additional-properties panel panel-info" data-ng-if="formatterOptions" cv-draggable data-handler=".panel-heading">
    <div class="panel-heading text-align-center">
        <h3 class="panel-title">Formatter            
        </h3>
    </div>
    <div class="panel-body">        
            <div class="row noLftRghtMargin">
                <label for="inputFormatType" class="col-sm-4 noLftRghtPadding control-label">Type</label>
                <div class="col-sm-8 noLftRghtPadding ">
                    <select name="formatType" id="inputFormatType" class="form-control" data-ng-model="formatters.render.type" data-ng-change="updateRenderer(formatters.render.type)">
                        <option value="none">None</option>
                        <option value="number">Number</option>
                        <option value="size">Size</option>
                        <option data-ng-if="dateTypes.concat(integerTypes).indexOf(selFieldType) !== -1" value="date">Date</option>
                        <option value="boolean" data-ng-hide="propData.type === 'CHART'">Boolean</option>
                        <option value="link" data-ng-hide="propData.type === 'CHART'">Link</option>
                        <option value="duration" data-ng-hide="propData.type === 'CHART'">Duration</option>
                        <option value="custom">Custom</option>
                    </select>


                </div>
            </div>
            <div class="row noLftRghtMargin" data-ng-show="formatters.render.type === 'custom'">            
                <label for="customformat">Custom Format</label>
                <div class="input-group-sm pull-right">
                    <button id="customformat" class="btn btn-primary btn-xs" data-ng-click="openAceEditor(formatters.render.customformat,'javascript',undefined,'formatters.render.customformat')">
                        <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddExpression"/>
                    </button>           
                </div>                          
            </div>
            <div class="row noLftRghtMargin" data-ng-show="formatters.render.type === 'number'">            
                <label class="col-sm-4 noLftRghtPadding">Format</label>
                <div class="col-sm-8 noLftRghtPadding">
                    <select class="form-control" data-ng-model="formatters.render.fmt">
                        <option value="comma">Comma Separated</option>
                        <option value="string">String</option>
                    </select>
                </div>            
            </div>
            <div class="row noLftRghtMargin" data-ng-show="formatters.render.type === 'duration'">            
                <label class="col-sm-4 noLftRghtPadding">Source is in:</label>
                <div class="col-sm-8 noLftRghtPadding">
                    <select class="form-control" data-ng-model="formatters.render.source">
                        <option value="milliseconds" default=true>Milliseconds</option>
                        <option value="seconds">Seconds</option>
                        <option value="minutes">Minutes</option>                            
                    </select>
                </div>     
            </div>
            <div class="row noLftRghtMargin" data-ng-show="formatters.render.type === 'size'">            
                <div class="row noLftRghtMargin">
                    <label class="col-sm-4 noLftRghtPadding">Source is in:</label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <select class="form-control" data-ng-model="formatters.render.source">
                            <option value="bytes">Bytes</option>
                            <option value="kb">KB</option>
                            <option value="mb">MB</option>
                            <option value="gb">GB</option>
                            <option value="tb">TB</option>
                            <option value="pb">PB</option>
                            <!-- <option value="eb">EB</option> -->
                        </select>
                    </div>            
                </div>
                <div class="row noLftRghtMargin">
                    <label class="col-sm-4 noLftRghtPadding">Target should be in:</label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <select class="form-control" data-ng-model="formatters.render.target">
                            <option value="relative">Auto</option>
                            <option value="kb">KB</option>
                            <option value="mb">MB</option>
                            <option value="gb">GB</option>
                            <option value="tb">TB</option>
                            <option value="pb">PB</option>
                            <!-- <option value="eb">EB</option> -->
                        </select>
                    </div>            
                </div>
                <div class="row noLftRghtMargin">
                    <label class="col-sm-4 noLftRghtPadding">Precision</label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <input type="number" class="form-control" min="0" max="20" data-ng-model="formatters.render.tofixed">
                    </div>            
                </div>
            </div>
            <div class="row noLftRghtMargin" data-ng-show="formatters.render.type === 'date'"> 
                <div data-ng-if="selFieldType !== 'Date'" class="row noLftRghtMargin">
                    <label class="col-sm-4 noLftRghtPadding">Input Time Zone</label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <select class="form-control" data-ng-model="formatters.render.srcTimezone" data-ng-options="tz for tz in timezones">
                        </select>
                    </div>
                </div>  
                <div data-ng-if="integerTypes.indexOf(selFieldType) !== -1" class="row noLftRghtMargin">
                    <label class="col-sm-4 noLftRghtPadding">Input Format</label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <select class="form-control" data-ng-model="formatters.render.srcFmt">
                            <option ng-repeat="srcFmt in IntegerDateFormats" value="{{srcFmt.val}}">{{srcFmt.name}} </option>
                        </select>
                    </div>
                </div>         
                <div class="row noLftRghtMargin">
                    <label class="col-sm-4 noLftRghtPadding">Output Format</label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <select class="form-control" data-ng-model="formatters.render.fmt">
                            <option value="Auto">Auto (Date)</option>
                            <option value="AutoDateTime">Auto (Date-Time)</option>
                            <option value="DD-MM-YYYY">DD-MM-YYYY</option>
                            <option value="DD-MMM-YYYY">DD-MMM-YYYY</option>
                            <option value="MM-DD-YYYY">MM-DD-YYYY</option>
                            <option value="Do-MMM-YYYY">Do-MMM-YYYY</option>
                            <option value="DD-MM-YYYY HH:mm:ss">DD-MM-YYYY HH:mm:ss</option>
                            <option value="Custom">Custom</option>
                        </select>
                    </div>
                </div>
                <div data-ng-show="formatters.render.fmt==='Custom'" class="row noLftRghtMargin">
                    <label class="col-sm-4 noLftRghtPadding">Custom Date Format</label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <textarea class="form-control" rows="3" data-ng-model="formatters.render.customDateFormat" placeholder="e.g. DD/MM/YYYY HH:mm:ss"></textarea>
                    </div>            
                </div>
                
            </div>
            <div class="row noLftRghtMargin" data-ng-show="formatters.render.type === 'boolean'">            
                <label class="col-sm-4 noLftRghtPadding">Format</label>
                <div class="col-sm-8 noLftRghtPadding">
                    <select class="form-control">
                        <option value="">Tick/Cross</option>
                    </select>
                </div>            
            </div>
            <div class="row noLftRghtMargin" data-ng-if="formatters.render.type === 'link'">            
                <div class="row">
                                     
                    <event-properties event-type="onClick" event-model="formatters.render.link.events.onClick" comp-type="selectedProperties" is-table="true" columns="componentColumns"></event-properties>                    
                         
                </div>                
            </div>                    
    </div>
    <div class="panel-footer">
        <div class="pull-right">
            <button type="button" class="btn btn-sm btn-info" data-ng-click="updateFormatterOptions()">
               <fmt:message key="Apply"/>
            </button>
            <button type="button" class="btn btn-sm btn-warning" data-ng-click="hideFormatterOptions()">
               <fmt:message key="CustomReport.Cancel"/>
            </button>
        </div>
    </div>    
</div>
</fmt:bundle>
