// Closure to isolate scope, as per best practices
(function() {
	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");

	app
			.directive("eventProperties",
					function() {
						return {
							restrict : 'AEC',
							templateUrl : customReports.contextPath + '/reportsplus/properties/eventProperties.jsp',
							scope : {
								eventType : '=',
								eventModel : '=',
								compType : '=?',
								isMobile : '=?',
								isTable : '=?',
								isChart : '=?',
								isCellComponent : '=?',
								columns : '<'
							},
							controller : [
									"$scope",
									"reportService",
									"customReportSvc",
									"$uibModal",
									"$timeout",
									function($scope, reportService, customReportSvc,$uibModal,$timeout) {
										$scope.actionTypes = [ {
											"label" : "None",
											"value" : ""
										}, {
											"label" : "Run a workflow",
											"value" : "Workflow"
										}, {
											"label" : "Open Report",
											"value" : "Report"
										}, {
											"label" : "Url",
											"value" : "Link"
										}, {
											"label" : "Custom",
											"value" : "Custom"
										}, {
											"label" : "Add Table Record",
											"value" : "AddTableRecord"
										}, {
											"label" : "Edit Table Records",
											"value" : "EditTableRecords"
										} ];

										let allowedCompsForPreview = ["row","column","table","KENDO_GRID","KENDO_TREEGRID"];
										if($.inArray($scope.compType,allowedCompsForPreview) !== -1) {
											$scope.actionTypes.push({
												"label" : "Show Preview",
												"value" : "ShowPreview"
											});
										}

										if ($scope.isMobile) {
											$scope.actionTypes.push({
												"label" : "Show Detail View",
												"value" : "Detail"
											})
										}

										$scope.entities = {
											Workflow : [],
											Report : []
										};

										if (!$scope.workflows) {
											$scope.workflows = [];
											$scope.workflowEntities = {};
										}
										if (!$scope.reports) {
											$scope.reports = [];
											$scope.reportEntities = {};
										}
										if (!$scope.tables) {
											$scope.tables = [];
											$scope.tableEntities = {};
										}

										$scope.getWorkflows = function() {

										}

										$scope.setTooltip = function() {
											$timeout(function() {
												$("#reportArea .tooltipElm").tooltip();
											});
										}

										$scope.getColumnDefaultHtml = function() {
											let previewHtml = "<ul>";
											angular.forEach($scope.eventModel.selColumns,function(column) {
											 	previewHtml += "\n\t<li class=\'padding-bottom-10\'>\n\t\t<span class=\'previewColNameStyle\'>"+column.displayName+
											 		" : </span>&nbsp;&nbsp;\n\t\t<span class=\'previewColDataStyle\'>{{row[\'"+column.dataField+"\']}}</span>\n\t</li>";

											});
											return previewHtml += "\n</ul>";
										}

										$scope.onClickRestApiOption = function() {
											$scope.eventModel.useRestAPI = true;
											$scope.eventModel.useRowData=false;
											if(!$scope.eventModel.customHtml || $scope.eventModel.customHtml.trim() === $scope.getColumnDefaultHtml().trim())
												$scope.eventModel.customHtml = $scope.defaultCustomHtmlForUrl;
											$scope.setTooltip();
										}

										$scope.OnClickColumnsOption = function() {
											$scope.eventModel.useRowData = true;
											$scope.eventModel.useRestAPI=false;
											if(!$scope.eventModel.customHtml || $scope.eventModel.customHtml.trim() === $scope.defaultCustomHtmlForUrl.trim())
												$scope.eventModel.customHtml = $scope.getColumnDefaultHtml();
											$scope.setTooltip();
										}

										$scope.getEntitiesOfType = function(type, resetInputs) {
											$scope.entityMap = {};
											if ($scope.eventModel && resetInputs) {
												$scope.eventModel.inputs = [];
											}

											if (type === 'Workflow') {
												if ($scope.workflows.length === 0) {
													var promise = reportService.getForms();
													promise
															.then(function(response) {
																for (var i = 0; i < response.data.container.length; i++) {
																	$scope.workflows
																			.push({
																				id : response.data.container[i].entity.workflowName,
																				name : response.data.container[i].entity.workflowName
																			});
																	$scope.workflowEntities[response.data.container[i].entity.workflowName] = response.data.container[i];
																}
																if ($scope.eventModel.name && resetInputs) {
																	$scope
																			.onSelectedEntityChanged($scope.eventModel.name,
																					$scope.$index,
																					$scope.eventModel.action);
																}
															});
												}
												$scope.entities.Workflow = $scope.workflows;
											} else if (type === 'Report') { // put page init stuff here. please
												if ($scope.reports.length === 0) {
													var promise = reportService.getReportsList();
													promise.then(function(response) {
														for (var i = 0; i < response.data.reports.length; i++) {
															$scope.reports.push({
																id : response.data.reports[i].userReportId,
																name : response.data.reports[i].reportName
															});
														}
													});
												}
												$scope.entities.Report = $scope.reports;
												if ($scope.eventModel.name) {
													$scope.pages = [];
													$scope.pageMap = {};
													var promise2 = reportService.getCustomReport({
														reportId : $scope.eventModel.name,
														includeDrafts : false,
														reportName : ""
													});
													promise2
															.then(function(response) {
																for (var i = 0; i < response.data.pages.length; i++) {
																	$scope.pages.push({
																		name : response.data.pages[i].pageName
																	});
																	$scope.pageMap[response.data.pages[i].pageName] = response.data.pages[i];
																}
															});
												}
											} else if (_.includes([ 'AddTableRecord', 'EditTableRecords' ], type)) {
												if ($scope.tables.length === 0) {
													var promise = reportService.getTablesList();
													promise.then(function(response) {
														angular.forEach(response.data, function(entity, idx) {

															$scope.tables.push(entity);
														})
													});
												}
											} else if (type === 'ShowPreview') {
												if($scope.eventModel.overrideCustomExp === undefined)
													$scope.eventModel.overrideCustomExp = true;
												
												$scope.visibleColumns = [];
												if ($scope.columns) {
													$scope.visibleColumns = $.map($scope.columns,(column) => {
														return {
															displayName : column.displayName,
															id : column.id,
															dataField : column.dataField
														};
													});
												}


												if(!$scope.eventModel.selColumns) {
													$scope.eventModel["useRowData"] = true;
													$scope.eventModel["selColumns"] = customReportSvc.getDeepCopy($scope.visibleColumns);

												}


												$scope.eventModel.selColumns = $scope.eventModel.selColumns.filter(selCol => {
														return $scope.visibleColumns.filter(col => {
															return selCol.id === col.id
														}).length > 0;
												});


												$scope.defaultCustomHtmlForUrl =  ':=  if(typeof response === "object") {\n\tvar $previewHtml = $("<ul></ul>");\n\tfor(var key in response) {\n\t\tvar value=response[key]; \n\t\tvar $li = $("<li class=\'padding-bottom-10\'><span class=\'previewColNameStyle\'></span>&nbsp&nbsp<span class=\'previewColDataStyle\'></span></li>");\n\t\t$(".previewColNameStyle", $li).text(key+":");\n\t\t$(".previewColDataStyle", $li).text(JSON.stringify(value));\n\t\t$previewHtml.append($li);\n\t}; \n\t$previewHtml = $previewHtml[0].outerHTML;\n\treturn $previewHtml;\n} else {\n\treturn response;\n}';

												if(!$scope.eventModel.customHtml) {
													if($scope.eventModel.useRowData)
														$scope.eventModel.customHtml = $scope.getColumnDefaultHtml();
													else
														$scope.eventModel.customHtml = $scope.defaultCustomHtmlForUrl;
												}
												$scope.selectEvents = {
													onSelectionChanged : function(selItems) {
														if($scope.eventModel.overrideCustomExp)
															$scope.eventModel.customHtml = $scope.getColumnDefaultHtml();
													}
												};	
												$scope.multiSelectSettings = {
													enableSearch : true,
													selectedToTop : true,
													displayProp : 'displayName',
													styleActive : true,
													keyboardControls: true,
													idProperty: 'dataField'
												};
												$scope.customHtmlCompLst = [];
												let $htmlComps = $("li[data-component-type='CUSTOM']");
												if($htmlComps.length > 0) {
													$scope.customHtmlCompLst = $("li[data-component-type='CUSTOM']").map((index,$li) => {
														return $($li).attr("comp");
													});
												}

												$scope.setTooltip();


											}

										}

										// when selected workflow or report is changed
										$scope.onSelectedEntityChanged = function(name, componentIndex, type) {
											var obj = {};
											$scope.inputs = [];
											$scope.eventModel.inputs = [];
											if (type == 'Workflow') {
												obj = $scope.workflowEntities[name];
												var inputForm = obj.deployments[0].inputForm;
												if (inputForm.entries) {
													for (var i = 0; i < inputForm.entries.length; i++) {
														$scope.inputs.push({
															id : inputForm.entries[i].inputName,
															value : "",
															isMulti : inputForm.entries[i].listType
														});
													}
													$scope.eventModel.inputs = $scope.inputs;
												}
											} else if (type === 'Report') {
												$scope.pages = [];
												$scope.pageMap = {};
												if (!$scope.reportEntities[name]) {
													var promise = reportService.getCustomReport({
														reportId : 0,
														includeDrafts : false,
														reportName : name
													});
													promise.then(function(response) {
														$scope.reportEntities[name] = response.data;
														$scope.updateReportEventModel(response.data);
													});
												} else {
													var currentReport = $scope.reportEntities[name];
													$scope.updateReportEventModel(currentReport);
												}
											} else if (type === 'AddTableRecord' || type === 'EditTableRecords') {
												$scope.tableForms = undefined;
												$scope.getTableFormsList(name);
											}
										}

										$scope.getTableFormsList = function(tableId) {
											$scope.loadFormSpinner = false;
											if (($scope.tableForms == undefined || $scope.tableForms.length == 0) &&
													tableId) {
												$scope.loadFormSpinner = true;
												//$("#formSpinner").show();
												angular.element('.wfPanelFormsSelect').addClass('wfForm-select');
												var promise = reportService.getTableForms(tableId);
												promise
														.then(function(response) {
															$scope.loadFormSpinner = false;
															$scope.tableForms = response.data;
															angular.element('.wfPanelFormsSelect')
																	.removeClass('wfForm-select');
															//$("#formSpinner").hide();
														});
											}
										}

										$scope.updateReportEventModel = function(currentReport) {
											$scope.eventModel.reportId = currentReport.userReportId;
											for (var i = 0; i < currentReport.pages.length; i++) {
												var page = currentReport.pages[i];

												$scope.pages.push({
													name : page.pageName
												});
												$scope.pageMap[page.pageName] = {
													inputs : $scope.getReportInputs(page.inputs)
												};

												if (page.isDefault) {
													$scope.eventModel.pageName = page.pageName;
													$scope.eventModel.inputs = $scope.pageMap[page.pageName].inputs;
												}
											}
										}

										$scope.getReportInputs = function(inputs) {
											var eventInputs = [];
											for (var i = 0; i < inputs.length; i++) {
												eventInputs.push({
													id : inputs[i].id,
													value : '',
													isMulti : inputs[i].allowMultipleSelection
												});
											}

											return eventInputs;
										}

										$scope.onSelectedPageChanged = function(pageName, componentIndex) {
											$scope.eventModel.inputs = $scope.pageMap[pageName].inputs;
										}

										$scope.showInsertVariable = function(input, menuLevel, rowId) {
											$scope.currentInput = input;
											$scope.cmp;
											var page;
											var componentId;
											if ($scope.$parent.component) {
												if ($scope.$parent.component.type === 'MenuItem') {
													page = $scope.$parent.$parent.$parent.$parent.$parent.$parent.page;
													componentId = $scope.$parent.$parent.$parent.$parent.$parent.$parent.componentId;
												} else {
													page = $scope.$parent.$parent.$parent.page;
													componentId = $scope.$parent.$parent.$parent.propData.componentId;
												}
											} else {
												page = $scope.$parent.$parent.$parent.$parent.$parent.page;
												componentId = $scope.$parent.$parent.$parent.componentId;
											}
											var modalInstance = $uibModal.open({
												templateUrl : "reportVariables/insertVariable.jsp",
												controller : "insertVariableCtrl",
												backdrop : 'static',
												keyboard : false,
												resolve : {
													page : function() {
														return page;
													},
													component : function() {
														return customReportSvc.getComponent(componentId,page.body.reportComponents);
													},
													modalParams : function() {
														return {
															entityToAdd : $scope.isTable ||
																	$scope.compType === "button" ? "selectedRow"
																	: "input"
														};
													}
												}
											});

											modalInstance.result.then(function(response) {
												if (response) {
													var appendExpression = "['" + response[0].label + "']";
													var ret = '=' + response[0].parent.entity.label + appendExpression;
													if (response !== undefined) {
														if (rowId) {
															$scope.eventModel.rowId = ret;
														} else {
															input.value = ret;
														}
													}
												}
											});
										};

										$scope.openAceEditor = function(editorContent,editorMode,dataVariable) {
											if(!editorContent && editorMode === "javascript")
                								editorContent = ":="
										    var modalInstance = $uibModal.open({
								                templateUrl:  customReportSvc.getContextPath() +"/reportsplus/modal/views/aceEditorModal.jsp",
								                controller: "aceEditorCtrl",
								                windowClass: 'aceEditorModalWindow reportModal',
								                backdrop  : 'static',
								                resolve: {
								                    modalTitle : function() {
								                        return localMsg.CodeEditor;
								                    },
								                    editorOptions : function() {
								                        return  {
								                            mode: editorMode
								                        }
								                    },
								                    editorContent : function() {
								                        return editorContent
								                    },
								                    inputVariables : function() {
								                    	switch(dataVariable) {
								                    		case "eventModel.customHtml" :
								                    			return $scope.eventModel.useRestAPI ?  { row :  $scope.visibleColumns, response : []} : { row : $scope.eventModel.selColumns };
															
															case "eventModel.restAPI.bodyParams" :
								                    			return { row : $scope.eventModel.selColumns };
															
															default:
								                    			return {};
								                    	}
								                     },
								                    helpText : function() {
								                    	switch(dataVariable) {
								                    		case "eventModel.customHtml" :
								                    			return $scope.eventModel.useRestAPI ? 'e.g. <div>{{row["columnName"]}}</div><div>{{response["propertyName"]}}</div>' : 'e.g. <div>{{row["columnName"]}}</div>';
								                    			break;

								                    		case "eventModel.restAPI.bodyParams" :
								                    			return 'e.g. { "propertyName" : {{row["columnName"]}} }';
								                    			break;

								                    		default:
								                    			return "";
								                    	}

								                    }
								                }
							                });

								            modalInstance.result.then(function (modifiedContent) {
									           customReportSvc.assignValToStringVariable($scope,dataVariable,modifiedContent);
									           if(!modifiedContent && dataVariable === "eventModel.customHtml")
									           	 	$scope.eventModel.customHtml =  $scope.eventModel.useRestAPI ? $scope.defaultCustomHtmlForUrl : $scope.getColumnDefaultHtml();
								           });
										}

									} ]

						};
					});

})();