<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
        <span class="ico ico-form-field"></span>
    </li>
    <li class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
        <span class="ico ico-code"></span>
    </li>
</ul>
<!-- Begin "General" group -->
<div data-ng-show="selectedPropertyCategory==='general'">
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                       type="text"
                       placeholder="<fmt:message key='CustomReport.Properties.TableName'/>"
                       data-ng-model="propData.title.text">
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input name="chartid" class="form-control input-sm"
                   type="text"
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">
                </div>
                <span class="inline-validation-error col-lg-12 noLftRghtPadding ng-hide" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>
            </div>
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message key="CustomReport.Properties.DataSet"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   type="text"
                   placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>"
                   readonly="true"
                   data-ng-model="propData.dataSet.dataSetName">
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideHeader"/>'><fmt:message key="CustomReport.Properties.HideHeader"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideHeader" id="hideheader">
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label
                    class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
                    title='<fmt:message key="CustomReport.Properties.HideBorder"/>'><fmt:message
                        key="CustomReport.Properties.HideBorder" /></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch
                        data-ng-model="propData.hideborder" id="hideborder">
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label
                    class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
                    title='<fmt:message key="CustomReport.Properties.HideLoadingAnimation"/>'><fmt:message
                        key="CustomReport.Properties.HideLoadingAnimation" /></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch
                        data-ng-model="propData.hideLoadingAnimation" id="hideloadinganimation">
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label
                    class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
                    title='<fmt:message key="CustomReport.Properties.AutoHeight"/>'><fmt:message
                        key="CustomReport.Properties.AutoHeight" /></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch
                        data-ng-model="propData.autoHeight" id="autoHeight">
                </div>
            </div>
        </div>
    </div>
	<entity-security data-item="propData"></entity-security>
</div>

<!-- End "General" group -->

<!--  Begin Column properties -->
<div data-ng-show="selectedPropertyCategory==='fields'">
    <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['columns']=!collapsed['columns']">
       <div class="col-xs-12 noLftRghtPadding">
           <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['columns'], 'ico-chevron-right':collapsed['columns']}" style="margin-right:5px"></span>
           <span>Columns<!-- TODO: localize --> </span>
       </div>
   </div>
    <div data-ng-repeat="column in propData.columns" data-ng-init="collapsed[column.id] = true" data-ng-class="{'collapsed': collapsed['columns']}"">
        <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
            <div class="fieldHeader" data-ng-click="collapsed[column.id]=!collapsed[column.id]">
                <label  class="col-lg-9 noLftRghtPadding" title="{{column.id}}">
                   <span>{{column.id}}</span>
                </label>
               <span class="pull-right">
                    <span class="ico inner-panel-expand-icon" data-ng-class="{'ico-chevron-down':!collapsed[column.id], 'ico-chevron-right':collapsed[column.id]}" style="margin-right:5px"></span>
                    <span class="ico inner-panel-expand-icon ico-trash2" title="Remove Measure" data-ng-click="deleteColumn($index)" ></span>
                </span>
            </div>
            <div data-ng-class="{'collapsed':collapsed[column.id]}">
            	<div class="row">
                    <div class="col-xs-12">
            	<!-- FIXME: Localize -->
                    <div class="form-group">
                        <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                        <div class="col-sm-8 noLftRghtPadding">
                            <input class="form-control input-sm" type="text" data-ng-model="column.id">
                        </div>
                    </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-xs-12" >
                        <div class="form-group">
                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Aggregate"/>'><fmt:message key="CustomReport.Properties.Aggregate"/></label>
                            <div class="col-sm-8 noLftRghtPadding">
                                <select  class="form-control input-sm" data-ng-model="column.aggrType" data-ng-change="updateComponent()">
                                    <option value="None"><fmt:message key="CustomReport.None"/></option>
                                    <option value="Count"><fmt:message key="CustomReport.Count"/></option>
                                    <option value="CountDistinct"><fmt:message key="CustomReport.Distinct"/></option>
                                    <option data-ng-show="isNumberColumn1(column.type)" value="Sum"><fmt:message key="CustomReport.Sum"/></option>
                                    <option data-ng-show="isNumberColumn1(column.type)" value="Avg"><fmt:message key="CustomReport.Avg"/></option>
                                    <option data-ng-show="isNumberColumn1(column.type)" value="Min"><fmt:message key="CustomReport.Min"/></option>
                                    <option data-ng-show="isNumberColumn1(column.type)" value="Max"><fmt:message key="CustomReport.Max"/></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- End Column properties -->
<div data-ng-show="selectedPropertyCategory==='customcode'">
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <label>
                <fmt:message key="CustomReport.Properties.CustomHtmlContent"/><br>
            </label>
            <div class="pull-right">
                <button class="btn btn-primary btn-xs" data-ng-click="openAceEditor(propData.htmlContent,'html','redrawComponent(propData.id)','propData.htmlContent')">
                    <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddHTML"/>
                </button>
            </div>
        </div>
    </div>
    <div class="row noLftRghtMargin" data-ng-show="ds && ds.endpoint === 'DATACUBE'">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <label>
                Custom Query<br>
            </label>
            <div class="pull-right">
                 <button class="btn btn-primary btn-xs" data-ng-click="openAceEditor(propData.customQuery,'javascript','redrawComponent(propData.id)','propData.customQuery')">
                    <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddQuery"/>
                </button>
            </div>
        </div>
    </div>

</div>




</fmt:bundle>
