<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<ul class="secondary-header secondary-background-color">
	    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
	        <span class="ico ico-cog"></span>
	    </li>
	    <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
	        <span class="ico ico-form-field"></span>
	    </li>
	</ul>	
	
	<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>

	
	<!-- Begin "General" group -->
	<div data-ng-show="selectedPropertyCategory==='general'">
		<div cv-columns data-column="columnData" class="column-container"></div>
	</div>
	
	<div data-ng-show="selectedPropertyCategory==='fields'" id="component-elements">
	    <div class="row noLftRghtMargin secondary-header property-header">
	       <div class="col-xs-12 noLftRghtPadding">
	           <span title='<fmt:message key="CustomReport.Properties.Component"/>'><fmt:message key="CustomReport.Properties.Component"/></span>
	           <span class="pull-right ico ico-plus-circle" title="Add Components" data-ng-click="addComponent()"></span>
	       </div>
	    </div>
		<!--  <div data-ng-class="{'collapsed': collapsed['sorting']}">-->
		<!-- BootStrap Starts Here -->
		<div class="setup-content">
			<div class="bootstrap-wrapper">
				<div class="form-horizontal">	
					<div data-ng-repeat="component in column.components" data-ng-init="collapsed['component'+$index] = true">
								<div data-ng-class="{'collapsed': collapsed['component']}">
								     <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel" id="individual-component">
								            <div class="fieldHeader" data-ng-click="collapsed['component'+$index]=!collapsed['component'+$index]">                
								                  <label class="col-lg-9 noLftRghtPadding ">
								                      <span title="{{component.title.text}}">{{component.title.text}}</span>
								                  </label>
								                   <span class="pull-right">
								                        <span data-ng-click="deleteComponent($index)" class="ico ico-trash2" title='<fmt:message key="DeleteField"/>'></span>
								                        <span class="ico inner-panel-expand-icon ico-chevron-right" data-ng-class="{'ico-chevron-down':!collapsed['component'+$index], 'ico-chevron-right':collapsed['component'+$index]}" title="ComponentDetails"></span>
								                    </span> 
								                    <br style="clear: both;">                                    
								             </div>   
								             <div data-ng-class="{'collapsed': collapsed['component'+$index]}" class="collapsed">                
											 	<component-properties component="component"></component-properties>	
											 </div>
											</div>		
										</div>
								     </div>
				</div>
			</div>
		</div>
	</div>	
</fmt:bundle>