<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
        <span class="ico ico-code"></span>
    </li>
</ul>

<!-- Begin "General" group -->
<div data-ng-show="selectedPropertyCategory==='general'">
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm" type="text"
                     placeholder="<fmt:message key='CustomReport.Properties.ButtonName'/>"
                     data-ng-model="propData.title.text">
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   type="text"
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
                   data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">
                  <span class="inline-validation-error" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>  <!-- localize -->
                </div>
            </div>
        </div>
    </div>
    
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='Add custom class'>Class</label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   type="text"
                   data-ng-model="propData.class"
                   >                  
                </div>
            </div>
        </div>
    </div>

   <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ImageType"/>'><fmt:message key="CustomReport.Properties.ImageType"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                	<select class="form-control input-sm"
					data-ng-model="propData.imageType">
						<option value="none">None</option>
						<option value="url">URL</option>
						<option value="custom">Custom</option>
				</select>
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin" data-ng-hide="propData.imageType == 'none'">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ImageSource"/>'><fmt:message key="CustomReport.Properties.ImageSource"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                	<input class="form-control input-sm" type="text" placeholder="{{propData.imageType == 'url' ? '../reports/img/settings.png' : '&lt;span class=&quot;sprite icon-refresh&quot;&gt;&lt;/span&gt;'}}" data-ng-model="propData.imageValue">
                </div>
            </div>
        </div>
    </div>


	<div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ButtonEnable"/>'><fmt:message key="CustomReport.Properties.ButtonEnable"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                	<select class="form-control input-sm"
					data-ng-model="propData.enable" data-ng-change="evalButtonsState(propData)">
						<option value="always"><fmt:message key="CustomReport.Properties.ButtonSelecteDefault"/></option>
						<option value="singleSelect"><fmt:message key="CustomReport.Properties.ButtonSingleSelect"/></option>
						<option value="multiSelect"><fmt:message key="CustomReport.Properties.ButtonMultiSelect"/></option>
						<option value="noRowSelected"><fmt:message key="CustomReport.Properties.ButtonNoRowSelected"/></option>
						<option value="custom"><fmt:message key="CustomReport.Properties.ButtonCustomExpression"/></option>
				</select>
                </div>
            </div>
        </div>
    </div>
    
     <div class="row noLftRghtMargin" data-ng-show="propData.enable === 'custom'">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-12 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ButtonEnableExpression"/>'><fmt:message key="CustomReport.Properties.ButtonEnableExpression"/></label>
                <div class="col-sm-12 noLftRghtPadding">
                	<textarea data-ng-model="propData.disableExpression"
								 placeholder="<fmt:message key="CustomReport.Properties.ButtonEnableExpressionResult"/>"
								rows="5"></textarea>
                </div>
            </div>
        </div>
    </div> 
    <!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                        data-ng-model="propData.mobile.visible">
                        <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                        <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
</div>


<!-- End "Table Options" group -->


<!-- Begin "Series" group -->
<div data-ng-show="selectedPropertyCategory==='customcode'">
    <event-properties event-type="onClick" event-model="propData.clickExpression" is-table="false" comp-type="'button'"></event-properties>
    <div class="col-xs-12">
<!-- FIXME: Localize -->
        <label title='<fmt:message key="CustomReport.Properties.ButtonStyles"/>'>
            <fmt:message key="CustomReport.Properties.ButtonStyles"/><br>
        </label>
        <div class="pull-right">
            <button class="btn btn-primary btn-xs" data-ng-click="propData.buttonAttributes = propData.buttonAttributes ? propData.buttonAttributes : {} ; openAceEditor(propData.buttonAttributes.style,'css',undefined,'propData.buttonAttributes.style')">
                <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddStyle"/>
            </button>                
        </div>        
    </div>
</div>

<!-- End "Table Options" group -->

<div class="row noLftRghtMargin">
	<div class="col-xs-12 deleteColumn" style="text-align: center;">
		<label> <a id="resetButton" class="btn btn-danger btn-sm"
			data-ng-click="deleteButton(propData)">Delete Button</a>
		</label>
	</div>
</div>



</fmt:bundle>