<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<div id="columnSettingModal" class="modalStyle">
		<div class="modal-header">
            <h3 class="modal-title" id="modal-title">{{Title}}</h3>
        </div>
        <div class="modal-body" id="modal-body">
           
	    	<div><label for="selectAll" title="<fmt:message key='CustomReport.MultiSelect.SelectAll'/>"><fmt:message key='CustomReport.MultiSelect.SelectAll'/></label> 
	    		<div class="material-switch pull-right margin-right-20">
	                <input id="selectAll" type="checkbox" class="hidden" data-ng-model="selectAll" data-ng-checked="isSelectAll()" data-ng-click="toggleSelectAll()"/> 
	                <label for="selectAll"></label>
            	</div>
				
			 </div>
	    	<div class="margin-top-7"> <label for="showSelected" title="<fmt:message key='CustomReport.showSelected'/>"><fmt:message key='CustomReport.showSelected'/></label> 
	    		<div class="material-switch pull-right margin-right-20">
	                <input id="showSelected" type="checkbox" class="hidden" data-ng-model="showSelected"/> 
	                <label for="showSelected" ></label>
            	</div>
				
			</div>
	    	<div class="searchDiv">
		        <i class="glyphicon glyphicon-search text-md"></i><input class="searchInput" ng-model="searchInput" placeholder="<fmt:message key='CustomReport.Search'/>" type="text"/>
		    </div>
		    <div id="columnContainer" class="view-area">
		        <ul id="colList" infinite-scroll="(columns.length < dataSet.fields.length) && loadMoreValues(pageSize)"  infinite-scroll-distance="1" infinite-scroll-parent="true">
		            <li class="noResultInfo" data-ng-if="showNoResultMsg()"><span><fmt:message key='CustomReport.NoResults'/></span></li>
		            <li data-ng-if="!showSelected || (showSelected && col.visible)" data-ng-hide="col.hidden" data-ng-repeat="(colname,col) in (searchInput ? searchColumns : columns) | orderBy : 'dataField'"><input
		                type="checkbox" id="chckBx_{{$index}}" class="customChkBx" data-ng-model="col.visible" data-ng-click="addSelectedCol(col)" /> 
		                <label class="chkBxLabel" title="{{col.displayName ? col.displayName : col.dataField}}" for="chckBx_{{$index}}">{{col.displayName ? col.displayName : col.dataField}}</label></li>
		        </ul>
		    </div>
        </div>
        <div class="modal-footer">
            <button class="btn btn-primary" type="button" ng-click="ok()"><fmt:message key='CustomReport.Ok'/></button>
            <button class="btn btn-default" type="button" ng-click="cancel()"><fmt:message key='CustomReport.Cancel'/></button>
        </div>
	</div>
</fmt:bundle>