(function () {
	"use strict";

	var reports = angular.module("reports");

	reports.service('reportService', ['$http', '$q', function ($http, $q) {

		var webServerId = null;
		var csRegionalSettings = null;

		this.getCustomReport = function (params) {
			if (params.isTileReport) {
				$("#container").addClass("healthTile");
			}
			if (params.isPreview) {
				var deferred = $q.defer();
				window.setTimeout(function () {
					var cr = localStorage.getItem("previewCustomReport");
					//localStorage.removeItem("previewCustomReport");
					deferred.resolve(JSON.parse(cr));
				}, 1000);

				return deferred.promise;

			} else {
				return $http.post('reportBuilder.do', params, {
					cache: true
				});
			}

		};

		//fetch system variables
		this.getSystemVariables = function () {
			return $http.get("getSystemVariables.do", {
				cache: true
			});
		};

		// saving user view
		this.saveView = function (reportId, view, viewType) {
			return $http.post("saveView.do", {
				reportId: reportId,
				view: JSON.stringify(view),
				viewType: viewType
			});
		};

		this.deleteView = function (viewId) {
			$http.post('deleteView.do', {
				viewId: viewId
			});
		}


		//get tags
		this.getReportsTags = function () {
			return $http.post("getReportsTags.do");
		}

		this.fetchDataSources = function () {
			return $http.post("fetchDataSources.do", {
				refreshDataSources: false
			}, {
				cache: true
			});
		}; // end method fetchDataSets


		this.fetchDatabases = function (dataSources) {
			var dsList = {
				dataSource: dataSources
			}
			var postData = {
				'dataSourceString': JSON.stringify(dsList)
			};
			return $http.post('fetchDBListForHost.do', postData, {
				cache: true
			});
		}; // end method fetchDatabases

		this.fetchTablesAndViews = function (dataSources, dataBaseName) {
			var dsList = {
				dataSource: dataSources
			};
			var postData = {
				'dataSourceString': JSON.stringify(dsList),
				'dataBaseName': dataBaseName
			};
			return $http.post('fetchTableViewList.do', postData, {
				cache: true
			});
		}; // end method fetchTablesAndViews


		this.retrieveDataSet = function (dataSet, component, inputs, whereClause, cacheId, exportType, mode, exportedFileName) {

			var dsName = dataSet ? dataSet.dataSetEntity.dataSetName : component.dataSetName;
			var q = "select * from " + dsName;
			var postData = {
				'data': JSON.stringify(dataSet),
				q: q,
				component: JSON.stringify(component),
				inputs: JSON.stringify(inputs),
				whereClause: whereClause,
				cacheId: globalVar.cacheId,
				exportType: exportType,
				mode: mode,
				exportedFileName: exportedFileName
			};
			return $http.post('retrieveDataSet.do', postData);
		};


		this.getDataForDataSet = function (dataSetName, dataSet, valueFields, groupbyFields, limit, offset,
			whereClause, orderByClause, component, havingClause, parameters, exportType, exportFileName,
			rawData, options, preview, filter, moreOptions) {

			var params = {
				dataSetName: dataSetName,
				fields: JSON.stringify(valueFields),
				groupbyFields: JSON.stringify(groupbyFields),
				whereClause: JSON.stringify(whereClause),
				orderByClause: orderByClause,
				havingClause: JSON.stringify(havingClause),
				filter: JSON.stringify(filter),
				component: JSON.stringify(component),
				parameters: JSON.stringify(parameters),
				limit: limit,
				offset: offset,
				cacheId: moreOptions.cacheId,
				exportType: exportType,
				exportedFileName: exportFileName,
				preview: preview,
				rawData: (rawData === true ? true : undefined)
			};

			if (options) {
				params.pivotGroupby = JSON.stringify(options.pivotGroupBy);
				params.pivotOrderby = options.pivotOrderby;
				params.pivotRow = options.pivotRow;
				params.pivotColumn = options.pivotColumn;
				params.pivotCell = options.pivotCell;
				params.pivotRowTitle = options.pivotRowTitle;

			}

			/*
			 * moreOptions could have any other parameter that's not a required parameter to get data from the
			 * dataset. This is added to support formatted data in the alert emails and test criteria. The
			 * properties required for alerts are reportId and isAlarm value set to true.
			 */
			if (!!moreOptions) {
				params.moreOptions = JSON.stringify(moreOptions);
			}

			return $http.post('retrieveDataSetByGet.do', params);
		}

		this.getRawData = function (params) {
			return $http.post(params.action, params);
		}

		this.retrieveCsvData = function (params) {
			let honorLocaleDate = customReports.honorLocaleDate;
			params['honorLocaleDate'] = honorLocaleDate;
			return $http.post('retireveCsvData.do', params);
		};

		/*
		 * this.fetchReportData= function(dataSets,updateUrl) { var postData = {'data':
		 * JSON.stringify(customReport)}; return $http.post('fetchReportData.do', postData); };
		 */

		this.genericGetApi = function (endpoint) {
			return $http.post('genericGetCREApi.do', {
				endpoint: endpoint
			});
		}

		this.saveReport = function (customReport, action) {
			var postData = {
				'reportJson': JSON.stringify(customReport),
				isPreview: false,
				'action': action
			};
			return $http.post('saveReport.do', postData);
		};


		this.deployReport = function (reportId) {
			var postData = {
				'reportId': reportId
			};
			return $http.post('deployReport.do', postData);
		};

		this.submitMetricsReport = function (reportId, reportName, reportUrl) {
			var postData = {
				'reportId': reportId,
				'reportName': reportName,
				'reportUrl': reportUrl
			};
			return $http.post('submitMetricsReport.do', postData);
		};

		this.deployMetricsReport = function (reportId) {
			var postData = {
				'reportId': reportId
			};
			return $http.post('deployMetricsReport.do', postData);
		};

		this.finalDeployMetricsReport = function (reportId, reportName, reportUrl) {
			var postData = {
				'reportId': reportId,
				'reportName': reportName,
				'reportUrl': reportUrl
			};
			return $http.post('finalDeployMetricsReport.do', postData);
		};

		this.getCustomDCReportStatus = function (reportId, reportName) {
			var postData = {
				'reportId': reportId,
				'reportName': reportName
			};
			return $http.post('getMetricsReportDCStatus.do', postData);
		};

		this.saveAlarm = function (alarm) {
			return $http.post('cloudsurvey.do?type=alarms', alarm);
		};

		function performAlertOperation(req) {

			var deferred = $q.defer();
			var url = cvUtil.getContextPath() + '/proxy/Alarms';

			$http({
				url: url,
				dataType: 'json',
				method: 'POST',
				data: req,
				headers: {
					'Content-Type': 'application/json'
				}
			}).then(function (data) {
				data=data.data;
				deferred.resolve(data);
			},function (error) {
				error=error.data;
				deferred.reject(error);
			});

			return deferred.promise;

		};
		this.getWebServerId = function () {
			var deferred = $q.defer();

			if (webServerId == null) {
				var url = cvUtil.getContextPath() + '/api/getWebServerClientProperty';
				var req = {
					"name": "WebServerClientId"
				};
				$http({
					url: url,
					dataType: 'json',
					method: 'POST',
					data: JSON.stringify(req),
					headers: {
						'Content-Type': 'application/json'
					}
				}).then(function (data) {
						if (data && data.data && data.data.name) {
							webServerId = parseInt(data.data.name);
						} else {
							console.error('Failed to get the WebServer ID');
						}
						deferred.resolve(webServerId);
					},
					function (error) {
						deferred.resolve(null);
						console.error('Failed to get the WebServer ID with reason: ' + error);
					});
			} else {
				deferred.resolve(webServerId);
			}
			return deferred.promise;
		};

		this.saveAlarmWS = function (req) {
			var deferred = $q.defer();

			this.getWebServerId().then(function (id) {
				if (!!id) {
					req.webServerClientId = id;
					deferred.resolve(performAlertOperation(JSON.stringify(req)));
				} else {
					deferred.reject('Failed to submit request');
				}

			}, function (error) {
				deferred.reject(error);
			});
			return deferred.promise;
		};
		/**
		 * Gets CS locale and timezone settings.
		 */
		this.getCSRegionalSettings = function () {
			var deferred = $q.defer();
			var url = cvUtil.getContextPath() + '/getScheduleBaseInfo.do';
			if (csRegionalSettings == null) {
				$http.get(url).then(data => {
					csRegionalSettings = data;
					deferred.resolve(data);
				}, message => {
					console.error(message);
					deferred.reject(null);
				});
			} else {
				deferred.resolve(csRegionalSettings);
			}
			return deferred.promise;
		};

		this.getAlarmDetails = function (param) {
			return $http.get('getAlarmDetails.do', {
				params: {
					"alarmId": param.alarmId
				}
			});
		}

		this.getScheduleDetails = function (param) {
			return $http.post('reportAlarmSchedules.do', param);
		}

		this.getAllReports = function (includeNonDeployed) {
			return $http.post('getAllReports.do', {
				includeNonDeployed: includeNonDeployed
			});
		}

		this.getAllDataSets = function (includeNonDeployed) {
			return $http.post('getAllDataSets.do', {
				includeNonDeployed: includeNonDeployed
			});
		}

		this.clearCache = function (cacheId) {
			return $http.post('clearReportsPlusCache.do', {
				cacheId: cacheId
			});
		}

		this.putFieldsForDataSet = function (url, dataSets) {
			return $http({
				url: baseUrl + "/proxy/cr/" + url,
				dataType: "json",
				method: "POST",
				data: JSON.stringify(dataSets),
				headers: {
					"Content-Type": "application/json"
				}
			});
		}

		this.getFieldsForDataSet = function (dataSet, requestParams) {
			var requestParams = requestParams || {},
				isPivot = requestParams.isPivot,
				options = requestParams.options,
				reportMode = requestParams.reportMode,
				parameters = requestParams.parameters,
				params = {
					'dataSet': dataSet.dataSet.dataSetId,
					'isPivot': isPivot,
					parameters: JSON.stringify(parameters)
				};

			if (options) {
				params.pivotGroupby = JSON.stringify(options.pivotGroupBy);
				params.pivotOrderby = options.pivotOrderby;
				params.pivotRow = options.pivotRow;
				params.pivotColumn = options.pivotColumn;
				params.pivotCell = options.pivotCell;
			}

			return $http.post('getFieldsForDataSet.do', params);
		}

		this.deleteReport = function (params) {
			return $http.post('deleteCustomReport.do', params);
		}

		this.cloneReport = function (params) {
			return $http.post('cloneReport.do', params);
		}

		this.publishToDownloadCenter = function (params) {
			return $http.post('publishToDownloadCenter.do', params);
		}

		this.publishToCloudStore = function (params) {
			return $http.post('publishToCloudStore.do', params);
		}

		this.saveAs = function (url, params) {
			var deferredAbort = $q.defer();
			var promise = $http.post(url, params, {
				timeout: deferredAbort.promise
			}).then(
				function (response) {
					return (response);
				},
				function (error) {
					return (deferredAbort.reject(error));
				}
			);

			promise.abort = function () {
				deferredAbort.resolve();
			};
			promise.finally(
				function () {
					promise.abort = angular.noop;
					deferredAbort = request = promise = null;
				}
			);

			return promise;
		}

		//Data cube APIs section, start
		var baseUrl = window.location.pathname.substring(0, window.location.pathname.indexOf("/", 2));
		var dCubeCoreUrl = baseUrl + "/server/";

		var APIList = {
			GET_HANDLER_SCHEMA: dCubeCoreUrl + "getHandlerSchema.do?handlerId={0}", 
			GET_FEDERATED_SCHEMA: dCubeCoreUrl + "getFederatedSchema.do?federatedSearchId={0}", 
			GET_HANDLERS_BASIC_INFO: dCubeCoreUrl + "getHandlersBasicInfo.do",
			GET_FEDERATED_BASIC_INFO: dCubeCoreUrl + "getFederatedBasicInfo.do",
			GET_HANLDER: dCubeCoreUrl + "getHandler.do",
			GET_HANLDER_ID: dCubeCoreUrl + "getHandlerId.do?dsId={0}&handlerName={1}", 
			GET_FEDERATED: dCubeCoreUrl + "getFederatedSearch.do?datasourceId={0}",
			GET_DEFAULT_HANDLER: dCubeCoreUrl + "getDefaultHandler.do?dsId={0}",
			EXPORT_SEARCH_VIEW: dCubeCoreUrl + "export.do",
			GET_EXPORT_STATUS: dCubeCoreUrl + "getExportStatus.do",
			DOWNLOAD_EXPORTED: dCubeCoreUrl + "doExportDownload.do",

			//Builder page APIs
			GET_CONNECTORS: dCubeCoreUrl + "getConnectorsInfo.do",
			GET_DATASOURCE: dCubeCoreUrl + "getDataSource.do?dsIdOrCoreName={0}", 
			SAVE_REPORT_VIEW: dCubeCoreUrl + "saveReportView.do",
			DELETE_REPORT_VIEW: dCubeCoreUrl + "deleteReportView.do", 

			//direct web service APIs
			GET_REPORT_HANDLERS: baseUrl + "/api/dcube/ReportHandlers",
			GET_DYNAMIC_FEDERATED_SCHEMA: baseUrl + "/api/dcube/getDynamicFederatedSchema/{0}/{1}/{2}" //{0} - entityTypeId, {1} - entityId, {2} - handler name
		};

		this.fetchDataSourceTypes = function () {
			return $http.get(APIList.GET_CONNECTORS);
		};

		this.fetchDataSetsForType = function (dsType) {
			return $http.get(APIList.GET_HANDLERS_BASIC_INFO, {
				params: {
					"type": dsType
				}
			});
		};

		this.fetchFederatedDataSources = function () {
			return $http.get(APIList.GET_FEDERATED_BASIC_INFO);
		};

		this.getReportHandlers = function (reportId) {
			return $http.get(APIList.GET_REPORT_HANDLERS, {
				params: {
					"reportId": reportId
				}
			});
		};

		this.getFieldsForDCubeDataSet = function (dataSet) {
			var api = APIList.GET_HANDLER_SCHEMA;
			var defaultHandlerAPI = APIList.GET_DEFAULT_HANDLER;
			if (dataSet.dsType === "federated" && dataSet.dsId == -1) {
				api = APIList.GET_DYNAMIC_FEDERATED_SCHEMA;
			} else if (dataSet.dsType === "federated") {
				api = APIList.GET_FEDERATED_SCHEMA;
				defaultHandlerAPI = APIList.GET_FEDERATED;
			}
			var getFields = function () {
				$http.get(cvFormatters.formatString(api, [dataSet.dsHandler.handlerId])).then(
					function (resp) {
						deferred.resolve(resp)
					});
			}
			var deferred = $q.defer();
			if (dataSet.dsType === "federated" && dataSet.dsId == -1) {
				if (dataSet.dsHandler.entityId === -1) {
					deferred.resolve({
						data: {
							error: {
								//we don't want to show error message "Please select any one of the Commcell Entity" on load
								errLogMessage: undefined
							}
						}
					});
				} else {
					$http.get(cvFormatters.formatString(api, [dataSet.dsHandler.entityTypeId, dataSet.dsHandler.entityId, dataSet.dsHandler.handlerName])).then(function (resp) {
						resp.data.schemaFields = resp.data.collections[0].schema.schemaFields;
						deferred.resolve(resp);
					}, function (error) {
						console.log(error);
						deferred.resolve(error);
					});
				}
			} else if (dataSet.dsHandler.handlerId !== undefined && dataSet.dsHandler.handlerId !== "") {
				getFields();
			} else if (dataSet.dsHandler.handlerName !== undefined && dataSet.dsHandler.handlerName !== "") {
				//handler name provided. get the handler ID using dsId and handlerName
				$http.get(cvFormatters.formatString(APIList.GET_HANLDER_ID, [dataSet.dsId, dataSet.dsHandler.handlerName])).then(function (handlerResp) {
					handlerResp = handlerResp.data;
					if (handlerResp && handlerResp.hasOwnProperty("searchViewList") && handlerResp.searchViewList.length > 0) {
						dataSet.dsHandler.handlerId = handlerResp.searchViewList[0].searchViewId;
						getFields();
					} else {
						console.log("Unable to get handler ID for the handler name:", dataSet.dsHandler.handlerName);
					}
				});
			} else {
				$http.get(cvFormatters.formatString(defaultHandlerAPI, [dataSet.dsId])).then(function (handlerResp) {
					if (handlerResp.data.handlerInfos === null) {
						deferred.resolve(handlerResp);
					}
					if (dataSet.dsType === "federated") {
						if (handlerResp.data.federatedSearchInfos) {
							dataSet.dsHandler.handlerId = handlerResp.data.federatedSearchInfos[0].federateSearchId;
							dataSet.dsHandler.handlerName = handlerResp.data.federatedSearchInfos[0].federateSearchName;
						}
					} else {
						dataSet.dsHandler.handlerId = handlerResp.data.handlerInfos[0].handlerId;
						dataSet.dsHandler.handlerName = handlerResp.data.handlerInfos[0].handlerName;
					}
					getFields();

				});
			}
			return deferred.promise;
		};

		this.getHandlersForDataSet = function (dsId, handlerId) {
			return $http.get(APIList.GET_HANLDER, {
				params: {
					"dataSourceId": dsId,
					"handlerId": handlerId
				}
			});
		};

		// get dcube data set info
		this.getDCubeDataSetInfo = function (dsId) {
			return $http.get(cvFormatters.formatString(APIList.GET_DATASOURCE,[dsId]));
		};

		this.saveReportView = function (viewData) {
			return $http.post(APIList.SAVE_REPORT_VIEW, viewData);
		};

		// delete report from search view
		this.deleteReportView = function (reportViewId) {
			const req = {
				reportViewId
			}
			return $http.post(APIList.DELETE_REPORT_VIEW, req);
		};

		// export table data to csv for datacube dataset
		this.exportToCSVDatacube = function (dataSet, reqObj) {
			var handlerId = dataSet.dsHandler.handlerId;
			var searchType = "Handler";
			if (dataSet.dsType === "federated") {
				searchType = "Federated";
			}
			var req = {
				"handlerId": handlerId,
				"searchType": searchType,
				"reqPayload": JSON.stringify(reqObj),
				"dsId" : ""
			};

			if (dataSet.dsType === "federated" && dataSet.dsId == -1) {
				req["entityType"] = dataSet.dsHandler.entityTypeId;
				req["entityId"] = $.isArray(dataSet.dsHandler.entityId) ? dataSet.dsHandler.entityId.join(",") : dataSet.dsHandler.entityId;
				req["handlerName"] = dataSet.dsHandler.handlerName;
			} else if(handlerId === "-1") {
				const dsId = dataSet.dsId;
				req["dsId"] =  dsId;
			}
			return $http.post(APIList.EXPORT_SEARCH_VIEW, req);
		};

		// get export status for exportToCSV
		this.getExportStatus = function (dataSet, token) {
			var handlerId = dataSet.dsHandler.handlerId;
			return $http.get(APIList.GET_EXPORT_STATUS, {
				params: {
					"handlerId": handlerId,
					"token": token
				}
			});
		};
		//Data cube APIs section, end

		// get fields for monitoring policy data set
		this.getFieldsForLMDataSet = function (policyId) {
			return $http.get(baseUrl + "/server/fieldsForLMPolicy?policyId=" + policyId);
		};

		// get user associated templates for monitoring policy data set
		this.getUserAssociatedLMTemplates = function (policyId) {
			return $http.get(baseUrl + "/server/lmTemplatesForUser");
		};

		// get user associated policies for monitoring policy data set
		this.getUserAssociatedLMPolicies = function (policyId) {
			return $http.get(baseUrl + "/server/lmPoliciesForUser");
		};

		// get user associated searches for monitoring policy data set
		this.getUserAssociatedLMSavedSearches = function () {
			return $http.get(baseUrl + "/server/lmSavedSearchesForUser");
		};

		this.getBrowserURLOfSelectedSearch = function (searchId) {
			return $http.get(baseUrl + "/server/lmSavedSearchDetails?searchId=" + searchId);
		}

		this.getFieldsForLMSavedSearch = function (searchId) {
			return $http.get(baseUrl + "/server/fieldsForLMSavedSearch?searchId=" + searchId);
		}

		// get data for dataset
		this.getDataForDataSetViaProxy = function (url, endpoint) {
			if (!endpoint) {
				endpoint = "/proxy/cr/";
			}
			return $http.get(baseUrl + endpoint + url);
		};


		this.postDataForDataSetViaProxy = function (url, dataSets, endpoint) {
			if (!endpoint) {
				endpoint = "/proxy/cr/";
			}
			return $http({
				url: baseUrl + endpoint + url,
				dataType: "json",
				method: "POST",
				data: JSON.stringify(dataSets),
				headers: {
					"Content-Type": "application/json"
				}
			});
		};


		this.getDataSet = function (dataSetName, deployed) {
			var postData = {
				dataSetName: dataSetName,
				deployed: deployed
			};
			return $http.post('getDataSet.do', postData);
		}

		this.saveDataSet = function (dataSet, endpoint) {
			if (!endpoint) {
				endpoint = "/proxy/cr/";
			}
			return $http({
				url: baseUrl + endpoint + "reportsplusengine/datasets",
				dataType: "json",
				method: "PUT",
				data: JSON.stringify(dataSet),
				headers: {
					"Content-Type": "application/json"
				}
			});
		}

		this.deleteDataSet = function (dataSetName) {
			var postData = {
				dataSetName: dataSetName
			};
			return $http.post('deleteDataSet.do', postData);
		}

		this.deployDataSet = function (dataSetName) {
			var postData = {
				dataSetName: dataSetName
			};
			return $http.post('deployDataSet.do', postData);
		}

		//functions for Security Entity
		this.getDomainServers = function () {
			return $http.get(baseUrl + "/RestServlet/CommCell/DomainController");
		}

		var headerObj = {
			headers: {
				'limit': 20,
				'offset': 0,
				'sortDir': 0
			}
		};

		this.getUsers = function (providerId) {

			var url = baseUrl + "/RestServlet/user?level=10";
			if (providerId && providerId === parseInt(providerId, 10)) {
				url += "&parent/providerId=" + providerId;
			}
			//return $http.get(baseUrl + "/RestServlet/user?level=10", headerObj);
			return $http.get(url, headerObj);
		}

		//need to figure out how to get userGroup for specific Domain
		this.getUserGroups = function () {
			return $http.get(baseUrl + "/RestServlet/usergroup");
		}

		this.searchUsers = function (searchText) {
			return $http.get("webconsole/browse/getUserSuggestions.do?userString=" + searchText);
		}


		//get Roles
		this.getRoles = function () {
			return $http.get(baseUrl + "/RestServlet/Security/Roles");
		}

		//getAllCategories
		this.getAllCategories = function () {
			return $http.get(baseUrl + "/RestServlet/security/allroles");
		}

		//get roleDetails
		this.getRoleDetails = function (roleId) {
			return $http.post('getRoleDetails.do', {
				roleId: roleId
			});
		}

		//save all information
		this.updateSecurityAssociation = function (reportId, users, userGroups, role) {
			var params = {
				"id": reportId,
				"users": JSON.stringify(users),
				"userGroups": JSON.stringify(userGroups),
				"role": JSON.stringify(role)
			};
			console.log("params: ", params);
			return $http.post('updateSecurityAssociation1.do', params);
		}

		//Gets list of workflows
		this.getForms = function () {
			return $http.get(baseUrl + "/RestServlet/Workflow");
		}

		this.getReportsList = function () {
			return $http.get(baseUrl + "/RestServlet/cr/reportsplusengine/reports");
		}

		this.getTablesList = function () {
			return $http.get(baseUrl + "/proxy/cr/apps/tables");
		}

		this.getTableForms = function (tableId) {
			return $http.get(baseUrl + "/proxy/cr/apps/tables/" + tableId + "/forms");
		}

		this.getTableData = function (tableId) {
			return $http.get(baseUrl + "/RestServlet/cr/apps/tables/" + tableId + "/data");
		}

		this.getRequest = function (url) {
			return $http.get(url);
		}
		this.getAlarmScheduleDetailsFromWS = function (alarmId) {
			var deferred = $q.defer();

			if (alarmId) {
				var url = 'ScheduleMetricsAlerts?entityId=' + alarmId;
				var endPoint = '/proxy/';
				this.getDataForDataSetViaProxy(url, endPoint).then(function (data) {
					if (_.get(data, 'data')) {
						deferred.resolve(_.get(data, 'data'));
					} else {
						console.error('Invalid response: ' + JSON.stringify(data));
						deferred.reject(null);
					}
				}, function (reason) {
					deferred.reject(reason);
				});
			}
			return deferred.promise;
		};
		this.getReportCapabilities = function (reportId) {
			return $http.get(baseUrl + "/proxy/security/131/" + reportId + "/Permissions");
		};
		this.getCountriesGeoJson = function () {
			return $http.get(cvUtil.getContextPath() + '/common/thirdParty/mapbox/v2/countries.geo.json');
		};

	}]);

})();