export const ReportType = {
    WEB_REPORT: 8012
} 

export const CustomQueryType = {
    CUSTOM_QUERY: 1,
    METRICS_QUERY: 2,
    LM_SEARCH: 3,
    CUSTOM_REPORTS_QUERY: 4
}

export const SubTaskType = {
    NONE: 0,
    ADMIN: 1,
    BACKUP: 2,
    RESTORE: 3,
    WORKFLOW: 4,
    COMPLIANCE_POLICY: 5
}

export const TaskOperationType = {
    NONE: 0,
    CUSTOM_QUERY_EXEC: 5014
}


export const TaskType = {
	NONE: 0,
	IMMEDIATE: 1,
	SCHEDULE: 2,
	SAVED_REPORT: 3,
	SCHEDULE_POLICY: 4,
	WORKFLOW: 5,
	PREVIEW: 6,
	AUTOMATIC_COPY: 7,
	AGENTLESS_SRM: 8
}

export const InitFromType = {
    NONE: 0,
    GUI: 1,
    COMMANDLINE: 2,
    SYSTEM: 3,
    SCRIPT: 4,
    SCHEDULE: 5,
    AUTOMATIC: 6,
    ALERT: 7,
    APP_CMDLINE: 8
}

export const WeekOfMonth = {
    None: 0,
    First: 1,
    Second: 2,
    Third: 3,
    Fourth: 4,
    Last: 5,
    SpecificDay: 6
}

export const Day = {
    None: 0,
    Sunday: 1,
    Monday: 2,
    Tuesday: 3,
    Wednesday: 4,
    Thursday: 5,
    Friday: 6,
    Saturday: 7,
    Day: 8,
    Weekday: 9,
    Weekend_Day: 10
}

export const FreqType = {
    One_Time: 1,
    On_Demand: 2,
    Daily: 4,
    Weekly: 8,
    Monthly: 16,
    Monthly_Relative: 32,
    Yearly: 64,
    Yearly_Relative: 128,
    Smart_Schedule: 512,
    Automatic_Schedule: 1024,
    Every: 2048,
    After_Job_Completes: 4096
}

export class TaskDetailsList {
    taskDetails;
}

export class TaskInfo {
    task;
    subTasks;
}

export class Task {
    taskId;
    taskType;
    GUID;
    ownerId;
    ownerName;
    originalCC;
    runUserId;
    initiatedFrom;
    description;
    task;
    taskFlags;
}

export class CommCellEntity {
    commCellId;
    commCellName;
    csGUID;
}

export class TaskEntity {
    taskId;
    taskName;
}

export class TaskFlags {
    disabled;
    isEZOperation;
    isEdgeDrive;
    uninstalled;
}

export class SubTaskInfo {
    subTask;
    pattern;
    options;
}

export class SubTask {
    subTaskId;
    subTaskName;
    subTaskOrder;
    subTaskType;
    operationType;
    subTask;
    flags;
}

export class Pattern {
    patternId;
    name;
    flags;
    freq_type;
    daysToRun;
    active_end_date;
    active_end_occurence;
    active_end_time;
    active_start_date;
    active_start_time;
    calendarId;
    created;
    freq_interval;
    freq_recurrence_factor;
    freq_relative_interval;
    freq_restart_interval;
    freq_subday_interval;
    modified;
    skipDayNumber;
    skipOccurence;
    tzId;
    description;
    timeZone;
}

export class JobOption {
    adminOpts;
}

export class AdminOption {
    reportOption;
    externalEntityAlertOption;
}

export class ReportOption {
    commonOpt;
    webReportOption;
}

export class RptCommonOptions {
    reportType;
} 

export class WebReportOption {
    reportId;
    reportType;
    url;
    webserverId;
}

export class ExternalEntityAlertOption {
    externalEntity;
}

export class ExternalQueryEntity {
    externalQueryId;
    queryType;
}

export class SubtaskEntity {
    subtaskId;
    subtaskName;
}

export class DaysToRun {
    Sunday;
    Monday;
    Tuesday;
    Wednesday;
    Thursday;
    Friday;
    Saturday;
    onDayNumber;
    week;
    day;
}

export class CVTimeZone {
    TimeZoneID;
    TimeZoneName;
}