/**
 * THIS IS A PARTIAL IMPLEMENTATION OF TMMsg messages. 
 * Some types required in alarms and other places are defined.  
 * Note that the fields in the defined classes could also be incomplete and not an exact match. 
 */

export declare enum ReportType {
    WEB_REPORT = 8012
}

export declare enum CustomQueryType {
    CUSTOM_QUERY = 1,
    METRICS_QUERY = 2,
    LM_SEARCH = 3,
    CUSTOM_REPORTS_QUERY = 4
}

export declare enum SubTaskType {
    NONE = 0,
    ADMIN = 1,
    BACKUP = 2,
    RESTORE = 3,
    WORKFLOW = 4,
    COMPLIANCE_POLICY = 5
}

export declare enum TaskOperationType {
    NONE = 0,
    CUSTOM_QUERY_EXEC = 5014
}

export declare enum TaskType {
	NONE = 0,
	IMMEDIATE = 1,
	SCHEDULE = 2,
	SAVED_REPORT = 3,
	SCHEDULE_POLICY = 4,
	WORKFLOW = 5,
	PREVIEW = 6,
	AUTOMATIC_COPY = 7,
	AGENTLESS_SRM = 8
}

export declare enum InitFromType {
    NONE = 0,
    GUI = 1,
    COMMANDLINE = 2,
    SYSTEM = 3,
    SCRIPT = 4,
    SCHEDULE = 5,
    AUTOMATIC = 6,
    ALERT = 7,
    APP_CMDLINE = 8
}

export declare enum WeekOfMonth {
    None = 0,
    First = 1,
    Second = 2,
    Third = 3,
    Fourth = 4,
    Last = 5,
    SpecificDay = 6
}

export declare enum Day {
    None = 0,
    Sunday = 1,
    Monday = 2,
    Tuesday = 3,
    Wednesday = 4,
    Thursday = 5,
    Friday = 6,
    Saturday = 7,
    Day = 8,
    Weekday = 9,
    Weekend_Day = 10
}

export declare enum FreqType {
    One_Time = 1,
    On_Demand = 2,
    Daily = 4,
    Weekly = 8,
    Monthly = 16,
    Monthly_Relative = 32,
    Yearly = 64,
    Yearly_Relative = 128,
    Smart_Schedule = 512,
    Automatic_Schedule = 1024,
    Every = 2048,
    After_Job_Completes = 4096
}

export declare class TaskDetailsList {
    taskDetails: TaskInfo[];
}

export declare class TaskInfo {
    task: Task;
    subTasks: SubTaskInfo[];
}

export declare class Task {
    taskId: number;
    taskType: TaskType;
    GUID: string;
    ownerId: number;
    ownerName: string; 
    originalCC: CommCellEntity;
    runUserId: number;
    initiatedFrom: InitFromType;
    description: string;
    task: TaskEntity;
    taskFlags: TaskFlags;
}

export declare class CommCellEntity {
    commCellId: number;
    commCellName: string;
    csGUID: string;
}

export declare class TaskEntity {
    taskId: number;
    taskName: string;
}

export declare class TaskFlags {
    disabled: number;
    isEZOperation: number;
    isEdgeDrive: number;
    uninstalled: number;
}

export declare class SubTaskInfo {
    subTask: SubTask;
    pattern: Pattern;
    options: JobOption;
}

export declare class SubTask {
    subTaskId: number;
    subTaskName: string;
    subTaskOrder: number;
    subTaskType: SubTaskType;
    operationType: TaskOperationType;
    subTask: SubtaskEntity;
    flags: number;
}

export declare class Pattern {
    patternId: number;
    name: string;
    flags: number;
    freq_type: FreqType;
    daysToRun: DaysToRun;
    active_end_date: number;
    active_end_occurence: number;
    active_end_time: number;
    active_start_date: number;
    active_start_time: number;
    calendarId: number;
    created: number;
    freq_interval: number;
    freq_recurrence_factor: number;
    freq_relative_interval: number;
    freq_restart_interval: number;
    freq_subday_interval: number;
    modified: number;
    skipDayNumber: number;
    skipOccurence: number;
    tzId: number;
    description: string;
    timeZone: CVTimeZone; 
}

export declare class JobOption {
    adminOpts: AdminOption;
}

export declare class AdminOption {
    reportOption: ReportOption;
    externalEntityAlertOption: ExternalEntityAlertOption;
}

export declare class ReportOption {
    commonOpt: RptCommonOptions;
    webReportOption: WebReportOption;
}

export declare class RptCommonOptions {
    reportType: ReportType;
} 

export declare class WebReportOption {
    reportId: string;
    reportType: string;
    url: string;
    webserverId: number;
}

export declare class ExternalEntityAlertOption {
    externalEntity: ExternalQueryEntity;
}

export declare class ExternalQueryEntity {
    externalQueryId: string;
    queryType: CustomQueryType;
}

export declare class SubtaskEntity {
    subtaskId: number;
    subtaskName: string;
}

export declare class DaysToRun {
    Sunday: number;    // defined as boolean but generated JSON should have number. 
    Monday: number;
    Tuesday: number;
    Wednesday: number;
    Thursday: number;
    Friday: number;
    Saturday: number;
    onDayNumber: number;
    week: WeekOfMonth;
    day: Day;
}

export declare class CVTimeZone {
    TimeZoneID: number;
    TimeZoneName: string;
}