(function (H) {

  H.wrap(H.Chart.prototype, 'init', function (proceed) {
    // Run the original proceed method      
    proceed.apply(this, Array.prototype.slice.call(arguments, 1));
    var chart = this,
      container = chart.container,
      options = chart.options;
    // console.log(chart);
    var isInteractiveEnabled = options.chart.interactiveEnabled;
    if (isInteractiveEnabled) {
      H.addEvent(this,
        'selection',
        function (e) {
          if (options.chart.type === 'column' || options.chart.type === 'bar' ||
            options.chart.type === 'treemap') {
            $(container).find("svg .highcharts-series-group rect").css('fillOpacity', '0.25');
          } else {
            $(container).find("svg .highcharts-series-group path").css('fillOpacity', '0.25');
          }
          H.each(this.series, function (series) {
            H.each(series.points, function (point) {
              if (point.x >= e.xAxis[0].min && point.x <= e.xAxis[0].max) {
                $(point.graphic.element).css("fill-opacity", "1");
                point.isSelected = true;
              } else if (point.isSelected) {
                $(point.graphic.element).css("fill-opacity", "1");
              } else {
                point.isSelected = false;
              }
            });
          });
          e.preventDefault();
        });

      H.addEvent(this, 'load', function (e) {
        var isFilterAvailable = false;
        H.each(chart.series, function (series) {
          H.each(series.points, function (point) {
            if (point.isSelected) {
              if (!isFilterAvailable) {
                isFilterAvailable = true;
                if (options.chart.type === 'column' || options.chart.type === 'bar' ||
                  options.chart.type === 'treemap') {
                  $(container).find("svg .highcharts-series-group rect").css('fillOpacity', '0.25');
                } else {
                  $(container).find("svg .highcharts-series-group path").css('fillOpacity', '0.25');
                }
              }
              $(point.graphic.element).css("fill-opacity", "1");
            }
          });
        });
      });

      H.addEvent(this, 'redraw', function (e) {
        var isFilterAvailable = false;
        var series = chart.series;
        H.each(series, function (series1) {
          H.each(series1.points, function (point) {
            if (point.isSelected) {
              if (!isFilterAvailable) {
                isFilterAvailable = true;
                if (options.chart.type === 'column' || options.chart.type === 'bar' ||
                  options.chart.type === 'heatmap' || options.chart.type === 'treemap') {
                  $(container).find("svg .highcharts-series-group rect").css('fillOpacity', '0.25');
                } else {
                  $(container).find("svg .highcharts-series-group path").css('fillOpacity', '0.25');
                }
              }
              $(point.graphic.element).css("fill-opacity", "1");
              if (options.chart.type === 'line') {
                $(point.graphic.element).attr("stroke-width", "5");
                $(point.graphic.element).attr("stroke", $(point.graphic.element).attr('fill'));
              }
              // else if (options.chart.type === 'pie') {
              //         point.slice(true);
              // }
            }
          });
        });
      });

      //console.log(options.plotOptions.series.point);
      H.addEvent(this.container, 'click', function (e) {
        if (e && e.hasOwnProperty('point')) {
          // console.log(e);
          var selectedPoint = e.point;
          var isHeatMap = false;
          if (options.chart.type === 'heatmap') {
            isHeatMap = true;
          }
          if (options.chart.type === 'column' || options.chart.type === 'bar' || isHeatMap ||
            options.chart.type === 'treemap') {
            $(container).find("svg .highcharts-series-group rect").css('fillOpacity', '0.25');
          } else {
            if (options.chart.type === 'pie') {
              $(container).find("svg .highcharts-series-group path").css('fillOpacity', '0.25');
            } else {
              $(container).find("svg .highcharts-markers path").css('fillOpacity', '0.25');
            }
          }
          $(selectedPoint.graphic.element).css('fillOpacity', 1);
          // if (isHeatMap) { // add yaxis value in current target
          //   e.currentTarget.yaxisvalue = chart.axes[1].categories[selectedPoint.y];
          // }
          var isRemoved = false;
          var selectedPoints = 0;
          if (selectedPoint.isSelected) {
            selectedPoint.isSelected = false;
          } else {
            selectedPoint.isSelected = true;
          }
          H.each(chart.series, function (series) {
            H.each(series.points, function (point) {
              if (point.x == selectedPoint.x && (!isHeatMap || point.y == selectedPoint.y)) {
                if (selectedPoint.isSelected) {
                  $(point.graphic.element).css("fill-opacity", "1");
                  if (options.chart.type === 'line') {
                    $(point.graphic.element).attr("stroke-width", "5");
                    $(point.graphic.element).attr("stroke", $(point.graphic.element).attr('fill'));
                  }
                  point.isSelected = true;
                  selectedPoints++;
                } else {
                  $(point.graphic.element).css("fill-opacity", "0.25");
                  if (options.chart.type === 'line') {
                    $(point.graphic.element).attr("stroke-width", "1");
                    $(point.graphic.element).attr("stroke", $(point.graphic.element).attr('fill'));
                  } else if (options.chart.type === 'pie') {
                    point.slice(false);
                  }
                  point.isSelected = false;
                }
              } else if (point.isSelected) {
                $(point.graphic.element).css("fill-opacity", "1");
                if (options.chart.type === 'line') {
                  $(point.graphic.element).attr("stroke-width", "5");
                  $(point.graphic.element).attr("stroke", $(point.graphic.element).attr('fill'));
                }
                point.isSelected = true;
                selectedPoints++;
              } else {
                $(point.graphic.element).css("fill-opacity", "0.25");
                point.isSelected = false;
              }
            });
          });
          // console.log(selectedPoints);
          if (selectedPoints == 0) {
            if (options.chart.type === 'column' || options.chart.type === 'bar' ||
              options.chart.type === 'treemap') {
              $(container).find("svg .highcharts-series-group rect").css('fillOpacity', '1');
            } else {
              $(container).find("svg .highcharts-series-group path").css('fillOpacity', '1');
            }
          }
        }
      });

    }
  });

  H
    .wrap(H.Chart.prototype,
      'print',
      function (proceed) {
        var chart = this,
          chartWidth = chart.chartWidth,
          chartHeight = chart.chartHeight,
          printMaxWidth = 780,
          printMaxHeight = 500;
        this.setSize(printMaxWidth, printMaxHeight, false);
        proceed.apply(this, Array.prototype.slice.call(arguments, 1));
        setTimeout(function () {
          chart.setSize(chartWidth, chartHeight, false); // setSize(width, height, animate)
        }, 1000);
      });

  Highcharts
    .wrap(Highcharts.Legend.prototype,
      'renderItem',
      function (proceed, item) {
        // http://jsfiddle.net/Ha3Wr/57/
        proceed.call(this, item);

        var isPoint = !!item.series,
          collection = isPoint ? item.series.points : this.chart.series,
          element = item.legendGroup.element;
        element.onmouseout = function () {
          H.each(collection, function (seriesItem) {
            if (seriesItem.legendItem) {
              var legendItem = seriesItem.legendItem;
              if (legendItem.styles.fontWeight != "bold") {
                legendItem.styles.fontWeight = "normal";
              }
            }
          });
        }

      });

}(Highcharts));