// Closure to isolate scope, as per best practices
window.dataSetUtility = (function() {
	var URL = "reportsplusengine/datasets/{{dsParam.dsId}}/{{dsParam.operation}}/?offset={{dsParam.offset}}";
	var excludeParams = ["componentName","isExport"];
	var urlParamDelimiter = "-";
	var dsUtil = {
		params : {}
	}

	dsUtil.initPrams = function() {
		dsUtil.params = {
			fields : [],
			groupby : [],
			parameters : [],
			orderby : "",
			isExport : false,
			where:""
		}
	}

	// isApiMode is set to true when showing the url Rest Api model. We do not need some system parameters like cacheId to be copied into the url.
	dsUtil.getUrlForDataComponent = function(component, dataSet, page, dataSetParams, urlParams, isTopologyNodes,
			isGrouped,isApiMode) {
		var finalUrl = dsUtil.getBaseUrl(dataSet, dataSetParams,isApiMode);
		var params = dsUtil.getParams(component, dataSet, page, dataSetParams, urlParams, isTopologyNodes, isGrouped);
		if (params.parametersList) {
			delete params.parametersList;
		}
		if(isApiMode){
			for(var param of excludeParams){
				delete params[param];
			}
		}
		finalUrl = finalUrl + "&" + dsUtil.requestToUrl(params);
		return finalUrl;
	}


	dsUtil.getParams = function(component, dataSet, page, dataSetParams, urlParams, isTopologyNodes, isGrouped) {
		dsUtil.initPrams();
		dsUtil.isExport = urlParams['exportType'] || false;
		dsUtil.csvExportType = urlParams['csvExportType'] || false;
		dsUtil.isAlarm = urlParams['isAlarm'] || false;
		dsUtil.params.componentName = dataSetParams.componentName;
		dsUtil.params.parametersList = dsUtil.applyInputsToDataSetV2(dataSet,
				page.inputs,
				dataSetParams.builderVersion,
				urlParams);
		if (component) {
			var urlOptions = dsUtil.getUrlOptions(component.id, urlParams);
			dsUtil.initParamsForComponent(component, urlOptions, dataSet, isTopologyNodes, isGrouped);
			if (!component.skipFilters) {
				dsUtil.processFilters(urlParams, component, page, isGrouped, dataSetParams)
			}

			if (component.searchText) {
				dsUtil.params.where = [];
				dsUtil.params.where.push(component.searchText)
			}

			if (component.formatObject) {
				dsUtil.params['format'] = "object";
			}
		}

		return dsUtil.params;
	}

	dsUtil.getBaseUrl = function(dataSet, dataSetParams,isApiMode) {
		let tempUrl = URL;

		if(!isApiMode){
			tempUrl += "&cacheId={{dsParam.cacheId}}";
		}
		var args = {};
		args["expression"] = tempUrl;
		args["dsParam"] = dataSetParams;
		return rpt.evalExpression(args);
	}

	/*
	 * For Line charts Line should be continuous with out any drops. Because we are adding zero to normalize the data the line looks dropped.
	 *
	 */
	dsUtil.supportNullValues = function(component){
		if((component.chartType === 'Line' || component.chartType == 'TimeSeries') && component.SkipLinesForMissingData){
			return true;
		}else{
			return false;
		}
	}

	dsUtil.downloadReportFile = function(fileName) {
		if (!fileName || fileName == "" || fileName == 'null') {
			cvUtil.errorToast(localMsg['ExportError']);
		} else {
			var finalLink = cvUtil.getContextPath() + "/reportsplus/downloadTableCsv.do?type=report&fileName=" +
					window.encodeURIComponent(fileName);
			var iframeId = "iframe" + Date.now();
			var iframeDOM = document.createElement("iframe");
			iframeDOM.setAttribute("style", "display:none;");
			iframeDOM.id = iframeId;
			document.body.appendChild(iframeDOM);
			iframeDOM.src = finalLink;
		}
	}

	dsUtil.initParamsForComponent = function(component, urlOptions, dataSet, isTopologyNodes, isGrouped) {
		if (component.type == "CHART" || component.type === "HITS" || component.type === "HEAT_MAP" ||
				component.type === "FACET" || component.type == "MAP" || component.type == "MAP_v2") { //Facet drop comes here
			if (component.chartType !== 'TileStatusChart') {
				dsUtil.fields = dsUtil.initChartparams(component, dsUtil.isExport);
			}
		} else if (component.type == "PIVOT_TABLE") {
			dsUtil.initPivotTableParams(component, urlOptions);
		} else if (component.type == "SCATTER") {
			var flds = []
			flds.push("[" + component.scatterX.name + "]");
			flds.push("[" + component.scatterY.name + "]");
			flds.push("[" + component.scatterLabel.name + "]");
			dsUtil.params.fields = flds.join(",");
		} else if (component.type === 'TOPOLOGY') {
			// Removed fields so it uses all the fields;
		} else if (component.type == 'NEW_TABLE_DISTINCT') {
			dsUtil.initGridDistinctParams(component, urlOptions, dataSet);
		} else if (component.type == 'INPUT') {
			dsUtil.initInputParams(component, urlOptions, dataSet);
		} else {
			dsUtil.initTableParams(component, urlOptions, dataSet, isGrouped);
		}
	}

	dsUtil.getUrlOptions = function(componentId, urlParams) {
		var sortingArr = [], filterArr = [], urlOptions = {}, columnId = "";
		if (urlParams) {
			// iterate through all parameters and find the keys that have the component id.
			for ( var key in urlParams) {
				var param = urlParams[key];
				if (key.indexOf(componentId) == 0) { // if key starts with the comnponent id
					var type = key.substring(key.indexOf("."), key.length);
					if (type === ".sort") {
						var sorts = param.split(",");
						for ( var i in sorts) {
							var sort = sorts[i];
							sortingArr.push({
								columnId : sort.indexOf("-") == 0 ? sort.substring(1, sort.length) : sort,
								direction : sort.indexOf("-") === 0 ? "desc" : "asc"
							});
						}
					} else if (type.indexOf(".filter.") != -1) {
						filterArr.push({
							columnId : decodeURIComponent(key.substring(key.indexOf(".filter.") + 8, key.length)),
							fValue : param
						});
					}
				}
			}
		}
		if (!$.isEmptyObject(filterArr)) {
			urlOptions["filters"] = filterArr;
		}
		if (!$.isEmptyObject(sortingArr)) {
			urlOptions["sorting"] = sortingArr;
		}
		return urlOptions;
	}

	dsUtil.initGridDistinctParams = function(component, urlOptions, dataSet) {
		var field = component.group[0].dataField;
		dsUtil.params.fields = [
				'distinct([' + field + ']) AS value',
				"count(IFNULL([" + field + "], '')) AS [Count_" + field + "]" ]
		dsUtil.params.orderby = '[' + field + ']' + " Asc"
		dsUtil.params.groupby = [ '[' + field + ']' ]
		dsUtil.params.fields = dsUtil.params.fields.join(",");
		dsUtil.params.groupby = dsUtil.params.groupby.join(",");
		if(dataSet && dataSet.endpoint == "HTTP"){
			dsUtil.params.rawData = true;
		}
	}

	let htmlRegex = /((<style>)[^]*(<\/style>))+|((<script>)[^]*(<\/script>))+|<\/?[^>]+>/ig;
	dsUtil.removeHtml = function(displayName){
		//some column display name may have links and html which is not needed during csv export.
		if (displayName && typeof displayName === "string" && htmlRegex.test(displayName)) {
			displayName = displayName.replace(htmlRegex, '');
		}

		return displayName;
	}

	dsUtil.initTableParams = function(component, urlOptions, dataSet, isGrouped) {
		var actualHiddenColumns = [], aggrTypeFound = false, orderByClause = "", colIdToAliasmap = {};
		if (component.type == "R-GGPlot") {
			return;
		}

		for (var i = 0; i < component.columns.length; i++) {
			var column = component.columns[i];
			if (column.dataField.indexOf("_ActualHidden") != -1) {
				actualHiddenColumns.push(column.dataField);
			}
			//			if (dsUtil.isExport && column.hidden) {
			//				continue; // Hidden columns are shown in the alert export.
			//			}

			var field = "[" + column.dataField + "]";

			var aliasName = column.id;
			// Should not use displayName in the case of an alert
			// As it'll change the dataField/ID value. And the alert will not show all column values.
			if (dsUtil.isAlarm != 'true' && dsUtil.isExport && dsUtil.isExport.toLowerCase() === 'csv') {
				aliasName = rpt.translate(column.displayName);
				// feature usage report has HMTL  in the display name.
				aliasName = dsUtil.removeHtml(aliasName);
			}

			if (column.aggrType && column.aggrType != 'None') {
				aggrTypeFound = true;
				if (column.aggrType == 'CountDistinct') {
					dsUtil.params.fields.push("count (distinct(" + field + ")) AS [" + aliasName + "]");
				} else if (column.aggrType == 'Count' && column.countNullsAsBlank) {
					dsUtil.params.fields.push("count (IFNULL(" + field + ",'')) AS [" + aliasName + "]");
				} else {
					dsUtil.params.fields.push(column.aggrType + "(" + field + ") AS [" + aliasName + "]");
				}

			} else {
				dsUtil.params.fields.push(field + " AS [" + aliasName + "]");
				dsUtil.params.groupby.push(field);
			}

			if (component.allColumns) {
				aliasName = column.dataField;
			}

			var index = actualHiddenColumns.indexOf(column.dataField + "_ActualHidden");
			if (index != -1) {
				aliasName = actualHiddenColumns[index];
			}
			colIdToAliasmap[column.id] = aliasName;
		}

		if (!aggrTypeFound) {
			dsUtil.params.groupby = [];
		} else if (component.allColumns) {
			//remove the sys column sys_rowid from the group by
			dsUtil.params.groupby.splice(dsUtil.params.groupby.indexOf("[sys_rowid]"), 1)
			dsUtil.params.fields.splice(dsUtil.params.fields.indexOf("[sys_rowid] AS [sys_rowid]"), 1);
		}
		var sorting = component.sorting;

		if (urlOptions && urlOptions.hasOwnProperty("sorting")) {
			sorting = urlOptions['sorting'];
		}

		if (sorting && sorting.length > 0) {
			for (var j = 0; j < sorting.length; j++) {
				var sort = sorting[j];
				var coltoSort = colIdToAliasmap[sort.columnId];
				if (coltoSort) {
					orderByClause = orderByClause + "[" + coltoSort + "] " + sort.direction + ",";
				}
			}
			if (orderByClause) {
				dsUtil.params.orderby = orderByClause.substring(0, orderByClause.lastIndexOf(','));
			}
		}
		if (component.allColumns && !dsUtil.csvExportType) {
			dsUtil.params.fields = [];
		}
		if (isGrouped) {
			var groupData = component.group[0];
			dsUtil.params.groupby = [];
			dsUtil.params.where = dsUtil.getNewFilter(groupData.value, groupData.dataField, groupData.type, false, false,"exact");
		}
		dsUtil.params.limit = component.pageSize;
		dsUtil.params.fields = dsUtil.params.fields.join(",");
		dsUtil.params.groupby = dsUtil.params.groupby.join(",");
		if(dataSet && dataSet.endpoint == "HTTP"){
			dsUtil.params.rawData = true;
		}
	}

	dsUtil.initInputParams = function(component) {
		dsUtil.params.limit = component.pageSize;
		dsUtil.params.fields = component.columns.join(",");
		dsUtil.params.orderby = component.orderByClause;
		dsUtil.params.where = component.where.join("or");

		if (component.additionalParams) {
			dsUtil.params = _.merge({}, dsUtil.params, component.additionalParams);
		}
	}

	dsUtil.initPivotTableParams = function(component, urlOptions) {
		if (!component.pivotRow) {
			return;
		}

		var pivotOrderBy = "";
		var pivotRow = "[" + component.pivotRow.column + "]";
		var pivotRowTitle = component.pivotRow.title.text;
		var pivotGroupByList = [];
		var pivotFields = [];
		var colIdToDataFieldMap = {};
		var orderByClause = "";//default sorting defined at the component level.
		pivotGroupByList.push(pivotRow);
		if (component.pivotRow.title && component.pivotRow.title.text &&
				component.pivotRow.column !== component.pivotRow.title.text) {
			pivotRow = pivotRow + " AS [" + pivotRowTitle + "]";
		}

		var pivotColumn = "[" + component.pivotColumn.column + "]";
		pivotGroupByList.push(pivotColumn);
		var pivotCell = component.pivotCell.column;

		var aggrType = component.pivotCell.aggrType;
		var aliasColumn = "[" + component.pivotCell.column + " " + aggrType + "]";
		if (aggrType && aggrType != "None") {
			if (aggrType == 'CountDistinct') {
				pivotCell = "count (distinct([" + pivotCell + "])) AS " + aliasColumn;
			} else {
				var defaultValue = (aggrType === 'Count' || !component.pivotCell.showNumberOps) ? "''" : -1;
				pivotCell = aggrType + "(IFNULL([" + pivotCell + "]," + defaultValue + ")) AS " + aliasColumn;
			}
		}

		for ( var i in component.columns) {
			var column = component.columns[i];
			var colToAdd = column.dataField;
			colIdToDataFieldMap[column.id] = colToAdd;
			if (!component.allColumns) {
				colToAdd = "[" + column.dataField + "]";
				pivotFields.push(colToAdd);
			}
		}

		var sorting = component.sorting;

		if (urlOptions && urlOptions.hasOwnProperty("sorting")) {
			sorting = urlOptions['sorting'];
		}

		if (sorting && sorting.length > 0) {
			for (var j = 0; j < sorting.length; j++) {
				var sort = sorting[j];
				var coltoSort = colIdToDataFieldMap[sort.columnId];
				if (coltoSort) {
					orderByClause = orderByClause + "[" + coltoSort + "] " + sort.direction + ",";
				}
			}
			if (orderByClause) {
				dsUtil.params.orderby = orderByClause.substring(0, orderByClause.lastIndexOf(','));
			}
		}

		if (component.orderColumns) {
			pivotOrderBy = pivotColumn;
			if (component.pivotDirection) {
				pivotOrderBy = pivotOrderBy + " " + component.pivotDirection;
			}
		}

		dsUtil.params.pivotRow = pivotRow;
		dsUtil.params.pivotColumn = pivotColumn;
		dsUtil.params.pivotCell = pivotCell;
		dsUtil.params.pivotGroupby = pivotGroupByList.join(",");
		dsUtil.params.pivotOrderby = pivotOrderBy;
		dsUtil.params.pivotRowTitle = pivotRowTitle;
		dsUtil.params.fields = pivotFields;
		dsUtil.params.limit = component.pageSize;
	}

	var convertTargetToSourceSize = function(filterValue, targetSizeType,operatorLength) {
		let sourceSizeType = filterValue.substring(filterValue.length-2);
		let operator = filterValue.substring(0,operatorLength);
		let value = parseInt(filterValue.substring(operatorLength,filterValue.length-2));

		// we need to convert the user selected size into the column size format for the filter to work in the backend
		value = cvFormatters.formatSize(value, {
			target : targetSizeType.toUpperCase(),
			source : sourceSizeType.toUpperCase(),
			tofixed : 2
		});
		value = value.split(" ")[0]; // only send the value and not the unit.
		value = operator+value;
		return value;
	}

	var covertSizefilter = function(filterValue, targetSizeType){
		let operatorLength = 1;
		if(!filterValue.startsWith(">=")){
			return convertTargetToSourceSize(filterValue, targetSizeType,operatorLength);
		}else{
			operatorLength = 2;
			if (filterValue.indexOf("&&") !== -1) {
				var y = filterValue.split("&&");
				y[0] = convertTargetToSourceSize(y[0], targetSizeType,operatorLength);
				y[1] = convertTargetToSourceSize(y[1], targetSizeType,operatorLength);
				return y.join("&&");

			}else{
				return convertTargetToSourceSize(filterValue, targetSizeType,operatorLength);
			}
		}
	}

	dsUtil.processFilters = function(urlParams, component, page, isGrouped, dataSetParams) {
		var reportComponents = page.body && page.body.reportComponents;
		var column, value, sourceComp, filters = {}, where = [], filter = [], havingClause = [];
		var where = isGrouped ? [ dsUtil.params.where ] : [];
		for ( var key in urlParams) {
			value = urlParams[key];
			var comp = key.substring(0, key.indexOf('.')); // get the component name from the key
			if (!comp) {
				continue; // if there is no component then there is no need to process the filters.
			}
			sourceComp = dsUtil.getComponent(comp, reportComponents);
			if (dataSetParams.panelComponentsToIds && dataSetParams.panelComponentsToIds[comp]) {
				if (dataSetParams.panelComponents[dataSetParams.panelComponentsToIds[comp]].indexOf(component.id) === -1) {
					continue;
				}
			}
			var isSameComponent = key.indexOf(component.id) === 0 ? true : false;
			if (!sourceComp && isSameComponent) {
				sourceComp = component;
			}
			var col = decodeURIComponent(key.substring(key.indexOf(".filter.") + 8, key.length));
			if (key.indexOf(".filter.") != -1) {
				if (sourceComp.type !== "TABLE" && sourceComp.type !== "PIVOT_TABLE" && component.type != "R-GGPlot") {
					var sourceDataset = dsUtil.getDataSet(sourceComp.dataSet.dataSetName, page.dataSets.dataSet);
					var currentDs = dsUtil.getDataSet(component.dataSet.dataSetName, page.dataSets.dataSet);
					var sourceField = dsUtil.getFieldDefintion(col, sourceDataset);
					var applyFilter = dsUtil.checkIffiltercanBeApplied({
						filterField : sourceField
					}, currentDs);

					if (!applyFilter && !sourceComp.isQuickAnalysis) {
						continue; // do not add thefilter if the source component data set and the other component data set do not match.
					}
				}

				if (!filters[comp]) {
					filters[comp] = [];
				}
				var condition = "";
				if (sourceComp.type === "TABLE" || sourceComp.type === "PIVOT_TABLE") {
					column = dsUtil.getColumnDefByName(col, component.columns);

					// skip the same column filter when loading the select options
					if (component.skipSameColumnFilters && component.selectColumn && component.selectColumn === col) {
						continue;
					}

					// apply parent filters when grouping and the filters are not on the same column with in the component
					if (component.applyParentFilters) {
						column = dsUtil.getColumnDefByName(col, sourceComp.columns);
					}
					if (column) {
						var aliasName = column.dataField;
						condition = dsUtil.getNewFilter(value, aliasName, column.type);
						if (sourceComp.type == "PIVOT_TABLE" && component.id === sourceComp.id) {
							filter.push(condition);
						} else {
							if (component.id === sourceComp.id || component.parentId === sourceComp.id) {
								if (column.aggrType !== "None") {
									aliasName = dsUtil.isExport ? column.displayName : column.id;
									var aggrfilterColumn = column.aggrType + "([" + column.dataField + "])";
									if (column.aggrType == "CountDistinct") {
										aggrfilterColumn = "count (distinct([" + column.dataField + "]))";
									}
									condition = dsUtil.getNewFilter(value, aggrfilterColumn, column.type, true);
									havingClause.push(condition);
								} else {
									if (value) {
										where.push(condition);
									}
								}
							}
						}
					} else if (col === "*" && (component.id === sourceComp.id || component.parentId === sourceComp.id)) {
						condition = dsUtil.getNewFilter(value, col, "string", false, undefined, 'containsAll');
						where.push(condition);
					}
				} else if (sourceComp.type === "SEARCH_BAR") {
					var column;
					var type = "string";
					if (col !== "*") { // we dont need to check for types for *.
						if (sourceComp.searchFields) {
							for (var i = 0; i < sourceComp.searchFields.length; i++) {
								var field = sourceComp.searchFields[i];
								if (field.column === col) {
									column = field.column;
									if (field.dataType) {
										type = field.dataType;
									}
									break;
								}
							}
						}
					}
					condition = dsUtil.getNewFilter(value, col, type);
					filters[comp].push(condition);
				} else if (sourceComp.type === "CHART" || sourceComp.type === "HEAT_MAP" || sourceComp.type === "FACET") { //Adding here helps deserialize json proeprly.
					// for time line chart the filters can be applied to self when user zooms into the component.
					if ((sourceComp.chartType === 'TimeSeries' || component.id !== sourceComp.id) ||
							(component.id === sourceComp.id && component.isQuickAnalysis)) {
						try {
							values = JSON.parse(value);
						} catch (e) {
							values = value;
						}
						if (!(values instanceof Array)) {
							values = [ values ];
						}
						for ( var i in values) {
							var currentValue = values[i];
							var isRemaining = false;
							var newCondition;
							if (currentValue instanceof Object) {
								condition = " (";
								for ( var x in currentValue) {
									col = x;
									value = currentValue[x];
									newCondition = dsUtil.getChartFilterCondition(col, value, sourceComp, page);
									if (condition.indexOf(newCondition) === -1) {
										condition = condition + newCondition + ' and ';
									}
								}
								condition = dsUtil.processFilterClause(condition);
								condition = condition + ") or ";
							} else {
								newCondition = dsUtil.getChartFilterCondition(col, currentValue, sourceComp, page);
								if (condition.indexOf(newCondition) === -1) {
									condition = condition + newCondition + ' or ';
								}
							}
						}
						condition = dsUtil.processFilterClause(condition);
						filters[comp].push(condition);
					}
				} else if (sourceComp.type === "DATE_RANGE") {
					condition = dsUtil.getNewFilter(value, col, sourceComp.dateRangeType);
					filters[comp].push(condition);
				} else if (sourceComp.type === "KENDO_GRID") {
					var values = JSON.parse(value) || value;
					if (!(values instanceof Array)) {
						values = [ values ]
					}
					column = dsUtil.getColumnDefByName(col, component.columns);
					if (column) {
						var condition = ''
						values.map(function(val, idx) {
							condition += (idx > 0 ? 'or' : '') +
									dsUtil.getNewFilter(val, column.dataField, column.type);
						})
						filters[comp].push(condition);
					}
				} else {
					condition = dsUtil.getNewFilter(value, col);
					filters[comp].push(condition);
				}

			} else if (key.indexOf(".select.") !== -1) {
				col = decodeURIComponent(key.substring(key.indexOf(".select.") + 8, key.length));
				if ((component.id === sourceComp.id || component.parentId === sourceComp.id) &&
						(sourceComp.type === "TABLE" || sourceComp.type === "PIVOT_TABLE")) {
					column = dsUtil.getColumnDefByName(col, sourceComp.columns);
					// when showing select options we need should not apply the select filter of same column.
					if (component.skipSameColumnFilters && component.selectColumn && component.selectColumn === col) {
						continue;
					}

					var values, conditions = [];
					var condition = "";
					var arrayToPush = where;
					if (sourceComp.type == "PIVOT_TABLE" && component.id === sourceComp.id) {
						arrayToPush = filter;
					}
					var doNotAddBrackets = false;
					if (column) {
						if (typeof value === "string" && value === "$all$") {
							continue;
						} else if (typeof value === "string" && value.startsWith("[")) {
							values = JSON.parse(value);
						} else {
							let formatter = _.get(column,'cellExpression.type');
		                     if(formatter === 'size'){
		                    	 let colSizeFormat = _.get(column,'cellExpression.source');
		                    	 if(colSizeFormat !== "bytes"){
		                    		 value = covertSizefilter(value,colSizeFormat);
		                    	 }
		                     }

							values = [ value ];
						}
						var aliasName = column.dataField;
						if (column.aggrType !== "None") {
							aliasName = column.aggrType === "CountDistinct" ? "count(distinct([" + column.dataField +
									"]))" : column.aggrType + "([" + column.dataField + "])";
							doNotAddBrackets = true;
							arrayToPush = havingClause;
						}
						for ( var i in values) {
							conditions.push(dsUtil.getNewFilter(values[i],
									aliasName,
									column.type,
									doNotAddBrackets,
									undefined,
									column.type.toLowerCase() === "string" ? "exact" : "equals"));
						}
					}

					condition = conditions.length === 1 ? conditions[0] : conditions.join(" or ");
					arrayToPush.push(condition);
				}
			}
		}
		for ( var componentName in filters) {
			// for time line chart the filters can be applied to self when user zooms into the component.
			if (component.type === "CHART" && component.chartType !== 'TimeSeries' && component.id === componentName && !component.isQuickAnalysis) {
				delete filters[componentName]; // do not apply current filters on the same source component
			} else {
				if (filters[componentName]) {
					$.merge(where, filters[componentName]);
				}
			}
		}

		if (urlParams["isOr"] === "or" && sourceComp &&
				(sourceComp.type === "TABLE" || sourceComp.type === "PIVOT_TABLE")) {
			dsUtil.params.where = [ where.join(" or ") ];
			dsUtil.params.having = [ havingClause.join(" or ") ];
			dsUtil.params.filter = [ filter.join(" or ") ];
		} else {
			dsUtil.params.where = where;
			dsUtil.params.having = havingClause;
			dsUtil.params.filter = filter;
		}
	}

	dsUtil.getComponent = function(componentName, components, rootLevel) {
		var component;
		var panelComponent;
		var tabComponent;
		if (components.length > 0) {
			for (var i = 0; i < components.length; i++) {
				var comp = components[i];
				if (comp.id === componentName) {
					component = comp;
					break;
				}
				if (comp.type === 'TABLE') {
					var quickChartComponent = comp.quickChart;
					if (quickChartComponent) {
						if (quickChartComponent.id === componentName) {
							component = quickChartComponent;
							break;
						}
					}
				}
				if (comp.type === "PANEL") {
					var panelComponent = dsUtil.getComponent(componentName, comp.panelComponents);
					if (panelComponent) {
						component = panelComponent;
						break;
					}
				}

				if (comp.type === "TABS") {
					for (var k = 0; k < comp.tabs.length; k++) {
						var tab = comp.tabs[k];
						if (!rootLevel) {
							tabComponent = dsUtil.getComponent(componentName, tab.component.panelComponents);
							if (tabComponent) {
								break;
							}
						} else if (tab.id === componentName) {
							tabComponent = tab;
							break;
						}
					}

					if (tabComponent) {
						component = tabComponent;
						break;
					}
				}

				if (comp.type === "PANEL_HEADER") {
					component = dsUtil.getComponent(componentName, comp.panelHeaderComponents);
					component = tabComponent;
					break;
				}

			}
		}
		return component;
	};

	dsUtil.getColumnDefByName = function(name, columns) {
		var col = undefined;
		for ( var i in columns) {
			var column = columns[i];
			if (column.id.toLowerCase() == name.toLowerCase()) {
				col = column;
			}
		}

		return col;
	}

	dsUtil.getChartFilterCondition = function(col, currentValue, sourceComp, page) {
		var remainingValues = [];
		var isRemaining = false;
		for (var k = 0; k < sourceComp.dimensionDataField.length; k++) {
			var dimension = sourceComp.dimensionDataField[k];
			if (dimension.customGroupsAvailable && dimension.groups && dimension.groups.length > 0) {
				for (var i = 0; i < dimension.groups.length; i++) {
					var value = dimension.groups[i]['groupValues'];
					remainingValues.push(value);
					if (currentValue === dimension.groups[i]['groupName']) {
						if (value === "*") {
							isRemaining = true;
						} else {
							currentValue = dimension.groups[i]['groupValues'];
						}
					}
				}
			}
		}

		var cond = '=';
		if (isRemaining) {
			currentValue = remainingValues.join(",");
			cond = '!=';
		}
		var ds = dsUtil.getDataSet(sourceComp.dataSet.dataSetName, page.dataSets.dataSet);
		var colObj;

		for (var i = 0; i < ds.fields.length; i++) {
			var field = ds.fields[i];
			if (field.name === col) {
				colObj = field;
				break;
			} else if (field.name.split(' ').join('') === col) {
				colObj = field;
				break;
			} else if (field.dataField === col) {
				colObj = field;
				break;
			}
		}

		var colType = colObj && colObj.type;
		var colName = (colObj && colObj.name) || col;

		return dsUtil.getNewFilter(currentValue, colName, colType, false, cond,"equals");
	}

	dsUtil.getNewFilter = function(value, col, type, doNotAddBrackets, condition, defaultOperator) {
		//		if (value && (typeof value === 'string' || value instanceof String) && value.indexOf(",") != -1) {
		//			value = value.replace(',', '\\\\,')
		//		}

		var operator = type && (type.toLowerCase() === "string" || type === 'FileList') ? "contains" : "";
		if (col === "*" && !type) {
			operator = "contains";
		}

		// this code block will make sure that empty and null values will be treated the same select filter or group by on table functionality is used.
		if(defaultOperator && value === ""){
			value = '=""';
			defaultOperator = "";
		}

		if (defaultOperator && value !== "") {
			operator = defaultOperator;
		}
		if (!condition) {
			condition = "=";
		}
		if (!doNotAddBrackets) {
			col = "[" + col + "]"; // columns having aggreagtion should not have square brackets.
		}
		var funcExpression = "_expr";
		if (type && (type.toLowerCase() === "string" || type === 'FileList')) {
			funcExpression = "_exprString";
			value = value.replace(/"/g, '""');
		} else if (type && [ "double", "float", "integer", "long", "short" ].indexOf(type.toLowerCase()) !== -1) {
			funcExpression = "_exprInt";
		} else if (type && [ "timestamp", "date" ].indexOf(type.toLowerCase()) !== -1) {
			funcExpression = "_exprDateTime";
		}
		var expression = col + ' ' + condition + ' ' + funcExpression + '("' + value + '")';
		if (typeof key !== "undefined" && key.startsWith("Facet")) {
			return expression;
		}

		if(value === '=""""'){
			value += " || null"; // when a blank query is made include the null values as well as we show them blank in the grid.
		}

		if (operator) {
			expression = col + ' ' + condition + ' ' + funcExpression + ' ("' + value + '","' + operator + '")'
		}
		return expression;
	}

	dsUtil.processFilterClause = function(whereClause) {
		var andLastIndex = whereClause.lastIndexOf("and");
		var orLastIndex = whereClause.lastIndexOf("or");
		var index = Math.max(andLastIndex, orLastIndex);
		if (index != -1) {
			whereClause = whereClause.substring(0, index);
		}

		return whereClause;
	}

	dsUtil.getCompareParams = function(component, grouping) {
		var compareParams = undefined;

		if (component.showCompare && component.showCompare === true) {
			compareParams = {};
			if (grouping == "auto" && component.chartTimeGroup) {
				compareParams.timeGroup = component.chartTimeGroup;
			} else {
				compareParams.timeGroup = grouping;
			}

			if (component.selectedCompareOption && component.selectedCompareOption.val &&
					component.selectedCompareOption.val != "None") {
				compareParams.timeSpan = component.selectedCompareOption.val;
				delete component.selectedCompareOption;
			} else {
				switch (compareParams.timeGroup.toLowerCase()) {
				case "hh":
					compareParams.timeSpan = 12;
					break;
				case "day":
					compareParams.timeSpan = 7;
					break;
				case "week":
					compareParams.timeSpan = 7;
					break;
				case "month":
					compareParams.timeSpan = 6;
					break;
				case "year":
					compareParams.timeSpan = 1;
					break;
				}
			}
		}
		return compareParams;
	}

	dsUtil.initChartparams = function(component, isExport) {
		var groupByFieldsList = [], valueFieldsList = [], orderByClause = "", orderByColumns = [], grouping = "", grouping2 = "", timeField, timeGroup, binCount, binWidth = "", bin, pageSize;

		if (component.isGroupBy == undefined) {
			for (var i = 0; i < component.measureDataField.length; i++) {
				if (component.measureDataField[i].aggrType != 'None') {
					component.isGroupBy = true;
					break;
				}
			}
		}

		if (component.isTimeGrouping == true) {
			var dimension = component.dimensionDataField[0];
			switch (dimension.timeGrouping) {
			case "auto":
				grouping = "auto";
				break;
			case "Hourly":
				grouping = "HH";
				break;
			case "Daily":
				grouping = "DAY";
				break;
			case "Weekly":
				grouping = "WEEK";
				break;
			case "Monthly":
				grouping = "MONTH";
				break;
			case "Yearly":
				grouping = "YEAR";
				break;
			default:
				grouping = "AUTO";
			}
		}

		var compareParams = dsUtil.getCompareParams(component, grouping);

		for ( var key in component.dimensionDataField) {
			var dimension = component.dimensionDataField[key];
			// no need of grouping on dimension when there is no aggregation done;
			var aliasName = dimension.column;
			if (isExport && component.xAxisTitle && component.xAxisTitle.text && key == 0) {
				aliasName = component.xAxisTitle.text;
			}
			if (component.chartType !== 'TimeSeries' && key == 0 && !dimension.numPointsToDisplay.includeAll &&
					dimension.numPointsToDisplay.maxPoints) {
				pageSize = dimension.numPointsToDisplay.maxPoints;
			} else {
				pageSize = -1; // exisitng time series have maxPoints hard coded to 15. For TimeSeries chart we need to include all values.
			}

			if (key == 0 && component.isTimeGrouping == true) {
				groupByFieldsList.push("[" + dimension.column + "]");
				timeField = dimension.column;
				aliasName = dimension.column; // we don't need to alias in export for time line chart as the time line calculation is failing fail.
				timeGroup = grouping;
				if (dimension.column !== aliasName) {
					valueFieldsList.push("[" + dimension.column + "] AS [" + aliasName + "]");
				} else {
					valueFieldsList.push("[" + dimension.column + "]");
				}

			} else {
				if (component.isGroupBy || !component.measureDataField || component.measureDataField.length == 0) {
					groupByFieldsList.push("[" + dimension.column + "]");
				}

				if (dimension.column !== aliasName) {
					valueFieldsList.push("[" + dimension.column + "]" + " AS [" + aliasName + "]");
				} else {
					valueFieldsList.push("[" + dimension.column + "]");
				}
			}

			if (dimension.customGroupsAvailable && dimension.groups && dimension.groups.length > 0) {
				dsUtil.applyCustomGroups(dimension);
			}
		}

		var aggrColumns = dsUtil.generateAggregateColumn(component.measureDataField, component, isExport);
		for ( var k in aggrColumns.returnColumn) {
			var column = aggrColumns.returnColumn[k];
			valueFieldsList.push(column);
		}

		if (component.type == 'TABLE' && component.sorting) {
			for ( var k in component.sorting) {
				var sort = component.sorting[k];
				orderByClause = orderByClause + sort.dataField + " " + sort.direction + ",";
			}
		} else if ((component.type == 'CHART' || component.type == 'FACET') && component.sorting) {
			if (component.isTimeGrouping == true) {
				var dimension = component.dimensionDataField[0];
				var sorting = component.sorting[0];
				orderByClause += "[" + dimension.column + "] " + sorting.direction;
			} else {
				var sorting = component.sorting[0];
				if (sorting.sortAxis != 'None') {
					if (sorting.columnId) {
						orderByClause = orderByClause + "[" + sorting.columnId + "] " + sorting.direction;
					} else if (sorting.sortAxis == 'XAxis') {
						orderByClause = orderByClause + "[" + component.dimensionDataField[0].column + "] " +
								sorting.direction;
					} else {
						for ( var k in aggrColumns.orderBycolumn) {
							var col = aggrColumns.orderBycolumn[k];
							orderByClause = orderByClause + col.name + ",";
						}
						orderByClause = orderByClause.substr(0, orderByClause.lastIndexOf(",")) + " " +
								sorting.direction;
					}
				}
			}

			if (component.chartType === 'Histogram') {
				if (component.binType === 'FIXEDBINCOUNT') {
					binCount = component.binValues[0].value;
				} else if (component.binType === 'FIXEDBINWIDTH') {
					var unit = component.binValues[0].unit;
					binWidth = binWidth + component.binValues[0].value + component.binValues[0].unit;
				} else if (component.binType === 'VARIABLEBINWIDTH') {
					bin = "";
					for ( var x in component.binValues) {
						var opt = component.binValues[x];
						bin = bin + opt.value + opt.unit + ",";
					}
					if (bin) {
						bin = bin.substr(0, bin.lastIndexOf(","));
					}
				} else if (component.binType === 'CUSTOMBINWIDTH') {
					bin = customReportHolder.evalExpression(component.customWidthExpression);
				}
			}
		}
		dsUtil.params.fields = valueFieldsList.join(",");
		dsUtil.params.groupby = groupByFieldsList.join(",");
		dsUtil.params.orderby = orderByClause;
		dsUtil.params.limit = pageSize;
		dsUtil.params.timeGroup = timeGroup;
		dsUtil.params.timeField = timeField;
		dsUtil.params.binCount = binCount;
		dsUtil.params.binWidth = binWidth;
		dsUtil.params.bin = bin;
		dsUtil.params.limit = pageSize;
		dsUtil.params.includeOther = component.showOthers;

		if (compareParams) {
			dsUtil.params.timeGroup = compareParams.timeGroup;
			dsUtil.params.timeSpan = compareParams.timeSpan;
		}

	}

	dsUtil.applyCustomGroups = function(dimension) {
		var cgString;
		for (var i = 0; i < dimension.groups.length; i++) {
			if (!cgString) {
				cgString = {
					groups : {},
					ungrouped : dimension.includeUngrouped === true ? "Include" : "Exclude",
					includeMissingGroups : dimension.includeMissingGroups
				};
			}
			cgString.groups[dimension.groups[i]["groupName"]] = dimension.groups[i]["groupValues"];
		}
		if (cgString) {
			dsUtil.params["customgroups." + dimension.column] = JSON.stringify(cgString);
		}
	}

	dsUtil.generateAggregateColumn = function(columns, component, isExport) {
		var isGroupBy = component.isGroupBy;
		var returnColumns = [];
		var aliasColumns = [];
		for ( var k in columns) {
			var columnField = columns[k];
			var aliasColumn = {};

			aliasColumn.sortOrder = columnField.sortOrder;
			aliasColumn.name = "[" + columnField.column + "]";
			var returnColumn = "[" + columnField.column + "]";

			if (isExport && columns.length == 1 && component.yAxisTitle && component.yAxisTitle.text) {
				aliasColumn.name = "[" + component.yAxisTitle.text + "]";
			}else if(isExport){
				aliasColumn.name = "[" + columnField.aggrType + "_" + columnField.column + "]";
			}

			if (columnField.aggrType !== 'None') {
				if (!isExport) {
					aliasColumn.name = "[" + columnField.aggrType + "_" + columnField.column + "]";
				}

				if (columnField.aggrType === 'CountDistinct') {
					returnColumn = "count (distinct([" + columnField.column + "])) AS " + aliasColumn.name;
				} else if (columnField.aggrType === 'Count') {
					returnColumn = columnField.aggrType + "(IFNULL([" + columnField.column + "], '')) AS " +
							aliasColumn.name;
				} else {
					var defaultValue = columnField.showNumberOps ? -1 : "''";
					defaultValue = columnField.type === 'String' ? "''" : defaultValue;
					if(dsUtil.supportNullValues(component)){
						returnColumn = columnField.aggrType + "([" + columnField.column + "]) AS " + aliasColumn.name;
					}else{
						returnColumn = columnField.aggrType + "(IFNULL([" + columnField.column + "], " + defaultValue + ")) AS " + aliasColumn.name;
					}
				}

			} else {

				/*
				 * there is no aggregate type for column and groupby is true , means there is aggregation on
				 * other columns that mean we have assume a default aggregation to the column which is Sum for
				 * number and Count for all other types
				 */
				if (isGroupBy) {
					if (columnField.showNumberOps) {
						aliasColumn.name = "[Sum_" + columnField.column + "]";
						returnColumn = "Sum(IFNULL([" + columnField.column + "], -1)) AS " + aliasColumn.name;
						columnField.aggrType = "Sum";
					} else {
						aliasColumn.name = "[Count_" + columnField.column + "]";
						returnColumn = "Count(IFNULL([" + columnField.column + "], '')) AS " + aliasColumn.name;
						columnField.aggrType = "Count";
					}
				} else {
					returnColumn = "[" + columnField.column + "] AS " + aliasColumn.name;
				}
			}

			returnColumns.push(returnColumn);
			aliasColumns.push(aliasColumn);
		}
		return {
			returnColumn : returnColumns,
			orderBycolumn : aliasColumns
		};
	};

	dsUtil.applyInputsToDataSet = function(dataSet, inputs, builderVersion, urlParams) {
		var parametersList = [];
		if (inputs && inputs.length > 0) {
			if (dataSet && dataSet.GetOperation && dataSet.GetOperation.parameters &&
					dataSet.GetOperation.parameters.length > 0) {
				angular.copy(dataSet.GetOperation.parameters, parametersList);
				for ( var k in parametersList) {
					var parameter = parametersList[k];
					if (parameter.values) {
						var value = parameter.values[0];
						parameter.values = [];
						if (value.indexOf("=input.") != -1) {
							for ( var i in inputs) {
								var input = inputs[i];
								if (value == "=input." + input.id) {
									if (input.controlType === 'CheckBox' || input.controlType === 'ListBox' ||
											input.allowMultipleSelection) {
										if (builderVersion === 1) {
											parameter.values = input.selectedValues;
										} else {
											if (input.allSelected && !input.required) {
												parameter.values = undefined;
											} else {
												parameter.values = input.selectedValues;
											}
										}
									} else {
										parameter.values.push(input.value);
									}
								}
							}
						} else {
							parameter.values.push(value);
						}
					}

				}
			}

			for ( var i in inputs) {
				var input = inputs[i];
				if (input.type === "Commcell") {
					var parameter = {
						name : "datasource",
						required : true
					};
					if (input.allowMultipleSelection) {
						parameter.values = input.selectedValues;
						parameter.isList = true;
					} else {
						if (input.controlType === 'CheckBox' || input.controlType === 'ListBox') {
							if (input.selectedValues[0]) {
								parameter.values = [ input.selectedValues[0] ];
							}
						} else {
							if (input.value) {
								parameter.values = [ input.value ];
							}
						}
					}
					parametersList.push(parameter);
				}
			}
		}

		for ( var i in parametersList) {
			var parameter = parametersList[i];
			var pretext = parameter.name === "datasource" ? "" : "parameter.";
			if (parameter.values) {
				var key = "parameter." + parameter.name;
				if (parameter.isList) {
					dsUtil.params[key] = parameter.values;
				} else {
					var val = parameter.values[0] + "";
					if (val !== "undefined") {
						dsUtil.params[key] = val;
					}
				}
			}
		}
		return parametersList;
	};

	dsUtil.applyInputsToDataSetV2 = function(dataSet, inputs, builderVersion, urlParams) {
		function addParameter(name,input){
			var parameter = {
					name : name,
					required : true
				};
				if (input.allowMultipleSelection) {
					parameter.values = $.isArray(input.value) ? input.value : [];
					parameter.isList = true;
				} else {
					if (input.value) {
						parameter.values = [ input.value ];
					}
				}
			return 	parameter;
		}
		var parametersList = [];
		var parameters = [];
		if (inputs && inputs.length > 0) {
			if (dataSet && dataSet.GetOperation && dataSet.GetOperation.parameters &&
					dataSet.GetOperation.parameters.length > 0) {
				angular.copy(dataSet.GetOperation.parameters, parametersList);
				for ( var k in parametersList) {
					var parameter = parametersList[k];
					if (parameter.values) {
						var value = parameter.values[0];
						parameter.values = [];
						if (value.indexOf("=input.") != -1) {
							for ( var i in inputs) {
								var input = inputs[i];
								if (value == "=input." + input.id) {
									if (input.allowMultipleSelection) {
										parameter.values = $.isArray(input.value) ? input.value : [];
									} else {
										parameter.values.push(input.value);
									}
								}
							}
						} else {
							parameter.values.push(value);
						}
					}

				}
			}

			if (dataSet && dataSet !== "CommcellList") {
				for ( var i in inputs) {
					var input = inputs[i];
					if (input.type === "Commcell") {
						parametersList.push(addParameter("datasource",input));
					}
				}
			}
		}


		if(typeof urlParams['commUniId'] !== "undefined"){
			parametersList.push(addParameter("sys_commCellId",{value:urlParams['commUniId']}));
		}

		if(typeof urlParams['ccGroupId'] !== "undefined"){
			parametersList.push(addParameter("sys_commcellGroupId",{value:urlParams['ccGroupId']}));
		}

		for ( var i in parametersList) {
			var parameter = parametersList[i];
			var pretext = parameter.name === "datasource" ? "" : "parameter.";
			if (parameter.values) {
				var key = "parameter." + parameter.name;
				if (parameter.isList) {
					if(parameter.values && parameter.values.length > 0){
						key= key+"[]";
						dsUtil.params[encodeURIComponent(key)] = parameter.values.join(",");
					}
				} else {
					var val = parameter.values[0] + "";
					if (val !== "undefined") {
						dsUtil.params[key] = val;
					}
				}
			}
		}
		return parametersList;
	};

	dsUtil.getDataSet = function(dataSetName, dataSets) {
		var dataSet = {};
		if (dataSets.length > 0) {
			for (var i = 0; i < dataSets.length; i++) {
				var dts = dataSets[i];
				if (dts.dataSet.dataSetName === dataSetName) {
					dataSet = dts;
					break;
				}
			}
		}
		return dataSet;
	};

	dsUtil.getDataSets = function(dataSet, page) {
		var dataSets = {
			dataSet : []
		};
		if (dataSet.endpoint === 'DATASET' || dataSet.endpoint === 'SCRIPT') {
			for (var i = 0; i < page.dataSets.dataSet.length; i++) {
				dataSets.dataSet.push(page.dataSets.dataSet[i]);
			}
		}
		dataSets.dataSet.push(dataSet);
		return dataSets;
	}

	dsUtil.requestToUrl = function(a1,addValAsString,addIndexBasedKeys) {
		return dsUtil.objectToUrl(a1,"",addValAsString,addIndexBasedKeys).join("&");
	}

	dsUtil.objectToUrl = function(a1, prefix,addValAsString,addIndexBasedKeys) {
		var u = [];
		var x;
		if (prefix) {
			prefix = prefix + urlParamDelimiter;
		} else {
			prefix = "";
		}
		for (x in a1) {
			if (x == 'invisible') {
				continue;
			}
			var curr = a1[x];
			if (curr === undefined || curr === '') {
				continue;
			}
			if (curr instanceof Array) {
				if(addValAsString && curr.length > 0)
					u.push(prefix + x + "=" + encodeURIComponent(JSON.stringify(curr)));
				else
					u = u.concat(dsUtil.arrayToUrl(curr, prefix + x,addIndexBasedKeys));
			} else if (curr instanceof Object) {
				if(addValAsString)
					u.push(prefix + x + "=" + encodeURIComponent(JSON.stringify(curr)));
				else
					u = u.concat(dsUtil.objectToUrl(curr, prefix + x));
			} else {
				u.push(prefix + x + "=" + encodeURIComponent(curr));
			}
		}
		return u;
	}
	dsUtil.arrayToUrl = function(curr, prefix,addIndexBasedKeys) {
		var u = [];
		var index = 0;
		for (index = 0; index < curr.length; index++) {
			var val = curr[index];
			if(addIndexBasedKeys && typeof val === "object")
				val = JSON.stringify(val);
			if (!addIndexBasedKeys && curr[index] instanceof Object) {
				u = u.concat(dsUtil.objectToUrl(curr[index], prefix));
			} else if (!addIndexBasedKeys && curr[index] instanceof Array) {
				u = u.concat(dsUtil.arrayToUrl(curr[index], prefix));
			} else {
				u.push(prefix + (addIndexBasedKeys ?  "-" + index : "") +  "=" + encodeURIComponent(val));
			}
		}
		if (prefix) {
			prefix = prefix + '=';
		}
		return u;
	}

	dsUtil.getFieldDefintion = function(fieldName, dataSet) {
		if (fieldName === "*") {
			return {
				name : "*"
			}
		}
		if (dataSet && dataSet.fields) {
			for (var i = 0; i < dataSet.fields.length; i++) {
				if (fieldName === dataSet.fields[i].name || fieldName === dataSet.fields[i].dataField) {
					return dataSet.fields[i];
				}
			}
		}
	}

	dsUtil.checkIffiltercanBeApplied = function(data, dataSet) {
		if (!data) { // inputs or clear filters does not send any data
			return true;
		}

		if (data && data.filterField && data.filterField.name === "*") {
			return true;
		}

		if (data && data.filterField && data.filterField.name !== '*') {
			var currentField = dsUtil.getFieldDefintion(data.filterField.name, dataSet);
			if (currentField && currentField.name && currentField.name === data.filterField.name &&
					currentField.type === data.filterField.type) {
				return true;
			}
		}
		return false;
	}

	return dsUtil;
})();