(function(globals) {
	var app = angular.module("reports");
	globals.customReport = {};
	globals.isReportManager = false;
	globals.globalVar = {};
	globals.globalVar.DATASET_MODE = {};
	globals.globalVar.DATASET_MODE.id = "dataSetId";
	globals.globalVar.DATASET_MODE.name = "dataSetName";
	globals.globalVar.DATASET_MODE.guid = "guid";
	globals.globalVar.dataSetMode = globals.globalVar.DATASET_MODE.id;

	var exportType = "";
	//poly fill for the phanton js issue reported here  https://github.com/angular/angular.js/issues/13794
	if (typeof Function.prototype.bind != 'function') {
		Function.prototype.bind = function bind(obj) {
			var args = Array.prototype.slice.call(arguments, 1), self = this, nop = function() {
			}, bound = function() {
				return self.apply(this instanceof nop ? this : (obj || {}), args.concat(Array.prototype.slice
						.call(arguments)));
			};
			nop.prototype = this.prototype || {};
			bound.prototype = new nop();
			return bound;
		};
	}

	app
			.service("customReportSvc",
					[
							'$sce',
							'$timeout',
							'reportService',
							'cvToaster',
							'$http',
							function($sce, $timeout, reportService, cvToaster,$http) {

								var customReportHolder = {};

								customReportHolder.sharedData = {
									callbacks : {}
								};

								/**
								 * Use this function to get query string parameters as an associative array
								 */
								customReportHolder.getUrlParams = function(url) {
									var urlParams = {};
									var defaultUrl = window.location.search.substring(1);
									if (customReports.appName === 'adminconsole' && window.location.hash.indexOf("?") > -1) {
										defaultUrl = window.location.hash
												.substring(window.location.hash.indexOf("?") + 1);
									}
									var e, a = /\+/g, // Regex for replacing addition symbol with a space
									r = /([^&=]+)=?([^&]*)/g, d = function(s) {
										return decodeURIComponent(s.replace(a, " "));
									}, q = url || defaultUrl;

									while (e = r.exec(q)) {
										urlParams[d(e[1])] = d(e[2]);
									}
									//customReportHolder.initFilterArrays(urlParams);
									return urlParams;
								};

								customReportHolder.initFilterArrays = function(filters) {
									for ( var filterParam in filters) {
										if (filterParam.indexOf(".filter.") != -1) {
											if (filterParam.indexOf("-") !== -1) {
												var key = filterParam.substring(0, filterParam.lastIndexOf("-"));
												if ($.isEmptyObject(filters[key])) {
													filters[key] = [];
												}
												filters[key].push(filters[filterParam]);
												delete filters[filterParam]; /// index-0 is causing the bookmarks to fail. Need to check with DC team to see if this is needed by them.
											}
										}
									}

									return filters;
								}

								customReportHolder.getParameter = function(name, url, defaultValue, getUrlViaHistoryJs) {
									name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
									var regexS = "[\\?&]" + name + "=([^&#]*)";
									var regex = new RegExp(regexS);
									if (typeof url === "undefined" || url === null) {
										url = window.location.href;
										/*
										 * if (!!getUrlViaHistoryJs) { // Using the History.js plugin to get
										 * the current URL: // console.debug("URL from window.location.href=" +
										 * window.location.href); // console.debug("URL from
										 * history.getState().url=" + History.getState().url); var state =
										 * History.getState(); if (typeof state !== 'undefined' && state !==
										 * null) { url = History.getState().url.replace(/&nbsp;/g, ' '); } }
										 */
									}
									var results = regex.exec(url);
									if (results === null) {
										if (typeof defaultValue !== 'undefined') {
											return defaultValue;
										} else {
											return "";
										}
									} else {
										return decodeURIComponent(results[1].replace(/\+/g, " "));
									}
								};

								customReportHolder.getParameterByName = function(name, defaultValue) {
									return customReportHolder.getParameter(name, null, defaultValue, true);
								};

								customReportHolder.generateCacheId = function(previousCacheId) {
									if (previousCacheId) {
										//clear the cache for the previous cache id.
										reportService.clearCache(previousCacheId);
									}
									return customReportHolder.generateUUID();
								};

								customReportHolder.setEnableEditModeActions = function(enabled) {
									if (enabled) {
										angular.element("#publishButton").show();
										angular.element("#publishToCloudButton").show();
										angular.element("#exportReportButton").show();
										angular.element("#exportReadMeButton").show();
										angular.element("#deployButton").show();
										angular.element("#reportButton").show();
										angular.element("#openReportButton").show();

									} else {
										angular.element("#publishButton").hide();
										angular.element("#publishToCloudButton").hide();
										angular.element("#exportReportButton").hide();
										angular.element("#exportReadMeButton").hide();
										angular.element("#deployButton").hide();
										angular.element("#reportButton").hide();
										angular.element("#openReportButton").hide();
									}
								};

								customReportHolder.isSafari = function(ua) {
									if (ua.indexOf('safari') != -1 && ua.indexOf('chrome') == -1) {
										return true;
									}

									return false;
								};

								//builder is not supported windows safari
								customReportHolder.checkBrowserCompatability = function(userAgent, isBuilder) {
									if (isBuilder && customReportHolder.isSafari(userAgent) &&
											window.navigator.appVersion.indexOf("Win") != -1) {
										//    		if ( customReportHolder.isBuilder() && window.navigator.appVersion.indexOf("Win")!=-1) {
										angular
												.element("#secTitleDiv")
												.append("<span id='builderErrorTopNote'>Safari browser is not supported for creating/editing reports.</span>");
										angular.element("#sectionTitle").css("width", "450px");
									}
								};

								customReportHolder.clearCallback = function(type) {
									if (customReportHolder.sharedData.callbacks[type]) {
										customReportHolder.sharedData.callbacks[type] = [];
									}
								};

								customReportHolder.restCallbacks = function(type) {
									customReportHolder.sharedData = {
										callbacks : {}
									};

								};

								//this will unregister any unnecessary call back once done with that. Like the preview Started call back is getting added each time the data set is opened for edit.
								customReportHolder.unRegisterCallback = function(type, cb, sourceId) {
									delete customReportHolder.sharedData.callbacks[type];
								};

								customReportHolder.unRegisterComponetCbs = function(componentId) {

									angular.forEach(customReportHolder.sharedData.callbacks, function(cbs, index) {
										for (var i = 0; i < cbs.length; i++) {
											var cb = cbs[i];
											if (cb && cb.source && componentId === cb.source) {
												delete cbs[i];
											}
										}
									});
								};

								customReportHolder.registerCallback = function(type, cb, sourceId) {
									if (!customReportHolder.sharedData.callbacks[type]) {
										customReportHolder.sharedData.callbacks[type] = [];
									}

									var callback = {};
									callback.func = cb;
									callback.source = sourceId;

									// check if callback is already registered for given sourceId
									if (sourceId) {
										var alreadyRegistered = undefined;
										angular.forEach(customReportHolder.sharedData.callbacks[type], function(
												callbackObj, index) {
											if (callbackObj.source == sourceId) {
												alreadyRegistered = callbackObj;
												return;
											}
										});
										if (!$.isEmptyObject(alreadyRegistered)) {
											return;
										}
									}
									customReportHolder.sharedData.callbacks[type].push(callback);
								};

								customReportHolder.triggerCallback = function(type, data, id, isAutoRefresh) {
									angular.forEach(customReportHolder.sharedData.callbacks[type], function(cb) {
										if (id) {
											if (cb.source && id == cb.source) {
												cb.func(data,isAutoRefresh);
											}
										} else {
											cb.func(data,isAutoRefresh);
										}

									});
								};

								customReportHolder.getDataSet = function(dataSetName, dataSets) {
									var dataSet = {};
									if (dataSets.length > 0) {
										for (var i = 0; i < dataSets.length; i++) {
											var dts = dataSets[i];
											if (dts.dataSet.dataSetName === dataSetName) {
												dataSet = dts;
												break;
											}
										}
									}
									return dataSet;
								};

								customReportHolder.getComponent = function(componentName, components, rootLevel) {
									var component;
									var panelComponent;
									var tabComponent;
									if (components.length > 0) {
										for (var i = 0; i < components.length; i++) {
											var comp = components[i];
											if (comp.id === componentName) {
												component = comp;
												break;
											}
											if (comp.type === "PANEL") {
												panelComponent = customReportHolder.getComponent(componentName,
														comp.panelComponents);
												if (panelComponent) {
													component = panelComponent;
													break;
												}

											}

											if (comp.type === "TABS") {
												for (var k = 0; k < comp.tabs.length; k++) {
													var tab = comp.tabs[k];
													if (!rootLevel) {
														tabComponent = customReportHolder.getComponent(componentName,
																tab.component.panelComponents);
														if (tabComponent) {
															break;
														}
													} else if (tab.id === componentName) {
														tabComponent = tab;
														break;
													}
												}

												if (tabComponent) {
													component = tabComponent;
													break;
												}
											}

											if (comp.type === "PANEL_HEADER") {
												component = customReportHolder.getComponent(componentName,
														comp.panelHeaderComponents);
												component = tabComponent;
												break;
											}

										}
									}
									return component;
								};

								customReportHolder.getComponentDefintion = function(comp, type, index, rows, columns) {

									if (comp.type == "CHART") {
										comp.id = "Chart_" + (new Date()).getTime();
										comp.chartType = type;
										if (type == 'TimeSeries') {
											comp.isDateTime = true;
										} else {
											comp.isDateTime = false;
										}
										customReportHolder.setDefaultChartProperties(comp);
										if (type === 'Histogram') {
											comp.binType = 'FIXEDBINCOUNT';
											comp.binValues = [ {
												value : "5",
												unit : ""
											} ];
										}
									} else if (comp.type == "TABLE") {
										comp.id = "Table" + (new Date()).getTime();
										;
										comp.pageSize = 20;
										comp.columns = [];
										comp.allColumns = false;
										customReportHolder.setDefaultTableProperties(comp);
									} else if (comp.type == "PIVOT_TABLE") {
										comp.id = "PivotTable" + (new Date()).getTime();
										;
										comp.pageSize = 20;
										comp.columns = [];
										comp.allColumns = true;
										customReportHolder.setDefaultTableProperties(comp);
									} else if (comp.type == "TAG_CLOUD") {
										comp.id = "TagCloud" + (new Date()).getTime();
										;
									} else if (comp.type == 'SEARCH_BAR') {
										comp.id = "SearchBar" + (new Date()).getTime();
										;
									} else if (comp.type == 'DATE_RANGE') {
										comp.id = "DateRange" + (new Date()).getTime();
										;
									} else if (comp.type == 'HITS') {
										comp.id = "Hits" + (new Date()).getTime();
										;
									} else if (comp.type == "HEAT_MAP") {
										comp.id = "HEATMAP_" + (new Date()).getTime();
										comp.chartType = type;
										customReportHolder.setDefaultChartProperties(comp);
									} else if (comp.type == "SCATTER") {
										comp.id = "SCATTER_" + (new Date()).getTime();
										comp.chartType = type;
										customReportHolder.setDefaultChartProperties(comp);
									} else if (comp.type === "CUSTOM") {
										comp.id = "CustomHtml" + (new Date()).getTime();
										;
										comp.columns = [];
									} else if (comp.type === "MAP") {
										comp.id = "Map" + (new Date()).getTime();
										;
										comp.columns = [];
									} else if (comp.type === "KENDO_GRID") {
										comp.id = "DataGrid_" + (new Date()).getTime();
										;
										comp.pageSize = 20;
										comp.columns = [];
										comp.allColumns = true;
									} else if (comp.type == 'FACET') {
										comp.id = "Facet" + (new Date()).getTime();
										;
										comp.allColumns = false;
									} else if (comp.type === "KENDO_TREEGRID") {
										comp.id = "TreeGrid_" + (new Date()).getTime();
										;
										comp.columns = [];
									} else if (comp.type === "PANEL_HEADER") {
										comp.id = "PanelComponent" + (new Date()).getTime();
										;
										comp.header = false;
										comp.panelHeaderComponents = [];
									} else if (comp.type === "PANEL") {
										comp.id = "Panel" + (new Date()).getTime();
										;
										comp.panelComponents = [];
									} else {
										return undefined;
									}

									return comp;
								}

								customReportHolder.getGridAttributes = function(comp, position, rows, columns,
										deviceType) {
									var gridLayoutItemAttrs = {
										mobile : {
											size : {
												x : 4,
												y : rows
											},
											position : position
										},
										tablet : {
											size : {
												x : 4,
												y : rows
											},
											position : position
										},
										desktop : {
											size : {
												x : 4,
												y : rows
											},
											position : position
										}
									};

									if (comp.type === 'TABLE' || comp.type === 'PIVOT_TABLE' ||
											comp.type === 'KENDO_GRID' || comp.type === 'KENDO_TREEGRID') {
										gridLayoutItemAttrs[deviceType].size.x = columns;
									} else if (comp.type === 'SEARCH_BAR') {
										gridLayoutItemAttrs[deviceType].size.y = 2;
									} else if (comp.type === 'DATE_RANGE') {
										gridLayoutItemAttrs[deviceType].size.x = 6;
										gridLayoutItemAttrs[deviceType].size.y = 3;
									} else if (comp.type === 'HITS') {
										gridLayoutItemAttrs[deviceType].size.x = 3;
										gridLayoutItemAttrs[deviceType].size.y = 3;
									} else if (comp.type === 'HEAT_MAP') {
										gridLayoutItemAttrs[deviceType].size.x = columns;
									} else if (comp.type === 'SCATTER') {
										gridLayoutItemAttrs[deviceType].size.x = columns;
									} else if (comp.type === 'CHART') {
										if (comp.chartType === 'Line' || comp.chartType === 'TimeSeries') {
											gridLayoutItemAttrs[deviceType].size.x = columns;
										}
									} else if (comp.type === 'PANEL') {
										gridLayoutItemAttrs[deviceType].size.x = columns;
									}

									return gridLayoutItemAttrs;
								}

								customReportHolder.calculateItemPosition = function(event) {
									// calculate row and column to place new item
									// get position of dragged item
									var srcTop = event.originalEvent.pageY - $(".gridster").offset().top + 20; // 20 px for top padding and margin
									var srcLeft = event.originalEvent.pageX - $(".gridster").offset().left;

									// get row height and col width of gridster item
									var rowHeight = $scope.gridsterOpts.rowHeight;
									var colWidth = $(".gridster").width() / $scope.gridsterOpts.columns;

									// calculate rows and cols
									var row = srcTop < rowHeight ? 0 : Math.ceil(srcTop / rowHeight);
									var column = srcLeft < colWidth ? 0 : Math.ceil(srcLeft / colWidth);
									return [ row, column ];
								}

								customReportHolder.getCustomReportObject = function() {
									return customReportHolder.customReport;
								};

								customReportHolder.deserializePagesAndSetCrObject = function(cr) {
									angular.forEach(cr.pages, function(page) {
										if (page.body) {
											page.body = JSON.parse(page.body);
										}
										//										if (page.headerComponents) {
										//											page.headerComponents = JSON.parse(page.headerComponents);
										//										}
									});
									return cr;
								}
								customReportHolder.setCustomReportObject = function(cr, reloadComponent) {
									customReportHolder.deserializePagesAndSetCrObject(cr);
									customReportHolder.setCustomReportTranslationObject(cr.translations);
									if (globals.customReport === "undefined" || globals.customReport === null) {
										globals.customReport = {};
									}

									globals.customReport.reportId = cr.report.customReportId;
									globals.customReport.reportName = cr.report.customReportName;
									cr.reloadComponent = reloadComponent;
									customReportHolder.triggerCallback("crChangeCallBacks", cr);
								};

								/*
								 * customReportHolder.setCustomReportTranslationObject =
								 * function(translations) { customReportHolder.customReport.translations =
								 * translations; customReportHolder.loadTranslations(translations, false);
								 * customReportHolder.triggerCallback("translationsChangeCallBacks",
								 * translations); };
								 */

								customReportHolder.resetToDefault = function(component) {
									customReportHolder.triggerCallback("resetPropStartedCallbacks", component);
									if (component.type == "CHART") {
										customReportHolder.setDefaultChartProperties(component, true);
									} else if (component.type == "TABLE") {
										customReportHolder.setDefaultTableProperties(component, true);
									}

									customReportHolder.triggerCallback("resetPropCompletedCallbacks", component);
								};

								customReportHolder.mask = function(div, isId, message) {
									var preFix = isId == true ? "#" : ".";
									$(preFix + div).mask(message);
								}

								customReportHolder.unMask = function(div, isId) {
									var preFix = isId == true ? "#" : ".";
									$(preFix + div).unmask();
								}

								customReportHolder.setDefaultChartProperties = function(component, isReset) {
									component.xAxisTitle = {};
									component.yAxisTitle = {};
									component.barWidthAutoOnly = false;
									component.dataSeries = [];
									component.isGrouped = false;
									//			component.isDateTime = false;
									customReportHolder.setDefaultStyles(component, isReset);
									component.sorting = [];
									if (component.chartType === 'TimeSeries') {
										component.sorting.push({
											direction : 'Asc',
											sortAxis : 'XAxis'
										});
									} else if (component.chartType === 'Line') {// || component.chartType === 'VerticalBar') {
										component.sorting.push({
											direction : 'Desc',
											sortAxis : 'XAxis'
										});
									} else {
										component.sorting.push({
											direction : 'Desc',
											sortAxis : 'YAxis'
										});
									}

									if (component.dimensionDataField) {
										angular.forEach(component.dimensionDataField, function(field, index) {
											if (!field.numPointsToDisplay) {
												field.numPointsToDisplay = {};
											}
											if (index == 0 && component.chartType !== 'TimeSeries') { // for dimension 1 we don't need to set this value as we include all the values.
												field.numPointsToDisplay.maxPoints = 15;
											} else {
												field.numPointsToDisplay.maxPoints = 10;
											}
										});
									}

									if (component.measureDataField) {
										angular.forEach(component.measureDataField, function(measure) {
											if (measure.aggrType != undefined) {
												measure.aggrType = 'Count';
											}
										});
									}

									component.seriesFormatting = [];

								};

								customReportHolder.setDefaultStyles = function(component, isReset) {
									var styles;
									if (component.styles == undefined) {
										styles = {};
										component.styles = styles;
									} else {
										styles = component.styles;
									}

									//			component.rotateXAxisLabels = false;
									if (isReset) {
										if (component.type == "CHART") {
											styles.defaultChartHeight = component.chartType == 'HorizontalBar' ? ""
													: 350;
											styles.defaultChartWidth = 1000;
											//styles.defaultBarSize = 20;
											styles.height = styles.defaultChartHeight;
											styles.width = styles.defaultChartWidth;
											//styles.barSize=styles.defaultBarSize;
											styles.barColor = customReportHolder.defaultMultiChartColors[0];
										}
									} else {
										if (component.type == "CHART") {
											styles.defaultChartHeight = component.chartType == 'HorizontalBar' ? ""
													: 350;
											styles.defaultChartWidth = 1000;
											//styles.defaultBarSize = 20;
											styles.height = styles.height == undefined ? styles.defaultChartHeight
													: styles.height;
											styles.width = styles.width == undefined ? styles.defaultChartWidth
													: styles.width;
											//					styles.background= styles.background || "#FFFFFF";
											//styles.barSize= styles.barSize || styles.defaultBarSize;
											styles.barColor = styles.barColor ||
													customReportHolder.defaultMultiChartColors[0];
										}
									}
									if (component.styles.chartPlotOptions === undefined) {
										component.styles.chartPlotOptions = {};
									}

									if (component.styles.chartPlotOptions.isShowGridlines == undefined) {
										if (component.chartType === 'TimeSeries' || component.chartType === 'treemap') {
											component.styles.chartPlotOptions.isShowGridlines = false;
										} else {
											component.styles.chartPlotOptions.isShowGridlines = true;
										}
									}

									if (component.styles.chartPlotOptions.isSmoothLines == undefined) {
										component.styles.chartPlotOptions.isSmoothLines = true;
									}

									if (component.styles.chartPlotOptions.isShowLineMarkers == undefined) {
										component.styles.chartPlotOptions.isShowLineMarkers = true;
									}

									if (component.styles.chartPlotOptions.autoConvertYValues == undefined) {
										component.styles.chartPlotOptions.autoConvertYValues = true;
									}

									if (component.styles.chartPlotOptions.isShowLabels == undefined) {
										component.styles.chartPlotOptions.isShowLabels = (component.chartType === 'heatmap' || component.chartType === 'treemap') ? true
												: false;
									}

									if (component.styles.chartPlotOptions.legendPosition == undefined) {
										component.styles.chartPlotOptions.legendPosition = "right";
										// if(component.chartType == 'Donut') {	// setting default values for donut chart in reportChartCtrl itself
										// 	if(!component.styles.chartPlotOptions.innerWidth)
										// 		component.styles.chartPlotOptions.innerWidth = "60";
										// 	if(!component.styles.chartPlotOptions.startAngle)
										// 		component.styles.chartPlotOptions.startAngle = "-150";
									}

									// 	if(!component.styles.chartPlotOptions.endAngle)
									// 		component.styles.chartPlotOptions.endAngle = "150";
									// }
								};

								customReportHolder.setDefaultTableProperties = function(component, isReset) {
									component.dataSetName = "";
									customReportHolder.setDefaultStyles(component, isReset);
								};

								customReportHolder.addCustomSeriesColor = function(component) {
									if (component.currDataSeries == undefined || component.currDataSeries.length == 0) {
										return;
									}

									var count = component.dataSeries.length;
									var series = {};
									series.value = component.currDataSeries[count].value;
									series.color = component.currDataSeries[count].color;
									series.autoColor = true;

									customReportHolder.triggerCallback("componentUpdateStartedCallbacks", component);
									if (component.dataSeries == undefined) {
										component.dataSeries = [];
									}
									component.dataSeries.push(series);
									customReportHolder.triggerCallback("componentUpdateCompletedCallbacks", component);
								};

								customReportHolder.setCurrentSeries = function(component, currSeries) {
									component.currDataSeries = currSeries;
								};

								customReportHolder.getColumnDefByName = function(name, columns) {
									var col = undefined;
									angular.forEach(columns, function(column) {
										if (column.id.toLowerCase() == name.toLowerCase()) {
											col = column;
										}
									});

									return col;
								}

								customReportHolder.getActualHiddenColumns = function(component) {
									var actualHiddenColumns = [];
									angular.forEach(component.columns, function(column) {
										if (column.dataField.indexOf("_ActualHidden") != -1) {
											actualHiddenColumns.push(column.dataField);
										}
									});
									return actualHiddenColumns;
								}

								customReportHolder.processFilterClause = function(whereClause) {
									var andLastIndex = whereClause.lastIndexOf("and");
									var orLastIndex = whereClause.lastIndexOf("or");
									var index = Math.max(andLastIndex, orLastIndex);
									if (index != -1) {
										whereClause = whereClause.substring(0, index);
									}

									return whereClause;
								}

								customReportHolder.processFilters = function(urlParams, params, isExport, component,
										reportComponents, rawData) {
									var column, value, sourceComp, filters = {}, where = [], filter = [], havingClause = [];
									for (var key in urlParams) {
										if (key.indexOf(".filter.") != -1) {
											value = urlParams[key];
											var comp = key.substring(0, key.indexOf('.')); // get the component name from the key
											sourceComp = dataSetUtility.getComponent(comp, reportComponents);

											if (sourceComp.dataSet.dataSetName !== component.dataSet.dataSetName) {
												continue; // do not add thefilter if the source component data set and the other component data set do not match.
											}

											var isSameComponent = key.indexOf(component.id) === 0 ? true : false;
											var col = decodeURIComponent(key.substring(key.indexOf(".filter.") + 8,
													key.length));
											if (!filters[comp]) {
												filters[comp] = [];
											}
											var condition = "";

											if (sourceComp.type === "TABLE" || sourceComp.type === "PIVOT_TABLE") {
												column = customReportHolder.getColumnDefByName(col, component.columns);
												if (column) {
													var aliasName = column.dataField;
													condition = customReportHolder.getNewFilter(value,
															aliasName,
															column.type);
													if (sourceComp.type == "PIVOT_TABLE" &&
															component.id === sourceComp.id) {
														filter.push(condition);
													} else {
														if (component.id === sourceComp.id &&
																component.id === sourceComp.id) {
															if (column.aggrType !== "None") {
																aliasName = isExport ? column.displayName : column.id;
																var aggrfilterColumn = column.aggrType + "([" +
																		column.dataField + "])";
																if (column.aggrType == "CountDistinct") {
																	aggrfilterColumn = "count (distinct([" +
																			column.dataField + "]))";
																}
																condition = customReportHolder.getNewFilter(value,
																		aggrfilterColumn,
																		column.type,
																		true);
																havingClause.push(condition);
															} else {
																where.push(condition);
															}
														}
													}
												}
											} else if (sourceComp.type === "SEARCH_BAR") {
												var column;
												var type = "string";
												if (col !== "*") { // we dont need to check for types for *.
													if (sourceComp.searchFields) {
														for (var i = 0; i < sourceComp.searchFields.length; i++) {
															var field = sourceComp.searchFields[i];
															if (field.column === col) {
																column = field.column;
																if (field.dataType) {
																	type = field.dataType;
																}
																break;
															}
														}
													}
												}
												condition = customReportHolder.getNewFilter(value, col, type);
												filters[comp].push(condition);
											} else if (sourceComp.type === "CHART" || sourceComp.type === "HEAT_MAP" ||
													sourceComp.type === "FACET") {
												//Adding FACET case because only then the square brackets are not added to the whereClause
												if (component.id !== sourceComp.id) {
													var values = JSON.parse(value);
													for ( var i in values) {
														var currentValue = values[i];
														var isRemaining = false;
														var newCondition;
														if (currentValue instanceof Object) {
															condition = " (";
															for ( var x in currentValue) {
																col = x;
																value = currentValue[x];
																newCondition = customReportHolder
																		.getChartFilterCondition(col, value, sourceComp);
																if (condition.indexOf(newCondition) === -1) {
																	condition = condition + newCondition + ' and ';
																}
															}
															condition = customReportHolder
																	.processFilterClause(condition);
															condition = condition + ") or ";

														} else {
															newCondition = customReportHolder
																	.getChartFilterCondition(col,
																			currentValue,
																			sourceComp);
															if (condition.indexOf(newCondition) === -1) {
																condition = condition + newCondition + ' or ';
															}
														}

													}
													condition = customReportHolder.processFilterClause(condition);
													filters[comp].push(condition);
												}
											} else if (sourceComp.type === "DATE_RANGE") {
												condition = customReportHolder.getNewFilter(value,
														col,
														sourceComp.dateRangeType);
												filters[comp].push(condition);
											} else {
												condition = customReportHolder.getNewFilter(value, col);
												filters[comp].push(condition);
											}

										}
									}

									for ( var componentName in filters) {
										if (component.type === "CHART" && component.id === componentName) {
											delete filters[componentName]; // do not apply current filters on the same source component
										} else {
											if (filters[componentName]) {
												$.merge(where, filters[componentName]);
											}
										}
									}

									params.whereClause = isExport ? where : JSON.stringify(where);
									params.havingClause = isExport ? havingClause : JSON.stringify(havingClause);
									params.filter = isExport ? filter : JSON.stringify(filter);

								}

								customReportHolder.getChartFilterCondition = function(col, currentValue, sourceComp) {
									var remainingValues = [];
									var isRemaining = false;
									for (var k = 0; k < sourceComp.dimensionDataField.length; k++) {
										var dimension = sourceComp.dimensionDataField[k];
										if (dimension.customGroupsAvailable && dimension.groups &&
												dimension.groups.length > 0) {
											for (var i = 0; i < dimension.groups.length; i++) {
												var value = dimension.groups[i]['groupValues'];
												remainingValues.push(value);
												if (currentValue === dimension.groups[i]['groupName']) {
													if (value === "*") {
														isRemaining = true;
													} else {
														currentValue = dimension.groups[i]['groupValues'];
													}
												}
											}
										}
									}

									var cond = '=';
									if (isRemaining) {
										currentValue = remainingValues.join(",");
										cond = '!=';
									}

									return customReportHolder.getNewFilter(currentValue, col, undefined, false, cond);
								}

								customReportHolder.getNewFilter = function(value, col, type, doNotAddBrackets,
										condition) {
									if (value && (typeof value === 'string' || value instanceof String) &&
											value.indexOf(",") != -1) {
										value = value.replace(',', '\\,')
									}
									var operator = type && type.toLowerCase() === "string" ? "contains" : "";
									if (col === "*" && !type) {
										operator = "contains";
									}
									if (!condition) {
										condition = "=";
									}
									if (!doNotAddBrackets) {
										col = "[" + col + "]"; // columns having aggreagtion should not have square brackets.
									}
									var funcExpression = "_expr";
									if (type && type.toLowerCase() === "string") {
										funcExpression = "_exprString";
										value = value.replace(/"/g, '""');
									} else if (type &&
											[ "double", "float", "integer", "long", "short" ].indexOf(type
													.toLowerCase()) !== -1) {
										funcExpression = "_exprInt";
									} else if (type && [ "timestamp", "date" ].indexOf(type.toLowerCase()) !== -1) {
										funcExpression = "_exprDateTime";
									}
									var expression = col + ' ' + condition + ' ' + funcExpression + '("' + value + '")';
									if (operator) {
										expression = col + ' ' + condition + ' ' + funcExpression + ' ("' + value +
												'","' + operator + '")'
									}
									return expression;
								}

								customReportHolder.processSort = function(sortArr, options, isExport, component) {
									options.orderByClause = "";
									var actualHiddenColumns = customReportHolder.getActualHiddenColumns(component);
									angular.forEach(sortArr, function(sObj) {
										var column = customReportHolder.getColumnDefByName(sObj.columnId,
												component.columns);
										if (column) {
											var orderBy = isExport ? customReportHolder
													.getLocalizedTitle(column.displayName) : sObj.columnId;
											if (component.allColumns) {
												orderBy = column.dataField;
											}
											var index = actualHiddenColumns
													.indexOf(column.dataField.replace(/ /g, "_") + "_ActualHidden");
											if (index != -1) {
												orderBy = actualHiddenColumns[index];
											}
											options.orderByClause = options.orderByClause + " [" + orderBy + "] " +
													sObj.direction;
										}
									});
								}

								customReportHolder.getUrlOptions = function(componentId, urlParams) {
									var sortingArr = [], filterArr = [], urlOptions = {}, columnId = "";
									if (urlParams) {
										// iterate through all parameters and find the keys that have the component id.
										angular.forEach(urlParams, function(param, key) {
											if (key.indexOf(componentId) == 0) { // if key starts with the comnponent id
												var type = key.substring(key.indexOf("."), key.length);
												if (type === ".sort") {
													var sorts = param.split(",");
													angular.forEach(sorts, function(sort) {
														sortingArr.push({
															columnId : sort.indexOf("-") == 0 ? sort.substring(1,
																	sort.length) : sort,
															direction : sort.indexOf("-") === 0 ? "desc" : "asc"
														});
													});
												} else if (type.indexOf(".filter.") != -1) {
													filterArr.push({
														columnId : decodeURIComponent(key.substring(key
																.indexOf(".filter.") + 8, key.length)),
														fValue : param
													});
												}
											}
										});
									}
									if (!$.isEmptyObject(filterArr)) {
										urlOptions["filters"] = filterArr;
									}
									if (!$.isEmptyObject(sortingArr)) {
										urlOptions["sorting"] = sortingArr;
									}
									return urlOptions;
								}

								customReportHolder.readUrlOptions = function(component, options, isExport, urlParams) {
									var urlOptions = customReportHolder.getUrlOptions(component.id, urlParams);
									if (urlOptions.hasOwnProperty("sorting")) {
										customReportHolder
												.processSort(urlOptions.sorting, options, isExport, component);
									}
									return options;
								}

								customReportHolder.getDataSetOptions = function(component, isExport, urlParams) {
									var options = {
										"pageSize" : component.pageSize,
										"orderByClause" : "",
										"includeOther" : component.showOthers,
										"includeOther" : component.showOthers,
										whereClause : [],
										havingClause : [],
										filter : [],
										valueFieldsList : [],
										groupByFieldsList : []
									};
									var fields = {};
									if (component.type == "CHART" || component.type === "HITS" ||
											component.type === "HEAT_MAP" || component.type === "FACET") {
										//Adding FACET case for dropped comes here for query formation
										//Chart and facet almost has same result count.
										fields = customReportHolder.getChartValueFields(component, isExport);
										options.pageSize = fields.pageSize;
									} else if (component.type == "PIVOT_TABLE") {
										fields = customReportHolder.getPivotTableFields(component, isExport);
									} else if (component.type == "TABLE") {
										fields = customReportHolder.getTableValueFields(component, isExport);
									} else if (component.type == "MAP") {
										//
										fields = customReportHolder.getTableValueFields(component, isExport)
										fields.valueFieldsList.push(component.latitude.name);
										fields.valueFieldsList.push(component.longitude.name);
									} else if (component.type == "SCATTER") {
										fields = customReportHolder.getTableValueFields(component, isExport);
										fields.valueFieldsList.push("[" + component.scatterX.name + "]");
										fields.valueFieldsList.push("[" + component.scatterY.name + "]");
										fields.valueFieldsList.push("[" + component.scatterLabel.name + "]");
									} else {
										fields = customReportHolder.getTableValueFields(component, isExport);
									}

									if (component.type != "PIVOT_TABLE" && component.type != "HEAT_MAP") {
										options.valueFieldsList = fields.valueFieldsList;
										options.groupByFieldsList = fields.groupByFieldsList;
										options.orderByClause = fields.orderByClause;
										options.timeField = fields.timeField;
										options.timeGroup = fields.timeGroup;
										options.binCount = fields.binCount;
										options.binWidth = fields.binWidth;
										options.bin = fields.bin;
									} else {
										$.extend(options, fields);
									}

									if (component.type != "CHART") {
										options = customReportHolder.readUrlOptions(component,
												options,
												isExport,
												urlParams);
									}

									return options;
								}

								customReportHolder.applyInputsToDataSet = function(dataSet, inputs, builderVersion) {
									var parametersList = [];
									if (inputs && inputs.length > 0) {
										if (dataSet && dataSet.GetOperation && dataSet.GetOperation.parameters &&
												dataSet.GetOperation.parameters.length > 0) {
											angular.copy(dataSet.GetOperation.parameters, parametersList);
											angular.forEach(parametersList, function(parameter) {
												if (parameter.values) {
													var value = parameter.values[0];
													parameter.values = [];
													if (value.indexOf("=input.") != -1) {
														angular.forEach(inputs, function(input) {
															if (value == "=input." + input.id) {
																parameter.inputId = input.id;
																if (input.controlType === 'CheckBox' ||
																		input.controlType === 'ListBox' ||
																		input.allowMultipleSelection) {
																	if (builderVersion === 1) {
																		parameter.values = input.selectedValues;
																	} else {
																		if (input.allSelected && !input.required) {
																			parameter.values = undefined;
																		} else {
																			parameter.values = input.selectedValues;
																		}
																	}
																} else if (dataSet.endpoint === "DATACUBE" &&
																		input.controlType === "Slider") {
																	parameter.values = ">=" + input.value;
																} else {
																	parameter.values.push(input.value);
																}
															}
														});
													} else {
														parameter.values.push(value);
													}
												}

											});
										}

										angular.forEach(inputs, function(input, i) {
											if (input.type === "Commcell") {
												var parameter = {
													name : "datasource",
													required : true
												};
												if (input.allowMultipleSelection) {
													parameter.values = input.selectedValues;
												} else {
													if (input.controlType === 'CheckBox' ||
															input.controlType === 'ListBox') {
														if (input.selectedValues[0]) {
															parameter.values = [ input.selectedValues[0] ];
														}
													} else {
														if (input.value) {
															parameter.values = [ input.value ];
														}
													}
												}
												parametersList.push(parameter);
											}
										});
									}
									/*var cn = customReportHolder.getParameterByName("_cn");
									var cnarrString = ""
									if (cn) {
										var cnarr = cn.split(",");
										cnarrString = "[";
										var i = 0
										for (; i < cnarr.length - 1; i++) {
											cnarrString += '\"' + cnarr[i] + '\",';
										}
										cnarrString += '\"' + cnarr[i] + '\"]';
									}
									if (cnarrString) {
										var parameter = {
											name : "datasource",
											required : true,
											values : JSON.parse(cnarrString)
										//											values : cn
										};
										parametersList.push(parameter);
									}*/
									return parametersList;
								};

								customReportHolder.applyInputsToDataSets = function(builderVersion) {
									var inputs = customReportHolder.sharedData.currentPage.inputs;
									var dataSets = [];
									angular.copy(customReportHolder.sharedData.currentPage.dataSets.dataSet, dataSets);
									if (inputs) {
										angular.forEach(dataSets, function(dataSet) {
											dataSet.GetOperation.parameters = customReportHolder
													.applyInputsToDataSet(dataSet, inputs, builderVersion);
										});
									}
									return dataSets;
								};

								//TODO: this has to be generalized later
								customReportHolder.applyParamsToDCubeDataSet = function(dataSet, params) {
									function _recurseAndReplace(obj, paramKey, paramVal) {
										$.each(obj, function(key, o) {
											if (typeof o === 'object') {
												_recurseAndReplace(o, paramKey, paramVal);
											} else if (o === "@" + paramKey) {
												obj[key] = paramVal;
												return false;
											}
										});
									}
									;
									angular.forEach(params, function(param) {
										_recurseAndReplace(dataSet.dCubeDataSet,
												param.name,
												param.values ? param.values[0] : undefined);
									});
								};

								customReportHolder.initUrlParams = function() {
									var urlParams = customReportHolder.getUrlParams();
									angular.forEach(urlParams, function(value, name) {
										customReportHolder.sharedData.requestString[name] = value;
									});

								}
								customReportHolder.updateUrlParams = function(isReplace) {
									var url = requestToUrl(customReportHolder.sharedData.requestString);
									history.replaceState(null, document.title, "?" + url);
								}

								customReportHolder.getHeatMapFields = function(component, isExport) {
								};

								customReportHolder.getPivotTableFields = function(component, isExport) {
									if (!component.pivotRow) {
										return;
									}

									var pivotOrderBy;
									var pivotRow = "[" + component.pivotRow.column + "]";
									var pivotRowTitle = component.pivotRow.title.text;
									var pivotGroupByList = [];
									var pivotFields = [];
									var colIdToDataFieldMap = {};
									var orderByClause = "";//default sorting defined at the component level.
									pivotGroupByList.push(pivotRow);
									if (component.pivotRow.title && component.pivotRow.title.text &&
											component.pivotRow.column !== component.pivotRow.title.text) {
										pivotRow = pivotRow + " AS [" + pivotRowTitle + "]";
									}

									var pivotColumn = "[" + component.pivotColumn.column + "]";
									pivotGroupByList.push(pivotColumn);
									var pivotCell = component.pivotCell.column;

									var aggrType = component.pivotCell.aggrType;
									var aliasColumn = "[" + component.pivotCell.column + " " + aggrType + "]";
									if (aggrType && aggrType != "None") {
										if (aggrType == 'CountDistinct') {
											pivotCell = "count (distinct([" + pivotCell + "])) AS " + aliasColumn;
										} else {
											pivotCell = aggrType + "(IFNULL([" + pivotCell + "],0)) AS " + aliasColumn;
										}
									}

									angular.forEach(component.columns, function(column) {
										var colToAdd = column.dataField;
										colIdToDataFieldMap[column.id] = colToAdd;

										var field = "[" + column.dataField + "]";
										var aliasName = isExport ? customReportHolder
												.getLocalizedTitle(column.displayName) : column.id;

										pivotFields.push(field + " AS [" + aliasName + "]");

									});

									if (component.sorting) {
										for (var j = 0; j < component.sorting.length; j++) {
											var sort = component.sorting[j];
											var coltoSort = colIdToDataFieldMap[sort.columnId];
											if (coltoSort) {
												orderByClause = orderByClause + "[" + coltoSort + "] " +
														sort.direction + ",";
											}
										}
									}

									orderByClause = orderByClause.substring(0, orderByClause.lastIndexOf(','));

									if (component.orderColumns) {
										pivotOrderBy = pivotColumn;
										if (component.pivotDirection) {
											pivotOrderBy = pivotOrderBy + " " + component.pivotDirection;
										}
									}

									return {
										pivotRow : pivotRow,
										pivotColumn : pivotColumn,
										pivotCell : pivotCell,
										pivotGroupBy : pivotGroupByList,
										pivotOrderby : pivotOrderBy,
										orderByClause : orderByClause,
										pivotRowTitle : pivotRowTitle,
										valueFieldsList : pivotFields
									};
								};

								customReportHolder.getTableValueFields = function(component, isExport) {
									var valueFieldsList = [];
									var groupByFieldsList = [];
									var aggrTypeFound = false;
									var columns = component.columns || [];
									var orderByClause = "";//default sorting defined at the component level.
									var actualHiddenColumns = [];
									var colIdToAliasmap = {};
									for (var i = 0; i < columns.length; i++) {
										var column = columns[i];
										if (column.dataField.indexOf("_ActualHidden") != -1) {
											actualHiddenColumns.push(column.dataField);
										}
										if (isExport && column.hidden) {
											continue; // Hidden columns are shown in the alert export.
										}
										var field = "[" + column.dataField + "]";
										var aliasName = isExport ? customReportHolder
												.getLocalizedTitle(column.displayName) : column.id;

										if (column.aggrType && column.aggrType != 'None') {
											aggrTypeFound = true;
											if (column.aggrType == 'CountDistinct') {
												valueFieldsList.push("count (distinct(" + field + ")) AS [" +
														aliasName + "]");
											} else {
												valueFieldsList.push(column.aggrType + "(" + field + ") AS [" +
														aliasName + "]");
											}
										} else {
											valueFieldsList.push(field + " AS [" + aliasName + "]");
											groupByFieldsList.push(field);
										}

										if (component.allColumns) {
											aliasName = column.dataField;
										}

										var index = actualHiddenColumns.indexOf(column.dataField + "_ActualHidden");
										if (index != -1) {
											aliasName = actualHiddenColumns[index];
										}

										colIdToAliasmap[column.id] = aliasName;
									}
									;

									// the order of sorting needs to be maintained.
									if (component.sorting) {
										for (var j = 0; j < component.sorting.length; j++) {
											var sort = component.sorting[j];
											var coltoSort = colIdToAliasmap[sort.columnId];
											if (coltoSort) {
												orderByClause = orderByClause + "[" + coltoSort + "] " +
														sort.direction + ",";
											}
										}
									}

									if (!aggrTypeFound) {
										groupByFieldsList = [];
									}

									orderByClause = orderByClause.substring(0, orderByClause.lastIndexOf(','));

									return {
										valueFieldsList : valueFieldsList,
										groupByFieldsList : groupByFieldsList,
										orderByClause : orderByClause
									};
								};

								customReportHolder.generateAggregateColumn = function(columns, component, isExport) {
									var isGroupBy = component.isGroupBy;
									var returnColumns = [];
									var aliasColumns = [];
									angular.forEach(columns, function(columnField) {

										var aliasColumn = {};
										aliasColumn.sortOrder = columnField.sortOrder;
										aliasColumn.name = "[" + columnField.column + "]";
										var returnColumn = "[" + columnField.column + "]";
										if (isExport && columns.length == 1 && component.yAxisTitle &&
												component.yAxisTitle.text) {
											aliasColumn.name = "[" + component.yAxisTitle.text + "]";
										}
										if (columnField.aggrType != 'None') {
											if (!isExport) {
												aliasColumn.name = "[" + columnField.aggrType + "_" +
														columnField.column + "]";
											}
											if (columnField.aggrType == 'CountDistinct') {
												returnColumn = "count (distinct([" + columnField.column + "])) AS " +
														aliasColumn.name;
											} else {
												returnColumn = columnField.aggrType + "(IFNULL([" + columnField.column +
														"],-1)) AS " + aliasColumn.name;
											}
										} else {
											/*
											 * there is no aggregate type for column and groupby is true ,
											 * means there is aggregation on other columns that mean we have
											 * assume a default aggregation to the column which is Sum for
											 * number and Count for all other types
											 */
											if (isGroupBy) {
												if (columnField.showNumberOps) {
													aliasColumn.name = "[Sum_" + columnField.column + "]";
													returnColumn = "Sum(IFNULL([" + columnField.column + "],-1)) AS " +
															aliasColumn.name;
													columnField.aggrType = "Sum";
												} else {
													aliasColumn.name = "[Count_" + columnField.column + "]";
													returnColumn = "Count(IFNULL([" + columnField.column +
															"],-1)) AS " + aliasColumn.name;
													columnField.aggrType = "Count";
												}
											} else {
												returnColumn = "[" + columnField.column + "] AS " + aliasColumn.name;
											}
										}
										returnColumns.push(returnColumn);
										aliasColumns.push(aliasColumn);
									});
									return {
										returnColumn : returnColumns,
										orderBycolumn : aliasColumns
									};
								};

								// When using time grouping, we need to format the dimension.column different when UNIX timestamps are used
								customReportHolder.formatDimensionColumnForGrouping = function(component, dimension) {
									return "[" + dimension.column + "]";
								}

								// When using time grouping, we need to format the dimension.column different when UNIX timestamps are used
								customReportHolder.getGroupString = function(component, params, isExport) {
									angular
											.forEach(component.dimensionDataField,
													function(dimension, key) {
														if (dimension.customGroupsAvailable && dimension.groups &&
																dimension.groups.length > 0) {
															var cgString;
															for (var i = 0; i < dimension.groups.length; i++) {
																if (!cgString) {
																	cgString = {
																		groups : {},
																		ungrouped : dimension.includeUngrouped === true ? "Include"
																				: "Exclude",
																		includeMissingGroups : dimension.includeMissingGroups
																	};
																}
																cgString.groups[dimension.groups[i]["groupName"]] = dimension.groups[i]["groupValues"];
															}
														}

														if (cgString) {
															if (isExport) {
																if (!params.customGroups) {
																	params.customGroups = [];
																}

																params.customGroups.push({
																	fieldName : dimension.column,
																	properties : JSON.stringify(cgString)
																});
															} else {
																params["customgroups." + dimension.column] = encodeURIComponent(JSON
																		.stringify(cgString));
															}
														}
													});
								}

								customReportHolder.getChartValueFields = function(component, isExport) {
									var groupByFieldsList = [], valueFieldsList = [], orderByClause = "", orderByColumns = [], grouping = "", grouping2 = "", timeField, timeGroup, binCount, binWidth = "", bin, pageSize;

									if (component.isGroupBy == undefined) {
										for (var i = 0; i < component.measureDataField.length; i++) {
											if (component.measureDataField[i].aggrType != 'None') {
												component.isGroupBy = true;
												break;
											}
										}
									}

									if (component.isTimeGrouping == true) {
										var dimension = component.dimensionDataField[0];
										switch (dimension.timeGrouping) {
										case "auto":
											grouping = "auto";
											break;
										case "Hourly":
											grouping = "HH";
											break;
										case "Daily":
											grouping = "DAY";
											break;
										case "Weekly":
											grouping = "WEEK";
											break;
										case "Monthly":
											grouping = "MONTH";
											break;
										case "Yearly":
											grouping = "YEAR";
											break;
										default:
											grouping = "AUTO";
										}
									}

									angular.forEach(component.dimensionDataField, function(dimension, key) {
										// no need of grouping on dimension when there is no aggregation done;
										var aliasName = dimension.column;
										if (isExport && component.xAxisTitle && component.xAxisTitle.text && key == 0) {
											aliasName = component.xAxisTitle.text;
										}
										if (component.chartType !== 'TimeSeries' && key == 0 &&
												!dimension.numPointsToDisplay.includeAll &&
												dimension.numPointsToDisplay.maxPoints) {
											pageSize = dimension.numPointsToDisplay.maxPoints;
										} else {
											pageSize = -1; // exisitng time series have maxPoints hard coded to 15. For TimeSeries chart we need to include all values.
										}

										if (key == 0 && component.isTimeGrouping == true) {
											groupByFieldsList.push("[" + dimension.column + "]");
											timeField = aliasName;
											timeGroup = grouping;
											if (dimension.column !== aliasName) {
												valueFieldsList.push("[" + dimension.column + "] AS [" + aliasName +
														"]");
											} else {
												valueFieldsList.push("[" + dimension.column + "]");
											}

										} else {
											if (component.isGroupBy || !component.measureDataField ||
													component.measureDataField.length == 0) {
												groupByFieldsList.push("[" + dimension.column + "]");
											}

											if (dimension.column !== aliasName) {
												valueFieldsList.push("[" + dimension.column + "]" + " AS [" +
														aliasName + "]");
											} else {
												valueFieldsList.push("[" + dimension.column + "]");
											}
										}
									});

									var aggrColumns = customReportHolder
											.generateAggregateColumn(component.measureDataField, component, isExport);
									angular.forEach(aggrColumns.returnColumn, function(column) {
										valueFieldsList.push(column);
									});

									if (component.type == 'TABLE' && component.sorting) {
										angular.forEach(component.sorting,
												function(sort) {
													//orderByColumns.push(sort.dataField);
													orderByClause = orderByClause + sort.dataField + " " +
															sort.direction + ",";
												});
									} else if (component.type == 'CHART' && component.sorting) {
										if (component.isTimeGrouping == true) {
											var dimension = component.dimensionDataField[0];
											var sorting = component.sorting[0];
											orderByClause += "[" + dimension.column + "] " + sorting.direction;
										} else {
											var sorting = component.sorting[0];
											if (sorting.sortAxis != 'None') {
												if (sorting.columnId) {
													orderByClause = orderByClause + "[" + sorting.columnId + "] " +
															sorting.direction;
												} else if (sorting.sortAxis == 'XAxis') {
													orderByClause = orderByClause + "[" +
															component.dimensionDataField[0].column + "] " +
															sorting.direction;
												} else {
													angular.forEach(aggrColumns.orderBycolumn, function(col) {
														//							orderByClause = orderByClause + col.name + " " + sorting.direction + ",";
														orderByClause = orderByClause + col.name + ",";
													});
													orderByClause = orderByClause.substr(0, orderByClause
															.lastIndexOf(",")) +
															" " + sorting.direction;
												}
											}
										}

										if (component.chartType === 'Histogram') {
											if (component.binType === 'FIXEDBINCOUNT') {
												binCount = component.binValues[0].value;
											} else if (component.binType === 'FIXEDBINWIDTH') {
												var unit = component.binValues[0].unit;
												binWidth = binWidth + component.binValues[0].value +
														component.binValues[0].unit;
											} else if (component.binType === 'VARIABLEBINWIDTH') {
												bin = "";
												angular.forEach(component.binValues, function(opt) {
													bin = bin + opt.value + opt.unit + ",";
												});
												if (bin) {
													bin = bin.substr(0, bin.lastIndexOf(","));
												}
											} else if (component.binType === 'CUSTOMBINWIDTH') {
												bin = customReportHolder
														.evalExpression(component.customWidthExpression);
											}
										}
									}

									//			 orderByClause = orderByClause ? orderByClause.substring(0,orderByClause.lastIndexOf(',')) : orderByClause;
									return {
										valueFieldsList : valueFieldsList,
										groupByFieldsList : groupByFieldsList,
										orderByClause : orderByClause,
										timeField : timeField,
										timeGroup : timeGroup,
										binCount : binCount,
										binWidth : binWidth,
										bin : bin,
										pageSize : pageSize
									};
								};

								customReportHolder.setComponentLoaded = function(component, components) {
									component.loaded = true;

									var allLoaded = true;
									angular.forEach(components, function(component) {
										if (!component.loaded) {
											allLoaded = false;
											return;
										}
									});

									if (allLoaded) {
										customReportHolder.triggerCallback("allComponentsLoaded", {});
										var exportType = customReportHolder.getParameterByName("exportType");
										if (exportType != 'PRINT') {
											return;
										}
										if (!globalVar.reportPrinted) {
											globalVar.reportPrinted = true;
											$timeout(function() {
												window.print();
											}, 1000);
										}
									}
								}

								customReportHolder.getDataField = function(dataField, aggrType) {
									if (aggrType && aggrType != "None") {
										dataField = aggrType + "_" + dataField;
									}

									return dataField;
								}

								customReportHolder.exportColumns = function(component) {
									var exportColumns = [];
									var hiddenColumns = customReportHolder.getParameterByName(component.id + ".hide")
											.split(",");
									var showColumns = customReportHolder.getParameterByName(component.id + ".show")
											.split(",");
									var pushColumn = false;

									angular.forEach(component.columns, function(column) {
										if (!column.hidden) {
											pushColumn = false;
											if (column.visible || showColumns.indexOf(column.id) != -1) {
												pushColumn = true;
											}

											if (hiddenColumns.indexOf(column.id) != -1) {
												pushColumn = false;
											}

											if (column.excludeFromCSVExport) {
												pushColumn = false;
											}

											if(typeof column.components !== undefined && column.components && column.components.length > 0){
												pushColumn = false;
											}

											if (pushColumn) {

												let displayName = customReportHolder.getLocalizedTitle(column.displayName);
												displayName = dataSetUtility.removeHtml(displayName);
												exportColumns.push(displayName);

											}
										}
									});

									return exportColumns;
								}

								customReportHolder.getDataSetParams = function(component, dataSet, inputs,
										dataSetParams, urlParams) {
									var options = customReportHolder.getDataSetOptions(component, false, urlParams);
									var parametersList = customReportHolder.applyInputsToDataSet(dataSet,
											inputs,
											dataSetParams.builderVersion);
									var params = {
										dataSetName : dataSet.dataSet.dataSetId,
										component : component.id,
										dataSet : dataSetParams.reportMode === 'builder' ||
												dataSetParams.reportMode === 'preview' || dataSetParams.isPreview ? JSON
												.stringify(dataSet)
												: null,
										fields : component.allColumns && component.type !== "PIVOT_TABLE" ? null : JSON
												.stringify(options.valueFieldsList),
										groupbyFields : JSON.stringify(options.groupByFieldsList),
										//									whereClause : options.whereClause,
										//										filter : JSON.stringify(options.filter),
										orderByClause : options.orderByClause,
										//								havingClause : JSON.stringify(options.havingClause),
										parameters : JSON.stringify(parametersList),
										limit : options.pageSize,
										offset : dataSetParams.offset,
										cacheId : dataSetParams.cacheId,
										includeOther : options.includeOther,
										exportType : dataSetParams.exportType,
										exportedFileName : dataSetParams.exportFileName,
										preview : dataSet.previewRowSize,
										rawData : (dataSetParams.rawData === true ? true : undefined),
										pivotGroupby : JSON.stringify(options.pivotGroupBy),
										pivotOrderby : options.pivotOrderby,
										pivotRow : options.pivotRow,
										pivotColumn : options.pivotColumn,
										pivotCell : options.pivotCell,
										pivotRowTitle : options.pivotRowTitle,
										timeField : options.timeField,
										timeGroup : options.timeGroup,
										binCount : options.binCount,
										binWidth : options.binWidth,
										bin : options.bin,
										includeMissingTimes : component.includeMissingTimes
									};

									return params;
								}

								customReportHolder.getDataSettoExport = function(component, page, urlParams, cacheId,
										builderVersion, reportComponents) {
									var datSetExport = {};
									var ds = angular.copy(customReportHolder.getDataSet(component.dataSet.dataSetName,
											page.dataSets.dataSet), {});
									if ($.isEmptyObject(ds)) {
										return;
									}
									var cmp = angular.copy(component, {});
									var urlOptions = customReportHolder.getDataSetOptions(component, true, urlParams);
									var inputs = page.inputs;
									datSetExport.entity = ds.dataSet;
									datSetExport.header = component.title && component.title.text ? customReportHolder
											.getLocalizedTitle(component.title.text) : "";
									var dataSetParams = {
											reportMode : 'viewer',
											componentName : component.title && component.title.text || component.id,
											dsId : null,
											operation : "data",
											builderVersion : builderVersion,
											isPreview : false,
											limit : -1,
											offset : 0,
											exportType : 'csv',
											rawData : false,
											cacheId : cacheId
										};
									cmp.pageSize = -1;
									urlParams['exportType'] = 'csv';
									urlParams['csvExportType'] = 'csv';
									var params = dataSetUtility.getParams(cmp, ds, page, dataSetParams, urlParams, false,false);
									params.column = customReportHolder.exportColumns(component);
									delete urlParams['exportType'];
									datSetExport.urlParameters = dataSetUtility.requestToUrl(params);

									return datSetExport;
								}

								customReportHolder.getLocalizedTitle = function(title) {
									title = customReportHolder.checkExpressionToLocalize(title);
									return title != "" ? customReportHolder.cvReportCustomization({
										"expression" : title
									}) : "";
								}

								var getPanelComponentFromCurrentTab = function(component, urlParams) {
									var currentTab = null;
									if (urlParams["active." + component.id]) {
										currentTab = urlParams["active." + component.id];
									} else if (component.defaultTab) {
										currentTab = component.defaultTab;
									}
									if (currentTab) {
										currentTab = _.find(component.tabs, [ 'id', currentTab ]);
									} else {
										currentTab = component.tabs[0];
									}
									return currentTab.component;
								}

								customReportHolder.getDataSetstoExport = function(components, page, title, urlParams,
										cacheId, builderVersion, reportComponents) {
									var dataSetsToExport = [];
									var panelComponent = null;
									var dsExport = null;
									angular.forEach(components, function(component) {
										panelComponent = null;
										if (component.type !== "SEARCH_BAR" && component.type !== "DATE_RANGE") {
											if (component.type === "TABS") {
												panelComponent = getPanelComponentFromCurrentTab(component, urlParams);
											} else if (component.type === "PANEL") {
												panelComponent = component;
											}

											if (panelComponent != null) {
												for ( var panel in panelComponent.panelComponents) {
													dsExport = customReportHolder
															.getDataSettoExport(panelComponent.panelComponents[panel],
																	page,
																	urlParams,
																	cacheId,
																	builderVersion,
																	reportComponents);
													if (dsExport) {
														dataSetsToExport.push(dsExport);
													}
												}
											} else {
												dsExport = customReportHolder.getDataSettoExport(component,
														page,
														urlParams,
														cacheId,
														builderVersion,
														reportComponents);
												if (dsExport) {
													dataSetsToExport.push(dsExport);
												}
											}
										}
									});
									var reportName = customReportHolder.getLocalizedTitle(title) +
											"\n Report generated on ";
									return {
										dataSet : dataSetsToExport,
										header : reportName
									};
								}

								customReportHolder.checkExpressionToLocalize = function(expression) {
									if (expression && typeof expression === "string" &&
											expression.substring(0, 1) !== "=" && expression.substring(0, 2) !== ":=") {
										expression = expression.replace(/'/g, "\\'"); // escape single quotes in a string.
										expression = "=rpt.translate('" + expression + "')";
									}
									return expression;
								}

								customReportHolder.cvReportCustomization = function(reportCustomization, domEelement) {
									var htmlRegex = /<([A-Za-z!][A-Za-z0-9!]*)\b[^>]*>(.*?)(<\/\1>)*/i;
									var removeHtmlRegex = /((<style>)[^]*(<\/style>))+|((<script>)[^]*(<\/script>))+|<\/?[^>]+>/ig;
									var expression = reportCustomization.expression;
									if (reportCustomization.localize && reportCustomization.localize === "true") {
										expression = customReportHolder.checkExpressionToLocalize(expression);
									}
									var allCellExpression = reportCustomization.allCellExpression;
									var tagAttributes = reportCustomization.tagAttributes;
									var showTitleTooltip = reportCustomization.showTitleTooltip !== undefined &&
											reportCustomization.showTitleTooltip != null &&
											reportCustomization.showTitleTooltip;
									var textOnly = reportCustomization.textOnly !== undefined &&
											reportCustomization.textOnly != null && reportCustomization.textOnly

									if (reportCustomization.isTableCustomization) {
										var rowIndex = reportCustomization.rowIndex;
										var columnIndex = reportCustomization.columnIndex;
										var row = reportCustomization.row;
										var cellData = elementData = reportCustomization.cellData;
										if (reportCustomization.allCellExpression && !expression) {
											expression = reportCustomization.allCellExpression;
										}
										textOnly = true;
									} else {
										var elementData = reportCustomization.elementData;
									}
									//TODO:Remove the comment after talking with Jagadeesh
									// function evalExpression(expression) {
									// 	var retunVal = expression;
									// 	if(typeof expression === "string" && expression.substring(0, 1) === "=") {
									// 		try {
									// 			retunVal = eval(expression.substring(1));
									// 		} catch (exception) {
									// 			console.error(exception.message)
									// 		}
									// 	} else if(typeof expression === "string" && expression.substring(0, 2) === ":=") {
									// 		try {
									// 			var expr = "(function() {" + expression.substring(2) + " }) ();";
									// 			retunVal = eval(expr);
									// 		} catch (exception) {
									// 			console.error(exception.message)
									// 		}
									// 	}
									// 	return retunVal;
									// }

									if (expression !== undefined && expression != null && expression.length > 0) {
										var currentElement = customReportHolder.evalExpression(expression);
										if (!domEelement) {
											return currentElement;
										}
										if (currentElement !== expression) {
											textOnly = false;
										} else if (textOnly) {
											currentElement = expression.replace(removeHtmlRegex, '');
										} else if (!textOnly && htmlRegex.test(expression)) {
											currentElement = angular.element(expression);
											if (showTitleTooltip) {
												currentElement.attr('title', expression);
											}
										} else {
											currentElement = expression;
										}
										elementData = currentElement;
										if (textOnly) {
											domEelement.text(elementData);
										} else {
											domEelement.empty();
											domEelement.append(elementData);
										}
									} else {
										if (!domEelement) {
											return reportCustomization;
										}
										if (elementData) {
											elementData = $sce.trustAsHtml(elementData);
										}
										domEelement.html(elementData);
									}
									if (showTitleTooltip) {
										if (htmlRegex.test(elementData)) {
											domEelement.attr('title', elementData.replace(removeHtmlRegex, ''));
										} else {
											domEelement.attr('title', elementData);
										}
									}
									if (tagAttributes !== undefined && tagAttributes != null &&
											tagAttributes.length > 0) {
										var tagAttributesObj = JSON.parse(tagAttributes);
										for ( var key in tagAttributesObj) {
											var currentElement = customReportHolder
													.evalExpression(tagAttributesObj[key]);
											if (currentElement != null) {
												domEelement.attr(key, currentElement);
											} else {
												domEelement.attr(key, tagAttributesObj[key]);
											}
										}
									}
								} // End of customize Function
								;

								customReportHolder.escapeHtml = function(str) {
									var div = document.createElement('div');
									div.appendChild(document.createTextNode(str));
									return div.innerHTML;
								};
								customReportHolder.CONTEXT_PATH = window.location.pathname.substring(0,
										window.location.pathname.indexOf("/", 2));
								customReportHolder.getContextPath = function() {
									return customReportHolder.CONTEXT_PATH;
								};

								customReportHolder.errorToast = function(msg, delay) {
									var message = {
										message : msg,
										delay : !delay ? 3000 : delay,
										ttl : 5000
									};
									cvToaster.showErrorMessage(message);
								}

								customReportHolder.toast = function(msg, delay) {
									var message = {
										message : msg,
										delay : !delay ? 3000 : delay,
										ttl : 5000
									};
									cvToaster.showInfoMessage(message);
								}

								customReportHolder.errorWithDetailsToast = function(intialText, endText, more, less) {
									var message = {
										intialText : intialText,
										endText : endText,
										more : more,
										less : less,
										ttl : 5000
									};
									cvToaster.showErrorMessageWithDetails(message);
								}

								customReportHolder.infoWithDetailsToast = function(intialText, endText, more, less) {
									var message = {
										intialText : intialText,
										endText : endText,
										more : more,
										less : less,
										ttl : 5000
									};
									cvToaster.showInfoMessageWithDetails(message);
								}

								customReportHolder.generateUUID = function() {
									var currentTime = new Date().getTime();
									var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(chr) {
										var randomNum = (currentTime + Math.random() * 16) % 16 | 0;
										currentTime = Math.floor(currentTime / 16);
										return (chr == 'x' ? randomNum : (randomNum & 0x7 | 0x8)).toString(16);
									});
									return uuid;
								};

								customReportHolder.writeCustomScriptToDOM = function(jsCustomCode) {
									var scriptTag = "<script nonce='"+nonceVar+"' data-custom-style='true'>";
									scriptTag += jsCustomCode;
									scriptTag += "</script>";
									if (angular.element('script[data-custom-style="true"]').length > 0) {
										angular.element('script[data-custom-style="true"]').remove();
									}
									angular.element("body").append(scriptTag);
									//customReportHolder.triggerCallback("refreshTableData",$scope.propData.id);
								};

								customReportHolder.writeCustomStyleToDOM = function(customStyle) {
									var styleTag = angular
											.element('<style type="text/css" data-custom-style="true"></style>');
									styleTag.append(customStyle);
									//$compile(styleTag)($scope);
									if (angular.element('style[data-custom-style="true"]').length > 0) {
										angular.element('style[data-custom-style="true"]').remove();
									}
									angular.element("head").append(styleTag);
								}

								customReportHolder.checkForDuplicateIDsInObject = function(object, propertyName,
										propertyValue, threshold) {
									var tmp = [];
									var duplicatesFound = false;
									if (threshold === undefined) {
										threshold = 1;
									}
									angular.forEach(object, function(o, index) {
										if (o[propertyName] in tmp) {
											tmp[o[propertyName]]++;
											if (tmp[o[propertyName]] > threshold) {
												duplicatesFound = true;
											}
										} else {
											tmp[o[propertyName]] = 1;
										}
									});
									// If we are checking if a particular value is duplicated, only return the status of that value
									if (propertyValue !== undefined) {
										duplicatesFound = false;
										if (propertyValue in tmp) {
											if (tmp[propertyValue] > threshold) {
												duplicatesFound = true;
											}
										}
									}
									return duplicatesFound;
								}

								customReportHolder.checkForSpaceInIDs = function(object, propertyName, propertyValue,
										threshold) {

									var spacesFoundInId = false;
									angular.forEach(object, function(o, index) {
										// if we are passing in a subproperty name, we have to recurse down through the object to find the subproperty value
										if (propertyName.indexOf(".") != -1) {
											var pn = propertyName.split(".");
											var tmp = o;
											angular.forEach(pn, function(part, i) {
												tmp = tmp[part];
											});
											if (/\s/g.test(tmp)) {
												spacesFoundInId = true;
											}
										} else {
											if (/\s/g.test(o[propertyName])) {
												spacesFoundInId = true;
											}
										}
									});
									return spacesFoundInId;
								}

								customReportHolder.checkForEmptyIDsInObject = function(object, propertyName) {
									var emptyIDsFound = false;
									angular.forEach(object, function(o, index) {
										// if we are passing in a subproperty name, we have to recurse down through the object to find the subproperty value
										if (propertyName.indexOf(".") != -1) {
											var pn = propertyName.split(".");
											var tmp = o;
											angular.forEach(pn, function(part, i) {
												tmp = tmp[part];
											});
											if ($.trim(tmp) == "") {
												emptyIDsFound = true;
											}
										} else {
											if ($.trim(o[propertyName]) == "") {
												emptyIDsFound = true;
											}
										}
									});
									return emptyIDsFound;
								}

								customReportHolder.checkForSquareBracketsInColumnNames = function(object, propertyName) {

									var squareBracketsFound = false;
									angular.forEach(object.columns, function(o, index) {
										// if we are passing in a subproperty name, we have to recurse down through the object to find the subproperty value
										if (propertyName.indexOf(".") != -1) {
											var pn = propertyName.split(".");
											var tmp = o;
											angular.forEach(pn, function(part, i) {
												tmp = tmp[part];
											});
											if (/[\[\]]/.test(tmp)) {
												squareBracketsFound = true;
											}
										} else {
											if (/[\[\]]/.test(o[propertyName])) {
												squareBracketsFound = true;
											}
										}
									});
									return squareBracketsFound;
								}

								// get dcube data source info
								customReportHolder.getDCubeDataSetInfo = function(dsId, callback) {
									// default parameters
									var dataSet = {
										"dCubeDataSet" : {
											"dsId" : 0,
											"dsName" : '',
											"dsType" : '',
											"dsHandler" : {
												"handlerId" : 0,
												"handlerName" : ''
											}
										},
										"dataSet" : {
											"dataSetName" : "Loading..",
											"originalDataSetName" : "",
											"dataSetId" : 0,
											"dataSetGuid" : customReportHolder.generateUUID()
										},
										"description" : "",
										"endpoint" : "DATACUBE",
										"allColumns" : false,
										"fields" : [],
										GetOperation : {
											sqlText : "",
											parameters : [],
											timeout : 5
										},
										queryPlan : {
											offline : false,
											versions : [ "ALL" ],
											retentionDays : 7
										}
									};
									reportService.getDCubeDataSetInfo(dsId).then(function(data) {
										dataSet.dataSet.dataSetName = data.data.displayName;
										dataSet.dCubeDataSet.dsName = dataSet.dataSet.dataSetName;
										dataSet.dCubeDataSet.dsId = dsId;
										callback(dataSet);
									}, function(error) {
										customReportHolder.errorToast(error.data);
										callback(dataSet);
									});
								}

								customReportHolder.getFieldsForCustomReport = function(fieldsArr) {
									var arrToReturn = [];
									if (!$.isEmptyObject(fieldsArr)) {
										$.each(fieldsArr, function(i, eachField) {
											//include timestamp field though skipdelete=true
											if (qb.base.isAllowedSystemField(eachField.fieldName) ||
													(!eachField.skipdelete && !qb.base
															.isFieldToBeExcluded(eachField.fieldName))) {
													eachField.name = eachField.fieldName;
													eachField.dataField = eachField.fieldName;
													eachField.origType = eachField.type;
													eachField.type = qb.base.getFieldTypeForReport(eachField.type);
													arrToReturn.push(eachField);
											}
										});
									}
									return arrToReturn;
								};

								customReportHolder.getSelectedColumnsDefn = function(fieldsArr, selectedColumns) {
									var fieldsMap = {};
									var arrToReturn = [], obj,self=this;
									if (!$.isEmptyObject(fieldsArr)) {
										$.each(fieldsArr, function(i, eachField) {
											fieldsMap[eachField.name] = eachField;
										});
										$.each(selectedColumns, function(i, eachColumn) {
											if(eachColumn.id !== "sys_rowid") {
												if (!fieldsMap.hasOwnProperty(eachColumn.dataField)) {
												//not found in schema; default to String
													obj = {};
													obj.dataField = obj.name = obj.fieldName = eachColumn.dataField;
													obj.type = "text_general";
												} else {
													obj = self.getDeepCopy(fieldsMap[eachColumn.dataField]);
												}
												obj.visible = eachColumn.visible;
												arrToReturn.push(obj);
											}
										});
									}
									return arrToReturn;
								}

								customReportHolder.prepareLMFieldsForReport = function(data) {
									var fields = [];
									var dtMap = {
										"0" : "String", //*_sf
										"1" : "String", //*_sn
										"2" : "String", // *_xf
										"3" : "String", // *_xn
										"4" : "Long", // *_if
										"5" : "Long", // *_in
										"6" : "Double", // *_df
										"7" : "Double", // *_dn
										"8" : "Long", // *_DEC_OF_HEX
										"9" : "Long", // *_DEC_OF_BIN
										"10" : "Double", // *_FLOAT_OF_HEX
										"11" : "Double", // *_FLOAT_OF_BIN
										"12" : "String", // *_lf
										"13" : "String", // *_ln
										"14" : "TimeStamp", // *_tf
										"15" : "TimeStamp" // *_tn
									}

									$.each(data, function(i, curField) {
										fields.push({
											name : curField.displayName,
											dataField : curField.solrFieldName,
											type : dtMap.hasOwnProperty(curField.dataType) ? dtMap[curField.dataType]
													: "String"
										});
									});

									return fields;
								};

								customReportHolder.getDispTextForAgg = function(aggrType) {
									switch (aggrType) {
									case "CountDistinct":
									case "Count":
										return "Count";
									case "Sum":
									case "Avg":
									case "Min":
									case "Max":
									case "Top":
									case "Bottom":
										return aggrType;
									default:
										return "";
									}
								};
								customReportHolder.getFormattedId = function(componentId) {
									return (componentId || "").replace(/[^A-Za-z0-9_]/g, "");
								};

								customReportHolder.evalExpression = function(expression, row, col, rowIndex, cellData,
										columnIndex) {
									var args = {
										expression : expression,
										row : row,
										col : col,
										rowIndex : rowIndex,
										cellData : cellData,
										columnIndex : columnIndex
									};
									return rpt.evalExpression(args);
								}


								customReportHolder.formatValueUtil = function(value, formatter, row, rowIndex, colIndex, dataSet,col) {
									if(formatter.type === "date" ) {
										if(col && (col.type === "Long" || col.type === "Integer")) {
											if(!formatter.srcFmt)
												formatter.srcFmt = "ts";
										} else
											formatter.srcFmt = dataSet && dataSet.endpoint === "DATACUBE" ? "YYYY-MM-DD'T'HH:mm:ss" : "MMM DD, YYYY hh:mm:ss A";

										if(col.type === "Date")
											formatter.srcTimezone = undefined;
										else if (!formatter.srcTimezone)
											formatter.srcTimezone = "GMT";

										formatter.timezone = moment.tz.guess();//destination time zone will be always browser's timezone
									}
									var renderer = $.extend(true, {}, formatter);
									if (renderer.type === 'number') {
										if (renderer.fmt == 'string') {
											renderer.type = "numberToString";
										}
									} else if (renderer.type === 'size') {
										renderer.fmt = renderer.target;
									} else if (renderer.type === 'boolean' && renderer.booleanType) {
										delete renderer.booleanType;
									} else if (renderer.type === 'Metrics' && renderer.fmt.length > 0) {
										return cvMetrics.format(renderer.fmt,value,row);
									} else if (renderer.type === 'link') {
										var args = {};
										args["cellData"] = value;
										args["row"] = row;
										args["rowIndex"] = rowIndex;
										args["colIndex"] = colIndex;
										if (typeof renderer.linkString === "string") {
											args["expression"] = renderer.linkString;
											renderer.linkString = rpt.evalExpression(args); // running through rpt.evalExpression() to support the {{}}
											if (!row) {
												row = {};
												row['value'] = value;
											}
											row['cellData'] = value;
											return cvFormatters.getDisplayValue(value, renderer, undefined, row);
										} else {
											return rpt.getColumCompHtml(renderer.link, args);

										}
									}

									return value !== undefined ? cvFormatters.getDisplayValue(value, renderer, undefined, row) : "";
								};
								customReportHolder.getFormattedValue = function(value, formatter, row, rowIndex,
										columnIndex, col, dataSet) {
									var returnVal = value;
									var label = value;
									var cellData = value;
									if (formatter === undefined || formatter === "") {
										return returnVal;
									} else if (typeof formatter === 'string') {
										if (cellData && typeof cellData === 'object' && cellData.length) {
											var result = [];
											for (var k = 0; k < cellData.length; k++) {
												result.push(customReportHolder.evalExpression(formatter,
														row,
														col,
														rowIndex,
														cellData[k],
														columnIndex));
											}
											return result;
										} else {
											return customReportHolder.evalExpression(formatter,
													row,
													col,
													rowIndex,
													value,
													columnIndex);
										}
									} else {
										if (cellData && typeof cellData === 'object' && cellData.length) {

											var result = [];
											for (var k = 0; k < cellData.length; k++) {
												result.push(customReportHolder.formatValueUtil(cellData[k],
														formatter,
														row,
														rowIndex,

														columnIndex,dataSet,col));

											}
											return result;
										} else {
											return customReportHolder.formatValueUtil(cellData,
													formatter,
													row,
													rowIndex,
													columnIndex,dataSet,col);

										}
									}
								}
								customReportHolder.getDefaultAdvancedFilter = function(field, value) {
									var advancedFilter = {
										'filters' : [],
										'logic' : 'or'
									};
									var filter = {
										'field' : field,
										'operator' : 'custom',
										'value' : value
									};
									advancedFilter.filters.push(filter);
									return advancedFilter;
								};
								customReportHolder.processFields = function(columns, dataSet) {
									var oldFields = dataSet && dataSet.fields || [];

									if (columns.length > 0) {
										var newFields = [];
										for (var k = 0; k < columns.length; k++) {
											newFields
													.push({
														name : columns[k].name,
														dataField : typeof columns[k].dataField !== "undefined" ? columns[k].dataField
																: columns[k].name,
														type : columns[k].type
													});
										}

										if (oldFields && oldFields.length > 0) {
											for (var i = 0; i < oldFields.length; i++) {
												var oldField = oldFields[i];
												var oldFieldFound = false;
												for (var j = 0; j < newFields.length; j++) {
													var newField = newFields[j];
													if (oldField.name.toLowerCase() === 'sys_rowid' &&
															oldField.name === newField.name) {
														oldField.type = newField.type;
														oldFieldFound = true;
														break;
													}

													if (oldField.dataField === '' ||
															oldField.dataField === newField.dataField) {
														oldField.type = newField.type;
														oldFieldFound = true;
														break;
													}
												}

												if (!oldFieldFound) {
													oldFields.splice(i, 1);
													i--;
												}
											}

											var currFields = [];
											// check if there fields from the old query are changed , then remove the fields from the fields definition.
											for (var i = 0; i < newFields.length; i++) {
												var newField = newFields[i];
												var oldFieldFound = false;
												var currIndex = 0;
												for (var j = 0; j < oldFields.length; j++) {
													var oldField = oldFields[j];

													if (oldField.name.toLowerCase() === 'sys_rowid' &&
															oldField.name === newField.name) {
														oldField.type = newField.type;
														oldFieldFound = true;
														break;
													}

													if (newField.dataField === oldField.dataField) {
														oldField.type = newField.type;
														oldFieldFound = true;
														currIndex = j;
														break;
													}
												}

												if (!oldFieldFound) {
													currFields.push(newField);
												}
											}

											oldFields = oldFields.concat(currFields);
										} else {
											oldFields = newFields;
										}
										dataSet.fields = oldFields;
									}
									//customReportSvc.triggerCallback("activeDataSetsCallbacks", $scope.dataSet);

								};
								customReportHolder.getDeepCopy = function(obj) {
									if (!obj) {
										return obj;
									}
									var isArray = false;
									if (Array.isArray(obj)) {
										isArray = true;
									}
									var copyObj = $.extend(true, isArray ? [] : {}, obj);
									return copyObj;
								}
								customReportHolder.generateColor = function(colorStart, colorEnd, colorCount) {
									function hex(c) {
										var s = "0123456789abcdef";
										var i = parseInt(c);
										if (i == 0 || isNaN(c)) {
											return "00";
										}
										i = Math.round(Math.min(Math.max(0, i), 255));
										return s.charAt((i - i % 16) / 16) + s.charAt(i % 16);
									}

									/* Convert an RGB triplet to a hex string */
									function convertToHex(rgb) {
										return hex(rgb[0]) + hex(rgb[1]) + hex(rgb[2]);
									}

									/* Remove '#' in color hex string */
									function trim(s) {
										return (s.charAt(0) == '#') ? s.substring(1, 7) : s
									}

									/* Convert a hex string to an RGB triplet */
									function convertToRGB(hex) {
										var color = [];
										color[0] = parseInt((trim(hex)).substring(0, 2), 16);
										color[1] = parseInt((trim(hex)).substring(2, 4), 16);
										color[2] = parseInt((trim(hex)).substring(4, 6), 16);
										return color;
									}

									// The beginning of your gradient
									var start = convertToRGB(colorStart);

									// The end of your gradient
									var end = convertToRGB(colorEnd);

									// The number of colors to compute
									var len = colorCount;

									//Alpha blending amount
									var alpha = 0.6;

									var saida = [];

									for (var i = 0; i < len; i++) {
										var c = [];
										alpha -= (1.0 / len);

										c[0] = start[0] * alpha + (1 - alpha) * end[0];
										c[1] = start[1] * alpha + (1 - alpha) * end[1];
										c[2] = start[2] * alpha + (1 - alpha) * end[2];

										saida.push(convertToHex(c));

									}

									return saida;

								}
								customReportHolder.randomColorFromBrightness = function(brightness) {
									function randomChannel(brightness) {
										var r = 255 - brightness;
										var n = 0 | ((Math.random() * r) + brightness);
										var s = n.toString(16);
										return (s.length == 1) ? '0' + s : s;
									}
									return '#' + randomChannel(brightness) + randomChannel(brightness) +
											randomChannel(brightness);
								}
								customReportHolder.defaultMultiChartColors = [
										'#6aa5e7',
										'#d53e4f',
										'#f46d43',
										'#fdae61',
										'#fee08b',
										'#ffffbf',
										'#e6f598',
										'#abdda4',
										'#66c2a5',
										'#ef9359',
										'#ff6d31',
										'#6baed6',
										'#9673a8',
										'#edc135',
										'#73b66b',
										'#b66b73',
										'#b58059',
										'#7d8cb7',
										'#edb721',
										'#b2abd2',
										'#e26698',
										'#74c476',
										'#cc3b42',
										'#41ab5c',
										'#086696',
										'#c66f28',
										'#2796af',
										'#c6542c',
										'#bc9d1d',
										'#8073ac',
										'#078783',
										'#93361c',
										'#af8022',
										'#665699' ];

								customReportHolder.patterns = [
										'M 0 0 L 10 10 M 9 -1 L 11 1 M -1 9 L 1 11',
										'M 0 10 L 10 0 M -1 1 L 1 -1 M 9 11 L 11 9',
										'M 3 0 L 3 10 M 8 0 L 8 10',
										'M 0 3 L 10 3 M 0 8 L 10 8',
										'M 1.5 0 L 5.5 4 M 0 3.5 L 4 5',
										'M 0 3 L 5 3 L 5 0 M 5 10 L 5 7 L 10 7',
										'M 3 3 L 8 3 L 8 8 L 3 8 Z',
										'M 5 5 m -4 0 a 4 4 0 1 1 8 0 a 4 4 0 1 1 -8 0',
										'M 1.5 0 L 1.5 4 M 0 1.5 L 4 5',
										'M 10 3 L 5 3 L 5 0 M 5 10 L 5 7 L 0 7',
										'M-1,1 l2,-2 M0,4 l4,-4 M3,5 l2,-2',
										'M 2 5 L 5 2 L 8 5 L 5 8 Z',
										'M 0 0 L 5 10 L 10 0',
										'M 0 8 L 5 7 L 6 0',
										'M 1.5 0 L 1.5 4 M 0 1.5 L 4 1.5' ];

								customReportHolder.getColorBlindPatterns = function() {
									var cvPatterns = [];
									var pttr = 0;
									for (var clr = 0; clr < customReportHolder.defaultMultiChartColors.length; clr++) {
										pttr = pttr === 15 ? 0 : pttr;
										cvPatterns.push({
											id : 'cv-pattern-' + clr,
											path : customReportHolder.patterns[pttr],
											color : customReportHolder.defaultMultiChartColors[clr]
										});
										pttr++;
									}
									return cvPatterns;
								}

								customReportHolder.createPattern = function(index, color, pttrn) {
									return {
										id : 'cv-pattern-' + index,
										path : pttrn,
										color : color
									}
								}
								/*
								 * Utility function to convert CR2 datasources data object to DataCube data
								 * object. Caution: This is tested against TreeMap chart. Doesn't handle
								 * Groups. CR2 data format = [dim1,dim2,...,measure]
								 *
								 */
								customReportHolder.convertCR2DataToDataCubeModel = function(cr2Data, dimensionFields,
										measureField) {
									if (cr2Data) {
										var datacubeData = {};
										datacubeData.moreInfo = {};
										datacubeData.records = [];
										var columns = cr2Data.columns;
										var records = cr2Data.records;
										var dimLen = dimensionFields.length;
										var numRecords = records.length;
										//populate moreInfo and keyMap
										for (var i = 0; i < dimLen; i++) {
											var col = dimensionFields[i].column.toString();
											datacubeData.moreInfo[col] = {};
											datacubeData.moreInfo[col].keyMap = {};
											for (var j = 0; j < numRecords; j++) {

												datacubeData.moreInfo[col].keyMap[records[j][i]] = records[j][i]
														.toString();
											}
										}
										//populate records
										var datacubeRecordItem = {};
										for (var i = 0; i < numRecords; i++) {
											var cr2Item = records[i];
											for (var j = 0; j + 1 < cr2Item.length; j++) {
												datacubeRecordItem[cr2Item[j].toString()] = cr2Item[j + 1];
											}
										}
										datacubeData.records.push(datacubeRecordItem);
										return datacubeData;
									}
									return null;
								}
								customReportHolder.getSelectedCommcellEntity = function(inputs) {
									var commcellEntitiesSelected = -1;
									var entityId, entityTypeId, entityObj = {
										isCommcellEntitySelected : false
									};
									angular.forEach(inputs, function(input, index) {
										if (input.type === "CommcellEntity") {
											if (commcellEntitiesSelected === -1) {
												commcellEntitiesSelected = 0;
											}
											if (input.value || !$.isEmptyObject(input.selectedValues)) {
												entityId = input.value || input.selectedValues.join(",");
												entityTypeId = input.entityTypeId;
												commcellEntitiesSelected++;
											}
										}
									});
									if (commcellEntitiesSelected !== -1) {
										entityObj.isCommcellEntitySelected = true;
										if (commcellEntitiesSelected === 1) {

											entityObj.entityTypeId = entityTypeId;
											entityObj.entityId = entityId;

										}
										if (commcellEntitiesSelected > 1) {
											customReportHolder
													.errorToast("Please select only one Commcell Entity.");
										}
									}
									return entityObj;
								}

								customReportHolder.getCustomInputs = function(urlParams,inputs) {

								    let customInputs ={};
							        angular.forEach(urlParams, function(paramVal,paramKey) {
							        	if (typeof paramVal === 'string'
							                 && (paramKey.indexOf(".filter.") !==-1 || paramKey.indexOf("input.") !== -1)) {
							                	customInputs[paramKey] = paramVal;
							            }
							        });

							        // get all the input values
							        angular.forEach(inputs, function(input, index) {
							           	customInputs['input.' + input.id] = input.value;
							        });
							        return customInputs;
								}

								customReportHolder.processInputsFromGroupValues = function(groupValues, inputs) {
							            if ($.isEmptyObject(inputs)) {
							                return groupValues;
							            } else {
							                var inputMap = {};
							                $.each(inputs, function(key, value) {
							                    inputMap[key] = value;
							                });
							                var match = /\$\{([a-zA-Z0-9_\-\s\.]*)\}/g.exec(groupValues);
							                while (match != null) {
							                    // console.log(match[0] + " "  +  match[1] + " " + groupValues);
							                    groupValues = groupValues.replace(match[0], inputMap[match[1]]);
							                    match = /\$\{([a-zA-Z0-9_\-\s\.]*)\}/g.exec(groupValues);
							                }
							                // console.log(groupValues);
							            }
							            return groupValues;
							        }

							    customReportHolder.getSelectedCustomGroupObject = function(dimension, filterVal, customInputs) {
							        var selectedGroup = undefined;
							        if (typeof dimension.groups != 'undefined' && dimension.groups.length > 0) {
							            var isOthersGroupSelected = false,
							                notFilter = [], actualGroupValue;
							            var checkForOthersGroup = dimension.includeUngrouped && dimension.ungroupedLabel !== undefined;
							            angular.forEach(dimension.groups, function(group) {
							                actualGroupValue = customReportHolder.processInputsFromGroupValues(group.groupValues, customInputs);
							                if (actualGroupValue.substring(0,1) === "=") {
							                    actualGroupValue = eval(actualGroupValue.substring(1));
							                }
							                if(!(new RegExp("^\\(.*\\)$","g").test(actualGroupValue)))
							                    actualGroupValue = "(" + actualGroupValue + ")";
							                notFilter.push("!" + actualGroupValue);
							                if (group.groupName === filterVal || group.groupName === decodeURI(filterVal)) {
							                    selectedGroup = {
							                        groupName : filterVal,
							                        groupValues : actualGroupValue
							                    }
							                    return;
							                }
							                else if(checkForOthersGroup && dimension.ungroupedLabel === filterVal)
							                {
							                    isOthersGroupSelected = true;
							                }
							            });
							            if(isOthersGroupSelected && notFilter)
							            {
							                selectedGroup = {
							                    groupName : filterVal,
							                    groupValues : notFilter.join("&&")
							                };
							            }
							        }
							        return selectedGroup;
							    }

								customReportHolder.executeRestAPI = function(restAPI,callback) {
									if(restAPI.bodyParams && typeof restAPI.bodyParams === "string")
										restAPI.bodyParams = JSON.parse(restAPI.bodyParams);
									/* angular.forEach(restAPI.bodyParams,function(data,key) {
										if(typeof data === "object")
											restAPI.bodyParams[key] = JSON.stringify(data);
									});  */

									$http({
									      method : restAPI.type,
									      url : restAPI.url,
										  data : JSON.stringify(restAPI.bodyParams),
										  headers: {"Content-Type": "application/json"}
									  }).then(function(resp) {
									  	  resp = resp.response ? resp.response : (resp.data ? resp.data : resp);
									     callback(resp);
									  }, function(resp) {
									    callback(resp);
									  });

								}

								customReportHolder.assignValToStringVariable = function(scope,variableName,value) {
							        let properties = variableName.split("."),
							        noOfProps = properties.length;
							        if(noOfProps > 1) {
							            let lastProperty = properties.pop(),
							            parentElm = scope.$eval(properties.join("."));
							            parentElm[lastProperty] = value;
							        } else {
							            scope[variableName] = value;
							        }
							    }

							    customReportHolder.getDataSetField = function(dataSet,fieldName) {
									let dataSetField;
									angular.forEach(dataSet.fields, function(field, index) {
						                if (field.dataField === fieldName) {
						                    dataSetField = field;
						                    return false;
						                }
						            });
						            return dataSetField;
								}

								//Function to create relative Time Label(Eg: Last 24 Hours) from relative values(Eg: '-PT24H P0D')
								//relativeTime format '<From> <To>'
								customReportHolder.getRelativeLabel = function(relativeTime) {
									var relLabelOptions = {
										"m" : localMsg.customReport.Minutes,
										"W" : localMsg.customReport.Weeks,
										"Q" : localMsg.customReport.Quarters,
										"Y" : localMsg.customReport.Years,
										"M" : localMsg.customReport.Months,
										"D" : localMsg.customReport.Days,
										"H" : localMsg.customReport.Hours
									};

									var relSingularLabelOptions = {
										"m" : localMsg.customReport.Minute,
										"W" : localMsg.customReport.Week,
										"H" : localMsg.customReport.Hour,
										"D" : localMsg.customReport.Day,
										"M" : localMsg.customReport.Month,
										"Q" : localMsg.customReport.Quarter,
										"Y" : localMsg.customReport.Year
									};
									var relativeLabel, relUnitLabel, relValue, relOptionLabel; //Example :- relativeLabel : "Last 24 Hours", relUnitLabel : "Last", relValue : 24, relOptionLabel : "Hours"
									var times = relativeTime.split(" ");
									var timeStart = times[0]
									var timeEnd = times[1];

									var timeValue;
									if (timeStart.indexOf("-P") == 0) {
										relUnitLabel = localMsg.customReport.Last;
										timeValue = timeStart;
									}else if(timeStart.indexOf("-R") == 0){
										relUnitLabel = localMsg.customReport.Previous;
										timeValue = timeStart;
									} else {
										relUnitLabel = localMsg.customReport.Next;
										timeValue = timeEnd;
									}
									var startIndex = timeValue.indexOf("P") == 0 ? 1 : 2;
									var endIndex = 1;
									var isTimeUnit = timeValue.indexOf("T") !== -1 ? true : false;
									if (isTimeUnit) {
										startIndex++;
									}
									relValue = parseInt(timeValue.substring(startIndex, timeValue.length - endIndex));
									var relOption = timeValue.substring(timeValue.length - endIndex);
									relOptionLabel = relValue == 1 ? relSingularLabelOptions[relOption]
											: relLabelOptions[relOption]; //If value is 1, singular label should be used
									if (isTimeUnit && relOption === "M") { //Defensive check : If timeunit,then 'm' should have been in lowercase (to denote minute)
										relOptionLabel = relValue == 1 ? relSingularLabelOptions['m']
												: relLabelOptions['m'];
									}
									relativeLabel = relUnitLabel + ' ' + relValue + ' ' + relOptionLabel;
									return relativeLabel;
								}

								//This fucntion gets the supported operators for Map HTML cluster filters
								customReportHolder.getFilterOpsForHtmlCluster = (type) => {
									if(type === undefined)
										return [];
									else {
										type = type.toLowerCase();
										let operators = ['&&','||','==','!='];
									    if(type === 'string')
										    return [...operators,...['empty','!empty']];
									    else if(['integer', 'long', 'short'].indexOf(type) !== -1)
										    return [...operators,...['>=','<=','>','<']];
									}
								}

								return customReportHolder;
							} ]);
})(window);
