(function() {
	'use strict';

	var reports = angular.module("reports");

	reports
			.controller("reportChartCtrl",
					[
							"$scope",
							"reportService",
							"customReportSvc",
							"$interpolate",
							"$timeout",
							"$rootScope",
							"$uibModal",
							"dataSource",
							"$window",
							function($scope, reportService, customReportSvc, $interpolate, $timeout, $rootScope,
									$modal, $dataSource, $window) {
								var exportType = customReportSvc.getParameterByName("exportType");
								var readme = customReportSvc.getParameterByName("readme");
								var accessibilityMode = cv && cv.userPref && cv.userPref.cvAccessibility === '1' ? true
										: false;
								var autoToTimConversion = {
									"MINUTE" : "Minute",
									"HH" : "Hourly",
									"DAY" : "Daily",
									"WEEK" : "Weekly",
									"MONTH" : "Monthly",
									"YEAR" : "Yearly"
								};
								const intervalsObj = {
									"second" : [30],
									"minute" : [1,30],
									"hour" : [1,12],
									"day" : [1,7],
									"month" : [1, 6],
									"year" : [1]
								};
								const unitToGroupMapping = {
									"second": "Second",
									"minute" : "Minute",
									"hour" : "Hourly",
									"day" : "Daily",
									"month" : "Monthly",
									"year" : "Yearly",
									"week" : "Daily"
								};
								const gapMappingForGroups = {
									Hourly: "+1HOUR",
									Daily: "+1DAY",
									Weekly: "+7DAYS",
									Monthly: "+1MONTH",
									Yearly: "+1YEAR"
								}

								var datasetFieldsMap = [];
								if($scope.dataSet) {//for upgrade cases
									angular.forEach($scope.dataSet.fields, function(field) {
										datasetFieldsMap[field.name] = field;
									});
								}

								$scope.setChildScope($scope);
								$scope.dataAvailableForPlot = $scope.component.chartType == "Pie" ||
										$scope.component.chartType == "Donut" ? false : true;
								var isExport = false;
								if (exportType || readme === "true") {
									isExport = true;
								}

								var dates = [ "TimeStamp", "Date" ];
								if ($scope.component.chartType == "TimeSeries") {
									dates.push("Integer");
									dates.push("String");
								}

								if ($scope.component.name && !$scope.component.id) {
									$scope.component.id = angular.copy($scope.component.name);
									$scope.component.name = undefined;
								}

								//  	$scope.component.isDateTime = false;// set this to false for now until time line chart is enabled.
								$scope.cacheId = null;
								$scope.componentLoaded = false;
								$scope.processing = false;
								$scope.labels = [];
								$scope.labelsY = [];
								$scope.tooltipLabels = null;
								$scope.rawData = [];
								$scope.fieldTypeMap = {};
								customReportSvc.setDefaultStyles($scope.component);

								$scope.compareBtnTitle = "Compare";
								$scope.component.showCompare = false;

								$scope.compareNoneOption = {
									                        	 dispName:"None",val:"None"
									                         };

								$scope.compareOptionsMap = {
										"Hourly" : [
							                         $scope.compareNoneOption,
							                         {
							                        	 dispName:"previous 6 hours",val:6
							                         },
							                         {
							                        	 dispName:"previous 12 hours",val:12
							                         },
							                         {
							                        	 dispName:"previous 24 hours",val:24
							                         }
										            ],

										"Daily"	: [
										       	   	 $scope.compareNoneOption,
							                         {
							                        	 dispName:"previous day",val:1
							                         },
							                         {
							                        	 dispName:"previous 7 days",val:7
							                         },
							                         {
							                        	 dispName:"previous 14 days",val:14
							                         }
										       	   ],
										"Weekly" : [
										             $scope.compareNoneOption,
							                         {
							                        	 dispName:"previous week",val:7
							                         },
							                         {
							                        	 dispName:"previous 2 weeks",val:14
							                         }
										            ] ,
										 "Monthly" : [
										              	 $scope.compareNoneOption,
								                         {
								                        	 dispName:"previous month",val:1
								                         },
								                         {
								                        	 dispName:"previous 3 months",val:3
								                         },
								                         {
								                        	 dispName:"previous 6 months",val:6
								                         }
										              ],
										"Yearly" : [
										             $scope.compareNoneOption,
							                         {
							                        	 dispName:"previous year",val:1
							                         },
							                         {
							                        	 dispName:"previous 3 years",val:3
							                         },
							                         {
							                        	 dispName:"previous 5 years",val:5
							                         }
										            ]
								};

								$scope.compareInfo = {
										selectedCompareOption: $scope.compareNoneOption
								};

								$scope.compareOptions = [];

								//keeps track of the field type of the multi-series column. When column is added or deleted
								//we use this mapping to update the applicable aggregate
								$scope.seriesFieldTypeMap = [];

								/*
								 * For Line charts Line should be continuous with out any drops. Because we are adding zero to normalize the data the line looks dropped.
								 *
								 */
								$scope.supportNullValues = function(){
									return dataSetUtility.supportNullValues($scope.component);
								}

								var defaultMultiChartColors = customReportSvc.defaultMultiChartColors;
								$scope.cvPatterns;
								if (accessibilityMode) {
									$scope.cvPatterns = customReportSvc.patterns;
									//$scope.component.styles.chartPlotOptions.isShowLabels = true;
								}
								var defaultBarSize = 20;
								var stacking = undefined; // not stacked
								var defaultHeight = 350; // $scope.component.chartType == 'Pie' ? 350 : 400;
								var defaultWidth = 1000;

								var numberTypes = [ "Double", "Float", "Integer", "Long", "Short", "Decimal" ];
								var numberOps = [ "Sum", "Min", "Max", "Avg" ];

								$scope.trendOptions = [ {
									"id" : 0,
									"label" : "None"
								}, {
									"id" : 1,
									"label" : "Hourly"
								}, {
									"id" : 2,
									"label" : "Daily"
								}, {
									"id" : 3,
									"label" : "Weekly"
								}, {
									"id" : 4,
									"label" : "Monthly"
								}, {
									"id" : 5,
									"label" : "Quarterly"
								}, {
									"id" : 6,
									"label" : "Yearly"
								} ];

								$scope.component.styles.barSizeAutoOnly = false;
								if (!$scope.component.styles.barColor) {// $scope.component.styles.barColor = "#005371";
									$scope.component.styles.barColor = "#00cee6";
								}

								if (!$scope.component.sorting) {
									$scope.component.sorting = [];
								}

								if ($scope.component.sorting.length == 0) {
									if ($scope.component.chartType == "Line" || $scope.component.chartType == "Bar") {
										$scope.component.sorting.push({
											direction : 'Desc',
											sortAxis : 'XAxis'
										});
									} else {
										$scope.component.sorting.push({
											direction : 'Desc',
											sortAxis : 'YAxis'
										});
									}
								} else {
									angular.forEach($scope.component.sorting, function(sorting) {
										if (!sorting.sortAxis) {
											sorting.sortAxis = 'XAxis';
										}
									});
								}

								if ($scope.component.dimensionDataField) {
									angular.forEach($scope.component.dimensionDataField, function(field, index) {
										if(!field.type && datasetFieldsMap.hasOwnProperty(field.column))//for upgrade cases
											field.type = datasetFieldsMap[field.column].type;
										if (!field.numPointsToDisplay) {
											field.numPointsToDisplay = {};
										}

										if (!field.numPointsToDisplay.maxPoints) {
											if (index == 0) {
												field.numPointsToDisplay.maxPoints = 15;
											} else {
												field.numPointsToDisplay.maxPoints = 10;
											}
										}

										//if ($scope.dataSet.endpoint === 'DATACUBE') {
										if (!field.customGroupsAvailable) {
											field.customGroupsAvailable = false;
										}
										//}

									});
								}
								//imported v1 report does not have showNumberOps set
								if ($scope.component.measureDataField) {
									angular.forEach($scope.component.measureDataField, function(field) {
										if(!field.type && datasetFieldsMap.hasOwnProperty(field.column))//for upgrade cases
											field.type = datasetFieldsMap[field.column].type;
										if (field.showNumberOps == undefined) {
											if (field.aggrType === "Sum" || field.aggrType === "Min" ||
													field.aggrType === "Max" || field.aggrType === "Avg") {
												field.showNumberOps = true;
											} else {
												field.showNumberOps = false;
											}
										}
									});
								}

								//===========END of default values =============
								$scope.disableYDrop = ($scope.component.categoryFields && $scope.component.categoryFields.length > 0) ? false
										: true;
								$scope.chartConfig = getChartConfig();

								/*
								 * if ($scope.component.styles.width == -1 || $scope.component.styles.width ==
								 * "") $scope.chartConfig.size.width = defaultWidth; else
								 * $scope.chartConfig.size.width=$scope.component.styles.width;
								 */

								customReportSvc.registerCallback("redrawAllComponents", function(data, isAutoRefresh) {
									// for time line chart the filters can be applied to self when user zooms into the component.
									if ($scope.component.chartType !== "TimeSeries" &&  ((data && data.id === $scope.component.id) ||
											($scope.dataSet.endpoint !== 'DATACUBE' && !dataSetUtility
													.checkIffiltercanBeApplied(data, $scope.dataSet)))) {
										return false;
									}
									$scope.cacheId = null;
									$scope.processing = true;
									$scope.drawChart(isAutoRefresh);
									$timeout(function() {
										$scope.processing = false;
									});
								}, $scope.component.id);

								customReportSvc.registerCallback("redrawOtherComponents", function(srcCompId) {
									if ($scope.component.id !== srcCompId) {
										$scope.cacheId = null;
										$scope.processing = true;
										$scope.drawChart();
										$timeout(function() {
											$scope.processing = false;
										});
									}
								});

								$scope.getHeight = function() {
									if ($scope.component.quickChartHeight) {
										return $scope.component.quickChartHeight;
									}
									var chartHeight = $("[comp=" + $scope.component.id + "]>div").height();
									/*if ($scope.reportMode == 'builder') {
										chartHeight = chartHeight - 150;
									} else {*/
										if ($scope.isFullScreen) {
											chartHeight = chartHeight - 100;
										} else {
											chartHeight = chartHeight - 60;
										}
									//}
								}

								//Code has not yet used; feature is yet to be integrated
								$scope.showFilteredValues = function(e, type) {
									$scope.component.filterType = type;
									var component = $scope.component;
									var filterParam = component.dimensionDataField[0].column;
									var filterType = component.filterType;
									$scope.component.tempFilters = [];
									// $scope.component.tempFilters[filterParam] = {};
									// $scope.component.tempFilters[filterParam][filterType] = [];
									// $scope.component.filterValues = $.extend(true, [], $scope.chartConfig.xAxis.categories);
									var options = {
										operationType : 'get',
										initialValues : $scope.chartConfig.xAxis.categories,
										searchQuery : '',
										start : 0,
										offset : 15
									};

									// in case filterType is include get rest of values from rest api call
									$dataSource.getDataSource($scope.dataSet.endpoint).getXaxisCategories(options,
											function(response) {
												$scope.component.filterValues = response;
											});

									if (!$.isEmptyObject(filters[filterParam]) &&
											!$.isEmptyObject(filters[filterParam][type])) {
										$scope.component.tempFilters = $.extend(true, [], filters[filterParam][type]);
									}
									$scope.modalInstance = $modal.open({
										templateUrl : "templates/filterPanel.jsp",
										size : "sm",
										controller : "reportChartCtrl",
										backdrop : 'static',
										scope : $scope
									});
									// $scope.modalInstance.result.then(function(){

									// }, function () {

									// });
									e.stopImmediatePropagation();
									e.preventDefault();
								};

								$scope.addUpdatedFilters = function() {
									// $uibModalInstance.close($scope.selected.item);
									var component = $scope.component;
									// filters[component.dimensionDataField[0].column][component.filterType] = $scope.component.tempFilters;
									$scope.addFilters(component.dimensionDataField[0].column,
											component.tempFilters,
											$scope.component,
											true,
											true,
											[],
											undefined,
											"viewer",
											"include",
											true);
									$scope.dismissModal();
								};

								$scope.updateFilters = function(filterVal) {
									var component = $scope.component;
									var filterParam = component.dimensionDataField[0].column;
									var filterType = component.filterType;
									if (component.tempFilters.indexOf(filterVal) == -1) {
										component.tempFilters.push(filterVal);
									} else {
										component.tempFilters.splice(filterVal, 1);
									}
								};

								$scope.dismissModal = function() {
									delete $scope.component.filterType;
									delete $scope.component.tempFilters;
									$scope.modalInstance.dismiss();
								};

								$scope.reloadComponent = function(refreshCache) {
									$scope.getChartData();
								};

								$scope.chartOptions = function(option) {
									if (option !== 'download') {
										console.error("Only download option is supported");
										return;
									}
									if ($scope.chartConfig && typeof $scope.chartConfig.getHighcharts === 'function') {
										var savedChart = angular.copy($scope.chartConfig); //Saving initial chart configuration
										var chart = $scope.chartConfig.getHighcharts();
										if ($scope.component && $scope.component.title && $scope.component.title.text) {
											if (!$scope.chartConfig.title) {
												$scope.chartConfig.title = {};
											}
											$scope.chartConfig.title.text = $scope.component.title.text;
										}
										chart.redraw();
										setTimeout(function() {
											chart.exportChart(); //Downloads chart as image
											$scope.chartConfig = savedChart;
											chart.redraw();
										}, 100);

									}
								}
								$scope.updateComponentFields = function(dataSet) {
									//check for the name of the dataset. Data Set name might have changed, so check with old dataset name.
									if ($scope.component.dataSet &&
											dataSet.dataSet.originalDataSetName === $scope.component.dataSet.dataSetName) {
										var isRefreshRequired = false;
										// set the new name
										$scope.component.dataSet.dataSetName = dataSet.dataSet.dataSetName;
										$scope.dataSet = dataSet;
										angular.forEach($scope.dataSet.fields, function(field) {
											for (var i = 0; i < $scope.component.dimensionDataField.length; i++) {
												var dimension = $scope.component.dimensionDataField[i];
												if (field.originalName !== field.name &&
														dimension.column === field.originalName) {
													dimension.column = field.name;
													isRefreshRequired = true;
													break;
												}
											}
											for (var i = 0; i < $scope.component.measureDataField.length; i++) {
												var measure = $scope.component.measureDataField[i];
												if (field.originalName !== field.name &&
														measure.column === field.originalName) {
													measure.column = field.name;
													isRefreshRequired = true;
													break;
												}
											}
										});
										if (isRefreshRequired) {
											$scope.getChartData();
										}
									}
								}

								customReportSvc.registerCallback("dataSetDeleted", function(dataSet) {
									if (dataSet.dataSet.dataSetName == $scope.component.dataSet.dataSetName) {
										$scope.deleteComponentByName($scope.component.id);
									}
								});

								$scope.convertTimeStamptoGroupingValue = function(data, grouping, onlyTimeInfo) {
									if($scope.dataSet.endpoint === 'DATACUBE')
										grouping = $scope.timeGrouping ? $scope.timeGrouping : $scope.component.dimensionDataField[0].timeGrouping;
									else {
										grouping =  $scope.component.dimensionDataField[0].timeGrouping === "auto"
										&& grouping ? autoToTimConversion[grouping.toUpperCase()]
										: $scope.component.dimensionDataField[0].timeGrouping
									}
									var months = [
											"Jan",
											"Feb",
											"Mar",
											"Apr",
											"May",
											"Jun",
											"Jul",
											"Aug",
											"Sep",
											"Oct",
											"Nov",
											"Dec" ];
									var formattedDateString = "";
									if (data && data != "") {
										var thisdate = moment(data);
										if(customReports.honorLocaleDate){
											let locale = rpt.getLocale();
											if(locale === "zh"){
												locale = "zh-cn";
											}
											thisdate = moment(data).locale(locale);
										}
										var month = thisdate.format('MMM');
										var year = thisdate.year();
										var day = thisdate.date();
										var hours = thisdate.hours()
										var minutes = thisdate.format("mm")
										var seconds = thisdate.format("ss")
										if (onlyTimeInfo && onlyTimeInfo.onlyTimeField &&
												onlyTimeInfo.onlyTimeField == true) {
											if (onlyTimeInfo.displayTimeInLocalTimeZone) {
												formattedDateString = hours + ":" + minutes +
														":" + seconds;
											} else {
												formattedDateString = thisdate.utc().hours() + ":" +
														thisdate.utc().minutes() + ":" + thisdate.utc().seconds() +
														"." + thisdate.utc().milliseconds();
											}
											return formattedDateString;
										}
										switch (grouping) {
										case "Minute":
											var unit = "";
											if (hours == 0) {
												unit = " Midnight";
											} else if (hours < 12) {
												unit =" AM";
											} else if (hours == 12) {
												unit = " Noon";
											} else {
												hours = (hours - 12) ;
												unit =  " PM";
											}
											formattedDateString = month + ' ' + day + ', ' + year + " " + hours +
													":" + minutes + ":" + seconds + unit;
											break;
										case "Hourly":
											var hourstr = "";
											if (hours == 0) {
												hourstr = "Midnight";
											} else if (hours < 12) {
												hourstr = hours + " AM";
											} else if (hours == 12) {
												hourstr = "Noon";
											} else {
												hourstr = (hours - 12) + " PM";
											}
											formattedDateString = month + ' ' + day + ', ' + year + " " + hourstr;
											break;
										case "Daily":
											formattedDateString = month + ' ' + day + ', ' + year;
											break;
										case "Weekly":
											formattedDateString = month + ' ' + day + ', ' + year;
											break;
										case "Monthly":
											formattedDateString = month + " " + year;
											break;
										case "Yearly":
											formattedDateString = year;
											break;
										default:
											var unit = "";
											if (hours == 0) {
												unit = " Midnight";
											} else if (hours < 12) {
												unit =" AM";
											} else if (hours == 12) {
												unit = " Noon";
											} else {
												hours = (hours - 12) ;
												unit =  " PM";
											}
											formattedDateString = month + ' ' + day + ', ' + year + " " + hours +
													":" + minutes + ":" + seconds + unit;
											break;
										}
									}
									return formattedDateString;
								}

								function getChartConfig() {

									Highcharts.setOptions({
										lang : {
											thousandsSep : ','
										}
									});
									var chartConfig = {
										options : {
											chart : {
												type : "column",
												zoomType : 'x',
												// backgroundColor: "transparent",
												animation : isExport ? false : true,
												events : {
													click : null,
													selection : null,
													redraw : function(event) {
														$scope.$emit('chartRedraw', [ $scope.component.id ]);
													}
												},
												options3d : {
													enabled : false,
													alpha : 15,
													beta : 20,
													depth : 110
												},
												showAxes : true,
												interactiveEnabled : false
											},
											 title:{
											        text:''
											},
											 subTitle:{
											        text:''
											},
											exporting : {
												enabled : false
											},
											legend : {
												enabled : true,
												align : 'right',
												layout : 'vertical',
												verticalAlign : 'middle',
												itemStyle : {
													fontWeight : 'normal',
												},
												labelFormatter : function() {
													var label = this.name;
													if (this.y) {
														label = label + " (" + this.y + ")";
													}
													return label;
												},
											// useHTML:true,    // Prior to 4.1.7, when using HTML, legend.navigation was disabled. (https://github.com/highcharts/highcharts/issues/1249)
											},
											colors : defaultMultiChartColors,
											tooltip : {
												headerFormat : '',
												useHTML : true,
												pointFormat : '<span style="font-size: 14px">{point.xlabel} : {point.name}</span><br/><span style="font-size: 14px">{point.slabel}  {point.svalue} </span><br/><span style="font-size: 14px">{point.ylabel} : {point.formattedY}</span><br/>',
												dateTimeLabelFormats : {
													//			            	millisecond: '%H:%M:%S.%L',
													second : '%l:%M:%S %p',
													minute : '%b %e, %l:%M %p',
													hour : '%b %e, %l:%M %p',
													day : '%b %e, %Y %l:%M %p',
													week : '%b %e',
													month : '%b %e',
													year : '%Y'
												}
											},
											credits : {
												enabled : false
											},
											plotOptions : {
												series : {
													connectNulls: $scope.supportNullValues() ? true : false,
													dataLabels : {
														allowOverlap : true
													},
													animation : isExport ? false : true,
													cursor : 'pointer',
													states : {
														select : {
															color : null,
															fillColor : null,
															borderColor : null
														}
													},
													point : {
														events : {
															select : null,
															unselect : null
														}
													},
												},

												bar : {
													events : {
														legendItemClick : null
													}
												},
												column : {
													events : {
														legendItemClick : null
													},
													depth : 40,
													stacking : true,
													grouping : false,
													groupZPadding : 30,
												},
												pie : {
													dataLabels : {
														enabled : false,
														format : undefined
													},
													depth : 40,
													style : {
														"color" : "black",
														"fontSize" : "11px",
														"fontWeight" : "500"
													},
													showInLegend : true,
													point : {
														events : {
															legendItemClick : null
														}
													}
												},
												line : {
													lineWidth : 1,
													marker : {
														states : {
															hover : {
																enabled : false
															},
															select : {
																fillColor : null,
																lineWidth : 0,
																radius : 6
															}
														}
													},
													dataLabels : {
														enabled : false,
														format : undefined
													}
												},
												spline : {
													dataLabels : {
														enabled : false,
														format : undefined
													}
												}
											},
											defs : {
												patterns : []
											}

										},
										title : {
											text : undefined
										},
										series : [],
										xAxis : {
											//						categories:$scope.chartPointLabels,
											title : {
												style : {
													fontWeight : "500",
													fontFamily : '"Open Sans", "Segoe UI", Helvetica, Arial, sans-serif"'
												}

											},
											dateTimeLabelFormats : {
												millisecond : '%l:%M:%S %L',
												second : '%l:%M:%S',
												minute : '%l:%M',
												hour : '%l:%M%p',
												day : '%b %e',
												week : '%b %e',
												month : '%b %Y',
												year : '%Y'
											},
											gridLineWidth : 1,
											gridLineDashStyle : 'Dot',
											labels : {
												style : {
													width : 'auto'
												},
												useHTML : true,
												step : 1
											},
											tickmarkPlacement : 'on'
										},
										yAxis : {
											title : {
												style : {
													fontWeight : "500",
													fontFamily : '"Open Sans", "Segoe UI", Helvetica, Arial, sans-serif"'
												}

											},
											gridLineDashStyle : 'Dot',
											lineWidth : 1,
											labels : {
												style : {
													width : 'auto'

												},
												formatter : null,
												useHTML : true
											},
											allowDecimals : false
										//min:0  - allow negative values
										},

										lang : {
											noData : "No chartable data."
										},
										loading : false,
										noData : true,
										func : function(chart) {
											$timeout(function() {
												if ($scope.chartConfig &&
														typeof $scope.chartConfig.getHighcharts === 'function') {
													var chart = $scope.chartConfig.getHighcharts();
													chart.reflow();
												}
											}, 0);
										}
									}

									if($scope.component.showTopRightTooltip) {
										chartConfig.options.tooltip.positioner = function (labelWidth, labelHeight, point) {
													let chart = this.chart;
		    										let plotRight = chart.plotLeft + chart.plotWidth;
			   										let x = plotRight - labelWidth;
			   										return {
			   											x,
			   											y: chart.plotTop
			   										}
			   									}
									}
									return chartConfig;
								}

								$scope.getFormattedValue =  function(value, formatter, row, rowIndex, columnIndex, col, dataSet) {
									var formattedValue = customReportSvc.getFormattedValue(value, formatter, undefined, undefined, undefined,col,dataSet);
									if(!formattedValue){
										formattedValue = value;
									}
									return formattedValue;
								}
								/*
								 * get formatted value for tabular data get the corresponding formatter based
								 * on the value index
								 */
								$scope.getFormattedValueTabularData = function(val, index) {
									var dimensionLength = $scope.component.dimensionDataField.length;
									var measureLength = $scope.component.measureDataField.length;
									var column;
									if (index < dimensionLength) {
										column = $scope.component.dimensionDataField[index];
									} else if (index - dimensionLength < measureLength) {
										column = $scope.component.measureDataField[index - dimensionLength];
									} else {
										return val;
									}

									return $scope.getFormattedValue(val,
											column.formatter,
											undefined,
											undefined,
											undefined,
											column,
											$scope.dataSet);
								};
								$scope.isHiddenColumn = function(index) {
									var dimensionLength = $scope.component.dimensionDataField.length;
									var measureLength = $scope.component.measureDataField.length;
									var hideColumn;
									if (index < dimensionLength) {
										hideColumn = $scope.component.dimensionDataField[index].hideColumn;
									} else if (index - dimensionLength < measureLength) {
										hideColumn = $scope.component.measureDataField[index - dimensionLength].hideColumn;
									} else {
										return false;
									}
									return hideColumn;
								};

								$scope.calculateMaxDateBasedOnGrouping = function(maxDate, timeGrouping) {
									/*if user is selecting some range then because of grouping it may happen that max range won't
									have all values shown for that exact same grouping time	so instead of sending exact time send the +1 value based on group.
									For e.g. if time grouping is yearly and	user is selecting 2015 and 2016 then we should get records for both 2015 and 2016.
									but if we send filter with start as 2015 group time and end as 2016 group time then for 2016 group will get only values with exact group time
									and not all values for 2016 group. so adding one more year to end date and sending filter query with max range exclusion */
									const groupInterval = $scope.groupInterval ? $scope.groupInterval : 1;
									switch(timeGrouping) {
										case "Second" :
											maxDate.setSeconds(maxDate.getSeconds() + groupInterval);
											break;
										case "Minute" :
											maxDate.setMinutes(maxDate.getMinutes() + groupInterval);
											break;
										case "Hourly" :
											maxDate.setHours(maxDate.getHours() + groupInterval);
											break;
										case "Daily" :
											maxDate.setDate(maxDate.getDate() + groupInterval);
											break;
										case "Weekly" :
											maxDate.setDate(maxDate.getDate() + 7);
											break;
										case "Monthly" :
											maxDate.setMonth(maxDate.getMonth() + groupInterval);
											break;
										case "Yearly" :
											maxDate.setYear(maxDate.getYear() + groupInterval);
											break;

									}
									return maxDate;
								}

								$scope.stopAutoRefresh = () => {
									$scope.page.body.autoRefresh = false;
									$scope.startAutoRefreshTimer();
									//if user has disabled/stopped auto refresh manually then we should not start it on filter clear
									//setting this flag on range selection. It will be checked while clearing the range selection
									$scope.startAutoRefreshOnFilterClear = true;
								}

								$scope.getTimeRangeFilter = (filterValues) => {
									let minDate;
									let maxDate;
									let dimension = $scope.component.dimensionDataField[0];
									let isSinglePoint = filterValues.length === 1;
									const timeGrouping = $scope.timeGrouping ? $scope.timeGrouping : dimension.timeGrouping;
									if(isSinglePoint) {
										maxDate = new Date(filterValues[0]);
										minDate =  new Date(filterValues[0]);
									} else {
										const dateFilters = filterValues.map(val =>  new Date(val));
										minDate = dateFilters.reduce(function (date1, date2) { return date1 < date2 ? date1 : date2; });
										maxDate = dateFilters.reduce(function (date1, date2) { return date1 > date2 ? date1 : date2; });
									}
									let filterVal = {
										from : minDate,
										to : $scope.calculateMaxDateBasedOnGrouping(maxDate, timeGrouping),
										excludeEnd :  timeGrouping !== "none"
									};
									$scope.isTimeRangeFilter = true;
									//stop auto refresh when time range filter is applied
									if($scope.page.body.isAutoRefreshShow && $scope.page.body.autoRefresh) {
										$scope.stopAutoRefresh();
									}
									$scope.minDate = minDate;
									$scope.maxDate = maxDate;

									if ($scope.dataSet.endpoint !== 'DATACUBE') {
										let endOperator = filterVal.excludeEnd ? "<" : "<=";
										let filterQuery = ">=" + filterVal.from.toISOString().split('.')[0] + 'Z' + " AND " +
										endOperator + filterVal.to.toISOString().split('.')[0] + 'Z';
										return filterQuery;
									}

									return filterVal;
								}
								$scope.selectPointsByDrag = function(e) {
									var that = this;
									var selectedGroups = [];
									var dimension = $scope.component.dimensionDataField[0];
									let isMultiple = true;
									$timeout(function() {
										var filterParam = $scope.component.dimensionDataField[0].column;
										var filterVal;
										// var filtersToRemove = { filterParam: "" , filterVals: []};
										var filtersToAdd = {
											filterParam : "",
											filterVals : []
										};

										if($scope.component.chartType === "TimeSeries") {
											const selectedRange = e.xAxis[0];
											const min = selectedRange.min;
											const max = selectedRange.max;
											let filterValues = [];
											// reverse engineer the last part of the data
											$.each(that.series[0].data, function () {
													if (this.x >= min && this.x <= max)
														filterValues.push(this.originalXVal);
											});
											if(filterValues.length) {
												filtersToAdd.filterParam = filterParam;
												filtersToAdd.filterVals = $scope.getTimeRangeFilter(filterValues);
												isMultiple = false;
											}
										} else {
											Highcharts.each(that.series, function(series) {
												Highcharts.each(series.points, function(point) {
													filterVal = point.category;
													if(dimension.formatter && Array.isArray(point.dimensionValues) && point.dimensionValues.length)
														filterVal = point.dimensionValues[0];

													if($scope.dataSet.endpoint === 'DATACUBE' && filterVal === "") {
														filterVal = qb.rv.getQueryForEmptyVal();
													}

													if (point.x >= e.xAxis[0].min && point.x <= e.xAxis[0].max) {
														filtersToAdd.filterParam = filterParam;
														if (filtersToAdd.filterVals.indexOf(filterVal) == -1) {
															if (typeof dimension.groups != 'undefined' &&
																	dimension.groups.length > 0) {
																let groupVals = "",
																urlParams = customReportSvc.getUrlParams(),
																customInputs = customReportSvc.getCustomInputs(urlParams,$scope.page.inputs),
																selectedGroup = customReportSvc.getSelectedCustomGroupObject(dimension, filterVal,customInputs);
																selectedGroups.push(selectedGroup);
																groupVals = selectedGroup.groupValues;
																filterVal = (groupVals || "").split(',');
															}
															filtersToAdd.filterVals.push(filterVal);
														}
													}
												});
											});
										}


										if (selectedGroups.length == 0) {
											selectedGroups = undefined;
										}

										if ($scope.dataSet.endpoint !== 'DATACUBE') {
											$scope.clearOptionEnabled = true;
										}
										if(filtersToAdd.filterVals.length !== 0) {
											$scope.addFilters(filtersToAdd.filterParam,
												filtersToAdd.filterVals,
												$scope.component,
												isMultiple,
												true,
												selectedGroups,
												undefined,
												"viewer",
												"include",
												true);
										}

									});
									return false;
								}

								$scope.legendSelect = function(event) {
									$scope.pointSelect(event);
									if (event.stopImmediatePropagation) {
										event.stopImmediatePropagation();
									}
									event.preventDefault();
									return false;
								}
								$scope.pointSelect = function(event) {
									if ($scope.component.isQuickAnalysis) {
										return;
									}
									$timeout(function() {
										var filterVal = "";
										var chart = $scope.chartConfig.getHighcharts();
										var isHeatMap = false;
										let isMultiple = true;
										if ($scope.component.chartType === 'heatmap') {
											filterVal = {}; // in  case of heatmap filterVal = { dimension1: value, dimension2: value}
											filterVal[$scope.component.dimensionDataField[1].column] = event.target.name;
											filterVal[$scope.component.dimensionDataField[0].column] = chart.axes[1].categories[event.target.y];
											isHeatMap = true;
										} else if ($scope.component.chartType === 'treemap' &&
												$scope.component.dimensionDataField.length == 2) {
											filterVal = {};
											filterVal[$scope.component.dimensionDataField[0].column] = event.target.name;
											filterVal[$scope.component.dimensionDataField[1].column] = event.target.svalue;
											isHeatMap = true;
										} else if($scope.component.chartType === "TimeSeries") {
											filterVal = $scope.getTimeRangeFilter([event.target.originalXVal]);
											isMultiple = false;
										}

										/*
										 * else if (($scope.dataSet.endpoint !== 'DATACUBE' &&
										 * $scope.component.dimensionDataField.length > 1)) { filterVal = {};
										 * filterVal[$scope.component.dimensionDataField[0].column] =
										 * event.target.name;
										 * filterVal[$scope.component.dimensionDataField[1].column] =
										 * event.target.series.name; }
										 */else {
											const isEmptyValue = $scope.dataSet.endpoint === 'DATACUBE' && event.target.name === "";
											filterVal = isEmptyValue ? qb.rv.getQueryForEmptyVal() : event.target.name;
										}
										if ($scope.dataSet.endpoint === 'DATACUBE') {
											if (isHeatMap) {
												addFilter({
													'column' : "tuples_" + $scope.component.id
												}, filterVal);
											} else {
												addFilter($scope.component.dimensionDataField[0], filterVal, isMultiple);
											}
										} else {
											if (filterVal !== '$Other$') {
												$scope.clearOptionEnabled = true;
												$scope.addFilters($scope.component.dimensionDataField[0].column,
														filterVal,
														$scope.component,
														isMultiple,
														true,
														[],
														undefined,
														"viewer",
														"include",
														true);
											}

										}
										event.preventDefault();
									});
									return false;
								};

								var addFilter = function(dimension, filterVal, isMultiple) {
									let urlParams = customReportSvc.getUrlParams(),
									customInputs = customReportSvc.getCustomInputs(urlParams,$scope.page.inputs),
									selectedGroup = customReportSvc.getSelectedCustomGroupObject(dimension, filterVal,customInputs),
									filterParam = dimension.column;
									if(selectedGroup)
										filterVal = selectedGroup;
									$scope.addFilters(filterParam,
											filterVal,
											$scope.component,
											isMultiple !== false,
											true,
											[selectedGroup],
											undefined,
											"viewer",
											"include",
											true);
								}


								$scope.getNoOfCompareTimeRanges = function(records){
									var startRange = undefined;
									var noOftimeranges = 0;
									for(var i=0;i<records.length;i++)
									{
										if(startRange == records[i][0])
											break;

										if(startRange == undefined)
											startRange = records[i][0];

										noOftimeranges++;
									}
									return noOftimeranges;
								}

								$scope.convertCompareDataToSeriesData = function(data) {
									var records = data.records;
									//var columns = data.columns;
									var returnData = {};
									var labels = [];
									var xValues = [];
									var chartData = [];

									var noOfCompareTimeRanges = $scope.getNoOfCompareTimeRanges(records);

									for(var i=0;i<noOfCompareTimeRanges;i++){
										labels.push("Range_" + i);
										var seriesObject = {
											name : "Range_" + i,
											data : []
										};
										chartData.push(seriesObject);
									};

									var startRange = undefined;
									var seriesIndex = 0;
									var currTimeGroup = data.timeGroup;
									var timeGroupMapForMoment = {
											'hh' : "hour",
											"day" : "days",
											"month" : "month",
											"year" : "year",
											"week" : "week"
									}

									angular
											.forEach(records,
													function(row, i) {
														if(startRange == undefined)
															startRange = row[0];

															var xValue = row[1];
															var formattedDateTime = row[1];
															var epochVal = row[1];
															if ($scope.component.isTimeGrouping === true) {
																formattedDateTime = $scope.convertTimeStamptoGroupingValue(row[1],
																	currTimeGroup);
																row[1] = formattedDateTime;
																if ($scope.component.dimensionDataField[0].timeGrouping == "Weekly") {
																	row[1] = "Week of " + formattedDateTime;
																}
															}

											if(startRange == row[0])
											{
												seriesIndex = 0;
												xValues.push($scope.getFormattedValue(formattedDateTime,
														$scope.component.dimensionDataField[0].formatter,
														undefined,
														undefined,
														undefined,
														$scope.component.dimensionDataField[0],
														$scope.dataSet));
											}
											else
												seriesIndex++;

																			var column = $scope.component.measureDataField[0];
																			var formattedY = $scope
																					.getFormattedValue(row[2],
																							column.formatter,
																							undefined,
																							undefined,
																							undefined,
																							column,
																							$scope.dataSet);
																			var data = {
																				name : row[1],
																				y : row[2],
																				xlabel : $scope.component.xAxisTitle.text,
																				ylabel : $scope.component.yAxisTitle.text,
																				formattedY : formattedY,
																				formattedName : formattedDateTime,
																				dateValEpoch : epochVal
																			};
																			chartData[seriesIndex].data.push(data);
													});
									returnData.labels = labels;
									returnData.chartData = chartData;
									returnData.xvalues = xValues;

									if(chartData){
										for(var i=0;i<chartData.length;i++){
											var currSeries = chartData[i];
											currSeries.name = currSeries.data[0].formattedName + " to " + $scope.convertTimeStamptoGroupingValue(moment(new Date(currSeries.data[currSeries.data.length - 1].dateValEpoch)).add(1,timeGroupMapForMoment[currTimeGroup.toLowerCase()]).toDate().getTime(),currTimeGroup);
										}
									}


									return returnData;
								};

								$scope.convertDataToSeriesData = function(data) {
									var records = data.records;
									//var columns = data.columns;
									var returnData = {};
									var labels = [];
									var xValues = [];
									var chartData = [];
									angular.forEach($scope.component.measureDataField, function(field) {
										labels.push(field.title.text);
										var seriesObject = {
											name : field.title.text,
											data : []
										};
										chartData.push(seriesObject);
									});

									angular
											.forEach(records,
													function(row, i) {
														var xValue = row[0];
														const originalXVal = xValue;
														if ($scope.component.isTimeGrouping === true) {
															xValue = $scope.convertTimeStamptoGroupingValue(row[0],
																data.timeGroup);
															row[0] = xValue;
															if ($scope.component.dimensionDataField[0].timeGrouping == "Weekly") {
																row[0] = "Week of " + xValue;
															}
														}
														xValues.push($scope.getFormattedValue(xValue,
																$scope.component.dimensionDataField[0].formatter,
																undefined,
																undefined,
																undefined,
																$scope.component.dimensionDataField[0],
																$scope.dataSet));
														angular
																.forEach(chartData,
																		function(series, j) {
																			var column = $scope.component.measureDataField[j];
																			var formattedY = $scope
																					.getFormattedValue(row[j + 1],
																							column.formatter,
																							undefined,
																							undefined,
																							undefined,
																							column,
																							$scope.dataSet);
																			var data = {
																				name : row[0],
																				originalXVal,
																				y : row[j + 1],
																				xlabel : $scope.component.xAxisTitle.text,
																				ylabel : $scope.component.measureDataField[j].title.text,
																				formattedY : formattedY,
																				formattedName : $scope
																						.getFormattedValue(row[0],
																								$scope.component.dimensionDataField[0].formatter,
																								undefined,
																								undefined,
																								undefined,
																								$scope.component.dimensionDataField[0],
																								$scope.dataSet),
																				dimensionValues : row.slice(0, 1),
																				measureValues : row.slice(1)
																			};
																			series.data.push(data);
																		});
													});
									returnData.labels = labels;
									returnData.chartData = chartData;
									returnData.xvalues = xValues;
									return returnData;
								};

								var doTreeMapSeries = function(data, labels, xValues, labelsY, seriesObject, chartData) {
									if ($scope.component.chartType == "treemap") {

										if ($scope.dataSet.endpoint != 'DATACUBE') {

											data = customReportSvc.convertCR2DataToDataCubeModel(data,
													$scope.component.dimensionDataField,
													$scope.component.measureDataField)
										}
										var records = data.records, moreInfo = data.moreInfo, xCategories = {}, yCategories = {}, xValueKeys = [];
										angular.forEach(moreInfo, function(info, key) {
											var keyMap = {};
											if ($.isEmptyObject(info.keyMap)) {
												angular.forEach(info.values, function(val) {
													keyMap[val] = val;
												});
											} else {
												keyMap = info.keyMap;
											}
											if ($scope.component.dimensionDataField &&
													key === $scope.component.dimensionDataField[0].column) {
												angular.copy(keyMap, xCategories);
											} else if ($scope.component.dimensionDataField &&
													$scope.component.dimensionDataField.length > 1 &&
													key === $scope.component.dimensionDataField[1].column) {
												angular.copy(keyMap, yCategories);
											}

										});

										angular
												.forEach(xCategories,
														function(label, key) {
															var labelX = label;
															if ($scope.component.isTimeGrouping === true) {
																labelX = $scope.convertTimeStamptoGroupingValue(label,
																		data.timeGroup);
															}

															labels.push(labelX.toString());
															xValues.push(labelX.toString());
															xValueKeys.push(key.toString());
														});

										angular.forEach(yCategories, function(label, key) {
											labelsY.push(label.toString());
										});
										constructTreemapWithLevel(records,
												seriesObject,
												chartData,
												xCategories,
												yCategories);
										return true;
									}
									return false;
								}

								/*
								 * Special case for heatmap. formatting series data into (x,y,value)
								 */
								var doHeatMapSeries = function(data, labels, xValues, labelsY, seriesObject, chartData) {
									var records = data.records, x = $scope.component.heatMapRow, y = $scope.component.heatMapColumn, moreInfo = data.moreInfo, recordSeek = 0, xCategories = {}, yCategories = {}, xValueKeys = [];

									var isTreemap = $scope.component.dimensionDataField.length == 1;

									angular.forEach(moreInfo, function(info, key) {
										var keyMap = {};
										if ($.isEmptyObject(info.keyMap)) {
											angular.forEach(info.values, function(val) {
												keyMap[val] = val;
											});
										} else {
											keyMap = info.keyMap;
										}
										if ($scope.component.heatMapColumn &&
												key === $scope.component.heatMapColumn.column) {
											angular.copy(keyMap, xCategories);
										} else if ($scope.component.heatMapRow &&
												key === $scope.component.heatMapRow.column) {
											//hack for now
											angular.copy(keyMap, yCategories); // keyMap is empty for y-axis
										}

									});

									angular
											.forEach(xCategories,
													function(label, key) {
														var labelX = label;
														if ($scope.component.isTimeGrouping === true) {
															labelX = $scope.convertTimeStamptoGroupingValue(label,
																	data.timeGroup);
														}

														labels.push(labelX.toString());
														xValues.push(labelX.toString());
														xValueKeys.push(key.toString());
													});

									angular.forEach(yCategories, function(label, key) {
										labelsY.push(label.toString());
									});

									angular.forEach(records, function(record, i) {
										var heatMapObj = {};
										heatMapObj.y = i;

										heatMapObj.slabel = record[$scope.component.heatMapRow.column];
										var counter = 0;
										angular.forEach(record, function(value, key) {
											if (key != $scope.component.heatMapRow.column &&
													xValueKeys.indexOf(key) >= 0) {
												var dataRecord = angular.copy(heatMapObj, {});
												dataRecord.x = xValueKeys.indexOf(key);
												dataRecord.value = value;
												dataRecord.formattedValue = $scope.getFormattedValue(value,
														$scope.component.measureDataField[0].formatter,
														undefined,
														undefined,
														undefined,
														$scope.component.measureDataField[0],
														$scope.dataSet);
												dataRecord.svalue = key;
												dataRecord.formattedSvalue = $scope.getFormattedValue(key,
														$scope.component.dimensionDataField[0].formatter,
														undefined,
														undefined,
														undefined,
														$scope.component.dimensionDataField[0],
														$scope.dataSet);
												dataRecord.formattedY = $scope.getFormattedValue(value,
														$scope.component.measureDataField[0].formatter,
														undefined,
														undefined,
														undefined,
														$scope.component.measureDataField[0],
														$scope.dataSet);
												dataRecord.name = xCategories[key];
												dataRecord.ylabel = $scope.component.yAxisTitle.text;
												dataRecord.xlabel = $scope.component.xAxisTitle.text;

												var brigthness = value == 0 ? 0 : Math.abs(10 * Math.log10(value));
												var color = i > defaultMultiChartColors.length ? customReportSvc
														.randomColorFromBrightness(brigthness)
														: defaultMultiChartColors[i];

												dataRecord.color = color;
												seriesObject = null;
												for (var k = 0; k < chartData.length; k++) {
													var dataField = chartData[k];
													if (dataField.name == record[0]) {
														seriesObject = dataField;
														break;
													}
												}
												if (!seriesObject) {
													seriesObject = {
														name : key,
														data : []
													};
													chartData.push(seriesObject);
												}
												seriesObject.data.push(dataRecord);
												counter++;
											}
										});
									});

								};

								var constructTreemapWithLevel = function(records, seriesObject, chartData, xCategories,
										yCategories) {
									var treeParentsMap = {};
									var treemapSeries = {};
									var isTreemapWithLevels = false;

									treemapSeries.type = 'treemap';
									treemapSeries.layoutAlgorithm = 'sliceAndDice';
									treemapSeries.alternateStartingDirection = true;

									if ($scope.component.dimensionDataField.length > 1) {
										isTreemapWithLevels = true;
									}
									treemapSeries.levels = [ {
										level : $scope.component.dimensionDataField.length == 1 ? 0 : 1,
										layoutAlgorithm : 'squarified',
										dataLabels : {
											'enabled' : $scope.component.styles.chartPlotOptions.isShowLabels ? true
													: false,
											'align' : 'left',
											'verticalAlign' : 'top',
											'style' : {
												'fontSize' : '15px',
												'fontWeight' : 'normal'
											}
										}

									} ];

									treemapSeries.data = [];
									var colorStart = '#000000';
									var colorEnd = $scope.component.styles.barColor;
									var maxPoints = isTreemapWithLevels ? $scope.component.dimensionDataField[1].numPointsToDisplay.maxPoints
											: $scope.component.dimensionDataField[0].numPointsToDisplay.maxPoints;
									var groupColor = customReportSvc.generateColor(colorStart, colorEnd, maxPoints);

									angular
											.forEach(records,
													function(record, i) {
														var counter = 0;
														var hashKey = null;

														angular
																.forEach(record,
																		function(value, key) {

																			if (isTreemapWithLevels && counter == 0) {
																				var parentRecord = {};
																				hashKey = value;

																				if (!treeParentsMap
																						.hasOwnProperty(hashKey)) {
																					treeParentsMap[hashKey] = {};
																					parentRecord.id = hashKey;
																					parentRecord.name = value;
																					parentRecord.formattedName = $scope
																							.getFormattedValue(hashKey,
																									$scope.component.dimensionDataField[0].formatter,
																									undefined,
																									undefined,
																									undefined,
																									$scope.component.dimensionDataField[0],
																									$scope.dataSet);
																					treemapSeries.data
																							.push(parentRecord);
																					var colorStart = '#000000';
																					var brigthness = value == 0 ? 0
																							: Math.abs(10 * Math
																									.log10(value));
																					var colorEnd = i > defaultMultiChartColors.length ? customReportSvc
																							.randomColorFromBrightness(brigthness)
																							: defaultMultiChartColors[i];

																					groupColor = customReportSvc
																							.generateColor(colorStart,
																									colorEnd,
																									$scope.component.dimensionDataField[1].numPointsToDisplay.maxPoints);
																					counter++;
																					return false;
																				}
																			} else {
																				hashKey = key;
																				var formattedValue = $scope
																						.getFormattedValue(value,
																								$scope.component.measureDataField[0].formatter,
																								undefined,
																								undefined,
																								undefined,
																								$scope.component.measureDataField[0],
																								$scope.dataSet);
																			}

																			var seriesChildrenPoint = {};
																			seriesChildrenPoint.name = xCategories[hashKey];
																			seriesChildrenPoint.formattedName = $scope
																					.getFormattedValue(seriesChildrenPoint.name,
																							$scope.component.dimensionDataField[0].formatter,
																							undefined,
																							undefined,
																							undefined,
																							$scope.component.dimensionDataField[0],
																							$scope.dataSet);
																			seriesChildrenPoint.value = value;
																			seriesChildrenPoint.formattedValue = formattedValue;
																			seriesChildrenPoint.formattedY = formattedValue;
																			seriesChildrenPoint.xlabel = $scope.component.xAxisTitle.text;
																			seriesChildrenPoint.ylabel = $scope.component.yAxisTitle.text;
																			if (isTreemapWithLevels) {
																				seriesChildrenPoint.svalue = yCategories[key];
																				seriesChildrenPoint.slabel = $scope.component.dimensionDataField[1].title.text +
																						' :';
																				seriesChildrenPoint.formattedSvalue = $scope
																						.getFormattedValue(seriesChildrenPoint.svalue,
																								$scope.component.dimensionDataField[1].formatter,
																								undefined,
																								undefined,
																								undefined,
																								$scope.component.dimensionDataField[1],
																								$scope.dataSet);
																				//seriesChildrenPoint.name = hashKey;
																				//seriesChildrenPoint.formattedName = customReportSvc
																				//		.getFormattedValue(hashKey,
																				//				$scope.component.dimensionDataField[0].formatter);
																				seriesChildrenPoint.svalue = key;
																				seriesChildrenPoint.slabel = $scope.component.dimensionDataField[1].title.text +
																						' :';
																				seriesChildrenPoint.formattedSvalue = $scope
																						.getFormattedValue(key,
																								$scope.component.dimensionDataField[1].formatter,
																								undefined,
																								undefined,
																								undefined,
																								$scope.component.dimensionDataField[1],
																								$scope.dataSet);
																				seriesChildrenPoint.parent = hashKey;
																				seriesChildrenPoint.color = '#' +
																						groupColor[counter - 1];
																			} else {
																				seriesChildrenPoint.color = '#' +
																						groupColor[counter];
																			}
																			treemapSeries.data
																					.push(seriesChildrenPoint);
																			counter++;

																		});
														seriesObject = angular.copy(treemapSeries, {});
														chartData.push(treemapSeries);
													});
								}



								/*
								 * Converts the results returned by the engine to chart format. This applies
								 * when there is at least one measure field and also takes care of one series
								 * field.
								 */
								$scope.convertDataToChartData = function(data) {
									var records = data.records, columns = data.columns, returnData = {}, labels = [], labelsY = [], isMulti = $scope.component.dimensionDataField &&
											$scope.component.dimensionDataField.length > 1, dataRecords = [], chartData = [], xValues = [], seriesObject, stackMax = $scope
											.getStackMaxPoints(), isHeatMap = $scope.component.chartType == "heatmap";

									//update records to show only required number stacks
									if (isMulti && stackMax != -1) {

										var newRec = [];
										if ($scope.component.chartType !== 'TimeSeries') {
											var sname = "";
											var stackMap = {};
											// if stackMax is 10 , then it will add 10 stacks to each point. This is good for stacked charts but not time line charts.
											for (var index = 0, sIndex = 0; index < records.length; index++, sIndex++) {
												var name = records[index][0];
												if (stackMap[name] == undefined) {
													stackMap[name] = {};
													stackMap[name].counter = 0;
												}

												if (stackMap[name].counter < stackMax) {
													stackMap[name].counter++;
													newRec.push(records[index]);
												}

											}
										} else {
											var dimList2 = [];
											//for time line charts we need to show only 10 points , as we represent the data continuously.
											for (var i = 0; i < records.length; i++) {
												var dim2 = records[i][1];
												if (dimList2.length < stackMax) {
													dimList2.push(dim2);
												}
												if (dimList2.indexOf(dim2) !== -1) {
													newRec.push(records[i]);
												} else {
													continue;
												}
											}
										}
										records = newRec;
									}
									if (!doTreeMapSeries(data, labels, xValues, labelsY, seriesObject, chartData)) {
										if (isHeatMap) {
											if ($scope.dataSet.endpoint === 'DATACUBE' && !$scope.useCREApiForSolr) {
												doHeatMapSeries(data, labels, xValues, labelsY, seriesObject, chartData);
											} else {
												doHeatMapSeriesForCRE(data,
														labels,
														xValues,
														labelsY,
														seriesObject,
														chartData);
											}

										} else {
											var xAxisCol = $scope.component.dimensionDataField[0];
											angular
													.forEach(records,
															function(row, i) {
																var yValueIndex = isMulti ? 2 : 1, xValueIndex = 0;

																/*
																 * if ($scope.component.isTimeGrouping) {
																 * yValueIndex++; xValueIndex++; }
																 */

																var xValue = row[xValueIndex];

																if (!isMulti) {
																	labels.push(xValue);
																} else {
																	row[1] = row[1] + "";
																}

																if($scope.supportNullValues() && row[yValueIndex] === -1 ){
																	row[yValueIndex] = null;
																}

																const originalXVal = xValue;
																if ($scope.component.isTimeGrouping === true) {
																	xValue = $scope
																			.convertTimeStamptoGroupingValue(row[0],
																					data.timeGroup,
																					$scope.component.dimensionDataField[0].onlyTimeInfo);
																	row[0] = xValue;
																	name = xValue;
																}
																let col1 = typeof columns !== "undefined" ? columns[0] : $scope.component.dimensionDataField[0];
																let dimension = $scope.component.dimensionDataField[0];
																const noFormatter = !dimension.formatter || (dimension.formatter && dimension.formatter.type == "none");
																const noCustomGroups = !dimension.customGroupsAvailable && $.isEmptyObject(dimension.groups);
																if (!$scope.component.isTimeGrouping && (col1.type === "TimeStamp" || col1.type === "Date") && noFormatter && noCustomGroups) {
																	xValue = rpt.formatDateByColType(xValue,col1);
																	row[xValueIndex] = xValue;
																}
																let col2 = isMulti && typeof columns !== "undefined" ? columns[1] : $scope.component.dimensionDataField[1];
																if (!$scope.component.isTimeGrouping && isMulti &&  (col2.type === "TimeStamp" || col2.type === "Date") && (!$scope.component.dimensionDataField[1].formatter || $scope.component.dimensionDataField[1].formatter && $scope.component.dimensionDataField[1].formatter.type == "none")) {
																	row[1] = rpt.formatDateByColType(row[1],col2);
																}

																if (xValues.indexOf(xValue) == -1) {
																	xValues.push($scope
																			.getFormattedValue(xValue,
																					xAxisCol.formatter,
																					undefined,
																					undefined,
																					undefined,
																					xAxisCol,
																					$scope.dataSet));
																	// TODO need to fix slabel as it is hacked to be absent completely (even the semicolon) in case of multiple dimensions
																}

																var column = $scope.component.measureDataField[0];
																var formattedY = $scope
																		.getFormattedValue(row[yValueIndex],
																				column.formatter,
																				undefined,
																				undefined,
																				undefined,
																				column,
																				$scope.dataSet);
																//for pie charts and donut when 0 values are returned by the backend the chart is blank but the legends are shown.
																if ($scope.component.chartType == "Pie" ||
																		$scope.component.chartType == "Donut") {
																	$scope.component.xAxisTitle.text = "";
																	$scope.component.yAxisTitle.text = "";
																	if (row[yValueIndex] !== undefined && row[yValueIndex] !== null) {
																		$scope.dataAvailableForPlot = true;
																	}
																}

																var dataRecord = {
																	name : row[0],
																	originalXVal,
																	y : row[yValueIndex],
																	slabel : isMulti ? $scope.component.dimensionDataField[1].title.text +
																			' :'
																			: undefined,
																	xlabel : $scope.component.xAxisTitle.text,
																	ylabel : $scope.component.yAxisTitle.text,
																	svalue : row[1],
																	formattedY : formattedY,
																	formattedName : $scope
																			.getFormattedValue(row[0],
																					$scope.component.dimensionDataField[0].formatter,
																					undefined,
																					undefined,
																					undefined,
																					$scope.component.dimensionDataField[0],
																					$scope.dataSet),
																	formattedSvalue : $scope.component.dimensionDataField.length > 1 ? $scope
																			.getFormattedValue(row[1],
																					$scope.component.dimensionDataField[1].formatter,
																					undefined,
																					undefined,
																					undefined,
																					$scope.component.dimensionDataField[1],
																					$scope.dataSet)
																			: undefined,
                                                                            dimensionValues: row.slice(0, yValueIndex),
                                                                            measureValues : row.slice(yValueIndex)
																};
																// We do not need slabel and svalue in the tooltip when we are only using a single dimension
																if ($scope.component.dimensionDataField.length == 1) {
																	delete dataRecord["slabel"];
																	delete dataRecord["svalue"];
																	delete dataRecord["formattedSvalue"];
																}
																if (isMulti) {
																	seriesObject = null;
																	for (var i = 0; i < chartData.length; i++) {
																		var dataField = chartData[i];
																		if (dataField.name == row[1]) {
																			seriesObject = dataField;
																			break;
																		}
																	}
																}
																if (!seriesObject) {
																	seriesObject = {
																		name : isMulti ? row[1] : $scope.component.measureDataField[0].column,
																		data : []
																	};
																	chartData.push(seriesObject);
																}
																seriesObject.data.push(dataRecord);
															});

										}
										// Normalization process . Setting the y value of each series on x axis to 0. if we dont do this then the chart will not be drawn completely.
										if (isMulti && !isHeatMap) {
											angular
													.forEach(chartData,
															function(series) {
																labels.push(series.name);
																var newData = [];
																angular
																		.forEach(xValues,
																				function(x) {
																					var valueFound = false;
																					for (var i = 0; i < series.data.length; i++) {
																						var seriesData = series.data[i]
																						if (seriesData.formattedName == x) {
																							valueFound = true;
																							newData.push(seriesData);
																							break;
																						}
																					}
																					if (!valueFound) {
																						var data = {
																							name : x,
																							y : !$scope.supportNullValues() ? 0 : null,
																							formattedY : ""
																						};
																						data.slabel = isMulti ? $scope.component.dimensionDataField[1].title.text +
																								' :'
																								: undefined;
																						data.ylabel = $scope.component.yAxisTitle.text;
																						data.xlabel = $scope.component.xAxisTitle.text;
																						data.svalue = series.name;
																						data.formattedName = $scope
																								.getFormattedValue(x,
																										$scope.component.dimensionDataField[0].formatter,
																										undefined,
																										undefined,
																										undefined,
																										$scope.component.dimensionDataField[0],
																										$scope.dataSet);
																						data.formattedSvalue = $scope.component.dimensionDataField.length > 1 ? $scope
																								.getFormattedValue(data.svalue,
																										$scope.component.dimensionDataField[1].formatter,
																										undefined,
																										undefined,
																										undefined,
																										$scope.component.dimensionDataField[1],
																										$scope.dataSet)
																								: undefined;
																						newData.push(data);
																					}
																				});
																series.data = newData;
															});
										}
									}

									returnData.labels = labels;
									returnData.labelsY = labelsY;
									returnData.chartData = chartData;

									//FOR HISTOGRAM BY DEFAULT WE WANT TO JUST SHOW THE CEIL VALUE INSTEAD OF (FLOOR-CEIL) IN XAXIS. So trying to adjust the labels from the data.
									if ($scope.component.chartType === 'Histogram') {
										$scope.histXlabels = []; //mocking the object to have the values ["",val1,val2,...........,valn]
										angular.forEach(xValues, function(x, i) {
											if (x.indexOf('<') != -1) {
												$scope.histXlabels.push("");
												$scope.histXlabels.push(x.substring(x.indexOf('<') + 1, x.length));
											} else if (x.indexOf('-') != -1) {
												$scope.histXlabels.push(x.substring(x.indexOf('-') + 1, x.length));
											}
										});
										returnData.xvalues = $scope.histXlabels
									} else {
										returnData.xvalues = xValues; // xvalues this is used for xaxis labels
									}

									return returnData;
								};

								var doHeatMapSeriesForCRE = function(data, labels, xValues, labelsY, seriesObject,
										chartData) {

									var records = data.records;
									var columns = data.columns;
									var indexlalebls = [];

									angular.forEach(records, function(row, i) {
										var label = row[0];
										var name = row[1];
										var yValue = row[2];
										var x = indexlalebls.indexOf(label);
										var yIndex = labels.indexOf(name);
										if (yIndex === -1) {
											labels.push(name);
											xValues.push(name);
										}
										if (x === -1) {
											indexlalebls.push(label);
											x = indexlalebls.indexOf(label);
											labelsY.push(label);
										}

										var formattedY = $scope.getFormattedValue(yValue,
												$scope.component.measureDataField[0].formatter,
												undefined,
												undefined,
												undefined,
												$scope.component.measureDataField[0],
												$scope.dataSet)
										var data = [ {
											x : i,
											y : x,
											value : yValue,
											formattedValue : formattedY,
											svalue : yValue,
											formattedSvalue : formattedY,
											formattedY : formattedY,
											name : name,
											ylabel : label,
											xlabel : $scope.component.heatMapRow.column
										} ];

										var found = false;
										for (var k = 0; k < chartData.length; k++) {
											var currData = chartData[k];
											if (currData.name === name) {
												var point = data[0];
												point.x = k;
												currData.data.push(point);
												found = true;
												break;
											}
										}
										if (!found) {
											chartData.push({
												name : name,
												data : data
											});
										}
									});
								}

								function getFormattedValue(value, formatter) {
									var returnVal = value;
									if (formatter === undefined || formatter === "") {
										return returnVal;
									} else {
										var expression = formatter;
										var returnVal;
										if (typeof expression === "string" && expression.substring(0, 1) === "=") {
											try {
												returnVal = eval(expression.substring(1));
											} catch (exception) {
												console.error(exception.message);
											}
										} else if (typeof expression === "string" &&
												expression.substring(0, 2) === ":=") {
											try {
												var expr = "(function() {" + expression.substring(2) + " }) ();";
												returnVal = eval(expr);
											} catch (exception) {
												console.error(exception.message);
											}
										}
										return returnVal;
									}
								}
								function getFormattedY(y) {
									var formattedY = 0;
									if (y % 1 != 0) {
										formattedY = y.toFixed(3);
									} else {
										formattedY = y.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
									}

									return formattedY;
								}
								$scope.isShowNoChartDiv = function() {
									return (!$scope.masked && $scope.componentLoaded && !$scope.component.isChartExist);
								};

								$scope.getMaxPoints = function() {
									var maxPoints = $scope.labels.length;
									// If the chart type is Timeline (TimeSeries), we will always show all available points
									if (!$scope.component.dimensionDataField ||
											$scope.component.dimensionDataField.length == 0 ||
											$scope.component.chartType == "TimeSeries") {
										return maxPoints;
									}

									var dimension = $scope.component.dimensionDataField[0];
									var max = parseInt(dimension.numPointsToDisplay.maxPoints);
									if (!dimension.numPointsToDisplay.includeAll && max < maxPoints) {
										maxPoints = max;
									}

									return maxPoints;

								};

								$scope.getStackMaxPoints = function() {
									if (!$scope.component.dimensionDataField ||
											$scope.component.dimensionDataField.length <= 1) {
										return -1;
									}

									var dimension = $scope.component.dimensionDataField[1];
									if (dimension.numPointsToDisplay.includeAll) {
										return -1;
									}

									var max = parseInt(dimension.numPointsToDisplay.maxPoints);
									if (max == NaN) {
										return -1;
									}

									return max;

								};

								$scope.getYAxisTitle = function() {
									if ($scope.component.yAxisTitle.text == null) {
										$scope.component.yAxisTitle.text = '';
										if ($scope.component.chartType === 'heatmap') {
											$scope.component.yAxisTitle.text = $scope.component.heatMapRow.column;
										} else {
											angular.forEach($scope.component.measureDataField, function(measure, i) {
												$scope.component.yAxisTitle.text = $scope.component.yAxisTitle.text +
														(i != 0 ? ',' : '') + measure.title.text + " " +
														(measure.aggrType != 'None' ? measure.aggrType + " " : "");
											});
										}
									}

									return $scope.component.yAxisTitle.text;
								}
								function getFiltersArray(currentFilter, dimField) {
									var filtersArr = [];
									if (dimField && !$.isEmptyObject(currentFilter[dimField]) &&
											!$.isEmptyObject(currentFilter[dimField]["include"])) {
										filtersArr = $.extend(true, [], currentFilter[dimField]["include"]); // deep copy
									}
									/*
									 * in case of custom groups in filtersArr delete custom group and add
									 * groupName only
									 */
									var tempFilters = [];
									angular.forEach(filtersArr, function(filterVal, index) {
										if (typeof filterVal === 'object' && filterVal.groupName) {
											tempFilters.push(filterVal.groupName);
										} else {
											tempFilters.push(filterVal);
										}
									});
									filtersArr = tempFilters;
									return filtersArr;
								}

								$scope.setSeriesSelected = function(chart) {
									if (!chart) {
										return;
									}
									$scope.clearOptionEnabled = false;
									for ( var key in $scope.mergedParams) {
										if (key.indexOf(".filter.") != -1) {
											var comp = key.substring(0, key.indexOf('.'));
											if ($scope.component.id === comp) {
												var value = $scope.mergedParams[key];
												try {
													var values = JSON.parse(value);
													Highcharts.each(chart.series, function(series) {
														Highcharts.each(series.points, function(point) {
															var secondDimValue = undefined; // heatmap second dimension value
															if (values.indexOf(point.name) != -1) {
																point.isSelected = true;
															}
														});
													});
												} catch (e) {
													console.log(e);
												}
												$scope.clearOptionEnabled = true;
											}
										}
									}
								}

								function applyChartFilters(chart) {
									if (!$scope.dataSet) {
										return;
									}
									var filtersArr = [];
									var filtersArr1 = []; // for heatmap second dimension
									var isMultiDimension = false;
									var dimField = !$.isEmptyObject($scope.component.dimensionDataField) ? $scope.component.dimensionDataField[0]
											: undefined;
									var dataSetName = $scope.dataSet.dataSet.dataSetName;
									var currentFilter;
									if ($.isEmptyObject($scope.page.body.filters['viewer'][dataSetName])) {
										return;
									}
									currentFilter = $scope.page.body.filters['viewer'][dataSetName];
									filtersArr = getFiltersArray(currentFilter, dimField.column);
									if (!$.isEmptyObject($scope.component.dimensionDataField) &&
											$scope.component.dimensionDataField.length > 1) {
										dimField = $scope.component.dimensionDataField[1];
										filtersArr1 = getFiltersArray(currentFilter, dimField.column);
										isMultiDimension = true;
									}
									var areTuplesAvailable = false;
									var tuples = [];
									angular.forEach(currentFilter, function(filterVal, filterParam) {
										if (filterParam.indexOf("tuples_") !== -1) {
											areTuplesAvailable = true;
											tuples = currentFilter[filterParam]["include"];
											return;
										}
									});
									if (chart && chart.series && filtersArr) {
										Highcharts
												.each(chart.series,
														function(series) {
															Highcharts
																	.each(series.points,
																			function(point) {
																				const isEmptyValue = point.name === "" && $scope.dataSet.endpoint === "DATACUBE";
																				const pointName = isEmptyValue ? qb.rv.getQueryForEmptyVal() : point.name;

																				var secondDimValue = undefined; // heatmap second dimension value
																				if (isMultiDimension) {
																					secondDimValue = chart.axes[1].categories[point.y];
																					if (!$.isEmptyObject(filtersArr) &&
																							filtersArr
																									.indexOf(secondDimValue) != -1) {
																						point.isSelected = true;
																					}
																					if (!$.isEmptyObject(filtersArr1) &&
																							filtersArr1
																									.indexOf(pointName) != -1) {
																						point.isSelected = true;
																					}
																					if (areTuplesAvailable) {
																						angular
																								.forEach(tuples,
																										function(tuple) {
																											var dimensions = Object
																													.keys(tuple);
																											if (tuple[dimensions[0]] === pointName &&
																													tuple[dimensions[1]] === secondDimValue) {
																												point.isSelected = true;
																												return;
																											}
																										});
																					}
																				} else {
																					if (filtersArr.indexOf(pointName.toString()) !== -1 || filtersArr.indexOf(pointName) !== -1) {
																						point.isSelected = true;
																						if ($scope.component.chartType === 'Pie' ||
																								$scope.component.chartType == "Donut") {
																							$(point.legendItem.element)
																									.css('font-weight',
																											"bold");
																							point.legendItem.styles.fontWeight = "bold";
																							point.graphic.translateX = point.slicedTranslation.translateX;
																							point.graphic.translateY = point.slicedTranslation.translateY;
																							point.graphic.doTransform = true;
																						}
																					}
																				}
																			});
														});
									}
								}

								$scope.assignTimeGrouping = function(timeGroup) {
									//assign timegrouping based on response timeGroup
									$scope.timeGrouping = unitToGroupMapping[timeGroup];
									if(timeGroup === "week") {
										$scope.groupInterval = 7;
									}
								}

								$scope.getChartData = function(isAutoRefresh) {
									var showNegative = false, isPreview = customReportSvc
											.getParameterByName("isPreview", false), i = 0, arr = [
											'Double',
											'Float',
											'Integer',
											'Long',
											'Short',
											'Decimal' ];

									$scope.enableDisableDataFetch($scope.component.id, true);
									$scope.component.multiBars = false;
									$scope.showLegend = false;
									$scope.component.isGroupBy = false;

									// check for aggregate functions in measureFields and assign type
									for (var i = 0; i < $scope.component.measureDataField.length; i++) {
										if (arr
												.indexOf($scope.fieldTypeMap[$scope.component.measureDataField[i].column]) != -1) {
											$scope.component.measureDataField[i].showNumberOps = true;
										}
										if ($scope.component.measureDataField[i].aggrType != 'None') {
											$scope.component.isGroupBy = true;
											break;
										}
									}

									// check if column is date/time column
									if ($scope.component.dimensionDataField.length > 0) {
										var dimObj = $scope.component.dimensionDataField[0];
										var fType = $scope.fieldTypeMap[dimObj.column] || dimObj.type;
										if (dates.indexOf(fType) != -1) {
											$scope.component.dimensionDataField[0].showTimeGrouping = true;
											if ($scope.component.dimensionDataField[0].timeGrouping === undefined) {
												$scope.component.dimensionDataField[0].timeGrouping = 'None';
											}

											if ($scope.component.dimensionDataField[0].timeGrouping !== 'None') {
												$scope.component.isTimeGrouping = true;
											}
										}
									}

									var fields = customReportSvc.getChartValueFields($scope.component);
									var config = $scope.chartConfig;
									// $scope.masked = true;
									if ($scope.component && $scope.dataSet) {
										$scope.timeGrouping = undefined;
										$scope.groupInterval = 1;
										if ($scope.dataSet.endpoint === 'DATACUBE' && !$scope.useCREApiForSolr) {
											var dimensionDataField = $scope
														.applyInputsToCustomGroups($scope.component.dimensionDataField);
											const compFilters = $scope.component.filters && $scope.component.filters['builder'] ? $scope.component.filters['builder'][dataSetName]: {};
											const timeGrouping = $scope.component.dimensionDataField[0].timeGrouping;
																									
											if($scope.component.doNotFormFacetRequest) {
												$dataSource
												.getDataSource($scope.dataSet.endpoint)
												.getChartDataWithoutFacetReq({
													dataSet : $scope.dataSet,
													measureDataField : $scope.component.measureDataField,
													dimensionDataField : dimensionDataField,
													sortOptions : $scope.component.sorting ? $scope.component.sorting[0]
															: undefined,
													filters : compFilters,
													reqParams : {
														reqType : "GET",
														interval : $scope.isTimeRangeFilter ? "auto" : timeGrouping
													}
												},
														function(resp) {
															if(resp.timeGroup) {
																$scope.assignTimeGrouping(resp.timeGroup);																
															}
															onSuccessGetChartDataForDataSet(resp, isAutoRefresh);
														});
											} else {
												var dataSetName = $scope.dataSet.dataSet.dataSetName;
												if ($scope.component.isTimeGrouping) {
													var measureDataFields = [ {
														column : dimensionDataField[0].column,
														aggrTypes : [ 'Min', 'Max', 'CountDistinct' ]
													} ];
													var options = {
														dataSet : $scope.dataSet,
														measureDataFields : measureDataFields,
														filters: compFilters
													};
													// get minimum, maximum and number of unique values for current date field using getFacetFunction
													$dataSource
													.getDataSource($scope.dataSet.endpoint)
													.getFacetFunction(options,
															function(data) {
																data = data.data || data;
																// data containing array of facet function result in order of aggrTypes
																const minDate = moment(data[0]);
																const maxDate = moment(data[1]);
																const count = data[2];																
																//if number records/points are less or equal to MAX_INTERVAL then no need to group it
																if(timeGrouping === 'auto' || $scope.isTimeRangeFilter) {
																	const DEFAULT_MAX_INTERVAL = 30;
																	const MAX_INTERVALS = DEFAULT_MAX_INTERVAL;
																	//TODO: check how can we uncomment below code. Need to show max points property in the propeties
																	//const MAX_INTERVALS = dimensionDataField[0].numPointsToDisplay && dimensionDataField[0].numPointsToDisplay.maxPoints
																	///? dimensionDataField[0].numPointsToDisplay.maxPoints : DEFAULT_MAX_INTERVAL ;

																	if(count <= MAX_INTERVALS) {
																		$scope.timeGrouping = dimensionDataField[0].timeGrouping = 'none';
																	} else {
																		//below logic is the decide the grouping unit. We are considering below groups:
																		// [30secs,min,30min,hour,day,week,month,year].
																		const units = Object.keys(intervalsObj);
																		let diff;
																		let groupInterval = 1;
																		let grouping = "Yearly";
																		let gap = "YEAR";
																		let minDiff = count;

																		for(let i = 0; i < units.length ; i++) {
																			let unit = units[i];
																			diff =  Math.abs(maxDate.diff(minDate, unit));
																			let interval = intervalsObj[unit].find(time => (Math.ceil(diff/time) <= MAX_INTERVALS));
																			//if time grouping has intervals less than max_intervals then consider it as grouping unit
																			if(interval) {
																				groupInterval = interval;
																				grouping = unitToGroupMapping[unit];
																				gap = unit.toUpperCase();
																				break;
																			} else {
																				//based on the min, max and count of unique values calculate which grouping unit will have detailed representation
																				let intervals = intervalsObj[unit].filter(time => minDiff > Math.abs(count - Math.ceil(diff/time)))
																				if(intervals.length) {
																					minDiff = Math.min(...intervals);
																					groupInterval = intervals[intervals.indexOf(minDiff)];
																					grouping = unitToGroupMapping[unit];
																					gap = unit.toUpperCase();
																				}
																			}
																		}

																		$scope.timeGrouping = grouping;
																		$scope.groupInterval = groupInterval;
																		dimensionDataField[0].minDate = minDate;
																		dimensionDataField[0].maxDate = maxDate;

																		// assign best grouping based on above calculations
																		dimensionDataField[0].timeGrouping = grouping;
																		dimensionDataField[0].gap = `+${groupInterval}${gap}`;
																	}
																	//when it's auto grouping get all the points
																	dimensionDataField[0].numPointsToDisplay.includeAll = true;
																	dimensionDataField[0].numPointsToDisplay.maxPoints = -1;

																} else {
																	dimensionDataField[0].minDate = minDate;
																	dimensionDataField[0].maxDate = maxDate;
																	dimensionDataField[0].gap = gapMappingForGroups[timeGrouping];
																}
																getChartDataForDatacube(dimensionDataField, isAutoRefresh);
															});
												} else {
													getChartDataForDatacube(dimensionDataField, isAutoRefresh);
												}
											}
											
										} else {
											$scope.getData(undefined, false, isAutoRefresh).then(function(data) {
												const resp = data.data || data;
												if(resp.timeGroup) {
													$scope.assignTimeGrouping(resp.timeGroup);	
												}
												onSuccessGetChartDataForDataSet(data, isAutoRefresh);
											});
										}
									}

									function getChartDataForDatacube(dimensionDataField, isAutoRefresh) {
										const compFilters = $scope.component.filters && $scope.component.filters['builder'] ? $scope.component.filters['builder'][dataSetName]: {};

										$dataSource
												.getDataSource($scope.dataSet.endpoint)
												.getChartData({
													dataSet : $scope.dataSet,
													componentType : $scope.component.type,
													chartType : $scope.component.chartType,
													measureDataField : $scope.component.measureDataField,
													dimensionDataField : dimensionDataField,
													sortOptions : $scope.component.sorting ? $scope.component.sorting[0]
															: undefined,
													filters : compFilters,
													inputParams : customReportSvc.applyInputsToDataSet($scope.dataSet,
															$scope.page.inputs)
												},
														function(resp) {
															onSuccessGetChartDataForDataSet(resp, isAutoRefresh);
														});
									}

									var updateCompareOptions = function(grouping){

										if(!System.additionalSettings)
											System.additionalSettings = {};

										if(!System.additionalSettings.Console)
											System.additionalSettings.Console = {};

										if(System.additionalSettings.Console.showCompareOptionOnTimeline == undefined)
											System.additionalSettings.Console.showCompareOptionOnTimeline = false;

										if(System.additionalSettings.Console.showCompareOptionOnTimeline === true){
											if($scope.compareOptionsMap[grouping]){
											$scope.compareOptions = $scope.compareOptionsMap[grouping];

											}
											else {

												$scope.compareOptions = [];
												$scope.compareOptions.push($scope.compareNoneOption);
											}
											$scope.compareInfo.selectedCompareOption = $scope.compareNoneOption;
										}
										else
										{
											$scope.compareOptions = [];
										}

}

									var onSuccessGetChartDataForDataSet = function(result, isAutoRefresh) {

										var response = result.data || result;
										$scope.tempComponent.tabularData = response;
										var chartData;
										$scope.component.isComponentLoading = false;

										if(response.timeGroup && $scope.component.dimensionDataField[0] && $scope.component.dimensionDataField[0].timeGrouping)
										{
											if($scope.component.dimensionDataField[0].timeGrouping == "auto")
												$scope.tempComponent.chartTimeGroup = response.timeGroup;

											if($scope.component.showCompare == false)
												updateCompareOptions(autoToTimConversion[response.timeGroup.toUpperCase()]);
										}

										// Strip out invalid values for TimeSeries and Line chart types
										// Neither of these chart types should support empty values or dummy datetime stamps
										// We should also limit the result set to 1000 total records so highcharts doesn't throw an error http://www.highcharts.com/errors/12
										var removedInvalidRecords = false;
										if ($scope.component.chartType == 'Line' ||
												($scope.component.chartType == 'TimeSeries' && $scope.component.showCompare == false)) {
											if (response.records.length > 0) {
												var i = 0;
												while (i < response.records.length) {
													var record = response.records[i];
													if (record[0] == undefined || record[0] === null ||
															record[0] == "" || record[0] == "Jan 1, 1900 12:00:00 AM" ||
															record[0] == "Jan 1, 1900") {
														response.records.splice(i, 1);
														removedInvalidRecords = true;
														i--;
													} else if ( !$scope.supportNullValues() && $scope.component.dimensionDataField.length === 1 &&
															record[1] === null) {
														record[1] = 0;
													} else if (!$scope.supportNullValues() && $scope.component.dimensionDataField.length === 2 &&
															record[2] === null) {
														record[2] = 0;
													}

													i++;
												}
											}
										}
										if ($scope.component.chartType === 'Histogram') {
											// RESPONSE FORMAT IS A BIT DFFERENT FOR HISTOGRAM , SO TRYING TO MERGE THESE TWO FOR MAKING MINIMAL CODE CAHNGES AND AVOID REGRESSION.
											//REMOVING THE FIRST COLUMN MAKES IT EQUEAL TO THE OTHER CHARTS , AT THE SAME TIME CONSTRUCT THE RANGES TO BE SHOWN IN THE TOOL TIP , (FLOOR - CEIL)
											if (response.records.length > 0) {
												var i = 0;
												while (i < response.records.length) {
													var row = response.records[i];
													if (row[0] === "") {
														row[1] = "<" + row[1];
													} else if (row[1] === "") {
														row[1] = ">" + row[0];
													} else {
														row[1] = row[0] + " - " + row[1];
													}
													row.splice(0, 1)
													i++;
												}
											}
										}
										$scope.tempComponent.tooManyRecordsReturned = false;
										if (response.records.length >= 1000) {
											response.records = response.records.slice((response.records.length - 999),
													response.records.length);
											$scope.tempComponent.tooManyRecordsReturned = true;
										}
										if (removedInvalidRecords === true ||
												$scope.tempComponent.tooManyRecordsReturned === true) {
											response.recordsCount = response.records.length;
											response.totalRecordsCount = response.records.length;
										}

										/*
										 * strip the unit out of the field as it is to be shown in the chart
										 * with data angular.forEach($scope.component.measureDataField,
										 * function(field){ var startIndex = field.column.lastIndexOf("(");
										 * var endIndex = field.column.lastIndexOf(")"); field.labelUnit =
										 * field.column.substring(0,2);//field.column.substring(startIndex+1,endIndex);
										 * }); angular.forEach($scope.component.dimensionDataField,
										 * function(field){ var startIndex = field.column.lastIndexOf("(");
										 * var endIndex = field.column.lastIndexOf(")"); field.labelUnit =
										 * field.column.substring(0,2);//field.column.substring(startIndex+1,endIndex);
										 * });
										 */

										// generate CSV for arrays for x and y axis
										if (!$scope.component.xAxisTitle) {
											$scope.component.xAxisTitle = {
												"text" : ''
											};
										}
										if (!$scope.component.yAxisTitle) {
											$scope.component.yAxisTitle = {
												"text" : ''
											};
										}
										if ($scope.component.xAxisTitle.text == null) {
											$scope.component.xAxisTitle.text = $scope.component.chartType === 'heatmap' ? $scope.component.heatMapColumn.column
													: $scope.component.dimensionDataField[0].title.text ? $scope.component.dimensionDataField[0].title.text : "";
										}
										if (config.xAxis) {
											config.xAxis.title.text = $scope.component.xAxisTitle.text;
											config.xAxis.reversed = false;
										}
										var yaxisTitle = $scope.getYAxisTitle();
										if (config.yAxis) {
											config.yAxis.title.text = yaxisTitle;

											if (yaxisTitle.indexOf("(%)") !== -1) {
												//config.options.plotOptions['column'] = {stacking: 'percent'}; for some reason this option is not working
												config.yAxis.max = 100; // forcing the yaxis max to be 100 incase of percentage chart. This is forward port feature of v10.
											}
										}

										// decision whether y axis goes in series or x axis

										if ($scope.component.showCompare &&
												$scope.component.showCompare == true) {
											chartData = $scope.convertCompareDataToSeriesData(response);
										}
										else if ($scope.component.measureDataField &&
												$scope.component.measureDataField.length > 1) {
											chartData = $scope.convertDataToSeriesData(response);
										} else {
											chartData = $scope.convertDataToChartData(response);
										}

										var data = chartData.chartData;
										$scope.cacheId = response.cacheId;
										if (data == undefined || data.length == 0 || chartData.xvalues == undefined ||
												chartData.xvalues.length == 0 || !$scope.dataAvailableForPlot) {
											$scope.component.isChartExist = false;
											$scope.componentLoaded = true;
											$scope.masked = false;
											if (isExport) {
												customReportSvc.setComponentLoaded($scope.component);
												$scope.setAllComponentsIntialized($scope.component);
											}
											return;
										}

										angular.copy(data, $scope.rawData);
										$scope.tooltipLabels = [];
										//format labels
										$scope.labels.splice(0, $scope.labels.length);
										$scope.labelsY.splice(0, $scope.labelsY.length);

										angular.forEach(chartData.xvalues, function(label) {
											// if (label && label.length > 30) {
											// 	$scope.labels.push(label.substring(0, 15) + "..." +
											// 			label.substring(label.length - 15, label.length));
											// } else {
											// Do we need this? i think highchart take care of showing ellipsis
											// if we are pushing short labels only then even on hover we will not be able to see full value
											$scope.labels.push(label);
											// }
											// backend send the label as $other$. for now setting this back in the front end. In future we will a label which can be localized and replaced here.
											if (label === "$Other$") {
												label = "Other";
											}
											$scope.tooltipLabels.push(label);
										});

										angular.forEach(chartData.labelsY, function(label) {
											if (label && label.length > 30) {
												$scope.labelsY.push(label.substring(0, 15) + "..." +
														label.substring(label.length - 15, label.length));
											} else {
												$scope.labelsY.push(label);
											}
										});
										$scope.component.multiBars = data.length > 1 ||
												$scope.component.dimensionDataField.length > 1 ||
												$scope.component.measureDataField.length > 1;

										//set chart type
										var chartType = getChartType($scope.component.chartType);
										$scope.chartConfig.options.chart.type = chartType;

										// If there is only one measure and one dimension field, make sure grouping is disabled.
										if ($scope.component.measureDataField.length == 1 &&
												$scope.component.dimensionDataField.length == 1) {
											$scope.component.isGrouped = false;
										}
										//set stacking
										if ($scope.component.isGrouped || $scope.component.chartType == 'Line' ||
												$scope.component.chartType == 'TimeSeries' ||
												$scope.component.chartType == 'heatmap' ||
												$scope.component.chartType == 'treemap') {
											stacking = undefined;
										} else {
											stacking = 'normal';
										}

										//set series data, bar size and color
										/*
										 * We will be handling bar size dynamically going forward. Do not use
										 * the defaults or auto-sizing. var barSize = defaultBarSize; if
										 * ($scope.component.styles.barSize != undefined &&
										 * $scope.component.styles.barSize > 0) barSize =
										 * $scope.component.styles.barSize;
										 *
										 * if ($scope.component.chartType.indexOf("Group") != -1 &&
										 * data.length > 5) { //set auto if many bars barSize = undefined;
										 * $scope.component.styles.barSizeAutoOnly = true; } else
										 * $scope.component.styles.barSizeAutoOnly = false;
										 *
										 */

										//prepare series data
										var configSeries = config.series;
										var height = defaultHeight;
										$scope.maxPoints = $scope.getMaxPoints();

										/*
										 * if ($scope.component.styles.height != undefined) {
										 *
										 * $scope.component.styles.height = $scope.component.styles.height;
										 * //set property panel $scope.chartConfig.size.height =
										 * $scope.component.styles.height; //set chart height }
										 */

										if ($scope.component.chartType === 'TimeSeries') {
											var pointStep = 1;
											// Show a maximum of 20 labels on the chart
											if ($scope.maxPoints > 20) {
												pointStep = Math.ceil($scope.maxPoints / 20);
											}
											//setting the max point step to 5.
											if (pointStep > 5) {
												pointStep = 5;
											}

											$scope.chartConfig.xAxis.labels.step = pointStep;

											// If there are more than 5 labels, enable rotation
											if (($scope.maxPoints / pointStep) > 5) {
												$scope.component.rotateXAxisLabels = true;
												$scope.component.rotateXAxisLabelsDegrees = -30;
											} else {

												$scope.component.rotateXAxisLabels = false;
												$scope.component.rotateXAxisLabelsDegrees = null;
											}
										}

										var defaultBarWidth = 15;
										var defaultGroupPadding = 0.2;
										if ($scope.component.chartType === 'HorizontalBar' &&
												!$scope.chartConfig.options.chart.height) { //if height is auto then calculate the height if horizontal bar
											var pointsToDisplay = $scope.maxPoints;
											if (pointsToDisplay > $scope.labels.length) {
												pointsToDisplay = $scope.labels.length;
											}

											if (pointsToDisplay == 1) {
												if (data.length == 1) {
													height = 140;
												} else {
													height = 175;
												}
											} else {
												if ($scope.component.isGrouped) {
													height = 175 + pointsToDisplay * (data.length * 20);
												} else {
													height = 125 + pointsToDisplay * 20;
												}
											}
											$scope.chartConfig.options.chart.height = height; //set chart height
										}

										if ($scope.component.chartType === "VerticalBar") {
											var pointsToDisplay = $scope.maxPoints;
											if (pointsToDisplay == 1) {
												defaultBarWidth = 50;
												defaultGroupPadding = 0.4;
											} else if (pointsToDisplay > 1 && pointsToDisplay <= 5) {
												defaultBarWidth = 35;
												defaultGroupPadding = 0.3;
											} else if (pointsToDisplay > 5 && pointsToDisplay <= 10) {
												defaultBarWidth = 25;
												defaultGroupPadding = 0.2;
											} else {
												defaultBarWidth = 15;
												defaultGroupPadding = 0.2;
											}

										}

										if ($scope.chartConfig.options.chart.height === undefined) {
											$scope.chartConfig.options.chart.height = $scope.getHeight();
										}

										// For line chart always start x-axis with position 0
										if ($scope.component.chartType === 'Line' ||
												$scope.component.chartType === 'TimeSeries') {
											var pointPlacement = 'on';
										}

										if ($scope.component.chartType === "Histogram") {
											defaultBarWidth = undefined;
											defaultGroupPadding = 0; // avoid space between the bars. Histogram should be continuous.
											var pointPlacement = 'between'; // Position the label to the right of the axis.
										}

										if ($scope.component.chartType === "treemap") {
											defaultBarWidth = undefined;
											defaultGroupPadding = 0.5; // avoid space between the bars. Histogram should be continuous.
										}

										/*
										 * if(isDashboard){ $scope.chartConfig.size.width = 800;
										 * $scope.chartConfig.size.height = 350;
										 * $scope.component.styles.barSize = 15; }
										 */
										if(!isAutoRefresh)
											configSeries.splice(0, configSeries.length);

										angular.forEach(data, function(val, index) {
											val.pointWidth = defaultBarWidth;
											val.pointPadding = 0;
											val.groupPadding = defaultGroupPadding;
											val.stacking = stacking;
											val.marker = {};
											val.marker.enabled = true;
											val.marker.radius = 2;
											val.pointPlacement = pointPlacement;
											val.tooltip = {};

											var others;

											//for cre based reports back end will calculate Others.
											if ($scope.$parent.dataSet.endpoint === 'DATACUBE' &&
													$scope.component.showOthers) {
												var otherTotal = 0, ctr = 0, slice;

												for (ctr = $scope.maxPoints; ctr < val.data.length; ctr++) {
													slice = val.data[ctr];
													otherTotal += slice.y;
												}
												//other total is always 0 , as the limit is being handled in the back end.
												others = {
													name : "Others",
													y : otherTotal,
													formattedY : otherTotal
												}

												if ($scope.tooltipLabels.length > $scope.maxPoints) {
													$scope.tooltipLabels.splice($scope.maxPoints,
															$scope.tooltipLabels.length - $scope.maxPoints);
													$scope.tooltipLabels.push("Others");
												}
												val.data.splice($scope.maxPoints, val.data.length - $scope.maxPoints);
											}
											if (others) {
												val.data.push(others);
											}

											//logic to limit the data when there is a max point limit set on the dimension. This is not applicable for data cube as this limit is being done in the back end with the facet query.
											// we will work on doing the same for the CRE as well. We will then remove this logic.
											if ($scope.$parent.dataSet.endpoint !== 'DATACUBE' &&
													$scope.component.chartType != 'TimeSeries' &&
													$scope.component.dimensionDataField.length > 1 &&
													val.data.length > $scope.maxPoints) {
												val.data.splice($scope.maxPoints, val.data.length - $scope.maxPoints);
											}

											//look for negative values
											if (!showNegative) {
												for (i = 0; i < val.data.length; i++) {
													if (val.data[i].y < 0) {
														showNegative = true;
														break;
													}
												}
											}
											if(isAutoRefresh) {
												let chart = $scope.chartConfig.getHighcharts();
												let chartSeries = chart.series.find(series => val.name === series.name);
												if(chartSeries) {
													chartSeries.setData(val.data,true,true);
												} else {
													configSeries.push(val);
												}
											} else {
												configSeries.push(val);
											}

										});

										if (config.yAxis) {
											if (!showNegative) {
												config.yAxis.min = 0;
											} else {
												config.yAxis.min = undefined;
											}
										}

										$scope.setDateSensitiveFields();
										$scope.setSeriesColors(data);

										// when xaxis label is blank ':' is shown in the label.
										$scope.getLabelWithSeperator = function(value) {
											var label = "";
											if (value) {
												label = value + " : <b>";
											}
											return label;
										}

										//			 //set the tooltip
										if ($scope.component.multiBars == false) {
											if ($scope.component.chartType == "Pie" ||
													$scope.component.chartType == "Donut") {
												config.options.tooltip.formatter = function() {
													return "<span style='font-size: 14px;color:{this.point.color}'>" +
															$scope
																	.getLabelWithSeperator($scope.tooltipLabels[this.point.x]) +
															this.point.formattedY + "</b> (" +
															(Math.round(this.point.percentage * 100) / 100) + "%)" +
															"</span>";
												};
											} else {
												if ($scope.component.isDateTime) {
													config.options.tooltip.formatter = null;
												} else {
													config.options.tooltip.formatter = function() {
														return "<span style='font-size: 14px;color:{this.series.color}'>" +
																$scope.getLabelWithSeperator(this.point.xlabel) +
																this.point.formattedName +
																"</b></span> <br/><span style='font-size: 14px;color:{this.series.color}'>" +
																$scope.getLabelWithSeperator(this.point.ylabel) +
																this.point.formattedY + "</b></span><br/>";
													};
												}
											}
										} else {
											if ($scope.component.chartType == "heatmap") {
												config.options.tooltip.formatter = function() {
													var rColumn, hColumn;
													var span1 = "", span2 = "";
													if ($scope.component.heatMapRow) {
														rColumn = $scope.component.heatMapRow.column;
													}
													if ($scope.component.heatMapColumn) {
														hColumn = $scope.component.heatMapColumn.column;
													}

													if (rColumn) {
														span1 = "<span style='font-size: 14px;color:{this.series.color}'>" +
																$scope.getLabelWithSeperator(rColumn) +
																this.point.slabel + "</b></span> <br/>"
													}
													if (hColumn) {
														span2 = "<span style='font-size: 14px;color:{this.series.color}'>" +
																$scope.getLabelWithSeperator(hColumn) +
																this.point.name + "</b></span><br/>"
													}
													var tooltipStr = span1 +
															span2 +
															"<span style='font-size: 14px;color:{this.series.color}'>" +
															$scope.component.heatMapCell.column +
															' ' +
															$scope
																	.getLabelWithSeperator($scope.component.heatMapCell.aggrType) +
															this.point.formattedY + "</b></span><br/>";

													return tooltipStr;
												};
											} else if ($scope.component.measureDataField &&
													$scope.component.measureDataField.length > 1) {
												config.options.tooltip.formatter = function() {
													return "<span style='font-size: 14px;color:{this.series.color}'>" +
															$scope.getLabelWithSeperator(this.point.xlabel) +
															this.point.formattedName +
															"</b></span> <br/><span style='font-size: 14px;color:{this.series.color}'>" +
															$scope.getLabelWithSeperator(this.point.ylabel) +
															this.point.formattedY + "</b></span><br/>";
												};
											} else {
												config.options.tooltip.formatter = function() {
													return '<span style="font-size: 14px">' +
															$scope.getLabelWithSeperator(this.point.xlabel) +
															this.point.formattedName +
															'</b></span><br/>' +
															(this.point.slabel?
															'<span style="font-size: 14px">' +
															this.point.slabel + '  <b>' + this.point.formattedSvalue +
															'</b></span><br/>':'') + '<span style="font-size: 14px">' +
															$scope.getLabelWithSeperator(this.point.ylabel) +
															this.point.formattedY + '<b></span><br/>';
												};
											}
										}

										$scope.getLabelWithEllipsis = function(label) {
											var labelLengthToCheck = $scope.component.styles.chartPlotOptions.maxLegendLabelLength && isNaN($scope.component.styles.chartPlotOptions.maxLegendLabelLength) === false ? 	$scope.component.styles.chartPlotOptions.maxLegendLabelLength : 30;
											if (label && label.length > labelLengthToCheck) {
													return label.substring(0,labelLengthToCheck) +"...";
												}
											return label;
										}

										config.options.legend.labelFormatter = function() {
											var thisname = this.name;
											if (thisname === null || thisname === undefined) {
												thisname = "";
											} else if (thisname === "null") {
												thisname = "";
												this.color = 'transparent';
											} else {
												thisname = thisname.toString();
											}

											if (thisname === "$Other$") {
												thisname = "Other";
											}
											var yValue = this.formattedY;
											if (yValue === null) {
												yValue = 0;
											}

											if ($scope.component.chartType == "Pie" ||
													$scope.component.chartType == "Donut") {
												var numberOfDimensions = $scope.component.dimensionDataField.length;
												if(numberOfDimensions > 0) {
                                                    thisname = $scope
                                                        .getFormattedValue( thisname ,
                                                            $scope.component.dimensionDataField[numberOfDimensions - 1].formatter, undefined, undefined, undefined, $scope.component.dimensionDataField[numberOfDimensions - 1], $scope.dataSet);
													thisname = $scope.getLabelWithEllipsis(thisname);
                                                    return thisname + ": " + yValue + " (" +
                                                        (Math.round(this.percentage * 100) / 100) + "%)";
                                                } else {
												    return "";
                                                }
											} else {
												return $scope.getLabelWithEllipsis(thisname);
											}
										};

										// Set the point click function
										if (config.options.plotOptions[$scope.chartConfig.options.chart.type] === undefined) {
											config.options.plotOptions[$scope.chartConfig.options.chart.type] = {
												point : {
													events : {
														click : null
													}
												}
											}
										}
										if (config.options.plotOptions[$scope.chartConfig.options.chart.type].point === undefined) {
											config.options.plotOptions[$scope.chartConfig.options.chart.type].point = {
												events : {
													click : null
												}
											}
										}

										var getRowObject = function(component, event) {
											var row = {};
											console.log(event);
											if (event.data.dimensionValues && event.data.dimensionValues.length > 0) {
												row[component.dimensionDataField[0].column] = event.data.dimensionValues[0];
												if (component.dimensionDataField.length > 1) {
													if (event.data.dimensionValues.length > 1) {
														row[component.dimensionDataField[1].column] = event.data.dimensionValues[1];
													} else {
														row[component.dimensionDataField[1].column] = event.data.ylabel;
													}
												}
											} else {
												row[component.dimensionDataField[0].column] = event.data.x;
												if (component.dimensionDataField.length > 1) {
													row[component.dimensionDataField[1].column] = event.data.ylabel;
												}
											}

											if (component.measureDataField.length === 1) {
												var aggrType = component.measureDataField[0].aggrType;
												var key = component.measureDataField[0].column;
												if (aggrType.toLowerCase() !== "none") {
													key = aggrType + "(" + key + ")";
												}
												if (event.data.measureValues && event.data.measureValues.length > 0) {
													row[key] = event.data.measureValues[0];
												} else {
													row[key] = event.data.y;
												}
											} else if (component.measureDataField.length > 1) {
												row["aggregateName"] = event.data.ylabel;
												row["aggregateValue"] = event.data.y;
											}

											return row;
										}

										var evalChartExpression = function(component, event) {
											var row = getRowObject(component, event);
											var clickConfig = $scope.component.events.onClick;
											var evalExpr = function(expr) {
												return rpt.evalExpression({
													expression : expr,
													event : event,
													row : row
												})
											}

											var args = {
												expression : rpt.getButtonExpression(clickConfig, evalExpr),
												event : event,
												row : row
											}
											console.log()
											return rpt.evalExpression(args);
										}

										if ($scope.component.events && $scope.component.events.onClick) {

											// add click event on the point
											$scope.enableInteractivity(false); // disable the interactivity when the on click expression is used.

											var clickConfig = $scope.component.events.onClick;

											if (typeof clickConfig === 'string') {

												if (clickConfig.substring(0, 1) !== "=") {
													clickConfig = "=" + clickConfig;
												}

												clickConfig = {
													action : "Custom",
													customExpression : clickConfig
												};

												$scope.component.events.onClick = clickConfig;
											}

											config.options.plotOptions[$scope.chartConfig.options.chart.type].point.events.click = function(
													clickEvent) {

												var event = {
													data : {
														x : clickEvent.point.name,
														xlabel : clickEvent.point.xlabel,
														xindex : clickEvent.point.x,
														y : clickEvent.point.y,
														ylabel : clickEvent.point.ylabel,
														dimensionValues: clickEvent.point.dimensionValues,
														measureValues: clickEvent.point.measureValues
													}
												};

												evalChartExpression($scope.component, event);

												return false;
											}
											// add click event on the legend
											config.options.plotOptions[$scope.chartConfig.options.chart.type].point.events.legendItemClick = function(
													clickEvent) {
												var event = {
													data : {
														x : clickEvent.target.name,
														xlabel : clickEvent.target.xlabel,
														xindex : clickEvent.target.x,
														y : clickEvent.target.y,
														ylabel : clickEvent.target.ylabel
													}
												};

												evalChartExpression($scope.component, event);

												return false;
											}
											// add click event on the chart
											config.options.chart.events.click = function(clickEvent) {
												if (clickEvent.target.nodeName != 'rect') {
													return false;
												}
												var event = {
													data : {
														x : "",
														xlabel : "",
														xindex : "",
														y : "",
														ylabel : ""
													}
												};
												eval($scope.component.events.onClick);
												return false;
											}
										} else {
											config.options.plotOptions[$scope.chartConfig.options.chart.type].point.events.click = null;
											if (!config.options.plotOptions[$scope.chartConfig.options.chart.type].point.events.legendItemClick) {
												config.options.plotOptions[$scope.chartConfig.options.chart.type].point.events.legendItemClick = null;
											}
											config.options.chart.events.click = null;
										}
										if ($scope.component.chartType == "Pie" ||
												$scope.component.chartType == "Donut") {
											config.options.plotOptions.pie.dataLabels.formatter = function() {
												var val = this.point.y === null ? 0 : this.point.y;
												return $scope.tooltipLabels[this.point.x] + " (<b>" + val + "</b>)";
											};
										} else {
											config.options.plotOptions.pie.dataLabels.formatter = undefined;
										}

										if ($scope.component.styles.chartPlotOptions.stackIn3d === undefined) {
											$scope.component.styles.chartPlotOptions.stackIn3d = false;
										}

										if ($scope.component.styles.chartPlotOptions.alpha3D === undefined) {
											$scope.component.styles.chartPlotOptions.alpha3D = config.options.chart.options3d.alpha;
										}
										if ($scope.component.styles.chartPlotOptions.beta3D === undefined) {
											$scope.component.styles.chartPlotOptions.beta3D = config.options.chart.options3d.beta;
										}

										if ($scope.component.styles.chartPlotOptions.columnPadding3D === undefined) {
											$scope.component.styles.chartPlotOptions.columnPadding3D = config.options.plotOptions.column.groupZPadding;
										}

										if ($scope.component.chartType == 'Pie' || $scope.component.chartType == 'Donut') {
											if ($scope.component.styles.chartPlotOptions.depth3D === undefined) {
												$scope.component.styles.chartPlotOptions.depth3D = config.options.plotOptions.pie.depth;
											}
										} else {
											if ($scope.component.styles.chartPlotOptions.depth3D === undefined) {
												$scope.component.styles.chartPlotOptions.depth3D = config.options.chart.options3d.depth;
											}
										}

										var isMulti = $scope.component.dimensionDataField &&
												$scope.component.dimensionDataField.length > 1;
										//config.options.chart.marginTop = config.options.legend.enabled ? 60 : undefined;
										//set legend.
										if (($scope.component.styles.chartPlotOptions.isShowLegend === undefined &&
												(isMulti || $scope.component.multiBars ||
														$scope.component.chartType == "Pie" || $scope.component.chartType == "Donut") && $scope.component.chartType != "heatmap") ||
												$scope.component.styles.chartPlotOptions.isShowLegend === true) {
											config.options.legend.enabled = true;
											$scope.component.styles.chartPlotOptions.isShowLegend = true
										} else {
											config.options.legend.enabled = false;
										}

										if (config.options.legend.enabled === true) {
											if ($scope.component.styles.chartPlotOptions.legendPosition == "left") {
												config.options.legend.align = "left";
												config.options.legend.layout = "vertical";
												config.options.legend.verticalAlign = "middle";
											} else if ($scope.component.styles.chartPlotOptions.legendPosition == "right") {
												config.options.legend.align = "right";
												config.options.legend.layout = "vertical";
												config.options.legend.verticalAlign = "middle";
											} else if ($scope.component.styles.chartPlotOptions.legendPosition == "top") {
												config.options.legend.align = "center";
												config.options.legend.layout = "horizontal";
												config.options.legend.verticalAlign = "top";
											} else if ($scope.component.styles.chartPlotOptions.legendPosition == "bottom") {
												config.options.legend.align = "center";
												config.options.legend.layout = "horizontal";
												config.options.legend.verticalAlign = "bottom";
											}

											if ($scope.gridster && $scope.gridster.isMobile) {
												config.options.legend.align = "center";
												config.options.legend.layout = "horizontal";
												config.options.legend.verticalAlign = "bottom";
											}
										}

										if (config.options.plotOptions[$scope.chartConfig.options.chart.type] === undefined) {
											config.options.plotOptions[$scope.chartConfig.options.chart.type] = {
												dataLabels : {
													enabled : null
												}
											};
										}
										if (config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels === undefined) {
											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels = {
												enabled : null
											};
										}
										if ($scope.component.styles.chartPlotOptions.isShowLabels === true) {

											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.enabled = true;
											if ($scope.component.multiBars === true) {
												config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.inside = true;
											} else {
												config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.inside = false;
											}
											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.style = {
												"color" : "#000",
												"fontWeight" : "500"
											}
											if ($scope.component.chartType === "Pie" ||
													$scope.component.chartType === "Donut") {
												config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.formatter = function() {
													var lbl = this.key === "$Other$" ? "Other" : this.key;
													return lbl + " : " + this.point.formattedY + " (" +
															this.percentage.toFixed(2) + "%)"
												};
											} else {
												if ($scope.component.chartType === 'heatmap') {
													var markerConfig = {
														enabled : false,
														lineWidth : 0,
														states : {
															hover : {
																enabled : false
															},
															select : {
																fillColor : null,
																lineWidth : 0,
																radius : 6
															}
														}
													};
													config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.formatter = undefined;
													config.options.plotOptions[$scope.chartConfig.options.chart.type].marker = markerConfig;
												}
												if ($scope.component.chartType === 'treemap') {
													config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.formatter = function() {

														return this.point.formattedName;
													}
												} else {
													config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.formatter = function() {
														return this.point.formattedY;
													};
												}

											}
										} else {
											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.enabled = false;
										}

										// Check if we are working with a "Donut" type of pie chart
										if ($scope.component.chartType == "Donut") {
											$scope.chartConfig.series[0]['size'] = "100%";
											$scope.chartConfig.series[0]['innerSize'] = ($scope.component.styles.chartPlotOptions.innerWidth || 60)
													.toString() +
													"%";
											$scope.chartConfig.series[0]['startAngle'] = ($scope.component.styles.chartPlotOptions.startAngle || -150);
											$scope.chartConfig.series[0]['endAngle'] = ($scope.component.styles.chartPlotOptions.endAngle || 150);
										} else {
											$scope.chartConfig.series[0]['size'] = null;
											$scope.chartConfig.series[0]['innerSize'] = null;
											$scope.chartConfig.series[0]['startAngle'] = null;
											$scope.chartConfig.series[0]['endAngle'] = null;
										}

										$scope.enable3dGraph($scope.component.styles.chartPlotOptions.enable3dGraph);

										$scope.chartConfig.options.chart.options3d.alpha = $scope.component.styles.chartPlotOptions.alpha3D;

										if($scope.component.chartType == 'Donut' || $scope.component.chartType == 'Pie' ) {
											$scope.chartConfig.options.chart.options3d.beta = 0;
											$scope.chartConfig.options.plotOptions.pie.depth = $scope.component.styles.chartPlotOptions.depth3D;
											$scope.chartConfig.options.chart.animation = false;

										} else {
											$scope.chartConfig.options.chart.options3d.beta = $scope.component.styles.chartPlotOptions.beta3D;
											$scope.chartConfig.options.chart.options3d.depth = $scope.component.styles.chartPlotOptions.depth3D;
											$scope.chartConfig.options.plotOptions.column.groupZPadding = $scope.component.styles.chartPlotOptions.columnPadding3D;

											if ($scope.component.styles.chartPlotOptions.enable3dGraph &&
													!$scope.component.styles.chartPlotOptions.stackIn3d) { //if stacking is false in 3d option
												$scope.chartConfig.series.forEach(function(el, i) {
														el.stack = i;
													}
												);
											}
										}


										if ($scope.component.isGrouped) {
											$scope.chartConfig.options.plotOptions.column.grouping = true;
										} else {
											$scope.chartConfig.options.plotOptions.column.grouping = false;
										}

										$scope
												.setShowGridlines($scope.component.styles.chartPlotOptions.isShowGridlines);
										$scope
												.setYAutoConversion($scope.component.styles.chartPlotOptions.autoConvertYValues);
										if ($scope.chartConfig.xAxis) {
											if ($scope.component.rotateXAxisLabels) {
												if ($scope.component.rotateXAxisLabelsDegrees != "") {
													$scope.chartConfig.xAxis.labels.rotation = parseInt($scope.component.rotateXAxisLabelsDegrees);
												} else {
													$scope.chartConfig.xAxis.labels.rotation = -45;
												}
											} else {
												$scope.chartConfig.xAxis.labels.rotation = undefined;
											}
										}

										if (isExport) {
											if ($scope.component.chartType == 'HorizontalBar') {
												$scope.chartConfig.xAxis.labels.style['padding-right'] = '15px';
											}

											if (isExport && $scope.component.chartType == 'VerticalBar') {
												$scope.chartConfig.yAxis.labels.style['padding-right'] = '10px';
											}
										}
										if ($scope.chartConfig.xAxis) {
											if ($scope.component.rotateXAxisLabels == true) {
												$scope.chartConfig.xAxis.labels.useHTML = false;
											} else {
												$scope.chartConfig.xAxis.labels.useHTML = true;
											}
										}

										if (config.xAxis) {
											if ($scope.component.chartType != 'Pie' &&
													$scope.component.chartType != 'Line' &&
													$scope.component.chartType != 'TimeSeries') {
												if ($scope.component.toggleChart) {
													config.xAxis.reversed = true;
												} else {
													config.xAxis.reversed = false;
												}
											}
										}

										if ($scope.component.chartType === 'Pie' ||
												$scope.component.chartType === 'Donut') {
											$scope.chartConfig.xAxis.lineWidth = 0;
											$scope.chartConfig.yAxis.lineWidth = 0;
											$scope.chartConfig.xAxis.title.text = "";
											$scope.chartConfig.yAxis.title.text = "";
										}
										//reset loading message
										config.loading = false;

										$scope.enableDisableDataFetch($scope.component.id, false);

										if (!$scope.componentLoaded) {
											$timeout(function() {
												$scope.componentLoaded = true;
												if (isExport) {
													$scope.setAllComponentsIntialized($scope.component);
												}
											});
										}

										if ($scope.component.chartScript) {
											$scope.applyChartScript($scope.component.chartScript);
										}

										$scope.component.isChartExist = true;
										$timeout(function() {
											// if($scope.isDcubeEnabledInCustomReports) {
											//     // reflow chart when loading is done to get properly in gridster layout
											//     $scope.$broadcast('resize');
											// }
											$scope.masked = false;
											angular.element("#chart_" + $scope.$index + " svg").off("click");
											angular.element("#chart_" + $scope.$index + " svg").on("click", function() {
												$scope.setActiveComponent($scope.component);
											});
											if ($scope.chartConfig &&
													typeof $scope.chartConfig.getHighcharts === 'function') {
												var chart = $scope.chartConfig.getHighcharts();
												if ($scope.dataSet.endpoint !== "DATACUBE" ||
														($scope.dataSet.endpoint === "DATACUBE" && $scope.useCREApiForSolr)) {
													$scope.setSeriesSelected(chart);
												} else {
													applyChartFilters(chart);
												}
												$timeout(function() {
													chart.redraw();
												},200);
											}
										});
										if ($scope.component.chartType === "heatmap" ||
												$scope.component.chartType === "treemap") {
											// config.options.chart.zoomType = 'xy';
											var isTreemap = $scope.component.chartType === "treemap";
											if (isTreemap) {

												config.options.chart.showAxes = false;
												config.options.title = '';
												delete $scope.chartConfig.xAxis;
												delete $scope.chartConfig.yAxis;
											}

											var seriesOptions = config.options.plotOptions.series;
											var isMulti = $scope.component.dimensionDataField &&
													$scope.component.dimensionDataField.length > 1;

											if (isMulti && isTreemap) {
												config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.enabled = false;
											}

											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.color = isTreemap ? '#ffffff'
													: '#000000';
											seriesOptions.dataLabels.allowOverlap = false;
											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.allowOverlap = false;

											seriesOptions.dataLabels.inside = true;
											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.align = 'center';
											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.inside = true;
											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.style = {};
											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.style.textShadow = 'none';
											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.style.fontSize = '12px';
											config.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.style.width = '100px';

										}

										if ($scope.component.isQuickAnalysis) {
											customReportSvc.triggerCallback("resizeComponent",$scope.component.parentId);
										}

									}

									/*
									 * var onError = function(error) { $scope.masked = false;
									 * console.log("Error fetching data"); if (error.data.length > 450) { var
									 * intialText = error.data.substring(0, 450); var endText =
									 * error.data.substring(450);
									 * customReportSvc.errorWithDetailsToast($.trim(intialText),
									 * $.trim(endText), "Continue &gt;&gt;", "Less &lt;&lt;", true); } else {
									 * alert(error.data); } }
									 */

								};

								$scope.convertLabelDisplayString = function(label, formatter) {
									var returnVal = label;
									if (label == "") {
										return returnVal;
									} else if (formatter === undefined || formatter == "") {
										return returnVal;
									} else {
										var expression = formatter;
										var cellData = label;
										if (typeof expression === "string" && expression.substring(0, 1) === "=") {
											try {
												returnVal = eval(expression.substring(1));
											} catch (exception) {
												console.error(exception.message);
											}
										} else if (typeof expression === "string" &&
												expression.substring(0, 2) === ":=") {
											try {
												var expr = "(function() {" + expression.substring(2) + " }) ();";
												returnVal = eval(expr);
											} catch (exception) {
												console.error(exception.message);
											}
										}
										return returnVal;
									}
								}

								$scope.enableDisableDataFetch = function(componentName, fetchData) {
									/*
									 * angular.forEach($scope.customReport.body.reportComponents,
									 * function(value, key) { if(value.name == componentName){ value.fetchData =
									 * fetchData; }else{ value.fetchData = false; } });
									 */
								};

								$scope.reflowChart = function() {
									var chart = $scope.chartConfig.getHighcharts();
									$timeout(function() {
										chart.reflow();
									}, 200);
								}

								$scope.dropped = function(dragEl, dropEl) {
									// Because the handler jumps "outside" of angular, updates must be
									// made in an $applied scope

									var dest = document.getElementById(dropEl);
									var src = document.getElementById(dragEl);

									var drag = angular.element(src);
									var drop = angular.element(dest);
									var columnName = drag.attr("data-name");
									var columnType = drag.attr("data-type");
									if (columnName == "allColumns") {
										customReportSvc.errorToast('All Fields cannot be used to draw a chart.');
										return;
									}

									var dataSetEntity = drag.data("datasetentity");
									var dataSetName = drag.parent().parent().data("datasetname");
									var isMulti = $scope.component.chartType.indexOf("Stack") != -1 ||
											$scope.component.chartType.indexOf("Group") != -1;
									if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
										$scope.associateDataSetToComponent(dataSetEntity);
									} else if ($scope.component.dataSet.dataSetName != dataSetName) {
										alert("Mismatched data Sets");
										return;
									}

									if ($scope.isTileBuilder && $scope.tileProperties) {
										var guid = drag.data("datasetguid");
										if (!guid) {
											guid = dataSetEntity.dataSetGuid;
										}
										$scope.tileProperties["outcomeDataset"] = guid;
										$scope.tileProperties["outcomeColumn"] = columnName;
									}

									// initialize the data field if not already not set
									if (!$scope.component.dimensionDataField) {
										$scope.component.dimensionDataField = [];
									}
									if (!$scope.component.measureDataField) {
										$scope.component.measureDataField = [];
									}

									if (drop.data('droptype') == "xAxis") {
										var isTreemap = $scope.component.chartType === "treemap";
										if ($scope.component.dimensionDataField.length == 0 &&
												$scope.component.chartType == "TimeSeries" &&
												dates.indexOf(drag.data('type')) == -1) {
											$scope.dataSet = undefined;
											$scope.component.dataSet = undefined;
											customReportSvc
													.errorToast("Only field of type TimeStamp, Date or Integer(Unix Time) can be added to X-Axis in Timeline chart.");
											return;
										}

										// if a field is already added to dimension, it can have multiple fields only if there is single/no measure fields, also duplicates are not allowed
										// more than two dimensions cannot be plotted
										// more than one dimension cannot be plotted in a pie chart
										if ($scope.component.dimensionDataField.indexOf(drag.attr("data-name")) != -1 ||
												$scope.component.dimensionDataField.length == 2 ||
												($scope.component.measureDataField.length > 1 && $scope.component.dimensionDataField.length == 1) ||
												($scope.component.chartType == "Pie" && $scope.component.dimensionDataField.length == 1) ||
												($scope.component.chartType == "Donut" && $scope.component.dimensionDataField.length == 1)) {
											//TODO show proper message that multiple dimension fields cannot be added
											return;
										}

										var dimension = {
											'column' : drag.attr("data-name"),
											'title' : {
												'text' : drag.attr("data-name")
											},
											sortOrder : 'NONE',
											isNumeric : false ,
											type : drag.attr("data-type")
										};
										//if ($scope.$parent.dataSet.endpoint === 'DATACUBE') {
										dimension.customGroupsAvailable = false;
										//}
										dimension.numPointsToDisplay = {};
										dimension.numPointsToDisplay.maxPoints = $scope.component.dimensionDataField.length == 0 ? isTreemap ? 10
												: 15
												: isTreemap ? 5 : 10;
										dimension.numPointsToDisplay.includeAll = false;
										dimension.showMinCount = ($scope.dataSet.endpoint === 'DATACUBE' &&
												!$scope.useCREApiForSolr && isTreemap) ? true : false;
										if (dimension.showMinCount) {
											dimension.minCount = 1;
										}
										$scope.component.dimensionDataField.push(dimension);
										// add the default measure same as dimension if there is none
										// Do not add the date field automatically to the Y-Axis for TimeSeries charts
										if ($scope.component.measureDataField.length == 0 &&
												$scope.component.dimensionDataField.length == 1 &&
												$scope.component.chartType != "TimeSeries") {
											// to avoid loading the graph twice
											$scope.firstDrop = true;
											var measure = {
												'column' : drag.attr("data-name"),
												'title' : {
													'text' : drag.attr("data-name")
												},
												'aggrType' : 'Count',
												sortOrder : 'DESC',
												type : drag.attr("data-type")
											};
											$scope.component.measureDataField.push(measure);

											var arr = [ 'Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal' ];
											if (arr.indexOf(drag.data('type')) != -1) {
												measure.showNumberOps = true;
											}
										}

										// When dropping a field, decide if we will enable time grouping
										if ($scope.component.dimensionDataField.length == 1 &&
												dates.indexOf(drag.data('type')) != -1) {
											dimension.showTimeGrouping = true;
											dimension.showHourlyGrouping = true;
											// If we have dropped a date field, do not show hourly grouping since there are no hours in the dataset
											if (drag.data('type') == "Date") {
												dimension.showHourlyGrouping = false;
											}
											// If we have just dragged a time-enabled field onto a TimeLine chart, we have no "None" option, so set isTimeGrouping to true by default
											if ($scope.component.chartType == "TimeSeries") {
												dimension.onlyTimeInfo = $scope.getOnlyTimeInfo(drag
														.attr("data-datafield"));
												$scope.component.isTimeGrouping = true;
												dimension.timeGrouping = "auto";
												if (drag.data('type') == "Integer") {
													dimension.isNumeric = true;
												}
											} else {
												dimension.timeGrouping = "None";
											}
										}

									} else if (drop.data('droptype') == "yAxis") {
										// if a field is already added to measure, it can have multiple fields only if there is single/no dimension fields, also duplicates are not allowed
										// more than one dimension cannot be plotted in a pie chart
										if ($scope.component.measureDataField.indexOf(drag.attr("data-name")) != -1 ||
												($scope.component.dimensionDataField.length > 1 && $scope.component.measureDataField.length == 1) ||
												($scope.component.chartType == "Pie" && $scope.component.measureDataField.length == 1) ||
												($scope.component.chartType == "Donut" && $scope.component.measureDataField.length == 1)) {
											//TODO show proper message that multiple measure fields cannot be added
											return;
										}

										var measure = {
											'column' : drag.attr("data-name"),
											'title' : {
												'text' : drag.attr("data-name")
											},
											'aggrType' : 'Count',
											sortOrder : 'DESC'
										};
										if ($scope.component.measureDataField.length > 0) {
											measure.aggrType = $scope.component.measureDataField[0].aggrType;
										}

										$scope.component.measureDataField.push(measure);

										var arr = [ 'Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal' ];
										if (arr.indexOf(drag.data('type')) != -1) {
											measure.showNumberOps = true;
										}
									}
									if ($scope.component.type == 'HEAT_MAP') {
										handleHeatMapEntityDrop(drop, columnName, columnType);
									}
									$scope.$apply();
								};

								var handleHeatMapEntityDrop = function(drop, columnName, columnType) {
									//TODO to add support for single dimension also
									var showNumberOps = false;
									if (drop.data('droptype') == "heatMapRow") {
										$scope.component.heatMapRow = {
											column : columnName
										};
										var dimension = {
											'column' : $scope.component.heatMapRow.column,
											'title' : {
												'text' : columnName
											}
										};
										dimension.numPointsToDisplay = {};
										dimension.customGroupsAvailable = false;
										dimension.numPointsToDisplay.maxPoints = $scope.component.dimensionDataField.length == 0 ? 15
												: 10;
										dimension.numPointsToDisplay.includeAll = false;
										dimension.showMinCount = ($scope.dataSet.endpoint === 'DATACUBE' && !$scope.useCREApiForSolr) ? true
												: false;
										if (dimension.showMinCount) {
											dimension.minCount = 1;
										}

										$scope.component.dimensionDataField.push(dimension);

									} else if (drop.data('droptype') == "heatMapColumn") {
										$scope.component.heatMapColumn = {
											column : columnName
										};
										var dimension = {
											title : {
												text : columnName
											},
											'column' : $scope.component.heatMapColumn.column
										};
										dimension.numPointsToDisplay = {};
										dimension.customGroupsAvailable = false;
										dimension.numPointsToDisplay.maxPoints = $scope.component.dimensionDataField.length == 0 ? 15
												: 10;
										dimension.numPointsToDisplay.includeAll = false;
										dimension.showMinCount = ($scope.dataSet.endpoint === 'DATACUBE' && !$scope.useCREApiForSolr) ? true
												: false;
										if (dimension.showMinCount) {
											dimension.minCount = 1;
										}
										$scope.component.dimensionDataField.push(dimension);

									} else if (drop.data('droptype') == "heatMapCell") {
										if ($scope.isNumberColumn(columnType)) {
											showNumberOps = true;
										}
										$scope.component.heatMapCell = {
											title : {
												text : columnName
											},
											column : columnName,
											aggrType : "Count",
											showNumberOps : showNumberOps
										};
									} else {
										alert('Drop the column in the designated fields above');
										return;
									}

									$scope.firstDrop = false;
									if ($scope.component.heatMapRow.column && $scope.component.heatMapColumn) {
										if (!$scope.component.heatMapCell || !$scope.component.heatMapCell.column) {
											$scope.component.heatMapCell = {
												title : {
													text : columnName
												},
												column : columnName,
												aggrType : "Count",
												showNumberOps : $scope.isNumberColumn(columnType)
											};
										}
										if ($scope.component.measureDataField.length == 0) {
											$scope.firstDrop = true;
											$scope.component.measureDataField.push({
												column : $scope.component.heatMapCell.column,
												aggrType : $scope.component.heatMapCell.aggrType,
												sortOrder : "desc",
												title : $scope.component.heatMapCell.title,
												showNumberOps : showNumberOps
											});
										}
									}
								};
								//	//update the DOM directly instead of scope. the event get triggered multiple times and calls to $apply throws error
								//	$scope.$on("LVL-DRAG-START", function(event,dragEl) {
								//		if ($scope.disableYDrop == true || $scope.component.isSelected == false)
								//			return;
								//
								//		angular.element("#" + $scope.component.id + " .yAxisColumnDrop").addClass("disableColumnDrop");
								//		var drag = angular.element(dragEl);
								//		var fieldType = drag.data('type');
								//
								//		if ($scope.isNumberAggregate() && !$scope.isNumberColumn(fieldType))
								//			angular.element("#chart_" + $scope.$index + " .yAxisColumnDrop").addClass("disableColumnDrop");
								//		else
								//			angular.element("#chart_" + $scope.$index + " .yAxisColumnDrop").removeClass("disableColumnDrop");
								//   });
								//
								//	//update the DOM directly instead of scope. the event get triggered multiple times and calls to $apply throws error
								//	$scope.$on("LVL-DRAG-END", function(event,dragEl) {
								//		if ($scope.disableYDrop == true ||  $scope.component.isSelected == false)
								//			return;
								//
								//		angular.element("#chart_" + $scope.$index + " .yAxisColumnDrop").removeClass("disableColumnDrop");
								//
								//   });
								//

								$scope.getOnlyTimeInfo = function(fieldName) {

									var onlyTimeInfo = {};

									onlyTimeInfo.onlyTimeField = false;
									onlyTimeInfo.displayTimeInLocalTimeZone = false;

									if ($scope.dataSet.endpoint === "MONITORING_POLICY") {
										onlyTimeInfo.onlyTimeField = fieldName.indexOf("_t_if") === (fieldName.length - "_t_if".length);
										onlyTimeInfo.displayTimeInLocalTimeZone = fieldName.indexOf("_u_t_if") === (fieldName.length - "_u_t_if".length);
									}

									return onlyTimeInfo;
								};

								$scope.isNumberAggregate = function() {
									return numberOps.indexOf($scope.component.aggrType) != -1;
								};

								$scope.isNumberColumn = function(type) {
									return numberTypes.indexOf(type) != -1;
								};

								$scope.setShowGridlines = function(show) {
									if ($scope.chartConfig.xAxis) {
										if (show) {
											$scope.chartConfig.xAxis.tickPosition = "inside";
											$scope.chartConfig.xAxis.gridLineWidth = 1;
										} else {
											$scope.chartConfig.xAxis.tickPosition = "outside"
											$scope.chartConfig.xAxis.gridLineWidth = 0;
										}
									}

								}

								$scope.enable3dGraph = function(show) {
									if (typeof $scope.chartConfig.options.chart.options3d != "undefined") {
										if (show) {
											$scope.chartConfig.options.chart.options3d.enabled = true;
										} else {
											$scope.chartConfig.options.chart.options3d.enabled = false;
										}
									}
								}

								$scope.applyChartScript = function(expr) {
									var args = {
											expression : expr,
											chartConfig : $scope.chartConfig
									};
									rpt.evalExpression(args);
								}

								$scope.setYAutoConversion = function(autoconvert) {
									if ($scope.chartConfig.yAxis) {
										if (autoconvert) {
											$scope.chartConfig.yAxis.labels.formatter = null;
										} else {
											$scope.chartConfig.yAxis.labels.formatter = function() {
												var formatter = $scope.component.convertYAxisLabel ||
														($scope.component.measureDataField.length > 0 && $scope.component.measureDataField[0].formatter),
												column = $scope.component.measureDataField.length > 0 ? $scope.component.measureDataField[0] : undefined;
												return $scope.getFormattedValue(this.value,
														formatter,
														undefined,
														undefined,
														undefined,
														column,
														$scope.dataSet);
											}
										}
									}

								}

								$scope.$watchCollection('component.dimensionDataField', function() {
									if (!$scope.componentLoaded || $scope.processing) {
										return;
									}
									if ($scope.activeComponent == null || $scope.activeComponent == $scope.component) {
										$scope.component.xAxisTitle.text = null;
									}
									$scope.drawChart();
								}, true);

								$scope.$watchCollection('component.measureDataField', function() {
									if ($scope.firstDrop) {
										$scope.firstDrop = false;
										return;
									}
									if (!$scope.componentLoaded || $scope.processing) {
										return;
									}

									if ($scope.activeComponent == null || $scope.activeComponent == $scope.component) {
										if (!$scope.component.measureDataField) {
											$scope.disableYDrop = false;
										}
										$scope.component.yAxisTitle.text = null;
										$scope.drawChart();
									}
								}, true);

								$scope.$watch('component.toggleChart', function() {
									if (!$scope.componentLoaded || $scope.processing) {
										return;
									}
									if ($scope.chartConfig.xAxis) {
										if ($scope.component.toggleChart) {
											$scope.chartConfig.xAxis.reversed = true;
										} else {
											$scope.chartConfig.xAxis.reversed = false;
										}
									}

									$scope.drawChart();
								}, true);

								/*
								 * $scope.$watch('component.styles.width', function() { if
								 * (!$scope.componentLoaded || $scope.processing) return;
								 *
								 * if ($scope.component.styles.width == -1 || $scope.component.styles.width ==
								 * "") $scope.chartConfig.size.width = defaultWidth; else
								 * $scope.chartConfig.size.width=$scope.component.styles.width; },true);
								 *
								 * $scope.$watch('component.styles.height', function() { if
								 * (!$scope.componentLoaded || $scope.processing) return;
								 *
								 *
								 * if ($scope.component.styles.height == -1 ||
								 * $scope.component.styles.height=="") $scope.chartConfig.size.height =
								 * defaultHeight; else
								 * $scope.chartConfig.size.height=$scope.component.styles.height; },true);
								 */

								/*
								 * $scope.$watch('component.styles.barSize', function() { if
								 * (!$scope.componentLoaded || $scope.processing) return;
								 *
								 * var barSize = defaultBarSize; if ($scope.component.styles.barSize == -1)
								 * barSize = undefined; else if ($scope.component.styles.barSize != "")
								 * barSize = $scope.component.styles.barSize;
								 *
								 * var data = $scope.chartConfig.series; angular.forEach(data, function(val) {
								 * val.pointWidth = barSize; }); }, true);
								 *
								 *
								 */

								$scope.$watch('[component.styles.barColor,component.chartColor,component.enableMonochromeFill]', function() {
									if (!$scope.componentLoaded || $scope.processing) {
										return;
									}

									$scope.setSeriesColors();

								}, true);

								$scope.$watch('component.quickChartHeight', function(val) {
									$scope.chartConfig.options.chart.height = $scope.getHeight();
								})

								$scope.$watch('component.seriesFormatting', function() {
									if (!$scope.componentLoaded || $scope.processing) {
										return;
										/*
										 * if ($scope.component.seriesFormatting.length==0
										 * ||$scope.component.seriesFormatting == undefined) return;
										 */
									}

									$scope.setSeriesColors();

								}, true);

								$scope
										.$watch('component.styles.chartPlotOptions',
												function() {
													if (!$scope.componentLoaded || $scope.processing) {
														return;
													}

													$scope
															.setShowGridlines($scope.component.styles.chartPlotOptions.isShowGridlines);
													$scope
															.setYAutoConversion($scope.component.styles.chartPlotOptions.autoConvertYValues);
													$scope.chartConfig.options.chart.type = getChartType($scope.component.chartType);
													$scope.chartConfig.options.plotOptions[$scope.chartConfig.options.chart.type].dataLabels.enabled = $scope.component.styles.chartPlotOptions.isShowLabels;
												},
												true);

								$scope.$watch('component.styles.chartPlotOptions.isShowLineMarkers', function() {
									if (!$scope.componentLoaded || $scope.processing) {
										return;
									}

									var showMarker = $scope.component.styles.chartPlotOptions.isShowLineMarkers;
									//angular.copy($scope.rawData, data);
									var seriesData = [];
									angular.copy($scope.chartConfig.series, seriesData);
									$scope.chartConfig.series.splice(0, $scope.chartConfig.series.length);
									angular.forEach(seriesData, function(val, index) {
										val.marker.enabled = showMarker;
										val.marker.radius = showMarker ? 2 : 0;
										$scope.chartConfig.series.push(val);
									});
								}, true);

								$scope
										.$watch('component.rotateXAxisLabels',
												function() {
													if (!$scope.componentLoaded || $scope.processing) {
														return;
													}
													if ($scope.chartConfig.xAxis) {
														if ($scope.component.rotateXAxisLabels) {
															if (!("rotateXAxisLabelsDegrees" in $scope.component)) {
																$scope.component.rotateXAxisLabelsDegrees = -30;
															}
															$scope.chartConfig.xAxis.labels.rotation = parseInt($scope.component.rotateXAxisLabelsDegrees);
															$scope.chartConfig.xAxis.labels.useHTML = false;
														} else {
															$scope.chartConfig.xAxis.labels.rotation = undefined;
															$scope.chartConfig.xAxis.labels.useHTML = true;
														}
													}

												},
												true);

								$scope
										.$watch('component.rotateXAxisLabelsDegrees',
												function() {
													if (!$scope.componentLoaded || $scope.processing ||
															!$scope.component.rotateXAxisLabels) {
														return;
													}
													if ($scope.chartConfig.xAxis) {
														if ($scope.component.rotateXAxisLabelsDegrees != "") {
															$scope.chartConfig.xAxis.labels.rotation = parseInt($scope.component.rotateXAxisLabelsDegrees);
														} else {
															$scope.chartConfig.xAxis.labels.rotation = undefined;
														}
													}

												},
												true);

								$scope
										.$watch('component.isGrouped',
												function(newValue, oldValue) {
													if (!$scope.componentLoaded || $scope.processing) {
														return;
													}

													if (newValue == oldValue) {
														return;
													}
													if ($scope.component.dimensionDataField.length > 0 &&
															($scope.component.chartType == 'VerticalBar' || $scope.component.chartType == 'HorizontalBar')) {
														$scope.drawChart();
													}
												},
												true);

								$scope
										.$watch('component.chartType',
												function(newValue, oldValue) {
													if ($scope.component.chartType === 'heatmap') {
														if (!$.isEmptyObject($scope.component.dimensionDataField)) {
															$scope.component.heatMapRow = $scope.component.dimensionDataField[0];
															$scope.component.heatMapColumn = $scope.component.dimensionDataField[1];
															$scope.component.heatMapCell = $scope.component.measureDataField[0];
														}
													}
													if (!$scope.componentLoaded || $scope.processing) {
														return;
													}

													if ($scope.component.chartType == undefined) {
														return;
													}

													$scope.processing = true;

													if ((newValue.indexOf("Stack") == -1 && newValue.indexOf("Group") == -1) &&
															($scope.component.categoryFields != undefined && $scope.component.categoryFields.length == 2)) {
														$scope.component.categoryFields.pop();
													}
													if ($scope.component.seriesFormatting &&
															((oldValue == "HorizontalBar" || oldValue == "VerticalBar") && (newValue
																	.indexOf("Stack") != -1 || newValue
																	.indexOf("Group") != -1)) ||
															((oldValue.indexOf("Stack") != -1 || oldValue
																	.indexOf("Group") != -1) && (newValue == "HorizontalBar" || newValue == "VerticalBar"))) {
														$scope.component.seriesFormatting.splice(0,
																$scope.component.seriesFormatting.length);
													}

													if ($scope.component.chartType != 'TimeSeries') {
														$scope.component.isDateTime = false;
													}

													$timeout(function() {
														$scope.processing = false;
													});

													$scope.drawChart();
												},
												true);

								$scope.$watch('component.xAxisTitle.text', function() {
									if (!$scope.componentLoaded || $scope.processing) {
										return;
									}
									var xTitle = $scope.component.xAxisTitle.text;
									if ($scope.chartConfig.xAxis) {
										$scope.chartConfig.xAxis.title.text = xTitle;
									}
									var data = $scope.chartConfig.series;
									angular.forEach(data, function(val) {
										angular.forEach(val.data, function(point) {
											point.xlabel = xTitle;
										})
									});

								}, true);

								$scope.$watch('component.yAxisTitle.text', function() {
									if (!$scope.componentLoaded || $scope.processing) {
										return;
									}
									if ($scope.chartConfig.yAxis) {
										var yTitle = $scope.component.yAxisTitle.text;
										$scope.chartConfig.yAxis.title.text = yTitle;
										var data = $scope.chartConfig.series;
									}

									/*
									 * Do not update the labels as this changes the tooltips to a label we do
									 * not want angular.forEach(data, function(val) {
									 * angular.forEach(val.data, function(point) { point.ylabel = yTitle; })
									 * });
									 */
								}, true);

								//	$scope.$watch('component.isDateTime', function() {
								//		if (!$scope.componentLoaded || $scope.processing)
								//			return;
								//
								//		$scope.drawChart();
								//
								//	}, true);

								$scope.enableInteractivity = function(enable) {
									$scope.chartConfig.options.plotOptions.series.point.events.select = enable === false ? null
											: $scope.pointSelect;
									$scope.chartConfig.options.chart.events.selection = enable === false ? null
											: $scope.selectPointsByDrag;
									if ($scope.component.chartType === 'Pie' || $scope.component.chartType == "Donut") {
										$scope.chartConfig.options.plotOptions.pie.point.events.legendItemClick = enable === false ? null
												: $scope.legendSelect;
									}
									$scope.chartConfig.options.chart.interactiveEnabled = enable;
									$scope.chartConfig.options.plotOptions.series.allowPointSelect = enable;
								}

								$scope.drawChart = function(isAutoRefresh) {
									var component = $scope.component;
									if (!$scope.chartConfig) {
										$scope.chartConfig = getChartConfig();
									}
									//if ($scope.dataSet && $scope.dataSet.endpoint === 'DATACUBE') {

									if (!$scope.component.disableInteractivity) {
										$scope.enableInteractivity(true);
									}

									//}
									if (!$scope.isLayoutAvailable) {
										$scope.component.isChartExist = false;
									}
									var isValid = false;
									var isMulti = component.chartType.indexOf("Stack") != -1 ||
											component.chartType.indexOf("Group") != -1;
									if (component.dimensionDataField && component.measureDataField &&
											component.dimensionDataField.length != 0 &&
											component.measureDataField.length != 0) {
										if (component.chartType == "heatmap" && component.dimensionDataField.length < 2) {
											isValid = false;
										} else {
											isValid = true;
										}

									}

									if (isValid == true) {
										$scope.componentLoaded = false;
										$scope.component.isComponentLoading = true;
										if(!isAutoRefresh)
											$scope.loadingButton();
										$scope.getChartData(isAutoRefresh);
									} else {
										$scope.component.isChartExist = false;
										if (!$scope.componentLoaded) {
											$timeout(function() {
												$scope.componentLoaded = true;
											});
										}
									}
								};

								$scope.aggregateSelectionChanged = function() {
									$scope.processing = true;
									$scope.component.yAxisTitle.text = null;
									$scope.processing = false;
									if ($scope.component.chartType === 'heatmap') {
										angular.forEach($scope.component.measureDataField, function(field) {
											field.aggrType = $scope.component.heatMapCell.aggrType;
										});
									}
									$scope.drawChart();
								}

								$scope.timeGroupingSelectionChanged = function(grouping) {
									$scope.component.showCompare = false;
									if (grouping !== "None") {
										$scope.component.isTimeGrouping = true;

										if(grouping == "auto" && $scope.component.showCompare == true)
											$scope.component.chartTimeGroup = $scope.tempComponent.chartTimeGroup;

									} else {
										$scope.component.isTimeGrouping = false;
									}

									$scope.drawChart();

								}

								$scope.compareOptionChanged = function(){
									if($scope.compareInfo.selectedCompareOption == $scope.compareNoneOption)
									{
										$scope.component.showCompare = false;
										//$scope.compareOptions = [];
									}
									else
									{
										if($scope.component.dimensionDataField[0] && $scope.component.dimensionDataField[0].timeGrouping && $scope.component.dimensionDataField[0].timeGrouping == "auto")
											$scope.component.chartTimeGroup = $scope.tempComponent.chartTimeGroup;

										$scope.component.showCompare = true;
										$scope.component.selectedCompareOption = $scope.compareInfo.selectedCompareOption;
									}
									$scope.drawChart();
								}


								$scope.deleteColumn = function(list, index, subType) {
									//$scope.processing = false;
									list.splice(index, 1);
									if (subType && $scope.isTileBuilder && $scope.tileProperties) {
										var dsProp = subType + "Dataset";
										var colProp = subType + "Column";
										delete $scope.tileProperties["outcomeDataset"];
										delete $scope.tileProperties["outcomeColumn"];
									}
								};

								$scope.deleteHeatMapCol = function(list, ipCol, type) {

									for (var i = 0; i < list.length; i++) {
										var item = list[i];
										if (item.column === ipCol) {
											list.splice(i, 1);
											$scope.component[type] = undefined;
											break;
										}
									}
								};

								function getChartType(type) {
									var chartType = "column";
									if (type.indexOf("Horizontal") != -1) {
										chartType = "bar";
									} else if (type.indexOf("Vertical") != -1) {
										chartType = "column";
									} else if (type == "Line" || type == 'TimeSeries') {
										var isShowArea = $scope.component.styles.chartPlotOptions.isShowArea;
										if ($scope.component.styles.chartPlotOptions.isSmoothLines) {
											chartType = isShowArea ? "areaspline" : "spline";
										} else {
											chartType = isShowArea ? "area" : "line";
										}
									} else if (type == "Pie" || type == "Donut") {
										chartType = "pie";
									} else if (type == "heatmap") {
										chartType = "heatmap";
									} else if (type == "treemap") {
										chartType = "treemap";
									}

									return chartType;
								}

								customReportSvc.registerCallback("componentUpdateStartedCallbacks", function(comp) {
									if (comp.name == $scope.component.id) {
										$scope.processing = true;
									}
								});

								customReportSvc.registerCallback("componentUpdateCompletedCallbacks", function(comp) {
									if (comp.name == $scope.component.id) {
										$timeout(function() {
											$scope.processing = false;
										});
									}
								});

								customReportSvc.registerCallback("resetPropStartedCallbacks", function(comp) {
									$scope.processing = true;
								});

								customReportSvc.registerCallback("resetPropCompletedCallbacks", function(comp) {
									$scope.drawChart();
									$timeout(function() {
										$scope.processing = false;
									});

								});

								customReportSvc.registerCallback("updateChart", function() {
									$scope.drawChart();
								}, $scope.component.id);
								customReportSvc.registerCallback("refreshComponent", function(componentId) {
									if ($scope.component.id === componentId) {
										$scope.drawChart();
									}
								}, $scope.component.id);

								$scope.isTimeDescending = function() {
									var sorting = $scope.component.sorting[0];
									if (sorting.direction == "Desc") {
										return true;
									} else {
										return false;
									}

								}

								$scope.setDateSensitiveFields = function() {
									//convert to UTC if datetime
									var config = $scope.chartConfig;
									var configSeries = config.series;
									var isUnixTime = false;
									var time = 0;
									if ($scope.component.isDateTime && !$scope.component.isTimeGrouping) {
										config.xAxis.categories = undefined;
										config.xAxis.type = 'datetime';
										if ($scope.isTimeDescending()) {
											config.xAxis.reversed = true;
										} else {
											config.xAxis.reversed = false;
										}

										angular.forEach($scope.rawData, function(val, index) {
											var dat = configSeries[index];
											//set tooltip
											if ($scope.component.multiBars == false) {
												dat.tooltip.headerFormat = '<p>{point.key}</p><br/>';
												dat.tooltip.pointFormat = '<b>{point.ylabel}:</b>{point.y}';
											} else {
												dat.tooltip.headerFormat = '<p>{point.key}</p><br/>';
												dat.tooltip.pointFormat = '<b>{series.name}:</b>{point.y}';
											}
											for (var pointIndex = 0; pointIndex < $scope.maxPoints; pointIndex++) {
												var point = val.data[pointIndex];
												if (pointIndex == 0) {
													isUnixTime = $scope.isInteger(point.name);
												}
												time = point.name;
												if (isUnixTime) {
													time = time * 1000;
												}
												dat.data[pointIndex].x = moment.utc(new Date(time)).valueOf();
												dat.data[pointIndex].name = dat.data[pointIndex].x;
											}

										});
									} else {
										if (config.xAxis) {
											config.xAxis.type = undefined;
											if ($scope.component.chartType == "heatmap") {
												config.yAxis.tickLength = 0;
												config.yAxis.categories = $scope.labelsY;
											}

										}

										if (config.xAxis) {
											config.xAxis.categories = $scope.labels;
										}

										angular.forEach($scope.rawData, function(val, index) {
											var dat = configSeries[index];
											delete dat.tooltip["headerFormat"];
											delete dat.tooltip["pointFormat"];
											for (var pointIndex = 0; pointIndex < $scope.maxPoints; pointIndex++) {
												var point = val.data[pointIndex];
												if (point) {
													dat.data[pointIndex][0] = point[0];
												}
											}
										});
									}
								};

								$scope.isInteger = function(value) {
									return Number(value) === value && value % 1 === 0;
								};

								$scope.generatePatternAndColor = function(index, clr) {
									index = index > 14 ? index - 14 : index;
									var idx = Math.floor(Math.random() * 10000 + 1);
									var pttrPath = $scope.cvPatterns[index];
									var pttrn = customReportSvc.createPattern(idx, clr, pttrPath);
									$scope.chartConfig.options.defs.patterns.push(pttrn);
									var color = 'url(#' + pttrn.id + ')';
									return color;
								}

								$scope.getColorVariations = function (color,count) {
									let rangeArray = [],
									colors = [],
									percentage=0,
									variationVal = count > 5 ? 0.8 : 0.6,
									step = variationVal/count;
									for(var i=0; i< count; i++) {
										rangeArray.push(i);
									}
									angular.forEach(rangeArray,function(cnt) {
										if(cnt !== 0)
											percentage += step;
										colors.push(Highcharts.Color(color).brighten(percentage).get());
									});
									return colors;
								}

								$scope.setSeriesColors = function(data) {

									var colors = [];
									var basicBar = false;
									if ($scope.component.multiBars == false && $scope.component.chartType != "Pie" &&
											$scope.component.chartType != "Donut") {
										basicBar = true;
									}
									let chartDefaultColors = defaultMultiChartColors;
									if($scope.component.enableMonochromeFill &&
										($scope.component.chartType === "Pie" || $scope.component.chartType === "Donut")) {
										var seriesDataLength = $scope.chartConfig.series[0].data.length;
										chartDefaultColors = $scope.getColorVariations($scope.component.chartColor,seriesDataLength);
									}


									$scope.chartConfig.options.colors = chartDefaultColors;
									if ($scope.component.seriesFormatting == undefined ||
											$scope.component.seriesFormatting.length == 0) {
										var currDataSeries = [];
										var colorCount = chartDefaultColors.length;
										var configSeries = $scope.chartConfig.series;
										var tempData = configSeries;
										if ($scope.component.multiBars == false ||
												$scope.component.chartType == "Pie" ||
												$scope.component.chartType == "Donut" ||
												$scope.component.chartType == "treemap") {
											tempData = configSeries[0].data;
											if ($scope.component.chartType == "treemap") {
												tempData = $.map(tempData, function(val, key) {
													if (!val.hasOwnProperty('id')) {
														return val;
													}
												});
											}
										}

										angular.forEach(tempData, function(val, index) {
											var series = {};
											series.value = val.name; //|| val[0] ; //val[0] for pie
											if ($scope.component.chartType == "treemap") {
												series.color = val.color;
											} else {
												series.color = basicBar ? $scope.component.styles.barColor
														: chartDefaultColors[index % colorCount];
												if (accessibilityMode) {
													series.color = $scope.generatePatternAndColor(index, series.color);
												}
											}
											currDataSeries.push(series);
											val.color = series.color;
											colors.push(series.color);
										});

										customReportSvc.setCurrentSeries($scope.component, currDataSeries);
										// customReportSvc.addCustomSeriesColor($scope.component);

									} else {
										var currDataSeries = [];
										var configSeries = $scope.chartConfig.series;
										var tempData = configSeries;
										if ($scope.component.multiBars == false ||
												$scope.component.chartType == "Pie" ||
												$scope.component.chartType == "Donut" ||
												$scope.component.chartType == "treemap") {
											tempData = configSeries[0].data;
											if ($scope.component.chartType == "treemap") {
												tempData = $.map(tempData, function(val, key) {
													if (!val.hasOwnProperty('id')) {
														return val;
													}

												});
											}
										}
										var start = 0;
										angular.forEach(tempData, function(dat, index) {
											var found = false;
											//tempdata[i].name for pie  tempData[i][0] ||
											var series = {};
											var name = dat.name === undefined ? "" : dat.name + "";
											series.value = name;
											currDataSeries.push(series);
											start = $scope.component.chartType == "treemap" ? start : 0;
											for (var i = start; i < $scope.component.seriesFormatting.length; i++) {
												var val = $scope.component.seriesFormatting[i];
												var value = val.value || "";
												value = value + "";
												if (val.autoColor && name.toLowerCase() == value.toLowerCase()) {
													break;
												}
												if (name.toLowerCase() == value.toLowerCase()) {
													series.selected = true;
													if (!accessibilityMode) {
														dat.color = val.color;
														series.color = val.color;
													} else {
														var color = $scope.generatePatternAndColor(0, val.color);
														dat.color = color;
														series.color = color;
													}
													found = true;
													start++;
													break;
												}
											}
											if (!found) {
												var color = basicBar ? $scope.component.styles.barColor : $scope
														.getColor(colors);
												colors.push(color);
												series.color = color;
												dat.color = color;
											}
										});

										//if current data does not include the customize series then add to list
										angular.forEach($scope.component.seriesFormatting, function(series) {
											var found = false;
											for (var j = 0; j < currDataSeries.length; j++) {
												if (currDataSeries[j].value == series.value) {
													found = true;
													break;
												}
											}
											if (!found && series.value) {
												var custom = {};
												custom.value = series.value;
												custom.color = series.color;
												currDataSeries.push(custom);
											}

										});
										customReportSvc.setCurrentSeries($scope.component, currDataSeries);
									}
									// if ($scope.component.multiBars == false && $scope.component.chartType == "Line") {
									$scope.chartConfig.options.colors = colors;
									// }
									// $scope.chartConfig.options.colors = colors;

								};

								$scope.getColor = function(colors) {
									var color = "#fff";
									var seriesList = $scope.component.seriesFormatting;
									var colorCount = defaultMultiChartColors.length;

									for (var i = 0; i < defaultMultiChartColors.length; i++) {
										var color = defaultMultiChartColors[i];
										var found = false;
										var tempColor = defaultMultiChartColors[i % colorCount];
										for (var j = 0; j < seriesList.length; j++) {
											var series = seriesList[j];
											if (!series.autoColor && tempColor == series.color) {
												found = true;
												break;
											}
										}
										//existing colors
										if (colors.indexOf(tempColor) != -1) {
											found = true;
										}

										if (!found) {
											color = defaultMultiChartColors[i % colorCount];
											break;
										}
									}
									return color;
								};

								$scope.init = function() {
									$scope.isDcubeEnabledInCustomReports = isDcubeEnabledInCustomReports;
									if($scope.component.chartType === "TimeSeries" && $scope.page.body.autoRefresh &&
									Array.isArray($scope.component.dimensionDataField) && $scope.component.dimensionDataField.length) {
										//if time range filter is getting applied from bookmarked URL and auto refresh is enabled then stop auto refresh
										const isComponentFilterApplied = $scope.showFilterClearOption($scope.reportMode,$scope.component.dimensionDataField[0], $scope.component, $scope.dataSet, "component");
										if(isComponentFilterApplied) {
											$scope.isTimeRangeFilter = true;
											$scope.stopAutoRefresh();
										}

									}
									if ($scope.dataSet && Object.keys($scope.dataSet).length > 0) {
                                        // create a field column name and type map
                                        if ($scope.dataSet.endpoint != 'DATACUBE' &&
                                                (!$scope.dataSet.fields || $scope.dataSet.fields.length == 0)) { //fields list will be empty if allColumns is true

                                            $scope.getFieldsForDataSet($scope.dataSet).then(function(data) {
                                                if ($scope.reportMode === 'viewer') {
                                                    $scope.dataSet.fields = data.data.columns; // chart interactivity
                                                }
                                                angular.forEach(data.data.columns, function(field) {
                                                    $scope.fieldTypeMap[field.name] = field.type;
                                                });
                                                $scope.drawChart();
                                            }, function(error) {
                                                $scope.errorFunc(error.data, error.status);
                                                return;
                                            });
                                        } else {
                                            if ($scope.dataSet.endpoint === 'MONITORING_POLICY') {
                                                angular.forEach($scope.dataSet.fields, function(field) {
                                                    $scope.fieldTypeMap[field.name] = field.type;
                                                });
                                            } else {
                                                angular.forEach($scope.dataSet.fields, function(field) {
                                                    $scope.fieldTypeMap[field.name] = field.type;
                                                });
                                            }
                                            //                                          }
                                            $scope.drawChart();
                                        }
                                    } else {
                                        $scope.drawChart();
                                    }
                                };

								$scope.init();

								$scope.getFieldLabel = function(chartType, axis) {
									return ((chartType == "Pie" || chartType == "Donut" || chartType == "treemap") ? (axis == "x" ? "Dimension"
											: "Measure")
											: (axis == "x" ? "X-Axis" : "Y-Axis"));
								};

								$scope
										.$on('resize',
												function(sizes, gridster) {
													if (gridster && gridster.length > 1) {
														var componentResizedScope = angular.element(gridster[1])
																.scope();
														var currentCompId = componentResizedScope.$parent.component.id;
														if ($scope.component.id == currentCompId) {
															if ($scope.chartConfig &&
																	typeof $scope.chartConfig.getHighcharts === 'function') {
																var that = $scope.chartConfig;
																$timeout(function() {
																	var chart = that.getHighcharts();
																	$scope.chartConfig.options.chart.height = $("li[comp=" +
																			$scope.component.id + "]>div").height();
																	if ($scope.reportMode == 'builder') {
																		chart.options.chart.height = $scope.chartConfig.options.chart.height - 150;
																	}
																	chart.reflow();
																});
															}
														}
													}
												});

								$scope.$on('chartRedraw', function(e, componentId) {
									if ($scope.chartConfig && typeof $scope.chartConfig.getHighcharts === 'function' &&
											($scope.isLayoutAvailable || $scope.component.isQuickAnalysis) && $scope.component.id == componentId) {
										var chart = $scope.chartConfig.getHighcharts();
										var otherElementsHeight = 170;
										if ($scope.reportMode === 'viewer' && $scope.isLayoutAvailable) {
											otherElementsHeight = 70;
											$scope.chartConfig.options.chart.height = $scope.gridsterItem.sizeY *
													$scope.gridster.curRowHeight - otherElementsHeight; //set chart height
											$scope.chartConfig.options.chart.height = $("li[comp=" +
													$scope.component.id + "]>div").height();
										}

										var chartHeight = $("li[comp=" + $scope.component.id + "]>div").height();
										if($scope.component.isQuickAnalysis){
											chartHeight = 400; // for quick charts setting the fixed height as the chart keeps shrinking when a value is changed.
										}
										/*if ($scope.reportMode == 'builder') {
											chart.options.chart.height = chartHeight - 150;
										} else {*/
											if ($scope.isFullScreen) {
												chart.options.chart.height = chartHeight - 100;
											} else {
												chart.options.chart.height = chartHeight - 60;
											}
										//}
										if ($scope.component.chartType === 'heatmap') {
											$("li[comp=" + $scope.component.id + "] .highcharts-axis-labels span")
													.css("cursor", "pointer");
											$("li[comp=" + $scope.component.id + "] .highcharts-xaxis-labels span")
													.off('click').on("click",
															function(event) {
																addFilter($scope.component.dimensionDataField[1],
																		this.innerText);
															});
											$("li[comp=" + $scope.component.id + "] .highcharts-yaxis-labels span")
													.off('click').on("click",
															function(event) {
																addFilter($scope.component.dimensionDataField[0],
																		this.innerText);
															});
										}
									}

									if ($scope.dataSet) {
										if ($scope.dataSet.endpoint !== "DATACUBE" ||
												($scope.dataSet.endpoint === "DATACUBE" && $scope.useCREApiForSolr)) {
											$scope.setSeriesSelected(chart);
										} else {
											applyChartFilters(chart);
										}
									}
								});
								angular
										.element($window)
										.on('resize',
												function() {
													var that = $scope.chartConfig;
													$timeout(function() {
														var chart = that.getHighcharts();
														if (chart) {
															$scope.chartConfig.options.chart.height = $("li[comp=" +
																	$scope.component.id + "]").height();
															/*if ($scope.reportMode == 'builder') {
																chart.options.chart.height = $scope.chartConfig.options.chart.height - 150;
															}*/

															chart.reflow();
															$scope.$broadcast("gridsterItemWidthChanged", true);
														}
													});
												});
								$scope
										.$on('gridsterItemWidthChanged',
												function(event, isLeftPanelToggle, componentId) {
													if ($scope.chartConfig &&
															typeof $scope.chartConfig.getHighcharts === 'function') {
														$timeout(function() {
															var chart = $scope.chartConfig.getHighcharts();
															if (!isLeftPanelToggle && $scope.component.id == componentId) {
																$scope.chartConfig.options.chart.height = $("li[comp=" + $scope.component.id + "]>div").height();
																//chart.options.chart.height = $scope.chartConfig.options.chart.height - 150;
																chart.reflow();
															} else if (isLeftPanelToggle) {
																chart.reflow();
															}

															var containerWidth = $("li[comp=" + $scope.component.id + "]>div").width();
															chart.setSize(containerWidth, chart.chartHeight);

															if ($scope.component.chartScript) {
																$scope.applyChartScript($scope.component.chartScript);
															}
															chart.redraw();
														},500);
													}
												});
								$scope.$on('clearAppliedFilters', (event, componentId) => {
									if (componentId === $scope.component.id) {
										$scope.isTimeRangeFilter = false;
										$scope.maxDate = undefined;
										$scope.minDate = undefined;
										//resume auto refresh when time range filter is cleared only if auto refresh is stopped beacuse
										//of time range selection. If user has manually stopped auto refresh then do not resume it
										if($scope.page.body.isAutoRefreshShow && $scope.startAutoRefreshOnFilterClear) {
											$scope.page.body.autoRefresh = true;
											$scope.startAutoRefreshTimer();
											$scope.startAutoRefreshOnFilterClear = false;
										}

									}
								});

							} ]);

}());