var module = angular.module("lvl.directives.dragdrop", ['lvl.services']);

module.directive('lvlDraggable', ['$rootScope', 'uuid', function($rootScope, uuid) {
	    return {
	        restrict: 'A',
	        link: function(scope, el, attrs, controller) {
	        	angular.element(el).attr("draggable", "true");

	            var id = angular.element(el).attr("id");
	            if (!id) {
	                id = uuid.newId()
	                angular.element(el).attr("id", id);
	            }

	            el.on("dragstart", function(e) {
	            	e.originalEvent.dataTransfer.setData('text', id);
	            	$rootScope.$broadcast("LVL-DRAG-START",this);
	            });

	            el.on("dragend", function(e) {
	                $rootScope.$broadcast("LVL-DRAG-END",this);

	            });
	        }
    	}
	}]);

module.directive('lvlDropTarget', ['$rootScope', 'uuid', function($rootScope, uuid) {
	    return {
	        restrict: 'A',
	        scope: {
	            onDrop: '&'
	        },
	        link: function(scope, el, attrs, controller) {
	            var id = angular.element(el).attr("id");
	            if (!id) {
	                id = uuid.newId()
	                angular.element(el).attr("id", id);
	            }

	            el.on("dragover", function(e) {
	              if (e.preventDefault) {
	                e.preventDefault(); // Necessary. Allows us to drop.
	              }

	              e.originalEvent.dataTransfer.dropEffect = 'move';  // See the section on the DataTransfer object.
	              return false;
	            });

	            el.on("dragenter", function(e) {
	              // this / e.target is the current hover target.
	              angular.element(e.target).addClass('lvl-over');
	            });

	            el.on("dragleave", function(e) {
	              angular.element(e.target).removeClass('lvl-over');  // this / e.target is previous target element.
	            });

	            el.on("drop", function(e) {
	              if (e.preventDefault) {
	                e.preventDefault(); // Necessary. Allows us to drop.
	              }

	              if (e.stopPropagation) {
	                e.stopPropagation(); // Necessary. Allows us to drop.
	              }
	            	var data = e.originalEvent.dataTransfer.getData("text");
	                scope.onDrop({dragEl: data, dropEl: id, event: e});
	            });

	        }
    	}
	}]);
