(function() {
	'use strict';

	var MAXROWS_TOPRINT_WITHOUT_DIALOG = 20000;
	var actionHandler = angular.module('reports');

	actionHandler
			.factory('actions',
					[
							'$uibModal',
							'customReportSvc',
							'reportService',
							function($modal, customReportSvc, reportService) {
								return {
									showDeleteDialog : function(reportId, reportName, callback) {
										var modalInstance = $modal
												.open({
													templateUrl : isReportManager ? "../reportsplus/modal/views/actionHandlerConfirmModal.html"
															: "modal/views/actionHandlerConfirmModal.html",
													controller : "actionHandlerConfirmModalCtrl",
													size : "sm",
													backdrop : 'static',
													keyboard : false,
													windowClass : 'confirmDialog',
													resolve : {
														modalTitle : function() {
															return "Confirm Delete";
														},
														modalMessage : function() {
															return reportName == undefined ? "Delete this report?"
																	: "Delete the report '" + reportName + "'?";
														},
														isInputRequired : function() {
															return false;
														},
														reportNameCopy : function() {
															return reportName + " - Copy ";
														},
														inputLabel : function() {
															return "";
														}
													}
												});

										modalInstance.result.then(function() {
											reportService.deleteReport({
												reportId : reportId,
												reportName : encodeURIComponent(reportName)
											}).then(function(data) {
												$('#content').unmask();
												customReportSvc.toast(data.data, null, null, true);
												if (!isReportManager) {
													var reportsUrl = customReportSvc.getContextPath() + "/reports";
													if (surveySingleCommcellUser) {
														reportsUrl = customReportSvc.getContextPath() +
																"/survey/reports/commcellmonitoring.jsp?commUniId=" +
																surveySingleCommcellUser;
													}
													window.location.replace(reportsUrl);

												} else if (callback) {
													callback();
													//							window.location.reload();
												}
											},
													function(xhr, ajaxOptions, thrownError) {
														$('#content').unmask();
														customReportSvc.errorToast($.trim(xhr.data), 30000);
													});
										});
									},

									showSaveAsDialog : function(reportId, reportName, callback) {
										var modalInstance = $modal
												.open({
													templateUrl : isReportManager ? "../reportsplus/modal/views/actionHandlerConfirmModal.html"
															: "modal/views/actionHandlerConfirmModal.html",
													controller : "actionHandlerConfirmModalCtrl",
													size : "sm",
													backdrop : 'static',
													keyboard : false,
													windowClass : 'confirmDialog',
													resolve : {
														modalTitle : function() {
															return "Clone As";
														},
														modalMessage : function() {
															return "";
														},
														isInputRequired : function() {
															return true;
														},
														reportNameCopy : function() {
															return reportName + " - Copy ";
														},
														inputLabel : function() {
															return "Report Name";
														}
													}
												});

										modalInstance.result.then(function(newReportName) {
											cloneReport(reportId, newReportName, callback);
										});
									},

									//  publish to store

									publishToStore : function(reportId, reportName, showDialog) {
										if (showDialog) {
											var modalInstance = $modal
													.open({
														templateUrl : isReportManager ? "../reportsplus/modal/views/actionHandlerConfirmModal.html"
																: "modal/views/actionHandlerConfirmModal.html",
														controller : "actionHandlerConfirmModalCtrl",
														size : "sm",
														backdrop : 'static',
														keyboard : false,
														windowClass : 'confirmDialog',
														resolve : {
															modalTitle : function() {
																return "Confirm Publish";
															},
															modalMessage : function() {
																return "This action will publish this report to the Commvault Software Store. Do you want to proceed?";
															},
															isInputRequired : function() {
																return false;
															},
															reportNameCopy : function() {
																return reportName + " - Copy ";
															},
															inputLabel : function() {
																return "";
															}
														}
													});

											modalInstance.result.then(function(newReportName) {
												publishToCloudStore(reportId, reportName);
											});
										} else {
											publishToCloudStore(reportId, reportName);
										}
									}

								}
								function cloneReport(reportId, newReportName, callback) {
									var params = {};
									params.reportId = reportId;
									params.newReportName = newReportName;
									params.isReportManager = false;

									reportService.cloneReport(params).then(function(data) {
										if (isReportManager) {
											if (callback) {
												callback(data);
											}
											customReportSvc.toast(data, null, null, true);

										} else {
											var url = "/reportsplus/index.jsp?reportId=" +
													data.data.report.customReportId;
											window.location.assign(customReportSvc.getContextPath() + url);

										}
									},
											function(xhr, ajaxOptions, thrownError) {
												customReportSvc.errorToast($.trim(xhr.data), 30000);
											});

								}

								function publishToCloudStore(reportId, reportName) {
									window.publishToStore = true;
									angular.element("#container").mask("Publishing report to store...");
									var params = {
										"reportId" : reportId
									};
									reportService
											.publishToCloudStore(params)
											.then(function(data1) {
												var data = data1.data;
												if (data != undefined && data != null && data.trim() != '') {
													if ($.trim(data) === "Unauthorized") {
														window.publishToStore = true;
														checkAppStoreAuthentication();
													} else {
														customReportSvc.toast(data);
													}
												} else {
													customReportSvc.errorToast("Unable to publish report.", 30000);
													window.publishToStore = false;
												}
												angular.element("#container").unmask();
												angular.element(".actionMenu").hide();
											},
													function(error) {
														if (error.status == -1) {
															customReportSvc
																	.errorToast("Error occurred.  Please verify Software Store connectivity.",
																			30000);
														} else {
															if ($.trim(error.data) === "Unauthorized") {
																checkAppStoreAuthentication();
															} else {
																customReportSvc.errorToast($.trim(error.data), 30000);
																window.publishToStore = false;
															}
														}
														angular.element("#container").unmask();
														angular.element(".actionMenu").hide();
													});
								}
							} ]);

	actionHandler.controller("actionEventCtrl", [
			"$scope",
			"actions",
			"$uibModal",
			"reportService",
			"customReportSvc",
			function($scope, actions, $modal, reportService, customReportSvc) {

				$scope.$watch('customReport', function(customReport) {
					if (customReport) {
						$scope.customReport = customReport;
					}

				});

				$scope.publishToCloudStore = function() {
					return actions.publishToStore($scope.customReport.report.customReportId,
							$scope.customReport.report.customReportName,
							false);
				};
				$scope.initListeners = function() {

					/*
					 * if (crMode == 'build') { angular.element("#deleteButton").addClass("disabled");
					 * angular.element("#shareButton").addClass("disabled");
					 * angular.element("#saveAsButton").addClass("disabled"); }
					 */
					angular.element("#publishButton").on("click", function() {
						angular.element("#container").mask("Publishing report...");
						var reportId = parseInt(customReportSvc.getParameterByName("reportId", 0));
						var params = {
							"reportId" : reportId
						};
						reportService.publishToDownloadCenter(params).then(function(data1) {
							var data = data1.data;
							if (data != undefined && data != null && data.trim() != '') {
								customReportSvc.toast(data, null, null, true);
							} else {
								customReportSvc.errorToast("Unable to publish report.", 30000);
							}
							angular.element("#container").unmask();
							angular.element(".actionMenu").hide();
						}, function(error) {
							customReportSvc.errorToast($.trim(error.data), 30000);
							angular.element("#container").unmask();
							angular.element(".actionMenu").hide();
						});

					});

					angular.element("#publishToCloudButton").on("click",
							function(evt) {
								if ($scope.customReport) {
									actions.publishToStore($scope.customReport.report.customReportId,
											$scope.customReport.report.customReportName,
											true);
								}

								evt.preventDefault();
								evt.stopPropagation();
							});

					angular.element(".exportReadme").on("click", function(evt) {
						angular.element("#exportCRReportId2").val(customReportSvc.getParameterByName("reportId", 0));
						angular.element("#exportReportName").val($scope.customReport.report.customReportName);
						angular.element("#exportReportPreviewUrl").val(window.location.search);
						angular.element("#exportCustomReportReadMe").submit();

					});

					angular.element("#deleteButton").on("click",
							function(evt) {
								if ($scope.customReport) {
									actions.showDeleteDialog($scope.customReport.report.customReportId,
											$scope.customReport.report.customReportName);
								} else {
									actions.showDeleteDialog(angular.element("#deleteButton").data().reportid);
								}
							});

					angular.element("#saveAsButton").on("click",
							function(evt) {
								if ($scope.customReport) {
									actions.showSaveAsDialog($scope.customReport.report.customReportId,
											$scope.customReport.report.customReportName,
											null);
								}

								evt.preventDefault();
								evt.stopPropagation();
							});

				};
				$scope.initListeners();
			} ]);

}(this));