/**
 * Controller responsible for rendring the inputs.
 */

(function() {

	var reports = angular.module("reports");
	reports
			.controller("reportInputsCtrl",
					[
							'$scope',
							'customReportSvc',
							function($scope, customReportSvc) {
								$scope.initialLoad = false;
								$scope.showApplyButton = false;
								$scope.more = false;
								$scope.isVisibleInput = false;
								$scope.isCommcellInputAvailable = false;
								/*
								 * Each key represents the id of the input, and the values holds the dependent
								 * id's of the inputs on this input. When ever the parent input which is the
								 * key reload , we should reload the dependent inputs as well.
								 */

								$scope.dependentInputs = {};

								/*
								 * Holds all the inputs that are initialized. When trying to load an input we
								 * should check if it depends on any input and then check if the dependent
								 * input is already initialized and then load the component , if not wait for
								 * the dependent input to load and initialize first.
								 * 
								 */
								$scope.initializedInputs = {};
								$scope.autoApply = false;
								$scope.hideReportSummary = $scope.requestParms['hideReportSummary'] || false;
								let commcellId = "";
								$scope.initInputs = function(page) {
									$scope.inputs = [];
									$scope.initializedInputs = {};
									$scope.dependentInputs = {};
									$scope.inputs = page.inputs;
									$scope.regInputs = [];
									$scope.moreInputs = [];
									for (var i = 0; i < $scope.inputs.length; i++) {
										var input = $scope.inputs[i];
										if (input.type === 'Commcell') {
											$scope.isCommcellInputAvailable = true;
											commcellId = input.id;
										}
										var dependsOn = input.dependsOn;
										if (dependsOn && dependsOn.length > 0) {
											for (var x = 0; x < dependsOn.length; x++) {
												var depend = dependsOn[x];
												if (!$scope.dependentInputs[depend]) {
													$scope.dependentInputs[depend] = []
												}
												$scope.dependentInputs[depend].push(input.id);
											}
										}
										if ($scope.isCommcellInputAvailable && input.type !== 'Commcell' &&
												input.fromDataSet && dependsOn && dependsOn.length > 0) {
											let values = $scope.dependentInputs[commcellId] || [];
											if (values.indexOf(input.id) === -1) {
												values.push(input.id);
											}
											$scope.dependentInputs[commcellId] = values;
										}
										$scope.initializedInputs[input.id] = false;
									}
									if ($scope.exportType || page.inputs.length === 6) {
										$scope.regInputs = page.inputs;
									} else {
										initializeInputs(page.inputs);
									}
								}

								var initializeInputs = function(inputs) {
									var minRegularLimit = 5;
									for (var i = 0; i < inputs.length; i++) {
										var input = inputs[i];
										if ((customReports.appName === 'adminconsole' && $scope.reportMode === "viewer" && input.type === 'Commcell') ||
												input.hidden) {
											minRegularLimit++;
										}

										if (i === minRegularLimit) {
											break;
										}
									}

									$scope.regInputs = inputs.slice(0, minRegularLimit);
									$scope.moreInputs = inputs.slice(minRegularLimit);
								}

								$scope.$watch('page', function(page) {
									if (page && typeof page === "string") {
										return;
									}
									if (page) {
										$scope.initialLoad = false;
										$scope.initInputs(page);
									}

									customReportSvc.registerCallback("redrawAllInputs", function(page) {
										var currentInputs = page ? page.inputs : $scope.inputs;

										angular.forEach(currentInputs, function(input, i) {
											$scope.initializedInputs[input.id] = false;
										});
										angular.forEach(currentInputs, function(input, i) {
											$scope.$broadcast('reinitialize', {
												id : input.id
											});
										});
									});

									if ($scope.reportMode === 'builder') {
										customReportSvc.registerCallback("inputUpdated", function(data) {
											initializeInputs(data.inputs);
										});
									}
								});

								$scope.reloadDependents = function(inputId) {
									$scope.$broadcast('reloadDependents', {
										id : inputId
									});
								}

								$scope.clearDependents = function(inputId) {
									$scope.$broadcast('clearDependents', {
										id : inputId
									});
								}

								$scope.applyInputs = function(updateRequestParams) {
									if (updateRequestParams) {
										
										// when apply button is clicked, if alarm id is present, remove it to avoid popping up the alarm dialog after closing.
										if ($scope.requestParms && $scope.requestParms.alarmId) {
											delete $scope.requestParms.alarmId;
										}

										for (var i = 0; i < $scope.inputs.length; i++) {
											var input = $scope.inputs[i];
											var key = "input." + input.id;
											var value = input.value;
											if (input.required &&
													(typeof input.value === "undefined" || input.value === "")) {
												customReportSvc.errorToast(input.displayName + " " +
														localMsg.customReport.inputIsRequired);
												return;
											}
											value = (typeof value !== "undefined")  ? (input.allowMultipleSelection &&
													_.isArray(value) ? JSON.stringify(value) : input.value) : undefined;
											var doNotUpdateUrl = $scope.initialLoad ? i !== $scope.inputs.length - 1
													: true; // do not update url for every parameter
											if (input.updateUrl) {
												doNotUpdateUrl = false;
												input.updateUrl = undefined;
											}
											rpt.input[input.id] = value;
											$scope.addParameterToUrl(key, value, false, false, doNotUpdateUrl, false); // update url when only apply button is clicked or autoApply (future) is enabled
										}
									}

									var entityObj = customReportSvc.getSelectedCommcellEntity($scope.inputs);
									angular
											.forEach($scope.page.dataSets.dataSet,
													function(dataSet) {
														var dCubeDataSet = dataSet.dCubeDataSet;
														if (dataSet.endpoint === 'DATACUBE' &&
																dCubeDataSet &&
																(entityObj.hasOwnProperty("entityTypeId") || dCubeDataSet.dataApi)) {
															var dsHandler = dCubeDataSet.dsHandler;
															if (dCubeDataSet.dataApi ||
																	(dsHandler && dCubeDataSet.dsType === 'federated' && dCubeDataSet.dsId == -1)) {
																var entityId = entityObj.entityId;
																if (_.isArray(entityId)) {
																	entityId = entityId.join();
																}
																dsHandler.entityId = entityId;
																dsHandler.entityTypeId = entityObj.entityTypeId;
																if ($scope.initialLoad) {
																	$scope.initPageVariables(function() {
																		$scope.initDataCubeDataset(dataSet);
																	});
																}
																return;
															}
														}
													});

									$scope.showApplyButton = false;

									if (!$scope.initialLoad) {
										$scope.initialLoad = true;
										$scope.setAllInputsIntialized();
									} else {
										if (entityObj.isCommcellEntitySelected) {
											//do not process further as alerts have been thrown in getSelectedCommcellEntity method
											//OR initDataCubeDataset is called which will refresh the components
											return;
										}
										customReportSvc.triggerCallback("validateComponentVisibility");
										customReportSvc.triggerCallback("redrawAllComponents");
									}
								}

								$scope.checkIfAllInputsInitialized = function(autApply, updateRequestParams) {
									var values = _.values($scope.initializedInputs);
									if (values.length === $scope.inputs.length && values.indexOf(false) === -1) {
										if (autApply || !$scope.initialLoad) {
											$scope.applyInputs(updateRequestParams);
										} else {
											$scope.showApplyButton = true;
										}
									}
								}

								$scope.setInputInitialized = function(inputId, status, updateRequestParams) {
									$scope.initializedInputs[inputId] = status;
									$scope.checkIfAllInputsInitialized(true, updateRequestParams);
								}

								$scope.updateVisibleInput = function(state) {
									if (!$scope.isVisibleInput) {
										$scope.isVisibleInput = state;
									}
								}

							} ]);

	reports
			.controller("reportInputCtrl",
					[
							'$scope',
							'reportService',
							"customReportSvc",
							"dataSource",
							"$filter",
							"$timeout",
							function($scope, reportService, customReportSvc, $dataSource, $filter, $timeout) {
								$scope.translatedLabel = rpt.translate($scope.input.displayName);
								if ($scope.input.controlType === 'TextBox') {
									$scope.translatedPlaceHolder = rpt.translate("Enter " + $scope.input.displayName);
								}
								$scope.toolTip = $scope.translatedLabel;
								if ($scope.input.toolTip) {
									$scope.toolTip = rpt.translate($scope.input.toolTip);
								}

								$scope.inputLabel = $scope.translatedLabel;
								$scope.highlightRequiredInput = false;
								$scope.leftClassEnabled = false;
								$scope.updateVisibleInput(!$scope.input.hidden);

								if ($scope.reportMode === "viewer" && $scope.input.type === 'Commcell') {
									$scope.input.hidden = true;
									if (customReports.appName === 'adminconsole') {
										$scope.input.allowMultipleSelection = false;
										$scope.input.value = 2; //default it to local commcell always in adminconsole
										$scope.input.defaultValue = 2; // change the defaultValue as well to set it to local.
									}
								}

								$scope.status = {
									isopen : false
								};

								$scope.child = {
									selectionChanged : false,
									valueSelected : false
								}; //will hold the child scope so that we can call the reload component method.

								$scope.child.inputLabel = $scope.inputLabel;
								$scope.setChildScope = function(childScope) {
									$scope.child = childScope;
								}

								$scope.isPost = function(dataSet) {
									return typeof dataSet !== "string" &&
											($scope.reportMode === "builder" || $scope.reportMode === "preview" ||
													$scope.isPreview || dataSet.preview) ? true : false;
								}

								$scope.getSelectedValues = function(input, requestParams) {
									var returnArray;
									var urlvalue = $scope.mergedParams['input.' + encodeURIComponent(input.id)];
									if (urlvalue && urlvalue.toLowerCase() !== 'all') {
										returnArray = JSON.parse(urlvalue);
									} else {
										returnArray = urlvalue;
									}
									return returnArray;
								}

								$scope.clearValues = function(e) {
									$scope.input.value = '';
									$scope.child.inputLabel = $scope.translatedLabel;
									$scope.child.valueSelected = false;

									if ($scope.input.controlType === 'ToggleBox') {
										$scope.initToggleBox();
									}

									if (e) {
										e.preventDefault();
										e.stopPropagation();
									}
								}

								$scope.clearInputSelection = function(e, resetOptions) {
									$scope.clearValues();
									if ($scope.child.clearSelection) {
										$scope.child.clearSelection(resetOptions);
									}
									$scope.checkAndReloadDependents(true);
									if ($scope.input.required) {
										$scope.highlightRequiredInput = true;
									}
									if (e) {
										e.preventDefault();
										e.stopPropagation();
									}
								}

								$scope.textInputChanged = function() {
									if ($scope.input.value) {
										$scope.child.inputLabel = $scope.input.value;
										$scope.child.valueSelected = true;
									} else {
										$scope.clearValues();
									}
								}

								$scope.initializeInput = function(input, updateSelections, doNotInitialize) {
									var initState = false;
									var urlValue = input.allowMultipleSelection ? $scope.getSelectedValues(input)
											: $scope.mergedParams['input.' + input.id];
									if (typeof urlValue != 'undefined') {
										input.value = urlValue;
									} else {
										if (input.defaultValue) {
											input.value = input.allowMultipleSelection &&
													input.defaultValue.toLowerCase() !== "all" ? input.defaultValue
													.split("\n") : input.defaultValue;
										}
									}

									if (typeof input.value !== "undefined") {
										if (!input.allowMultipleSelection) {
											input.value = $scope.convertStringType(input.value, input);
										} else {
											if (_.isArray(input.value)) {
												input.value = _.map(input.value, $scope.convertStringType)
											}
										}
										initState = true;

										if (input.allowMultipleSelection && input.required &&
												typeof $scope.input.value === 'string' &&
												input.value.toLowerCase() === 'all') {
											initState = false;
										}
									} else {
										if (!input.required) {
											input.value = "";
											initState = true;
										}
									}

									if (input.required) {
										$scope.checkIfrequiredInputIsIntialized(input, true);
									}

									if (!doNotInitialize) {
										rpt.input[input.id] = input.value;
										$scope.setInputInitialized(input.id, initState, false);
									}

									//initialize time value to a date object
									if (input.type === "Time") {
										var timeString = "Wed Dec 31 1969 " + input.value;
										$scope.input.date = new Date(timeString);
										if (input.value) {
											$scope.child.inputLabel = moment($scope.input.date).format('hh:mm A');
										}
									}

									if ($scope.input.controlType === 'ToggleBox') {
										$scope.initToggleBox();
									}

									if ($scope.input.controlType === 'Slider') {
										$scope.handleSlider();
									}

									if (input.controlType == "DatePicker") {
										if (input.value) {
											$scope.input.date = $filter('date')(input.value, "yyyy-MM-dd");
											$scope.child.inputLabel = moment(input.value).format('MMM D, YYYY');
										}
									}

									if (input.controlType == "DateTimePicker") {
										if (input.value) {
											$scope.input.date = $filter('date')(input.value, "yyyy-MM-dd HH:mm:ss Z");
											$scope.child.inputLabel = moment(input.value)
													.format('MMM D, YYYY hh:mm:ss A');
										}
									}

									if (input.type === "DateRange" && input.value) {
										if (!isNaN(input.value)) {
											// to initialize relative value when defaultValue only has a number instead of -P24H P0D
											input.relativeOption = input.relativeOptions[0];
											input.relativeUnit = input.relativeUnits[0];
											input.relativeValue = parseInt(input.value);
											input.value = input.relativeOption == "Last" ? "-P" : "P";
											var relativeUnitValue = input.relativeUnit.substring(0, 1);
											if ([ "Hours", "Minutes" ].indexOf(input.relativeUnit) !== -1) {
												input.value = input.value + "T";
											}
											input.value = input.value + input.relativeValue + relativeUnitValue;
											input.value = input.relativeOption == "Last" ? input.value + " P0D"
													: "P0D " + input.value;
										} else {
											$scope.updateTimeValue(input);
										}
									}

									if (updateSelections && typeof $scope.child.initialize === "function") {
										$scope.child.initialize();
									}

								}

								$scope.handleSearch = function(search) {
									$scope.child.handleSearchText(search);
								}

								$scope.convertStringType = function(string) {
									var input = $scope.input;
									if (string && input.type === "Integer") {
										string = parseInt(string);
									} else if (string && input.type === "Decimal") {
										string = parseFloat(string);
									} else if (string && input.type === "Commcell" && input.valueField === "id") {
										string = parseInt(string);
									} else if (input.type === "Boolean") {
										string = Boolean(string);
									} else if (string && input.type === "CommcellEntity" && !isNaN(string)) {
										string = parseInt(string);
									}
									return string
								}

								$scope.handleSlider = function() {
									$scope.rzOptions = angular.copy($scope.input.rangeParam, {
										onChange : function(id) {
											$scope.child.selectionChanged = true;
										}
									});

									$scope.rzOptions.onChange = function(id) {
										$scope.child.selectionChanged = true;
									}

									if ($scope.input.value) {
										$scope.child.inputLabel = $scope.input.value;
									}
								}

								$scope.handleToggleSelect = function(search) {
									$scope.isSelected = !$scope.isSelected;
									$scope.setToggleState();
								}

								$scope.setToggleState = function() {
									$scope.child.selectionChanged = true;
									if ($scope.isSelected) {
										$scope.input.value = $scope.input.possibleValues[0];
									} else {
										$scope.input.value = $scope.input.possibleValues[1];
									}
									$scope.child.valueSelected = $scope.isSelected;
								}

								$scope.initToggleBox = function() {
									$scope.isSelected = $scope.input.value == $scope.input.possibleValues[0] ? true
											: false;

									if ($scope.exportType) {
										$scope.child.inputLabel = $scope.isSelected ? localMsg.customReport.Yes
												: localMsg.customReport.No;
									}

									$scope.setToggleState();
								}

								$scope.handleDateChange = function(e) {
									if ($scope.input.controlType === 'DatePicker') {
										$scope.input.value = $filter('date')($scope.input.date, "yyyy-MM-dd");
										$scope.child.inputLabel = moment($scope.input.date).format('MMM D, YYYY');
									} else if ($scope.input.controlType === 'DateTimePicker') {
										$scope.input.value = $filter('date')
												($scope.input.date, "yyyy-MM-dd HH:mm:ss Z");
										$scope.child.inputLabel = moment($scope.input.date)
												.format('MMM D, YYYY hh:mm:ss A');

									} else if ($scope.input.controlType === 'TimePicker') {
										$scope.input.value = $filter('date')($scope.input.date, "HH:mm:00");
										$scope.child.inputLabel = moment($scope.input.date).format('hh:mm A');
									}

									$scope.child.valueSelected = true;
									$scope.child.selectionChanged = true;
									$scope.status.isopen = false;
								}

								$scope.getDSId = function(dataSet) {
									if (typeof dataSet === "string") {
										return dataSet;
									}
									var isPost = $scope.isPost(dataSet) ? encodeURIComponent(dataSet.dataSet.dataSetName)
											: !dataSet.guid ? dataSet.dataSet.dataSetId : dataSet.guid;
									if (!$scope.isPost(dataSet)) {
										return typeof $scope.customReport.guid !== "undefined" ? $scope.customReport.guid +
												":" + dataSet.guid
												: dataSet.guid;
									} else {
										return isPost;
									}
								}

								function errorCallback(error) {
									if (error && error.data) {
										customReportSvc.errorToast(error.data);
									}
								}
								$scope.getData = function(dataset, component, callBack) {
									if (dataset && dataset.endpoint && dataset.endpoint === "DATACUBE") {
										var parametersList = customReportSvc.applyInputsToDataSet(dataset,
												$scope.inputs,
												$scope.customReport.builderVersion);
										$dataSource.getDataSource(dataset.endpoint).init(dataset);
										$dataSource
												.getDataSource(dataset.endpoint)
												.getChartData({
													dataSet : dataset,
													measureDataField : [ {
														'column' : $scope.input.valueField,
														'aggrType' : 'Count'
													} ],
													dimensionDataField : [
															{
																'column' : $scope.input.valueField,
																'numPointsToDisplay' : {
																	'includeAll' : true
																},
																'sortDirection' : ($scope.input.sort && $scope.input.sort.columnId === $scope.input.valueField) ? $scope.input.sort.direction
																		: undefined
															},
															{
																'column' : $scope.input.labelField,
																'sortDirection' : ($scope.input.sort && $scope.input.sort.columnId === $scope.input.labelField) ? $scope.input.sort.direction
																		: undefined
															} ],
													inputParams : parametersList
												},
														callBack);
									} else {
										var dsId = $scope.getDSId(dataset);
										var dataSetParams = {
											reportMode : $scope.reportMode,
											componentName : component.title && component.title.text || component.id,
											dsId : dsId,
											operation : (component.type == "R-GGPlot") ? "rImage" : ($scope
													.isPost(dataset) ? "select" : "data"),
											builderVersion : $scope.customReport.builderVersion,
											isPreview : $scope.isPreview,
											limit : component.pageSize,
											offset : component.pageOffset || 0,
											exportType : null,
											exportedFileName : null,
											rawData : dataset && dataset.endpoint == "HTTP" ? true : false,
											cacheId : dataset.preview ? customReportSvc.generateUUID() : $scope.cacheId
										};
										//$scope.mergedParams = $.extend({}, $scope.requestParms, $scope.viewParams);
										var dataUrl = dataSetUtility.getUrlForDataComponent(component,
												dataset,
												$scope.page,
												dataSetParams,
												$scope.mergedParams,
												undefined,
												undefined);
										dataUrl = dataUrl + "&format=object"
										if ($scope.isPost(dataset)) {
											var datasets = dataSetUtility.getDataSets(dataset, $scope.page);
											return reportService.postDataForDataSetViaProxy(dataUrl, datasets)
													.then(callBack, errorCallback);
										} else {
											return reportService.getDataForDataSetViaProxy(dataUrl).then(callBack,
													errorCallback);
										}
									}
								}

								$scope.checkIfrequiredInputIsIntialized = function(input, doNotAlret) {
									if (typeof input.value === "undefined" ||
											(input.value instanceof Array && input.value.length === 0)) {
										if (!doNotAlret) {
											customReportSvc.errorToast(input.displayName + " " +
													localMsg.customReport.inputIsRequired);
										}
										$scope.highlightRequiredInput = true;
										return false;
									} else {
										$scope.highlightRequiredInput = false;
										return true;
									}
								}

								$scope.$on('clearDependents', function(event, args) {
									if (args.id === $scope.input.id) {
										$scope.clearInputSelection(undefined, true);
									}
								});

								$scope.checkAndReloadDependents = function() {
									var dependents = $scope.dependentInputs[$scope.input.id];
									if ($scope.input.required &&
											!$scope.checkIfrequiredInputIsIntialized($scope.input) && dependents &&
											dependents.length > 0) {
										for (var i = 0; i < dependents.length; i++) {
											$scope.clearDependents(dependents[i]);
										}
										return;
									}
									if (dependents && dependents.length > 0) {
										for (var i = 0; i < dependents.length; i++) {
											$scope.reloadDependents(dependents[i]);
										}
									}
									if (!$scope.initialLoad && $scope.input.required && $scope.input.value) {
										$scope.input.updateUrl = true;
									}
									$scope.checkIfAllInputsInitialized($scope.autoApply, true);
								}

								$scope.updateTimeValue = function(input) {
									input.relativeOption = input.relativeOptions[0];
									if (input.value) {
										if (isNaN(input.value)) { // default value can be specified in XML time format like -P30D for last 30 days or +P30D for next 30 days. It can also be specified as -P30D P5D meaning that "last 30 days to last 5 days" from current day
											input.value = input.value;
											var inputValues = input.value.split(" ");
											if (inputValues.length === 1) { // if only start time is specified like -P30D , we have to assume and add the end date as P0D to cuurent time
												if (input.value.indexOf("P") === 0) {
													if (input.relativeOption !== "Custom") {
														input.value = "P0D " + input.value; // if the default value is Next , then from should be current date , so the final value will "P0D P30D"
													} else {
														input.value = new Date().toISOString().split('.')[0] + 'Z' +
																' ' + $scope.getTimeValuefromInput(input.value);
													}

												} else {
													if (input.relativeOption !== "Custom") {
														input.value = input.value + " P0D" // if the default value is Last , then to should be current date , so the final value will "-P30D P0D"
													} else {
														input.value = $scope.getTimeValuefromInput(input.value) + ' ' +
																new Date().toISOString().split('.')[0] + 'Z';
													}
												}
											} else {
												if (input.relativeOption === "Custom" &&
														input.relativeOptions.length === 1 &&
														(input.value.indexOf("P") === 0 || input.value.indexOf("-P") === 0)) {
													input.value = $scope.getTimeValuefromInput(inputValues[0]) + ' ' +
															$scope.getTimeValuefromInput(inputValues[1]);
												}
											}
										}
									}
								}

								$scope.getTimeValuefromInput = function(value) {
									var returnValue;
									var currentDate = new Date();
									if (value) {
										var isTimeUnit = value.indexOf("T") !== -1 ? true : false;
										var subtract = value.indexOf("-P") == 0 ? true : false;
										var startIndex = subtract == true ? 2 : 1;
										if (isTimeUnit) {
											startIndex++;
										}
										var endIndex = 1;
										var units = value.substring(value.length, value.length - endIndex);
										if (units !== "M" || (units === "M" && isTimeUnit)) {
											units = units.toLowerCase();
										}

										var numberOfUnits = parseInt(value.substring(startIndex, value.length -
												endIndex));
										if (subtract) {
											returnValue = moment(currentDate).subtract(units, numberOfUnits);
										} else {
											returnValue = moment(currentDate).add(units, numberOfUnits);
										}
									}
									if (returnValue) {
										returnValue = new Date(returnValue).toISOString().split('.')[0] + 'Z';
									}

									return returnValue;
								}

								$scope.calculateRightPosition = function() {
									var element = document.querySelector('#' + $scope.input.id + '-dropdown-menu');
									if (element != null) {
										var rect = element.getBoundingClientRect();
										var body = document.body.getBoundingClientRect();
										if (rect.right > body.right) {
											$scope.leftClassEnabled = true;
										}
									}
								}

								// handles the close event of the drop down.
								$scope.toggled = function(open) {
									if (!open && $scope.child.selectionChanged) {

										if ($scope.input.controlType === 'TextBox' ||
												$scope.input.controlType === 'TextArea' ||
												$scope.input.controlType === 'Slider') {
											$scope.textInputChanged();
										}

										if (!$scope.initializedInputs[$scope.input.id]) {
											$scope.initializedInputs[$scope.input.id] = true;
										}

										if ($scope.input.type === 'Commcell') {
											$scope.hideDatasource = {};
										}

										$scope.checkAndReloadDependents();
										$scope.child.selectionChanged = false;
									}

									if (!$scope.input.sliderInit && $scope.input.controlType === 'Slider') {
										$scope.$broadcast('reCalcViewDimensions');
										$scope.input.sliderInit = true;
									}

									/*
									 * if ($scope.input.controlType === 'TextBox' || $scope.input.controlType
									 * === 'TextArea') { document.getElementById($scope.input.id +
									 * "-input").focus(); }
									 */

									$scope.calculateRightPosition();
								}

								if (!$scope.initializedInputs[$scope.input.id]) {
									$scope.initializeInput($scope.input);
								}

								$scope.$on('reinitialize', function(event, args) {
									if (args.id === $scope.input.id) {
										$scope.clearInputSelection();
										$scope.initializeInput($scope.input, true);
									}
								});
							} ]);

})();
