 <%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

	<div class="select-wrapper panel panel-primary">
		<div class="input-search-wrapper panel-heading">
			<div data-ng-if="input.controlType == 'ListBox' || input.controlType == 'CheckBox' || input.controlType == 'DropDown' || input.controlType == 'RadioButton'">
				<div data-ng-show="child.showSearchBar" class="searchtext-wrapper">
					<span class="glyphicon glyphicon-search" aria-hidden="true"></span>
					<input type="text" class="search-box" placeholder="<fmt:message key="CustomReport.Search" /> {{translatedLabel}}"
					 data-ng-model="search"
					data-ng-keyup="handleSearch(search)" autofocus="autofocus" />
					<span data-ng-show="input.searching" class="glyphicon glyphicon-refresh glyphicon-refresh-animate search-loading" aria-hidden="true"></span>
					<span data-ng-show="search.length > 0 && !input.searching" aria-hidden="true" class="clear-search-text" data-ng-click="search='';handleSearch(search);" title="Clear filter">&times;</span>
				</div>
				<span data-ng-show="!child.showSearchBar"><label class="panel-heading-label"><fmt:message key="CustomReport.MultiSelect.Select" />&nbsp;{{translatedLabel}}</label></span>
			</div>
			<div data-ng-if="!(input.controlType == 'ListBox' || input.controlType == 'CheckBox' || input.controlType == 'DropDown' || input.controlType == 'RadioButton' || input.controlType == 'TextBox' || input.controlType == 'TextArea')">
				<label><fmt:message key="CustomReport.MultiSelect.Select" />&nbsp;{{translatedLabel}}</label>
			</div>
			<div data-ng-if="input.controlType == 'TextBox' || input.controlType == 'TextArea'">
				<label><fmt:message key="CustomReport.ReportInput.Enter" />&nbsp;{{translatedLabel}}</label>
			</div>
		</div>
		<div class="options panel-body">
			<div  data-ng-if="input.controlType == 'ListBox' || input.controlType == 'CheckBox' || input.controlType == 'DropDown' || input.controlType == 'RadioButton'">
				<div cv-rpt-multi-select></div>
			</div>

			<div  data-ng-if="input.controlType == 'TextBox'" style="position: relative">
				<div class="wrapper-div">
				 <div class="inline-block wrapper-input-div">
				     <input id="{{input.id}}-input" type="text" data-ng-model="input.value" data-ng-change="child.selectionChanged = true"/>
				     <span data-ng-if="input.value" data-ng-click="clearValues($event);" class="clear-button">&times;</span>
			     </div>
			     <div class="inline-block wrapper-button-div">
			     	<button class="btn pull-right" data-ng-click="status.isopen = false"><fmt:message key="CustomReport.Ok"/></button>
			     </div>
			    </div>
			</div>

		     <!-- Input TextArea -->
			<div  data-ng-if="input.controlType == 'TextArea'">
				<div class="wrapper-div">
					<div class="wrapper-input-div">
		      			<textarea id="{{input.id}}-input" data-ng-model="input.value" data-ng-change="child.selectionChanged = true"></textarea>
		      		</div>
		      	</div>
		      	<div class="wrapper-button-div pull-right">
			     	<button class="btn pull-right" data-ng-click="status.isopen = false"><fmt:message key="CustomReport.Ok"/></button>
			    </div>
		    </div>

		    <div class="reports-date-picker date-picker" data-ng-if="input.controlType == 'DatePicker'">
				<div uib-datepicker data-ng-model="input.date" ng-click="$event.stopPropagation()" datepicker-options="{showWeeks :false}"  class="date-picker"></div>
				<div class="pull-right action-btn-panel">
					<button class="btn apply-btn" data-ng-click="handleDateChange()"><fmt:message key="Apply"/></button>
				</div>
			</div>

			<div class="reports-date-picker datetime-picker" data-ng-if="input.controlType == 'DateTimePicker'">
				<div class="date-time-picker date-picker">
					<div uib-datepicker data-ng-model="input.date" ng-click="$event.stopPropagation()" datepicker-options="{showWeeks :false,closeOnDateSelection:false}"  class="date-picker" min="minDate" max="maxDate" ></div>
				</div>
				<div class="date-time-picker time-picker">
					<div uib-timepicker data-ng-model="input.date" hour-step="1" minute-step="15" show-meridian="true" show-spinners="true"></div>
					<div class="pull-right action-btn-panel">
						<button class="btn margin-right-5" data-ng-click="input.date = null"><fmt:message key="CustomReport.Clear"/></button>
						<button class="btn apply-btn" data-ng-click="handleDateChange()"><fmt:message key="Apply"/></button>
					</div>
				</div>

			</div>

			<div class="reports-date-picker daterange-picker" data-ng-if="input.controlType == 'DateRange'">
				<div cv-rpt-date-range-picker></div>
			</div>

			<div  class="time-picker" data-ng-if="input.controlType == 'TimePicker'">
    			<div uib-timepicker data-ng-model="input.date" hour-step="1" minute-step="15" show-meridian="true" show-spinners="true"></div>
    			<div class="pull-right action-btn-panel">
						<button class="btn margin-right-5" data-ng-click="input.date = null"><fmt:message key="CustomReport.Clear"/></button>
						<button class="btn apply-btn" data-ng-click="handleDateChange()"><fmt:message key="Apply"/></button>
				</div>
			</div>

			<div  class="input_slider" data-ng-if="input.controlType == 'Slider'">
				<rzslider rz-slider-model="input.value"  rz-slider-options="rzOptions"></rzslider>
			</div>

			 <!-- Input ToggleBox -->
			<div  data-ng-if="input.controlType == 'ToggleBox'">
				<label for="{{input.id}}-toggle" ><fmt:message key="CustomReport.Enabledisable"/></label>
		      	<div class="cv-material-toggle cv-toggle pull-right" data-ng-class="{'enabled':(isSelected), 'isOff':(!isSelected)}">
					<div id="{{input.id}}-toggle" class="cv-material-toggle-bar" data-ng-click="handleToggleSelect()"></div>
					<div class="cv-material-toggle-round" data-ng-click="handleToggleSelect()"></div>
				</div>
		    </div>


		</div>
</div>


</fmt:bundle>