 <%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<fmt:message key="CustomReport.Component.TopologyChart" var="topology" />
	<div style="height: 100%;" id="{{component.id}}"
	class="clearFloat reportTable reportView previewTable_table"
	data-ng-if="component.chartType =='topology'">
	<div class="maskLayer full-height"
			data-ng-class="{'isMasked':masked}">
			<div class="tableOptions" data-ng-hide="tableOptions">
				<div class="pivotOptions"
					data-ng-show="reportMode == 'builder' && component.type === 'TOPOLOGY' && !isFullScreen">

					<fieldset class="axisColumnDrop ng-isolate-scope"
						x-lvl-drop-target="true" data-droptype="nodesId"
						x-on-drop="dropped(dragEl, dropEl)">

						<legend class="fieldsetLegend ng-binding">
							<fmt:message key="CustomReport.Component.TopologyChart.Id">
								<fmt:param value="${topology}" />
							</fmt:message>
						</legend>
						<div class="chartColumns groupingCol"
							data-ng-class="{'hidden':component.topologyProps.nodes.id.name == undefined}">
							<label> ({{component.topologyProps.nodes.id.name}}) <span
								class="deleteColumn"
								data-ng-click="deleteColumn('nodes', 'id')">&times;</span>
							</label>
							<!-- No need of a delete button on the dimension data field as it is a mandatory column for all chart types -->

						</div>
					</fieldset>

					<fieldset class="axisColumnDrop ng-isolate-scope"
						x-lvl-drop-target="true" data-droptype="nodesLabel"
						x-on-drop="dropped(dragEl, dropEl)">
						<legend class="fieldsetLegend ng-binding">
							<fmt:message key="CustomReport.Component.TopologyChart.Label">
								<fmt:param value="${topology}" />
							</fmt:message>
						</legend>
						<div class="chartColumns groupingCol"
							data-ng-class="{'hidden':component.topologyProps.nodes.label.name == undefined}">
							<label> ({{component.topologyProps.nodes.label.name}}) <span
								class="deleteColumn"
								data-ng-click="deleteColumn('nodes', 'label')">&times;</span>
							</label>
						</div>
					</fieldset>
					
					<fieldset class="axisColumnDrop ng-isolate-scope"
						x-lvl-drop-target="true" data-droptype="edgesFrom"
						x-on-drop="dropped(dragEl, dropEl)">
						<legend class="fieldsetLegend ng-binding">
							<fmt:message key="CustomReport.Component.TopologyChart.From">
								<fmt:param value="${topology}" />
							</fmt:message>
						</legend>
						<div class="chartColumns groupingCol"
							data-ng-class="{'hidden':component.topologyProps.edges.from.name == undefined}">
							<label> ({{component.topologyProps.edges.from.name}}) <span
								class="deleteColumn"
								data-ng-click="deleteColumn('edges', 'from')">&times;</span>
							</label>
						</div>
					</fieldset>
					
					<fieldset class="axisColumnDrop ng-isolate-scope"
						x-lvl-drop-target="true" data-droptype="edgesTo"
						x-on-drop="dropped(dragEl, dropEl)">
						<legend class="fieldsetLegend ng-binding">
							<fmt:message key="CustomReport.Component.TopologyChart.To">
								<fmt:param value="${topology}" />
							</fmt:message>
						</legend>
						<div class="chartColumns groupingCol"
							data-ng-class="{'hidden':component.topologyProps.edges.to.name == undefined}">
							<label> ({{component.topologyProps.edges.to.name}}) <span
								class="deleteColumn"
								data-ng-click="deleteColumn('edges', 'to')">&times;</span>
							</label>
						</div>
					</fieldset>
				</div>
			</div>
			<div class="clearFloat"></div>
			<div class="noChartDiv" data-ng-show="isShowNoChartDiv()"
				data-ng-click="setActiveComponent()">
				<label data-ng-show="componentLoaded && !component.isChartExist "><fmt:message
					key="CustomReport.NoDataAvailable" /></label>
			</div>
			<div style="height: 100%;" id="chart"></div>
		</div>
	</div>
</fmt:bundle>