// Closure to isolate scope, as per best practices
(function() {
	// Get a reference to the reportsBuilder module
	var reports = angular.module("reports");

	reports.directive("cvSharedComponent", function() {
		return {
			restrict : 'AE',
			templateUrl : customReports.contextPath + '/reportsplus/components/shared/sharedComponent.jsp',
			controller : [
					'$scope',
					'reportService',
					'customReportSvc',
					function($scope, reportService, customReportSvc) {
						$scope.component = {
							"type" : "TABLE",
							"id" : "Shared_" + (new Date()).getTime(),
							"title" : {
								"text" : ""
							},
							"pageSize" : 10,
							"columns" : [],
							"allColumns" : true,
							"selectedRowValues" : $scope.selectedValues,
							"selectorColumns" : $scope.selectorColumns,
							"enableButtonPanel" : true,
							"enableRowSelection" : true,
							"enableMultiRowSelection" : false,
							"showFilterByDefault" : true,
							"autoHeight":"Off",
							"shared" : true
						}

						if ($scope.componentInput) {
							$scope.component = $.extend({}, $scope.component, $scope.componentInput);
						}

						if ($scope.component.enableRowSelection) {
							window.closeFn = $scope.modalInstance.close;
							$scope.component.buttons = [ {
								"title" : {
									"text" : "Cancel"
								},
								"id" : "button1",
								"enable" : "always",
								"class" : "default",
								"clickExpression" : {
									"action" : "Custom",
									"inputs" : [],
									"customExpression" : ":=closeFn()"
								}
							}, {
								"title" : {
									"text" : "Done"
								},
								"id" : "button1",
								"enable" : "always",
								"class" : "btn-primary",
								"clickExpression" : {
									"action" : "Custom",
									"inputs" : [],
									"callBackFn" : $scope.component.callBackFn,
									"customExpression" : ":=closeFn();"
								}
							} ]

							if ($scope.component.callBackFn) {
								delete $scope.component.callBackFn;
							}
							$scope.component.showButtonsAtBottom = true;
						}

						reportService.getDataSet($scope.component.dataSet.dataSetName, true).then(function(data) {
							$scope.dataSet = data.data;
							$scope.dataSetId = $scope.dataSet.dataSet.dataSetId;
							$scope.component.title.text = $scope.dataSet.dataSet.dataSetName;
							$scope.sharedDatasetName = $scope.dataSet.dataSet.dataSetName;
							customReportSvc.triggerCallback("refreshComponent", $scope.component.id);
						});

					} ]
		};
	});
	reports.controller('openSharedComponentCtrl', [
			"$scope",
			"reportService",
			"$uibModal",
			"customReportSvc",
			"$timeout",
			function($scope, reportService, $uibModal, customReportSvc, $timeout) {
				$scope.sharedDatasetName = "";
				var modalInstance;
				$scope.openTableComponent = function(componentInput) {
					$scope.componentInput = componentInput;
					var modalSize = "md";
					if ($scope.componentInput.modalSize) {
						modalSize = $scope.componentInput.modalSize;
					}
					$timeout(function() {
						$scope.modalInstance = $uibModal.open({
							templateUrl : customReports.contextPath + "/reportsplus/components/shared/sharedModal.jsp",
							scope : $scope,
							size : modalSize,
							backdrop : 'static',
							windowClass : 'small-size',
							controller : [ "$scope", function($scope) {
								$scope.handleCallBackAndClose = function() {
									if ($scope.componentInput.callBackFn) {
										console.log('')
									} else {
										$scope.$close();
									}
								}
							} ]
						});
					}, 1000);
				}

			} ]);

})();