(function() {
	'use strict';

	angular.module("reports").controller('searchBarCtrl', searchBarCtrl);

	searchBarCtrl.$inject = [ '$scope', 'reportService', 'customReportSvc', 'dataSource' ];

	function searchBarCtrl($scope, reportService, customReportSvc, $dataSource) {
		var urlField;
		angular.forEach($scope.requestParms, function(val, key) {
			var component = key.substring(0, key.indexOf('.'));
			if (component === $scope.component.id) {
				urlField = key.substring(key.lastIndexOf('.') + 1, key.length);
				if (urlField === "*") {
					urlField = "ALL_FIELDS";
				}
				$scope.tempComponent.searchquery = val;
			}
		});
		$scope.init = function() {
			if (!$.isEmptyObject($scope.component.searchFields)) {
				//$scope.searchOptions = $scope.component.searchFields;
				/*
				 * if (!$scope.allAdded) { $scope.allAdded = true; $scope.addAll(); }
				 */
				$scope.searchOptions = $scope.component.searchFields;

				angular.forEach($scope.searchOptions, function(dataField) {
					if (!dataField.displayName) {
						dataField.displayName = dataField.column;
					}
					if (urlField && (urlField === dataField.column || urlField === "*")) {
						$scope.tempComponent.searchField = dataField;
						$scope.previousSearch = urlField;
					}

					if (!urlField && dataField.isSelected) {
						$scope.tempComponent.searchField = dataField;
					}
				})
				if ($scope.component.searchFields[0].column !== 'ALL_FIELDS') {
					var allFieldsColumn = {
						'column' : 'ALL_FIELDS',
						'displayName' : 'ALL',
						'isSelected' : false
					};
					$scope.component.searchFields.splice(0, 0, allFieldsColumn);
				}
			}
			if ($scope.tempComponent.searchField) {
				if ($scope.dataSet && $scope.dataSet && $scope.dataSet.endpoint === 'DATACUBE') {
					var filters = $scope.page.body.filters['viewer'];
					var dataSetName = $scope.dataSet.dataSet.dataSetName;
					var field = $scope.tempComponent.searchField.column;
					/*
					 * in case of search all available fields get search query from any one of the fields
					 */
					if ($scope.tempComponent.searchField.column === 'ALL_FIELDS') {
						field = $scope.component.searchFields[1].column;
					}
					if (!$.isEmptyObject(filters) && !$.isEmptyObject(filters[dataSetName]) &&
							!$.isEmptyObject(filters[dataSetName][field]) && filters[dataSetName][field].searchQuery) {
						$scope.tempComponent.searchquery = filters[dataSetName][field].searchQuery;
					}
				}
			}

			if ($scope.exportType) {
				$scope.setAllComponentsIntialized($scope.component);
			}

		};

		$scope.addAll = function() {
			if ($scope.dataSet.endpoint !== "DATACUBE") {
				$scope.searchOptions.push({
					column : "All"
				});
			}
		}

		$scope.clearOldSearch = function() {
			if ($scope.previousSearch) {
				$scope.addParameterToUrl($scope.component.id + ".filter." + $scope.previousSearch, "", false, false);
			}
		}

		$scope.doSearchOperation = function(isClear) {
			var options = {
				dataSet : $scope.dataSet,
				componentType : $scope.component.type,
				isAllColumns : $scope.component.allColumns,
				searchquery : $scope.tempComponent.searchquery
			};
			if ($scope.dataSet.endpoint === 'DATACUBE') {
				if(options.searchquery)
					options.searchquery = `(${options.searchquery}*) OR (${options.searchquery})`;
				if (!$scope.component.allColumns && !isClear && options.searchquery) {
					const searchFields = [];
					const field = $scope.tempComponent.searchField.column;
					const fieldType = $scope.tempComponent.searchField.dataType;
					if (field === 'ALL_FIELDS') {
						angular.forEach($scope.component.searchFields, function(field, index) {
							if (index > 0) { //ignore first ALL_FIELDS													
								searchFields.push({
									fName: field.column,
									fType: field.dataType
								});
							}
						});
					} else {
						searchFields.push({
							fName: field,
							fType: fieldType
						});
					}

					options.searchFields = searchFields;
					
				}

				$dataSource.getDataSource($scope.dataSet.endpoint).doSearch(options, function(isSuccess) {
					if (isSuccess) {
						customReportSvc.triggerCallback("redrawAllComponents");
					}
				});
			} else {

				var field = $scope.tempComponent.searchField && $scope.tempComponent.searchField.column;
				if (options.isAllColumns || (field && field === "ALL_FIELDS")) {
					field = "*";
				}
				$scope.clearOldSearch();
				$scope.previousSearch = field;
				$scope.addFilters(field,
						options.searchquery,
						$scope.component,
						false,
						true,
						undefined,
						undefined,
						"viewer",
						"include",
						true);
			}
		};

		$scope.dropped = function(dragEl, dropEl) {
			// Because the handler jumps "outside" of angular, updates must be
			// made in an $applied scope

			var dest = document.getElementById(dropEl);
			var src = document.getElementById(dragEl);

			var drag = angular.element(src);
			var drop = angular.element(dest);
			var columnName = drag.attr("data-name");
			var columnDataType = drag.attr("data-origtype");

			var dataSetEntity = drag.data("datasetentity");
			// var dataSetName = drag.parent().parent().data("datasetname");
			var dataSetName = dataSetEntity.dataSetName;
			if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
				$scope.associateDataSetToComponent(dataSetEntity);
			} else if ($scope.component.dataSet.dataSetName != dataSetName) {
				alert("Mismatched data Sets");
				return;
			}

			if ($scope.dataSet.endpoint !== "DATACUBE") {
				columnDataType = drag.attr("data-type");
			}

			$scope.component.allColumns = undefined;

			if (columnName == "allColumns") {
				$scope.component.allColumns = true;
				$scope.component.searchFields = undefined;
			} else {
				var newfield = {
					'column' : columnName,
					'displayName' : columnName,
					'dataType' : columnDataType,
					'isSelected' : true
				};
				if ($.isEmptyObject($scope.component.searchFields)) {
					$scope.component.searchFields = [ {
						'column' : 'ALL_FIELDS',
						'displayName' : 'ALL',
						'isSelected' : false
					} ];
				}
				var foundField;
				// mark other as not selected
				angular.forEach($scope.component.searchFields, function(dataField) {
					if (dataField.column === newfield.column) {
						dataField.isSelected = true;
						foundField = dataField;
					} else {
						dataField.isSelected = false;
					}
				});
				/*
				 * var foundField = $scope.component.searchFields.find(function(dataField) { return
				 * newfield.column === dataField.column; });
				 */
				if (!foundField) {
					$scope.component.searchFields.push(newfield);
					newfield.isSelected = true;
					$scope.tempComponent.searchField = $scope.component.searchFields[$scope.component.searchFields.length - 1];
				} else {
					$scope.tempComponent.searchField = foundField;
				}
			}
			$scope.searchOptions = $scope.component.searchFields;
			$scope.$apply();
		};
		$scope.init();

		$scope.$on('LVL-DRAG-START', function() {
			$scope.isFieldDragging = true;
			$scope.$apply();
		});

		// clear component fitlers before deleting the component
		$scope.$on('clearAppliedFilters', function(event, componentId) {
			if (componentId === $scope.component.id) {
				$scope.tempComponent.searchquery = '';
				$scope.doSearchOperation(true);
			}
		});

		$scope.$on('LVL-DRAG-END', function() {
			$scope.isFieldDragging = false;
			$("li[comp=" + $scope.component.id + "] .overlay").removeClass('lvl-over')
			$scope.$apply();
		});

		$scope.$watch('tempComponent.searchField', function(newValue, oldValue) {
			angular.forEach($scope.component.searchFields, function(field, index) {
				if (field.column === $scope.tempComponent.searchField.column) {
					field.isSelected = true;
				} else {
					field.isSelected = false;
				}
			});
			if (oldValue && newValue.column !== oldValue.column && $scope.tempComponent.searchquery !== "") {
				$scope.tempComponent.searchquery = "";
				$scope.doSearchOperation(true);
			}
		});

		customReportSvc.registerCallback("redrawAllComponents", function(data) {
			// not sure if we need refresh here
		});
	}
})();
