<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
        <span class="ico ico-form-field"></span>
    </li>
    <li class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
        <span class="ico ico-code"></span>
    </li>
</ul>

<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>

<!-- Begin "General" group -->
<div data-ng-show="selectedPropertyCategory==='general'">
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
          <div class="form-group">
              <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
              <div class="col-sm-8 noLftRghtPadding">
                  <input class="form-control input-sm"
                     data-ng-model="propData.title.text"
                       type="text" readonly="true"
                       placeholder="<fmt:message key='CustomReport.Properties.ChartName'/>">
              </div>
          </div>                 
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
          <div class="form-group">
              <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
              <div class="col-sm-8 noLftRghtPadding">
                  <input class="form-control input-sm"
                   type="text"                   
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" 
                   data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">            
              </div>
              <span class="inline-validation-error" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>  <!-- localize
          </div>                           
		  <label><fmt:message key="CustomReport.Properties.ID"/>
            <input class="form-control input-sm"
                   type="text"                   
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" 
                   data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">
            <span class="inline-validation-error" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>  <!-- localize -->   
        </div>
    </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
          <div class="form-group">
              <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message key="CustomReport.Properties.DataSet"/></label>
              <div class="col-sm-8 noLftRghtPadding">
                  <input class="form-control input-sm" type="text" placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>" readonly="true" data-ng-model="propData.dataSet.dataSetName">
              </div>
          </div>
<!-- FIXME: Localize -->
		  <label>
            
          </label>
        </div>
    </div>     
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
		<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='{{getFieldLabel(propData.chartType, "x")}} <fmt:message key="CustomReport.Properties.Title"/>'>{{getFieldLabel(propData.chartType, 'x')}} <fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                       data-ng-model="propData.scatterProps.scatterX"
                       type="text">
                </div>
            </div>                   
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
		<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='{{getFieldLabel(propData.chartType, "y")}} <fmt:message key="CustomReport.Properties.Title"/>'>{{getFieldLabel(propData.chartType, 'y')}} <fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   data-ng-model="propData.scatterProps.scatterY"
                   type="text">
                </div>
            </div>                         
        </div>
    </div>
    <div class="row noLftRghtMargin" >
       <%--  <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ShowLabels"/>'><fmt:message key="CustomReport.Properties.ShowLabels"/></label>
                <div class="col-sm-3 noLftRghtPadding">                    
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.scatterProps.isConnected" id="isConnected">
                </div>
            </div>           
        </div>    --%>
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ShowLegend"/>'><fmt:message key="CustomReport.Properties.ShowLegend"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.scatterProps.isShowLegend" id="showLabels">
                </div>
            </div>               
        </div>    
        <div class="col-xs-12" >
            <div class="form-group" data-ng-show="propData.scatterProps.isShowLegend">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.LegendPosition"/>'><fmt:message key="CustomReport.Properties.LegendPosition"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <select class="form-control input-sm" data-ng-model="propData.scatterProps.legendPosition">
                        <option value="top"><fmt:message key="CustomReport.Properties.LegendPlacementTop"/></option>
                        <option value="right"><fmt:message key="CustomReport.Properties.LegendPlacementRight"/></option>
                        <option value="bottom"><fmt:message key="CustomReport.Properties.LegendPlacementBottom"/></option>
                        <option value="left"><fmt:message key="CustomReport.Properties.LegendPlacementLeft"/></option>                      
                     </select>
                </div>
            </div>        
        </div>        
	 </div>
	 <div class="row noLftRghtMargin" data-ng-show="propData.styles.chartPlotOptions.isShowLegend">
	 	<div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.MaxLegendLabelLength"/>'><fmt:message key="CustomReport.Properties.MaxLegendLabelLength"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="text" class="form-control input-sm" data-ng-model="propData.styles.chartPlotOptions.maxLegendLabelLength" data-ng-blur="updateChart()">
                </div>
            </div>
	 	</div>
     </div>
     <!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                        data-ng-model="propData.mobile.visible">
                        <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                        <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
	<entity-security data-item="propData"></entity-security>
</div>
<!-- End "General" group -->

<!-- Begin "Field" group -->
<div data-ng-show="selectedPropertyCategory==='fields'">
		<div class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
			<div class="fieldHeader"
				data-ng-click="collapsed['dimension'+$index]=!collapsed['dimension'+$index]">
				<label class="col-lg-9 noLftRghtPadding"> <span>{{dimension.column}}</span>
				</label> <span class="pull-right"> <span
					class="ico inner-panel-expand-icon"
					data-ng-class="{'ico ico-chevron-down':!collapsed['dimension'+$index], 'ico ico-chevron-right':collapsed['dimension'+$index]}"></span>
				</span>
			</div>
			<div data-ng-class="{'collapsed' : collapsed['propData.scatterProps.scatterX' + $index]}">
				<div id="pointsToPlot">
					<div class="row noLftRghtMargin">
						<div class="form-group">
							<label
								class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
								title='<fmt:message key="CustomReport.Properties.MaxPoints"/>'><fmt:message
									key="CustomReport.Properties.MaxPoints" /> <!-- TODO: Localize --></label>
							<div class="col-sm-8 noLftRghtPadding">
								<input id="maxPointTextbox" class="fieldPropValue form-control"
									data-ng-model="propData.scatterLabel.numPointsToDisplay.maxPoints"
									data-ng-readonly="propData.scatterLabel.numPointsToDisplay.includeAll"
									data-ng-change="updateChart(false)" type="text">
							</div>
						</div>
					</div>
					<div class="row noLftRghtMargin">
						<div class="form-group">
							<label
								class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
								title='<fmt:message key="CustomReport.Properties.All"/>'><fmt:message
									key="CustomReport.Properties.All" />
								<!-- TODO: Localize --></label>
							<div class="col-sm-3 noLftRghtPadding">
								<input type="checkbox" cv-toggle-switch
									data-ng-model="propData.scatterLabel.numPointsToDisplay.includeAll"
									id="includeall{{$index}}" data-ng-change="updateChart(false)">

							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<!-- End "Field" group -->

<!-- Begin "Custom Code" group -->
<div data-ng-show="selectedPropertyCategory==='customcode'">  
     <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <label class="col-xs-12 noLftRghtPadding">
                <fmt:message key="CustomReport.Properties.PointExpression"/><br>
            </label>
            <span class="col-xs-12 noLftRghtPadding">
                <textarea  data-ng-model="propData.onClick" data-ng-blur="redrawComponent(propData.id)"></textarea>
            </span>
        </div>

    </div>      
</div>
<!-- End "Custom Code" group -->
</fmt:bundle>