<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
   <ul class="secondary-header secondary-background-color">
      <li class="sub-header" title="General"
         data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}"
         data-ng-click="selectedPropertyCategory='general'"><span
         class="ico ico-cog"></span></li>
      <li class="sub-header" title="Fields"
         data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}"
         data-ng-click="selectedPropertyCategory='fields'"><span
         class="ico ico-form-field"></span></li>
      <li class="sub-header" title="Custom Code"
         data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}"
         data-ng-click="selectedPropertyCategory='customcode'"><span
         class="ico ico-code"></span></li>
      <li class="sub-header" title="Filters"
         data-ng-show="ds && ds.endpoint === 'DATACUBE'"
         data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}"
         data-ng-click="selectedPropertyCategory='filters'"><span
         class="ico ico-funnel"></span></li>
   </ul>
   <div
      data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>
   <!-- Begin "General" group -->
   <div data-ng-show="selectedPropertyCategory==='general'">
      <div class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                  title='<fmt:message key="CustomReport.Properties.Title"/>'>
                  <fmt:message
                     key="CustomReport.Properties.Title" />
               </label>
               <div class="col-sm-8 noLftRghtPadding">
                  <input class="form-control input-sm" type="text"
                     placeholder="<fmt:message key='CustomReport.Properties.TableName'/>"
                     data-ng-model="propData.title.text">
               </div>
            </div>
         </div>
      </div>
      <div class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                  title='<fmt:message key="CustomReport.Properties.ID"/>'
                  cv-label-title>
                  <fmt:message
                     key="CustomReport.Properties.ID" />
               </label>
               <div class="col-sm-8 noLftRghtPadding">
                  <input name="chartid" class="form-control input-sm" type="text"
                     data-ng-model="propData.id"
                     data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
                     data-ng-blur="validateComponentId()"
                     data-ng-class="{'pattern-invalid': !propData.id}">
               </div>
               <span
                  class="inline-validation-error col-lg-12 noLftRghtPadding ng-hide"
                  data-ng-show="!propData.id">*ID should contain
               characters,digits and underscore only.</span>
            </div>
         </div>
      </div>
      <div class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                  title='<fmt:message key="CustomReport.Properties.DataSet"/>'>
                  <fmt:message
                     key="CustomReport.Properties.DataSet" />
               </label>
               <div class="col-sm-8 noLftRghtPadding">
                  <input class="form-control input-sm" type="text"
                     placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>"
                     readonly="true" data-ng-model="propData.dataSet.dataSetName">
               </div>
            </div>
         </div>
      </div>
      <div class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                  title="<fmt:message key='CustomReport.Properties.map.style'/>">
                  <fmt:message key='CustomReport.Properties.map.style'/>
               </label>
               <div class="col-sm-8 noLftRghtPadding">
                  <select  class="form-control input-sm" data-ng-model="propData.mapStyle"                        
                        data-ng-options="style.value as style.name for style in mapStyles">
                  </select>                  
               </div>
            </div>
         </div>
      </div>
      <div class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                  title="<fmt:message key='CustomReport.Properties.map.inputType'/>">
                  <fmt:message key='CustomReport.Properties.map.inputType'/>
               </label>
               <div class="col-sm-8 noLftRghtPadding">
                  <select class="form-control input-sm"
                     data-ng-model="propData.inputType">
                     <option value="latlon">
                        <fmt:message key='CustomReport.Properties.map.latlon'/>
                     </option>
                     <option value="cc">
                        <fmt:message key='CustomReport.Properties.map.countrycode'/>
                     </option>
                  </select>
               </div>
            </div>
         </div>
      </div>
      <!-- If country code selected, allow the user to choose bubble map or heat map -->
      <!-- <div data-ng-if="propData.inputType === 'cc'" class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                  title="<fmt:message key='CustomReport.Properties.map.mapType'/>">
                  <fmt:message key='CustomReport.Properties.map.mapType'/>
               </label>
               <div class="col-sm-8 noLftRghtPadding">
                  <select class="form-control input-sm"
                     data-ng-model="propData.mapType">
                     <option value="bubble">
                        <fmt:message key='CustomReport.Properties.map.bubbleMap'/>
                     </option>
                     <option value="heat"><fmt:message key='CustomReport.Properties.map.heatMap'/></option>
                  </select>
               </div>
            </div>
         </div>
         </div> -->

      
      <div class="row noLftRghtMargin" data-ng-if="ds && ds.endpoint === 'DATACUBE' && propData.inputType === 'latlon'">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
                  title="<fmt:message key='CustomReport.Properties.EnableHtmlClusters'/>">
                  <fmt:message key="CustomReport.Properties.EnableHtmlClusters"/></label>
               <div class="col-sm-3 noLftRghtPadding">
                  <input type="checkbox" data-ng-change="refreshComponent(propData.id)" cv-toggle-switch
                     data-ng-model="propData.enableHtmlClusters"
                     id="enableHtmlClusters">
               </div>
            </div>
         </div>
      </div>

      <!-- clustering applicable only for latitude/longitude -->
      <div data-ng-if="propData.inputType === 'latlon' && propData.isAggrColPresent" class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
                  title='<fmt:message key="CustomReport.Properties.map.cluster"/>'>
                  <fmt:message
                     key="CustomReport.Properties.map.cluster" />
               </label>
               <div class="col-sm-3 noLftRghtPadding">
                  <input type="checkbox" cv-toggle-switch
                     data-ng-model="propData.enableClustering"
                     id="enableClustering">
               </div>
            </div>
         </div>
      </div>
      


      <div data-ng-if="propData.isAggrColPresent && (propData.inputType === 'cc' || (propData.inputType === 'latlon' && propData.enableClustering))" class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                  title='<fmt:message key="CustomReport.Properties.map.bubbleSizeBy"/>'>
                  <fmt:message
                     key="CustomReport.Properties.map.bubbleSizeBy" />
               </label>
               <div class="col-xs-12 col-sm-12 col-md-12 col-lg-8 noLftRghtPadding">
                  <select data-ng-model="propData.bubbleSizeBy" data-ng-init="propData.columns[0].id" 
                     data-ng-options="col.id as col.displayName for col in propData.columns"
                     data-ng-change="redrawComponent(componentId)" class="col-xs-12 noLftRghtPadding"></select>
               </div>
            </div>
         </div>
      </div>
      <div data-ng-if="propData.isAggrColPresent && propData.bubbleSizeBy" class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                  title='<fmt:message key="CustomReport.Properties.Color"/>'>
                  <fmt:message
                     key="CustomReport.Properties.Color" />
               </label>
               <div class="col-lg-8 noLftRghtPadding">
                  <input class="form-control input-sm seriesColor" type="color"
                     data-ng-model="propData.mapColor" data-ng-change="redrawComponent(componentId)">
               </div>
            </div>
         </div>
      </div>
      <div data-ng-if="propData.isAggrColPresent && propData.bubbleSizeBy" class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
                  title='<fmt:message key="CustomReport.Properties.labels.show"/>'>
                  <fmt:message
                     key="CustomReport.Properties.labels.show" />
               </label>
               <div class="col-sm-3 noLftRghtPadding">
                  <input type="checkbox" cv-toggle-switch
                     data-ng-model="propData.showLabels" data-ng-click="redrawComponent(componentId)"
                     id="showLabels">
               </div>
            </div>
         </div>
      </div>
      <div class="row noLftRghtMargin">
         <div class="col-xs-12">
            <div class="form-group">
               <label
                  class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
                  title='<fmt:message key="CustomReport.Properties.DisableInteractivity"/>'>
                  <fmt:message
                     key="CustomReport.Properties.DisableInteractivity" />
               </label>
               <div class="col-sm-3 noLftRghtPadding">
                  <input type="checkbox" cv-toggle-switch
                     data-ng-model="propData.disableInteractivity"
                     id="disableInteractivity">
               </div>
            </div>
         </div>
      </div>
      <!-- Mobile Visible Option -->
      <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
         <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'>
               <fmt:message key="CustomReport.Properties.Mobile.Visible"/>
            </label>
            <div class="col-sm-4 noLftRghtPadding">
               <select class="form-control input-sm"
                  data-ng-model="propData.mobile.visible">
                  <option value="On">
                     <fmt:message key="CustomReport.Yes"/>
                  </option>
                  <option value="Off">
                     <fmt:message key="CustomReport.No"/>
                  </option>
               </select>
            </div>
         </div>
      </div>
	  <entity-security data-item="propData"></entity-security>
   </div>
   <!-- End "General" group -->
   <!-- Begin "Fields" group -->
   <div data-ng-show="selectedPropertyCategory==='fields'">
      <div data-ng-if="propData.enableHtmlClusters && propData.categoryColumn">
         <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
            <div class="fieldHeader"
               data-ng-click="collapsed['categoryColumn']=!collapsed['categoryColumn']"
               data-ng-init="collapsed['categoryColumn']=true">
               <label class="col-lg-9 noLftRghtPadding"> <span>
               {{propData.categoryColumn.displayName}}</span>
               </label> <span class="pull-right"> <span
                  class="ico inner-panel-expand-icon"
                  data-ng-class="{'ico ico-chevron-down':!collapsed['categoryColumn'], 'ico ico-chevron-right':collapsed['categoryColumn']}"></span>
               </span>
            </div>
            <div data-ng-class="{'collapsed' : collapsed['categoryColumn']}">
               <div class="row noLftRghtMargin">
                  <div class="col-xs-12 noLftRghtPadding">
                     <label class="control-label noLftRghtPadding" 
                              title='<fmt:message key="CustomReport.Properties.ClusterGroups"/>'>
                              <fmt:message key="CustomReport.Properties.ClusterGroups"/>
                        </label>
                        <div class="pull-right">
                           <button class="btn btn-primary btn-xs" data-ng-click="showMapFilterInputOptions()">
                              <fmt:message key="CustomReport.Add"/>
                           </button>
                        </div>
                  </div>
               </div>
               <div class="row noLftRghtMargin">
                  <div class="col-xs-12 noLftRghtPadding">
                     <div class="form-group">
                        <label
                           class="col-xs-12 col-lg-6 control-label noLftRghtPadding"
                           title='<fmt:message key="CustomReport.Properties.InnerCircleColor"/>'>
                           <fmt:message key="CustomReport.Properties.InnerCircleColor"/>
                        </label>
                        <div class="col-xs-12 col-lg-6 noLftRghtPadding">
                           <input class="form-control input-sm seriesColor" type="color"
                              data-ng-model="propData.innerCircleColor" data-ng-change="refreshComponent(propData.id)">
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <div data-ng-repeat="column in propData.columns" data-ng-init="collapsed['column'+$index] = true">
         <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel" >
            <div class="fieldHeaderContainer">
               <div class="fieldHeader dataGridFieldHeader" data-ng-click="collapsed['column'+$index]=!collapsed['column'+$index]">
                  <label class="col-lg-9 noLftRghtPadding">
                  <span cv-report-customization cv-expression="{{column.displayName}}"></span>
                  </label>
                  <span class="pull-right">
                  <span class="ico inner-panel-expand-icon" data-ng-class="{'ico-chevron-down':!collapsed['column'+$index], 'ico-chevron-right':collapsed['column'+$index]}" style="margin-right:5px"></span>
                  </span>
               </div>
               <div class="removeColumnInHeader">
                  <span class="pull-right">
                  <span class="ico ico-trashcan" title="<fmt:message key='CustomReport.Properties.DeleteColumn'/>" data-ng-click="removeColumn(column)"></span>
                  </span>
               </div>
            </div>
            <div data-ng-class="{'collapsed': collapsed['column'+$index]}">
               <div class="row noLftRghtMargin">
                  <div class="col-xs-12 noLftRghtPadding">
                     <div class="form-group">
                        <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DisplayName"/>'>
                           <fmt:message key="CustomReport.Properties.DisplayName"/>
                        </label>
                        <div class="col-sm-8 noLftRghtPadding">
                           <input class="form-control input-sm" type="text" placeholder="<fmt:message key='CustomReport.Properties.DisplayName'/>" data-ng-model="column.displayName">
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row noLftRghtMargin">
                  <div class="col-xs-12 noLftRghtPadding">
                     <div class="form-group">
                        <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'>
                           <fmt:message key="CustomReport.Properties.ID"/>
                        </label>
                        <div class="col-sm-8 noLftRghtPadding">
                           <input class="form-control input-sm" type="text" data-ng-model="column.id">
                        </div>
                     </div>
                  </div>
               </div>
               <div class="row formatter-option">
                  <div class="col-xs-12">
                     <div class="form-group">
                        <label class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Fields.Formatter"/>'>
                           <fmt:message key="CustomReport.Properties.Fields.Formatter"/>
                        </label>
                        <div class="col-sm-5 noLftRghtPadding">
                           <span class="pull-right">
                           <span class="label label-info cursor-pointer" data-ng-click="showFormatterOptions(column,'cellExpression')">{{getFormatterType(column.cellExpression)}}</span>
                           </span>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <div data-ng-if="propData.inputType === 'cc' && propData.categoryColumn">
         <div
            class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
            <div class="fieldHeader"
               data-ng-click="collapsed['categoryColumn']=!collapsed['categoryColumn']"
               data-ng-init="collapsed['categoryColumn']=true">
               <label class="col-lg-9 noLftRghtPadding"> <span>
               {{propData.categoryColumn.displayName}}</span>
               </label> <span class="pull-right"> <span
                  class="ico inner-panel-expand-icon"
                  data-ng-class="{'ico ico-chevron-down':!collapsed['categoryColumn'], 'ico ico-chevron-right':collapsed['categoryColumn']}"></span>
               </span>
            </div>
            <div data-ng-class="{'collapsed' : collapsed['categoryColumn']}">
               <div id="pointsToPlot">
                  <div class="row noLftRghtMargin">
                     <div class="form-group">
                        <label
                           class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
                           title='<fmt:message key="CustomReport.Properties.MaxPoints"/>'>
                           <fmt:message
                              key="CustomReport.Properties.MaxPoints" />
                        </label>
                        <div class="col-sm-8 noLftRghtPadding">
                           <input id="maxPointTextbox"
                              class="fieldPropValue form-control"
                              data-ng-model="propData.categoryColumn.numPointsToDisplay.maxPoints"
                              data-ng-readonly="propData.categoryColumn.numPointsToDisplay.includeAll"
                              data-ng-change="refreshComponent(propData.id)" type="text">
                        </div>
                     </div>
                  </div>
                  <div class="row noLftRghtMargin">
                     <div class="form-group">
                        <label
                           class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
                           title='<fmt:message key="CustomReport.Properties.All"/>'>
                           <fmt:message
                              key="CustomReport.Properties.All" />
                        </label>
                        <div class="col-sm-3 noLftRghtPadding">
                           <input type="checkbox" cv-toggle-switch
                              data-ng-model="propData.categoryColumn.numPointsToDisplay.includeAll"
                              id="includeall_pie"
                              data-ng-change="refreshComponent(propData.id)">
                        </div>
                     </div>
                  </div>
                  <div class="row noLftRghtMargin">
                     <div class="col-xs-12 noLftRghtPadding">
                        <div class="form-group">
                           <label
                              class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding"
                              title='<fmt:message key="CustomReport.Properties.CustomGroups"/>'>
                              <fmt:message key="CustomReport.Properties.CustomGroups"/>
                           </label>
                           <div class="col-sm-5 noLftRghtPadding">
                              <div class="pull-left">
                                 <div class="on-off-switch" style="margin-top: 3px;">
                                    <input type="checkbox" name="on-off-switch"
                                       data-ng-model="propData.categoryColumn.customGroupsAvailable"
                                       class="on-off-switch-checkbox" id="customgroup_categoryColumn"
                                       data-ng-click="updateCustomGroupsAvailable(propData.categoryColumn)">
                                    <label class="on-off-switch-label"
                                       for="customgroup_categoryColumn"> <span
                                       class="on-off-switch-inner"></span> <span
                                       class="on-off-switch-switch"></span>
                                    </label>
                                 </div>
                              </div>
                              <span
                                 class="ico ico-pencil pro-btn-algn cursor-pointer pull-right"
                                 data-ng-click="showAdditionalProperties(propData.categoryColumn)"
                                 data-ng-show="propData.categoryColumn.customGroupsAvailable"></span>
                           </div>
                        </div>
                     </div>
                  </div>
                  <!-- Begin "Series" group -->
                  <div class="row noLftRghtMargin"
                     data-ng-click="collapsed['series']=!collapsed['series']">
                     <div class="col-xs-12 noLftRghtPadding">
                        <span
                           data-ng-class="{'ico ico-chevron-down':!collapsed['series'], 'ico ico-chevron-right':collapsed['series']}"></span>
                        <span>
                           <fmt:message
                              key="CustomReport.Properties.CustomColors" />
                        </span>
                        <span
                           class="pull-right ico ico-plus-circle"
                           title="<fmt:message key='CustomReport.Properties.CustomizeSeriesColors'/>"
                           data-ng-click="collapsed['series']=false;addCustomSeriesColor($event)"></span>
                     </div>
                  </div>
                  <div data-ng-class="{'collapsed': collapsed['series']}">
                     <div class="row noLftRghtMargin seriesLabelRow noLftRghtMargins"
                        data-ng-repeat="series in propData.seriesFormatting">
                        <div class="form-group">
                           <div class="col-sm-9" style="padding-right: 0px">
                              <div class="seriesNameDiv">
                                 <input class="seriesTextField" type="text"
                                    data-ng-model=series.value> 
                                 <select
                                    class="form-control input-sm seriesSelect"
                                    data-ng-model="series.value">
                                    <option
                                       data-ng-repeat="currSeries in propData.currDataSeries"
                                       data-ng-show="!currSeries.selected"
                                       data-ng-model="currSeries.value">{{currSeries.value}}</option>
                                 </select>
                              </div>
                           </div>
                           <div class="col-sm-2 noLftRghtPadding">
                              <input class="seriesColor form-control input-sm" type="color"
                                 data-ng-model="series.color">
                           </div>
                           <div class="col-sm-1 noLftRghtPadding">
                              <span class="ico ico-trash2 pro-dlt-btn"
                                 data-ng-click="deleteSeries($index)"></span>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <div data-ng-if="propData.showMapFilterInputOptions" class="filter-properties additional-properties panel panel-info"
          cv-draggable data-handler=".panel-heading">
         <div class="panel-heading text-align-center">
            <h3 class="panel-title">{{filterColumn.id}}            
            </h3>
         </div>
         <div class="panel-body">  
            <div class="row noLftRghtMargin margin-top-7" data-ng-repeat="filter in filterColumn.mapFilters"> 
               <div class="col-xs-4 col-sm-4 col-md-4 col-lg-3 group-info">
                   <input type="text"  data-ng-model="filter.name" id="input" class="form-control-input" 
                   placeholder='<fmt:message key="CustomReport.Properties.GroupName"/>'/>
               </div>                    
               <div class="col-xs-8 col-sm-8 col-md-8 col-lg-8 group-info">
                  <div class="display-webkit-box">
                     <input type="text" data-ng-model="filter.value" class="form-control-input" 
                     placeholder='<fmt:message key="CustomReport.Properties.ClusterExpression"/>'/>
                     <div class="input-group-append">
                        <button class="btn btn-default btn-sm glyphicon glyphicon-question-sign helper-button" 
                        title='<fmt:message key="CustomReport.Properties.ConstructExpression"/>'
                        data-ng-click="openAceEditor(filter.value,
                        'expression',undefined,'filterColumn.mapFilters['+$index+'].value',undefined,'exp')"></button>
                        <input class="seriesColor filter-color-input" type="color" data-ng-model="filter.color"/>
                       <span class="glyphicon glyphicon-trash delete-group-icon" title="Delete Group" 
                       data-ng-click="filterColumn.mapFilters.splice($index,1)">
                     </div>
                  </div>
                      
               </div>                
           </div> 

           <div class="add-new-group text-align-center">
            <button type="button" class="btn btn-default" data-ng-click="filterColumn.mapFilters.push({'name' : '', 'value': '','color':''})">
               <span class="sprite reports-actions-newreport v-middle"></span>
               <fmt:message key="CustomReport.Properties.AddClusterGroup"/>
            </button>
         </div> 
              
            <div class="row noLftRghtMargin">            
                  <label class="col-sm-10">
                     <fmt:message key="CustomReport.Properties.IncludeValuesNotPartOfGroups"/>
                  </label>
                     <div class="col-sm-2 padding-left-5">
                        <input type="checkbox" cv-toggle-switch data-ng-model="filterColumn.includeUngrouped" 
                        id="unGroupedInput">
                     </div>                
			</div>
			<div data-ng-if="filterColumn.includeUngrouped" class="row noLftRghtMargin">            
                <label class="col-sm-5">
					<fmt:message key="CustomReport.Properties.LabelForValuesNotPartOfGroups"/>
				 </label>
				 <div class="col-sm-5 noLftRghtPadding">               
					 <input type="text" data-ng-model="filterColumn.ungroupedLabel"/> 
				 </div>
				 <div class="col-sm-2 padding-left-10">
					<input class="seriesColor filter-color-input" type="color" 
					data-ng-model="filterColumn.ungroupedColor"/>                                           
				 </div>
			</div>
         </div>
         <div class="panel-footer">
               <div class="pull-right">
                  <button type="button" class="btn btn-sm btn-info" data-ng-click="addFiltersToComponentColumn()">
                     <fmt:message key="Apply"/>
                  </button>
                  <button type="button" class="btn btn-sm btn-warning" data-ng-click="hideMapFilterInputOptions()">
                     <fmt:message key="CustomReport.Cancel"/>
                  </button>
               </div>
         </div>
         </div>
   </div>
   <!-- End "Fields" group -->
   <!-- Begin "Custom Code" group -->
   <div data-ng-show="selectedPropertyCategory==='customcode'">
      <div class="row noLftRghtMargin">
         <div class="col-xs-12">
            <label class="col-xs-12 noLftRghtPadding">
               <fmt:message key="CustomReport.properties.OnMarkerClick"/>
               <br>
            </label>
            <button class="btn btn-primary btn-xs pull-right" 
               data-ng-click="openAceEditor(propData.onClickMarkerExp,
               'text','refreshComponent(propData.id)','propData.onClickMarkerExp')">
               <span class="glyphicon glyphicon-new-window"></span>
               <fmt:message key="CustomReport.properties.AddUrl"/>
           </button>
         </div>
      </div>
      <div ng-if="propData.enableClustering && propData.bubbleSizeBy" class="row noLftRghtMargin">
         <div class="col-xs-12">
            <label class="col-xs-12 noLftRghtPadding">
               <fmt:message
                  key="CustomReport.Properties.map.cluster.tooltip" />
               <br>
            </label>
            <span class="col-xs-12 noLftRghtPadding"> <textarea
               data-ng-model="propData.tooltipExpForClustered"></textarea>
            </span>
         </div>
      </div>
      <div data-ng-if="propData.enableHtmlClusters" class="row noLftRghtMargin">
         <div class="col-xs-12">
            <label class="col-xs-12 noLftRghtPadding">
               <fmt:message
                  key="CustomReport.Properties.map.cluster.tooltip" />
               <br>
            </label>
            <button class="btn btn-primary btn-xs pull-right" 
               data-ng-click="openAceEditor(propData.htmlClusterTooltipExp,
               'html','refreshComponent(propData.id)','propData.htmlClusterTooltipExp',undefined, 'props')">
               <span class="glyphicon glyphicon-new-window"></span> 
               <fmt:message key="CustomReport.properties.AddExpression"/>
           </button>
         </div>
      </div>
      <div class="row noLftRghtMargin">
         <div class="col-xs-12">
            <label class="col-xs-12 noLftRghtPadding">
               <fmt:message
                  key="CustomReport.Properties.map.uncluster.tooltip" />
               <br>
            </label>
            <button class="btn btn-primary btn-xs pull-right" 
               data-ng-click="openAceEditor(propData.tooltipExpForDataPoint,
               'html','refreshComponent(propData.id)','propData.tooltipExpForDataPoint')">
               <span class="glyphicon glyphicon-new-window"></span> 
               <fmt:message key="CustomReport.properties.AddExpression"/>
           </button>
         </div>
      </div>
   </div>
   <!-- End "Custom Code"  group -->
   <!-- Begin "Filters" group -->
   <div
      data-ng-show="ds && ds.endpoint === 'DATACUBE' && selectedPropertyCategory==='filters'">
      <cvfacet config="propData" type="'properties'" page="page"
         filters="propData.filters" filter-mode="'builder'"
         report-mode="reportMode"></cvfacet>
   </div>
   <!-- End "Filters" group -->
</fmt:bundle>