<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

	<ul class="secondary-header secondary-background-color">
		<li class="sub-header" title="General"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}"
			data-ng-click="selectedPropertyCategory='general'"><span
			class="ico ico-cog"></span></li>
		<li class="sub-header" title="Fields"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}"
			data-ng-click="selectedPropertyCategory='fields'"><span
			class="ico ico-form-field"></span></li>
		<li data-ng-show="propData.enableRowSelection" class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
	        <span class="ico ico-code"></span>
		</li>
		<li class="sub-header" title="Filters" data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}" 
			data-ng-click="selectedPropertyCategory='filters'">
			<span class="ico ico-funnel"></span>
		</li>
	</ul>
	<div
		data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>
	<!-- Begin "General" group -->
	<div data-ng-show="selectedPropertyCategory==='general'">
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<!-- FIXME: Localize -->
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message
							key="CustomReport.Properties.Title" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							placeholder="<fmt:message key="CustomReport.Properties.TableName"/>"
							data-ng-model="propData.title.text">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<!-- FIXME: Localize -->
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message
							key="CustomReport.Properties.ID" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							data-ng-model="propData.id"
							data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
							data-ng-blur="validateComponentId()"
							data-ng-class="{'pattern-invalid': !propData.id}"> <span
							class="inline-validation-error" data-ng-show="!propData.id">*ID
							should contain characters,digits and underscore only.</span>
						<!-- localize -->
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<!-- FIXME: Localize -->
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"><fmt:message
							key="CustomReport.Properties.DataSet" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							placeholder="<fmt:message key="CustomReport.Properties.DataSetName"/>"
							readonly="true" data-ng-model="propData.dataSet.dataSetName">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
	        <div class="col-xs-12">
	            <div class="form-group">
	                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EnableColumnSelection"/>'><fmt:message key="CustomReport.Properties.EnableColumnSelection"/></label>
	                <div class="col-sm-3 noLftRghtPadding">
	                    <input type="checkbox" data-ng-model="propData.enableRowSelection" data-ng-change="refreshComponent(propData.id)" id="enableRowSelection">
	                </div>
	            </div>
	        </div>
	    </div>
		<!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                      data-ng-model="propData.mobile.visible">
                      <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                      <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
	<entity-security data-item="propData"></entity-security>

	</div>

	<div data-ng-show="selectedPropertyCategory==='fields'">
		<div class="row noLftRghtMargin secondary-header property-header"
			data-ng-show="propData.hDataField"
			data-ng-click="collapsed['hDataField']=!collapsed['hDataField']"
			data-ng-init="collapsed['hDataField']=true">
			<div class="col-xs-12 noLftRghtPadding">
				<!-- TODO: localize -->
				<span class="ico"
					data-ng-class="{'ico-chevron-down':!collapsed['hDataField'], 'ico-chevron-right':collapsed['hDataField']}"
					style="margin-right: 5px"></span> <span>Hierarchical Field</span>
			</div>
		</div>
		<div data-ng-class="{'collapsed': collapsed['hDataField']}">
			<div class="row noLftRghtMargin">
				<div class="col-xs-12">
					<!-- FIXME: Localize -->
					<div class="form-group">
						<label
							class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding">Field
							Name</label>
						<div class="col-sm-8 noLftRghtPadding">
							<input class="form-control input-sm" type="text" readonly
								data-ng-model="propData.hDataField.dataField">
						</div>
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group">
						<label
							class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding">Show
							Aggregate on tree node</label>
						<div class="col-sm-3 noLftRghtPadding">
							<div class="on-off-switch">
								<input type="checkbox" name="on-off-switch"
									data-ng-model="propData.hDataField.isShowAggr"
									class="on-off-switch-checkbox" id="showAggr"
									data-ng-change="updateChart(true)"> <label
									class="on-off-switch-label" for="showAggr"> <span
									class="on-off-switch-inner"></span> <span
									class="on-off-switch-switch"></span>
								</label>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group"
						data-ng-show="propData.hDataField.isShowAggr">
						<label
							class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding">Aggregation</label>
						<div class="col-sm-8 noLftRghtPadding">
							<select class="form-control input-sm"
								data-ng-model="propData.hDataField.aggrOpts.aggrColName"
								data-ng-change="updateChart()"
								data-ng-options='column.dataField as (column.aggrType + " of " + column.displayName) for column in propData.columns'>
							</select>
						</div>
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group"
						data-ng-show="propData.hDataField.isShowAggr">
						<label
							class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding">Show
							percentage</label>
						<div class="col-sm-3 noLftRghtPadding">
							<div class="on-off-switch">
								<input type="checkbox" name="on-off-switch"
									data-ng-model="propData.hDataField.aggrOpts.showAsPercentage"
									class="on-off-switch-checkbox" id="showAsPercentage"
									data-ng-change="updateChart(true)"> <label
									class="on-off-switch-label" for="showAsPercentage"> <span
									class="on-off-switch-inner"></span> <span
									class="on-off-switch-switch"></span>
								</label>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group"
						data-ng-show="propData.hDataField.isShowAggr && propData.hDataField.aggrOpts.showAsPercentage">
						<label
							class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding">Decimal
							Points</label>
						<div class="col-sm-3 noLftRghtPadding">
							<input class="form-control input-sm" type="number" min="0"
								max="5"
								data-ng-model="propData.hDataField.aggrOpts.decimalPoints"
								data-ng-change="updateChart(true)">
						</div>
					</div>
				</div>
				<div class="col-xs-12">
					<div class="form-group">
						<label
							class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding">Show
							Icon</label>
						<div class="col-sm-3 noLftRghtPadding">
							<div class="on-off-switch">
								<input type="checkbox" name="on-off-switch"
									data-ng-model="propData.hDataField.isShowIcon"
									class="on-off-switch-checkbox" id="showIcon"
									data-ng-change="updateChart(true)"> <label
									class="on-off-switch-label" for="showIcon"> <span
									class="on-off-switch-inner"></span> <span
									class="on-off-switch-switch"></span>
								</label>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xs-12" data-ng-show="propData.hDataField.isShowIcon">
					<div class="form-group">
						<label
							class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding">Column</label>
						<div class="col-sm-8 noLftRghtPadding">
							<select class="form-control input-sm"
								data-ng-model="propData.hDataField.iconColumn"
								data-ng-options='column.dataField as column.displayName for column in propData.columns'>
							</select>
						</div>
					</div>
				</div>
				<div class="col-xs-12" data-ng-show="propData.hDataField.isShowIcon">
					<div class="form-group">
						<label
							class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding">Value
						</label>
						<div class="col-sm-8 noLftRghtPadding">
							<input class="form-control input-sm" type="text"
								data-ng-model="propData.hDataField.iconColumnVal"
								data-ng-change="updateChart()">
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin secondary-header property-header"
			data-ng-click="collapsed['columns']=!collapsed['columns']"
			data-ng-init="collapsed['columns']=true">
			<div class="col-xs-12 noLftRghtPadding">
				<span class="ico"
					data-ng-class="{'ico-chevron-down':!collapsed['columns'], 'ico-chevron-right':collapsed['columns']}"
					style="margin-right: 5px"></span> <span>Columns</span>
				<!-- TODO: localize -->
			</div>
		</div>
		<div data-ng-class="{'collapsed': collapsed['columns']}">
			<div data-ng-repeat="column in propData.columns"
				data-ng-init="collapsed['column'+$index] = true">
				<div
					class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
					<div class="fieldHeaderContainer">
						<div class="fieldHeader dataGridFieldHeader"
						data-ng-click="collapsed['column'+$index]=!collapsed['column'+$index]">
						<label class="col-lg-9 noLftRghtPadding"> <span
							cv-report-customization cv-expression="{{column.displayName}}"
							cv-localize="true"></span>
						</label> <span class="pull-right"> <span
							class="ico inner-panel-expand-icon"
							data-ng-class="{'ico-chevron-down':!collapsed['column'+$index], 'ico-chevron-right':collapsed['column'+$index]}"
								style="margin-right: 5px"></span>
						</span>
					</div>
						<div class="removeColumnInHeader">
							<span class="pull-right"> <span class="ico ico-trashcan"
								title="<fmt:message key='CustomReport.Properties.DeleteColumn'/>"
								data-ng-click="removeColumn(column)"></span>
							</span>
						</div>
					</div>
					<div data-ng-class="{'collapsed': collapsed['column'+$index]}">
						<div class="row noLftRghtMargin">
							<div class="col-xs-12 noLftRghtPadding">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.DisplayName"/>'><fmt:message
											key="CustomReport.Properties.DisplayName" /></label>
									<div class="col-sm-8 noLftRghtPadding">
										<input class="form-control input-sm" type="text"
											placeholder="<fmt:message key='CustomReport.Properties.DisplayName'/>"
											data-ng-model="column.displayName">
									</div>
								</div>
							</div>
						</div>

						<div class="row noLftRghtMargin">
							<div class="col-xs-12 noLftRghtPadding">
								<!-- FIXME: Localize -->
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message
											key="CustomReport.Properties.ID" /></label>
									<div class="col-sm-8 noLftRghtPadding">
										<input class="form-control input-sm" type="text"
											data-ng-model="column.id">
									</div>
								</div>
							</div>
						</div>

						<div class="row noLftRghtMargin">
							<div class="col-xs-12 noLftRghtPadding">
								<!-- FIXME: Localize -->
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message
											key="CustomReport.Properties.ID" /></label>
									<div class="col-sm-8 noLftRghtPadding">
										<input class="form-control input-sm" type="text"
											data-ng-model="column.id">
									</div>
								</div>
							</div>
						</div>
						<div class="row noLftRghtMargin">
							<div class="col-xs-12 noLftRghtPadding">
								<!-- FIXME: Localize -->
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.Aggregate"/>'><fmt:message
											key="CustomReport.Properties.Aggregate" /></label>
									<div class="col-sm-8 noLftRghtPadding">
										<select class="form-control fieldPropValue input-sm"
											data-ng-model="column.aggrType"
											data-ng-change="updateChart()">
											<option value="None"><fmt:message
													key="CustomReport.None" /></option>
											<option value="Count"><fmt:message
													key="CustomReport.Count" /></option>
											<option value="CountDistinct"><fmt:message
													key="CustomReport.Distinct" /></option>
											<option data-ng-if="column.showNumberOps" value="Sum"><fmt:message
													key="CustomReport.Sum" /></option>
											<option data-ng-if="column.showNumberOps" value="Avg"><fmt:message
													key="CustomReport.Avg" /></option>
											<option data-ng-if="column.showNumberOps" value="Min"><fmt:message
													key="CustomReport.Min" /></option>
											<option data-ng-if="column.showNumberOps" value="Max"><fmt:message
													key="CustomReport.Max" /></option>
										</select>
									</div>
								</div>
							</div>
						</div>


						<div class="row formatter-option">
							<div class="col-xs-12">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding"
										title='Formatter'> Formatter </label>
									<div class="col-sm-5 noLftRghtPadding">
										<span class="pull-right"> <span
											class="label label-info cursor-pointer"
											data-ng-click="showFormatterOptions(column,'cellExpression')">{{getFormatterType(column.cellExpression)}}</span>
										</span>
									</div>
								</div>
							</div>
						</div>

						<div class="row noLftRghtMargin">
							<div class="col-xs-12 noLftRghtPadding">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.Hidden"/>'><fmt:message
											key="CustomReport.Properties.Hidden" /></label>
									<div class="col-sm-8 noLftRghtPadding">
										<select class="form-control input-sm"
											data-ng-model="column.hidden"
											data-ng-options="o.v as o.n for o in [{ n: 'False', v: false }, { n: 'True', v: true }]"
											data-ng-change="hideFilterColumn($index)"></select>
									</div>
								</div>
							</div>
						</div>


						<div class="row noLftRghtMargin">
							<div class="col-xs-12 noLftRghtPadding">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding"
										title='Custom Groups'> Custom Groups </label>
									<div class="col-sm-5 noLftRghtPadding">
										<span class="pull-left">
											<div class="on-off-switch" style="margin-top: 3px;">
												<input type="checkbox" name="on-off-switch"
													data-ng-model="column.customGroupsAvailable"
													class="on-off-switch-checkbox" id="customgroup{{$index}}"
													data-ng-click="updateCustomGroupsAvailable(column)">
												<label class="on-off-switch-label"
													for="customgroup{{$index}}"> <span
													class="on-off-switch-inner"></span> <span
													class="on-off-switch-switch"></span>
												</label>
											</div>
										</span> <span
											class="ico ico-pencil pro-btn-algn cursor-pointer pull-right"
											data-ng-click="showAdditionalProperties(column)"
											data-ng-show="column.customGroupsAvailable"></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- End Column properties -->
	</div>
	<div data-ng-show="selectedPropertyCategory==='customcode'">
	    <div data-ng-init="collapseProp=true" data-ng-if="propData.enableRowSelection">
	      <div class="row noLftRghtMargin noLftRghtPadding secondary-header property-header" data-ng-click="collapseProp=!collapseProp">
	         <div class="col-xs-12">
	             <span class="ico col-xs-2 margin-right-5 noLftRghtPadding" data-ng-class="{'ico-chevron-down':!collapseProp, 'ico-chevron-right':collapseProp}"></span>
	             <label class="col-xs-10 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.RowFormatter"/>'>
	              <fmt:message key="CustomReport.Properties.RowFormatter"/><br>
	            </label>
	             
	         </div>
	      </div>
	      <div data-ng-if="!collapseProp">    
	        <event-properties event-type="onClick" event-model="propData.rowFormatter" comp-type="'row'" columns="propData.columns"></event-properties>
	      </div>
	  </div>

	</div>
	<div data-ng-show="selectedPropertyCategory==='filters'">
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<label class="col-xs-12 noLftRghtPadding">
					<fmt:message
						key="CustomReport.Properties.CustomFilterQuery"/><br>
				</label>
				<span class="col-xs-12 noLftRghtPadding">
					<textarea  data-ng-model="propData.customFilterQuery" data-ng-blur="updateComponent(propData.id)"></textarea>
				</span>
			</div>
		</div>
	</div>
</fmt:bundle>