// Closure to isolate scope, as per best practices
(function() {
	// Get a reference to the reportsBuilder module
	var reports = angular.module("reports");
	reports.directive("columnList", function() {
		return {
			restrict : 'E',
			templateUrl : customReports.contextPath + '/reportsplus/components/kendoui/templates/colList.jsp',
			scope : {
				'columns' : '=',
				'callbackfn' : '='
			}
		};
	});
	reports.directive("cellFilter", function() {
		return {
			restrict : 'E',
			templateUrl : customReports.contextPath + '/reportsplus/components/kendoui/templates/cellFilter.jsp',
			replace : true,
			scope : {
				field : '@field',
				filterValue : '@filterValue',
				cellFilter : '@cellFilter'
			},
			controller : [
					"$scope",
					"reportService",
					"$uibModal",
					"customReportSvc",
					function($scope, reportService, $uibModal, customReportSvc) {

						$scope.filter = {
							field : $scope.field,
							value : $scope.filterValue,
							operator : "contains",
							type : "filter"
						}

						$scope.filterApplied = $scope.filterValue ? true : false;

						$scope.handleCellFilter = function() {
							$scope.filterApplied = $scope.filter.value ? true : false;
							$scope.$parent.applyFilter($scope.filter);
						}

					} ]

		};
	});

})();
