<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<div id="{{component.id}}" data-ng-show="!quickAnalysisMode" ng-controller="tableKendoCtrl" data-ng-if="true" class="reportTable full-height grid-component" data-ng-class="{'table-scroll': component.autoHeight === 'Off'}">
		<div class="full-height tableMaskLayer" id="table_{{component.id}}"
				x-lvl-drop-target="true" x-on-drop="dropped(dragEl, dropEl)">
				<div class="pivotOptions" data-ng-if="reportMode == 'builder' && component.type === 'PIVOT_TABLE'">
						<fieldset class="axisColumnDrop ng-isolate-scope" data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}" x-lvl-drop-target="true" data-droptype="pivotRow" x-on-drop="dropped(dragEl, dropEl)">
							<legend class="fieldsetLegend ng-binding"><fmt:message key="CustomReport.Component.DropPivotRow"/></legend>
							<div class="chartColumns groupingCol" data-ng-class="{'hidden':component.pivotRow == undefined || component.pivotRow.column == undefined }">
							<label>
							({{component.pivotRow.column}})
							<span class="deleteColumn" data-ng-click="deleteColumn('pivotRow')">&times;</span>
						</label>
						<!-- No need of a delete button on the dimension data field as it is a mandatory column for all chart types -->

							</div>
						</fieldset>
						<fieldset class="axisColumnDrop ng-isolate-scope" data-ng-class="{'disableColumnDrop':  !component.isSelected || disableMeasureDrop}" x-lvl-drop-target="true" data-droptype="pivotColumn" x-on-drop="dropped(dragEl, dropEl)">
							<legend class="fieldsetLegend ng-binding">Drop Pivot Column</legend>
							<div class="chartColumns groupingCol" data-ng-class="{'hidden':component.pivotColumn == undefined || component.pivotColumn.column == undefined }">
							<label>
							({{component.pivotColumn.column}})
							<span class="deleteColumn" data-ng-click="deleteColumn('pivotColumn')">&times;</span></label></div>
						</fieldset>

						<fieldset class="axisColumnDrop ng-isolate-scope" data-ng-class="{'disableColumnDrop':  !component.isSelected || disableMeasureDrop}" x-lvl-drop-target="true" data-droptype="pivotCell" x-on-drop="dropped(dragEl, dropEl)" >
							<legend class="fieldsetLegend ng-binding">Drop Pivot cell</legend>
							<div class="chartColumns groupingCol" data-ng-class="{'hidden':component.pivotCell == undefined || component.pivotCell.column == undefined }">

							<label>
							<select data-ng-model="component.pivotCell.aggrType" data-ng-change="reloadComponent()" class="colNoBorder">
			                   <option value="None">None</option>
			                   <option value="Count">Count</option>
			                   <option value="CountDistinct">Distinct</option>
			                   <option data-ng-if="component.pivotCell.showNumberOps" value="Sum"><fmt:message key="CustomReport.Sum"/></option>
			                   <option data-ng-if="component.pivotCell.showNumberOps" value="Avg"><fmt:message key="CustomReport.Avg"/></option>
			                   <option data-ng-if="component.pivotCell.showNumberOps" value="Min"><fmt:message key="CustomReport.Min"/></option>
			                   <option data-ng-if="component.pivotCell.showNumberOps" value="Max"><fmt:message key="CustomReport.Max"/></option>
			               </select>
		               	({{component.pivotCell.column}})</label>
							<span class="deleteColumn" data-ng-click="deleteColumn('pivotCell')">&times;</span></div>
						</fieldset>
					</div>
				<div id ="Kendo_{{component.id}}" class="full-height ng-table datagridContainer k-autofitting" data-ng-class="{'hide-expand': !grouped, 'selectable': selectable, 'grouped': grouped,'shared': component.shared}" kendo-grid="kendoGrid" k-options="kendoGridOptions" k-rebind="kendoGridOptions.columns">
					<div  data-ng-if="reportMode == 'builder' && component.type == 'TABLE' && showDropColumnsMessage" class="hideOnExportFriendly show-drop-columns">
						 	<p><fmt:message key="CustomReport.Component.DropDataField"/></p>
				    </div>
				    <table data-ng-class="{'search-results': component.showAsSearchResults}">
				        <tr class="kendo-row odd" k-row-template data-uid="#: uid #" data-ng-attr-style="{{dataItem['rowStyle']}}" data-ng-click="component.enableRowSelection && !component.enableButtonPanel && handleRowClickEvent($event)">
				        	<td data-ng-if="component.enableButtonPanel && component.enableRowSelection && !component.enableMultiRowSelection" class="columnSelector"><input data-ng-if="!dataItem['hideRowSelection']" data-ng-disabled="dataItem['disableRowSelection']" name="{{component.id}}-radio" type="radio" data-ng-model="singleSelectValue" ng-value="{{dataItem[SYS_ROWID]}}" data-ng-click="rowChanged(dataItem,$index)"></td>
							<td data-ng-if="component.enableButtonPanel && component.enableRowSelection && component.enableMultiRowSelection" class="columnSelector"><input data-ng-if="!dataItem['hideRowSelection']" data-ng-disabled="dataItem['disableRowSelection']" data-ng-model="checkboxes[dataItem[SYS_ROWID]]" ng-value="{{dataItem[SYS_ROWID]}}" type="checkbox" data-ng-change="rowChanged(dataItem,$index)" id="{{component.id}}_cb_{{dataItem[SYS_ROWID]}}"><label for="{{component.id}}_cb_{{dataItem[SYS_ROWID]}}" class="checkbox-label">&nbsp;</label></td>
				            <td data-ng-if="!component.showAsSearchResults && !column.hidden" data-label="{{translatedColNames[column.id]}}" data-ng-repeat="column in component.columns" data-ng-class="{'nowrap': !column.wrapText ,'wrap':column.wrapText == true}" data-colId="{{column.id}}" data-label="{{translatedColNames[column.id]}}" data-ng-attr-style="{{dataItem[column.id+'tagAttributes']['style']}}"  data-ng-show="column.visible" ng-attr-title="{{getToolTip(dataItem,column)}}" ng-bind-html="toTrusted(dataItem,column)" ></td>
				            <td colspan="{{component.columns.length}}" data-ng-if="component.showAsSearchResults" class="search-result-row" ng-bind-html="trustHtml(dataItem['rowTemplate'])"></td>
				        </tr>
				        <tr k-alt-row-template class="kendo-row k-alt even" data-uid="#: uid #" data-ng-attr-style="{{dataItem['rowStyle']}}" data-ng-click="component.enableRowSelection && !component.enableButtonPanel && handleRowClickEvent($event)">
				            <td data-ng-if="component.enableButtonPanel && component.enableRowSelection && !component.enableMultiRowSelection" class="columnSelector"><input data-ng-if="!dataItem['hideRowSelection']" data-ng-disabled="dataItem['disableRowSelection']" name="{{component.id}}-radio" type="radio" data-ng-model="singleSelectValue" ng-value="{{dataItem[SYS_ROWID]}}" data-ng-click="rowChanged(dataItem,$index)"></td>
							<td data-ng-if="component.enableButtonPanel && component.enableRowSelection && component.enableMultiRowSelection" class="columnSelector"><input data-ng-if="!dataItem['hideRowSelection']" data-ng-disabled="dataItem['disableRowSelection']" data-ng-model="checkboxes[dataItem[SYS_ROWID]]" ng-value="{{dataItem[SYS_ROWID]}}" type="checkbox" data-ng-change="rowChanged(dataItem,$index)" id="{{component.id}}_cb_{{dataItem[SYS_ROWID]}}"><label for="{{component.id}}_cb_{{dataItem[SYS_ROWID]}}" class="checkbox-label">&nbsp;</label></td>
				            <td data-ng-if="!component.showAsSearchResults && !column.hidden" data-label="{{translatedColNames[column.id]}}" data-ng-repeat="column in component.columns" data-ng-class="{'nowrap': !column.wrapText ,'wrap':column.wrapText == true}" data-colId="{{column.id}}" data-label="{{translatedColNames[column.id]}}" data-ng-attr-style="{{dataItem[column.id+'tagAttributes']['style']}}"  data-ng-show="column.visible" ng-attr-title="{{getToolTip(dataItem,column)}}" ng-bind-html="toTrusted(dataItem,column)"></td>
				            <td colspan="{{component.columns.length}}" data-ng-if="component.showAsSearchResults" class="search-result-row" ng-bind-html="trustHtml(dataItem['rowTemplate'])"></td>
				        </tr>
				    </table>

				    <div k-detail-template>
				        <div kendo-grid="detailGrid" k-options="detailGridOptions(dataItem)" k-rebind="detailGridOptions.columns">
				        		<table data-ng-class="{'search-results': component.showAsSearchResults}">
							        <tr class="kendo-row odd" k-row-template data-uid="#: uid #" data-ng-attr-style="{{dataItem['rowStyle']}}" data-ng-click="component.enableRowSelection && !component.enableButtonPanel && handleRowClickEvent($event)">
							        	<td data-ng-if="component.enableButtonPanel && component.enableRowSelection && !component.enableMultiRowSelection" class="columnSelector"><input data-ng-if="!dataItem['hideRowSelection']" data-ng-disabled="dataItem['disableRowSelection']" name="{{component.id}}-radio" type="radio" data-ng-model="singleSelectValue" ng-value="{{dataItem[SYS_ROWID]}}" data-ng-click="rowChanged(dataItem,$index)"></td>
										<td data-ng-if="component.enableButtonPanel && component.enableRowSelection && component.enableMultiRowSelection" class="columnSelector"><input data-ng-if="!dataItem['hideRowSelection']" data-ng-disabled="dataItem['disableRowSelection']" data-ng-model="checkboxes[dataItem[SYS_ROWID]]" ng-value="{{dataItem[SYS_ROWID]}}" type="checkbox" data-ng-change="rowChanged(dataItem,$index)" id="{{component.id}}_cb_{{dataItem[SYS_ROWID]}}"><label for="{{component.id}}_cb_{{dataItem[SYS_ROWID]}}" class="checkbox-label">&nbsp;</label></td>
							            <td data-ng-if="!component.showAsSearchResults && !column.hidden" data-colId="{{column.id}}" data-label="{{translatedColNames[column.id]}}" data-ng-repeat="column in component.columns" data-ng-attr-style="{{dataItem[column.id+'tagAttributes']['style']}}"  data-ng-show="column.visible" ng-attr-title="{{getToolTip(dataItem,column)}}" ng-bind-html="toTrusted(dataItem,column)" ></td>
							            <td colspan="{{component.columns.length}}" data-ng-if="component.showAsSearchResults" class="search-result-row" ng-bind-html="trustHtml(dataItem['rowTemplate'])"></td>
							        </tr>
							        <tr k-alt-row-template class="kendo-row k-alt even" data-uid="#: uid #" data-ng-attr-style="{{dataItem['rowStyle']}}" data-ng-click="component.enableRowSelection && !component.enableButtonPanel && handleRowClickEvent($event)">
							            <td data-ng-if="component.enableButtonPanel && component.enableRowSelection && !component.enableMultiRowSelection" class="columnSelector"><input data-ng-if="!dataItem['hideRowSelection']" data-ng-disabled="dataItem['disableRowSelection']" name="{{component.id}}-radio" type="radio" data-ng-model="singleSelectValue" ng-value="{{dataItem[SYS_ROWID]}}" data-ng-click="rowChanged(dataItem,$index)"></td>
										<td data-ng-if="component.enableButtonPanel && component.enableRowSelection && component.enableMultiRowSelection" class="columnSelector"><input data-ng-if="!dataItem['hideRowSelection']" data-ng-disabled="dataItem['disableRowSelection']" data-ng-model="checkboxes[dataItem[SYS_ROWID]]" ng-value="{{dataItem[SYS_ROWID]}}" type="checkbox" data-ng-change="rowChanged(dataItem,$index)" id="{{component.id}}_cb_{{dataItem[SYS_ROWID]}}"><label for="{{component.id}}_cb_{{dataItem[SYS_ROWID]}}" class="checkbox-label">&nbsp;</label></td>
							            <td data-ng-if="!component.showAsSearchResults && !column.hidden" data-colId="{{column.id}}"  data-label="{{translatedColNames[column.id]}}" data-ng-repeat="column in component.columns" data-ng-class="{'nowrap': !column.wrapText ,'wrap':column.wrapText == true}" data-ng-class="{'nowrap': !column.wrapText ,'wrap':column.wrapText == true}"  data-ng-attr-style="{{dataItem[column.id+'tagAttributes']['style']}}" data-ng-show="column.visible" ng-attr-title="{{getToolTip(dataItem,column)}}" ng-bind-html="toTrusted(dataItem,column)"></td>
							            <td colspan="{{component.columns.length}}" data-ng-if="component.showAsSearchResults" class="search-result-row" ng-bind-html="trustHtml(dataItem['rowTemplate'])"></td>
							        </tr>
							    </table>
				        </div>
				    </div>
				</div>
			</div>
		</div>

	<div class="qcContainer full-height" data-ng-if="!exportType && reportMode !== 'preview' && component && component.dataSet && quickAnalysisMode">
		<chart-wrapper data-columns="component.columns" data-column-data="columnData" parent="component.id" filters="component.filters" quick-chart="component.quickChart" height="component.quickChart.height"></chart-wrapper>
	</div>

</fmt:bundle>
