(function() {
	"use strict";

	angular.module("reports").controller("kendoGridCtrl", kendoGridCtrl);

	kendoGridCtrl.$inject = [ '$scope', 'reportService', 'customReportSvc', 'dataSource', '$timeout' ];

	function kendoGridCtrl($scope, reportService, customReportSvc, dataSource, $timeout) {
		var kendoGridModel = {};
		$scope.rowIndex = 0;
		$scope.prevRowUID = undefined;
		$scope.kendoDataSource = null;
		$scope.setChildScope($scope);
		$scope.kendoColumns = [];
		$scope.kendoGridOptions = {}
		$scope.columnDefinitionById = {};
		$scope.gridDataInitialized= false;
		if (!$scope.component.sorting) {
			$scope.component.sorting = [];
		}
		$scope.component.kendoAggregates = [];
		if (typeof $scope.component.showGroupingHeader === 'undefined') {
			$scope.component.showGroupingHeader = true;
		}
		$scope.componentLoaded = false;

		customReportSvc.setDefaultStyles($scope.component); // to set default
		var exportType = customReportSvc.getParameterByName("exportType"), isPreview = customReportSvc
				.getParameterByName("isPreview", false);

		$scope.isPreviewEnabled = isPreview;
		$scope.exportType = exportType;

		if ($scope.isPreviewEnabled || $scope.reportMode === 'preview') {
			$scope.component.hideAlarmOption = true;
			$scope.component.hideCsvOption = true;
		}

		$scope.bindClickEventToRow = function() {
			let $rows = $("li[comp=" + $scope.component.id + "] table tbody>tr:not('.k-grouping-row,.groupingrow')");
			if($scope.component.enableRowSelection)
			 	$rows.addClass("cursor-pointer");
		
			$rows.off("click").on("click", function($event) {
                let $groupingRow = $(this).parents(".groupingrow"),
	            groupName;
	            if($groupingRow.length !== 0)
	              groupName = $groupingRow.data("groupName");
                $scope.handleTableRowSelection($event,$(this).index(),groupName); 
            });

            if (!$scope.gridDataInitialized && $scope.component.rowFormatter && $scope.component.rowFormatter.action === "ShowPreview" 
				&& $scope.component.rowFormatter.previewComponentId && $scope.isCustomHtmlCompPresent($scope.component.rowFormatter.previewComponentId))
				 $rows.first().click();
				
            $scope.gridDataInitialized = true;
		}

		//!common!
		$scope.createKendoGrid = function() {
			var isValid = false;
			$scope.component.isComponentLoading = true;

			if (!$scope.isFullScreen) {
				$scope.loadingButton();
			}

			if ($scope.component.columns.length == 0) {
				$timeout(function() {
					$scope.componentLoaded = true;
					$scope.component.isComponentLoading = false;
				});

				return;
			}
			if (!$scope.dataservice) {
				if ($scope.dataSet) {
					$scope.dataservice = dataSource.getDataSource($scope.dataSet.endpoint);
				}
			}
			// kendo datasource

			$scope.kendoDataSource = new kendo.data.DataSource({
				type : "json",
				data : [],
				pageSize : $scope.component.pageSize,
				serverPaging : true,
				serverFiltering : true,
				serverSorting : true,
				serverGrouping : true,
				serverAggregates : false,
				filter: $scope.tempComponent.dataGridFilter,
				transport : {
					read : function(params) {
						if(typeof $scope.kendoDataSource !== "undefined" && params.data.isAutoRefresh) {
							const kendoGrid = $("#Kendo_" + $scope.component.id).data("kendoGrid");
							kendoGrid.element.find("div.k-loading-mask").remove();
						}
						var sort = params ? params.data.sort : [];
						var pageNo = params.data.page - 1; // solr start = 0
						var pageSize = params.data.pageSize;
						var skip = params.data.skip; // 0 for pageNo 1
						var kendoGroups = params ? params.data.group : [];
						var filter = params ? params.data.filter : null;

						$scope.component.pageOffset = skip;
						$scope.component.pageSize = pageSize;
						$scope.component.group = kendoGroups;
						$scope.component.filters = [];
						$scope.component.groupDimensions = [];
						$scope.component.sorting = sort;					
						var sortOnAggregateField = false;

						if (filter) {
							$scope.addKendoGridFilters(filter, $scope.component.filters);

						}
						if ($scope.component.group.length > 0) {

							if (sort && sort.length > 0) {
								var sortObj = sort[0];
								angular.forEach($scope.component.groupMeasures, function(measure, idx) {
									if (measure.sortOrder) {
										delete measure.sortOrder;
									}
								});
								angular.forEach($scope.component.groupMeasures, function(measure, idx) {
									if (sortObj.field === measure.column) {
										sortOnAggregateField = true;
										measure.sortOrder = sortObj.dir;
									}
								});

							}

							angular.forEach(kendoGroups, function(group, idx) {
								var dimension = {};
								dimension.column = group.field;
								dimension.numPointsToDisplay = {};
								dimension.numPointsToDisplay.maxPoints = pageSize;
								if (idx == 0) {
									dimension.numPointsToDisplay.offset = $scope.component.pageOffset;
								}
								dimension.sortDirection = sortOnAggregateField ? null : group.dir;

								angular.forEach($scope.kendoGridOptions.columns, function(kendoCol, idx) {
									if (kendoCol.field == group.field) {
										kendoCol.hidden = true;
									}
								});
								if (group.aggregates.length == 0) {
									angular.forEach($scope.component.groupMeasures, function(measure, idx) {
										var kendoAggregate = {};
										kendoAggregate.field = measure.column;
										kendoAggregate.aggregate = measure.aggrType.toLowerCase();
										group.aggregates.push(kendoAggregate);
									});
									$scope.addKendoGridAggregate(group.field,"Count", group);
								}
								angular.forEach($scope.component.columns, function(col, idx) {
									if (group.field == col.dataField) {
										dimension.minCount = parseInt(col.minCount);
										col.showMinCount = true;
									}
								});
									
								$scope.component.groupDimensions.push(dimension);
							});

							var options = {};
							options.dataSet = $scope.dataSet;
							options.componentType = $scope.component.type;
							options.dimensionDataField = customReportSvc.getDeepCopy($scope.component.groupDimensions);
							options.measureDataField = $scope.component.groupMeasures;
							options.sortOptions = $scope.component.sorting[0];
							options.filters = $scope.component.filters;
							options.constructGroupStructure = true;
							options.doNotExclude = true;
							options.groups = customReportSvc.getDeepCopy($scope.component.group);
							var dimensions = options.dimensionDataField;
							var isMapped = false;
							angular.forEach(options.dimensionDataField, function(dimension, index) {
								angular.forEach($scope.component.columns, function(column, index) {
									if (column.id === dimension.column && column.mapping) {
										dimensions.push({
											'column': dimension.column
										});
										if (column.mapping) {
											dimension.column = column.mapping;
											dimension.isMappedCol = true;
											isMapped = true;
										}
									}
								});
							});
							options.inputParams = customReportSvc.applyInputsToDataSet($scope.dataSet,
									$scope.page.inputs);
							
							if($scope.component.outerGridFilterQuery) 
								options.customFilterQuery = $scope.component.outerGridFilterQuery;
								
							options.offset = $scope.component.pageOffset;
							if ($scope.dataservice) {
								$scope.dataservice.getChartData(options, function(resp, reqObj) {
									$scope.rowIndex = 0;
									$scope.prevRowUID = undefined;
									$scope.respData = {};
									if (isMapped) {
										if (resp && resp.data && resp.data.groups) {
											angular.forEach(resp.data.groups, function(group, index) {
												if (group.items && group.items.length > 0) {
													var mappedField = group.field;
													var mappedValue = group.value;
													group.field = group.items[0].field;
													group.value = group.items[0].value;
													group.mappedValue = mappedValue;
													$scope.respData[group.field + '_' + group.value + '_' + mappedValue] = {'field': mappedField, 'value': mappedValue};
													group.items = [];
												}
											});
										} else if(Array.isArray(resp.records) && Array.isArray(resp.columns)) {
											//when aggregate is None the facet query will not be formed. So groups will not be prsesnt in data
											//Need to form groups using records
											resp.data= {
												groups : []
											}
											const groupField = $scope.component.group[0].field;
											const feildAggrMap = {};
											$scope.component.group[0].aggregates.forEach(aggr => {feildAggrMap[aggr.field] = aggr.aggregate.toLowerCase()});
											resp.records.forEach(record => {
												const group = {
													field: groupField,
													items:[],
													hasSubGroups:true,
													aggregates:{}
												};
												let mappedValue,mappedCol;
											    resp.columns.forEach((col,indx) => {
													if(col.isMappedCol) {
														mappedValue = record[indx];
														mappedCol = col.column;
														group.aggregates.mappedValue = mappedValue;
													} else {
														group.aggregates[col.column] = {[feildAggrMap[col.column]]:record[indx]};
														if(groupField === col.column)						
															group.value = record[indx];
													}
													
												});
												if(mappedValue) {
													$scope.respData[group.field + '_' + group.value + '_' + mappedValue] = {'field': mappedCol, 'value': mappedValue};
													mappedValue="";
												}												
												resp.data.groups.push(group);		
										});
										}
									}
									params.success(resp);
									isValid = true;
									$timeout(function() {
										$scope.componentLoaded = true;
										$scope.component.isComponentLoading = false;
									});
									if($.isEmptyObject($scope.tempComponent))
										$scope.tempComponent = {};
									$scope.tempComponent.latestSearchParams = [reqObj.params];
								});

							}
						} else {

							if (sort) {
								$scope.component.sorting = [];
								for (var i = 0; i < sort.length; i++) {
									var sortObj = {};
									sortObj.columnId = sort[i].field;
									sortObj.direction = sort[i].dir;
									sortObj.sortAxis = 'XAxis';
									$scope.component.sorting.push(sortObj);
								}
							} else {
								$scope.component.sorting = [];
							}
							var options = {};
							options.dataSet = $scope.dataSet;
							var measures = [];
							$scope.component.groupMeasures = [];

							angular.forEach($scope.component.columns, function(col, idx) {
								col.showMinCount = false;
								col.minCount = 1;
								angular.forEach($scope.kendoGridOptions.columns, function(kendoCol, idx) {
									if (kendoCol.field == col.dataField && !col.hidden) {
										kendoCol.hidden = false;
										return false;
									}
								});
							});

							options.tableParams = {
								columns : $scope.component.columns,
								offset : $scope.component.pageOffset,
								limit : $scope.component.pageSize,
								sort : $scope.component.sorting,
								filters : $scope.component.filters,
								measures : [],
								customFilterQuery: $scope.component.outerGridFilterQuery
							};
							options.inputParams = customReportSvc.applyInputsToDataSet($scope.dataSet,
									$scope.page.inputs);

							if ($scope.dataservice) {
								$scope.dataservice.getTableData(options, function(resp, reqObj) {
									$scope.rowIndex = 0;
									$scope.prevRowUID = undefined;
									var records = resp.records;
									var columns = resp.columns;
									params.success(resp);
									isValid = true;
									$timeout(function() {
										$scope.componentLoaded = true;
										$scope.component.isComponentLoading = false;
									});							
						
								});
							}

						}
					}
				},
				group : $scope.component.group,
				schema : {
					model : kendoGridModel,
					data : function(data) {
						return data.records;
					},
					total : function(response) {
						var totalRecordCount = 0;
						if (response.hasOwnProperty("totalRecordCount")) {
							return response.totalRecordCount;
						}
					},
					aggregates : function(response) {
					},
					selectable : "row",
					groups : function(response) {
						return response.data.groups;
					}
				},
				aggregate : [],
				sort : $scope.component.sorting
			});

			//Add kendo grid aggregate
			//!common!
			$scope.addKendoGridAggregate = function(aggrField, aggrType, kendoGroupObj) {
				var kendoAggregate = {};
				var measure = {};
				var cellExpression = $scope.component.allCellExpression;
				var kendoAggregates = [];
				var groupMeasures = [];
				var aggrCnt = 0;

				kendoAggregate.field = aggrField;
				kendoAggregate.aggregate = aggrType.toLowerCase();

				for (var j = 0; j < $scope.component.columns.length; j++) {
					var col = $scope.component.columns[j];
					if (col.cellExpression && aggrField === col.dataField) {
						cellExpression = col.cellExpression;
					}
				}
				measure.column = aggrField;
				measure.aggrType = aggrType;
				measure.cellExpression = cellExpression;
				for (var j = 0; j < kendoGroupObj.aggregates.length; j++) {
					var aggr = kendoGroupObj.aggregates[j];
					if (aggr.field === aggrField && aggr.aggregate === aggrType.toLowerCase()) {
						aggrCnt++;
					}
				}
				;
				if (aggrCnt == 0) {
					kendoAggregates.push(kendoAggregate);
				} else if (aggrCnt > 0) {
					aggrCnt = 0;
				}

				for (var j = 0; j < $scope.component.groupMeasures.length; j++) {
					var measureObj = $scope.component.groupMeasures[j];
					if (measureObj.column === aggrField && measureObj.aggrType === aggrType) {
						aggrCnt++;
					}

				}
				;
				if (aggrCnt == 0) {
					groupMeasures.push(measure);
				} else if (aggrCnt > 0) {
					aggrCnt = 0;
				}

				kendoGroupObj.aggregates.push.apply(kendoGroupObj.aggregates, kendoAggregates);
				$scope.component.groupMeasures.push.apply($scope.component.groupMeasures, groupMeasures);

				if ($scope.component.groupMeasures.length == 0) {
					kendoGroupObj.aggregates.push(kendoAggregate);
					$scope.component.groupMeasures.push(measure);
				}

			};
			//add KendoGrid filters to component filter.
			//!common!
			$scope.addKendoGridFilters = function(kendoGridFilter, reportFilters) {
				kendoGridFilter = kendoGridFilter || {'filters': []};
				var filters = kendoGridFilter.filters;
				if ($.isEmptyObject(filters)) {
					return;
							}
				var filterMapping = {};
				angular.forEach(filters, function(filterObj, index){
					if (filterObj && filterObj.field) { 	// single filter query without operator
						filterMapping[filterObj.field] = {'logic': 'or', 'filters': [filterObj]};
					} else if (filterObj && filterObj.filters) { 	// multiple query with logic in between
						filterMapping[filterObj.filters[0].field] = filterObj;
						}
				});
				angular.forEach($scope.component.columns, function(column, index) {
					var fieldName = column.dataField;
					if (filterMapping[fieldName]) {
						$scope.addFilters(fieldName, filterMapping[fieldName], $scope.component, false, false, undefined, true, 'viewer', undefined, true, undefined, true, false);
					} else {
						$scope.addFilters(fieldName, "", $scope.component, false, false, undefined, true, 'viewer', undefined, true, undefined, true, false);

					}
				});
				customReportSvc.triggerCallback("redrawAllComponents", $scope.component.id);
				// need to stop double redraw on page reload

			};
			// general kendo grid options
			//!common!??
			$scope.kendoGridOptions = {
				dataSource : $scope.kendoDataSource,
				dataBinding : onDataBinding,
				// filterable : {
				// 	mode : $scope.component.showColumnFilters ? "row" : "menu",				
				// },
				sortable : {
					mode : "single",
					allowUnsort : true
				},
				pageable : {
					refresh : true,
					pageSizes : true,
					buttonCount : 5
				},
				scrollable : false,
				resizable : true,
				reorderable : true,
				groupable : ($scope.reportMode === 'viewer' || $scope.reportMode === 'preview') ? $scope.component.showGroupingHeader: true,
				columnMenu : true,
				columns : $scope.kendoColumns.filter(function(column) { return !column.hideFromOuterGrid; }),
				columnHide : function(e) {

				},
				dataBound : function(e) {
					var grid = $("#Kendo_" + $scope.component.id).data("kendoGrid");
					var GrpFooterList = $(".k-group-footer");
					var GrpList = $(".k-grouping-row");
					if (grid && this.dataSource.group().length > 0) {
						var firstCell = e.sender.element.find(".k-grouping-row td:first-child");
                        firstCell.attr("colspan", 2);
						for (var i = 0; i < GrpList.length; i++) {
							var firstGroup = GrpList[i];
							if (firstGroup) {
								grid.collapseGroup(firstGroup);
							}
						}
						for (var i = 0; i < GrpFooterList.length; i++) {
							$(GrpFooterList[i]).show();

						}
					}

					//!!group header click event to bring search results!!
					$("li[comp=" + $scope.component.id + "] .k-grouping-row a.k-icon")
							.off("click")
							.on("click",
									function(event) {										
										var self = $(this);
										var groupTemplate = self.next(".groupItem");
										var groupingField = $(groupTemplate).attr("data-group");
										var groupingValue = $(groupTemplate).attr("data-group-value");
										var headerUid = $(groupTemplate).attr("data-uid");
										var filters = {};
										filters.columnId = groupingField;
										filters.fValue = groupingValue;
										var currentGroupLevel = 0;
										var fieldsMapping = {};
										angular.forEach($scope.component.columns, function(column, index) {
											if (column.mapping) {
												fieldsMapping[column.id] = column.mapping;
											}
										});
										for (var j = 0; j < $scope.component.group.length; j++) {
											var group = $scope.component.group[j];
											if (groupingField == group.field || (fieldsMapping[group.field] && fieldsMapping[group.field] === groupingField)) {
												currentGroupLevel = j + 1;
												break;
											}
										}
										var groupExpandClass = "groupExpand_" + currentGroupLevel;
										var groupExpandClassTr = groupExpandClass + "_tr";
										if (self.hasClass("k-i-expand")) {

											self.addClass(groupExpandClass);
											self.closest("tr").addClass(groupExpandClassTr);
											self.data("filterData", filters);

											var previousGroupLevel = currentGroupLevel - 1;
											var previousGroupClass = "groupExpand_" + previousGroupLevel;
											var previousGroupClassTr = previousGroupClass + "_tr";
											//Get the previous group row
											var previousGroup = self.closest("tr").prevAll("tr." +
													previousGroupClassTr + ":first").find("a." + previousGroupClass)[0];

											var addedFilterData = {};
											if (previousGroup) {
												addedFilterData = $(previousGroup).data("filterData");
											}

											var currentGrpFilters = [];
											currentGrpFilters.push(filters);
											if (!$.isEmptyObject(addedFilterData)) {
												currentGrpFilters.push(addedFilterData);

											}

											if (currentGroupLevel == $scope.component.group.length) {
												let count;												
												const uuid = generateUUID();
												const colspan = $scope.component.columns.reduce((count, col) =>
    															count + (col.visible === true && col.hidden === false && !col.hideFromInnerGrid), 0);
												var rowTemplate = '<tr data-uid="' +
														uuid +
														'" role="row" class="ng-scope groupingrow" data-group-name = "'+groupingField+'_'+groupingValue+'" style="display: table-row;" >' +
														'<td class="k-group-cell">&nbsp;</td><td class="' + uuid +
														'" colspan="' + colspan +
														'"><div class="groupDetailsRow"></div></td></tr>';

												self.closest("tr.k-grouping-row").after(rowTemplate);
												detailInit($("." + uuid).find(".groupDetailsRow"), currentGrpFilters, headerUid);
											}
										} else {
											self.removeData().removeClass(groupExpandClass);
											self.closest("tr").removeClass(groupExpandClassTr);
											self.closest("tr.k-grouping-row").next('tr.groupingrow').remove();

										}

										$scope.resizeGridComponent();
										$timeout(function() {
											$scope.bindClickEventToRow();
										},500);
									});
					//!!mouseup event to bring up the hidden group footers!!
					$(".k-grouping-row a.k-icon").off("mouseup").on("mouseup", function() {
						$timeout(function() {
							for (var i = 0; i < GrpFooterList.length; i++) {
								if ($(GrpFooterList[i]).css('display') === 'none') {
									$(GrpFooterList[i]).show();
								}

							}
						});
					});
					let $groupingRows = $(".k-grouping-row",this.tbody);
					//to exapnd the first group and show it's preview the component
					if($groupingRows.length > 0) {
						if($scope.component.rowFormatter && $scope.component.rowFormatter.action === "ShowPreview" 
							&& $scope.component.rowFormatter.previewComponentId && $scope.isCustomHtmlCompPresent($scope.component.rowFormatter.previewComponentId)) {
								this.expandRow($(".k-grouping-row",this.tbody).first());
						}							
					} else
						$scope.bindClickEventToRow();				
					$scope.resizeGridComponent();					
					
				},
				columnMenuInit : function(e) {
					if ($scope.kendoGrid.dataSource.group().length > 0) {

						var menu = e.container.find(".k-menu").data("kendoMenu");
						var field = e.field;
						var isNumericCol = $scope.isNumericCol(field);

						var aggregateMenuStr = cvKendoAggregateMenu.getKendoAggregateMenu(field, 'None', 'checked');

						aggregateMenuStr += cvKendoAggregateMenu.getKendoAggregateMenu(field, 'Count', '');
						aggregateMenuStr += cvKendoAggregateMenu.getKendoAggregateMenu(field, 'CountDistinct', '');

						if (isNumericCol) {
							aggregateMenuStr += cvKendoAggregateMenu.getKendoAggregateMenu(field, 'Sum', '');
							aggregateMenuStr += cvKendoAggregateMenu.getKendoAggregateMenu(field, 'Min', '');
							aggregateMenuStr += cvKendoAggregateMenu.getKendoAggregateMenu(field, 'Max', '');
						} else if ($scope.isDateCol(field)) {
							aggregateMenuStr += cvKendoAggregateMenu.getKendoAggregateMenu(field, 'Min', '');
							aggregateMenuStr += cvKendoAggregateMenu.getKendoAggregateMenu(field, 'Max', '');
						}

						$(e.container).find("ul.k-menu").append(cvKendoAggregateMenu
								.getMenuPlaceHolder(aggregateMenuStr));
						var aggregateInputs = $(e.container).find("ul.k-menu").find(".cvDataGridAggregate")
								.find(".aggregateInput");
						angular.forEach($scope.component.groupMeasures, function(measure, idx) {
							var aggrType = measure.aggrType;
							var text = $scope.getAggregateText(aggrType.toLowerCase());
							var itemName = "aggregateInput_" + measure.column;

							$(aggregateInputs).each(function(index) {
								console.log($(this).attr("data-aggregation"));
								if ($(this).attr("data-aggregation") === aggrType) {
									$(this).attr("checked", true);
									return false;
								}
							});
						});

						$(".cvDataGridAggregateText").off("click").on("click", function(event) {
							event.stopPropagation();
							var aggregateInput = $(this).prev(".aggregateInput");
							var checked = aggregateInput.is(":checked");
							aggregateInput.attr("checked", !checked);

							var tempCols = $scope.onSelectAggregation(aggregateInput);
							$scope.kendoGrid.columns = tempCols;
							$scope.kendoGrid.dataSource.read();
						});
						menu.bind("select", function(e) {
							var menuText = $(e.item).text();
							var aggregateInput = $(e.item).find(".aggregateInput");
							var aggrType = aggregateInput.attr("data-aggregation");
							var aggrField = aggregateInput.attr("data-field");

							var tempCols = $scope.onSelectAggregation(aggregateInput);
							menu.close();
							$scope.kendoGrid.columns = tempCols;
							$scope.kendoGrid.dataSource.read();
						});

					}
				},
				columnReorder : function(e) {
					var newIndex = e.newIndex;
					var columnName = e.column.field;
					$scope.swapColumns(columnName, newIndex);
					$scope.updateKendoModel();
				}
			};
			$scope.onSelectAggregation = function(aggregateInput) {
				var aggregateCols = [];
				var aggrType = aggregateInput.attr("data-aggregation");
				var aggrField = aggregateInput.attr("data-field");

				if (aggregateInput.is(":checked") && aggrType.toLowerCase() != "none") {

					angular.forEach($scope.kendoGridOptions.columns, function(kendoCol, idx) {
						if (kendoCol.field == aggrField) {

							var text = $scope.getAggregateText(aggrType.toLowerCase());
							// kendoCol.groupFooterTemplate = function(row) {
							// 	// return $scope.getFormattedCellValue(row, kendoCol, aggrType, text);
							// };
						}
						aggregateCols.push(kendoCol);
					});

					angular.forEach($scope.kendoGrid.dataSource.group(), function(group, idx) {
						$scope.addKendoGridAggregate(aggrField, aggrType, group);
					});

				} else {
					aggregateCols = [];
					var tempGroupMeasure = [];
					angular.forEach($scope.kendoGridOptions.columns, function(kendoCol, idx) {
						var col = kendoCol;
						if (kendoCol.field == aggrField) {
							delete col.groupFooterTemplate;
						}
						aggregateCols.push(col);
					});
					angular.forEach($scope.component.groupMeasures, function(measure, idx) {
						if (measure.column != aggrField) {
							tempGroupMeasure.push(measure);
						}
					});

					angular.forEach($scope.kendoGrid.dataSource.group(), function(group, idx) {
						var groupAggregates = [];
						angular.forEach(group.aggregates, function(aggregate, index) {
							if (aggregate.field != aggrField) {
								groupAggregates.push(aggregate);
							}
						});
						group.aggregates = groupAggregates;
					});

					$scope.component.groupMeasures = tempGroupMeasure;
				}
				return aggregateCols;
			};

			$scope.resizeGridComponent = function() {
				$timeout(function() {

					var tableHeight = $("li[comp=" + $scope.component.id + "]").find(".datagridContainer").outerHeight(true) +
							$("li[comp=" + $scope.component.id + "]").find(".reportstabletitle").outerHeight(true) + 10;

					var tableWidth = $("li[comp=" + $scope.component.id + "]").find(".datagridContainer").width();
					var gridsterCurColWidth = $("#reportContentWrapper").size() > 0 ? $("#reportContentWrapper").width() / 12 : $scope.gridster.curColWidth;
					if ($scope.gridsterItem && $scope.gridsterItem.$element && !$scope.component.collapsed &&
							tableWidth > 0 && gridsterCurColWidth > 0) {
						if (!$scope.isFullScreen) {
							$scope.gridsterItem.sizeX = Math.ceil(tableWidth / gridsterCurColWidth);
						}
						$scope.gridsterItem.sizeY = Math.ceil(tableHeight / $scope.gridster.rowHeight);
					}
				}, 200);
			};

			//!common!
			$scope.swapColumns = function(columnName, newIndex) {
				for (var j = 0; j < $scope.component.columns.length; j++) {
					var col = $scope.component.columns[j];
					if (col.dataField == columnName) {
						var currentIndex = j;
						var currentCol = $scope.component.columns[newIndex];
						$scope.component.columns[newIndex] = col;
						$scope.component.columns[j] = currentCol;
						break;
					}
				}
			};

			function isOdd(num) {
				return num % 2;
			}

			$scope.getFormattedValue = function(value, cellExpression, col,rowIndex, row) {
				return customReportSvc.getFormattedValue(value, cellExpression, row, rowIndex, undefined, col, $scope.dataSet);
			};
			//!common!
			var getIntraFieldSolrOperator = function(kendoOperator, filterValue, isNumeric, allowInterFieldOp,
					interFieldOp) {
				var solrOperator = filterValue;
				switch (kendoOperator) {
				case "eq":
					if (isNumeric) {
						solrOperator = filterValue;
					} else {
						solrOperator = '"' + filterValue + '"';
					}
					break;
				case "neq" || "doesnotcontain":
					solrOperator = "!" + filterValue;
					break;
				case "startswith":
					solrOperator = "^" + filterValue;
					break;
				case "contains":
					solrOperator = "*" + filterValue + "*";
					break;
				case "doesnotcontain":
					solrOperator = "";
					break;
				case "endswith":
					solrOperator = filterValue + "$";
					break;
				default:
					break;
				}
				if (allowInterFieldOp) {
					switch (interFieldOp.toLowerCase()) {
					case "and":
						solrOperator = solrOperator + "&&";
						break;
					case "or":
						solrOperator = solrOperator + "||";
						break;
					default:
						break;
					}
				}
				return solrOperator;

			};

			var detailInit = function(groupItem, groupFilters, groupHeaderUid) {
				let dataSource = new kendo.data.DataSource({
						type : "json",
						data : $scope.component.kendoGroupDetailsData,
						pageSize : 5,
						serverPaging : true,
						serverFiltering : true,
						serverSorting : false,
						serverGrouping : false,
						serverAggregates : false,
						reorderable : false,
						transport : {
							read : function(params) {
								var sort = params ? params.data.sort : null;
								var pageNo = params.data.page - 1; // solr start = 0
								var pageSize = params.data.pageSize;
								var skip = params.data.skip; // 0 for pageNo 1
								var group = params ? params.data.group : null;
								var filter = params ? params.data.filter : null;
								var pageOffset = skip;
								var pageSize = pageSize;
								var tableFilters = [];

								if (sort) {
									var sorting = [];
									for (var i = 0; i < sort.length; i++) {
										var sortObj = {};
										sortObj.columnId = sort[i].field;
										sortObj.direction = sort[i].dir;
										sortObj.sortAxis = 'XAxis';
										sorting.push(sortObj);
									}
								}
								if (!$.isEmptyObject(filter)) {
									$scope.addKendoGridFilters(filter, tableFilters);

								}
								let customFilterQuery = $scope.component.innerGridFilterQuery;
								tableFilters = tableFilters.concat(groupFilters, $scope.component.filters);
								const groupHeaderRow = $scope.kendoGrid._groupRows.find(groupRow => {
									return ($scope.component.groupDimensions.filter(groupDimension => groupRow.aggregates[groupDimension.column].uid === groupHeaderUid)).length === 1;
								});
								
								let row = {};
								$scope.component.groupMeasures.forEach(groupMeasure => { 
									row[groupMeasure.column] = groupHeaderRow.aggregates[groupMeasure.column][groupMeasure.aggrType.toLowerCase()];

								});
								
								if(customFilterQuery && !$.isEmptyObject(groupHeaderRow)) {
									customFilterQuery = customReportSvc.evalExpression(customFilterQuery, row);
								}
								
								var options = {};
								options.dataSet = $scope.dataSet;
								options.tableParams = {
									columns : $scope.component.columns,
									offset : pageOffset,
									limit : pageSize,
									sort : sorting,
									filters : tableFilters,
									group : group,
									measures : [],
									customFilterQuery: customFilterQuery
								};
								options.inputParams = customReportSvc.applyInputsToDataSet($scope.dataSet,
										$scope.page.inputs);
								
								if ($scope.dataservice) {
									$scope.dataservice.getTableData(options, function(resp) {
										$scope.rowIndex = 0;
										$scope.prevRowUID = undefined;
										var records = resp.records;
										params.success(resp);
										$timeout(function() {
											$scope.componentLoaded = true;
											$scope.component.isComponentLoading = false;
										});
									});
								}

							}
					},
					schema : {
						model : kendoGridModel,
						data : function(data) {
							return data.records;
						},
						total : 'totalRecordCount',
						aggregates : function(response) {
							return response.stats;
						},
						selectable : "row"
					},
					aggregate : []
				});
				groupItem.kendoGrid({
					dataSource : dataSource,
					scrollable : false,
					resizable : true,
					sortable : false,
					pageable : true,
					columns : $scope.kendoColumns.filter(function(column) { return !column.hideFromInnerGrid; })
				});

				if(!$.isEmptyObject($scope.kendoDataSource._group)) {
					if(typeof $scope.kendoDataSource.groupDataSources === 'undefined')
						$scope.kendoDataSource.groupDataSources = {};
					angular.forEach(groupFilters,function(groupFilter) {
						let fieldName =groupFilter.columnId + "_" +groupFilter.fValue;
						$scope.kendoDataSource.groupDataSources[fieldName] = dataSource;
					});
					
				}
			};

			var previousGrouping = {};
			function onDataBinding(e) {
	            var dataSource = this.dataSource;
	            var groups = dataSource.group();

	            if (groups.length > 1) {
	                e.preventDefault();
	                for (var i = 0; i < groups.length; i++) {
	                    if (previousGrouping.length > 0 && (groups[i].field == previousGrouping[0].field)) {
	                        groups.splice(i, 1);
	                    };
	                };
	                setTimeout(function() {
	                    dataSource.read();
	                });
	            };

	            previousGrouping = groups;
	        };
			function generateUUID() {
				var d = new Date().getTime();
				var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
					var r = (d + Math.random() * 16) % 16 | 0;
					d = Math.floor(d / 16);
					return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
				});
				return uuid;
			}
			;

		}

		//drag and drop handler in dashboard.
		//!common!
		$scope.dropped = function(dragEl, dropEl) {
			$scope.component.allColumns = false;
			if ($scope.reportMode == "viewer") {
				return;
			}

			if (!$scope.component.isSelected) {
				customReportSvc.errorToast('Select the component to add a column.');
				return;
			}
			var dest = document.getElementById(dropEl);
			var src = document.getElementById(dragEl);

			var drag = angular.element(src);
			var drop = angular.element(dest);

			var columnName = drag.attr("data-name");
			var columnType = drag.attr("data-type");
			var origType = drag.attr("data-origtype");
			var dataField = drag.attr("data-datafield");
			var dataSetEntity = drag.data("datasetentity");
			var dataSetName = dataSetEntity.dataSetName;

			if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
				$scope.associateDataSetToComponent(dataSetEntity);
			} else if ($scope.component.dataSet.dataSetName != dataSetName) {
				alert("Mismatched data Sets");
				return;
			}

			if (columnName == "allColumns") {
				$scope.component.allColumns = true;
				var columns = $scope.$parent.dataSet.fields;
				for (var j = 0; j < columns.length; j++) {
					var col = columns[j];
					var column = $scope.getColumnInfo(col);
					if (column) {
						column.type = col.type;
						$scope.component.columns.push(column);
					} else {
						$scope.addColumn({
							name : col.name,
							dataField : col.dataField,
							type : col.type
						});
					}

				}
			} else {
				if (!$scope.component.allColumns) {
					$scope.addColumn({
						name : columnName,
						dataField : dataField,
						type : columnType,
						origType : origType
					});
				}

			}
			$scope.updateKendoModel();
			$scope.$apply();

		};
		//!common!
		$scope.updateKendoModel = function() {
			var kendoFieldModel = {};
			var kendoCols = [];
			var columns = $scope.component.columns;
			var outerGridCols = $scope.component.columns.filter(function(column) { return !column.hideFromOuterGrid && column.hidden !== true; });
			kendoFieldModel["fields"] = {};
			angular.forEach(columns, function(col, idx) {
				if(idx === 0)
					$scope.rowIndex ++;
				var colModel = {};

				var dataType = col.type;
				var colName = col.dataField;
				var columnIndex = idx;
				var isHidden = col.hidden;
				if (typeof col.minCount == 'undefined') {
					col.minCount = 1;
				}
				colModel[col.dataField] = getKendoColDataType(dataType);
				$.extend(true, kendoFieldModel["fields"], colModel);

				// kendo columns
				var column = {};
				column.field = col.dataField;
				column.title = col.displayName;
				column.encoded = true;
				column.hidden = false;
				column.hideFromInnerGrid = col.hideFromInnerGrid;			
				column.hideFromOuterGrid = col.hideFromOuterGrid;
				if(col.width) {
					column.width = col.width;
				}
				column.groupHeaderTemplate = function(row) {
					var field = row.field;
					var value = row.value;
					var valueFormatted = value;
					var count = row["count"];
					var originalValue = value;
					var originalField = field;
					const rowData = {};
					const mappedValue = !$.isEmptyObject(row.aggregates) ? row.aggregates.mappedValue : row.mappedValue;
					$scope.component.groupMeasures.forEach(col => rowData[col.column] = row.aggregates[col.column][col.aggrType.toLowerCase()]);
                    rowData[field] = value;               
					var cellExpression = col.cellExpression || $scope.component.allCellExpression;
					if (cellExpression) {
						valueFormatted = $scope.getFormattedValue(value, cellExpression, col, undefined, rowData);
					}
					if ($scope.respData && !$.isEmptyObject($scope.respData)) { // to get mapped value
						const respVal = $scope.respData[originalField + '_' + originalValue + '_' +mappedValue];
						field = respVal ? respVal.field : "";
						value = respVal ? respVal.value : "";
					}										
					var header = "<span class='groupItem' data-uid='"+row.uid+"' title='"+valueFormatted+"' data-group='" + field + "' data-group-value='" + value +
					                            "'>" + valueFormatted + "<span class='groupAggregateItem'> (" + row["count"] +
					                            ")</span></span></td>";
                    //insert <td> for each column in the outer table. If aggregation applied, show the formatted value
                    //Since the template is rendered inside a <td></td> tag, not adding an openning <td> tag in the beginning and a closing </td> tag at the end                    
                    angular.forEach(outerGridCols, function(eachCol, i) {
                        if (eachCol.dataField !== originalField) {
                            header += "<td>";
                            angular.forEach($scope.component.groupMeasures, function(measure, j) {
                                if (measure.column === eachCol.dataField) {
                                    var aggVal = row.aggregates[eachCol.dataField][measure.aggrType.toLowerCase()];
                                    var innerCellExp = eachCol.cellExpression || $scope.component.allCellExpression;
                                    if (innerCellExp) {
										aggVal = $scope.getFormattedValue(aggVal, innerCellExp, eachCol, undefined, rowData);
                                    }
                                    header += aggVal;
                                    return;
					}
				});
                            if (i !== outerGridCols.length - 1) {
                                header += "</td>";
                            }
                        }
                    });                    
                    return header;
				}

				column.groupFooterTemplate = "";



				column.template = function(row) {
					var cellData = row[colName] ? row[colName] : null;
					var cellExpression = col.cellExpression || $scope.component.allCellExpression;
					var splitByChar = col.splitByCharacter || null;					
					if(!$scope.prevRowUID)
						$scope.prevRowUID = row.uid;
					if (cellExpression && cellData) {
						cellData = $scope.getFormattedValue(cellData, cellExpression, col,$scope.rowIndex, row);						
					}
					//below code is to calculate row index for first column of the table and we can use same row index for rest of the columns
					if(row.uid !== $scope.prevRowUID) {
						$scope.prevRowUID = undefined;
						$scope.rowIndex++;
					}
					
					if (col.hasOwnProperty("splitByCharacter") && col.splitByCharacter != "") {
						if (cellData != null && splitByChar != null) {
							if (cellData.indexOf(splitByChar) != -1) {
								cellData = cellData.split(col.splitByCharacter).join("<br/>");
							}
						}
					}
					row[colName] = cellData ? cellData : cvSearchMessages.NotAvailable;
					return `<span title="${row[colName]}">${row[colName]}</span>`;
				}

				if (isHidden) {
					column.hidden = true;
				}
				kendoCols.push(column);

			});
			$scope.kendoColumns = [];
			$scope.kendoColumns = kendoCols;
			kendoGridModel = kendo.data.Model.define(kendoFieldModel);

			function getKendoColDataType(datatype) {
				var kendoDataType = {};
				kendoDataType["nullable"] = false;
				switch (datatype.toLowerCase()) {
				case "integer":
				case "float":
				case "double":
				case "tdouble":
				case "long":
				case "tlong":
					kendoDataType["type"] = "number";
					break;
				default:
					kendoDataType["type"] = "string";
					break;
				}
				return kendoDataType;
			}

		};

		$scope.getAggregateText = function(aggrType) {
			var text = "";
			switch (aggrType) {
			case "countdistinct":
				text = "CountDistinct";
				break;
			case "min":
				text = "Min";
				break;
			case "max":
				text = "Max";
				break;
			case "count":
				text = "Count";
				break;
			case "sum":
				text = "Sum";
				break;
			default:
				break;
			}
			return text;
		};
		//!common!
		$scope.getFormattedCellValue = function(rowData, kendoCol, aggrType, text) {
			var footerText = "";
			var aggregate = aggrType.toLowerCase();
			if (!rowData) {
				return "";
			}
			if (aggregate != "count" && aggregate != "countdistinct") {
				for (var i = 0; i < $scope.component.columns.length; i++) {
					var col = $scope.component.columns[i];
					var colName = col.id;
					if (colName === kendoCol.field && rowData[colName]) {						
						var cellExpression = col.cellExpression || $scope.component.allCellExpression;
						var cellData = rowData[colName][aggregate];
						var columnIndex = i;
						if (cellExpression) {
							rowData[colName][aggrType.toLowerCase()] = $scope.getFormattedValue(cellData,
									cellExpression,col);
						}

						break;
					}
				}
			}
			if (rowData[kendoCol.field] && rowData[kendoCol.field].hasOwnProperty(aggregate)) {
				footerText = "<span class='groupItem'>" + rowData[kendoCol.field][aggregate] + "</span>";
			}

			return footerText;

		};

		//!common!
		$scope.$watchCollection('kendoColumns', function() {
			if (!$scope.componentLoaded || $scope.processing) {
				return;
			}
			$scope.createKendoGrid();

		}, true);

		//!common!
		$scope.registerLocalCallBack = function(name, callback, sourceId) {
			if ($scope.reportMode !== 'preview') {
				customReportSvc.registerCallback(name, callback, sourceId);
			}
		};
		//making a copy of original definition from the table component.
		$scope.colsCopy = angular.copy($scope.component.columns);
		//!common!
		$scope.registerLocalCallBack("reInitializeTable", function(comp) {
			if ($scope.component.id === comp) {
				if ($scope.component.allColumns) {
					$scope.colsCopy = angular.copy($scope.$parent.dataSet.fields);
					$scope.component.columns = $scope.$parent.dataSet.fields;
				} else {
					$scope.component.columns = angular.copy($scope.colsCopy);
				}
				$scope.updateKendoModel();
			}
		});
		$scope.registerLocalCallBack("redrawAllComponents", function(componentId, isAutoRefresh) {
			if (!$scope.componentLoaded || $scope.processing || (componentId === $scope.component.id)) {
				return;
			}
			$scope.kendoGrid.dataSource.read({isAutoRefresh});
		});
		//!common!
		$scope.registerLocalCallBack("refreshDatagrid", function(name) {
			if ($scope.component.id === name) {
				$scope.updateKendoModel();
			}

		});
		$scope.registerLocalCallBack("refreshComponent", function(componentId) {
			if ($scope.component.id === componentId) {
				$scope.updateKendoModel();
			}
		});
		//!common!
		$scope.registerLocalCallBack("refreshTableData", function(name) {
			if ($scope.component.id === name) {
				$scope.kendoGrid.dataSource.read();
			}
		});
		//!common!
		$scope.registerLocalCallBack("hiddenColumn", function(index) {
			$scope.updateKendoModel();
		});
		//!common!
		$scope.registerLocalCallBack("columnRemoved", function(col) {
			if ($scope.component.id === col.componentId) {
				col.componentId = undefined;

				var columnIndex = $scope.getColumnIndexByID(col.id);
				console.log("columnRemoved ", $scope.component.columns.length);
				if ($scope.component.allColumns) {
					col.hidden = true;
				} else {
					$scope.component.columns.splice(columnIndex, 1);
				}
				if ($scope.component.columns.length == 0) {
					$scope.component.dataSet = undefined;
					$("#Kendo_" + $scope.component.id).empty();
				}
				$scope.setActiveComponent($scope.component);
				$scope.updateKendoModel();
			}
		});
		//!common!
		$scope.addColumn = function(colObj) {
			var column = $scope.getBasicColumnDef(colObj);
			$scope.component.columns.push(column);
			return column;
		};
		//!common!
		$scope.getBasicColumnDef = function(col) {
			var column = {
				dataField : col.name,
				displayName : col.name,
				id : $scope.generateColumnId(col.dataField),
				type : col.type,
				origType : col.hasOwnProperty("origType") ? col.origType : "",
				visible : true,
				hidden : false,
				aggrType : 'None',
				componentId : $scope.component.id,
				minCount : 1
			};
			if ($scope.reportMode === "preview" && $scope.component.columns.length > 9) {
				column.visible = false;
			}
			$scope.columnDefinitionById[column.id] = column;
			return column;
		};
		//!common!
		$scope.generateColumnId = function(dataField) {
			var id = dataField.replace(/\s/g, "");
			var orginalId = dataField.replace(/\s/g, "");
			var i = 1;
			while (id in $scope.columnDefinitionById) {
				id = orginalId + i;
				i++;
			}
			return id;
		};
		//!common!
		$scope.getColumnIndexByID = function(colId) {
			for (var i = 0; i < $scope.component.columns.length; i++) {
				if (colId.toLowerCase() == $scope.component.columns[i].id.toLowerCase()) {
					return i;
				}
			}
		};
		$scope.getColumnInfo = function(col) {
			var retCol;
			for (var k = 0; k < $scope.colsCopy.length; k++) {
				if ($scope.colsCopy[k].id.toLowerCase() === col.name.toLowerCase() ||
						$scope.colsCopy[k].dataField.toLowerCase() === col.dataField.toLowerCase()) {
					retCol = $scope.colsCopy[k];
					break;
				}
			}
			return retCol;
		};
		//!common!
		$scope.isNumericCol = function(columnName) {
			var isNumeric = false;
			for (var i = 0; i < $scope.component.columns.length; i++) {
				var col = $scope.component.columns[i];
				var colName = col.dataField;
				var dataType = col.type;
				if (colName == columnName && dataType.toLowerCase() != "string" &&
						dataType.toLowerCase() != "timestamp") {
					isNumeric = true;
					break;
				}
			}
			return isNumeric;
		};
		$scope.isDateCol = function(columnName) {

			var isDateCol = false;
			for (var i = 0; i < $scope.component.columns.length; i++) {
				var col = $scope.component.columns[i];
				var colName = col.dataField;
				var dataType = col.type;
				if (colName == columnName &&
						(dataType.toLowerCase() === "date" || dataType.toLowerCase() === "roundSecondsDate" ||
								dataType.toLowerCase() === "secondsDate" || dataType.toLowerCase() === "tdate" || dataType
								.toLowerCase() === "epoch")) {
					isDateCol = true;
					break;
				}
			}
			return isDateCol;
		};
		//!common!
		$scope.registerLocalCallBack("refreshTableData", function(name) {
			if ($scope.component.id === name) {
				$scope.kendoGrid.refresh();
			}
		});
		$scope.init = function() {
			$scope.isDcubeEnabledInCustomReports = isDcubeEnabledInCustomReports;
			if ($scope.dataSet && $scope.dataSet.dataSet) {
				var dataSetName = $scope.dataSet.dataSet.dataSetName;
				$scope.tempComponent.dataGridFilter = {'logic': 'and','filters': []};				
				var columns = [];
				angular.forEach($scope.component.columns, function(column, index) {
					columns.push(column.dataField);
				});				
				angular.forEach($scope.page.body.filters['viewer'][dataSetName], function(filterObj, filterParam) {
					if (columns.indexOf(filterParam)!=-1 && filterObj.tableFilters && !$.isEmptyObject(filterObj.tableFilters)) {
						// $scope.tempComponent.dataGridFilter[filterParam] = filterObj.tableFilters;
						$scope.tempComponent.dataGridFilter.filters = $scope.tempComponent.dataGridFilter.filters.concat(filterObj.tableFilters);
					}					
				});
			}
			$scope.updateKendoModel();
			$scope.createKendoGrid();
			$('body').off('click').on('click', "li[comp=" + $scope.component.id + "] .k-group-indicator a.k-link", function() {
				$scope.kendoGrid.dataSource.sort({});
			});
		};

		$scope.init();

		$scope.component.exportDataTableToCSV = function() {
			let searchParams = customReportSvc.getDeepCopy(JSON.parse($scope.tempComponent.latestSearchParams).searchParams);
			const dateCol = $scope.component.columns.filter(col => {
				return !$.isEmptyObject(col.cellExpression) && col.cellExpression.type === "date";
			});
			if(dateCol.length > 0) {
				const cellExpression = dateCol[0].cellExpression;
				const date = $scope.dataservice.getDateFormatAndTimeZone(cellExpression);			
				searchParams.push(date.format);
				searchParams.push(date.timeZone);
			}
			
			if($scope.component.exportFilterQuery) {
				//if export filter query is given then remove data grid's component level custom filter. 
				//This property can be used when user wants to have different filter query for report table and export data
				searchParams.forEach(param => {
					if(param.key === "fq" && param.value === $scope.component.outerGridFilterQuery)
						param.value = $scope.component.exportFilterQuery
				});
			}

			if($scope.component.exportColumns) {
				searchParams = searchParams.filter(col => col.key !== "fl");
				const exportCols = $scope.component.exportColumns.split(",");
				exportCols.forEach(col => {
					searchParams.push({
						key : "fl",
						value: col
					});
				});	
				
			}

			var tempObj = {};
			tempObj["searchParams"] = searchParams;
			$scope.exportToCSVDatacube(tempObj);
		}
	}

})();
