<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title='<fmt:message key="CustomReport.OverrideInputs"/>' data-ng-class="{'sub-header-active': selectedPropertyCategory==='inputs'}" data-ng-click="selectedPropertyCategory='inputs'">
        <span class="ico ico-form-field"></span>
    </li>
</ul>


<div data-ng-show="selectedPropertyCategory==='general'">
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm" type="text"
                     placeholder="Frame name"
                     data-ng-model="propData.title.text">
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   type="text"
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
                   data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">
                  <span class="inline-validation-error" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>  <!-- localize -->
                </div>
            </div>
        </div>
    </div>

    <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideHeader"/>'><fmt:message key="CustomReport.Properties.HideHeader"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideHeader" id="hideheader">
                </div>
            </div>
    </div>

    <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='URL'>URL</label>
                <div class="col-sm-8 noLftRghtPadding">
                        <input class="form-control input-sm" placeholder="Frame name" type="text" data-ng-model="propData.url">
                </div>
            </div>
    </div>
    <div class="col-xs-12">
         <div class="form-group">
             <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideInputs"/>'><fmt:message key="CustomReport.Properties.HideInputs"/></label>
             <div class="col-sm-3 noLftRghtPadding">
                     <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideInputs" id="hideInputs">
             </div>
         </div>
    </div>
	<entity-security data-item="propData"></entity-security>
	</div>

	<div data-ng-show="selectedPropertyCategory==='inputs'">
		<div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['inputs']=!collapsed['inputs']" data-ng-init="collapsed['inputs']=true">
		     <div class="col-xs-12 noLftRghtPadding">
		         <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['inputs'], 'ico-chevron-right':collapsed['inputs']}" style="margin-right:5px"></span>
		         <span><fmt:message key="CustomReport.OverrideInputs"/></span> <!-- TODO: localize -->
		     </div>
	   </div>
	   <div data-ng-class="{'collapsed': collapsed['inputs']}">
  			 <div class="row ng-scope noLftRghtMargin">
		       <div class="col-xs-12">
		  			<select data-ng-model="inputId" data-ng-options="input as input.displayName for input in reportInputs" class="col-lg-10 noLftRghtPadding" style="margin-right: 5px;"></select>
		      		<span class="ico ico-plus-circle pro-dlt-btn" data-ng-click="addInputsToFrameComponent(inputId)"> </span>
				</div>
			</div>
			<div  class="col-xs-12 frame-inputs" style="margin-right: 0" data-ng-repeat="input in propData.inputs">
				<label class="col-xs-12 col-lg-4 noLftRghtPadding" title="{{input.id}}">{{input.id}}</label>
				<div class="col-xs-12 col-lg-8 noLftRghtPadding input-group">
					<input type="text" class="form-control" data-ng-model="input.value" aria-describedby="basic-addon1"></input>
					<span data-ng-hide="isTable" class="input-group-addon" id="basic-addon1" ng-click="showInsertVariable(input)">f(x)</span>
					<span class="ico ico-trash2 pro-dlt-btn" data-ng-click="propData.inputs.splice($index,1)"> </span>
				</div>
			</div>
	   </div>
	</div>


</div>

</fmt:bundle>