(function() {
	'use strict';

	var reports = angular.module("reports");
	reports.directive("cvFrame", function() {
		return {
			restrict : 'AE',
			templateUrl : customReports.contextPath + '/reportsplus/components/frame/frame.jsp',
			controller : 'frameCtrl'

		};
	});

	reports.controller('autoRefreshCtrl', [
			"$scope",
			"reportService",
			"customReportSvc",
			"component",
			function($scope, reportService, customReportSvc, component) {
				$scope.autoRefresh = component.autoRefresh || {
					refreshEnabled : false,
					refreshEvery : 60
				};

				$scope.updateAndClose = function() {
					$scope.$close($scope.autoRefresh);
				}
			} ]);

	reports.controller('frameModalCtrl', [
			"$scope",
			"reportService",
			"customReportSvc",
			"component",
			function($scope, reportService, customReportSvc, component) {
				$scope.reportsDefinitions = {};
				$scope.frameTypes = [ "Report", "Custom" ];
				$scope.reportsList = [];
				$scope.pageList = [];
				$scope.pageDefinitions = [];
				$scope.componentsList = [];
				$scope.url = component.url;
				$scope.frameType = component.frameType;
				$scope.titleText = component.title.text;

				if ($scope.url) {
					var params = customReportSvc.getUrlParams($scope.url)
					$scope.reportId = params['reportId'];
					$scope.pageName = params['pageName'];
					$scope.componentId = params['showComponents'];
				}

				reportService.getReportsList().then(function(data) {
					$scope.reportsList = data.data.reports;
					if ($scope.reportId) {
						$scope.getReportDefintions($scope.reportId);
					}
				});

				$scope.getReportDefintions = function(reportId) {
					if (!$scope.reportsDefinitions[reportId]) {
						var params = {
							reportId : reportId,
							reportName : "",
							isTileReport : false,
							includeDrafts : false
						}

						reportService.getCustomReport(params).then(function(data) {
							$scope.reportsDefinitions[reportId] = data.data;
							$scope.updatePageList(data.data);

						});

					}
				}

				$scope.updatePageList = function(report) {
					var defaultPageId;
					$scope.pageList = [];
					for (var i = 0; i < report.pages.length; i++) {
						var page = report.pages[i];
						if (page.pageName) {
							$scope.pageList.push({
								value : page.pageName,
								label : page.pageTitle.text
							});
							$scope.pageDefinitions[report.pages[i].pageName] = page;
							if (page.isDefault) {
								defaultPageId = report.pages[i].pageName;
							}
						} else {
							defaultPageId = "Page0";
							$scope.pageDefinitions[defaultPageId] = page;
						}
					}
					$scope.updateComponents(defaultPageId);
				}

				$scope.updateComponents = function(pageId) {
					var page = $scope.pageDefinitions[pageId];
					$scope.componentsList = [];
					var body = JSON.parse(page.body);
					for (var i = 0; i < body.reportComponents.length; i++) {
						var comp = body.reportComponents[i];
						$scope.componentsList.push({
							value : comp.id,
							label : comp.title.text ? comp.title.text : comp.id
						});
					}
				}

				$scope.updateUrlAndClose = function() {
					var url;
					if ($scope.frameType === 'Report') {
						if ($scope.reportId) {
							component.url = "reportId=" + $scope.reportId;
							if ($scope.pageName) {
								component.url = component.url + "&pageName=" + $scope.pageName;
							}

							if ($scope.componentId) {
								component.url = component.url + "&showComponents=" + $scope.componentId;
							}

						}
					} else {
						component.url = $scope.url;
					}
					component.frameType = $scope.frameType;
					component.title.text = $scope.titleText;
					$scope.reportId = undefined;
					$scope.pageName = undefined;
					$scope.componentId = undefined;
					$scope.frameType = undefined;
					$scope.titleText = undefined;
					$scope.$close(component);
				}

			} ]);

	reports.controller('frameCtrl', [
			"$scope",
			"reportService",
			"$uibModal",
			"customReportSvc",
			function($scope, reportService, $uibModal, customReportSvc) {
				$scope.action;
				$scope.autoRefreshInterval;
				$scope.url = "";
				$scope.detailUrl = "";
				$scope.openFrameModal = function() {
					var modalInstance = $uibModal.open({
						templateUrl : customReports.contextPath + "/reportsplus/components/frame/frameModal.jsp",
						controller : 'frameModalCtrl',
						resolve : {
							component : function() {
								return $scope.component;
							}
						}
					});

					modalInstance.result.then(function(component) {
						if (component) {
							$scope.component = component;
							$scope.updateUrl();
							if ($scope.action === 'NEW') {
								$scope.reportComponents.push($scope.component);
								$scope.setActiveComponent($scope.component);
								$scope.calculateAndpdateLayout();
							}
							$scope.saveDashboard($scope.customReport, true);
						}
					});

				}

				$scope.calculateAndpdateLayout = function() {
					var position = $scope.calculateItemPosition();
					var compLayout = {
						"mobile" : {
							"size" : {
								"x" : 4,
								"y" : 8
							},
							"position" : [ position, 0 ]
						},
						"tablet" : {
							"size" : {
								"x" : 4,
								"y" : 8
							},
							"position" : [ position, 0 ]
						},
						"desktop" : {
							"size" : {
								"x" : 4,
								"y" : 8
							},
							"position" : [ position, 0 ]
						}
					}
					$scope.reportLayout[$scope.component.id] = compLayout;
				}

				$scope.setAutoRefreshTimer = function(isReset) {
					if (isReset && $scope.autoRefreshInterval) {
						clearInterval($scope.autoRefreshInterval);
					}

					setTimeout(function() {
						$scope.autoRefreshInterval = setInterval(function() {
							$scope.reloadComponent(true);
						}, $scope.component.autoRefresh.refreshEvery * 1000);
					}, 400);
				}

				/*
				 * $scope.getReportComponents = function(reportId, reportName) { var params = { reportId :
				 * reportId, includeDrafts : $scope.includeDrafts, reportName : reportName, isTileReport :
				 * false, includeDrafts : false }
				 * 
				 * reportService.getCustomReport(params).then(function(data) { return
				 * JSON.parse(data.pages[0].body).reportComponents; }); }
				 */

				$scope.convertV1Url = function(source) {
					var newUrl = window.location.protocol + "//" + window.location.host + cvUtil.getContextPath() +
							'/reportsplus/reportInclude.jsp';
					var reportName = cvUtil.getParameterByName('reportName', source, '');
					if (reportName == '') {
						reportName = cvUtil.getParameterByName('name', source, '');
					}
					var format = cvUtil.getParameterByName('format', source, '');
					var reportId = cvUtil.getParameterByName('reportId', source, '');
					//var reportComponents = $scope.getReportComponents(reportId, reportName);
					newUrl = newUrl + "?reportName=" + window.encodeURI(reportName) + "&reportId=" + reportId +
							"&format=" + format;
					return newUrl;
				}

				var generateCacheKey = function() {
					return "ReportsCache" + SESSION_ID + $scope.reportId + "reportName" + $scope.reportName;
				}

				$scope.computeInputs = function(){
					let url = "";
					for(var input of $scope.component.inputs){
						let value = "";
						if(input.value){
							var args = {};
			                args["expression"] = input.value;
			                args["input"] = rpt.input;
			                let retVal = rpt.evalExpression(args);
			                url=url+"&input."+input.id+"="+retVal;
						}
					}
					return url;
				}

				$scope.updateUrl = function() {
					let inputUrl = "";
					if($scope.component.inputs && $scope.component.inputs.length > 0){
						inputUrl = $scope.computeInputs();
					}
					if ($scope.component.url.indexOf("reportInclude.jsp?") !== -1) {
						$scope.component.frameType = "Report";
						$scope.component.url = $scope.component.url.substring($scope.component.url.indexOf("?") + 1);
					} else if ($scope.component.url.indexOf('customreports') != -1) {
						//$scope.component.url = $scope.convertV1Url($scope.component.url);
					}

					if ($scope.component.frameType === "Report" && $scope.component.url) {
						$scope.url = location.origin + customReports.contextPath+"/reportsplus/reportInclude.jsp?" +
								$scope.component.url + "&isDashboard=true&cacheKey=" + generateCacheKey();
						if($scope.component.url.indexOf("showComponents") !== -1 ){
							let params = $scope.component.url.split('&');
							params = params.filter(item => !item.startsWith("showComponents"));
							$scope.detailUrl = location.origin + customReports.contextPath+"/reportsplus/reportViewer.jsp?"+params.join("&");
						}else{
							$scope.detailUrl = location.origin + customReports.contextPath+"/reportsplus/reportViewer.jsp?" + $scope.component.url;
						}

						if(inputUrl){
							$scope.url = $scope.url+inputUrl;
							if($scope.component.hideInputs){
								$scope.url =$scope.url+"&hideReportSummary=true";
							}
							$scope.detailUrl = $scope.detailUrl+inputUrl;
						}

					} else {
						$scope.url = $scope.component.url;
						$scope.detailUrl = $scope.component.url;
					}

					if($scope.component.inputs && $scope.component.inputs.length > 0){
						$scope.component.inputs.map(input => console.log(input.id));
					}

					if ($scope.component.autoRefresh && $scope.component.autoRefresh.refreshEnabled) {
						$scope.setAutoRefreshTimer();
					}
				}

				$scope.reloadComponent = function(refreshCache) {
					$scope.clearReportCache($scope.reportId);
					$scope.updateUrl();
					document.getElementById("frame-" + $scope.component.id).src = $scope.url;
				}

				$scope.setAutoRefresh = function() {
					var autoRefreshmodalInstance = $uibModal.open({
						templateUrl : customReports.contextPath + "/reportsplus/components/frame/autoRefresh.jsp",
						controller : 'autoRefreshCtrl',
						resolve : {
							component : function() {
								return $scope.component;
							}
						}
					});

					autoRefreshmodalInstance.result.then(function(autoRefresh) {
						if (autoRefresh) {
							$scope.component.autoRefresh = autoRefresh;
							$scope.setAutoRefreshTimer()
						}
					});
				}

				if ($scope.component) {
					$scope.setChildScope($scope);
					$scope.updateUrl();
					customReportSvc.registerCallback("redrawAllComponents", function(data) {
						$scope.reloadComponent();
					}, $scope.component.id);
				}

				$scope.addTileToDashboard = function() {
					$scope.action = 'NEW';
					$scope.component = {
						type : "IFRAME",
						frameType : "Report",
						url : "",
						id : "Frame_" + (new Date()).getTime(),
						title : {
							text : ""
						}
					};
					$scope.openFrameModal();
				}

				if (!customReports.eventAdded) {
					angular.element("#addNewReport").bind("click", function(evt) {
						$scope.addTileToDashboard();
					});
					customReports.eventAdded = true;
				}

			} ]);

})();