<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
        <span class="ico ico-form-field"></span>
    </li>
</ul>

<!-- Begin "General" group -->
<div data-ng-show="selectedPropertyCategory==='general'"> 
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                       data-ng-model="propData.title.text"
                       type="text"
                       placeholder="<fmt:message key="CustomReport.Properties.ChartName"/>">
                </div>
            </div>                  
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input name="chartid" class="form-control input-sm"
                   type="text"                   
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">                
                </div>
                <span class="inline-validation-error col-lg-12 noLftRghtPadding ng-hide" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>
            </div> 
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message key="CustomReport.Properties.DataSet"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   type="text"
                   placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>"
                   readonly="true"
                   data-ng-model="propData.dataSet.dataSetName">
                </div>
            </div> 
        </div>
    </div>    


<!-- Begin "Relative" group -->
  <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['relative']=!collapsed['relative']">
       <div class="col-xs-12 noLftRghtPadding">
           <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['relative'], 'ico-chevron-right':collapsed['relative']}" style="margin-right:5px"></span>
           <span>Relative <!-- TODO: localize --></span>
           <span class="pull-right ico ico-plus-circle" title="Add Custom Range" data-ng-click="collapsed['relative']=true;propData.relativeTimes.push({'label': '', 'value': ''})"></span>
       </div>
   </div>
   <div class="row noLftRghtMargin" data-ng-class="{collapsed:collapsed['relative']}">
       <div data-ng-class="{'collapsed': collapsed['relative']}">
          <div class="row ng-scope noLftRghtMargin" data-ng-repeat="relative in propData.relativeTimes">
          <div class="col-xs-7" style="padding-right: 0px;margin-right: 3px;">
            <input type="text" data-ng-model="relative.label" data-ng-blur="validateRelativeTime()"></input>
          </div>
          <div class="col-xs-3 noLftRghtPadding" style="margin-right: 3px">
            <input type="text" data-ng-model="relative.value" data-ng-blur="validateRelativeTime()" data-ng-pattern="/[mhdMy]$/"></input>
          </div>                 
          <div class="col-xs-1 noLftRghtPadding">
            <span class="ico ico-trash2 pro-dlt-btn" data-ng-click="propData.relativeTimes.splice($index,1);validateRelativeTime()"> </span>
          </div>
      </div>
    </div>
    <!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                        data-ng-model="propData.mobile.visible">
                        <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                        <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
	<entity-security data-item="propData"></entity-security>
      <!-- <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 relative-time">
        <input class="form-control input-sm"
                 data-ng-model="propData.relativeTimes"
                   type="text"
                   placeholder="Comma separated relative time" data-ng-blur="validateRelativeTime()">
        <span style="color:#a6b8c8;">* m - minutes, h - hours, d - days, M - months, y - years</span>  
      </div>
    </div> -->
</div>
<!-- End "Relative" group -->

</div>
<div data-ng-show="selectedPropertyCategory==='fields'">
    <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel" data-ng-show="propData.dateRangeField">
        <div class="fieldHeader"  data-ng-click="collapsed['dimension'+$index]=!collapsed['dimension'+$index]">
            <label class="col-lg-9 noLftRghtPadding">
               <span>{{propData.dateRangeField}}</span>                       
            </label>
              <span class="pull-right">                  
                  <span class="ico inner-panel-expand-icon ico-trash2" title="Remove Dimension" data-ng-click="propData.dateRangeField = ''"></span>
              </span>
        </div>
</div>

<!-- <a id="resetButton" class="mainBtn" data-ng-click="resetDefault()">
    <fmt:message key="CustomReport.Properties.ResetToDefault"/>
</a> -->

</fmt:bundle>