<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.ReportsPlusMessages">
	<div class="modal-header">
			<h3 class="modal-title">Test criteria</h3>
	</div>

	<div class="col-sm-12 padding-top-30" data-ng-if="isLoading()">
		<img src="/adminconsole/common/img/ajax-loader.gif" class="test-criteria-loading-icon" style="">
	</div>
	<div class="col-sm-12 padding-top-30 error" data-ng-if="error">
				{{error}}
	</div>

	<div class="row padding-bottom-30">

		<div class="col-sm-12" data-ng-if="data">
			<div class="table-responsive-test-criteria padding-left-10 padding-top-10 padding-right-10" data-ng-if="data.data.length > 0">
				<table class="table table-hover">
					<thead>
						<tr>
							<th data-ng-repeat="col in data.columns track by $index"> {{col}} </th>
						</tr>
					</thead>
					<tbody>
						<tr data-ng-repeat="row in data.data track by $index">
							<td data-ng-repeat="rowData in row track by $index"> {{rowData}} </td>
						</tr>
					</tbody>
				</table>
			</div>
			<div data-ng-if="data.data.length == 0" class="modal-wrapper margin-top-20 margin-left-20">
				<fmt:message key="noDataForTestCriteria" />
			</div>
			<div data-ng-if="metaText" class="float-right margin-top-20 margin-right-10 modal-wrapper">
				{{metaText}}
			</div>
		</div>

	</div>

	<span id="{{testCriteriaId}}"></span> <!-- Holder to load the report iframe -->

	<div class="modal-footer">
		<div class="button-container">
				<button type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="cancel()"><fmt:message key="CustomReport.Ok" /></label></button>
		</div>
	</div>
</fmt:bundle>