<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<fmt:bundle basename="localization.ReportsPlusMessages">
	<form class="form-horizontal">

		<div class="form-group" data-ng-hide="dataSet.endpoint === 'DATACUBE'">
			<div>
				<label class="control-label col-md-2" for="dataSetName"><fmt:message
						key="DataSet.Preview.DataSetName" /></label>
				<div class="col-md-10">
					<input type="text" class="form-control" id="dataSetName"
						placeholder="Name" data-ng-blur="dataSetNameChanged(dataSet)"
						data-ng-init="dataSet.dataSet.originalDataSetName = dataSet.dataSet.dataSetName"
						data-ng-model="dataSet.dataSet.dataSetName" required>
				</div>
			</div>
		</div>
		<div class="form-group" data-ng-if="dataSet.endpoint !== 'DATACUBE' && sharedMode">
			<div>
				<label class="control-label col-md-2"><fmt:message key="CustomReport.Properties.Description"/></label>
				<div class="col-md-10">
					<textarea class="form-control" rows="1"
						data-ng-model="dataSet.description"></textarea>
				</div>
			</div>
		</div>

		<div data-ng-show="dataSet.endpoint === 'MONITORING_POLICY'">

			<div class="form-group">
				<label class="control-label col-md-2" for="dataSourceType"><fmt:message
						key="DataSet.Preview.DataSourceType" /></label>
				<div class="col-md-10">
					<select class="form-control" id="lmDataSourceSelect"
						data-ng-model="dataSet.selectedLMSourceType"
						data-ng-change="updateLMDataSets()"
						data-ng-options="sourcetype.dispName for sourcetype in lmDataSources track by sourcetype.type"
						required>
					</select>
				</div>
			</div>

			<div data-ng-if="dataSet.selectedLMSourceType.type === 'POLICY'">
				<div class="form-group">
					<div>
						<label class="control-label col-md-2" for="dataSourceType"><fmt:message
								key="DataSet.Preview.MonitoringPolicyNameLabel" /></label>
						<div class="col-md-10">
							<select class="form-control" id="policiesSelect"
								data-ng-model="policyInfo.selectedPolicy"
								data-ng-options="policy.monitoringPolicyName for policy in userPolicyList track by policy.monitoringPolicyid"
								data-ng-click="updateDropDownWithParameterizedPolicies()"
								required>
							</select>
						</div>
					</div>
				</div>
				
				<div data-ng-show="policyInfo.selectedPolicy && policyInfo.selectedPolicy.monitoringTypes && policyInfo.selectedPolicy.monitoringTypes[0] == 'GLOBAL_MONITORING'" data-ng-init="(!userTemplates || !userTemplates.length) && getUserTemplates()" class="form-group">
					<div>
						<label class="control-label col-md-2" for="dataSourceType"><fmt:message
								key="DataSet.Preview.LMTemplateLabel" /></label>
						<div class="col-md-10">
							<select style="height: 120px;" multiple class="form-control" id="templatesSelect"
								data-ng-model="policyInfo.selectedTemplates"
								data-ng-options="template as template for template in userTemplates">
							</select>
						</div>
					</div>
				</div>
			</div>

			<div
				data-ng-if="dataSet.selectedLMSourceType.type === 'SAVED_SEARCH'">
				<div class="form-group">
					<div>
						<label class="control-label col-md-2" for="dataSourceType"><fmt:message
								key="DataSet.Preview.SavedSearchNameLabel" /></label>
						<div class="col-md-10">
							<select class="form-control" id="savedSearchesSelect"
								data-ng-model="policyInfo.selectedSavedSearch"
								data-ng-options="search.searchName for search in userSavedSearches track by search.searchId"
								required>
							</select>
						</div>
					</div>
				</div>
			</div>

			<div
				data-ng-if="dataSet.selectedLMSourceType.type === 'QUERY' || dataSet.selectedLMSourceType.type === 'POLICY' ">
					<div class="form-group">
						<div>
						<label class="control-label col-md-2">Search Text</label>
						<div class="col-md-10">
						<input type="text" class="form-control" 
								data-ng-model="policyInfo.selectedSearchQuery.adHocQueryInfo.searchText"/>
						</div>
						</div>
					</div>
					<div class="form-group">
						<div>
						<label class="control-label col-md-2">Time Range</label>
						<div class="col-md-10">
							<input type="text" class="form-control" id="timeRange" data-ng-model="policyInfo.selectedSearchQuery.adHocQueryInfo.timeQuery"/>
						</div>
					</div>
					</div>
					
					<div class="form-group">
						<div>
							<label class="control-label col-md-2">Filter Queries</label>
							<div class="col-md-10">
								<textarea class="form-control" rows="10"
									data-ng-model="policyInfo.selectedSearchQuery.adHocQueryInfo.filterQuery"></textarea>
							</div>
						</div>
					</div>
					
					<div class="form-group">
						<div>
							<label class="control-label col-md-2">Exclude Queries</label>
							<div class="col-md-10">
								<textarea class="form-control" rows="10"
									data-ng-model="policyInfo.selectedSearchQuery.adHocQueryInfo.excludeFilterQuery"></textarea>
							</div>
						</div>
					</div>
					</div>
					
		</div>

		<div data-ng-show="dataSet.endpoint === 'R'">
		
			<div class="form-group">
				<label class="control-label col-md-2">Source Data Sets</label>
				
				<!-- extra-settings="dropdownSetting"
				<div ng-dropdown-multiselect="" ng-options="item as item.dataSet.dataSetName for item in dataSets " selected-model="CategoriesSelected" checkboxes="true">
					
				</div>
				 -->
				 <div class="col-md-10">
					<textarea type="text" class="form-control" rows="1" ng-readonly="true" ng-init="initRDataSets()" ng-model="rDataSets" placeholder="Click to add Data Sets" data-ng-click="showDataSet()"> 
						</textarea>
				</div>
			</div>
		
			<div class="form-group">
				<label class="control-label col-md-2">Data Set Query</label>
				<div class="col-md-10">
					<textarea class="form-control" rows="10"
						data-ng-model="dataSet.GetOperation.rDataSetQuery"
						data-ng-blur=""></textarea>
						
				</div>
			</div>
			
			<div class="form-group">
				<label class="control-label col-md-2">Plot Query</label>
				<div class="col-md-10">
					<textarea class="form-control" rows="7"
						data-ng-model="dataSet.GetOperation.rPlotQuery"
						data-ng-blur=""></textarea>
				</div>
			</div>
		</div>
        <div data-ng-show="dataSet.endpoint === 'PYTHON3'">

	        <div class="form-group">
	            <label class="control-label col-md-2">Source Data Sets</label>
	
			<!-- extra-settings="dropdownSetting"
			<div ng-dropdown-multiselect="" ng-options="item as item.dataSet.dataSetName for item in dataSets " selected-model="CategoriesSelected" checkboxes="true">
	
			</div>
			 -->

            <div class="col-md-10">
                <textarea type="text" class="form-control" rows="1" ng-readonly="true" ng-init="initRDataSets()" ng-model="rDataSets" placeholder="Click to add Data Sets" data-ng-click="showDataSet()">
				</textarea>
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-md-2">Data Set Query</label>
                <div class="col-md-10">
                    <textarea class="form-control" rows="10" data-ng-model="dataSet.GetOperation.rDataSetQuery" data-ng-blur=""></textarea>

                </div>
            </div>

            <!--<div class="form-group">
                <label class="control-label col-md-2">Plot Query1</label>
                <div class="col-md-10">
                    <textarea class="form-control" rows="7" data-ng-model="dataSet.GetOperation.rPlotQuery" data-ng-blur=""></textarea>
                </div>
            </div>-->
        </div>

		<div class="form-group"
			data-ng-if="dataSet.endpoint === 'DATABASE' || dataSet.endpoint === 'HTTP'">
			<label class="control-label col-md-2"><fmt:message
					key="DataSet.Preview.DataSources" /></label>
			<div class="col-md-10 ${applicationScope.cloudSurveyEnabled == 'true' && sessionScope.cloudSurveyAdminUser == 'false' ? 'button-disabled' : ''}">
				<!-- having two hierarchical selectors since the control is not angular-friendly -->
				<div data-ng-if="dataSet.endpoint === 'DATABASE'">
					<hierarchical-selector data="dataSourceNodes.DATABASE"
						defaultselection="selectedDataSourceNodes.DATABASE"
						multi-select="true"
						on-selection-changed="dataSourceChanged(items, 'DATABASE')" />
				</div>
				<div data-ng-if="dataSet.endpoint === 'HTTP'">
					<hierarchical-selector data="dataSourceNodes.HTTP"
						defaultselection="selectedDataSourceNodes.HTTP"
						multi-select="true"
						on-selection-changed="dataSourceChanged(items, 'HTTP')" />
				</div>
			</div>
		</div>
		<div data-ng-show="dataSet.endpoint === 'DATACUBE'">
			<div class="form-group">
				<label class="control-label col-md-2" for="dataSourceType"><fmt:message
						key="DataSet.Preview.DataSourceType" /></label>
				<div class="col-md-10">
					<select class="form-control" id="databasesSelect"
						data-ng-model="dataSet.dCubeDataSet.dsType"
						data-ng-change="updateDCubeDataSets(true)"
						data-ng-options="listOfDS[dsType] for dsType in dataSourceTypes track by dsType"></select>
				</div>
			</div>
			<div data-ng-if="dataSet.dCubeDataSet.dsType === 'federated'">
				<div class="form-group">
					<label class="control-label col-md-2" for="fsSelect"><fmt:message
							key="DataSet.Preview.FederatedSearch" /> ({{ dCubeDataSets.length }})</label>
					<div class="col-md-10">
						<select class="form-control" id="fsSelect"
							data-ng-change="onDataSetChange()"
							data-ng-model="dataSet.dCubeDataSet.dsId"
							data-ng-options="dataSet.dsId as dataSet.dsName for dataSet in dCubeDataSets | orderBy : 'dsName'"></select>
					</div>
				</div>
			</div>
			<div data-ng-if="dataSet.dCubeDataSet.dsType !== 'federated'">
				<div class="form-group">
					<label class="control-label col-md-2" for="dataSetsSelect"><fmt:message
							key="DataSet.Preview.DataSources" /> ({{ dCubeDataSets.length }})</label>
					<div class="col-md-10">
						<select class="form-control" id="dataSetsSelect"
							data-ng-change="onDataSetChange()"
							data-ng-model="dataSet.dCubeDataSet.dsId"
							data-ng-options="dataSet.dsId as dataSet.dsName for dataSet in dCubeDataSets | orderBy : 'dsName'"></select>
					</div>
				</div>
				<div class="form-group">
					<label class="control-label col-md-2" for="handlerSelect"><fmt:message
							key="DataSet.Preview.Handlers" /> ({{ dCubeDataSets.length > 0 ?
						dCubeDataSetsMap[dataSet.dCubeDataSet.dsId].handlers.length : 0
						}})</label>
					<div class="col-md-10">
						<select class="form-control" id="handlerSelect"
							data-ng-change="onHandlerChange()"
							data-ng-model="dataSet.dCubeDataSet.dsHandler"
							data-ng-options="handler.handlerName for handler in dCubeDataSetsMap[dataSet.dCubeDataSet.dsId].handlers | orderBy : 'handlerName'"></select>
					</div>
				</div>
			</div>
		</div>

		<%-- <div data-ng-show="dataSet.endpoint === 'DATASET' || dataSet.endpoint === 'SCRIPT'">
			<div class="form-group">
				<label class="control-label col-md-2" for="dataSetsSelect"><fmt:message
						key="DataSet.Preview.SourceDataSets" /></label>

				<div class="btn-group col-md-10" id="datasets-dropdown">					
					<div ng-dropdown-multiselect="" options="joinDataSets" selected-model="dataSet.dataSets" extra-settings="dataSetDropdownSettings"></div>					
				</div>
			</div>

		</div>	 --%>
		
		<div data-ng-if="dataSet.endpoint === 'SHARED'">
			<div class="form-group">
				<label class="control-label col-md-2" for="dataSourceType"><fmt:message
						key="CustomReport.DataSets" /></label>
				<div class="col-md-10">
					<select class="form-control" id="lmDataSourceSelect"
						data-ng-model="dataSet.sharedDS"										
						data-ng-options="ds.dataSetName for ds in sharedDsList track by ds.dataSetGuid" data-ng-change="updateDSparameters(dataSet.sharedDS)">
					</select>
				</div>
			</div>
		</div>			

		<div data-ng-if="dataSet.endpoint === 'DATABASE'">
			<div class="form-group">
				<label class="control-label col-md-2" for="databasesSelect"><fmt:message
						key="DataSet.Preview.Databases" /></label>

				<div class="btn-group col-md-10 ${applicationScope.cloudSurveyEnabled == 'true' && sessionScope.cloudSurveyAdminUser == 'false' ? 'button-disabled' : ''}">
					<button id="databases-dropdown" type="button"
						class="btn btn-default dbButton" data-toggle="dropdown"
						data-ng-click="updateDataBasesOnclick($event)">
						{{dataSet.databaseName}} <span class="caret"></span>
					</button>
					<ul class="dropdown-menu" role="menu">
						<!-- <li data-ng-repeat="db in databases" role="menuitem"><span data-ng-click="dataSet.databaseName = db">{{db}}</span></li> -->
						<li data-ng-repeat="db in databases"
							data-ng-class="{ active: dataSet.databaseName === db }"><a
							dropdown-toggle data-ng-click="changeDatabase(db)">{{db}}</a></li>
					</ul>
				</div>

			</div>

			<div class="form-group">
				<label class="control-label col-md-2"> <select
					class="dropdownLabel" data-ng-model="tablesOrViews">
						<option value="tables" data-ng-selected="tableOrView === 'tables'"><fmt:message
								key="DataSet.Preview.Tables" /></option>
						<option value="views" data-ng-selected="tableOrView === 'views'"><fmt:message
								key="DataSet.Preview.Views" /></option>
				</select>
				</label>

				<div class="btn-group col-md-10">
					<button id="tables-dropdown" type="button"
						class="btn btn-default dbButton" data-toggle="dropdown"
						data-ng-click="updateTablesAndViewOnclick($event)">
						{{selectedTableOrView}} <span class="caret"></span>
					</button>
					<ul class="dropdown-menu" role="menu">
						<!-- <li data-ng-repeat="db in databases" role="menuitem"><span data-ng-click="dataSet.databaseName = db">{{db}}</span></li> -->
						<li data-ng-repeat="data in tablesAndViews[tablesOrViews]"
							data-ng-class="{ active: selectedTableOrView === data }"><a
							dropdown-toggle data-ng-click="isQuerychanged(data)">{{data}}</a></li>
					</ul>
				</div>
			</div>
		</div>

		<div data-ng-show="dataSet.endpoint === 'DATABASE' || dataSet.endpoint === 'DATASET' || dataSet.endpoint === 'SCRIPT'">
			<div class="form-group">
				<div class="col-md-2">	
					<label id="queryLabel" class="control-label col-md-9 noLftRghtPadding"><fmt:message
							key="DataSet.Preview.Query" /></label>
					<button class="btn btn-primary btn-xs" title='<fmt:message
							key="CustomReport.properties.OpenInEditor" />' data-ng-click="openAceEditor(dataSet.GetOperation.sqlText,'sql',isQueryModified,'dataSet.GetOperation.sqlText')">
		           		 <span class="glyphicon glyphicon-new-window"></span> 
		        	</button>  
		        </div>	
				<div class="col-md-10">		
					<textarea class="form-control" rows="17"
                       data-ng-model="dataSet.GetOperation.sqlText"
                       data-ng-blur="isQueryModified()"></textarea>			                 	               
				</div>
			</div>
		</div>

		<div data-ng-show="dataSet.endpoint === 'HTTP'">

			<div data-ng-show="!unregisteredDataSourceSelected"
				class="form-group">
				<div class="col-md-offset-2 col-md-10">
					<div class="checkbox">
						<label><input type="checkbox"
							data-ng-model="dataSet.GetOperation.useHttps"> <fmt:message
								key="DataSet.Preview.UseHTTPS" /></label>
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="control-label col-md-2"><fmt:message
						key="DataSet.Preview.HTTPMETHOD" /></label>
				<div class="col-md-10">
					<div class="btn-group">
						<label class="btn btn-default"
							data-ng-class="{ active: dataSet.GetOperation.method === 'GET' }"
							data-ng-click="dataSet.GetOperation.method = 'GET'"><fmt:message
								key="DataSet.Preview.GET" /></label> <label class="btn btn-default"
							data-ng-class="{ active: dataSet.GetOperation.method === 'POST' }"
							data-ng-click="dataSet.GetOperation.method = 'POST'"><fmt:message
								key="DataSet.Preview.POST" /></label>
					</div>
				</div>
			</div>

			<div data-ng-show="!unregisteredDataSourceSelected"
				class="form-group">
				<label class="control-label col-md-2" for="restApi"><fmt:message
						key="DataSet.Preview.RESTAPI" /></label>
				<div class="col-md-10">
					<input type="text" class="form-control" id="restApi"
						placeholder="e.g. /v1/resources/"
						data-ng-model="dataSet.GetOperation.restApi">
				</div>
			</div>

			<div data-ng-show="unregisteredDataSourceSelected" class="form-group">
				<label class="control-label col-md-2" for="restApi"><fmt:message
						key="DataSet.Preview.RESTURL" /></label>
				<div class="col-md-10">
					<input type="text" class="form-control"
						placeholder="e.g. https://api.example.com/v1/resources/"
						data-ng-model="unregisteredDataSource.connectionURL">
				</div>
			</div>

			<div class="form-group">
				<label class="control-label col-md-2"><fmt:message
						key="DataSet.Preview.URLParameters" /></label>
				<div class="col-md-10">
					<table class="table table-hover table-condensed"
						data-ng-show="dataSet.GetOperation.urlParameters.length > 0">
						<tbody>
							<tr
								data-ng-repeat="urlParameter in dataSet.GetOperation.urlParameters">
								<td class="col-xs-4"><input class="form-control"
									type="text" placeholder="Key" data-ng-model="urlParameter.name" /></td>
								<td class="col-xs-7"><input class="form-control"
									type="text" placeholder="Value"
									data-ng-model="urlParameter.value" /></td>
								<td class="col-xs-1"><span
									class="sprite icon-minus-disabled v-middle"
									data-ng-click="removeUrlParameter($index)"></span></td>
							</tr>
						</tbody>
					</table>
					<div class="pull-left">
						<a class="btn btn-default" data-ng-click="addUrlParameter()"><span
							class="sprite icon-plus v-middle"></span>&nbsp;&nbsp;<fmt:message
								key="CustomReport.Add" /></a>
					</div>
				</div>
			</div>

			<div class="form-group"
				data-ng-show="dataSet.GetOperation.method === 'POST'">
				<label class="control-label col-md-2"><fmt:message
						key="DataSet.Preview.HTTPContent" /></label>
				<div class="col-md-10 control-group">
					<textarea class="form-control" rows="5"
						data-ng-model="dataSet.GetOperation.httpContent"></textarea>
				</div>
			</div>

			<div class="form-group"
				data-ng-show="dataSet.GetOperation.method === 'POST'">
				<label class="control-label col-md-2" for="dataSetEndpoint"><fmt:message
						key="DataSet.Preview.ContentType" /></label>
				<div class="col-md-10">
					<div class="btn-group">
						<label class="btn btn-default"
							data-ng-class="{ active: dataSet.GetOperation.httpContentType === 'application/xml; charset=UTF-8' }"
							data-ng-click="dataSet.GetOperation.httpContentType = 'application/xml; charset=UTF-8'"><fmt:message
								key="DataSet.Preview.XML" /></label> <label class="btn btn-default"
							data-ng-class="{ active: dataSet.GetOperation.httpContentType === 'application/json; charset=UTF-8' }"
							data-ng-click="dataSet.GetOperation.httpContentType = 'application/json; charset=UTF-8'"><fmt:message
								key="DataSet.Preview.JSON" /></label>
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="control-label col-md-2"><fmt:message
						key="DataSet.Preview.AcceptType" /></label>
				<div class="col-md-10">
					<div class="btn-group">
						<label class="btn btn-default"
							data-ng-class="{ active: dataSet.GetOperation.headers[0].value === 'application/xml' }"
							data-ng-click="dataSet.GetOperation.headers[0].value = 'application/xml'"><fmt:message
								key="DataSet.Preview.XML" /></label> <label class="btn btn-default"
							data-ng-class="{ active: dataSet.GetOperation.headers[0].value === 'application/json' }"
							data-ng-click="dataSet.GetOperation.headers[0].value = 'application/json'"><fmt:message
								key="DataSet.Preview.JSON" /></label>
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="control-label col-md-2"><fmt:message
						key="DataSet.Preview.Headers" /></label>
				<div class="col-md-10">
					<table class="table table-hover table-condensed"
						data-ng-show="dataSet.GetOperation.headers.length > 1">
						<tbody>
							<tr
								data-ng-repeat="header in dataSet.GetOperation.headers.slice(1)">
								<td class="col-xs-4"><input class="form-control"
									type="text" placeholder="Header" data-ng-model="header.name" /></td>
								<td class="col-xs-7"><input class="form-control"
									type="text" placeholder="Value" data-ng-model="header.value" /></td>
								<td class="col-xs-1"><span
									class="sprite icon-minus-disabled v-middle"
									data-ng-click="removeHeader($index + 1)"></span></td>
							</tr>
						</tbody>
					</table>
					<div class="pull-left">
						<a class="btn btn-default" data-ng-click="addHeader()"><span
							class="sprite icon-plus v-middle"></span>&nbsp;&nbsp;<fmt:message
								key="CustomReport.Add" /></a>
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="control-label col-md-2" for="rowExpression"><fmt:message
						key="DataSet.Preview.RowExpression" /></label>
				<div class="col-md-10">
					<input type="text" class="form-control" id="rowExpression"
						placeholder="{{ dataSet.GetOperation.headers[0].value === 'application/xml' ? 'XPath' : 'JSONPath' }} expression for table row"
						data-ng-model="dataSet.GetOperation.rowExpression"
						data-ng-init="dataSet.GetOperation.originalRowExpression = dataSet.GetOperation.rowExpression"
						data-ng-blur="rowExpressionChanged()">
				</div>
			</div>
		</div>

	</form>

</fmt:bundle>
