var PARAM_WORKFLOW_ID = "workflowId";
var PARAM_WORKFLOW_NAME = "workflowName";
var PARAM_USER_INTERACTION = "id";
var PARAM_INTERACTION_ID = "interactionId";
var PARAM_INTERACTION_NAME = "interactionName";
var PARAM_CLIENT_ID = "clientId";
var PARAM_CLIENT_NAME = "clientName";
var PARAM_TARGET = "target";
var PARAM_DESCRIPTION = "description";
var PARAM_SUBTIME = "subTime";
var PARAM_FILTER = "filter";
var PARAM_TAB = "tab";
var PARAM_ACTION_NAME = "actionName";
var PARAM_USER_GUID = "id";
var PARAM_SUBMIT_OPTION = "_submit";
var PARAM_WORKFLOWENGINE_ID = "workflowEngineId";
var MODAL_URL = "/forms/run.jsp?";
var INVALID_WORKFLOW = true;
var availableWorkflows = -1;
var actionsTable = undefined;
var reinitializingTable = false;
var ACTIONS_URL = cvUtil.getContextPath() + "/server/retrieveActionForm";
var FORMS_URL = cvUtil.getContextPath() + "/server/retrieveForm";
var START_ACTION_URL = cvUtil.getContextPath() + "/server/startAction";
var START_FORMS_URL = cvUtil.getContextPath() + "/server/startForm";
var FORM_INDEX = 0;
var ACTION_INDEX = 1;
var currRequest = [];
var hItem;
var isTabSelect = false;
var isModalBoxEnabled = false;
var isRefreshReq = true;
var isIntialReq = false;
var isModalExists = false;
var inputParamsForModal = "";
var urlParams = {};
var selectedTab;
var dataResp;
var isOpenFilter = true;
var intialStateofIE = false;
var currentResp = undefined;
var isEmptyForm = false;
var respType = {
	GENERIC_RESP : 0,
	INFO_RESP : 1,
	POPUP_RESP : 2,
	END_USER_RESP : 3,
	START_WORKFLOW_RESP : 4,
	INPUT_PAGE : 5
};

var wfInputEntryValMap = {};
var searchableEntryMap = {};
var customInputsMap = {};
var reservedWords = [
		PARAM_WORKFLOW_ID,
		PARAM_WORKFLOW_NAME,
		PARAM_TAB,
		PARAM_SUBMIT_OPTION,
		PARAM_FILTER,
		PARAM_USER_GUID,
		PARAM_SUBTIME,
		PARAM_ACTION_NAME,
		PARAM_INTERACTION_NAME,
		PARAM_WORKFLOWENGINE_ID,
		PARAM_INTERACTION_ID,
		PARAM_USER_INTERACTION];
var isFormsPage = true;
var userInteractionResp = undefined;
var wfJsonObj = undefined;
var wfActionsTableHeight = {};

function columnresize(workflowIndex) {
	if ($("#formsTabs .disp").eq(workflowIndex).height() > 38) {
		var more = "<a href='#' class='more' data-open='0'>More</a>";
		var $disp = $("#formsTabs .disp").eq(workflowIndex);
		$disp.css("height", "37px");
		$disp.prev().show();
		$disp.parent(".displayText").append(more);
	}
}

function addListenerForToggle() {
	$(".more").off("click");
	$(".more").on("click", function(e) {
		e.preventDefault();
		if ($(this).data("open") == 0) {
			$(this).data("open", 1);
			$(this).html("Less");
			$(this).siblings(".ellip").hide();
			$(this).siblings(".disp").css("height", "auto");
			$(this).parents("li").css("height", "auto");
		} else {
			$(this).data("open", 0);
			$(this).html("More");
			$(this).siblings(".ellip").show();
			$(this).siblings(".disp").css("height", "37px");
			$(this).parents("li").css("height", "75px");
		}
	});
}

function addWorkflow(target, container, workflow, templateHTML) {
	if (workflow.inputForm != undefined/* && workflow.inputForm.entries!=undefined */) {
		var inputJSON = {};

		inputJSON[PARAM_CLIENT_ID] = workflow.client.clientId;
		inputJSON[PARAM_CLIENT_NAME] = workflow.client.clientName;
		inputJSON[PARAM_WORKFLOW_NAME] = workflow.entity.workflowName;
		inputJSON[PARAM_WORKFLOW_ID] = workflow.entity.workflowId;
		inputJSON[PARAM_TARGET] = target + '?tab=' + wfUtils.constants.FORM_INDEX + '&workflowName=' + workflow.entity.workflowName +
				'&workflowId=' + workflow.entity.workflowId;
		inputJSON[PARAM_DESCRIPTION] = ""/* workflow.description */;

		var workflowHTML = "";
		workflowHTML = $.trim(Mustache.to_html(templateHTML, inputJSON).replace(/^\s*/mg, ''));
		workflowHTML = workflowHTML.replace(/\n/g, '');

		container.append(workflowHTML);
		$("#" + inputJSON[PARAM_WORKFLOW_ID]).siblings(".disp").html(function() {
			return workflow.description;
		});

		columnresize(++availableWorkflows);
	}
}

function isiPhone() {
	return ((navigator.platform.indexOf("Mobile") != -1) || (navigator.platform.indexOf("iPad") != -1) || (navigator.platform
			.indexOf("iPhone") != -1));
}

function getCustomDialog(options) {
	$topModal = cvUtil.getTopModal().jqDialog;
	$topModal
			.dialog({
				resizable : true,
				minHeight : options.minHeight,
				minWidth : options.minWidth,
				handles : "all"
			})
			.bind('dialogdragstart dialogresizestart',
					function() {
						var overlay = $(this).find('.hidden-dialog-overlay');
						if (!overlay.length) {
							overlay = $('<div class="hidden-dialog-overlay" style="position:absolute;top:0;left:0;right:0;bottom:0;z-order:100000;"></div>');
							overlay.appendTo(this);
						} else {
							overlay.show();
						}
					}).bind('dialogdragstop dialogresizestop', function() {
				$(this).find('.hidden-dialog-overlay').hide();
			});
}

function getAppropriateParams(workflowId, workflowName, interactionId, interactionName, subTime) {
	var param = [];

	if ((workflowId != undefined && workflowId != "") || (workflowName != undefined && workflowName != "")) {
		param.push(cvUtil.createParamString(PARAM_WORKFLOW_ID, workflowId));
		param.push(cvUtil.createParamString(PARAM_WORKFLOW_NAME, workflowName));
	} else if (interactionId != undefined && interactionId != "") {
		param.push(cvUtil.createParamString(PARAM_INTERACTION_ID, interactionId));
		param.push(cvUtil.createParamString(PARAM_SUBTIME, subTime));
	}
	return param;
}

function getStateURL(urlParameters) {
	var param = [];
	param.push(cvUtil.createParamString(PARAM_TAB, urlParameters.tab));
	if (urlParameters.tab == wfUtils.constants.ACTION_INDEX) {
		//param.push(cvUtil.createParamString(PARAM_FILTER, urlParameters.isOpenFilter));
		if (urlParameters.actionName != "") {
			param.push(cvUtil.createParamString("actionName", urlParameters.actionName));
		}
	}
	var inputParam = cvUtil.createParamsString(param);
	param = getAppropriateParams(urlParameters.workflowId,
			urlParameters.workflowName,
			urlParameters.interactionId,
			urlParameters.interactionName,
			urlParameters.subTime);

	if (param.length > 0 && inputParam != '') {
		inputParam += '&';
	}

	inputParam += cvUtil.createParamsString(param);
	return inputParam;
}

function initiateInputForm(workflowId, workflowName, interactionId, interactionName, subTime) {
	inputParamsForModal = "";
	if (urlParams.actionName != "") {
		processAction();
	} else {
		var param = getAppropriateParams(workflowId, workflowName, interactionId, interactionName, subTime);

		if (param.length > 0) {
			param.push(cvUtil.createParamString("isInfoResp", false));
			param.push(cvUtil.createParamString("isPopUpResp", false));
			inputParamsForModal = cvUtil.createParamsString(param);

			var title = selectedTab == wfUtils.constants.FORM_INDEX ? workflowName : interactionName;
			displayModal(title);
		}
	}
}

var wfCloseListener = function(res) {
	if(!isLMPage()){
	displayPostWorkflowMessage(res);
	}
	else
	{	
		if(res.wfInputsAdded){
			$(".editWorkflow").css("display","block");
		}
	}
};

function processAction() {

	var url = wfUtils.functions.getURL(true);
	var params = [];
	params.push(cvUtil.createParamString("interactionId", urlParams.interactionId));
	params.push(cvUtil.createParamString("id", urlParams.id));
	params.push(cvUtil.createParamString("actionName", urlParams.actionName));
	inputParams = cvUtil.createParamsString(params);
	var message = wf_localMsg.successfulAction;
	cvUtil.loadPage(url, inputParams, function(data) {
		if (data != undefined) {
			if (data.respType == respType.GENERIC_RESP && data.response.errorCode != 0) {
				message = data.response.errorMessage;
				if (data.response.errorCode == -1) {
					message = wf_localMsg.invalidInteraction;
				}
				if (data.response.errorCode == -2) {
					message = wf_localMsg.unauthorizedAction;
				} else if (data.response.errorCode == -3) {
					message = wf_localMsg.completedAction + " " + data.response.errorMessage;
				} else if (data.response.errorCode == -4) {
					message = wf_localMsg.killedAction;
				}
			}

			$("#warning").attr("data-error", data.response.errorCode);
			$(".alert").html(message);
			$("#dialog").dialog({
				resizable : false,
				modal : true,
				width : 400,
				height : 150,
				close : function(event, ui) {
					invokeAppropriateWorkflowCallBack(data.response.errorCode);
				}
			});
			$("#dialog").parents(".ui-dialog").addClass("wfWarning");
			var margin = $("#dialog").innerWidth() / 2 - $("#warning").width() - 20 + "px";
			$("#warning").css("margin-right", margin);
			$("body .ui-dialog-titlebar").css("border-bottom", "none");
		}
	}, function(xhr, ajaxOptions, thrownError) {
		alert(wf_localMsg.startFormTimeoutWarning);
	}, getAjaxTimeOut());

}

function displayModal(modalTitle) {
	var target = cvUtil.getContextPath() + MODAL_URL + inputParamsForModal;
	var options = {
		width : 490,
		height : 445,
		title : modalTitle,
		resizable : true,
		href : target,
		iframe : true
	};

	cvUtil.showModal(options, null, wfCloseListener);

	var $topUIDialog = cvUtil.getTopModal().jqDialog.parent(".ui-dialog");
	
	var newwidth = $topUIDialog.width() + 10;
	$topUIDialog.addClass("wfPopup");
	$topUIDialog.find(".ui-dialog-titlebar").addClass("wfPopupTitle");

	var dialogOptions = {};
	dialogOptions.minHeight = 485;
	if (newwidth > 380) {
		dialogOptions.minWidth = newwidth;
	} else {
		dialogOptions.minWidth = 410;
	}

	getCustomDialog(dialogOptions);

	if (isiPhone()) {
		$(".ui-dialog").css("position", "fixed");
		$(".ui-dialog").css("top", "20px");
		$(".ui-dialog").css("left", "20px");
	}
}

function pushWorkflowParameterChangesToUrl(params) {

	if (logging.urlhistory) {
		console.log("Pushing params to URL");
	}

	if (params == '' && History.isInternetExplorer()) {
		window.location.href = '';
	} else {
		History.pushState(null, document.title, "?" + params);
	}
}

function historyStateChanged() {

	console.debug("URL statechange intercepted - updating workflow paramters from URL");
	readWorfklowParamtersFromUrl();

	var modalList = cvUtil.getTopWindow().cvUtil.openDialogs;
	if (modalList != undefined && modalList.length > 0) {
		$(modalList).each(function() {
			$("#modal" + this).remove();
		});
	}

	if (urlParams.workflowId != "" || urlParams.interactionId != "" || urlParams.id != "") {
		if (isIntialReq) // true for IE for first time when the page loads.
		{
			isIntialReq = false;
			workflowParametersChanged();
		}
		/*
		 * else { inputParamsForModal = getStateURL(); displayModal(); }
		 */
	} else {
		if (isRefreshReq) {
			if (intialStateofIE) {
				intialStateofIE = false;
				urlParams.tab = wfUtils.constants.ACTION_INDEX;
				urlParams.isOpenFilter = isOpenFilter;
			}
			workflowParametersChanged();
		} else {
			isRefreshReq = true;
		}
	}

}

function createWorkflowPage(workflowList) {
	var container = $('.apps');
	container.empty();
	availableWorkflows = -1;

	var templateHTML = $('.wfTemplate ul').html();

	for (var index = 0; index < workflowList.length; index++) {
		addWorkflow(cvUtil.getContextPath() + "/forms/", container, workflowList[index], templateHTML);
	}

	if (availableWorkflows == -1) {
		$("#formsTabs .laptopList").html('<span class="error">' + wf_localMsg.noRedeployedForms + '</span>');
	} else {
		$(".run").off("click");
		$(".run").on("click", function(event) {
			event.preventDefault();
			initiateInputForm($(this).attr("id"), $(this).attr("name"), undefined, undefined);
		});
		addListenerForToggle();
	}
}


function clearInputEntryVal(){
	wfInputEntryValMap = {};
}

function updateInputEntryVal(wfId,currInput,currInputVal){
	if(isLMPage()){
		var wfInfo = {};
		var inputMap = {};
		
		if(wfInputEntryValMap[wfId])
			wfInfo = wfInputEntryValMap[wfId];
		else
			wfInputEntryValMap[wfId] = wfInfo;
		
		if(wfInfo["inputs"])
			inputMap = wfInfo["inputs"];
		
		inputMap[currInput] = currInputVal;
		wfInputEntryValMap[wfId]["inputs"] = inputMap;
	}
}

function updateCustomQueryParamValsFromJSON(wfObj) {
	customInputsMap = {};
	var inputs = wfObj.inputs;
	if (inputs != undefined) {
		jQuery.each(inputs, function(key, value) {
			var paramName = key.trim();
			if (reservedWords.indexOf(paramName) == -1) {
				customInputsMap[paramName] = [];
				if (value != undefined) {
					if ($.isArray(value)) {
						customInputsMap[paramName] = value;
					} else {
						customInputsMap[paramName].push(value);
					}
				}
			}
		});
	}
}

function constructParamsFromInputs(wfId){
	if(wfInputEntryValMap[wfId] && wfInputEntryValMap[wfId]["inputs"]){
		return getCustomInputParams(wfInputEntryValMap[wfId]["inputs"]);
	}
	return undefined;
}

function updateCustomQueryParamVals(url) {
	url = url.split("+").join(" ");
	url = url.substring(url.indexOf("?"));
	customInputsMap = {};
	var tokens;
	var re = /[?&]?([^=]+)=([^&]*)/g;

	while (tokens = re.exec(url)) {
		var paramName = decodeURIComponent(tokens[1].replace(/\+/g, " "));
		if (reservedWords.indexOf(paramName) == -1) {
			if (customInputsMap[paramName] == undefined) {
				customInputsMap[paramName] = [];
			}
			customInputsMap[paramName].push(decodeURIComponent(tokens[2]));
		}
	}
}

function displaySelectedTab(previousTab) {
	if (previousTab != selectedTab) {
		urlParams.updateTab = true;
		if (selectedTab == wfUtils.constants.ACTION_INDEX) {

			$("#tabs").tabs("select", wfUtils.constants.ACTION_INDEX);
		} else {
			$("#tabs").tabs("select", wfUtils.constants.FORM_INDEX);
		}
	} else {
		updateTabsFromURLParams(false);
	}
}

function clearUserInteractionParams() {
	interactionParams = $.extend(true, {}, userInteractionResp);
	interactionParams = interactionParams.request;
	interactionParams.inputForm = "";
	interactionParams.description = "";
	interactionParams.title = "";
	interactionParams.completedForm = "";
	return interactionParams;
}

function clearPopUpResponseParams() {
	var interactionParam = $.extend(true, {}, currentResp);
	interactionParam.response.subject = "";
	interactionParam.response.description = "";
	interactionParam.response.inputForm = "";
	return interactionParam;
}

function addWarningListener() {
	$("#warning").off("click");
	$("#warning").on("click", function(e) {
		e.preventDefault();
		var $dialogs = $(".wfBottomArea.ui-dialog-content");
		$dialogs.eq($dialogs.length - 1).dialog("destroy");
		removeOpenDialogsFromModal();
		invokeAppropriateWorkflowCallBack(parseInt($("#warning").attr("data-error")));
	});
}
function getWfParamVal(paramVal, defaultVal) {
	if (paramVal == undefined || paramVal == "") {
		return defaultVal;
	}
	return paramVal;
}

function readWorfklowParamtersFromObj(wfObj) {
	if (wfObj != undefined) {
		urlParams.isOpenFilter = true;
		urlParams.workflowId = getWfParamVal(wfObj[PARAM_WORKFLOW_ID], "");
		urlParams.workflowName = getWfParamVal(wfObj[PARAM_WORKFLOW_NAME], "");
		urlParams.interactionId = getWfParamVal(wfObj[PARAM_INTERACTION_ID], "");

		if(urlParams.interactionId == "")
			urlParams.interactionId = getWfParamVal(wfObj[PARAM_USER_INTERACTION], "");
		
		urlParams.interactionName = getWfParamVal(wfObj[PARAM_INTERACTION_NAME], "");
		urlParams.tab = getWfParamVal(wfObj[PARAM_TAB], 0);
		urlParams.subTime = getWfParamVal(wfObj[PARAM_SUBTIME], "");
		urlParams.actionName = getWfParamVal(wfObj[PARAM_ACTION_NAME], "");
		urlParams.submit = getWfParamVal(wfObj[PARAM_SUBMIT_OPTION], "");
		urlParams.wfEngineId = getWfParamVal(wfObj[PARAM_WORKFLOWENGINE_ID], "");
		urlParams.id = getWfParamVal(wfObj[PARAM_USER_GUID], "");
	}

	if (urlParams.submit != "") {
		if (urlParams.submit == "true") {
			urlParams.submit = true;
		} else if (urlParams.submit == true) {
			urlParams.submit = true;
		} else if (urlParams.submit == "false") {
			urlParams.submit = false;
		} else {
			urlParams.submit = false;
		}
	}

	updateCustomQueryParamValsFromJSON(wfObj);

	if (!$.isEmptyObject(customInputsMap)) {
		urlParams.submit = urlParams.submit == "" ? false : (urlParams.submit != true) ? false : true;
	}
	
	displayAppropriateLoader();
}

function invokeAppropriateWorkflowCallBack(errorCode) {

	if (isFormPage()) {
		pushDefaultParameters();
			if (rpt) {
				rpt.reload();// we will reload the report using the rpt object.
			}
			
			getOpenActionsCount();
			
	} else {
		if (errorCode == 0) {
			if (wfJsonObj.success != undefined) {
				wfJsonObj.success(wfJsonObj.successParams);
			} else if (wfJsonObj.refreshOnSuccess == undefined ||
					(wfJsonObj.refreshOnSuccess != undefined && wfJsonObj.refreshOnSuccess == true)) {
				if (rpt) {
					rpt.reload();// we will reload the report using the rpt object.
				} else {
					location.reload();
				}
			}
		} else {
			if (wfJsonObj.fail != undefined) {
				wfJsonObj.fail(wfJsonObj.failParams);
			} else if (wfJsonObj.refreshOnFail != undefined && wfJsonObj.refreshOnFail == true) {
				if (rpt) {
					rpt.reload(); // we will reload the report using the rpt object.
				} else {
					location.reload();
				}
			}
		}
	}
}

function removeGivenElementsFromDOM($elementsToRemove){
	$($elementsToRemove).each(function() {
		$(this).remove();
	});
}

function removeOpenDialogsFromModal() {
	if(!isLMPage()){
	var $topWindow = cvUtil.getTopWindow();
	removeGivenElementsFromDOM($topWindow.$(".overlay"));
	removeGivenElementsFromDOM($topWindow.$(".ui-dialog"));
	removeGivenElementsFromDOM($topWindow.$(".ui-widget-overlay"));
	removeGivenElementsFromDOM($topWindow.$(".modal"));
}
}

function displayPostWorkflowMessage(res) {
	removeOpenDialogsFromModal();
	if (res.errorCode != undefined) {
		var message = '';
		var status = true;
		if (res.errorCode == 10) {
			alert(res.respMsg);
			invokeAppropriateWorkflowCallBack(res.errorCode);
		} else {
			if (res.errorCode == -1) {
				if (selectedTab == wfUtils.constants.FORM_INDEX) {
					//$("#warning").attr("data-workflowpresent",false);
					if(res.respMsg)
						message = res.respMsg;
					else
						message = '<span class="ellipsis" title="' + urlParams.workflowName + '">' +
							urlParams.workflowName + '</span>' + wf_localMsg.invalidWorkflow;
				} else {
					message = wf_localMsg.invalidInteraction;
				}
			} else if (res.errorCode == 0) {
				if (res.respType == 4) {
					if (selectedTab == wfUtils.constants.FORM_INDEX) {
						$("#warning").attr("data-workflowpresent", false);
						message = wf_localMsg.successfulWorkflow;
						//pushDefaultParameters();
					} else {
						status = false;
						invokeAppropriateWorkflowCallBack(res.errorCode);
					}
				} else {
					status = false;
					invokeAppropriateWorkflowCallBack(res.errorCode);
				}
			} else if (selectedTab == wfUtils.constants.ACTION_INDEX) {
				if (res.errorCode == -2) {
					message = wf_localMsg.unauthorizedAction;
				}
				if (res.errorCode == -3) {
					message = wf_localMsg.completedAction + " " + res.respMsg;
				} else if (res.errorCode == -4) {
					message = wf_localMsg.killedAction;
				}
			} else {
				message = res.respMsg;
			}

			if (status) {
				$("#warning").attr("data-error", res.errorCode);
				$(".alert").html(message);
				$("#dialog").dialog({
					resizable : false,
					modal : true,
					width : 400,
					height : 150,
					close : function(event, ui) {
						invokeAppropriateWorkflowCallBack(res.errorCode);
					}
				});

				//if(!isFormsPage){
				var $dialogs = $(".wfBottomArea.ui-dialog-content");
				var $dialog = $(".wfBottomArea.ui-dialog-content").eq($dialogs.length - 1);
				$dialog.parents(".ui-dialog").addClass("wfWarning");
				//$("#dialog").parents(".ui-dialog").addClass("wfWarning");
				//}
			}

			var $dialogs = $(".wfBottomArea.ui-dialog-content");
			var $dialog = $(".wfBottomArea.ui-dialog-content").eq($dialogs.length - 1);
			var $warning = $dialog.find("#warning");
			var margin = $dialog.innerWidth() / 2 - $warning.width() - 20 + "px";
			$warning.css("margin-right", margin);
			$("body .ui-dialog-titlebar").eq($dialogs.length- 1).css("border-bottom", "none");
		}
	} else {
		isRefreshReq = false;
		pushDefaultParameters();
		if (res.respType == respType.POPUP_RESP) {
			var params = [];
			params.push(cvUtil.createParamString("isPopUpResp", true));
			inputParamsForModal = cvUtil.createParamsString(params);
			displayModal(undefined);
		} else if (res.respType == respType.INFO_RESP) {
			var params = [];
			params.push(cvUtil.createParamString("isInfoResp", true));
			inputParamsForModal = cvUtil.createParamsString(params);
			displayModal(undefined);
		}
	}
}

function getAjaxTimeOut() {
	var ajaxReqOptions = {
		timeout : wfReqTimeOut?wfReqTimeOut:600000
	};
	return ajaxReqOptions;
}

function getCustomInputParams(savedInputMap) {
	var params = [];
	var customInputs = isLMPage() && savedInputMap?savedInputMap:customInputsMap;
	jQuery.each(customInputs, function(key, value) {
		if (value.length > 0) {
			jQuery.each(value, function() {
				params.push(cvUtil.createParamString(key, $.trim(this)));
			});
			params.push(cvUtil.createParamString("fieldList", key));
		}
	});
	return params;
}

function triggerActivityForSubmit() {
	var params = [];
	params = getCustomInputParams();

	if (urlParams.interactionId != "") {
		params.push(cvUtil.createParamString("interactionId", urlParams.interactionId));
	} else {
		params.push(cvUtil.createParamString("workflowName", urlParams.workflowName));
		params.push(cvUtil.createParamString("workflowId", urlParams.workflowId));
		if(parent.urlParams.wfEngineId && parent.urlParams.wfEngineId!=""){
			params.push(cvUtil.createParamString("_wfClientId",parent.urlParams.wfEngineId));
		}
	}

	params.push(cvUtil.createParamString("timeOffset", new Date().getTimezoneOffset()));
	var inputParams = cvUtil.createParamsString(params);

	var url = wfUtils.functions.getURL(true);
	cvUtil.mask();
	cvUtil.loadPage(url, inputParams, function(data) {
		var isWfCompleted = true;
		if (data != undefined) {
			customInputsMap = {};
			cvUtil.unmask();
			var wfResp = {
				respMsg : '',
				errorCode : undefined,
				respType : ''
			};
			currentResp = data;
			wfResp.respType = currentResp.respType;
			if (currentResp.respType == respType.GENERIC_RESP) {
				wfResp.respMsg = data.response.errorMessage;
				wfResp.errorCode = data.response.errorCode;
			} else if (currentResp.respType == respType.START_WORKFLOW_RESP) {
				wfResp.respMsg = "";
				wfResp.errorCode = 0;
			} else if (currentResp.respType == respType.END_USER_RESP) {
				wfResp.errorCode = undefined;
			} else if (currentResp.respType == respType.POPUP_RESP || currentResp.respType == respType.INFO_RESP) {
				isWfCompleted = false;
				initiateInputForm(urlParams.workflowId,
						urlParams.workflowName,
						urlParams.interactionId,
						urlParams.interactionName,
						urlParams.subTime);
			} else {
				wfResp.respMsg = data.errorMessage;
				wfResp.errorCode = data.errorCode;
			}

			if (isWfCompleted) {
				currentResp = undefined;
				displayPostWorkflowMessage(wfResp);
			}
		}
	}, undefined, getAjaxTimeOut());
}

function isCurPageForms(){
	window.location.pathname === cvUtil.getContextPath() + "/forms/";
}

function openForm(wfObj) {
	wfJsonObj = wfObj;
	addWarningListener();
	readWorfklowParamtersFromObj(wfObj);
	if (urlParams.interactionId != "") {
		selectedTab = wfUtils.constants.ACTION_INDEX;
	} else {
		selectedTab = wfUtils.constants.FORM_INDEX;
	}
	isFormsPage = false;
	if (urlParams.submit) {
		triggerActivityForSubmit();
	} else {
		initiateInputForm(urlParams.workflowId,
				urlParams.workflowName,
				urlParams.interactionId,
				urlParams.interactionName,
				urlParams.subTime);
	}
	return false;
}

function readWorfklowParamtersFromUrl(url) {
	urlParams = {};
	if (url != undefined) {
		urlParams.isOpenFilter = cvUtil.getParameterByName(PARAM_FILTER, url, true, false);
		urlParams.workflowId = cvUtil.getParameterByName(PARAM_WORKFLOW_ID, url, "", false);
		urlParams.workflowName = cvUtil.getParameterByName(PARAM_WORKFLOW_NAME, url, "", false);
		urlParams.interactionId = cvUtil.getParameterByName(PARAM_INTERACTION_ID, url, "", false);
		
		if(urlParams.interactionId == "")
			urlParams.interactionId = cvUtil.getParameterByName(PARAM_USER_INTERACTION, url, "", false);

		urlParams.interactionName = cvUtil.getParameterByName(PARAM_INTERACTION_NAME, url, "", false);
		urlParams.tab = cvUtil.getParameterByName(PARAM_TAB, url,0, false);
		urlParams.subTime = cvUtil.getParameterByName(PARAM_SUBTIME, url, "", false);
		urlParams.actionName = cvUtil.getParameterByName(PARAM_ACTION_NAME, url, "", false);
		urlParams.submit = cvUtil.getParameterByName(PARAM_SUBMIT_OPTION, url, "", false);
		urlParams.wfEngineId = cvUtil.getParameterByName(PARAM_WORKFLOWENGINE_ID, url, "", false);
		urlParams.id = cvUtil.getParameterByName(PARAM_USER_GUID, url, "", false);
	} else {
		if (History.isInternetExplorer()) {
			url = History.getState().cleanUrl;

			urlParams.isOpenFilter = cvUtil.getParameterByName(PARAM_FILTER, url, true, false);
			urlParams.workflowId = cvUtil.getParameterByName(PARAM_WORKFLOW_ID, url, "", false);
			urlParams.workflowName = cvUtil.getParameterByName(PARAM_WORKFLOW_NAME, url, "", false);
			urlParams.interactionId = cvUtil.getParameterByName(PARAM_INTERACTION_ID, url, "", false);
			
			if(urlParams.interactionId == "")
				urlParams.interactionId = cvUtil.getParameterByName(PARAM_USER_INTERACTION, url, "", false);

			urlParams.interactionName = cvUtil.getParameterByName(PARAM_INTERACTION_NAME, url, "", false);
			urlParams.tab = cvUtil.getParameterByName(PARAM_TAB, url,0, false);
			urlParams.subTime = cvUtil.getParameterByName(PARAM_SUBTIME, url, "", false);
			urlParams.actionName = cvUtil.getParameterByName(PARAM_ACTION_NAME, url, "", false);
			urlParams.submit = cvUtil.getParameterByName(PARAM_SUBMIT_OPTION, url, "", false);
			urlParams.wfEngineId = cvUtil.getParameterByName(PARAM_WORKFLOWENGINE_ID, url, "", false);
			urlParams.id = cvUtil.getParameterByName(PARAM_USER_GUID, url, "", false);
		} else {
			urlParams.isOpenFilter = cvUtil.getParameterViaHistory(PARAM_FILTER, true);
			urlParams.workflowId = cvUtil.getParameterViaHistory(PARAM_WORKFLOW_ID, "");
			urlParams.workflowName = cvUtil.getParameterViaHistory(PARAM_WORKFLOW_NAME, "");
			urlParams.interactionId = cvUtil.getParameterViaHistory(PARAM_INTERACTION_ID, "");
			
			if(urlParams.interactionId == "")
				urlParams.interactionId = cvUtil.getParameterViaHistory(PARAM_USER_INTERACTION, "");

			urlParams.interactionName = cvUtil.getParameterViaHistory(PARAM_INTERACTION_NAME, "");
			urlParams.tab = cvUtil.getParameterViaHistory(PARAM_TAB, 0);
			urlParams.subTime = cvUtil.getParameterViaHistory(PARAM_SUBTIME, "");
			urlParams.actionName = cvUtil.getParameterViaHistory(PARAM_ACTION_NAME, "");
			urlParams.submit = cvUtil.getParameterViaHistory(PARAM_SUBMIT_OPTION, "");
			urlParams.wfEngineId = cvUtil.getParameterViaHistory(PARAM_WORKFLOWENGINE_ID,"");
			urlParams.id = cvUtil.getParameterViaHistory(PARAM_USER_GUID, "");
		}
		url = History.getState().cleanUrl;
	}

	urlParams.workflowName = encodeURIComponent(urlParams.workflowName);
	urlParams.interactionName = encodeURIComponent(urlParams.interactionName);
	urlParams.subTime = encodeURIComponent(urlParams.subTime);

	if (urlParams.submit != "") {
		if (urlParams.submit == "true") {
			urlParams.submit = true;
		} else {
			urlParams.submit = false;
		}
	}

	updateCustomQueryParamVals(url);

	if (!$.isEmptyObject(customInputsMap) || urlParams.submit == true) {
		urlParams.submit = urlParams.submit == "" ? false : urlParams.submit != true ? false : true;
		urlParams.tab = wfUtils.constants.FORM_INDEX;
	} else {
		if (urlParams.tab == -1) {
			if (urlParams.workflowId != "" || urlParams.workflowName != "") {
				urlParams.tab = wfUtils.constants.FORM_INDEX;
			} else if (urlParams.interactionId != "" || urlParams.interactionName != "") {
				urlParams.tab = wfUtils.constants.ACTION_INDEX;
			}
		}
	}

	if (urlParams.tab != "") {
		urlParams.tab = parseInt(urlParams.tab);
	}

	if (urlParams.tab == wfUtils.constants.FORM_INDEX) {
		urlParams.isOpenFilter = isOpenFilter;
	} else if (urlParams.isOpenFilter == "false") {
		urlParams.isOpenFilter = false;
		isOpenFilter = false;
	}
	
	displayAppropriateLoader();
}

function displayAppropriateLoader(){
	if(!urlParams.submit){
		if(urlParams.tab == wfUtils.constants.FORM_INDEX)
			$(".wfFormsLoader").show();
		else
			$(".wfActionsLoader").show();
	}
}

function workflowParametersChanged() {
	var previousTab = selectedTab;

	if (urlParams.tab != "") {
		selectedTab = urlParams.tab;
	} else if (urlParams.interactionId != "") {
		selectedTab = wfUtils.constants.ACTION_INDEX;
	} else {
		selectedTab = wfUtils.constants.FORM_INDEX;
	}
	displaySelectedTab(previousTab);
}

function updateOpenActionsCount(noOfRows) {
	if (noOfRows != 0) {
		$(".activeActionsCount").show();
		$(".activeActionsCount").html(noOfRows);
	} else {
		$(".activeActionsCount").hide();
	}
}

function loadWorkflows() {
	cvUtil.loadPage(cvUtil.getContextPath() + '/server/forms', null, function(data) {
		if (data != undefined) {
			var workflowList = data.container;
			if (workflowList != undefined && workflowList.length > 0) {
				createWorkflowPage(workflowList);
			} else {
				$(".center").remove();
			}

			var openCount = 0;
			if (data.pendingActions != undefined) {
				openCount = parseInt(data.pendingActions);
			}

			enableOrDisableActionsTab(openCount, data.completedActions);
			updateOpenActionsCount(openCount);
		} else {
			$(".center").remove();
		}
	}, undefined, getAjaxTimeOut());
}

function updateWorkflowsPage() {

	var isWorkflowExists = $("#warning").attr("data-workflowpresent");
	if (isWorkflowExists != undefined && isWorkflowExists == "false") {
		$("#warning").removeAttr("data-workflowpresent");
		$(".apps").html('<div class="center"><img src="../common/img/loader.gif"/></div>');
		//loadWorkflows();
	}
}

/**
 * 
 * @param aoData
 * @param key
 * @param value
 */
function addToMap(aoData, key, value) {
	if (aoData.push) {
		aoData.push({
			name : key,
			value : value
		});
	}
}

function reInitializeDataTable(id) {
	reinitializingTable = true; // used to prevent reinitialization from invoking another ajax call

	// Restore original table DOM:
	if (actionsTable != undefined) {
		console.debug("Destroying actions table");
		actionsTable.fnClearTable();
		actionsTable.fnDestroy();
		actionsTable = null;
		console.debug("Done destroying actions table");
	}

	// Reinitialized the data table:
	console.debug("Re-initializing actions table");
	reinitializingTable = false;
	$("#" + id + "body").empty(); // else the intialize may try to incorporate the old row data and break
	initializeUserActionsTable(id);

	console.debug("Done re-initializing actions table");
}

function paginationReplace() {
	var pag = $(".dataTables_info").html().replace("entries", "");
	pag = pag.replace("Showing", "");
	pag = pag.replace("to", "-");
	pag = pag.replace("of", "<span class='unbold'>of</span>");
	pag = pag.replace("</p>", "</p>");
	var pagpar = "<p class='newpagination'>" + pag + "</p>";
	$(".dataTables_info").html(pagpar);
	var vis = $(".dataTables_paginate").css("visibility");
	if (vis == "visible") {
		var width = 0;
		$('.paginate_button').each(function() {
			width += $(this).outerWidth(true);
		});
		width = width / 2 + 50;
		var topwidth = $(".top").width();
		var paginatewidth = topwidth - width + 120 + "px";
		$(".dataTables_info").width(paginatewidth);
		if (urlParams.isOpenFilter) {
			$(".newpagination").css("width", "813px");
		} else {
			$(".newpagination").css("width", "620px");
		}
	}

}

function getFormattedDate(actionTime) {
	var currdate = new Date(parseInt(actionTime) * 1000);
	var temp = currdate.toDateString();
	temp = temp.substring(4);
	return currdate.getHours() + ":" + currdate.getMinutes() + " " + temp;
}

function getSubjectCol(source) {
	var rowTemplate = "<a id=\"" + source.map.id + '" href="' + cvUtil.getContextPath() + '/forms/?tab=' +
			source.map.tabIndex + '&filter=' + source.map.filter + '&interactionId=' + source.map.id +
			'&interactionName=' + source.map.name;

	if (!source.map.filter) {
		rowTemplate += '&subTime=' + source.map.completionTime + '" data-subTime="' + source.map.completionTime + '"';
	} else {
		rowTemplate += '"';
	}

	rowTemplate += '" class="runActions">' + source.map.name + '</a>';
	return rowTemplate;
}

function initializeUserActionsTable(id) {
	//jQuery.fn.dataTableExt.oPagination.iFullNumbersShowPages = 1;
	return;

	actionsTable = $('#' + id).dataTable({
		"sAjaxSource" : cvUtil.getContextPath() + '/server/retrieveActions',
		"iDisplayLength" : 15,
		"fnServerParams" : function(aoData) {
			addToMap(aoData, "tab", wfUtils.constants.ACTION_INDEX);
			addToMap(aoData, "isOpenfilter", urlParams.isOpenFilter);
			var date = new Date();
			addToMap(aoData, "timeOffset", date.getTimezoneOffset());
		},
		"fnDrawCallback" : function() {
			if (urlParams.isOpenFilter) {
				updateOpenActionsCount(this.dataTableSettings[0].fnRecordsTotal());
			}
			$(".runActions").off("click");
			$(".runActions").on("click", function(e) {
				e.preventDefault();
				initiateInputForm("", "", $(this).attr("id"), $(this).html(), $(this).attr("data-subTime"));
			});
			paginationReplace();
		},
		"sDom" : 'rt<"bottom"iflp<"clear">>',
		"sPaginationType" : 'full',
		"fnServerData" : function(sSource, aoData, fnCallback) {
			$.ajax({
				"dataType" : 'json',
				"type" : "POST",
				"url" : sSource,
				"data" : aoData,
				"error" : function() {
				},
				"success" : function(json) {
					// Proceed with normal dataTable processing:
					$(".dataTables_info").css("visibility", "visible");
					console.log(json);
					fnCallback(json);

					//enableOrDisableActionsTab(parseInt(json.iTotalRecords));
					if (actionsTable.dataTableSettings[0]._iDisplayLength < json.iTotalRecords) {
						$("#" + id + "_paginate").show();
						$(".dataTables_info").css("visibility", "visible");
					} else {
						$("#" + id + "_paginate").hide();
						if (json.iTotalDisplayRecords == 0) {
							$(".dataTables_info").hide();
						}
						//$(".newpagination").css("width","813px");
					}
				}
			});
		},
		"aoColumnDefs" : (urlParams.isOpenFilter) ? [ {
			"aTargets" : [ 0 ],
			"mDataProp" : function(source, type, val) {
				return getSubjectCol(source);
			}
		}, {
			"type" : "num",
			"aTargets" : [ 1 ],
			"mDataProp" : function(source, type, val) {
				if (type == "sort") {
					return source.map.createdTime_epoch;
				} else {
					return source.map.createdTime;
				}
			}
		} ] : [ {
			"aTargets" : [ 0 ],
			"mDataProp" : function(source, type, val) {
				return getSubjectCol(source);
			}
		}, {
			"aTargets" : [ 1 ],
			"mDataProp" : function(source, type, val) {
				return source.map.completedby;
			}
		}, {
			"type" : "num",
			"aTargets" : [ 2 ],
			"mDataProp" : function(source, type, val) {
				if (type == "sort") {
					return source.map.completionTime_epoch;
				} else {
					return source.map.completionTime;
				}
			}
		} ],
		"aaSorting" : (urlParams.isOpenFilter) ? [ [ 1, "desc" ] ] : [ [ 2, "desc" ] ],
		"bLengthChange" : false,
		"bRetrieve" : true,
		"bAutoWidth" : false,
		"bFilter" : false,
		"oLanguage" : {
			"oPaginate" : {
				"sFirst" : '',
				"sNext" : '',
				"sPrevious" : '',
				"sLast" : ''
			},
			"sLoadingRecords" : "",
			"sEmptyTable" : urlParams.isOpenFilter ? wf_localMsg.noPendingActions : wf_localMsg.noCompletedActions
		},
	});
}

function enableOrDisableAppropriateAction() {
	if (urlParams.isOpenFilter) {
		$(".closedActions").hide();
		$(".openActions").show();
		$("#completed").removeClass("active");
		$("#open").addClass("active");
	} else {
		$(".openActions").hide();
		$(".closedActions").show();
		$("#open").removeClass("active");
		$("#completed").addClass("active");
	}
}

function getAppropriateActionId() {
	return urlParams.isOpenFilter ? "openActionsTable" : "closedActionsTable";
}

function updateTabsFromURLParams(isFormProcessed) {
	if (selectedTab == wfUtils.constants.ACTION_INDEX) {
		enableOrDisableAppropriateAction();
		reInitializeDataTable(getAppropriateActionId());
	} else {
		loadWorkflows();
	}

	if (!isFormProcessed) {
		if (urlParams.submit == true) {
			triggerActivityForSubmit();
		} else {
			initiateInputForm(urlParams.workflowId,
					urlParams.workflowName,
					urlParams.interactionId,
					urlParams.interactionName,
					urlParams.subTime);
		}
	}
}

function isLMPage(){
	var $contextPath = cvUtil.getContextPath();
	return window.location.pathname ===  $contextPath + "/logMonitoring.do" || window.location.pathname === $contextPath + "/logMonitoring/editSearch.jsp";
}

function isFormPage(){
	return window.location.pathname === cvUtil.getContextPath() + "/forms/";
}

function pushDefaultParameters() {
	if (isFormPage()) {
		isRefreshReq = false;
		var param = [];
		urlParams.workflowId = "";
		urlParams.workflowName = "";
		urlParams.wfEngineId = "";
		urlParams.interactionId = "";
		urlParams.interactionName = "";
		urlParams.actionName = "";
		urlParams.id = "";
		urlParams.tab = selectedTab;
		urlParams.isOpenFilter = isOpenFilter;
		var updatedFilter = isOpenFilter;

		var changedURL = getStateURL(urlParams);

		readWorfklowParamtersFromUrl();
		isOpenFilter = updatedFilter;

		var currentURL = getStateURL(urlParams);

		if (urlParams.tab != -1 && changedURL == currentURL) {
			if (isRefreshReq) {
				workflowParametersChanged();
			} else {
				isRefreshReq = true;
			}
		} else {
			param.push(cvUtil.createParamString(PARAM_TAB, selectedTab));
			if (selectedTab == wfUtils.constants.ACTION_INDEX) {
				//param.push(cvUtil.createParamString(PARAM_FILTER, updatedFilter));
			}
			pushWorkflowParameterChangesToUrl(cvUtil.createParamsString(param));
		}
	}
}

function getOpenActionsCount(){
	var count = 0;
	cvUtil.loadPage(cvUtil.getContextPath() + '/server/openActionsCount', null, function(data) {
		if (data != undefined) {
			count = parseInt(data);
			updateOpenActionsCount(count);
		}
	});
}

function displayInitialAppropriateTab() {
	var count = 0;

	readWorfklowParamtersFromUrl();

	if (!(History.emulated.pushState && History.getHash()) && urlParams.tab != -1) {
		workflowParametersChanged();
	} else {
		cvUtil.loadPage(cvUtil.getContextPath() + '/server/openActionsCount', null, function(data) {
			if (data != undefined) {
				count = parseInt(data);
				if (History.emulated.pushState && History.getHash()) {
					if (count > 0) {
						updateOpenActionsCount(count);
						intialStateofIE = true;
					}
					History.Adapter.trigger(window, "statechange");
				} else {
					readWorfklowParamtersFromUrl();
					if (urlParams.tab == -1) {
						if (count > 0) {
							updateOpenActionsCount(count);
							$("#tabs").tabs("select", wfUtils.constants.ACTION_INDEX);
						} else {
							pushDefaultParameters();
						}
					}
					/*
					 * else { workflowParametersChanged(); }
					 */
				}
			} else {
				pushDefaultParameters();
			}
		}, function(xhr, ajaxOptions, thrownError) {
			pushDefaultParameters();
		}, getAjaxTimeOut());
	}
}

function enableOrDisableActionsTab(actionsCount, isCompletedActions) {
	if (actionsCount > 0 || isCompletedActions) {
		$("#tabs").tabs("enable", wfUtils.constants.ACTION_INDEX);
		$("#tab2").show();
		$(".activeActionsCount").show();
	} else {
		/*
		 * if(selectedTab == wfUtils.constants.ACTION_INDEX) { $( "#tabs" ).tabs( "select", wfUtils.constants.FORM_INDEX); } else {
		 */
		$("#tabs").tabs("disable", wfUtils.constants.ACTION_INDEX);
		$("#tab2").hide();
		$(".activeActionsCount").hide();
		//				}
	}
}
