var FormSearchableOps=(function(){
var currentPagedInput;
var paginationURL = wfUtils.constants.START_FORMS_URL;
var interactiveParams = {};
var PageControl = {
	FIRST : "FIRST",
	NEXT : "NEXT",
	PREVIOUS : "PREVIOUS",
	LAST : "LAST",
	SELECTION : "SELECTION",
	SEARCH : "SEARCH"
};
var INPUT_PAGE = 5;
var currentPagedInputName;
var localMap = {};
var isListType = false;
var showSelectedListMode = "false";
var PAGE_LIMIT = 100;

function getTargetUrlForDatasetOptions(currentPagedInput){
	if(currentPagedInput.datasetOptions)
		return "wfDataSetOptions.do";
	else
		return "wfEntityList.do";
}

function getResults(pageAction, pageVal) {
	
	if(Forms.isDataSetRequest(currentPagedInput)){
		$("#wfSearchablePopUp .modal-body").mask("");
		var params = [];
		
		params.push(cvUtil.createParamString("offset",(pageVal - 1)*PAGE_LIMIT));
		params.push(cvUtil.createParamString("limit", PAGE_LIMIT));
		params.push(cvUtil.createParamString("cacheId", getCacheId(currentPagedInput.name)));
		params.push(cvUtil.createParamString("where", $("#SearchresultSearch").val()));
		
		if(currentPagedInput.datasetOptions)
			params.push(cvUtil.createParamString("dataSetOptions",JSON.stringify(currentPagedInput.datasetOptions)));
			
		var inputParams = cvUtil.createParamsString(params);
		cvUtil.loadPage(getTargetUrlForDatasetOptions(currentPagedInput), inputParams, function(data) {
			$("#wfSearchablePopUp .modal-body").unmask("");
			if (data != undefined && data.records != undefined) {
				var optionsResp = getOptionsInfoForComplexEntity(currentPagedInput.inputType,data);
				
				currentPagedInput.currentPage = pageVal;
				if(optionsResp != undefined){
					var curOptionsMap = searchableEntryMap[currentPagedInput.inputName]["optionsMap"];
					curOptionsMap = $.extend({},curOptionsMap,optionsResp.optionsMap);
					searchableEntryMap[currentPagedInputName]["optionsMap"] = curOptionsMap;
					currentPagedInput["totalPages"] = optionsResp["totalPages"];
					currentPagedInput["options"] = optionsResp["options"];
					searchableEntryMap[currentPagedInputName]["cacheId"] = optionsResp["cacheId"];
				}
			}
			resultsCallBack();
		}, function(xhr, ajaxOptions, thrownError) {
			$("#wfSearchablePopUp .modal-body").unmask("");
		});
	}
	else
	{
	var params = [];
	params.push(cvUtil.createParamString("interactionParams", JSON.stringify(interactiveParams)));
	params.push(cvUtil.createParamString("inputEntry", currentPagedInput));
	params.push(cvUtil.createParamString("pageControl", pageAction));
	params.push(cvUtil.createParamString("searchTerm", $("#SearchresultSearch").val()));
	params.push(cvUtil.createParamString("pageVal", $(".customPagInput").val()));

	var inputParams = cvUtil.createParamsString(params);

	cvUtil.loadPage(paginationURL, inputParams, function(data) {
		if (data != undefined && data.response.input != undefined) {
			currentPagedInput = $.extend({}, true, data.response.input);

					if (currentPagedInput.totalPages > 0) {
						var curOptionsMap = searchableEntryMap[currentPagedInput.inputName]["optionsMap"];
						if(data.response.optionsMap)
							{
								var optionsMap = JSON.parse(data.response.optionsMap);
								if(optionsMap)
									curOptionsMap = $.extend({},curOptionsMap,optionsMap);
							}
							searchableEntryMap[currentPagedInput.inputName]["optionsMap"] = curOptionsMap;
					}
					
					resultsCallBack();
					
					currentPagedInput.options = undefined;
					currentPagedInput.alignment = undefined;
					currentPagedInput.controlType = 2;
					currentPagedInput.documentation = "";
					currentPagedInput = JSON.stringify(currentPagedInput);
				}
			});
	}
}

function updatePaginationButtons(pageInfo){
	if (pageInfo.currentPage == 1) {
			$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .prev").addClass("statusDisabled");
				} else {
			$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .prev").removeClass("statusDisabled");
				}

				if (pageInfo.currentPage == pageInfo.totalPages) {
			$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .next").addClass("statusDisabled");
				} else {
			$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .next").removeClass("statusDisabled");
				}
}

function resultsCallBack(){
			if (currentPagedInput.totalPages == 0) {
				$("#Searchresult .checkboxes").html('<div class="noResults">No results found</div>');
				$(".customPagInput").val(0);
				$(".totalPageCount").html(0);
		$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .prev").addClass("statusDisabled");
		$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .next").addClass("statusDisabled");
			} else {
				updatePaginationButtons(currentPagedInput);
				$(".customPagInput").val(currentPagedInput.currentPage);
				$(".totalPageCount").html("/ " + currentPagedInput.totalPages);
				isListType = currentPagedInput.listType;
		displayResults(currentPagedInput.options,searchableEntryMap[currentPagedInput.inputName]["optionsMap"],currentPagedInput.totalPages);
			}
}

function applyAlreadySelectedList(list) {
	jQuery.each(list,
			function() {
				var currenKeyword = this.trim();
				var desiredCheckBoxID = $(".checkboxes").find("[value='" +
						escapeSpecialSymbols(currenKeyword) + "']");
				if (desiredCheckBoxID.length != 0) {
					desiredCheckBoxID.attr('checked', true);
				}
			});
}

function escapeSpecialSymbols(currentKey) {
	currentKey = currentKey.replace(/\./g, "\\.");
	currentKey = currentKey.replace(/:/g, "\\:");
	currentKey = currentKey.replace(/::/g, "\\::");
	currentKey = currentKey.replace(/,/g, "\\,");

	currentKey = currentKey.replace(/!/g, "\\!");
	currentKey = currentKey.replace(/@/g, "\\@");
	currentKey = currentKey.replace(/#/g, "\\#");
	currentKey = currentKey.replace(/\$/g, "\\$");
	currentKey = currentKey.replace(/%/g, "\\%");
	currentKey = currentKey.replace(/\^/g, "\\^");
	currentKey = currentKey.replace(/&/g, "\\&");
	currentKey = currentKey.replace(/\*/g, "\\*");
	currentKey = currentKey.replace(/\(/g, "\\(");
	currentKey = currentKey.replace(/\)/g, "\\)");
	currentKey = currentKey.replace(/\"/g, '\\"');
	currentKey = currentKey.replace(/\+/g, "\\+");
	// currentKey = currentKey.replace(/\//g,"\\");
	currentKey = currentKey.replace(/~/g, "\\~");
	currentKey = currentKey.replace(/`/g, "\\`");
	currentKey = currentKey.replace(/</g, "\\<");
	currentKey = currentKey.replace(/>/g, "\\>");
	currentKey = currentKey.replace(/\?/g, "\\?");
	currentKey = currentKey.replace(/\[/g, "\\[");
	currentKey = currentKey.replace(/]/g, "\\]");
	currentKey = currentKey.replace(/{/g, "\\{");
	currentKey = currentKey.replace(/}/g, "\\}");
	//currentKey = currentKey.replace(/\\/g,"\\");
	currentKey = currentKey.replace(/'/g, "\\'");
	currentKey = currentKey.replace(/;/g, "\\;");
	currentKey = currentKey.replace(/\|/g, "\\|");

	return currentKey;
}

function displayResults(options,optionsMap,totalPages) {
	var container = $("#Searchresult .checkboxes");
	container.empty();
	
	$(".customPagInput").attr("max",totalPages);
	var baseHTML = '<div class="checkbox"><label><span><input type="checkbox"';

	if (showSelectedListMode == "true") {
		baseHTML += ' checked="checked"';
	}

	baseHTML += 'name="" value="';

	var currentInput = searchableEntryMap[currentPagedInputName];
	
	if(showSelectedListMode == "true" || (currentInput.className != "java.util.Date" && currentInput.className != "java.util.Calendar" && currentInput.className != "workflow.types.Time")){
		jQuery(options).each(function(index) {

			var curOption = this;
			var curVal = "";

			if(isNaN(curOption))
			{
				curOption = curOption.trim();
				curVal = curOption.replace(/\"/g, "&quot;");
				
			}
			else
			{
				curVal = curOption
			}

			var curName = curVal;
			
			if(optionsMap[curOption])
				curName = optionsMap[curOption];
			
			container.append(baseHTML + curVal + '" title="' + curName + '"/><span>' + curName +
					'</span></span></label></div>');
		});
	}
	else
	{
		if(currentInput.className == "java.util.Date"){
			var opt = {'showOnlyDate':true};
	jQuery(options).each(function(index) {
		var curOption = this.trim().replace(/\"/g, "&quot;");
				curOption = Forms.getFormattedValueForDateTime(opt,curOption);
		container.append(baseHTML + curOption + '" title="' + curOption + '"/><span>' + curOption +
				'</span></span></label></div>');
	});
		}
		else if (currentInput.className == "java.util.Calendar" || currentInput.className == "workflow.types.Time") {
			var opt = currentInput.className == "workflow.types.Time"?{'showOnlyTime':true}:{};
			jQuery(options).each(function(index) {
				var curOption = this.trim().replace(/\"/g, "&quot;");
				curOption = Forms.getFormattedValueForDateTime(opt,curOption);
				container.append(baseHTML + curOption + '" title="' + curOption + '"/><span>' + curOption +
				'</span></span></label></div>');
			});
		}
	}

	applyAlreadySelectedList(searchableEntryMap[currentPagedInputName]["tempList"]);
	$('#searchList input[type="checkbox"]').off("change");
	$('#searchList input[type="checkbox"]').on("change",
			function() {
				if ($(this).prop('checked')) {
					var selectedCheckBox = $(this);
					if (!isListType) {
						$('#searchList input[type="checkbox"]').prop("checked", false);
						searchableEntryMap[currentPagedInputName]["unSelectedList"] = [];
						searchableEntryMap[currentPagedInputName]["unSelectedList"] = $.extend([],
								searchableEntryMap[currentPagedInputName]["tempList"]);
						searchableEntryMap[currentPagedInputName]["tempList"] = [];
						searchableEntryMap[currentPagedInputName]["tempList"].push($(this).val());
						selectedCheckBox.prop("checked", true);
					} else {
						searchableEntryMap[currentPagedInputName]["tempList"].push($(this).val());
					}
				} else {
					var desiredIndex = searchableEntryMap[currentPagedInputName]["tempList"].indexOf($(this).val());
					if (desiredIndex != -1) {
						searchableEntryMap[currentPagedInputName]["unSelectedList"].push($(this).val());
						searchableEntryMap[currentPagedInputName]["tempList"].splice(desiredIndex, 1);
					}
				}
			});
}

function updateStateOfSearchableControlInForm(currentInputInfo){
	var _changeCallBackFunc = searchableEntryMap[currentInputInfo]["_changeCallBackFunc"];
	console.log(_changeCallBackFunc);
	_changeCallBackFunc(searchableEntryMap[currentInputInfo]["selectedList"]);		
}

function closeSearchableDialog(container){
			$(container).modal("hide");
}

function getCacheId(currentInputInfo){
	var cacheId = searchableEntryMap[currentInputInfo]["cacheId"];
	if(cacheId!=undefined)
		return cacheId;
	else
		return undefined;
}

function getOptionsInfoForComplexEntity(inputType,optionsJsonArr){
	var optionsResp = undefined;
	if(Forms.isDataSetRequest(searchableEntryMap[currentPagedInputName])){
		var optionsMap = {};
		var options = [];
		
		if(optionsJsonArr!=undefined && optionsJsonArr.records!=undefined){
				optionsResp = {};
				var records = optionsJsonArr.records;
				
				
				var noOfRecords = records.length;
				noOfRecords = noOfRecords > PAGE_LIMIT?PAGE_LIMIT:noOfRecords;
				for(i = 0 ;i<noOfRecords; i++)
				{
					var curRecord = records[i][0];
					optionsMap[curRecord] = records[i][1] && records[i][1].trim()!=""?records[i][1]:curRecord;
					options.push(curRecord);
				}
			optionsResp["optionsMap"] = optionsMap;
			optionsResp["options"] = options;
			optionsResp["totalPages"] = Math.ceil(optionsJsonArr.totalRecordCount/PAGE_LIMIT);
			optionsResp["cacheId"] = optionsJsonArr.cacheId?optionsJsonArr.cacheId:undefined;
		}
	}
	return optionsResp;
}

function initPagination(options,currentInputInfo) {
	displayResults(options,searchableEntryMap[currentInputInfo]["optionsMap"],searchableEntryMap[currentInputInfo]["totalPages"]);
	$(".prev").off("click");
	$(".prev").on("click", function(e) {
		e.preventDefault();
		var curPage = parseInt($(".customPagInput").val());
		getResults(PageControl.PREVIOUS,curPage - 1);
	});

	$(".next").off("click");
	$(".next").on("click", function(e) {
		e.preventDefault();
		var curPage = parseInt($(".customPagInput").val());
		getResults(PageControl.NEXT,curPage + 1);
	});

	$("#searchableOkButton").off("click");
	$("#searchableOkButton").on("click", function(e) {
		e.preventDefault();
		searchableEntryMap[currentInputInfo]["selectedList"] = $.extend([],searchableEntryMap[currentInputInfo]["tempList"]);
		//Forms.displaySelectedValsForSearchableType(currentInputInfo);
		searchableEntryMap[currentInputInfo]["unSelectedList"] = [];
		searchableEntryMap[currentInputInfo]["tempList"] = [];
		
		updateStateOfSearchableControlInForm(currentInputInfo);
		closeSearchableDialog("#" + wfUtils.constants.SEARCHABLE_POPUP_ID,true);
	});

	$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID).off("hidden.bs.modal").on("hidden.bs.modal", function () {
		if(!Forms.isFullPageForm())	
		$("body").addClass("modal-open");
		$(this).data('bs.modal', null);
		var unselectedOptions = searchableEntryMap[currentInputInfo]["unSelectedList"];
		var tempList = searchableEntryMap[currentInputInfo]["tempList"];
		jQuery(unselectedOptions).each(function(index) {
			var curOption = this;
			if (tempList.indexOf("curOption") != -1) {
				searchableEntryMap[currentInputInfo]["selectedList"].push(curOption);
			}
			searchableEntryMap[currentInputInfo]["unSelectedList"] = [];
			searchableEntryMap[currentInputInfo]["tempList"] = [];
		});
		searchableEntryMap[currentInputInfo]["unSelectedList"] = [];
		searchableEntryMap[currentInputInfo]["tempList"] = [];
		updateStateOfSearchableControlInForm(currentInputInfo);
		$("#" + currentInputInfo).trigger("change");
	});
	
	$(".customPagInput").off("keydown");
	$(".customPagInput").on("keydown", function(e) {
		if (e.keyCode == 13 && !e.shiftKey) {
			e.preventDefault();
			getResults(PageControl.SELECTION, $(this).val());
		}
	});

	$("#SearchresultSearch").off("keydown");
	$("#SearchresultSearch").on("keydown", function(e) {
		if (e.keyCode == 13 && !e.shiftKey) {
			e.preventDefault();
			getResults(PageControl.SEARCH,1);
		}
	});

	$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .sb-icon-search").off("click").on("click", function(e) {
		e.preventDefault();
		getResults(PageControl.SEARCH,1);
	});

}

function resetSearchableParams(){
	currentPagedInput = undefined;
	interactiveParams = {};
	currentPagedInputName = undefined;
	localMap = {};
	isListType = false;
	showSelectedListMode = "false";
}

function showSearchable(inputName,showSelectedList){
			resetSearchableParams();
			Forms.setModalTitle("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .modal-header h4",showSelectedList == "true"?wf_localMsg.searchableSelectedOptionsTitle:wf_localMsg.searchableResultsTitle);
			currentPagedInputName = inputName;
			showSelectedListMode = showSelectedList;
			var options;

			if (showSelectedListMode == "true") {
				options = searchableEntryMap[currentPagedInputName]["tempList"];
				$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .next").addClass("statusDisabled");
				$("#headerArea").css("display", "none");
				$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .prev").addClass("statusDisabled");
			} else {
				var userInteractionResp = Forms.getUserInteractionResp();
				var curInteraction = (userInteractionResp != undefined &&
						userInteractionResp.request != undefined && userInteractionResp.request != "") ? userInteractionResp.request.interactionId
						: undefined;
				
				var optionsResp = getOptionsInfoForComplexEntity(searchableEntryMap[currentPagedInputName].inputType,FormOps.getForm().state.schema.properties[currentPagedInputName].optionsJsonArr);
				
				if(optionsResp != undefined){
					searchableEntryMap[currentPagedInputName]["optionsMap"] = optionsResp["optionsMap"];
					searchableEntryMap[currentPagedInputName]["options"] = optionsResp["options"];
					searchableEntryMap[currentPagedInputName]["totalPages"] = optionsResp["totalPages"];
					searchableEntryMap[currentPagedInputName]["cacheId"] = optionsResp["cacheId"]
				}
				
				currentPagedInput = $.extend({}, true, searchableEntryMap[currentPagedInputName]);
				
				if (curInteraction != undefined && curInteraction != "") {
					var interactiveRsp = Forms.clearUserInteractionParams();
					interactiveParams["response"] = interactiveRsp;
				} else {
					if(!wfUtils.functions.isComplexEntity(currentPagedInput.inputType))
					interactiveParams = Forms.clearPopUpResponseParams();
				}

				currentPagedInput.documentation = "";
				isListType = currentPagedInput.listType;
				options = currentPagedInput.options;
				
				interactiveParams.respType = INPUT_PAGE;
				var totalPages = currentPagedInput.totalPages;
				currentPagedInput.controlType = 2;
				currentPagedInput.options = undefined;
				currentPagedInput.alignment = undefined;
				
				$(".customPagInput").val(currentPagedInput.currentPage);
				updatePaginationButtons(currentPagedInput);
				
				if(optionsResp == undefined)
				currentPagedInput = JSON.stringify(currentPagedInput);
				if (totalPages <= 1) {
					$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .next").addClass("statusDisabled");
				}
				
				$(".totalPageCount").html("/ " + totalPages);
			}
			
			initPagination(options,inputName);
}

return {
	"showSearchable": showSearchable
}

})();