"use strict";


function isUserInteraction() {
	return inputForm.interactionId != undefined && inputForm.interactionId > 0 ? true : false;
}

function invokeDefaultEvent(e) {
	$(e.target).trigger(e.handleObj.type + "." + APP_NAMESPACE);
}

function setSearchableEntryMap(key,val) {
	searchableEntryMap[key] = value;
}

var searchableEntryMap = {};
var APP_NAMESPACE = "formsApp";
var SELECTED_FILEROW_TEMPLATE = "SELECTED_FILEROW_TEMPLATE";
var SELECTED_FILEROW_PREVIEW_TEMPLATE = "SELECTED_FILEROW_PREVIEW_TEMPLATE";

var Forms = (function(formObj){
var controlToFocus = undefined;
var TEXTBOX = "TEXTBOX";
var MULTILINE = "MULTILINE";
var DROPDOWN = "DROPDOWN";
var LISTBOX = "LISTBOX";
var RADIO = "RADIOBUTTON";
var CHECKBOX = "CHECKBOX";
var RADIOBUTTON = "RADIOBUTTON";
var PWD_TEXT_FIELD = "PWD_TEXT_FIELD";
var CALENDAR = "CALENDAR";
var DATE_TIME = "DATETIME_PICKER";
var TIME_PICKER = "TIME_PICKER";
var FILE_PICKER = "FILE_PICKER";
var ACTION_BUTTON_CONTROL = "ACTION_BUTTON_CONTROL";
var ACTION_BUTTON_CONTROL_LABEL = "ACTION_BUTTON_CONTROL_LABEL";
var ACTION_BUTTON_DELETE_CONTROL = "ACTION_BUTTON_DELETE_CONTROL";
var SEARCHABLEDROPDOWN = "SEARCHABLEDROPDOWN";
var SEARCHABLE_TEMPLATE = "SEARCHABLE_TEMPLATE";
var dialogType = {
 		POPUP_DIALOGTYPE : "Popup"
 	};
var scriptMetaInfo = {
	cssInfo : {
			startTag : "<style id=\"wfUserDefinedStyleBlock\">",
		endTag : "</style>"
	},
	javaScriptInfo : {
		startTag : "<script>",
		endTag : "</script>"
	}
};
var templateClass = {
		SEARCHABLEDROPDOWN : 'searchableDropdown ul',
		ACTION_BUTTON_CONTROL : '<button type="button" data-action="{{actionName}}" data-validate="{{validateForm}}" class="btn btn-primary" id="{{id}}" data-dismiss="{{disMissModal}}">{{label}}</button>',
		ACTION_BUTTON_CONTROL_LABEL : '<label for="{{innerBtnId}}" data-action="{{actionName}}" data-validate="{{validateForm}}" class="btn btn-primary" id="{{id}}">{{label}}</label>',
		ACTION_BUTTON_DELETE_CONTROL : '<button type="button" class="btn btn-primary" id="{{id}}">{{label}}</button>',
		SEARCHABLE_TEMPLATE : 'searchableTemplate',
		SELECTED_FILEROW_TEMPLATE : '<span class="upload-list-item" data-cross="true" data-inputName="{{inputName}}" data-fileName="{{fileName}}" data-defaultFile="{{isDefaultFile}}"><span>{{fileName}}</span></span>',
		SELECTED_FILEROW_PREVIEW_TEMPLATE : '<span class="upload-list-item" data-cross="true" data-inputName="{{inputName}}" data-fileName="{{fileName}}" data-defaultFile="{{isDefaultFile}}"><span><a href="#" class="wfPreviewFile" data-shareId="{{shareId}}" data-filePath="{{filePath}}" data-fileName="{{fileName}}" data-size="{{size}}">{{fileName}}</a></span></span>'
};
var controlAlignment = {
		HORIZONTAL : "HORIZONTAL",
		VERTICAL : "VERTICAL"
	};

var inputForm;
var workflowResp = {
		respMsg : '',
		errorCode : undefined,
		respType : ''
	};
var fieldVals = [];
var dialogType = {
		POPUP_DIALOGTYPE : "Popup"
	};
var uploadFileList=[];
var destPath = "";
var interactionId;
var workflowId;
var workflowName;
var wfInputEntryFileUploadMap = {};
var wfStagedFileInputs = [];
var inputFormValidated = false;
var formsSystemParams = {};
var curWfMetaInfo = {};
var selectedTab;
var urlParams;
var currentResp = undefined;
var userInteractionResp = undefined;
var appTableParams = undefined
	var formInputs = {};
var currFormInputs = {};
	var appStudioReqOptions = {
			callType : "PUT",
			contentType : "application/json"
	};

function getCurrentInputForm(){
	return inputForm;
}

function isMultiRowEditForm() {
	return getCurrentInputForm().isMultiRowEditForm != undefined
			&& getCurrentInputForm().isMultiRowEditForm === true;
}

function updateChangedValue(currentInput) { 
	var inputName = currentInput.inputName;
	if(currentInput.controlHidden == undefined || currentInput.controlHidden == false ){
	if(currentInput.controlType === RADIOBUTTON){
		var $selectedRadio = $("input[name=" + inputName + "]:radio:checked");
		if($selectedRadio.length > 0){
				FormOps.updateFormDataForV3Form(inputName, $selectedRadio[0].value);
			} else {
				FormOps.updateFormDataForV3Form(inputName, undefined);
	}

	} else if(currentInput.controlType === CHECKBOX){
			if(currentInput.className === "java.lang.Boolean"){
				FormOps.updateFormDataForV3Form(inputName, $("#"+ inputName).attr("data-value") === "true"?true:false);
			}
			else
			{
		var $selectedCheckboxes =  $("input[name=" + inputName + "]:checkbox:checked");
		if($selectedCheckboxes.length > 0){
			var values = [] ;
			jQuery($selectedCheckboxes).each(function(index) {
				values.push($(this).attr("data-value"));
			});
					FormOps.updateFormDataForV3Form(inputName, values);
			} else {
					FormOps.updateFormDataForV3Form(inputName, undefined);
				}
		}
	} else if((currentInput.controlType === DROPDOWN || currentInput.controlType === LISTBOX) && 
			currentInput.listType && !currentInput.searchable){
		var curVal = $("#" + inputName).val();
		if(curVal!=undefined && curVal!="") {
				FormOps.updateFormDataForV3Form(inputName, $.isArray(curVal) ? curVal : curVal.split(","));
			} else {
				FormOps.updateFormDataForV3Form(inputName, undefined);
	}
 } else if(currentInput.controlType === MULTILINE || currentInput.controlType === LISTBOX || 
 		  (currentInput.controlType === DROPDOWN && !currentInput.searchable) || 
 		  (currentInput.controlType === TEXTBOX && !currentInput.listType)){
			if(currentInput.controlType === DROPDOWN){
				var $selectedVal = $("#" + inputName).find(":selected").val();
				if($selectedVal!=undefined && $selectedVal!="")
				{
					FormOps.updateFormDataForV3Form(inputName, $selectedVal);
				} else {
					FormOps.updateFormDataForV3Form(inputName, undefined);
				}     
			}
			else
			{
		if($("#" + inputName).val()!="") {
					FormOps.updateFormDataForV3Form(inputName, $("#" + inputName).val());
			} else {
					FormOps.updateFormDataForV3Form(inputName, undefined);
				}
			}
	}
}
}

function updateInputEntriesInFormDataFromDOM(){
	var inputEntries = inputForm.inputForm.entries;
	for (var index = 0; index < inputEntries.length; index++) {
		updateChangedValue(inputEntries[index]);
	}
}


function triggerOnChangeEvt(inputName,eventType) { 
	var element = document.getElementById(inputName);
	var event = new Event(eventType, { bubbles: true });
	element.dispatchEvent(event);
}


function addFieldVal(key,value){
	fieldVals.push(cvUtil.createParamString(key,value));
}

function getCurrentResp(){
	return currentResp;
}

function setCurrentResp(curResp){
	currentResp = curResp;
}

function setUserInteractionResp(curUserResp){
	userInteractionResp = curUserResp;
}

function initializeVariables(){
	urlParams = Forms.getUrlParams();
	selectedTab = Forms.getSelectedTab();
}

function initFormsSysParamters() {
	formsSystemParams.userId = $("#curUserId").val();
	formsSystemParams.userName = $("#curUserName").val();
}

function getWorkflowResp() {
	return workflowResp;
}

	function setWorkflowResp(wfResp) {
		workflowResp = wfResp;
	}

function validateInputField(inputField, validate,errorList) {
	if (validate == "true") {
		var isInvalid = false;
		var errorMsg = wf_localMsg.requiredValMsg + " " + getDisplayName(inputField);
		if (inputField.required) {
			var inputVals = $("#" + inputField.inputName).val();
			if (inputField.controlType == LISTBOX) {
				if ($('#' + inputField.inputName + 'Area .listBoxOption.active').length == 0) {
					isInvalid = true;
				}
			} else if (inputField.controlType == DROPDOWN) {
				if (inputField.searchable != undefined && inputField.searchable) {
					inputVals = searchableEntryMap[inputField.inputName]["selectedList"];
				}

				if (inputVals == undefined || inputVals.length == 0) {
					isInvalid = true;
				}
			} else if (inputField.controlType == RADIO) {
				if ($('input:radio[name=' + inputField.inputName + ']:checked').length == 0) {
					isInvalid = true;
				}
			} else if (inputField.controlType == CHECKBOX) {
				if (inputField.inputType != "java.lang.Boolean" &&
						$('input:checkbox[name=' + inputField.inputName + ']:checked').length == 0) {
					isInvalid = true;
				}
			} else if (inputField.controlType == DATE_TIME || inputField.controlType == CALENDAR ||
					inputField.controlType == TIME_PICKER) {
				errorMsg = validateDateTimeControl(inputField, true, true);
				if (errorMsg != undefined) {
					isInvalid = true;
				}
			} else if (inputField.controlType == FILE_PICKER) {
				errorMsg = wf_localMsg.requiredFileMsg + " " + getDisplayName(inputField);
				var noOfFiles = parseInt($.trim($("#" + inputField.inputName + "selectedFilesArea")
						.find(".upload-num-files").html()));
				if (noOfFiles < 1) {
					isInvalid = true;
				}
			} else if (inputVals == undefined || inputVals == null || inputVals == "") {
				isInvalid = true;
			}

			if (isInvalid) {
				showError(errorMsg);
				return false;
			}
		}
	}
	return true;
}



function getHtml(input, templateHTML) {
	if(templateHTML){
	var html = Mustache.to_html(templateHTML, input);
	if (input["doNotTrimSpaces"] == undefined) {
		html = html.replace(/^\s*/mg, '');
	}
	html = $.trim(html);
	html = html.replace(/\n/g, '');
	} else {
		return "";
	}
 
	return html;
}

function isValidData(interactionId, data) {
	if(Forms.isAppTableFormReq())
		return true;
	else if (interactionId && interactionId != "") {
		return data.request != undefined;
	} else {
		return data.container != undefined && data.container.length != 0;
	}
}

function showError(errorMsg) {
	// resizeErrorArea();
	$(".error").show();
	$(".error").html(errorMsg);
	$(".error").attr("title", errorMsg);
}

function addAppropriateListener(currentInput) {
	if (currentInput.controlType == TEXTBOX || currentInput.controlType == DROPDOWN) {
		if ((currentInput.options != undefined && currentInput.options.length > 0) ||
				(currentInput.defaultValues != undefined && currentInput.defaultValues.length > 0)) {
			if (currentInput.listType != undefined && currentInput.listType && !currentInput.searchable &&
					currentInput.controlType == DROPDOWN) {
				$("#" + currentInput.inputName).multiselect({
					height : 100,
					selectedList : 1,
					header : true,
					disable:currentInput.readOnly?true:false,
					// multiple : (currentInput.listType!=undefined &&
					// currentInput.listType)?true:complexEntity?false:true,
					// noneSelectedText:currentInput.listType!=undefined &&
					// currentInput.listType?"Select Options":"Select Option",
					open : function(event, ui) {
						$(".ui-multiselect-checkboxes li:not(.ui-multiselect-optgroup-label)").show();
					},
					close : function(event, ui) {
						// $(".ui-autocomplete").scrollTop(0);
					},
					click : function(event, ui) {
						addUserSelectedOptions($(event.target).attr("id"),false);
					},
					checkAll : function(event, ui) {
						addUserSelectedOptions($(event.target).attr("id"),false);
					}, 
					uncheckAll : function(event, ui) {
						addUserSelectedOptions($(event.target).attr("id"),false);
					}
				}).multiselectfilter({
					filter : function(event, matches) {
						$(matches).each(function() {
							if (this.attributes["value"].value.toUpperCase().indexOf(event.currentTarget.value
									.toUpperCase()) != 0) {
								$(this).parents("li").hide();
							}
						});
					},
				});
				addUserSelectedOptions(	currentInput.inputName,currentInput.readOnly);
			} 
		}
	} 
}

function getAppropriateDefaultDateFormat(option){
	var formatMap = {
			CALENDAR:	"YYYY-MM-DD",
			DATETIME_PICKER:"MM/DD/YYYY hh:mm A",
			TIME_PICKER:"hh:mm A"
	};
 
	return option.showOnlyTime?"hh:mm A":option.showOnlyDate?"YYYY-MM-DD":"MM/DD/YYYY hh:mm A";
}

function getAppropriateDateFormat(option){
	var formatMap = {
			CALENDAR:	"DD/MM/YYYY",
			DATETIME_PICKER:"MM/DD/YYYY hh:mm A",
			TIME_PICKER:"hh:mm A"
	};
 
	return option.showOnlyTime?"hh:mm A":option.showOnlyDate?"MM/DD/YYYY":"MM/DD/YYYY hh:mm A";
}

function getFormattedDefaultValueForDateTime(option,inputVal){

	var formattedVal = "";

	if(inputVal){
		formattedVal = moment(new Date(parseInt(inputVal))).format(getAppropriateDefaultDateFormat(option));
  
	return formattedVal;
	}
}

function getFormattedValueForDateTime(option,inputVal){
	var formattedVal = "";
 
	if(inputVal){
		formattedVal = moment(new Date(parseInt(inputVal))).format(getAppropriateDateFormat(option));
  
	return formattedVal;
	}
}

	function inpurFormCallBack(inputFormJson){
		
		if(inputFormJson.title){
			setModalTitle("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header h4",inputFormJson.title);
		}

		$("#" + wfUtils.constants.FORMS_POPUP_ID + " .close").off("click");
		setModalTooltipTitle("");
		$('#' + wfUtils.constants.FORMS_POPUP_ID + ' .modal-footer').attr("title", "");
		inputForm = inputFormJson;
		displayInputForm("", "", getFormProperties("",inputFormJson));
	}

	function openModalForInputForm(inputFormJson) {
		resetFormVariables(false);
		initializeVariables();
		Forms.initializeV2Form(inpurFormCallBack,inputFormJson);
	}
 
function openModal(wfInfo){

	$("#" + wfUtils.constants.FORMS_POPUP_ID + " .close").off("click");
	setModalTooltipTitle("");
	$('#' + wfUtils.constants.FORMS_POPUP_ID + ' .modal-footer').attr("title","");
 
	if((!wfInfo.isInfoResp || wfInfo.isInfoResp == "false") && (!wfInfo.isPopUpResp || wfInfo.isPopUpResp == "false")){
		var submit = wfInfo.submit ? wfInfo.submit : false;
		 resetFormVariables(submit);
	}

	 initializeVariables();
	 processWorkflowRequest(wfInfo);
}

function closeWarningMessage(callBack,callBackParams) {
  
		$("#" + wfUtils.constants.FORMS_WARNINGMESSAGE_ID).off("hidden.bs.modal").on("hidden.bs.modal", function() {
			if (Forms.isFullPageForm() === false && Forms.isModalOpen()) {
				$("body").addClass("modal-open");
			}
      
			$(this).data('bs.modal', null);
   
			if(callBack)
				callBack(callBackParams);

		});
  
		$("#" + wfUtils.constants.FORMS_WARNINGMESSAGE_ID).modal('hide');
	}

	function showWarningDialog(options, divText, yesCallBack, noCallBack,yesCallBackParams,noCallBackParams) {
			//divText = divText.replace(/</g,"&lt;").replace(/>/g,"&gt;")
			$("#" + wfUtils.constants.FORMS_WARNINGMESSAGE_ID).remove();   
			$(wfUtils.constants.WARNING_DIALOG_TEMPLATE).insertAfter("#" + wfUtils.constants.SEARCHABLE_POPUP_ID);
   
	var $modalBody = $("#" + wfUtils.constants.FORMS_WARNINGMESSAGE_ID + " .modal-body");
	setModalTitle("#" + wfUtils.constants.FORMS_WARNINGMESSAGE_ID + " .modal-header h4",options.title!=undefined && options.title!=""?options.title:"Message");
 
	if(options.onlyOneButton!=undefined && options.onlyOneButton === true)
	{
		$("#warningMsgNoBtn").hide();
	}
	else
		$("#warningMsgNoBtn").show();
 
	if(options.noText!=undefined && options.noText!="")
		$("#warningMsgNoBtn").html(options.noText);
 
	if(options.yesText!=undefined && options.yesText!="")
		$("#warningMsgYesBtn").html(options.yesText);
 
 
	$modalBody.html(divText);
 
	$("#warningMsgNoBtn").off("click").on("click",function(e){
		e.preventDefault();
			closeWarningMessage(noCallBack,noCallBackParams);

/*		if(noCallBack)
				noCallBack(noCallBackParams);*/
	});
 
	$("#warningMsgYesBtn").off("click").on("click",function(e){
		e.preventDefault();
			closeWarningMessage(yesCallBack,yesCallBackParams);

/*		if(yesCallBack)
				yesCallBack(yesCallBackParams);*/

	});
 
		$("#" + wfUtils.constants.FORMS_WARNINGMESSAGE_ID + " .close").off("click").on("click",function(e){  
			e.preventDefault();
			closeWarningMessage(noCallBack,noCallBackParams);
		});
  
	$("#" + wfUtils.constants.FORMS_WARNINGMESSAGE_ID).modal("show");
}

function getDisplayName(inputEntry) {
	if (inputEntry.displayName != undefined && inputEntry.displayName != '') {
		return inputEntry.displayName;
	}
	return inputEntry.inputName;
}

function createAcionButtonRow(inputJSON, actionContainer) {
	var inputEntryHtml = "";
 
	if(inputJSON["addDeleteBtn"]!=undefined && inputJSON["addDeleteBtn"] === true)
		inputEntryHtml += getHtml(inputJSON, templateClass[ACTION_BUTTON_DELETE_CONTROL]);
	else
	inputEntryHtml += getHtml(inputJSON, templateClass[inputJSON["btnType"] == "submit"?ACTION_BUTTON_CONTROL_LABEL:ACTION_BUTTON_CONTROL]);

	$("#"  + wfUtils.constants.FORMS_POPUP_ID + " ." + actionContainer).append(inputEntryHtml);
}

function registerDefaultListenerForActions(listenerToRegister) {
	var actionButtons = getInputActions();
	var noOfActions = (actionButtons != undefined && actionButtons.length > 0) ?actionButtons.length:0;
	var isCustomActions = noOfActions>0 ? true : false;
 
	if(isCustomActions){
		for (var index = 0; index < noOfActions; index++) {
			var currentAction = actionButtons[index];
			if (!$.isEmptyObject(currentAction.name.trim())) {
				listenerToRegister(escapeSpecialSymbolsForId(currentAction.name.trim().replace(/\s+/g, "")));
			}
		}
	}
	else if(enableOnClickInWfForms || Forms.isMultiRowEditForm())
		listenerToRegister("okButton"); 
}

function addListenerForActionButtons(buttonId) {

	//buttonId = buttonId.trim().replace(/\s+/g,"");
	$("#" + buttonId).off("click." + APP_NAMESPACE);
	$("#" + buttonId)
			.on("click." + APP_NAMESPACE,
					function(e) {
						e.preventDefault();
						if(inputFormValidated){
							if(Forms.isV3Form() && (currentResp == undefined || currentResp.respType != respType.INFO_RESP)) { //update form data from physical dom
								console.log(FormOps.getFormData() );
								updateInputEntriesInFormDataFromDOM();        
								console.log("After Applying V3 style form: " + FormOps.getFormData());
							}
				processFormAfterRulesExecution(FormOps.getFormData(), $(this));
						}
					});
}

function isEditRowReqForAppTable(){
	if(Forms.isAppTableFormReq())
	{ 
		if(appTableParams.rowId)
		{
			return true;
		}
	}
	return false;
}

function deleteAppTableRecord(curAppTableParams){
		var url = getAppTableFormUrl(false,curAppTableParams,true);
	unMaskForm();
		cvUtil.loadPage(url, {}, function(data) {
		if (data != undefined) {
			$(".error").html("");
				data = {
						respType : 0,
						response : {
							errorCode : 0 
						}
					};
			currentResp = data;
			parent.currentResp = data;
			workflowResp.respType = data.respType;
			processWorkflowResp(data);
   
			unMaskForm();
			cvUtil.unmask();
		}
	}, function(xhr, ajaxOptions, thrownError) {
		unMaskForm();
		if(Forms.isAppTableFormReq())
		{
			try {
                    showErrorMessages([JSON.parse(xhr.responseText).errorMessage]);
                } catch (e) {
                    showErrorMessages([xhr.responseText]);
                }   
		}
		else
		{
		workflowResp.respMsg = Forms.isAppTableFormReq()?xhr.responseText : wf_localMsg.startFormTimeoutWarning;
		workflowResp.errorCode = 10;
		closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
		}
		}, appStudioReqOptions);
	maskForm();
}

function addRowDeletionListener(){
	if(isEditRowReqForAppTable())
	{
		$("#wfRemoveAppTableRow").off("click." + APP_NAMESPACE);
		$("#wfRemoveAppTableRow")
				.on("click." + APP_NAMESPACE,
						function(e) {
			e.preventDefault();
			Forms.showWarningDialog({title:"Confirm"},"Are you sure you want to delete?",deleteAppTableRecord,undefined,appTableParams,undefined);
		});
	}
}

function getReactForm(interactionId){
	var reactForm; 
 
	if(Forms.isAppTableFormReq())
		reactForm = inputForm.reactForm;
	else if (interactionId != "") {
		var isOpenAction = isCompletedForm() ? false : true;
		reactForm = !isOpenAction ? inputForm.completedForm.reactForm : inputForm.inputForm.reactForm;
	} else {
		reactForm = inputForm.inputForm.reactForm;
	}
 
	if(reactForm)
		return JSON.parse(reactForm);
}

function isCompletedForm(currForm) {
	return currForm?currForm.status === "COMPLETED":inputForm && inputForm.status === "COMPLETED";
}

function getInputActions(interactionId) {
	if(Forms.isAppTableFormReq())
		return inputForm.actions;
	else if(currentResp != undefined && currentResp.respType == respType.INFO_RESP){
		return currentResp.response.actions;
	}
	else if (interactionId != "") {
		var isOpenAction = isCompletedForm() ? false : true;
		if (!isOpenAction) {
			return undefined;
		} else {
			return inputForm.inputForm.actions;
		}
	} else {
		return inputForm.inputForm.actions;
	}
}

function getInputEntries(interactionId) {
	if(Forms.isAppTableFormReq())
		return inputForm.entries;
	else if (interactionId != "") {
		var isOpenAction = isCompletedForm() ? false : true;
		return !isOpenAction ? inputForm.completedForm.entries : inputForm.inputForm.entries;
	} else {
		return inputForm.inputForm.entries;
	}
}

function addStartAndEndTagIfNotPresent(script, tagInfo, endTag) {
	var tempScript = script.trim().replace(/\s+/g, "");
	var startTag = tagInfo.startTag;
	var endTag = tagInfo.endTag;

	if (tempScript.indexOf(startTag) != 0) {
		script = tagInfo.startTag + script;
	}

	if (tempScript.substring(tempScript.length, tempScript.length - endTag.length) != endTag) {
		script += tagInfo.endTag;
	}
	return script;
}

	function removeUserDefinedCss(){
		$("head #wfUserDefinedStyleBlock").remove();
	}
 
function loadUserDefinedScriptAndCss(inputScript, inputStyleSheet) {

		removeUserDefinedCss();
  
	if (inputStyleSheet != undefined && inputStyleSheet.trim() != "") {
		inputStyleSheet = addStartAndEndTagIfNotPresent(DOMPurify.sanitize(inputStyleSheet,{SAFE_FOR_JQUERY: true}), scriptMetaInfo.cssInfo);
		$("head").append(inputStyleSheet);
	}

	if (inputScript != undefined && inputScript.trim() != "") {
		inputScript = addStartAndEndTagIfNotPresent(inputScript, scriptMetaInfo.javaScriptInfo);
		$("head").append(inputScript);
	}
}

function createDefaultActionButton(actionContainer) {
	var inputJSON = {};
	inputJSON["id"] = "okButton";
	inputJSON["name"] = "";
	inputJSON["label"] = wf_localMsg.okButtonLbl;
	inputJSON["validateForm"] = true;
	inputJSON["buttonClass"] = "nonCustomAction";

	createAcionButtonRow(inputJSON, actionContainer);
	addValidationListeners("okButton");
}

function resetForm(){
	var $modal = $("#" + wfUtils.constants.FORMS_POPUP_ID);
  
		try{
			$("#countboxHolder").remove();
			if(interval)
				clearInterval(interval);
   
		}
		catch(e){
   
		}
  
		removeUserDefinedCss();
		$modal.find(".modal-footer").empty().removeClass("disabledActions");
		$modal.find(".modal-body").html('<div class="center"><img src="' + cvUtil.getContextPath() + '/common/img/loader.gif"/></div>');
	setModalTitle("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header h4","");
}

function setModalTooltipTitle(title){
	$('#' + parent.wfUtils.constants.FORMS_POPUP_ID + ' .modal-header h4').attr("title",title);
}

function setModalTitle(container,title){
	if(Forms.isFullPageForm()  && container.indexOf(wfUtils.constants.SEARCHABLE_POPUP_ID) == -1 && container.indexOf(wfUtils.constants.FORMS_WARNINGMESSAGE_ID) == -1 )
		container += " #wfWorkflowTitle";

	title = DOMPurify.sanitize(title,{SAFE_FOR_JQUERY: true});
 
	$(container).html(title).attr("title",title);
}

function getInputParamsEnteredByUser(){
	var parmeterStr = undefined;
	if(!wfUtils.functions.isLMPage()){
		if(currentResp == undefined || currentResp.respType == parent.respType.POPUP_RESP)
		{
	fieldVals = [];
	getInputFormValuesEnteredByUser(undefined,true,true);
			parmeterStr = cvUtil.createParamsString(fieldVals);
	fieldVals = []; 
		}
	}
	return parmeterStr;
}

function closeModal(container){
	cvUtil.unmask();
 
		if (!Forms.isFullPageForm() && isModalOpen()) {
		Forms.onWorkflowCompletion(workflowResp,true);
		//$(container).modal("hide");
}
	else {
		Forms.onWorkflowCompletion(workflowResp,false);
	}
  
}

function resetFormValue(currentInput) {
			formInputs[currentInput.inputName] = null;
}

function updateFormValues(currentInput, isChild, parent) {
	if (isChild) {
		fieldVals.push(cvUtil.createParamString("fieldList", parent));
		fieldVals.push(cvUtil.createParamString(parent + "_child", currentInput.inputName));
	} else {
		fieldVals.push(cvUtil.createParamString("fieldList", currentInput.inputName));
		if (currentInput.controlType == FILE_PICKER) {
			fieldVals.push(cvUtil.createParamString(currentInput.inputName + "_type", "Binary"));
		} else {
			fieldVals.push(cvUtil.createParamString(currentInput.inputName + "_type", currentInput.inputType));
		}

	}
 
	var formData = FormOps.getFormData();
	var inputName = currentInput.inputName;
	var wfId = inputForm.entity ? inputForm.entity.workflowId : 0;
	var currInputVal = [];
	var inputValue = undefined;
	var $topWindow = cvUtil.getTopWindow();

	if (currentInput.controlHidden) {
		var defaultVals = currentInput.defaultValues;
		var formattedStr = "";
		var curDate = undefined;
		if(defaultVals && defaultVals.length > 0){
			if(currentInput.controlType == CALENDAR){
				inputValue = formData[inputName];
				currInputVal.push(inputValue);
				Forms.updateInputEntryVal(wfId, inputName, currInputVal);
				fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputValue));
					formInputs[inputName] = inputValue;
			}
			else if (currentInput.controlType == DATE_TIME || currentInput.controlType == TIME_PICKER) {
				var option = currentInput.controlType == TIME_PICKER?{'showOnlyTime':true}:{};
				inputValue = Math.round(moment(formData[inputName],getAppropriateDateFormat(option)).toDate().getTime()/1000);
				currInputVal.push(inputValue);
				Forms.updateInputEntryVal(wfId, inputName, currInputVal);
				fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputValue));
					formInputs[inputName] = currInputVal;
			}
			else
			{
			if (defaultVals) {
					jQuery.each(defaultVals, function(index) {
						fieldVals.push(cvUtil.createParamString(inputName, this.trim()));
					});
						formInputs[inputName] = defaultVals;
				Forms.updateInputEntryVal(wfId, inputName, defaultVals);
			} else if (currentInput.defaultValue) {
					fieldVals.push(cvUtil.createParamString(inputName, currentInput.defaultValue));
				currInputVal.push(currentInput.defaultValue);
				Forms.updateInputEntryVal(wfId, inputName, currInputVal);
						formInputs[inputName] = currInputVal;
			}
			}
		}
		else
		{
			resetFormValue(currentInput);  
		}
		return;
	}
 
 
	if(formData[inputName]!=undefined){
  
		if(Array.isArray(formData[inputName]) && formData[inputName].length > 0){
			var inputVals = formData[inputName];
			if(currentInput.controlType == FILE_PICKER){
				wfStagedFileInputs.push(currentInput.inputName);

				var defaultFiles = wfInputEntryFileUploadMap[inputName + "_defaultFiles"];
    
				if(defaultFiles && defaultFiles.length > 0){
					formInputs[inputName] = defaultFiles;
				}
				else
					formInputs[inputName] = [];
    
				$(inputVals).each(function(index) {
					var curFile = this;
					FormUploadOps.addNewFile(currentInput, curFile, index);
					if(!Forms.isAppTableFormReq()){
					fieldVals.push(cvUtil
							.createParamString("file" + index + "_" + currentInput.inputName + "_fullDestPath",
									encodeURIComponent(getDestPathOfCurrInput(currentInput.inputName) + "\\" + curFile.name)));
					}
				});
			}
			else if(currentInput.className == "java.util.Date"){
				var opt = {'showOnlyDate':true};
				$(inputVals).each(function(index) {
					inputValue = this.trim()
					fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputValue));
					currInputVal.push(inputValue);
				});
					formInputs[inputName] = currInputVal;
				Forms.updateInputEntryVal(wfId, inputName, currInputVal);
			}
			else if (currentInput.className == "java.util.Calendar" || currentInput.className == "workflow.types.Time") {
				var opt = currentInput.className == "java.util.Calendar"?{}:{'showOnlyTime':true};
				$(inputVals).each(function(index) {
					inputValue = Math.round(moment(this.trim(),getAppropriateDateFormat(opt)).toDate().getTime()/1000);
					fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputValue));
					currInputVal.push(inputValue);
				});
					formInputs[inputName] = currInputVal;
				Forms.updateInputEntryVal(wfId, inputName, currInputVal);
			}
			else{
				if(Forms.isAppTableFormReq()){
					formInputs[inputName] = inputVals.join("\n");
				}
				else
				{
					$(inputVals).each(function(index) {
						if(this!=undefined){
						fieldVals.push(cvUtil.createParamString(inputName, this.trim()));
						currInputVal.push(this.trim());
						}
					});
				}
				Forms.updateInputEntryVal(wfId, inputName, currInputVal);
			}
		}
		else if(currentInput.controlType == CALENDAR){
			inputValue = formData[inputName];
			currInputVal.push(inputValue);
			Forms.updateInputEntryVal(wfId, inputName, currInputVal);
			fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputValue));
				formInputs[inputName] = inputValue;
		}
		else if (currentInput.controlType == DATE_TIME || currentInput.controlType == TIME_PICKER) {
			var option = currentInput.controlType == TIME_PICKER?{'showOnlyTime':true}:{};
			inputValue = Math.round(moment(formData[inputName],getAppropriateDateFormat(option)).toDate().getTime()/1000);
			currInputVal.push(inputValue);
			Forms.updateInputEntryVal(wfId, inputName, currInputVal);
			fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputValue));
				formInputs[inputName] = inputValue;
		}
		else if (currentInput.inputType == "workflow.types.EncryptedString") {
			fieldVals.push(cvUtil.createParamString(inputName + "_reencrypt", true));
			fieldVals.push(cvUtil.createParamString(inputName,Base64.encode($.trim(formData[inputName]))));
				formInputs[inputName] = Base64.encode($.trim(formData[inputName]));
		} 
		else
		{
			if(currentInput.controlType == FILE_PICKER){
				wfStagedFileInputs.push(currentInput.inputName);
				var curFile = formData[inputName];
				FormUploadOps.addNewFile(currentInput, curFile,0);
				if(!Forms.isAppTableFormReq())
				fieldVals.push(cvUtil.createParamString("file" + 0 + "_" + currentInput.inputName + "_fullDestPath",encodeURIComponent(getDestPathOfCurrInput(currentInput.inputName) + "\\" + curFile.name)));
			}
			else
			{
				var inputVal = formData[inputName];
				currInputVal.push(inputVal);
					formInputs[inputName] = inputVal;
				fieldVals.push(cvUtil.createParamString(currentInput.inputName, inputVal));
				Forms.updateInputEntryVal(wfId, inputName, currInputVal);
			}
		}
	} else {
			resetFormValue(currentInput);
	}

	if(Forms.isAppTableFormReq())
	{
		if(currentInput.controlType == FILE_PICKER){
			var defaultFiles = wfInputEntryFileUploadMap[inputName + "_defaultFiles"];
			var inputVals = [];
			if(defaultFiles){
				jQuery.each(defaultFiles, function(key, value) {
					inputVals.push(value);
				});
				formInputs[inputName] = inputVals;
			}
			else
				formInputs[inputName] = [];
		}
	}
}

function validateInputForm(validate) {
	var inputEntries = inputForm.inputForm.entries;
	var errorList = [];
	for (var index = 0; index < inputEntries.length; index++) {
		var currentInput = inputEntries[index];

		if (!validateInputField(currentInput, validate,errorList)) {
			return false;
		}

		if (currentInput.children != undefined && currentInput.children.length > 0) {

			var currentChild;
			for (var childIndex = 0; childIndex < currentInput.children.length; childIndex++) {
				currentChild = currentInput.children[childIndex];

				var isChildVaildated = validateInputField(currentChild, validate,errorList);
				if (!isChildVaildated) {
					return false;
				}
			}
		}
	}
	return true;
}

function setCurrentFormInputs() {
	if(Forms.isMultiRowEditForm()){
		inputFormValidated = true;
		getInputFormValuesEnteredByUser();
		currFormInputs = $.extend(true, {}, formInputs);
		inputFormValidated = false;
		formInputs = {};
	}
}

function getFormValuesEnteredForMultiRowEdit(actionName, validate) {   
	getInputFormValuesEnteredByUser(actionName, validate);
 
	if (Forms.isMultiRowEditForm()) {
    	var fieldMap = FormOps.getForm().state.schema.properties;
    	jQuery.each(fieldMap,function(key,value){
    		if(!isValueChanged(key,currFormInputs,formInputs))
                	delete formInputs[key];
		});
	}
}

function getInputFormValuesEnteredByUser(actionName, validate,getParams) {
	if(inputForm){
	fieldVals.push(cvUtil.createParamString("reactForm",true));
	if (inputFormValidated || (getParams!= undefined && getParams === true)) {
		var inputEntries = Forms.isAppTableFormReq()?inputForm.entries:inputForm.inputForm.entries;
		uploadFileList = [];
		wfStagedFileInputs = [];
		destPath = /* inputForm.inputForm.destPath + "\\" + */Base64.encode(userGUID + new Date().getTime());
		for (var index = 0; index < inputEntries.length; index++) {
			var currentInput = inputEntries[index];

			if (currentInput.children != undefined && currentInput.children.length > 0) {

				var currentChild;
				for (var childIndex = 0; childIndex < currentInput.children.length; childIndex++) {
					currentChild = currentInput.children[childIndex];
					updateFormValues(currentChild, true, currentInput.inputName);
				}
			} else {
				updateFormValues(currentInput, false, undefined);
			}
		}
		fieldVals.push(cvUtil.createParamString("actionName", actionName));
	}
}
}

function getFormObject(interactionId, data) {
	if(Forms.isAppTableFormReq())
		return data;
	else if (interactionId && interactionId != "") {
		return data.request;
	} else {
		return data.container[0];
	}
}

function displayInputForm(description, interactionId, formProps) {
 
	if(!formProps)
		formProps = {};

	formProps.layoutInfo = formProps.layoutInfo && formProps.layoutInfo!="" ?JSON.parse(formProps.layoutInfo):undefined;
	Forms.updateAppStudioUrlParams(Forms.getCurrentInputForm());
	Forms.addFormCloseListener();
 
		addFormCustomizationLink();
  
	var showAsFullPageForm = Forms.isFullPageForm(); 

	if(showAsFullPageForm)
		resizeDialog(formProps,false,true);
	else
	resizeDialog(formProps);

	Forms.checkWindowLocation();

	var inputEntries = getInputEntries(interactionId);
	var entriesToDisplay = [];
 
	var reactForm = getReactForm(interactionId);
	var formData = reactForm.formData;
	var schemaProps = reactForm.schema.properties; 
 
	if(formProps.layoutInfo){
		if(formProps.layoutInfo.fieldOrderInfo && formProps.layoutInfo.fieldOrderInfo.defaultOrder === false){
			var order = formProps.layoutInfo.fieldOrderInfo.order;
			if(order){
				for(var i= 0 ; i<order.length;i++){
					if(schemaProps[order[i]]){
						var currField = $.extend(true,{},schemaProps[order[i]]);
						delete schemaProps[order[i]];
						schemaProps[order[i]] = currField;
					}
				}
			}
		}
  
		if(Forms.isPreviewInputForm() || !Forms.isAppTableFormReq())
		{
			if(formProps.layoutInfo && formProps.layoutInfo.hiddenInfo && !$.isEmptyObject(formProps.layoutInfo.hiddenInfo)){
				var hiddenInfo =  formProps.layoutInfo.hiddenInfo;
				var entriesToDisplay  = [];
				for(var index = 0 ; index<inputEntries.length;index++){
					var curEntry = inputEntries[index].name;
					if(hiddenInfo[curEntry]!=undefined && hiddenInfo[curEntry] === true){
						delete reactForm.schema.properties[curEntry];
						delete reactForm.uiSchema[curEntry];
						delete reactForm.formData[curEntry];
						reactForm.schema.required.splice(reactForm.schema.required.indexOf(curEntry),1)
					}
					else
						entriesToDisplay.push(inputEntries[index]);
				}
				inputEntries = entriesToDisplay;
			}
		}
	}

	if(reactForm.schema.properties["choose_runNow"]){
	delete reactForm.schema.properties["choose_runNow"].enum;
	delete reactForm.schema.properties["choose_runNow"].enumNames;
	} 
 
	var currentInput = undefined;
	controlToFocus = undefined;
 
	if(Forms.isReadOnlyForm()){
		for (var index = 0; index < inputEntries.length; index++) {
			currentInput = inputEntries[index];
			reactForm.uiSchema[currentInput.inputName]["ui:readonly"] = true;
		}
	}
	else
	{
	for (var index = 0; index < inputEntries.length; index++) {
		currentInput = inputEntries[index];
				var inputEntryName = currentInput.inputName && currentInput.inputName.trim()!=""?currentInput.inputName.trim():currentInput.name;

				if (isDataSetRequest(currentInput)) {
				var optionsJsonArr = reactForm.schema.properties[inputEntryName]["optionsJsonArr"];
				if(optionsJsonArr && optionsJsonArr!="")
				{
					optionsJsonArr = JSON.parse(optionsJsonArr);
					reactForm.schema.properties[inputEntryName]["optionsJsonArr"] = optionsJsonArr;
					var totalRecords = optionsJsonArr.totalRecordCount!=undefined?optionsJsonArr.totalRecordCount:0
					if(totalRecords > maxOptionsInWFDropDown ){
						reactForm.uiSchema[inputEntryName]["ui:field"] = "Searchable";
						currentInput.searchable = true;      
					}

				}
		}

		if(currentInput.listType && Forms.isAppTableFormReq() && wfUtils.functions.isMobileDevice()){
			reactForm.uiSchema[inputEntryName]["ui:field"] = "MultiSelect";
		}

		if(reactForm.uiSchema[inputEntryName]["ui:focus"]!= undefined && reactForm.uiSchema[inputEntryName]["ui:focus"] === true)
			controlToFocus = inputEntryName;
    
		if(!currentInput.controlHidden){
			if(currentInput.listType && currentInput.inputType != "java.lang.Boolean" && reactForm.formData && !reactForm.formData[inputEntryName])
				reactForm.formData[inputEntryName] = undefined; 
    
				if(currentInput.searchable){
				reactForm.schema.properties[inputEntryName]["customProps"] = {};
				reactForm.schema.properties[inputEntryName]["customProps"] = currentInput;
				}
			}
  
		if(isDateTimeField(currentInput.controlType,currentInput.className) && formData[inputEntryName]){
			var vals = formData[inputEntryName];
			var updatedVals = undefined;

			if(currentInput.inputType != "java.util.Date"){
			var formattedVal = undefined;

			if(Array.isArray(vals)){
				updatedVals = [];
				var nofVals = vals.length;
				for(var i = 0;i<nofVals;i++){
					updatedVals.push(getFormattedDefaultValueForDateTime(reactForm.uiSchema[inputEntryName],vals[i]));
				}
			}
			else
			{
				updatedVals = getFormattedDefaultValueForDateTime(reactForm.uiSchema[inputEntryName],vals);
			}
		}
		else {
				if(Array.isArray(vals)){
					updatedVals = [];
					var nofVals = vals.length;
					for(var i = 0;i<nofVals;i++){
						if(vals[i].indexOf("T")!=-1)
							updatedVals.push(moment(vals[i],'YYYY-MM-DDThh:mm:ssZ').format('YYYY-MM-DD'));
						else
							updatedVals.push(vals[i]);
					}
				} 
				else
				{
					updatedVals = vals.indexOf("T")!=-1?moment(vals,"YYYY-MM-DDThh:mm:ssZ").format("YYYY-MM-DD"):vals;
				}
		}
  
		formData[inputEntryName] = updatedVals;
		}
  
		if(currentInput.controlType == FILE_PICKER){
			var defaultFiles = reactForm.schema.properties[inputEntryName]["defaultFiles"];
			if(defaultFiles && defaultFiles!=""){
				try{ 
					reactForm.schema.properties[inputEntryName]["defaultFiles"] = JSON.parse(defaultFiles);
					if(reactForm.schema.properties[inputEntryName]["defaultFiles"] == undefined || reactForm.schema.properties[inputEntryName]["defaultFiles"].length == 0)
							reactForm.formData[inputEntryName] = undefined;
				}
				catch(e){
					reactForm.schema.properties[inputEntryName]["defaultFiles"] = [];
				}

			}
			else
				reactForm.schema.properties[inputEntryName]["defaultFiles"] = [];
   
		}
	}
	}
 
	cvUtil.unmask();
		cvUtil.unmask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
 
	if(urlParams.showAsModal && !showAsFullPageForm)
	{
		  $("#" + wfUtils.constants.FORMS_POPUP_ID).modal("show");  
	}
   
	FormOps.renderForm(reactForm,!showAsFullPageForm);

	if(showAsFullPageForm)
	{
		  $(".wfFullPageForm").removeClass("active");  
	}  

	//var controlToFocus = Forms.getControlToFocus();
/*	if (controlToFocus) {
		setTimeout(function() {$("#" + controlToFocus).focus();},100);
	}*/

	var inputEntryName = undefined;

	FormUploadOps.addFilePreventListeners();
}

function getFormProperties(interactionId,currForm) {
	if(Forms.isAppTableFormReq())
			return currForm ? currForm.properties : inputForm.properties;
	else if(currentResp != undefined && currentResp.respType == respType.INFO_RESP){
			if(currForm!=undefined)
				return currForm.inputForm.properties;
		return currentResp.response.properties;
	}
	else{
	var currentForm = currForm?currForm:inputForm;
	if (interactionId != "") {
		var isOpenAction = isCompletedForm(currForm) ? false : true;
		if (isOpenAction) {
			return currentForm.inputForm != undefined ? currentForm.inputForm.properties : undefined;
		} else {
			return currentForm.completedForm != undefined ? currentForm.completedForm.properties : undefined;
		}
	} else {
		return currentForm.inputForm != undefined ? currentForm.inputForm.properties : undefined;
	}
}
}

function clearInfoResponseParams() {
	var interactionParams = $.extend(true, {}, currentResp);
	interactionParams.response.message = "";
	interactionParams.title = "";
	interactionParams.html = "";
	interactionParams.response.properties = "";
	return interactionParams;
}

function clearUserInteractionParams() {
	var interactionParams = $.extend(true, {}, userInteractionResp);
	interactionParams = interactionParams.request;
	interactionParams.inputForm = "";
	interactionParams.description = "";
	interactionParams.title = "";
	interactionParams.completedForm = "";
	return interactionParams;
}

function clearPopUpResponseParams() {
		var interactionParam = {};
		if(currentResp){
			interactionParam = $.extend(true, {}, currentResp);
	interactionParam.response.subject = "";
	interactionParam.response.description = "";
	interactionParam.response.inputForm = "";
		}
	return interactionParam;
}

function resizeDialog(formProps,displayResizableOption,renderAsBrowserScroll) {
	var $modalBody = $("#wfFormsPopup").find(".modal-body").eq(0);
	var $modalContent = $("#wfFormsPopup").find(".modal-content").eq(0);

	$modalBody.removeClass("customSizeForModalBody");
	$modalBody.removeClass("browserScrollModal");
	$modalContent.removeClass("browserScrollModal");
 
	if(!wfUtils.functions.isMobileDevice()){
		if(renderAsBrowserScroll){
			renderAsBrowserScrollModal($modalBody,$modalContent);
		}
		else if(!$.isEmptyObject(formProps) && formProps.width && formProps.height)
		{
			renderAsCustomSizeModal($modalBody,$modalContent,formProps);
		}
		else if(defaultFormWidth && defaultFormHeight){
			var defaultProps = {"width" : defaultFormWidth, "height" : defaultFormHeight};
			renderAsCustomSizeModal($modalBody,$modalContent,defaultProps);
		}
		else
		{
			renderAsBrowserScrollModal($modalBody,$modalContent);
		}
	}
	else
	{
		renderAsBrowserScrollModal($modalBody,$modalContent);
	}
}

function renderAsCustomSizeModal($modalBody,$modalContent,formProps,displayResizableOption){
	if(displayResizableOption && displayResizableOption == false) 
		$("#wfFormsPopup").find(".ui-resizable-handle").hide();
	else
	$("#wfFormsPopup").find(".ui-resizable-handle").show();
 
	$modalBody.css("width","auto");
	$modalContent.css("width",formProps.width + "px");
	$modalBody.css("height",formProps.height + "px");
	$modalContent.css("height","auto");
	$modalBody.addClass("customSizeForModalBody");
}

function renderAsBrowserScrollModal($modalBody,$modalContent){
	$("#wfFormsPopup").find(".ui-resizable-handle").hide();
	$modalBody.addClass("browserScrollModal");
	$modalContent.addClass("browserScrollModal");
}

function isModalOpen(container){
 
	if(container == undefined)
		container = wfUtils.constants.FORMS_POPUP_ID;
 
	return $("#" + container).data()!=undefined && $("#" + container).data()['bs.modal']!=null && (($("#" + container).data()['bs.modal']._isShown!=null && $("#" + container).data()['bs.modal']._isShown === true) || ($("#" + container).data()['bs.modal'].isShown!=null && $("#" + container).data()['bs.modal'].isShown === true));
}


function canShowCustomizeLink(){
	var $currInputForm = Forms.getCurrentInputForm();
	return System.additionalSettings.Console.showCustomizeThisFormLink === true || ($currInputForm.canEdit != undefined && $currInputForm.canEdit == true) || ($currInputForm.inputForm && $currInputForm.inputForm.canEdit!=undefined && $currInputForm.inputForm.canEdit === true);
}

function showCustomizeArea(){
		var $modalHeaderArea = $("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header #modalHeaderArea")
		$modalHeaderArea.addClass("customizeActive");
		$modalHeaderArea.siblings("hr").addClass("customizeActive");
}

function hideCustomizeArea(){
		var $modalHeaderArea = $("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header #modalHeaderArea")
		$modalHeaderArea.removeClass("customizeActive");
		$modalHeaderArea.siblings("hr").removeClass("customizeActive");
}

function hideCustomizeAreaWithDom(){
	$("#wfCustomizeThisForm").remove();
	hideCustomizeArea();
}

	function addFormCustomizationLink(){
 
		var linkValid = true;
   
		if(!System.additionalSettings)
			System.additionalSettings = {};
  
		if(!System.additionalSettings.Console)
			System.additionalSettings.Console = {};
    
		if(System.additionalSettings.Console.showCustomizeThisFormLink == undefined)  
			System.additionalSettings.Console.showCustomizeThisFormLink = false;

		if(Forms.isPreviewInputForm())
		{
			var link = '<div id="wfBackToCustomize"><a href="#">Back to customize</a><br></div>';
			$("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header").prepend(link);
			$("#wfBackToCustomize").off("click").on("click",function(event){
				event.preventDefault();
				Forms.hideTargetFullPageForm();
			});
			showCustomizeArea();
		}
		else
		{   
		if(canShowCustomizeLink())
		{
			var link = '<div id="wfCustomizeThisForm"><a href="';
			if(Forms.isAppTableFormReq())
			{
				var $currInputForm = Forms.getCurrentInputForm();
				link += '/adminconsole/#/tables/';
				if(appTableParams.tableId)
				{
					link += appTableParams.tableId + '/forms/';
     
					if($currInputForm.formId)
						link += $currInputForm.formId + '/customize'; 
					else
						linkValid = false;
				}
				else
					linkValid = false;
			}
			else
			{
				if(wfUtils.functions.isAdminConsole())
					link += '/webconsole';
				else
					link += cvUtil.getContextPath();
     
				link += '/forms/customize/?workflowId=';
     
				$("#" + wfUtils.constants.FORMS_POPUP_ID + " #wfCustomizeThisForm").remove();
				var $currInputForm = Forms.getCurrentInputForm();
    
    
				if($currInputForm.entity && $currInputForm.entity.workflowId){
					link += $currInputForm.entity.workflowId;
				}
				else if($currInputForm.workflow && $currInputForm.workflow.workflowId){
					link += $currInputForm.workflow.workflowId;
				}
    
				if($currInputForm.inputForm.activity)
				{
					link += '&activity=' + $currInputForm.inputForm.activity;
				}
    
			}
   
			link += '" target="_blank"> Customize this form </a>';
			link += "<br></div>";
   
			if(linkValid)
			{    
					$("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header").prepend(link);
					showCustomizeArea();
			}
			else
				hideCustomizeArea();
		}
		else{
			hideCustomizeArea();
		}
		}
	}

function processWorkflowResp(data) {
	$("#inputcontainer").removeClass("infoMessage");
	$(".modal-backdrop.fade.in").blur();
	workflowResp.respType = data.respType;
	workflowResp.outputParams = data || {};
	if (data.respType == respType.GENERIC_RESP) {
		workflowResp.respMsg = data.response.errorMessage;
		workflowResp.errorCode = data.response.errorCode;
		closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
	} else if (data.respType == respType.START_WORKFLOW_RESP) {
		workflowResp.respMsg = "";
		workflowResp.errorCode = 0;
		closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
	} else if (data.respType == respType.POPUP_RESP) {
			$("#wfModalFooter .btn").focus();
	 	workflowResp["respMsg"] = '';
	 	workflowResp["errorCode"] = undefined;
		var title = wf_localMsg.popUpInputRespTitle;
		if (data.response.subject != undefined && data.response.subject != "") {
			title = data.response.subject;
		}
		setModalTitle("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header h4",title);
		inputForm = data.response;
		displayInputForm(data.response.description, "", getFormProperties(""));
	} else if (data.respType == respType.INFO_RESP) {
	 	workflowResp["respMsg"] = '';
	 	workflowResp["errorCode"] = undefined;
		var title = data.response.title;
		if (title == undefined || title == "") {
			title = wf_localMsg.infoRespTitle;
		}
		Forms.addFormCloseListener();
		if (data.response.dialogType == dialogType.POPUP_DIALOGTYPE) {
				$("#wfModalFooter .btn").focus();
			inputForm = data.response;
			var reactForm = {}; 
			reactForm = data.response.reactForm?JSON.parse(data.response.reactForm):{};
			setModalTitle("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header h4",title);
			var showAsFullPageForm = Forms.isFullPageForm();
			if(urlParams.showAsModal && !showAsFullPageForm)
			{
			if(!isModalOpen()){
					  cvUtil.unmask();
					  $("#" + wfUtils.constants.FORMS_POPUP_ID).modal("show");  
				}
			}
  
		if(showAsFullPageForm)
			resizeDialog({},false,true);
		else
			resizeDialog(data.response.properties)

			FormOps.renderInfoMessage(data.response.message,reactForm);
  
		if(showAsFullPageForm)
		{
			  $(".wfFullPageForm").removeClass("active");  
		}
  
		} else {
			if(wfUtils.functions.isAdminConsole()){
				cvUtil.notify("notificationTemplateInfo", {
					text : title + "<br><br>" + data.response.message,
					data : undefined
					}, 2500,
				    false,undefined, undefined);
			}
			else {
			cvUtil.toast(title + "<br><br>" + data.response.message);
			}
			var interactionParams = clearInfoResponseParams();
			fieldVals = [];
			fieldVals.push(cvUtil.createParamString("interactionParams", JSON.stringify(interactionParams)));
			fieldVals.push(cvUtil.createParamString("timeOffset", new Date().getTimezoneOffset()));
			var inputParams = cvUtil.createParamsString(fieldVals);
			var url = wfUtils.functions.getURL(true);
			CheckIfUploadAndStartActivity(url, inputParams);
		}
	} else if (data.respType == respType.END_USER_RESP) {
		workflowResp.errorCode = undefined;
		closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
	} else {
		workflowResp.respMsg = data.errorMessage;
		workflowResp.errorCode = data.errorCode;
		closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
	}
}

function startActivity(url, inputParams) {
 
		var isAppTableReq = Forms.isAppTableFormReq();

		if(!isAppTableReq){
	var reactParam = cvUtil.createParamString("reactForm",true);
   
	if(inputParams!="")
		inputParams += "&" + reactParam;
	else
		inputParams = reactParam;
 
		}

	var ajaxOptions = wfUtils.functions.getAjaxTimeOut();
	ajaxOptions["headers"] = {
		"Accept-Language" : cvUtil.readCookie('locale')
	}
	unMaskForm();
	cvUtil.loadPage(url, inputParams, function(data) {
		if (data != undefined) {
				if(isAppTableReq){
					data = {
						respType : 0,
						response : {
							errorCode : 0 
						}
					};
				}
				else
				{
			currentResp = data;
			parent.currentResp = data;
			workflowResp.respType = data.respType;
				}
				$(".error").html("");
			processWorkflowResp(data);
			}
			unMaskForm();
	}, function(xhr, ajaxOptions, thrownError) {
			unMaskForm();
			if(isAppTableReq){
				try{
					showErrorMessages([JSON.parse(xhr.responseText).errorMessage]);
				}
				catch(e){
					showErrorMessages([xhr.responseText]);
				}
			}
			else{
				workflowResp.respMsg = wf_localMsg.startFormTimeoutWarning;  
		workflowResp.errorCode = 10;
			if(Forms.isModalOpen() == true)
				initializeV2ErrorCallBack();
			else
				Forms.initializeV2Form(initializeV2ErrorCallBack);
			}
			//closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
		}, isAppTableReq?appStudioReqOptions:ajaxOptions);
	maskForm();
}

function getDestPathOfCurrInput(inputName) {
	return destPath + "_" + inputName;
}

function maskForm(){
	if(Forms.isFullPageForm()){
		if(Forms.isTargetDivFullPageForm()){
			var $ele = Forms.getTargetContainerForFullPage();
			if($ele!=undefined && $ele.length > 0 )
				$ele.find("#wfFormsPopup").mask(" ");
			else
				cvUtil.mask();
		}
		else if(wfUtils.functions.isAdminConsole())
			$("#wfFormsPopup").mask(" ");
		else
		    cvUtil.mask();  
		Forms.showMobileViewSpinner();
  
	}
	else
		$(".modal-content").mask(" ");
}

function unMaskForm(){
	if(Forms.isFullPageForm()){
		if(Forms.isTargetDivFullPageForm()){
			var $ele = Forms.getTargetContainerForFullPage();
			if($ele!=undefined && $ele.length > 0 )
				$ele.find("#wfFormsPopup").unmask(" ");
			else
				cvUtil.unmask();
		}
		else if(wfUtils.functions.isAdminConsole())
			$("#wfFormsPopup").unmask(" ");
		else
		cvUtil.unmask();
	}
	else
	$(".modal-content").unmask(" ");
	cvUtil.unmask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
}

function addFilesToUploader(uploader,files,curDestPath,inputName){
	var uploadQueryParams = {};
 
	if(Forms.isAppTableFormReq()) {
		var inputEntryPropertiesStr = FormOps.getInputEntryProperties(inputName);
		if(inputEntryPropertiesStr && inputEntryPropertiesStr!=""){
			var inputEntryProperties = JSON.parse(inputEntryPropertiesStr);
			//var inputEntryProperties = inputEntryPropertiesStr;
			var uploadMetaInfo = inputEntryProperties.uploadMetaInfo
			if(uploadMetaInfo){
				uploadQueryParams["appStudioUploadUrl"] = uploadMetaInfo.url;
				if(uploadMetaInfo.postParams){
					jQuery.each(uploadMetaInfo.postParams, function(key, value) {
						uploadQueryParams[key] = value;
					});
					if(uploadQueryParams["actualFilePath"])
						uploadQueryParams["actualFilePath"] += "/" + inputForm.destPath;
				}
			}
		}
	}
	else
	{
	uploadQueryParams["destPath"] = curDestPath;
	uploadQueryParams["wfDestFolderName"] = curDestPath;
	uploadQueryParams["wfWorkflowId"] = curWfMetaInfo.workflowId;
	uploadQueryParams["wfWorkflowName"] = curWfMetaInfo.workflowName;
	uploadQueryParams["wfJobId"] = inputForm.jobId;
	uploadQueryParams["wfEngineClientId"] = inputForm.client.clientId;
	}
 
	var currentBatch = uploader.getBatch(true);
	var uploadBatchInfo = uploader.uploadBatch[currentBatch];
	uploadBatchInfo.setBatchOption("query", uploadQueryParams);
 
	uploader.prepareFileForUpload(files,currentBatch);
}


function initializeAndGetUploader(url, inputParams,fileNameToIdMap,wfInputToFileNameMap) {
 
	var uploadErrorMsg = wf_localMsg.wfFileUploadError;

	var uploaderConfig = {}
 
	if(Forms.isAppTableFormReq()){
		uploaderConfig = {
			target : 'appStudioUploadHandler.do',
		minFileSize : 1,
			encodeFileName : false,
			sendFileIdAsName : false
		};
	}
	else
	{
		uploaderConfig = {
			target : 'forms/workflowUploadHandler.do',
			minFileSize : 1,
			encodeFileName : true
		};
	}
 
	var uploader = new Uploader(uploaderConfig);
 
	var isNewUploaderSupported = uploader != null && uploader.isSupported();
	var continueUpload = true;

	if (isNewUploaderSupported) {
    
		uploader.onEvent(uploader.EventEnum.FILE_ADDED, function(fileItem) {
			fileNameToIdMap[fileItem.fileName] = {
				name : fileItem.fileName,
				size : fileItem.fileSize
			}
			console.log(fileNameToIdMap);
		});
  
		uploader.onEvent(uploader.EventEnum.FILE_ADD_ERROR, function(fileItem) {
			showErrorMessages([fileItem.fileName + " : " + fileItem.error.message]);
			$(".modal-dialog").unmask(" ");
		});

		uploader.onEvent(uploader.EventEnum.FILE_UPLOAD_ERROR, function(fileItem) {
			uploadFileList = [];
			wfStagedFileInputs = [];
			showErrorMessages([uploadErrorMsg]);
			$(".modal-dialog").unmask(" ");
			continueUpload = false;
		});
  
		uploader.onEvent(uploader.EventEnum.UPLOAD_END, function(fileItem) {
 
		if(continueUpload === true){
			uploadFileList = [];
			wfStagedFileInputs = [];
   
			if(Forms.isAppTableFormReq()){
				var currFileInfo = {};
				var curInputVals = [];   
				var currentInputFiles  = [];
				var inputParamsJSON = JSON.parse(inputParams);
    
				if(wfInputToFileNameMap){
     
					jQuery.each(wfInputToFileNameMap,function(key,value){
						curInputVals = [];
						currentInputFiles = value;
						if(currentInputFiles && currentInputFiles.length > 0){
							/*if(currentInputFiles.length  == 1){
								curInputVals.push(fileNameToIdMap[currentInputFiles[0]]);
							}
							else
							{*/      
								for(var index=0;index<currentInputFiles.length;index++){
									curInputVals.push(fileNameToIdMap[currentInputFiles[index]]);
								}
							//}
						}
      
						if(!inputParamsJSON[key])
							inputParamsJSON[key] = [];
      
						inputParamsJSON[key] = inputParamsJSON[key].concat(curInputVals);
					});
				}
				inputParams = JSON.stringify(inputParamsJSON);
			}
			startActivity(url, inputParams);
		}
		});

  
		uploader.onEvent(uploader.EventEnum.FILE_UPLOAD_ERROR, function(fileItem) {
			continueUpload = false;
			unMaskForm();
			showErrorMessages([fileItem.fileName + "( Failed to upload , Error Message : " + fileItem.error.message + ")"]);
		});
	}
 
	return uploader;
}

function startUpload(url, inputParams) {
	unMaskForm();
 
	var wfStagedIndex = 0;
	var canStartUpload = false;
 
	if(!System.additionalSettings)
		System.additionalSettings = {};
 
	if(!System.additionalSettings.Console)
		System.additionalSettings.Console = {};
   
	if(System.additionalSettings.Console.useNewUploadForWorkflows == undefined)  
		System.additionalSettings.Console.useNewUploadForWorkflows = false;
 
	if(System.additionalSettings.Console.useNewUploadForWorkflows || wfUtils.functions.isAdminConsole()){
		var wfInputToFileNameMap = {};
		var fileNameToIdMap = {};
  
		var uploader = initializeAndGetUploader(url, inputParams,fileNameToIdMap,wfInputToFileNameMap);
  
		if (wfStagedFileInputs.length > 0 && !$.isEmptyObject(wfInputEntryFileUploadMap)) {
			jQuery.each(wfStagedFileInputs, function(index) {
				var curInput = this.trim();
				var curInputFileMap = wfInputEntryFileUploadMap[curInput];
				var curInputDefaultFileMap = wfInputEntryFileUploadMap[curInput + "_defaultFiles"];
				var curDestPath = getDestPathOfCurrInput(curInput);
				var fileNames = [];
    
				if (!$.isEmptyObject(curInputFileMap)) {
					var curBatchFiles = [];
					jQuery.each(curInputFileMap, function(key, value) {
						curBatchFiles.push(value);
						fileNames.push(value.name);
					});
					wfInputToFileNameMap[curInput] = fileNames;
					canStartUpload = true;
					addFilesToUploader(uploader,curBatchFiles,curDestPath,curInput);
				}
    
				/*if (!$.isEmptyObject(curInputDefaultFileMap)) {
					jQuery.each(curInputDefaultFileMap, function(key, value) {      
						fileNames.push(value.name);
					});
					wfInputToFileNameMap[curInput] = fileNames;
					//addFilesToUploader(uploader,curBatchFiles,curDestPath,curInput);
				}*/        
			});
			if(canStartUpload)
				uploader.startUpload();
		}
	}
	else
	{
	var contentDiv = document.createElement("DIV");
	$(contentDiv).load(cvUtil.getContextPath() + "/logMonitoring/uploadForm.jsp", function() {

		$(contentDiv).find(".uploadInProgress").show();
		$(".uploadProgress").prepend($(contentDiv).find(".uploadFileDiv"));
		var formData = new FormData();
		formData.append("clientId", inputForm.client.clientId);
		formData.append("incompatibleBrowser", false);

		if (wfStagedFileInputs.length > 0 && !$.isEmptyObject(wfInputEntryFileUploadMap)) {
			jQuery.each(wfStagedFileInputs, function(index) {
				var curInput = this.trim();
				var curInputFileMap = wfInputEntryFileUploadMap[curInput];
				//var fullPath = inputForm.inputForm.destPath + "\\" + getDestPathOfCurrInput(curInput);
				var curDestPath = getDestPathOfCurrInput(curInput);
				if (!$.isEmptyObject(curInputFileMap)) {
					jQuery.each(curInputFileMap, function(key, value) {
						var file = value;
						formData.append("destPath", curDestPath);
						formData.append("isFile", true);
						formData.append("fileSize", file.size);
						formData.append("isWorkflowUpload", true);
						formData.append("wfEncodedFileName", encodeURIComponent(file.name));
						formData.append("wfDestFolderName", curDestPath);
						formData.append("wfWorkflowId", curWfMetaInfo.workflowId);
						formData.append("wfWorkflowName", curWfMetaInfo.workflowName);
						formData.append("wfJobId", inputForm.jobId);
						formData.append("wfEngineClientId", inputForm.client.clientId);

						formData.append('file', file);
					});
				}
			});
		}

		var uploadErrorMsg = wf_localMsg.wfFileUploadError;

		window.setTimeout(function() {
			var ajaxId = $.ajax({
				url : 'uploadFile.do',
				type : 'POST',
				data : formData,
				async : true,
				success : function(dataResult) {
					var returnedItems = JSON.parse(dataResult);
					var returnCode = returnedItems.returnCode;
					if (returnCode == "Error") {
						var errorList = [];
						errorList.push(uploadErrorMsg);
						FormOps.showErrorMessages(errorList);
						unMaskForm();
					} else {
						uploadFileList = [];
						wfStagedFileInputs = [];
						//wfInputEntryFileUploadMap = {};
						startActivity(url, inputParams);
					}
				},
				error : function(xhr, ajaxOptions, thrownError) {
					var errorList = [];
					errorList.push(uploadErrorMsg);
					FormOps.showErrorMessages(errorList);
					$(".modal-dialog").unmask(" ");
				},
				cache : false,
				contentType : false,
				processData : false,
				timeout : wfReqTimeOut ? wfReqTimeOut : 630000
			});
		}, 100);
	});
	}
	maskForm();
}

function CheckIfUploadAndStartActivity(url, inputParams) {
	if (uploadFileList.length > 0) {
		startUpload(url, inputParams);
	} else {
		startActivity(url, inputParams);
	}
}

function addURLForSelectedEntries(currentInputInfo, htmlText) {
	$("#" + currentInputInfo + " .selectedEntries").html(htmlText).show();
	$(".selectedEntries").off("click." + APP_NAMESPACE);
	$(".selectedEntries").on("click." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		e.stopPropagation();
		showSearchableResults($(this).attr("data-input"), "true");
	});
}


function displaySelectedValsForSearchableType(currentInputInfo) {
	var selectedList = searchableEntryMap[currentInputInfo]["selectedList"];
	var selectedSize = selectedList.length;
 
	var optionsMap = searchableEntryMap[currentInputInfo]["optionsMap"];
	var selectedLabels = [];
	var curVal = "";
 
	jQuery.each(selectedList, function(index) {
		curVal = this.trim();
		selectedLabels.push(optionsMap[curVal]?optionsMap[curVal]:curVal);
	});
 
	var htmlText = selectedLabels.join(";");
 
		currentInputInfo = currentInputInfo.replace(/ /g,"\\ ");
 
	if(htmlText && htmlText.trim() !="" )
		$("#" + currentInputInfo + "Parent").attr("title", htmlText);

	if (selectedSize >= 1) {
		addURLForSelectedEntries(currentInputInfo, htmlText);
	} else if (selectedSize == 0) {
		$("#" + currentInputInfo + " .selectedEntries").html("").hide();
	}
}

function updateDefaultValuesForSearchable(_changeCallBackFunc,currentInput,formData,optionsMap){
 
	var curOptionsMap = {};
 
	if(searchableEntryMap[currentInput.inputName])
	{
		curOptionsMap = searchableEntryMap[currentInput.inputName]["optionsMap"];
	}
  
	searchableEntryMap[currentInput.inputName] = $.extend(true, {}, currentInput);
	searchableEntryMap[currentInput.inputName]["selectedList"] = [];
	searchableEntryMap[currentInput.inputName]["_changeCallBackFunc"] =  _changeCallBackFunc;
 
	if(!curOptionsMap)
		curOptionsMap = {};
 
	if(optionsMap)
		curOptionsMap = $.extend({},curOptionsMap,optionsMap);
 
	searchableEntryMap[currentInput.inputName]["optionsMap"] = curOptionsMap;
 
	if(formData){
		var defaultVals =  formData;
		if(Array.isArray(defaultVals)){
			var noOfDefaultVals = defaultVals != undefined && defaultVals.join() != "" ? defaultVals.length : 0;
			if (noOfDefaultVals > 0) {
				searchableEntryMap[currentInput.inputName]["selectedList"] = $.extend([],
						defaultVals);
			}   
		}
		else
		{
			if(defaultVals)
				searchableEntryMap[currentInput.inputName]["selectedList"] .push(defaultVals);
		}
	}

	searchableEntryMap[currentInput.inputName]["unSelectedList"] = [];
	displaySelectedValsForSearchableType(currentInput.inputName); 
 
	$("#" + wfUtils.constants.FORMS_POPUP_ID + " .wfSearchable").off("click." + APP_NAMESPACE).on("click." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		e.stopPropagation();
		showSearchableResults($(this).attr("data-info"), "false");
	});
 
	$("#" + wfUtils.constants.FORMS_POPUP_ID + " .searchableArea").off("click." + APP_NAMESPACE).on("click." + APP_NAMESPACE, function(e) {
		e.preventDefault();
		showSearchableResults($(this).attr("data-info"), "false");
	});

}

function dataSetCallBack(returnedRows,contextInfo){
	console.log(returnedRows);
	console.log(contextInfo);
	var _changeCallBackFunc = searchableEntryMap[contextInfo.name]["_changeCallBackFunc"];
	console.log(_changeCallBackFunc); 
	var processedRows= [];
	if(searchableEntryMap[contextInfo.name].listType !=undefined && searchableEntryMap[contextInfo.name].listType === true){
		for(var i = 0;i<returnedRows.length;i++){
			processedRows.push(returnedRows[i][searchableEntryMap[contextInfo.name].datasetOptions.valueField]);  
		}
	}else{
		processedRows.push(returnedRows[0][searchableEntryMap[contextInfo.name].datasetOptions.valueField]);
	}
 
	if(processedRows && processedRows.length>0)
		$("#" + contextInfo.name + " .overFlowArea").prop("contentEditable","false");

	_changeCallBackFunc(processedRows);
}

function showSearchableResults(currentInputInfo, showSelectedList) {

	if(!wfUtils.functions.isMobileDevice() && System.additionalSettings.Console.useDataSetSearchable === true && searchableEntryMap[currentInputInfo].datasetOptions && showSelectedList == "false"){
		var allowMultiRowSelection = searchableEntryMap[currentInputInfo].listType!=undefined && searchableEntryMap[currentInputInfo].listType === true?true:false;
		openTable({ dataSet : { dataSetName : searchableEntryMap[currentInputInfo].datasetOptions.datasetGuid },"enableMultiRowSelection" : allowMultiRowSelection,callBackFn:dataSetCallBack,"ctxObject":{name:currentInputInfo},sys_rowid_col:searchableEntryMap[currentInputInfo].datasetOptions.valueField,selectedValues:searchableEntryMap[currentInputInfo].selectedList}); 
	}
	else
	{  
	searchableEntryMap[currentInputInfo]["unSelectedList"] = [];
	searchableEntryMap[currentInputInfo]["tempList"] = $.extend([],searchableEntryMap[currentInputInfo]["selectedList"]);
 
	cvUtil.loadPage(cvUtil.getContextPath() + "/forms/reactPaginate.jsp",
			undefined,
			function(data) {
				var $modalBody = $("#" + wfUtils.constants.SEARCHABLE_POPUP_ID + " .modal-body");
				$modalBody.html(data);
				FormSearchableOps.showSearchable(currentInputInfo,showSelectedList);
				$modalBody.scrollTop(0);
				$("#" + wfUtils.constants.SEARCHABLE_POPUP_ID).modal("show");
			});
	}
}

function sumbitInfoMessage(e){
	sumbitThisForm(e);
}

function addValidationListeners(buttonId) {

	// buttonId = buttonId.trim().replace(/\s+/g,"");
	$("#" + buttonId).off("click.validate" + APP_NAMESPACE);
	$("#" + buttonId).on("click.validate" + APP_NAMESPACE, function(e) {
		e.preventDefault();
		if(Forms.isMultiRowEditForm()){
			inputFormValidated = validateMultiRowEditForm();
			if (!inputFormValidated) {
				e.stopImmediatePropagation();
			}
		}
		else
		{
		var validate = $(this).attr("data-validate");
		inputFormValidated = false;
		if (currentResp == undefined || currentResp.respType == respType.POPUP_RESP) {
			if(Forms.isV3Form()){ //update form data from physical dom
				console.log(FormOps.getFormData());
				updateInputEntriesInFormDataFromDOM();        
				console.log(FormOps.getFormData());
			}
			inputFormValidated = validateInputForm(validate);
			if (!inputFormValidated) {
				e.stopImmediatePropagation();
			}
		}
		else if(currentResp!=undefined && currentResp.respType == respType.INFO_RESP)
			inputFormValidated = true;
		}
	});
}

function escapeSpecialSymbolsForId(currentKey) {
	currentKey = currentKey.replace(/#/g, "s1").replace(/!/g, "s2").replace(/@/g, "s3").replace(/\*/g, "s4")
			.replace(/\$/g, "s5").replace(/%/g, "s6").replace(/\^/g, "s7").replace(/&/g, "s8").replace(/\(/g, "s9")
			.replace(/\)/g, "s10").replace(/\[/g, "s11").replace(/]/g, "s12").replace(/{/g, "s13").replace(/}/g, "s14")
			.replace(/\+/g, "s15").replace(/\\/g, "s16").replace(/\|/g, "s17").replace(/'/g, "s18").replace(/\"/g,
					's19').replace(/;/g, "s20").replace(/:/g, "s21").replace(/::/g, "s22").replace(/\?/g, "s23")
			.replace(/\./g, "s24").replace(/</g, "s25").replace(/>/g, "s26").replace(/,/g, "s27").replace(/`/g, "s28")
			.replace(/~/g, "s29").replace(/\=/g, "s30").replace(/\//g, "s31");
	return currentKey;
}

	function submitRulesValidCallBack(param){
		sumbitThisForm(param.event,param.button);
	}

function processForm(e){
	if($("#okButton.disabledActions").length === 0 && $("#okButton").length === 1)
			processFormAfterRulesExecution(e,$("#okButton"));
	}

	function processFormAfterRulesExecution(e,$button){
		var params = {};
		params.button = $button;
		params.event = e;
		Forms.processFormSubmitRules(submitRulesValidCallBack,params);
}

function sumbitThisForm(e,$button){
	inputFormValidated = true;
	var interactionParams = undefined;
	var validate = undefined
	var actionName = undefined;
 
	if($button)
	{
		actionName = $button.attr("data-action");
		validate = $button.attr("data-validate");
	}
	var isValidated = inputFormValidated;
	var inputParams = undefined;
	fieldVals = [];

	if(Forms.getDoNotStartWorkflow()){
		getInputFormValuesEnteredByUser(actionName, validate);
		if (inputFormValidated) {
			workflowResp.respMsg = "";
			workflowResp.errorCode = 0;
			closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
		}
	}
	else if(Forms.isAppTableFormReq()){
		getFormValuesEnteredForMultiRowEdit(actionName, validate);

		if (inputFormValidated) {
				/*fieldVals = [];
			fieldVals.push(cvUtil.createParamString("tableId",appTableParams["tableId"]));
				fieldVals.push(cvUtil.createParamString("rowId", appTableParams["rowId"]));*/
				if(Forms.isAddRecordReq()){
					formInputs["sys_guid"] = cvUtil.generateUUID().replace(/-/g,"");
					inputForm.destPath = formInputs["sys_guid"];
				}
				else {
					formInputs["sys_guid"] = inputForm.destPath;
				}
				inputParams = JSON.stringify(formInputs);
   
			var url = getAppTableFormUrl(true,appTableParams);
			CheckIfUploadAndStartActivity(url, inputParams);
		}
	}
	else if (wfUtils.functions.isLMPage()) {
		getInputFormValuesEnteredByUser(actionName, validate);
		if (inputFormValidated) {
			fieldVals.push(cvUtil.createParamString("workflowId", workflowId));
			workflowResp.wfInputsAdded = true;
			wfInputEntryValMap[workflowId]["inputValStr"] = cvUtil
					.createParamsString(fieldVals);
			closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
		}
	}
	else {
		if (currentResp == undefined) {
			getInputFormValuesEnteredByUser(actionName, validate);

			if (inputFormValidated) {
				if (interactionId && interactionId != "") {
					fieldVals.push(cvUtil.createParamString("interactionId", interactionId));
					// fieldVals.push(cvUtil.createParamString("inputForm",JSON.stringify(inputForm.inputForm)));
					interactionParams = clearUserInteractionParams();

					fieldVals.push(cvUtil.createParamString("interactionParams", JSON
							.stringify(interactionParams)));
				} else {
					fieldVals.push(cvUtil.createParamString("workflowName", workflowName));
					fieldVals.push(cvUtil.createParamString("workflowId", workflowId));
					if (urlParams.wfEngineId && urlParams.wfEngineId != "") {
						fieldVals.push(cvUtil.createParamString("_wfClientId",
								urlParams.wfEngineId));
					} else {
						fieldVals.push(cvUtil.createParamString("_wfClientId",
								inputForm.client.clientId));
						fieldVals.push(cvUtil.createParamString("_wfClientName",
								inputForm.client.clientName));
					}
				}

				fieldVals.push(cvUtil.createParamString("timeOffset", new Date()
						.getTimezoneOffset()));
				inputParams = cvUtil.createParamsString(fieldVals);

				var url = wfUtils.functions.getURL(true);
				CheckIfUploadAndStartActivity(url, inputParams);
			} else {
				console.debug("Input Form Not Completely Entered : ");
			}
		} else if (currentResp.respType == respType.INFO_RESP ||
				currentResp.respType == respType.POPUP_RESP) {
			// params = [];
			if (currentResp.respType == respType.POPUP_RESP) {
				getInputFormValuesEnteredByUser(actionName, validate);
				interactionParams = clearPopUpResponseParams();
			} else {
				interactionParams = clearInfoResponseParams();
				fieldVals.push(cvUtil.createParamString("actionName", actionName));
				inputFormValidated = true;
			}

			if (inputFormValidated) {
				if (urlParams.wfEngineId && urlParams.wfEngineId != "") {
					fieldVals.push(cvUtil.createParamString("_wfClientId",
							urlParams.wfEngineId));
				}
				fieldVals.push(cvUtil.createParamString("interactionParams", JSON
						.stringify(interactionParams)));
				fieldVals.push(cvUtil.createParamString("timeOffset", new Date()
						.getTimezoneOffset()));
				inputParams = cvUtil.createParamsString(fieldVals);
				var url = wfUtils.functions.getURL(true);
				CheckIfUploadAndStartActivity(url, inputParams);
			}
		}
	}
}

function validateThisForm(a,b){
	console.log(a);
	console.log(b);
	alert("validate");
	b["Disk"].addError("Test");
	return b;
}

function setCurrWorkflowMetaInfo(wfEntity) {
	curWfMetaInfo = wfEntity;
}


	function initializeV2ErrorCallBack(){
		closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
	}

	function isCancelRulesExists() {
		var formProps = Forms.getFormProperties(Forms.getInteractionId());

		if (formProps == undefined) {
			return false;
		}

		if (formProps.rules == undefined || formProps.rules.rules == undefined || formProps.rules.rules.length == 0) {
			return false;
		}

		var rules = formProps.rules.rules;
		var cancelRuleExist = false;

		for (var i = 0; i < rules.length; i++) {
			var ruleTriggers = rules[i].ruleTriggers;

			if (rules[i].enabled == true && (ruleTriggers.onFormCancelled != undefined && ruleTriggers.onFormCancelled == true)) {
				cancelRuleExist = true;
				break;
			}
		}
		return cancelRuleExist;
	}

	function initializeV2FormCallBack(data){

		var description = inputForm.description;
		if (selectedTab == wfUtils.constants.ACTION_INDEX) {
			setCurrWorkflowMetaInfo(inputForm.workflow);
			userInteractionResp = data;
				setModalTitle("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header h4",inputForm.subject);
			if (data.errorCode != undefined) {
				workflowResp.respMsg = data.errorMessage;
				workflowResp.errorCode = data.errorCode;
				closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
			} else {
				if (inputForm.status == "NEW") {
					$(".bottom .btns").addClass("btns-absolute");
					displayInputForm(description, interactionId, getFormProperties(interactionId));
				} else if (inputForm.status == "KILLED") {
					workflowResp.respMsg = "";
					workflowResp.errorCode = -4;
					closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
				} else if (inputForm.status == "COMPLETED") {
					displayInputForm(description, interactionId, getFormProperties(interactionId));
				} else if (inputForm.status == "DELETED") {
					workflowResp.respMsg = "";
					workflowResp.errorCode = -1;
					closeModal("#" + wfUtils.constants.FORMS_POPUP_ID);
				}
			}
		} else {
			if(!Forms.isAppTableFormReq()){
			setCurrWorkflowMetaInfo(inputForm.entity);
			workflowName = inputForm.entity.workflowName;
				setModalTitle("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header h4",workflowName != undefined ? workflowName : "");
			}
			else
			{
				var dialogTitle = "Add row";
				if(appTableParams && appTableParams["rowId"])
					dialogTitle = "Edit row";
				setModalTitle("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-header h4",dialogTitle);
			}
			displayInputForm(description, interactionId, getFormProperties(interactionId));
		}
	}

	function getAppTableFormUrl(submit, curAppTableParams,isDeleteRequest) {
		var url = cvUtil.getContextPath();
		if(isDeleteRequest!=undefined && isDeleteRequest === true)
		{
			url += "/proxy/cr/apps/tables";
			url += "/" + curAppTableParams.tableId + "/data";
   
			if(curAppTableParams.rowId)
			{
				url += "/" + curAppTableParams.rowId;
				appStudioReqOptions.callType = "DELETE";
			}
		}
		else
		{
		if(submit == false)
		{
			url += "/server/retrieveAppTableForm.do";
		}
		else
		{
			url += "/proxy/cr/apps/tables";
			url += "/" + curAppTableParams.tableId + "/data";

			if(curAppTableParams.rowId)
			{
				url += "/" + curAppTableParams.rowId;
				appStudioReqOptions.callType = "PUT";
			}
			else
			{
				appStudioReqOptions.callType = "POST";
			}
		}
		}
		return url
	}
 
function processWorkflowRequest(wfInfo) {

	var params = [];
	var isValidated;
	interactionId = wfInfo.interactionId;

	if (wfInfo.selectedTab != undefined) {
		Forms.setSelectedTab(wfInfo.selectedTab);
	}

	var url = wfUtils.functions.getURL(false);
	workflowId = wfInfo.workflowId;
	workflowName = wfInfo.workflowName;
	var subTime = wfInfo.subTime;

	searchableEntryMap = {};

	var submit = wfInfo.submit ? wfInfo.submit : false;

	initFormsSysParamters();

	var isInfoResp = wfInfo.isInfoResp ? wfInfo.isInfoResp : "false";
	var isPopUpResp = wfInfo.isPopUpResp ? wfInfo.isPopUpResp : "false";

	if (submit == true) {
			cvUtil.unmask();
			cvUtil.unmask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
		Forms.setInputParamsForClosedWf(undefined);
		setCurrWorkflowMetaInfo(currentResp.response.workflow);
		urlParams.submit = "";
			Forms.initializeV2Form(processWorkflowResp,currentResp);
	}

	if (submit == "" || submit == false) {
		if (isInfoResp == "false" && isPopUpResp == "false") {
			Forms.setInputParamsForClosedWf(undefined);
			currentResp = undefined;
			userInteractionResp = undefined;

			if (submit == false) {
				params = Forms.getCustomInputParams();
				Forms.setSubmit("");
				Forms.customInputsMap = {};
			}

			params.push(cvUtil.createParamString("workflowId", workflowId));
			params.push(cvUtil.createParamString("workflowName", workflowName));
			params.push(cvUtil.createParamString("interactionId", interactionId));
			// params.push(cvUtil.createParamString("filter", filter));
			params.push(cvUtil.createParamString("timeOffset", new Date().getTimezoneOffset()));
			params.push(cvUtil.createParamString(wfUtils.constants.PARAM_SUBMIT_OPTION, submit));
			params.push(cvUtil.createParamString("reactForm",true));

			if(Forms.isAppTableFormReq()){
				appTableParams = wfInfo["appTableParams"];
    
				params.push(cvUtil.createParamString("tableId",appTableParams["tableId"]));
				params.push(cvUtil.createParamString("rowId",appTableParams["rowId"]));
				params.push(cvUtil.createParamString("formId",appTableParams["formId"]))
    
				url = getAppTableFormUrl(submit,wfInfo["appTableParams"]);
			}
   
			var inputParams = cvUtil.createParamsString(params);

			cvUtil.loadPage(url,
					inputParams,
					function(data) {
						if(Forms.isAppTableFormReq()){
							if(data.errorCode && data.errorCode === 1)
							{
								cvUtil.unmask();
								cvUtil.unmask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
								workflowResp.respMsg = data.errorMsg;
								workflowResp.errorCode = 10;
								if(Forms.isModalOpen() == true)
									initializeV2ErrorCallBack();
								else
									Forms.initializeV2Form(initializeV2ErrorCallBack);
								return;
							}
						} 
      
						if (isValidData(interactionId, data)) {
							inputForm = getFormObject(interactionId, data);
						var props = getFormProperties(interactionId);
      
						var fullPageParameter = Forms["PARAM_SHOW_AS_FULLPAGE_FORM"];
						var modalParamter = Forms["PARAM_SHOW_AS_MODAL"];
						if(urlParams[fullPageParameter] === -1)
						{
							if(props!=undefined && props.pageMode!=undefined && props.pageMode!= "" && props.pageMode == "FULL_PAGE" )
							{
								urlParams[fullPageParameter] = true;
								urlParams[modalParamter] = false;
									}
							else
							{
								urlParams[fullPageParameter] = false;
								urlParams[modalParamter] = true;
								}
							}
						Forms.setFullPageParameter(urlParams[fullPageParameter],urlParams[modalParamter]);
						Forms.initializeV2Form(initializeV2FormCallBack,data);
						} else if (data.errorMessage != undefined) {
							workflowResp.respMsg = data.errorMessage;
							workflowResp.errorCode = data.errorCode;
						if(Forms.isModalOpen() == true)
							initializeV2ErrorCallBack();
						else
							Forms.initializeV2Form(initializeV2ErrorCallBack);
						}
					},
					function(xhr, ajaxOptions, thrownError) {
						cvUtil.unmask();
					cvUtil.unmask(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
						workflowResp.respMsg = Forms.isAppTableFormReq()?xhr.responseText : wf_localMsg.formError;
						workflowResp.errorCode = 10;
					if(Forms.isModalOpen() == true)
						initializeV2ErrorCallBack();
					else
						Forms.initializeV2Form(initializeV2ErrorCallBack);
						/*
						 * if(thrownError!='userAborted'){
						 * cvUtil.handleError(xhr, ajaxOptions, thrownError); }
						 */
					},
					wfUtils.functions.getAjaxTimeOut());
		} else {
			var interactionParams = "";
			var inputParamsOfClosedWf = "";
			fieldVals = [];

			if (isInfoResp == "true") {
				interactionParams = clearInfoResponseParams();
			} else if (isPopUpResp == "true") {
				interactionParams = clearPopUpResponseParams();
				fieldVals.push(cvUtil.createParamString("continueWorkflow", "false"));
				inputParamsOfClosedWf = Forms.getInputParamsForClosedWf();
			}
			//setCurrWorkflowMetaInfo(currentResp.response.workflow);
			fieldVals.push(cvUtil.createParamString("workflowId", workflowId));
			fieldVals.push(cvUtil.createParamString("workflowName", workflowName));
			fieldVals.push(cvUtil.createParamString("interactionParams", JSON.stringify(interactionParams)));
			fieldVals.push(cvUtil.createParamString("timeOffset", new Date().getTimezoneOffset()));
			inputParams = cvUtil.createParamsString(fieldVals);
			inputParams = inputParamsOfClosedWf!=undefined && inputParamsOfClosedWf.trim() != ""?inputParams + "&" + inputParamsOfClosedWf:inputParams;
				Forms.initializeV2Form(invokeClosePopUpOrInfoMsgCallBack,inputParams);
			}
		}
	}

function invokeClosePopUpOrInfoMsgCallBack(paramter){
	var url = wfUtils.functions.getURL(true);
	CheckIfUploadAndStartActivity(url, paramter);
}

function updateModalFooterWithCompleteFormInfo(){
	if(!Forms.isReadOnlyForm()){
	$("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-footer").html('<div style="height: 61px;font-size: 16px;"><div class="executor" style="display: block;">Submitted By: <span class="submittedby">admin</span></div><div class="subtime" style="display: block;">Submitted On: <span class="submittedon"></span></div><div class="actionExecuted">Action: <span class="actionName"></span></div></div>');

	if (inputForm.completedBy && inputForm.completedBy.userName) {
		$(".submittedby").html(inputForm.completedBy.userName);
	} else {
		$(".submittedby").hide();
	}

	$(".submittedon").html(new Date(parseInt(inputForm.completed) * 1000).toLocaleString());
	$(".executor").show();
	$(".subtime").show();
	var actionExecuted = inputForm.actionExecuted;
	if (actionExecuted != undefined && actionExecuted != "") {
		$(".actionName").html(actionExecuted);
		$(".actionExecuted").show();
	}
	}
	else
		$("#" + wfUtils.constants.FORMS_POPUP_ID + " .modal-footer").hide();
}


function isDateTimeField(controlType,className){
	return controlType === CALENDAR || controlType === DATE_TIME || controlType === TIME_PICKER || className === "java.util.Date" || className === "java.util.Calendar" || className === "workflow.types.Time";
}

var getComponent = function(widgetKey){
	return componentMap[widgetKey];
}

	function validateInputField(inputName, formData) {
		//if (inputField.required) {
			if(formData[inputName] == undefined ||  (typeof(formData[inputName]) === "string" && formData[inputName].trim() === "")){
				var inputInfo = {};
				inputInfo["displayName"] = FormOps.getDisplayName(inputName);
				var errorList = [wf_localMsg.requiredValMsg + " " + getDisplayName(inputInfo)];
				FormOps.showErrorMessages(errorList);
				return false;
			} 
		//}
	return true;
}

function validateMultiRowEditForm() {

				var requiredFields = FormOps.getForm().state.schema.required;
				//var inputEntries = inputForm.inputForm.entries;
			var formData = FormOps.getFormData();
			for (var index = 0; index < requiredFields.length; index++) {
					var currentInput = requiredFields[index].trim();
     
				if(!FormOps.hasMixedValues(currentInput)){
					if (!validateInputField(currentInput, formData)) {
						return false;
					}
				}
			}
		return true;
} 
 
function validateInputForm(validate) {
	if(validate == "true")
	{
			var requiredFields = FormOps.getForm().state.schema.required;
			//var inputEntries = inputForm.inputForm.entries;
		var formData = FormOps.getFormData();
			for (var index = 0; index < requiredFields.length; index++) {
				var currentInput = requiredFields[index].trim();
 
			if (!validateInputField(currentInput, formData)) {
				return false;
			}
 
			if (currentInput.children != undefined && currentInput.children.length > 0) {
 
				var currentChild;
				for (var childIndex = 0; childIndex < currentInput.children.length; childIndex++) {
					currentChild = currentInput.children[childIndex];
 
					var isChildVaildated = validateInputField(currentChild, formData);
					if (!isChildVaildated) {
						return false;
					}
				}
			}
		}
	}
	return true;
}

function getInteractionId(){
	return interactionId;
}

function addFileToList(curFile){
	uploadFileList.push(curFile);
}

function getUserInteractionResp(){
	return userInteractionResp;
}

function resetFormVariables(submitVal){
	 	workflowResp = {
				respMsg : '',
				errorCode : undefined,
				respType : ''
		 };
		 uploadFileList=[];
		 inputForm = undefined;
		 fieldVals = [];
		 uploadFileList=[];
		 destPath = "";
		 interactionId = undefined;
		 workflowId = undefined;
		 workflowName = undefined;
		 wfInputEntryFileUploadMap = {};
		 wfStagedFileInputs = [];
		 inputFormValidated = false;
		 formsSystemParams = {};
		 curWfMetaInfo = {};
		 if(submitVal === false)
			 currentResp = undefined;
		 userInteractionResp = undefined;
		 appTableParams = {};
		formInputs = {};
		currFormInputs = {};
}

function closeDialog(){
		if (Forms.isFullPageForm()) {
			Forms.onWorkflowCompletion(Forms.getWorkflowResp());
		} else {
	$("#" + wfUtils.constants.FORMS_POPUP_ID).modal("hide");
}
	}

function getFileUploadMap(){
	return wfInputEntryFileUploadMap;
}

function setFileUploadMap(curWfInputEntryFileUploadMap){
	wfInputEntryFileUploadMap = curWfInputEntryFileUploadMap;
}

function getControlToFocus(){
	return controlToFocus;
}

	var useDataSetOptions = function(currentInput){
		return currentInput.datasetOptions && currentInput.datasetOptions.datasetGuid?true:false;
	}
 
	function isDataSetRequest(currInput){
		return wfUtils.functions.isComplexEntity(currInput.inputType) || useDataSetOptions(currInput);
	}
 
	formObj["openModal"] = openModal;
	formObj["getWorkflowResp"] =  getWorkflowResp;
	formObj["setWorkflowResp"] =  setWorkflowResp;
	formObj["isCompletedForm"] =  isCompletedForm;
	formObj["sumbitThisForm"] =  sumbitThisForm;
	formObj["getInputActions"] =  getInputActions;
	formObj["createAcionButtonRow"] =  createAcionButtonRow;
	formObj["registerDefaultListenerForActions"] =  registerDefaultListenerForActions;
	formObj["loadUserDefinedScriptAndCss"] =  loadUserDefinedScriptAndCss;
	formObj["getFormProperties"] =  getFormProperties;
	formObj["addValidationListeners"] =  addValidationListeners;
	formObj["getInteractionId"] =  getInteractionId;
	formObj["addListenerForActionButtons"] =  addListenerForActionButtons;
	formObj["setModalTitle"] = setModalTitle;
	formObj["closeModal"] = closeModal;
	formObj["getUserInteractionResp"] =  getUserInteractionResp;
	formObj["getFileUploadMap"] =  getFileUploadMap;
	formObj["setFileUploadMap"] =  setFileUploadMap;
	formObj["getHtml"] =  getHtml;
	formObj["templateClass"] =  templateClass;
	formObj["addFieldVal"] =  addFieldVal;
	formObj["getDestPathOfCurrInput"] =  getDestPathOfCurrInput;
	formObj["addFileToList"] =  addFileToList;
	formObj["escapeSpecialSymbolsForId"] =  escapeSpecialSymbolsForId;
	formObj["updateDefaultValuesForSearchable"] =  updateDefaultValuesForSearchable;
	formObj["clearPopUpResponseParams"] =  clearPopUpResponseParams;
	formObj["clearUserInteractionParams"] =  clearUserInteractionParams;
	formObj["displaySelectedValsForSearchableType"] =  displaySelectedValsForSearchableType;
	formObj["getCurrentResp"] =  getCurrentResp;
	formObj["setCurrentResp"] =  setCurrentResp;
	formObj["setUserInteractionResp"] =  setUserInteractionResp;
	formObj["updateModalFooterWithCompleteFormInfo"] =  updateModalFooterWithCompleteFormInfo;
	formObj["getReactForm"] =  getReactForm;
	formObj["getAppropriateDateFormat"] =  getAppropriateDateFormat;
	formObj["CALENDAR"] =  CALENDAR;
	formObj["TIME_PICKER"] =  TIME_PICKER;
	formObj["resizeDialog"] = resizeDialog;
	formObj["getFormattedValueForDateTime"] = getFormattedValueForDateTime;
	formObj["getFormObject"] = getFormObject;
	formObj["isValidData"] = isValidData;
	formObj["getControlToFocus"] = getControlToFocus;
	formObj["isModalOpen"] = isModalOpen;
	formObj["resetForm"] = resetForm;
	formObj["getCurrentInputForm"] = getCurrentInputForm;
	formObj["getInputParamsEnteredByUser"] = getInputParamsEnteredByUser;
	formObj["processForm"] = processForm;
	formObj["showWarningDialog"] = showWarningDialog;
	formObj["closeWarningMessage"] = closeWarningMessage;
	formObj["closeDialog"] = closeDialog;
	formObj["setModalTooltipTitle"] = setModalTooltipTitle;
	formObj["getAppTableFormUrl"] = getAppTableFormUrl;
	formObj["addRowDeletionListener"] = addRowDeletionListener;
	formObj["isEditRowReqForAppTable"] = isEditRowReqForAppTable;
	formObj["deleteAppTableRecord"] = deleteAppTableRecord;
	formObj["initializeV2ErrorCallBack"] = initializeV2ErrorCallBack;
	formObj["openModalForInputForm"] = openModalForInputForm;
	formObj["isDataSetRequest"] = isDataSetRequest;
	formObj["isCancelRulesExists"] = isCancelRulesExists;
	formObj["hideCustomizeAreaWithDom"] = hideCustomizeAreaWithDom;
	formObj["isMultiRowEditForm"] = isMultiRowEditForm;
	formObj["setCurrentFormInputs"] = setCurrentFormInputs;

return formObj;

})(Forms || {});