var DynamicForms = (function() {
var rules = {};
var ruleTypes = {
	ANY : "ANY",
	ALL : "ALL"
};

var SHOW = "SHOW";
var HIDE = "HIDE";
var REQUIRE = "REQUIRE";
var UNREQUIRE = "UNREQUIRE";
var READONLY = "READONLY";
var EDITABLE = "EDITABLE";
var CHANGE_FIELD_VALUE = "CHANGE_FIELD_VALUE";
var DO_NOT_CHANGE_VALUE = "DO_NOT_CHANGE_VALUE";
var SHOW_MESSAGE = "SHOW_MESSAGE";
var DO_NOT_SHOW_MESSAGE = "DO_NOT_SHOW_MESSAGE";
var CANCEL_SUBMIT = "CANCEL_SUBMIT";
var FAIL_VALIDATION = "FAIL_VALIDATION";
var DO_NOT_FAIL_VALIDATION = "DO_NOT_FAIL_VALIDATION";
var CUSTOM = "CUSTOM";
var NOT_CUSTOM = "NOT_CUSTOM";
var actionQueue = [];
var failValidationMsgs = [];
var oldRow = {};

var oppositeActionTypeMap = {
	SHOW : HIDE,
	HIDE : SHOW,
	REQUIRE : UNREQUIRE,
	UNREQUIRE : REQUIRE,
	READONLY : EDITABLE,
	EDITABLE : READONLY,
	CHANGE_FIELD_VALUE : DO_NOT_CHANGE_VALUE,
	DO_NOT_CHANGE_VALUE : CHANGE_FIELD_VALUE,
	SHOW_MESSAGE : DO_NOT_SHOW_MESSAGE,
	DO_NOT_SHOW_MESSAGE : SHOW_MESSAGE,
	FAIL_VALIDATION : DO_NOT_FAIL_VALIDATION,
	DO_NOT_FAIL_VALIDATION : FAIL_VALIDATION,
	CUSTOM : NOT_CUSTOM,
	NOT_CUSTOM : CUSTOM
}

var operatorMap = {
	EQUALS : "==",
	NOT_EQUALS : "!=",
	LESS_THAN : "<",
	LESS_THAN_EQUALS : "<=",
	GREATER_THAN : ">",
	GREATER_THAN_EQUALS : ">=",
}

var nullCheckOpsMap = {
		IS_EMPTY : "{0} === undefined || {0} === ''",
		IS_NOT_EMPTY : "{0}!=undefined && {0} !== ''",
}

var stringOpsMap = {
		STARTS_WITH : '.startsWith("{0}")',
		ENDS_WITH : '.endsWith("{0}")',
		CONTAINS : '.indexOf("{0}")!=-1',
		NOT_CONTAINS : '.indexOf("{0}")==-1'
}

var buttonTypeLabelMap = {
		"OK" : {
			yesText : "OK",
			onlyOneButton : true
		},
		"OK_CANCEL" : {
			yesText : "OK",
			noText : "Cancel"
		},
		"YES_NO" : {
			yesText : "Yes",
			noText : "No"
		}
};

var messageTypeToTitleMap = {
	"INFO" : "Info",
	"WARNING" : "Warning",
	"ERROR" : "Error"
};

var getCurrentRow = function(){
	var currForm = Forms.getCurrentInputForm();
	var currRow = $.extend(true, {},FormOps.getFormData());
	if(currForm)
	{
		currRow.createdBy = currForm.createdBy;
		currRow.modifiedBy = currForm.modifiedBy;
		currRow.createdTime = currForm.createdTime;
		currRow.modifiedTime = currForm.modifiedTime;
	}
	return currRow;
}

var getSystemObj = function(){
	return $.extend({},true,window.System);
}

var getOperator = function(operator){
	return operator?operatorMap[operator]?operatorMap[operator]:undefined:undefined;
}

var executeCancelAction = function(action){
	action = $.extend(true,{},action);
	var promise = undefined;
	var _func = cancelActionTypes[action.type];
	if(_func){
		action.value = getEvaluatedActionValExpression(action);
		promise = _func(action);
	}

	return promise;
}

var executeSubmitAction = function(action){
	action = $.extend(true,{},action);
	var promise = undefined;
	var _func = submitActionTypes[action.type];
	if(_func)
	{
		action.value = getEvaluatedActionValExpression(action);
		promise =_func(action);
	}

	return promise;
}

var executeCustomScript = function(action){
		var row = getCurrentRow();
		var System = getSystemObj();
		try {
			eval(action.value);
			FormOps.updateFormDataJson(row,true);
		}
		catch(e){

		}
}

var getEvaluatedActionValExpression = function(action)
{
	var row = getCurrentRow();
	var System = getSystemObj();
	var result = action.value;
	if(action && action.value && action.value.startsWith("=")){
		result = action.value.substring(action.value.indexOf("=") + 1);
		try
		{
			result = eval(result);
		}
		catch(e){
			result = action.value;
		}
	}
	return result;
};

var executeAction = function(action,actionType){
	action = $.extend(true,{},action);
	var promise = undefined;
	var _func = actionTypes[actionType?actionType:action.type];
	if(_func){
		action.value = getEvaluatedActionValExpression(action);
		promise = _func(action);
	}

	return promise;
}

var getOppositeAction = function(type){
	return oppositeActionTypeMap[type];
}

var showInputEntry = function(action){
	var field = action.field;
	FormOps.updateFormWithDynamicRules(field,{hideField:false},false);
}

var hideInputEntry = function(action){
	var field = action.field;
	FormOps.updateFormWithDynamicRules(field,{hideField:true},false);
}

var markFieldAsRequired = function(action) {
	var field = action.field;
	FormOps.updateFormWithDynamicRules(field,{required:true},false);
}

var markFieldAsNotRequired = function(action) {
	var field = action.field;
	FormOps.updateFormWithDynamicRules(field,{required:false},false);
}

var markFieldAsReadOnly = function(action) {
	var field = action.field;
	FormOps.updateFormWithDynamicRules(field,{"ui:readonly":true},false);
}

var markFieldAsEditable = function(action) {
	var field = action.field;
	FormOps.updateFormWithDynamicRules(field,{"ui:readonly":false},false);
}

var changeFieldValue = function(action) {
	var field = action.field;
	var value = action.value;
	value = value == undefined || value == "undefined" || value === "true" || value === "false"?eval(value):value;
	FormOps.updateFormWithDynamicRules(field,{"value":value},false);
}

var isPopUpMessageValid = function(popUpMessage){
	return popUpMessage && popUpMessage.message && popUpMessage.message!="";
}

var showMessage = function(action,yesCallBack,noCallBack){
	var promise = undefined;
	if(isPopUpMessageValid(action.popUpMessage)){
		promise = new Promise(function(resolve, reject){
		var dialogInfo = buttonTypeLabelMap[action.popUpMessage.button];
		dialogInfo["title"] = messageTypeToTitleMap[action.popUpMessage.type];
			Forms.showWarningDialog(dialogInfo,action.popUpMessage.message,yesCallBack,noCallBack,resolve,resolve);
		});
	}
	return promise;
}

var showGeneralMessageCallBack = function(promiseResolve){
	promiseResolve(true);
	}

var showGeneralMessage = function(action){
	return showMessage(action,showGeneralMessageCallBack,showGeneralMessageCallBack);
}

var showMessageYesCallback = function(promiseResolve){
	promiseResolve(true);
}

var showMessageNoCallback = function(promiseResolve){
	promiseResolve(false);
}

var showMessageForSubmit = function(action){
	return showMessage(action,showMessageYesCallback,showMessageNoCallback);
	}

var showMessageForCancel = function(action){
	return showMessage(action,showMessageYesCallback,showMessageNoCallback);
}

var cancelSubmitCallBack = function(promiseResolve){
	promiseResolve(false);
}

var cancelSubmit = function(action){
	return showMessage(action,cancelSubmitCallBack,cancelSubmitCallBack);
}

var failValidation = function(action){
	if(action.value)
		failValidationMsgs.push(action.value);

	showErrorMessages(failValidationMsgs);
}

var failValidationForSubmit = function(action){
	failValidation(action);
	var promise = new Promise(function(resolve, reject){
		resolve(false);
	});
	return promise;
}

var failValidationForCancel = function(action){
	failValidation(action);
	var promise = new Promise(function(resolve, reject){
		resolve(false);
	});
	return promise;
}

var failValidationForFieldChange = function(action){
	failValidation(action);
}

var actionTypes = {
		SHOW : showInputEntry,
		HIDE : hideInputEntry,
		REQUIRE : markFieldAsRequired,
		UNREQUIRE : markFieldAsNotRequired,
		READONLY : markFieldAsReadOnly,
		EDITABLE : markFieldAsEditable,
		CHANGE_FIELD_VALUE : changeFieldValue,
		DO_NOT_CHANGE_VALUE : undefined,
		SHOW_MESSAGE : showGeneralMessage,
		DO_NOT_SHOW_MESSAGE : undefined,
		CANCEL_SUBMIT : cancelSubmit,
		FAIL_VALIDATION : failValidationForFieldChange,
		DO_NOT_FAIL_VALIDATION : undefined,
		CUSTOM : executeCustomScript,
		NOT_CUSTOM : undefined
}

var submitActionTypes = {
	SHOW_MESSAGE : showMessageForSubmit,
	CANCEL_SUBMIT : cancelSubmit,
	FAIL_VALIDATION : failValidationForSubmit,
	CUSTOM : executeCustomScript
}

var cancelActionTypes = {
	SHOW_MESSAGE : showMessageForCancel,
	FAIL_VALIDATION : failValidationForCancel,
	CUSTOM : executeCustomScript
}


var recordOperationType = {
	"INSERT" : "insert",
	"UPDATE" : "update",
	"DELETE" : "delete"
}

var recordOperations = {
		"RECORD_ADDED" : "Forms.isAddRecordReq()",
		"RECORD_MODIFIED" : "Forms.isModifyRecordReq()",
		"RECORD_DELETED" : undefined
};

var isConditionValid = function(condition)
{
    var expression = getConditionExpression(condition);
	if(expression){
		expression = expression.replace(/\\/g,"\\\\");
		try
		{
			 var row = getCurrentRow();
			 var System = getSystemObj();
			if(eval(expression) === true)
				return true;
		}
		catch(exception){
			return false;
		}
	}
	return false;
}

var getConditionExpression = function(condition){
	var expression = undefined;
	var operator = condition["op"];
	var field = condition["field"];
	var value = condition["value"];

	if(value && value.trim().startsWith("="))
	{
		try{
			value = value.trim();
			value = eval(value.substring(value.indexOf("=") + 1));
		}
		catch(e){
			value = value;
		}
	}

	//if(field)
	//{

		if(field === wfUtils.constants.FORMS_CUSTOM_OPERATION_FIELD)
		{
			expression = value;
			expression = expression && expression!=""?"(function(){" + expression + "})();":expression;
		}
		else if(field === wfUtils.constants.FORMS_RECORD_OPERATION_FIELD)
		{
			expression = recordOperations[value];
		}
		else if(nullCheckOpsMap[operator])
		{
			field = "FormOps.getFormData()['" + field + "']";
			expression = nullCheckOpsMap[operator].replace("{0}",field).replace("{0}",field);
		}
		else if(stringOpsMap[operator])
		{
			//if(field)
				expression = "FormOps.getFormData()['" + field + "']" + stringOpsMap[operator].replace("{0}",value);
		}
		else
		{
			operator = getOperator(condition["op"]);
			if(operator)
	{
				expression = "FormOps.getFormData()['" + field + "']" + operator + (value == undefined || value == "undefined" || value === "true" || value === "false"?eval(value):isNaN(parseInt(value))? "\"" + value + "\"":value);
		}
	}
	//}

	return expression;
}

var resetErrors = function(doNotResetMsgs){
	if(doNotResetMsgs == undefined || doNotResetMsgs === false){
		failValidationMsgs = [];
		showErrorMessages(failValidationMsgs);
	}
}

var processRulesOnFormLoad = async function(){

	var outerPromise = new Promise(function(resolve,reject){
		processOpenEventRules(resolve);
	});

	var outerResult = await outerPromise;

	processFieldChangeRules(undefined,true);
}

var processOpenEventRules = async function(outerPromiseResolve){
	if(rules && rules.length > 0){
		resetErrors();
		var noOfRules = rules.length;
		for(var i = 0 ;i < noOfRules;i++){
			var isFormOpenRule = rules[i].ruleTriggers.OnFormFormOpened;

			if(isFormOpenRule != undefined && isFormOpenRule === true)
			{
				var promise = new Promise(function(resolve,reject){
					processRule(rules[i],resolve);
				});

				var result = await promise;
			}
		}
	}

	if(outerPromiseResolve != undefined)
		outerPromiseResolve(true);
}

var processCancelEventRules = async function(cancelRulesValidCallBack,params){
	var cancelThisForm = true;
	if(rules && rules.length > 0){
		resetErrors();
		var noOfRules = rules.length;
		for(var i = 0 ;i < noOfRules;i++){
			var isFormCancelledRule = rules[i].ruleTriggers.onFormCancelled;

			if(isFormCancelledRule != undefined && isFormCancelledRule === true)
			{
				var promise = new Promise(function(resolve,reject){
					processCancelRule(rules[i],resolve);
				});

				var result = await promise;

				if(result === false)
				{
					cancelThisForm = false;
				break;
		}
	}
		}

		if(cancelThisForm === true)
			cancelRulesValidCallBack();
	}
	else
		cancelRulesValidCallBack();
}

var isPreviewPage = function(){
	return window.location.pathname === cvUtil.getContextPath() + "/forms/preview/" || Forms.isPreviewInputForm();
}

var shouldProcessApplyToFormRule = function(currRule){
	var shouldProcessRule = false;
	var isAddReq = Forms.isAddRecordReq();

	var isRecordAddedRule = currRule.ruleTriggers.onRecordAdded;
	isRecordAddedRule = isRecordAddedRule!=undefined && isRecordAddedRule == true?true:false;

	var isRecordUpdateRule = currRule.ruleTriggers.onRecordUpdated;
	isRecordUpdateRule = isRecordUpdateRule!=undefined && isRecordUpdateRule == true?true:false;

	if(isRecordAddedRule === false && isRecordUpdateRule === false)
		shouldProcessRule = true;
	else
		{
			if(isRecordAddedRule === true)
			{
				if(isAddReq === true)
					shouldProcessRule = true;
			}

			if(shouldProcessRule == false)
				if(isRecordUpdateRule === true)
					if(isAddReq === false)
						shouldProcessRule = true;
		}

	return shouldProcessRule;
}

var processFormSubmitRules = async function(submitRulesValidCallBack,params){
	var submitTheForm = true;
	var currRule = undefined;
	if(rules && rules.length > 0){

		var outerPromise = new Promise(function(resolve,reject){
			processFieldChangeRuleWithPromise(resolve);
		});

		var outerResult = await outerPromise;
		var applyRuleToForms = false;

		if(failValidationMsgs.length > 0)
			return;

		var noOfRules = rules.length;
		for(var i = 0 ;i < noOfRules;i++){
			var isFormSubmitRule = rules[i].ruleTriggers.onFormSubmitted;

			currRule = rules[i];

			applyRuleToForms = currRule.applyRuleToAllForms != undefined && currRule.applyRuleToAllForms === true?true:false;

			if(isFormSubmitRule != undefined && isFormSubmitRule === true)
			{
				if(applyRuleToForms === true && shouldProcessApplyToFormRule(rules[i]) == false)
					continue;

				var promise = new Promise(function(resolve,reject){
					processSubmitRule(rules[i],resolve);
				});

				var result = await promise;

				if(result === false)
				{
						submitTheForm = false;
						break;
				}
			}
			}

		if(submitTheForm === true)
		{
			if(isPreviewPage() === true)
				Forms.showWarningDialog({onlyOneButton : true,yesText:"OK"},"All rules validated. Form will be submitted!");
			else
				submitRulesValidCallBack(params);
		}

	}
	else
		submitRulesValidCallBack(params);
}

var processFieldChangeRuleWithPromise = function(resolve){
	processFieldChangeRules(undefined,false,resolve);
}

var processFieldChangeRules = async function(formState,doNotResetMsgs,outerPromiseResolve){

	if(!FormOps.getForm())
		return;

	resetErrors(doNotResetMsgs);
	var formContext = FormOps.getFormContext();

	if(formContext.skipProcessingRules === true)
	{
		FormOps.updateContextProperty("skipProcessingRules",false);
		return;
	}

	if(rules){
		var noOfRules = rules.length;
		for(var i = 0 ;i < noOfRules;i++){
			var isFieldChangeRule = rules[i].ruleTriggers.OnFormFieldChange;

			if(isFieldChangeRule != undefined && isFieldChangeRule === true)
			{
				var promise = new Promise(function(resolve,reject){
					processRule(rules[i],resolve);
				});

				var result = await promise;
			}

		}
	}
	if(outerPromiseResolve != undefined)
		outerPromiseResolve(true);
}

var processCancelActions = async function(actions){
	var processNextAction = true;
	var promise = undefined;

	if(actions){
		var noOfActions = actions.length;
		var curAction = undefined;

		for(var i = 0;i<noOfActions;i++){
			curAction = actions[i];

			if(curAction.type === CUSTOM){
				promise = executeCancelAction(curAction);
			}
			else if(curAction.type === SHOW_MESSAGE)
			{
				if(isPopUpMessageValid(curAction.popUpMessage))
				{
					promise = executeCancelAction(curAction);
				}
			}
			else if(curAction.type === FAIL_VALIDATION)
			{
				promise = executeCancelAction(curAction);
			}


			if(promise!=undefined)
			{
				processNextAction = await promise;

				if(processNextAction === false)
					break;
				}
			else
				continue;
			}
		}
	return processNextAction;
}

var processSubmitActions = async function(actions){
	var processNextAction = true;
	var promise = undefined;

	if(actions){
		var noOfActions = actions.length;
		var curAction = undefined;

		for(var i = 0;i<noOfActions;i++){
			promise = undefined;

			curAction = actions[i];

			if(curAction.type === CUSTOM){
				promise = executeSubmitAction(curAction);
			}
			else if(curAction.type === FAIL_VALIDATION){
				promise = executeSubmitAction(curAction);
			}
			else if(curAction.type === CANCEL_SUBMIT){
				promise = executeSubmitAction(curAction);
			}
			else if(curAction.type === CHANGE_FIELD_VALUE){
				promise = executeAction(curAction);
				FormOps.renderFormPostDynaamicRules();
			}
			else if(curAction.type === SHOW_MESSAGE)
			{
				if(isPopUpMessageValid(curAction.popUpMessage))
				{
					promise = executeSubmitAction(curAction);
				}
			}

			if(promise!=undefined)
			{
				processNextAction = await promise;

				if(processNextAction === false)
					break;
				}
			else
				continue;
			}
		}

	return processNextAction;
}


var processActions = async function(actions,executeWithOppositeAction){
	var processNextAction = true;
	var promise = undefined;

	if(actions){
		var noOfActions = actions.length;

		if(executeWithOppositeAction !=undefined && executeWithOppositeAction === true)
		{
			for(var i = 0;i<noOfActions;i++){
				var currAction = actions[i];
				promise = executeAction(currAction,getOppositeAction(currAction.type));

				if(promise!=undefined)
				{
					processNextAction = await promise;

					if(processNextAction === false)
						break;
				}
				else
					continue;
			}
		}
		else
		{
			for(var i = 0;i<noOfActions;i++){
				promise = executeAction(actions[i]);

				if(promise!=undefined)
				{
					processNextAction = await promise;

					if(processNextAction === false)
						break;
				}
				else
					continue;
			}
		}
		FormOps.renderFormPostDynaamicRules();
	}
	return processNextAction;
}


var getRecordOperationType = function(){
	return Forms.isPreviewInputForm()?"insert":Forms.isAddRecordReq()?"insert":Forms.isModifyRecordReq()?"update":"delete";
}

var processCancelRule = function(rule,resolve){
	var ruleValid = true;
	var processNextRule = true;
	if(rule && rule.enabled === true)
	{
		ruleValid = evaluateBusinessRule(rule,FormOps.getFormData(),oldRow,getRecordOperationType(),getSystemObj(),false);

		var actions = rule.actions?rule.actions:undefined;

		if(ruleValid){
			processNextRule = processCancelActions(actions);
		}
	}
	resolve(processNextRule);
}

var processSubmitRule = function(rule,resolve){
	var ruleValid = true;
	var processNextRule = true;
	if(rule && rule.enabled === true)
	{
		ruleValid = evaluateBusinessRule(rule,FormOps.getFormData(),oldRow,getRecordOperationType(),getSystemObj(),false);

		var actions = rule.actions?rule.actions:undefined;

		if(ruleValid){
			processNextRule = processSubmitActions(actions);
		}
	}
	resolve(processNextRule);
}

var processRule = function(rule,resolve){
	var ruleValid = true;
	var processNextRule = true;
	if(rule && rule.enabled === true)
	{
		ruleValid = evaluateBusinessRule(rule,FormOps.getFormData(),oldRow,getRecordOperationType(),getSystemObj(),false);

		var actions = rule.actions?rule.actions:undefined;

		if(ruleValid){
			processNextRule = processActions(actions,false);
		}
		else
		{
			processNextRule = processActions(actions,true);
		}
	}
	resolve(processNextRule);
}

var processCondGroups = function(condGroups,condGroupsType){
	var noOfCondsGrpsMet = 0;
	var condGroupsValid = true;
	if(condGroups && condGroups.length > 0)
	{
		var noOfConditiongroups = condGroups.length;
		for(var i = 0 ;i < noOfConditiongroups;i++){
			if(processCondGroup(condGroups[i]))
				noOfCondsGrpsMet++;
		}

		if(condGroupsType === ruleTypes.ALL){
			if(noOfCondsGrpsMet !== noOfConditiongroups)
				condGroupsValid = false;
		}
		else
		{
			if(noOfCondsGrpsMet === 0)
				condGroupsValid = false;
		}
	}
	return condGroupsValid
}

var processCondGroup = function(condGroup){
	var condGroupValid = true;
	if(condGroup)
	{
		var conditions = condGroup["conditions"];
	    var condGroupType = condGroup["allOrAny"]?condGroup["allOrAny"]:ANY;
		var noOfCondsMet = 0;
		if(conditions && conditions.length > 0){
			var noOfConditions = conditions.length;
			for(var i = 0 ;i < noOfConditions;i++){
				if(isConditionValid(conditions[i]) === true)
				{
					noOfCondsMet++;
				}
			}

			if(condGroupType === ruleTypes.ALL){
				if(noOfCondsMet !== noOfConditions)
					condGroupValid = false;
			}
			else
			{
				if(noOfCondsMet === 0)
					condGroupValid = false;
			}
		}
	}
	return condGroupValid;
}


var processRules = function(){
	if(rules){
		var noOfRules = rules.length;
		for(var i = 0 ;i < noOfRules;i++){
			processRule(rules[i]);
		}
	}
}

var setRules = function(rulesToProcess){
	rules = rulesToProcess?rulesToProcess:[];

	if(rules.length > 0){
		var noOfRules = rules.length;
		for(var i=0;i<noOfRules;i++){
			var currRule = rules[i];
			if(currRule.applyRuleToAllForms != undefined && currRule.applyRuleToAllForms === true)
			{
				currRule.ruleTriggers.OnFormFieldChange  = false;
				currRule.ruleTriggers.onFormSubmitted = true;
			}
		}
	}

	oldRow = FormOps.getFormData();
}

var initializeRules = function(rulesToProcess){
	rules = rulesToProcess?rulesToProcess:{};
	processRules();
}

var resetRules = function(){
	resetErrors();
	rules = [];
}

var formObj = {};
formObj["initializeRules"] = initializeRules;
formObj["processRules"] = processRules;
formObj["setRules"] = setRules;
formObj["processOpenEventRules"] = processOpenEventRules;
formObj["processRulesOnFormLoad"] = processRulesOnFormLoad;
formObj["processCancelEventRules"] = processCancelEventRules;
formObj["processFormSubmitRules"] = processFormSubmitRules;
formObj["processFieldChangeRules"] = processFieldChangeRules;
formObj["resetRules"] = resetRules;
return formObj;

})();

window["Forms"] = Object.assign({},window["Forms"],DynamicForms);