<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>  
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="requestURI" value="<%=request.getRequestURI()%>"></c:set>
<fmt:bundle basename="localization.formsMessages">
<fmt:message key="Workflow_Success" var="successfulWorkflow" />
<fmt:message key="Action_Success" var="successfulAction" />
<fmt:message key="Invalid_Workflow" var="invalidWorkflow" />
<fmt:message key="Workflow" var="pageTitle" />
<fmt:message key="Actions" var="actionsTitle" />
<fmt:message key="No_Pending_Label" var="noPendingActions" />
<fmt:message key="No_Completed_Label" var="noCompletedActions" />
<fmt:message key="No_ReDeployed_Workflows" var="noRedeployedForms" />
<fmt:message key="Invalid_Interaction" var="invalidInteraction" />
<fmt:message key="Unauthorized_Action" var="unauthorizedAction" />
<fmt:message key="Already_Completed_Interaction" var="completedAction" />
<fmt:message key="Already_Killed_Interaction" var="killedAction" />
<fmt:message key="Form_Error_Message" var="formErrorMsg" />
<fmt:message key="POPUP_INPUT_RESP_TITLE" var="popUpInputRespTitle" />
<fmt:message key="INFO_RESP_TITLE" var="infoRespTitle" />
<fmt:message key="Date_Label" var="dateLabel" />
<fmt:message key="Invalid_Date_Format_Label" var="invalidDateFormat" />
<fmt:message key="Invalid_Time_Format_Label" var="invalidTimeFormat" />
<fmt:message key="Empty_Date_Label" var="emptyDateMsg" />
<fmt:message key="Empty_Time_Label" var="emptyTimeMsg" />
<fmt:message key="Required_Value_Label" var="requiredValMsg" />
<fmt:message key="Required_File_Label" var="requiredFileMsg" />
<fmt:message key="Duplicate_File_Warning" var="duplicateFileWarningMsg" />
<fmt:message key="Multiple_File_Upload_Error" var="multipleFileUploadError" />
<fmt:message key="Start_Form_TimeOut_Warning" var="startFormTimeoutWarning" />
<fmt:message key="Workflow_File_Upload_Error" var="wfFileUploadError" />
<fmt:message key="Searchable_Results_Title" var="searchableResultsTitle" />
<fmt:message key="Searchable_Selected_Options_Title" var="searchableSelectedOptionsTitle" />
<fmt:message key="Searchable_Items_Selected_Label" var="searchableItemsselectedLbl" />
<fmt:message key="Submit_Request_Label" var="submitReqLbl" />
<fmt:message key="OK_Label" var="okButtonLbl"></fmt:message>
<fmt:message key="Next_Btn_Label" var="nextButtonLbl"></fmt:message>
<fmt:message key="Back_Btn_Label" var="backButtonLbl"></fmt:message>
<c:set var="requestURI" value="<%=request.getRequestURI()%>"></c:set>
<c:set var="userGUID" value="<%=session.getId()%>"></c:set>
<c:set var="workflowReqTimeout" value="${cvConfig.workflowRequestTimeout}"></c:set>
</fmt:bundle>


<link rel="stylesheet" href="${pageContext.request.contextPath}/forms/css/common.css?${applicationScope.BUILD_TS}" />

<div id="dialog" class="wfBottomArea">
<p class="alert"></p>
<a class="okSaveButton" id="warning" href="#" style="margin: 10px 108px 10px 0 "><fmt:bundle basename="localization.messages"><fmt:message key="common.action.ok" /></fmt:bundle></a>
</div>

		<c:if test="${!fn:contains(requestURI,'/forms')}">
		<jsp:include page="formModalHtml.jsp"/>
		</c:if>
		<jsp:include page="reactFormIndex.jsp">
				<jsp:param value="${param.appName}" name="applicationName" /> 
				<jsp:param value="${fn:escapeXml(param.doNotIncludeKendoLibs)}" name="doNotIncludeKendoLibs" /> 
				<jsp:param value="${param.includeBootstrapLib}" name="includeBootstrapLib" />
				<jsp:param value="${!fn:contains(requestURI,'/forms') || fn:contains(requestURI,'/forms/preview')}" name="includeFormsJS" />
		</jsp:include>

<script nonce="${sessionScope.cspNonce}" >
     var wf_localMsg = wf_localMsg || {}; 
     wf_localMsg.formsTab = "${pageTitle}";
     wf_localMsg.actionsTab = "${actionsTitle}";
     wf_localMsg.successfulWorkflow = "${successfulWorkflow}";
     wf_localMsg.successfulAction = "${successfulAction}";
     wf_localMsg.invalidWorkflow = "${invalidWorkflow}";
     wf_localMsg.noPendingActions = "${noPendingActions}";
     wf_localMsg.noCompletedActions = "${noCompletedActions}";
     wf_localMsg.noRedeployedForms = "${noRedeployedForms}";
     wf_localMsg.invalidInteraction = "${invalidInteraction}";
	 wf_localMsg.unauthorizedAction = "${unauthorizedAction}";
     wf_localMsg.completedAction = "${completedAction}";
     wf_localMsg.killedAction = "${killedAction}";
     wf_localMsg.formError="${formErrorMsg}";
     wf_localMsg.popUpInputRespTitle="${popUpInputRespTitle}";
     wf_localMsg.infoRespTitle="${infoRespTitle}";
     wf_localMsg.dateLabel="${dateLabel}";
     wf_localMsg.invalidDateFormat="${invalidDateFormat}";
     wf_localMsg.invalidTimeFormat="${invalidTimeFormat}";
     wf_localMsg.emptyDateMsg="${emptyDateMsg}";
     wf_localMsg.emptyTimeMsg="${emptyTimeMsg}";
     wf_localMsg.requiredValMsg="${requiredValMsg}";
	 wf_localMsg.requiredFileMsg="${requiredFileMsg}";
	 wf_localMsg.duplicateFileWarningMsg="${duplicateFileWarningMsg}";
	 wf_localMsg.multipleFileUploadError="${multipleFileUploadError}";
     wf_localMsg.startFormTimeoutWarning = "${startFormTimeoutWarning}";
     wf_localMsg.wfFileUploadError = "${wfFileUploadError}";
     wf_localMsg.searchableResultsTitle = "${searchableResultsTitle}";
     wf_localMsg.searchableSelectedOptionsTitle = "${searchableSelectedOptionsTitle}";
     wf_localMsg.searchableItemsselectedLbl = "${searchableItemsselectedLbl}";
     wf_localMsg.submitReqLbl = "${submitReqLbl}";
	 wf_localMsg.okButtonLbl = "${okButtonLbl}";
	 wf_localMsg.nextButtonLbl="${nextButtonLbl}";
	 wf_localMsg.backButtonLbl="${backButtonLbl}";

     var userGUID = "${userGUID}";
	 var wfReqTimeOut = (parseInt("${workflowReqTimeout}") * 60 * 1000) + ( 60 * 1000);
</script>