const BUILDER_TYPE = {
	WORKFLOWS : 'WORKFLOW_RULE_BUILDER',
    FORMS: 'FORM_RULE_BUILDER',
    BUSINESS: 'BUSINESS_RULE_BUILDER',
    VIEWS: 'VIEWS_CONFIGURATION',
};

var RuleBuilder = (function () {

    var fetcher;
    var builderInfo;
    var onInit;
	var builderType;

    var getRuleData;
    var getData;

    const init = function () {
        // fix for issue with childNodes undefined
        // TODO: remove this when completely port to react rule builder
        setTimeout(function() {
            $('#root').show();
            $('#wc-rule-builder').remove();
        }, 0)
    }

	const openWorkflowRuleBuilder = function(tBuilderInfo,isBuilderEmbeddedInEditor) {
        builderInfo = tBuilderInfo;
		builderType = BUILDER_TYPE.WORKFLOWS;
        init();
        onInit(BUILDER_TYPE.WORKFLOWS,!isBuilderEmbeddedInEditor?false:true)
    };
	
    const openAppStudioFormsRuleBuilder = function(tBuilderInfo) {
        builderInfo = tBuilderInfo;
		builderType = BUILDER_TYPE.FORMS;
        init();
        onInit(BUILDER_TYPE.FORMS)
    };

    const openAppStudioBusinessRuleBuilder = function(tBuilderInfo) {
        builderInfo = tBuilderInfo;
		builderType = BUILDER_TYPE.BUSINESS;
        init();
        onInit(BUILDER_TYPE.BUSINESS)
    };

    const openViewConfigurationPage = function(tBuilderInfo) {
        builderInfo = tBuilderInfo;
		builderType = BUILDER_TYPE.VIEWS;
        init();
        onInit(BUILDER_TYPE.VIEWS)
    };

    const setOnInit = function(f) {
        onInit = f
    };

    const setGetterRuleData = function(f) {
        getRuleData = f
    };

    const setFetcher = function(f) {
        fetcher = f;
    };

    const setDataGetter = function(f) {
        getData = f;
    };

    const fetchData = function() {
        return fetcher(builderInfo).then((data) => {
            $('.button-container').show()
            return data;
        })
    };

    const onSaveFormRuleBuilder = function(f) {
        saveFormRuleBuilder = f;
    }

    const onSaveAndDeployFormRuleBuilder = function(f) {
        saveAndDeployFormRuleBuilder = f;
    }

    const onGetFormRuleBuilderData = function(f) {
        getFormRuleBuilderData = f;
    }

    const previewCustomization = function() {

		if(builderType == BUILDER_TYPE.WORKFLOWS){
			
        var curEpoch = new Date().getTime();

        var fullPageForm = $('<form id="wfPreviewForm" method="post" target="POPUPW' + curEpoch + '">').attr({
            action :  "/webconsole/forms/preview"
        }).appendTo(document.body);

        var paramMap = {};

        for ( var inputName in paramMap) {
            if (paramMap.hasOwnProperty(inputName)) {
                $('<input type="hidden" />').attr({
                    name : inputName,
                    value : paramMap[inputName]
                }).appendTo(fullPageForm);
            }
        }

        $("#wfPreviewForm").submit(function(event){
            var POPUPW = window.open('about:blank','POPUPW' + curEpoch,'width=938,height=458,left=-1500');

            var inputFormForActivity = getFormRuleBuilderData();

            POPUPW.sessionStorage["previewInputForm"] = JSON.stringify(inputFormForActivity);
        });

        fullPageForm.submit();
        fullPageForm.remove();
		}
		else
		{
			Forms.previewAppStudioInputForm(JSON.stringify(getFormRuleBuilderData()));
		}
    };

    const onCancelFormRuleBuilder = function(f) {
        cancelFormRuleBuilder = f
    }


    return {
		openWorkflowRuleBuilder ,
        openAppStudioFormsRuleBuilder,
        openAppStudioBusinessRuleBuilder,
        openViewConfigurationPage,
        setFetcher,
        setOnInit,
        setGetterRuleData,
        setDataGetter,
        openViewConfigurationPage,
        previewCustomization: () => previewCustomization(),
        getRuleData: () => getRuleData(),
        getData: () => getData(),
        getFormRuleBuilderData: () => getFormRuleBuilderData(),
        fetchData,
        onGetFormRuleBuilderData,
        onCancelFormRuleBuilder,
        cancelFormRuleBuilder: () => cancelFormRuleBuilder(),
        onSaveFormRuleBuilder,
        onSaveAndDeployFormRuleBuilder,
        saveFormRuleBuilder: () => saveFormRuleBuilder(),
        saveAndDeployFormRuleBuilder: () => saveAndDeployFormRuleBuilder()
        

    }
})();