<%
	response.setHeader("Cache-Control", "no-cache");
    response.setDateHeader("Expires", 0);
%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib prefix="enhance" uri="http://pukkaone.github.com/jsp" %>
<html>
<head>
<jsp:include page="/common/search-engine.jsp" />
<title>Webconsole SysInfo</title>
<style>
	.info th, .info td {
		border-bottom: 1px solid #369;
	}
	.info td {
		width: 600px;
	}
	.info th {
		border-right: 1px solid #369;
	}
	.hidden {
		display: none;
	}
	.toggle{
		text-decoration: underline;
		color: #369;
		cursor: pointer;
	}
	td, th {
		font-family: Helvetica, Arial, Verdana;
		font-size: 1em;
	}
</style>
<jsp:include page="common/jquery.jsp" />
<script nonce="${sessionScope.cspNonce}" >
	$(document).on("ready", function(){
		$(".toggle").each(function(){
			var tgDiv = $($(this).data("togglediv"));
			$(this).toggle(function(){
				tgDiv.show();
			}, function(){
				tgDiv.hide();
			});
			$(this).on("click", function(e){
				e.preventDefault();
				e.stopPropagation();
			});
		});
	});
</script>
</head>
<body>
	<c:set var="isDebugModeEnabledForCurrentUser" value="${cv:isDebugModeEnabledForCurrentUser()}"/>
	<c:if test="${empty BASE_URL}">
		<!-- The jsp was accessed directly instead of via the sysInfo.do handler -->
		<h1>This page was improperly accessed. Some data will not be available.</h1>
	</c:if>
    <c:if test="${isDebugModeEnabledForCurrentUser == 'true'}">
		<table width="900" cell-padding="2">
			<tr>
				<th colspan="2" style="text-align:center"><h1>Webconsole SysInfo</h1><h3>${requestScope.BUILD_INFO}</h3></th>
			</tr>
			<tr class="info">
				<th style="width:140px">Web Service: </th>
				<td><a href="${requestScope.BASE_URL}" target="_blank">${requestScope.BASE_URL}</a></td>
			</tr>
			<tr class="info">
				<th>System Path: </th>
				<td>${requestScope.BASE_PATH}</td>
			</tr>
			<tr class="info">
				<th>Session Info: </th>
				<td>
					<h4 class="toggle" data-togglediv=".sessionInfo">Toggle Info</h4>
					<enhance:out escapeXml="false">
					<div class="hidden sessionInfo">${requestScope.SESSION_INFO}</div><br/>
					</enhance:out>
					<a href="clearsession.do">Clear Session</a> <br/>
				</td>
			</tr>
			<tr class="info">
				<th>Application Params: </th>
				<td>
					<h4 class="toggle" data-togglediv=".appInfo">Toggle Info</h4>
					<enhance:out escapeXml="false">
					<div class="hidden appInfo">${requestScope.APPLICATION_PARAMS}</div><br/>
					</enhance:out>
				</td>
			</tr>
			<tr class="info">
				<th>API Tools: </th>
				<td><a href="${pageContext.request.contextPath}/sandbox" >Sandbox</a></td>
			</tr>
			<tr class="info">
				<th valign="top">Cached Keys: </th>
				<td>
					<div class="keys hidden">
						<c:forEach var="key" items="${requestScope.CACHE_KEYS}">
						${key}<br/>
						</c:forEach>
					</div>
					${requestScope.CACHE_KEY_COUNT}<br/>
					<a href="clearcache.do">Clear Cache</a> <br/>
				</td>
			</tr>

			<tr class="info">
				<th valign="top">Basic Memory Info</th>
				<td>
					<enhance:out escapeXml="false">
					<b>Heap Size</b>: ${requestScope.HEAP_SIZE}<br/>
					<b>Max Size</b>: ${requestScope.MAX_HEAP_SIZE}<br/>
					<b>Available Size</b>: ${requestScope.AVAILABLE_MEM}<br/>
					<h4 class="toggle" data-togglediv=".detailedMemInfo">Detailed Info</h4>
					<div class="hidden detailedMemInfo">${requestScope.DETAILED_MEM_INFO}</div>
					</enhance:out>
				</td>
			</tr>
			<tr class="info">
				<th valign="top" style="width:140px">JVM Info</th>
				<td>
					<h4 class="toggle" data-togglediv=".detailedJvmInfo">Toggle Info</h4>
					<enhance:out escapeXml="false">
					<div class="hidden detailedJvmInfo">${requestScope.JVM_INFO}</div>
					</enhance:out>
				</td>
			</tr>
			<tr class="info">
				<th valign="top" style="width:140px">Startup Params</th>
				<td>
					<a href="getStartupParams.do">Refresh Configuration Properties</a><br />
					<a href="getStartupParams.do?readAll=true">Refresh All Configuration Properties (including READONCE properties)</a>
				</td>
			</tr>
			<tr class="info">
				<th valign="top" style="width:140px">WebConsole logging</th>
				<td>
					<strong>
					Warning: changing the log level will affect how much data is recorded
					to WebConsole.log. TRACE and DEBUG logging may record large
					amounts of data and can impact Web Console performance.
					</strong><br/><br/>
					Current log level: ${requestScope.WCLOGLEVEL}<br/>
					Override log level:
					<a href="setLogLevel.do?logLevel=TRACE">TRACE</a>
					<a href="setLogLevel.do?logLevel=DEBUG">DEBUG</a>
					<a href="setLogLevel.do?logLevel=INFO">INFO</a>
					<a href="setLogLevel.do?logLevel=WARN">WARN</a>
					<a href="setLogLevel.do?logLevel=ERROR">ERROR</a><br />
					<a href="setLogLevel.do?logLevel=clear">Clear override</a> (allows polling to restore registry-configured log level)
				</td>
			</tr>
		</table>
    </c:if>
</body>
</html>