<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<fmt:message key="Register_code_error" var="Register_code_error"/>
<fmt:message key="Register_companyName_error" var="Register_companyName_error"/>
<fmt:message key="Register_email_error" var="Register_email_error"/>
<fmt:message key="Register_Password_error" var="Register_Password_error"/>
<fmt:message key="Register_blank_password_error" var="Register_blank_password_error"/>
<fmt:message key="Register_username_error" var="Register_username_error"/>
<fmt:message key="Register_fields_mandatory" var="Register_fields_mandatory"/>
<fmt:message key="Register_password_spaces" var="Register_password_spaces"/>
<fmt:message key="Register_invalid_email" var="Register_invalid_email"/>

<div class="form-group">
	<label class="control-label sr-only" id="labelFullName" for="fullName"><fmt:message key="Full_Name" /></label>
	<input type="text" id="fullName" name="fullName" class="textbox form-control" placeholder="<fmt:message key="Full_Name" />" />
</div>
<div class="form-group">
	<label class="control-label sr-only" id="labelUsername" for="username"><fmt:message key="Username" /></label>
	<input type="text" id="username" name="username" class="textbox form-control" data-msg="${Register_username_error}" data-validation="^[^\s\/\\@]{3,20}$" placeholder="<fmt:message key="Username" />" />
	<div class="error alert vw-alert-danger hidden" for="username">&nbsp;</div>
</div>
<div class="form-group">
	<label class="control-label sr-only" id="labelPassword" for="password"><fmt:message key="Password" /></label>
	<input type="password" autocomplete="off" id="pwd" name="password" class="textbox form-control" data-msg="${Register_blank_password_error}" data-validation="(?=.{1,}).*" placeholder="<fmt:message key="Password" />" />
	<div class="error alert vw-alert-danger hidden" for="pwd">&nbsp;</div>
</div>
<div class="form-group">
	<label class="control-label sr-only" id="labelConfirmPassword" for="confirmPassword"><fmt:message key="Confirm_Password" /></label>
	<input type="password" autocomplete="off" id="confirmPassword" name="confirmPassword" class="textbox form-control" data-msg="${Register_Password_error}" data-validationfn="matchPwds()" placeholder="<fmt:message key="Confirm_Password" />" />
	<div class="error alert vw-alert-danger hidden" for="confirmPassword">&nbsp;</div>
</div>
<div class="form-group">
	<label class="control-label sr-only" id="labelEmail" for="email"><fmt:message key="Email" /></label>
	<input type="text" id="email" name="email" class="textbox form-control" data-msg="${Register_email_error}" data-validation="^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$" placeholder="<fmt:message key="Email" />" />
	<div class="error alert vw-alert-danger hidden" for="email">&nbsp;</div>
</div>
<div class="form-group">
	<fmt:message var="coNameLabel" key="Auth_Code" />
	<c:if test="${fn:endsWith(pageContext.request.requestURI, 'registerBusiness.jsp')}">
		<fmt:message var="coNameLabel" key="Company_Name" />
	</c:if>

	<label class="control-label sr-only" id="labelCoName" for="coName">${coNameLabel}</label>
	<input type="text" id="coName" name="coName" class="textbox form-control" placeholder="${coNameLabel}" />
	<div class="error alert vw-alert-danger hidden" for="coName"></div>
</div>
<div class="form-group">
	<label class="control-label sr-only" id="labelDescription" for="description"><fmt:message key="register.field.description" /></label>
	<textarea rows="3" id="description" name="description" class="textbox form-control" placeholder="<fmt:message key="register.field.description" />"></textarea>
	<!-- <textarea rows="3" id="description" name="description" data-msg="Please enter a description" data-validationfn="checkDescription()" class="textbox form-control"></textarea> -->
	<div class="error alert vw-alert-danger hidden" for="description"></div>
</div>
<div class="form-group vw-captcha-container">
	<label class="control-label col-xs-5" id="labelCaptcha" for="captcha"><fmt:message key="EnterCaptcha" /></label>
	<div class="col-xs-7 vw-captcha"><img id="captchImg" src="${pageContext.request.contextPath}/getCaptcha.do" /></div>
	<input type="text" id="captcha" name="captcha" class="textbox form-control" data-msg="${Register_code_error}" />
	<div class="error alert vw-alert-danger hidden" for="captcha" id="captchaError">&nbsp;</div>
</div>
<div class="form-group clearfix">
	<button id="registerBtn" class="mainBtn vw-btn vw-btn-primary" name="submit" type="button">
		<span class="vw-btn-text"><fmt:message key="Register" /></span>
		<svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-spin"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg>
	</button>
	<p id="reg_pass" class="pull-left vw-alternate-actions"><a href="index.jsp"><fmt:message key="register.login_link"/></a></p>
</div>

<script nonce="${sessionScope.cspNonce}" >
var Register_fields_mandatory="${Register_fields_mandatory}";
var Register_password_spaces="${Register_password_spaces}";
var Register_Password_error="${Register_Password_error}";
var Register_blank_password_error="${Register_blank_password_error}";
var Register_invalid_email="${Register_invalid_email}";
</script>
